      SUBROUTINE PARUSR(STR,LUN,I1,IO)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    PARUSR
!   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
!
! ABSTRACT: THIS SUBROUTINE INITATES THE PROCESS TO PARSE OUT MNEMONICS
!   (NODES) FROM A USER-SPECIFIED CHARACTER STRING, AND SEPARATES THEM
!   INTO STORE AND CONDITION NODES.  INFORMATION ABOUT THE STRING
!   "PIECES" (I.E., THE MNEMONICS) IS STORED IN ARRAYS IN COMMON BLOCK
!   /USRSTR/.  CONDITION NODES ARE SORTED IN THE ORDER EXPECTED IN THE
!   INTERNAL JUMP/LINK TABLES AND SEVERAL CHECKS ARE PERFORMED ON THE
!   NODES.
!
! PROGRAM HISTORY LOG:
! 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
! 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
!                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
!                           ROUTINE "BORT"; IMPROVED MACHINE
!                           PORTABILITY
! 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
!                           INTERDEPENDENCIES
! 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
!                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
!                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
!                           TERMINATES ABNORMALLY; CHANGED CALL FROM
!                           BORT TO BORT2; RESPONDED TO CHANGE IN
!                           PARUTG (WHICH THIS ROUTINE CALLS) TO NO
!                           LONGER EXPECT AN ALTERNATE RETURN TO A
!                           STATEMENT NUMBER IN THIS ROUTINE WHICH
!                           CALLED BORT (BORT IS NOW CALLED IN PARUTG)
! 2007-01-19  J. ATOR    -- REPLACED CALL TO PARSEQ WITH CALL TO PARSTR
!
! USAGE:    CALL PARUSR (STR, LUN, I1, IO)
!   INPUT ARGUMENT LIST:
!     STR      - CHARACTER*(*): STRING OF BLANK-SEPARATED MNEMONICS
!     LUN      - INTEGER: I/O STREAM INDEX INTO INTERNAL MEMORY ARRAYS
!     I1       - INTEGER: A NUMBER GREATER THAN OR EQUAL TO THE NUMBER
!                OF BLANK-SEPARATED MNEMONICS IN STR
!     IO       - INTEGER: STATUS INDICATOR FOR BUFR FILE ASSOCIATED
!                WITH LUN:
!                       0 = input file
!                       1 = output file
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT2    LSTRPC   PARSTR   PARUTG
!    THIS ROUTINE IS CALLED BY: STRING
!                               Normally not called by any application
!                               programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      COMMON /USRSTR/ NNOD,NCON,NODS(20),NODC(10),IVLS(10),KONS(10)
      COMMON /ACMODE/ IAC

      CHARACTER*(*) STR
      CHARACTER*128 BORT_STR1,BORT_STR2
      CHARACTER*80  UST
      CHARACTER*20  UTG(30)
      LOGICAL       BUMP

      DATA MAXUSR /30/
      DATA MAXNOD /20/
      DATA MAXCON /10/

!----------------------------------------------------------------------
!----------------------------------------------------------------------

      UST  = STR
      IF(LEN(STR).GT.80) GOTO 900

      NCON = 0
      NNOD = 0

!  PARSE OUT STRING PIECES(S) (UTG's or MNEMONICS)
!  -----------------------------------------------

      CALL PARSTR(UST,UTG,MAXUSR,NTOT,' ',.TRUE.)

      DO N=1,NTOT

!  DETERMINE IF THIS UTG IS A CONDITION NODE OR A STORE NODE
!  ---------------------------------------------------------

      CALL PARUTG(LUN,IO,UTG(N),NOD,KON,VAL)
      IF(KON.NE.0) THEN
!  .... it is a condition node
         NCON = NCON+1
         IF(NCON.GT.MAXCON) GOTO 901
         NODC(NCON) = NOD
         KONS(NCON) = KON
         IVLS(NCON) = NINT(VAL)
      ELSE
!  .... it is a store node
         NNOD = NNOD+1
         IF(NNOD.GT.MAXNOD) GOTO 902
         NODS(NNOD) = NOD
      ENDIF
      ENDDO

!  SORT CONDITION NODES IN JUMP/LINK TABLE ORDER
!  ---------------------------------------------

      DO I=1,NCON
      DO J=I+1,NCON
      IF(NODC(I).GT.NODC(J)) THEN
         NOD     = NODC(I)
         NODC(I) = NODC(J)
         NODC(J) = NOD

         KON     = KONS(I)
         KONS(I) = KONS(J)
         KONS(J) = KON

         VAL     = IVLS(I)
         IVLS(I) = IVLS(J)
         IVLS(J) = VAL
      ENDIF
      ENDDO
      ENDDO

!  CHECK ON SPECIAL RULES FOR CONDITIONAL NODES THAT ARE BUMP NODES
!  ----------------------------------------------------------------

      BUMP = .FALSE.

      DO N=1,NCON
      IF(KONS(N).EQ.5) THEN
         IF(IO.EQ.0)   GOTO 903
         IF(N.NE.NCON) GOTO 904
         BUMP = .TRUE.
      ENDIF
      ENDDO

!  CHECK STORE NODE COUNT AND ALIGNMENT
!  ------------------------------------

      IF(.NOT.BUMP .AND. NNOD.EQ.0) GOTO 905
      IF(NNOD.GT.I1)                GOTO 906

      IRPC = -1
      DO I=1,NNOD
      IF(NODS(I).GT.0) THEN
         IF(IRPC.LT.0) IRPC = LSTRPC(NODS(I),LUN)
         IF(IRPC.NE.LSTRPC(NODS(I),LUN).AND.IAC.EQ.0) GOTO 907
      ENDIF
      ENDDO

!  EXITS
!  -----

      RETURN
900   WRITE(BORT_STR1,'("BUFRLIB: PARUSR - INPUT STRING (",A,") HAS ")') &
       STR
      WRITE(BORT_STR2,'(18X,"LENGTH (",I4,"), > LIMIT OF 80 CHAR.")') &
       LEN(STR)
      CALL BORT2(BORT_STR1,BORT_STR2)
901   WRITE(BORT_STR1,'("BUFRLIB: PARUSR - THE NUMBER OF CONDITION '// &
       'NODES IN INPUT STRING")')
      WRITE(BORT_STR2,'(18X,A,") EXCEEDS THE MAXIMUM (",I3,")")') &
       STR,MAXCON
      CALL BORT2(BORT_STR1,BORT_STR2)
902   WRITE(BORT_STR1,'("BUFRLIB: PARUSR - THE NUMBER OF STORE NODES '// &
       'IN INPUT STRING")')
       WRITE(BORT_STR2,'(18X,A,") EXCEEDS THE MAXIMUM (",I3,")")') &
       STR,MAXNOD
      CALL BORT2(BORT_STR1,BORT_STR2)
903   WRITE(BORT_STR1,'("BUFRLIB: PARUSR - BUMP NODE (^ IN INPUT '// &
       'STRING ",A)') STR
      WRITE(BORT_STR2,'(18X,"IS SPECIFIED FOR A BUFR FILE OPEN FOR '// &
       'INPUT, THE BUFR FILE MUST BE OPEN FOR OUTPUT")')
      CALL BORT2(BORT_STR1,BORT_STR2)
904   WRITE(BORT_STR1,'("BUFRLIB: PARUSR - INPUT STRING (",A,") '// &
       'CONTAINS")') STR
      WRITE(BORT_STR2,'(18X,"CONDITIONAL NODES IN ADDITION TO BUMP '// &
       'NODE - THE BUMP MUST BE ON THE INNER NODE")')
      CALL BORT2(BORT_STR1,BORT_STR2)
905   WRITE(BORT_STR1,'("BUFRLIB: PARUSR - INPUT STRING (",A,") HAS")') &
       STR
      WRITE(BORT_STR2,'(18X,"NO STORE NODES")')
      CALL BORT2(BORT_STR1,BORT_STR2)
906   WRITE(BORT_STR1,'("BUFRLIB: PARUSR - INPUT STRING (",A,")")') STR
      WRITE(BORT_STR2,'(18X,"HAS",I5," STORE NODES (MNEMONICS) - THE '// &
       'LIMIT {THIRD (INPUT) ARGUMENT} IS",I5)') NNOD,I1
      CALL BORT2(BORT_STR1,BORT_STR2)
907   WRITE(BORT_STR1,'("BUFRLIB: PARUSR - INPUT STRING (",A,") '// &
       'CONTAINS")') STR
      WRITE(BORT_STR2,'(18X,"STORE NODES (MNEMONICS) THAT ARE IN MORE'// &
       ' THAN ONE REPLICATION GROUP")')
      CALL BORT2(BORT_STR1,BORT_STR2)
      END SUBROUTINE PARUSR
