      SUBROUTINE PKVS1(IL,IV)

!$$$  SUBPROGRAM DOCUMENTATION BLOCK
!
! SUBPROGRAM:    PKVS1
!   PRGMMR: ATOR            ORG: NP12       DATE: 2004-08-18
!
! ABSTRACT: THIS SUBROUTINE IS USED TO SPECIFY A VALUE IV TO BE WRITTEN
!   INTO BYTE IL OF SECTION 1 (OR INTO BYTE 8 OF SECTION 0, IF IL = 0)
!   FOR ALL BUFR MESSAGES THAT WILL BE OUTPUT BY FUTURE CALLS TO ANY
!   OF THE BUFR ARCHIVE LIBRARY SUBROUTINES WHICH CREATE SUCH MESSAGES
!   (E.G. WRITCP, WRITSB, COPYMG, WRITSA, ETC.).  THIS SUBROUTINE CAN  
!   BE CALLED AT ANY TIME, INCLUDING BEFORE THE FIRST CALL TO BUFR
!   ARCHIVE LIBRARY SUBROUTINE OPENBF IF IT IS DESIRED FOR THE NEW VALUE
!   TO ALSO BE INCLUDED IN ANY DX DICTIONARY TABLE MESSAGES THAT WILL BE
!   OUTPUT BY BUFR ARCHIVE LIBRARY SUBROUTINE WRITDX.  IF MULTIPLE
!   VALUES ARE DESIRED TO BE CHANGED IN SECTION 1 (OR 0) OF FUTURE
!   OUTPUT MESSAGES, THEN EACH SUCH VALUE (AND CORRESPONDING LOCATION)
!   SHOULD BE SPECIFIED USING A SEPARATE CALL TO THIS SUBROUTINE.
!   IN ANY CASE, EACH CALL TO THIS SUBROUTINE WITH A PARTICULAR IL VALUE
!   OVERRIDES ANY PREVIOUS CALL(S) WITH THAT SAME IL VALUE (OR, IN THE
!   CASE OF THE FIRST CALL WITH A PARTICULAR IL VALUE, IT OVERRIDES THE
!   DEFAULT VALUE FOR THE CORRESPONDING BYTE LOCATION!).  NOTE THAT THIS
!   SUBROUTINE IS CONSIDERED OBSOLETE AND MAY BE REMOVED FROM THE BUFR
!   ARCHIVE LIBRARY IN A FUTURE VERSION; USERS SHOULD INSTEAD MIGRATE TO
!   THE USE OF BUFR ARCHIVE LIBRARY SUBROUTINE PKVS01.
!
! PROGRAM HISTORY LOG:
! 2004-08-18  J. ATOR    -- ORIGINAL AUTHOR
! 2005-11-29  J. ATOR    -- ADDED SPECIAL IL=-99 INITIALIZATION OPTION
!			    FOR INTERNAL USE WITHIN BUFRLIB; MARKED AS
!                           OBSOLETE AND ADDED PRINT NOTIFICATION
!
! USAGE:    CALL PKVS1(IL,IV)
!   INPUT ARGUMENT LIST:
!     IL       - INTEGER: BYTE TO OVERWRITE WITHIN SECTION 1 OF ALL
!                FUTURE OUTPUT BUFR MESSAGES:
!                       0 = OVERWRITE BYTE 8 OF SECTION 0
!		      -99 = SPECIAL FLAG TO FORCE INITIALIZATION OF
!			    NCOD=0 WITHIN COMMON /SECT01/; IN THIS
!			    CASE THE INPUT VALUE IV IS IGNORED
!			    (NOTE: AN APPLICATION PROGRAM SHOULD NEVER
!			    ITSELF NEED TO DO THIS!)
!     IV       - INTEGER: NEW VALUE FOR BYTE POINTED TO BY IL
!
! REMARKS:
!    THIS ROUTINE CALLS:        BORT
!    THIS ROUTINE IS CALLED BY: BFRINI
!                               Also called by application programs.
!
! ATTRIBUTES:
!   LANGUAGE: FORTRAN 77
!   MACHINE:  PORTABLE TO ALL PLATFORMS
!
!$$$

      PARAMETER (MXCOD=15)

      COMMON /SECT01/ NCOD,ILCOD(MXCOD),IVCOD(MXCOD)

      COMMON /QUIET / IPRT

      CHARACTER*128 BORT_STR

      DATA IFIRST/0/

      SAVE IFIRST

!-----------------------------------------------------------------------
!-----------------------------------------------------------------------

      IF(IFIRST.EQ.0) THEN

!	NOTE THAT WE ARE INITIALIZING NCOD=0 HERE (RATHER THAN WITHIN
!	SUBROUTINE BFRINI) IN ORDER TO ALLOW FOR THE POSSIBILITY THAT A
!	USER MAY CALL SUBROUTINE PKVS1 PRIOR TO CALLING SUBROUTINE
!	OPENBF (WHICH ITSELF CALLS BFRINI!).  HOWEVER, IF THE USER DOES
!	NOT DO THIS, THEN THE "CALL PKVS1(-99,-99)" STATEMENT WITHIN
!	BFRINI WILL ENSURE THAT THE REQUIRED INITIALIZATION OF NCOD=0
!	STILL GETS DONE; OTHERWISE, WE WOULD RUN THE RISK OF NCOD BEING
!	UNINITIALIZED WHEN REFERENCED LATER ON WITHIN SUBROUTINE MSGWRT!

        NCOD = 0
        IFIRST = 1

         IF( (IPRT.GE.0) .AND. (IL.NE.-99) ) THEN
      PRINT*
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT 101
101   FORMAT(' BUFRLIB: PKVS1 - THIS SUBROUTINE IS NOW OBSOLETE; ', &
       'USE SUBROUTINE PKVS01 INSTEAD')
      PRINT*,'+++++++++++++++++BUFR ARCHIVE LIBRARY++++++++++++++++++++'
      PRINT*
         ENDIF

      ENDIF

      IF (IL.EQ.-99) THEN
        RETURN
      ENDIF

!     IF AN IV HAS ALREADY BEEN ASSIGNED FOR THIS PARTICULAR IL, THEN
!     OVERWRITE THAT ENTRY IN COMMON /SECT01/ USING THE NEW IV VALUE.

      IF(NCOD.GT.0) THEN
        DO I=1,NCOD
          IF(IL.EQ.ILCOD(I)) THEN
            IVCOD(I) = IV
            RETURN
          ENDIF
        ENDDO
      ENDIF

!     OTHERWISE, USE THE NEXT AVAILABLE UNUSED ENTRY IN COMMON /SECT01/.

      IF(NCOD.GE.MXCOD) GOTO 900

      NCOD = NCOD + 1
      ILCOD(NCOD) = IL
      IVCOD(NCOD) = IV      

!  EXITS
!  -----

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: PKVS1 - CANNOT OVERWRITE MORE THAN '// &
       '",I2," DIFFERENT BYTES WITHIN SECTION 1")') MXCOD
      CALL BORT(BORT_STR)
      END SUBROUTINE PKVS1
