PROGRAM ipxwrf

!-------------------------------------------------------------------------------
! Name:     Intermediate Processor for Pleim-Xiu LSM for WRF-ARW
! Purpose:  Persists soil moisture and/or soil temperature for reinitialized
!           WRF-ARW simulations.
! Revised:  10 May 2007  Original version.  (T. Otte)
!           24 Aug 2007  Added option to replace deep soil temperature with
!                        2-m temperature averaged from analyses over 
!                        user-defined period.  (T. Otte)
!-------------------------------------------------------------------------------

  USE files

  IMPLICIT NONE

!-------------------------------------------------------------------------------
! Read user options from namelist.
!-------------------------------------------------------------------------------

  CALL readnml

!-------------------------------------------------------------------------------
! Verify that the input files are for the same geographical domain.
!-------------------------------------------------------------------------------

  IF ( ( do_msoil ) .OR. ( do_tsoil ) ) THEN
    CALL ckwrfhdrs (file_wrfout_last, file_wrfin_next)
  ENDIF

  IF ( do_tsoildeep_from2m ) THEN
    CALL ckwrfhdrs (file_wrffdda_next, file_wrfin_next)
  ENDIF

!-------------------------------------------------------------------------------
! Replace soil moisture and/or soil temperature in WRF input file for the next
! simulation with values from WRF output from previous simulation and/or from
! average values from analyses.
!-------------------------------------------------------------------------------

  IF ( ( do_msoil ) .OR. ( do_tsoil ) ) THEN
    CALL wrfswapdata
  ENDIF

  IF ( do_tsoildeep_from2m ) THEN
    CALL wrfaverage
  ENDIF

  WRITE (6,'(//, a)') 'NORMAL TERMINATION'

END PROGRAM ipxwrf
