!
!##################################################################
!##################################################################
!######                                                      ######
!######           SUBROUTINE check_files_dimensions          ######
!######                                                      ######
!######                     Developed by                     ######
!######     Center for Analysis and Prediction of Storms     ######
!######                University of Oklahoma                ######
!######                                                      ######
!##################################################################
!##################################################################
!
SUBROUTINE check_files_dimensions(MAXWRFFIL,grid_id,io_form,            &
     nprocs,nproc_x,nproc_y,abstimes,abstimei,abstimee,      &
     dir_extd,extdname,nextdfil,                             &
     ids,ide,idss,idse,jds,jde,jdss,jdse,istatus)
  !
  !-----------------------------------------------------------------------
  !
  ! PURPOSE: Check the existence of WRF files to be read and return the 
  !          valid file number, file names and the domain grid indices.
  !          
  !-----------------------------------------------------------------------
  !
  !  AUTHOR:
  !  Yunheng Wang (04/26/2007)
  !
  !  MODIFICATION HISTORY:
  !
  !-----------------------------------------------------------------------

  IMPLICIT NONE

  INTEGER, INTENT(IN)    :: MAXWRFFIL
  INTEGER, INTENT(IN)    :: grid_id
  INTEGER, INTENT(IN)    :: io_form
  INTEGER, INTENT(IN)    :: abstimes, abstimei, abstimee
  INTEGER, INTENT(IN)    :: nproc_x,nproc_y
  INTEGER, INTENT(IN)    :: nprocs(nproc_x*nproc_y)
  CHARACTER(LEN=256), INTENT(IN)  :: dir_extd
  CHARACTER(LEN=256), INTENT(OUT) :: extdname(MAXWRFFIL)
  INTEGER,            INTENT(OUT) :: nextdfil
  INTEGER,            INTENT(OUT) :: ids, ide, jds, jde
  INTEGER,            INTENT(OUT) :: idss,idse,jdss,jdse
  INTEGER,            INTENT(OUT) :: istatus

  !-----------------------------------------------------------------------
  !
  ! Misc. local variables
  !
  !-----------------------------------------------------------------------

  INTEGER :: year, month, day, hour, minute, second
  INTEGER :: ifile, npx, npy, n
  INTEGER :: ips, ipe, jps, jpe, ipss, ipse, jpss, jpse
  INTEGER :: ipesv, jpssv, jpesv
  INTEGER :: nx

  CHARACTER(LEN=256) :: tmpstr

  LOGICAL :: fexist
  LOGICAL :: dset = .FALSE.
  LOGICAL :: in_a_row = .FALSE.

  !@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  !
  ! Begining of executable code ....
  !
  !@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

  ids  = 99999999
  ide  = 0
  idss = 99999999
  idse = 0

  jds  = 99999999
  jde  = 0
  jdss = 99999999
  jdse = 0

  nextdfil    = 0
  extdname(:) = ' ' 
  istatus     = 0

  WRITE(6,'(1x,a,/,1x,a,/)')                             &
       '============================','WRF files to be read are:'

  ifile = abstimes
  IFILE_LOOP : DO WHILE (ifile <= abstimee)

     CALL abss2ctim(ifile,year,month,day,hour,minute,second)

     nextdfil = nextdfil + 1
     WRITE(extdname(nextdfil),'(a,a,I2.2,a,I4.4,5(a,I2.2))')             &
          &       TRIM(dir_extd),'wrfout_d',grid_id,'_',                 &
          &       year,'-',month,'-',day,'_',hour,':',minute,':',second

     ipesv = 0
     jpssv = 0
     jpesv = 0

     n = 0
     YLOOP : DO npy = 1,nproc_y
        in_a_row = .FALSE.
        XLOOP : DO npx = 1,nproc_x

           IF (npx > 1) in_a_row = .TRUE.

           n = n+1
           WRITE(tmpstr,'(a,a,I4.4)') TRIM(extdname(nextdfil)),'_',nprocs(n)

           INQUIRE(FILE=TRIM(tmpstr), EXIST = fexist )

           IF(.NOT. fexist) THEN
              WRITE(6,'(1x,a)') 'ERROR: The WRF file ',                       &
                   TRIM(tmpstr),' does not exist.'
              STOP
           ENDIF

           CALL get_wrf_patch_indices(TRIM(tmpstr),io_form,                &
                ips,ipe,ipss,ipse,jps,jpe,jpss,jpse,nx,istatus)
           IF (istatus /= 0) EXIT

           IF (.NOT. dset) THEN
              IF (npx == 1) THEN
                 ids  = ips
                 idss = ipss
              END IF

              IF (npx == nproc_x) THEN
                 ide  = ipe
                 idse = ipse
              END IF

              IF (npy == 1) THEN
                 jds  = jps
                 jdss = jpss
              END IF

              IF (npy == nproc_y) THEN
                 jde  = jpe
                 jdse = jpse
              END IF

           END IF

           IF ( n > 1) THEN
              IF (in_a_row) THEN
                 IF (jps /= jpssv .OR. jpe /= jpesv .OR. ips /= ipesv+1) THEN
                    WRITE(6,'(/,1x,a,I4,2a,/,8x,2(a,I2),a,/,8x,a,/,8x,a,/)')  &
                         'ERROR: Patch ',n,' for file ',TRIM(tmpstr),            &
                         'at relative patch (',npx,',',npy,                      &
                         ') is not aligned in a row with its former patch.',     &
                         'Please check parameter nproc_xin. Either it was specified with a wrong number', &
                         'or the program has made a bad guess about it.'
                    STOP
                 END IF
              ELSE
                 IF (jps /= jpesv+1) THEN
                    WRITE(6,'(/,1x,a,I4,2a,/,8x,2(a,I2),a,/,8x,a,/,8x,a,/)')  &
                         'ERROR: Patch ',n,' for file ',TRIM(tmpstr),            &
                         'at relative patch (',npx,',',npy,                      &
                         ') is not aligned in column with its former patch.',    &
                         'Please check parameter nproc_xin. Either it was specified with a wrong number', &
                         'or the program has made a bad guess about it.'
                    STOP
                 ENDIF
              ENDIF
           ENDIF

           ipesv = ipe
           jpssv = jps
           jpesv = jpe

           WRITE(6,'(3x,a,I2.2,a,I4,a,5x,a, 5x)')                            &
                'WRF file ',nextdfil,': patch - ',n,' =', TRIM(tmpstr)

        ENDDO XLOOP
     ENDDO YLOOP

     ifile = ifile + abstimei
     dset = .TRUE.

  ENDDO IFILE_LOOP


  !-----------------------------------------------------------------------
  !
  ! Validate nextdfil before return
  !
  !-----------------------------------------------------------------------

  IF(nextdfil < 1) THEN
     WRITE(6,'(a)') 'No input WRF file was valid. Please check the input file.'
     istatus = -3
     RETURN
  END IF

  IF (ide < ids .OR. jde < jds) THEN
     WRITE(6,'(1x,2(a,I4),/36x,2(a,I4),a)')                              &
          'ERROR: Domain indices are invalid: ids = ',ids,', ide = ',ide,     &
          '; jds = ',jds,', jde = ',jde,'.'
     istatus = -3
     RETURN
  END IF

  print*, 'nextdfil = ', nextdfil
  print*, 'ids, ide, jds, jde = ', ids, ide, jds, jde
  print*, 'idss, idse, jdss, jdse = ', idss, idse, jdss, jdse

END SUBROUTINE check_files_dimensions
