!
!##################################################################
!##################################################################
!######                                                      ######
!######       SUBROUTINE get_wrf_patch_indices               ######
!######                                                      ######
!######                     Developed by                     ######
!######     Center for Analysis and Prediction of Storms     ######
!######                University of Oklahoma                ######
!######                                                      ######
!##################################################################
!##################################################################
!
SUBROUTINE get_wrf_patch_indices(filename,io_form,ips,ipe,ipss,ipse,    &
                                 jps,jpe,jpss,jpse,nx,istatus)

!-----------------------------------------------------------------------
!
!  PURPOSE:
!    Get the size of data patch stored in the WRF data file
!
!-----------------------------------------------------------------------
!
!  AUTHOR:
!  Yunheng Wang (04/26/2007)
!
!  MODIFICATION HISTORY:
!
!-----------------------------------------------------------------------
  use netcdf
 
  IMPLICIT NONE
 
  CHARACTER(LEN=*), INTENT(IN)  :: filename
  INTEGER,          INTENT(IN)  :: io_form
  INTEGER,          INTENT(OUT) :: ips, ipe, jps, jpe
  INTEGER,          INTENT(OUT) :: ipss,ipse,jpss,jpse
  INTEGER,          INTENT(OUT) :: nx
  INTEGER,          INTENT(OUT) :: istatus

!------------------------------------------------------------------
!
!  Misc. local variables
!
!------------------------------------------------------------------
 
  INTEGER           :: ncid
  CHARACTER(LEN=80) :: errmsg

!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
!
!  Beginning of executable code...
!
!@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

  istatus = 0
  IF (io_form == 7) THEN

    istatus = NF90_OPEN(TRIM(filename),NF90_NOWRITE,ncid)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'WEST-EAST_PATCH_START_STAG',ips)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'WEST-EAST_PATCH_END_STAG',ipe)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'WEST-EAST_PATCH_START_UNSTAG',ipss)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'WEST-EAST_PATCH_END_UNSTAG',ipse)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'SOUTH-NORTH_PATCH_START_STAG',jps)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'SOUTH-NORTH_PATCH_END_STAG',jpe)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'SOUTH-NORTH_PATCH_START_UNSTAG',jpss)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'SOUTH-NORTH_PATCH_END_UNSTAG',jpse)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_GET_ATT(ncid,NF90_GLOBAL,'WEST-EAST_GRID_DIMENSION',nx)
    IF(istatus /= NF90_NOERR)  GO TO 999

    istatus = NF90_CLOSE(ncid)
    IF (istatus /= NF90_NOERR) GO TO 999
  ELSE
    istatus   = -1
    ips = 0
    ipe = 0
    ipse= 0
    jps = 0
    jpe = 0
    jpse= 0
    WRITE(6,'(1x,a,/)')       &
      'WARNING: Only support netCDF file at present for patch indices.'
  END IF
 
  RETURN

  999 CONTINUE
  errmsg = NF90_STRERROR(istatus)
  WRITE(6,'(1x,2a)') 'NetCDF error: ',errmsg
  STOP

END SUBROUTINE get_wrf_patch_indices
