







module BalanceCheckMod










  use shr_kind_mod, only: r8 => shr_kind_r8




  implicit none
  save


  public :: BeginWaterBalance  
  public :: BalanceCheck       







contains







  subroutine BeginWaterBalance(lbc, ubc, lbp, ubp, &
             num_nolakec, filter_nolakec, num_lakec, filter_lakec, &

             ilx, jlx)





    use shr_kind_mod , only : r8 => shr_kind_r8
    use clmtype
    use clm_varpar   , only : nlevsoi
    use subgridAveMod, only : p2c



    implicit none
    integer, intent(in) :: lbc, ubc                    
    integer, intent(in) :: lbp, ubp                    
    integer, intent(in) :: ilx, jlx
    integer, intent(in) :: num_nolakec                 
    integer, intent(in) :: filter_nolakec(ubc-lbc+1)   
    integer, intent(in) :: num_lakec                   
    integer, intent(in) :: filter_lakec(ubc-lbc+1)     













    real(r8), pointer :: h2osno(:)             
    real(r8), pointer :: h2osoi_ice(:,:)       
    real(r8), pointer :: h2osoi_liq(:,:)       
    real(r8), pointer :: h2ocan_pft(:)         
    real(r8), pointer :: wa(:)                 




    real(r8), pointer :: h2ocan_col(:)         
    real(r8), pointer :: begwb(:)              



    integer :: c, p, f, j, fc            


    

    h2osno             => clm3%g%l%c%cws%h2osno
    h2osoi_ice         => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq         => clm3%g%l%c%cws%h2osoi_liq
    begwb              => clm3%g%l%c%cwbal%begwb
    h2ocan_col         => clm3%g%l%c%cws%pws_a%h2ocan
    wa                 => clm3%g%l%c%cws%wa

    

    h2ocan_pft         => clm3%g%l%c%p%pws%h2ocan

    
    
    call p2c(num_nolakec, filter_nolakec, h2ocan_pft, h2ocan_col)



    do f = 1, num_nolakec
       c = filter_nolakec(f)
       begwb(c) = h2ocan_col(c) + h2osno(c) + wa(c)
    end do
    do j = 1, nlevsoi


      do f = 1, num_nolakec
         c = filter_nolakec(f)
         begwb(c) = begwb(c) + h2osoi_ice(c,j) + h2osoi_liq(c,j)
      end do
    end do



    do f = 1, num_lakec
       c = filter_lakec(f)
       begwb(c) = h2osno(c)
    end do

  end subroutine BeginWaterBalance










  subroutine BalanceCheck(lbp, ubp, lbc, ubc ,ilx ,jlx)
















    use clmtype
    
    use subgridAveMod

    use globals, only: dtime, nstep




    implicit none
    integer :: lbp, ubp 
    integer :: lbc, ubc 

    integer :: ilx,jlx















    integer , pointer :: pgridcell(:)       
    real(r8), pointer :: pwtgcell(:)        
    integer , pointer :: cgridcell(:)       
    real(r8), pointer :: forc_rain(:)       
    real(r8), pointer :: forc_snow(:)       
    real(r8), pointer :: forc_lwrad(:)      
    real(r8), pointer :: endwb(:)           
    real(r8), pointer :: begwb(:)           
    real(r8), pointer :: fsa(:)             
    real(r8), pointer :: fsr(:)             
    real(r8), pointer :: eflx_lwrad_out(:)  
    real(r8), pointer :: eflx_lwrad_net(:)  
    real(r8), pointer :: sabv(:)            
    real(r8), pointer :: sabg(:)            
    real(r8), pointer :: eflx_sh_tot(:)     
    real(r8), pointer :: eflx_lh_tot(:)     
    real(r8), pointer :: eflx_soil_grnd(:)  
    real(r8), pointer :: qflx_evap_tot(:)   
    real(r8), pointer :: qflx_surf(:)       
    real(r8), pointer :: qflx_qrgwl(:)      
    real(r8), pointer :: qflx_drain(:)      
    real(r8), pointer :: forc_solad(:,:)    
    real(r8), pointer :: forc_solai(:,:)    



    real(r8), pointer :: errh2o(:)          
    real(r8), pointer :: errsol(:)          
    real(r8), pointer :: errlon(:)          
    real(r8), pointer :: errseb(:)          
    real(r8), pointer :: errsoi_col(:)      




    integer  :: p,c,g                      




    logical  :: found                      
    integer  :: index                      


    

    forc_rain         => clm_a2l%forc_rain
    forc_snow         => clm_a2l%forc_snow
    forc_lwrad        => clm_a2l%forc_lwrad
    forc_solad        => clm_a2l%forc_solad
    forc_solai        => clm_a2l%forc_solai

    

    cgridcell         => clm3%g%l%c%gridcell
    endwb             => clm3%g%l%c%cwbal%endwb
    begwb             => clm3%g%l%c%cwbal%begwb
    qflx_surf         => clm3%g%l%c%cwf%qflx_surf
    qflx_qrgwl        => clm3%g%l%c%cwf%qflx_qrgwl
    qflx_drain        => clm3%g%l%c%cwf%qflx_drain
    qflx_evap_tot     => clm3%g%l%c%cwf%pwf_a%qflx_evap_tot
    errh2o            => clm3%g%l%c%cwbal%errh2o
    errsoi_col        => clm3%g%l%c%cebal%errsoi

    

    pgridcell         => clm3%g%l%c%p%gridcell
    pwtgcell          => clm3%g%l%c%p%wtgcell
    fsa               => clm3%g%l%c%p%pef%fsa
    fsr               => clm3%g%l%c%p%pef%fsr
    eflx_lwrad_out    => clm3%g%l%c%p%pef%eflx_lwrad_out
    eflx_lwrad_net    => clm3%g%l%c%p%pef%eflx_lwrad_net
    sabv              => clm3%g%l%c%p%pef%sabv
    sabg              => clm3%g%l%c%p%pef%sabg
    eflx_sh_tot       => clm3%g%l%c%p%pef%eflx_sh_tot
    eflx_lh_tot       => clm3%g%l%c%p%pef%eflx_lh_tot
    eflx_soil_grnd    => clm3%g%l%c%p%pef%eflx_soil_grnd
    errsol            => clm3%g%l%c%p%pebal%errsol
    errseb            => clm3%g%l%c%p%pebal%errseb
    errlon            => clm3%g%l%c%p%pebal%errlon

    




    



    do c = lbc, ubc
       g = cgridcell(c)
       
       errh2o(c) = endwb(c) - begwb(c) &
            - (forc_rain(g) + forc_snow(g) - qflx_evap_tot(c) - qflx_surf(c) &
            - qflx_qrgwl(c) - qflx_drain(c)) * dtime

    end do

    found = .false.
    do c = lbc, ubc

       if (abs(errh2o(c)) > 1e-2_r8) then
          found = .true.
          index = c
       end if
    end do
    if ( found ) then
       write(6,*)'WARNING:  water balance error ',&
            ' nstep = ',nstep,' index= ',index,' errh2o= ',errh2o(index)
       if (abs(errh2o(index)) > .10_r8) then
       write(6,200)'Warning: water balance error',nstep,index,errh2o(index)
       write(6,*)'This sometimes happens when CLM_WRF is initialized over ice, but'
       write(6,*)'if this occurs after the first timestep, there may be a problem.'


       end if
    end if

    



    do p = lbp, ubp
       if (pwtgcell(p)>0._r8) then
          g = pgridcell(p)

          
          errsol(p) = fsa(p) + fsr(p) - (forc_solad(g,1) + forc_solad(g,2) &
                      + forc_solai(g,1) + forc_solai(g,2))

          
          errlon(p) = eflx_lwrad_out(p) - eflx_lwrad_net(p) - forc_lwrad(g)
          
          
          errseb(p) = sabv(p) + sabg(p) + forc_lwrad(g) - eflx_lwrad_out(p) &
                      - eflx_sh_tot(p) - eflx_lh_tot(p) - eflx_soil_grnd(p)
       end if
    end do

    

    found = .false.
    do p = lbp, ubp
       if (pwtgcell(p)>0._r8) then
          if (abs(errsol(p)) > .10_r8 ) then
             found = .true.
             index = p
          end if
       end if
    end do
    if ( found ) then
       write(6,100)'solar radiation balance error',nstep,index,errsol(index)
       write(6,*)'clm model is stopping'
       call endrun()
    end if

    

    found = .false.
    do p = lbp, ubp
       if (pwtgcell(p)>0._r8) then
          if (abs(errlon(p)) > .10_r8 ) then
             found = .true.
             index = p
          end if
       end if
    end do
    if ( found ) then
       write(6,100)'longwave enery balance error',nstep,index,errlon(index)
       write(6,*)'clm model is stopping'
       call endrun()
    end if

    

    found = .false.
    do p = lbp, ubp
       if (pwtgcell(p)>0._r8) then
          if (abs(errseb(p)) > .10_r8 ) then
             found = .true.
             index = p
          end if
       end if
    end do
    if ( found ) then
       write(6,100)'surface flux energy balance error',nstep,index,errseb(index)
       write(6,*)'clm model is stopping'
       call endrun()
    end if

    

    found = .false.
    do c = lbc, ubc

       if (abs(errsoi_col(c)) > 1.0e-2_r8 ) then
          found = .true.
          index = c
       end if
    end do
    if ( found ) then
       write(6,100)'soil balance error',nstep,index,errsoi_col(index)
       if (abs(errsoi_col(index)) > .10_r8) then
          write(6,*)'clm model is stopping'
          call endrun()
       end if
    end if

100 format (1x,a14,' nstep =',i10,' point =',i6,' imbalance =',f8.2,' W/m2')
200 format (1x,a14,' nstep =',i10,' point =',i6,' imbalance =',f8.2,' mm')

  end subroutine BalanceCheck

end module BalanceCheckMod
