







module BareGroundFluxesMod











   use shr_kind_mod, only: r8 => shr_kind_r8


   implicit none
   save


   public :: BareGroundFluxes   







contains







  subroutine BareGroundFluxes(lbp, ubp, num_nolakep, filter_nolakep)






    use clmtype
    
    use clm_varpar         , only : nlevsoi
    use clm_varcon         , only : cpair, vkc, grav, denice, denh2o, rgas


    use FrictionVelocityMod, only : FrictionVelocity, MoninObukIni


    implicit none
    integer, intent(in) :: lbp, ubp                     
    integer, intent(in) :: num_nolakep                  
    integer, intent(in) :: filter_nolakep(ubp-lbp+1)    





















    integer , pointer :: pcolumn(:)        
    integer , pointer :: pgridcell(:)      
    integer , pointer :: frac_veg_nosno(:) 
    real(r8), pointer :: t_grnd(:)         
    real(r8), pointer :: thm(:)            
    real(r8), pointer :: qg(:)             
    real(r8), pointer :: thv(:)            
    real(r8), pointer :: dqgdT(:)          
    real(r8), pointer :: htvp(:)           
    real(r8), pointer :: beta(:)           
    real(r8), pointer :: zii(:)            
    real(r8), pointer :: forc_u(:)         
    real(r8), pointer :: forc_v(:)         
    real(r8), pointer :: forc_t(:)         
    real(r8), pointer :: forc_th(:)        
    real(r8), pointer :: forc_q(:)         
    real(r8), pointer :: forc_rho(:)       
    real(r8), pointer :: forc_pbot(:)      
    real(r8), pointer :: forc_hgt_u(:)     
    real(r8), pointer :: psnsun(:)         
    real(r8), pointer :: psnsha(:)         
    real(r8), pointer :: z0mg_col(:)       
    real(r8), pointer :: h2osoi_ice(:,:)   
    real(r8), pointer :: h2osoi_liq(:,:)   
    real(r8), pointer :: dz(:,:)           
    real(r8), pointer :: watsat(:,:)       
    real(r8), pointer :: frac_sno(:)       



    real(r8), pointer :: z0hg_col(:)       
    real(r8), pointer :: z0qg_col(:)       



    real(r8), pointer :: dlrad(:)         
    real(r8), pointer :: ulrad(:)         
    real(r8), pointer :: cgrnds(:)        
    real(r8), pointer :: cgrndl(:)        
    real(r8), pointer :: cgrnd(:)         
    real(r8), pointer :: taux(:)          
    real(r8), pointer :: tauy(:)          
    real(r8), pointer :: eflx_sh_grnd(:)  
    real(r8), pointer :: eflx_sh_tot(:)   
    real(r8), pointer :: qflx_evap_soi(:) 
    real(r8), pointer :: qflx_evap_tot(:) 
    real(r8), pointer :: t_ref2m(:)       
    real(r8), pointer :: q_ref2m(:)       
    real(r8), pointer :: t_veg(:)         
    real(r8), pointer :: btran(:)         
    real(r8), pointer :: rssun(:)         
    real(r8), pointer :: rssha(:)         
    real(r8), pointer :: ram1(:)          
    real(r8), pointer :: fpsn(:)          
    real(r8), pointer :: rootr(:,:)       
    real(r8), pointer :: rresis(:,:)      





    integer, parameter  :: niters = 3  
    integer  :: p,c,g,f,j              
    integer  :: filterp(ubp-lbp+1)     
    integer  :: fn                     
    integer  :: fp                     
    integer  :: iter                   
    real(r8) :: zldis(lbp:ubp)         
    real(r8) :: displa(lbp:ubp)        
    real(r8) :: zeta                   
    real(r8) :: wc                     
    real(r8) :: dth(lbp:ubp)           
    real(r8) :: dthv                   
    real(r8) :: dqh(lbp:ubp)           
    real(r8) :: obu(lbp:ubp)           
    real(r8) :: ur(lbp:ubp)            
    real(r8) :: um(lbp:ubp)            
    real(r8) :: temp1(lbp:ubp)         
    real(r8) :: temp12m(lbp:ubp)       
    real(r8) :: temp2(lbp:ubp)         
    real(r8) :: temp22m(lbp:ubp)       
    real(r8) :: ustar(lbp:ubp)         
    real(r8) :: tstar                  
    real(r8) :: qstar                  
    real(r8) :: thvstar                
    real(r8) :: cf                     
    real(r8) :: ram                    
    real(r8) :: rah                    
    real(r8) :: raw                    
    real(r8) :: raih                   
    real(r8) :: raiw                   
    real(r8) :: fm(lbp:ubp)            
    real(r8) :: z0mg_pft(lbp:ubp)
    real(r8) :: z0hg_pft(lbp:ubp)
    real(r8) :: z0qg_pft(lbp:ubp)
    real(r8) :: www                    
    real(r8) :: rsoil                  


    

    forc_th    => clm_a2l%forc_th
    forc_hgt_u => clm_a2l%forc_hgt_u
    forc_pbot  => clm_a2l%forc_pbot
    forc_t     => clm_a2l%forc_t
    forc_u     => clm_a2l%forc_u
    forc_v     => clm_a2l%forc_v
    forc_rho   => clm_a2l%forc_rho
    forc_q     => clm_a2l%forc_q

    

    pcolumn => clm3%g%l%c%p%column
    pgridcell => clm3%g%l%c%p%gridcell
    frac_veg_nosno => clm3%g%l%c%p%pps%frac_veg_nosno
    dlrad => clm3%g%l%c%p%pef%dlrad
    ulrad => clm3%g%l%c%p%pef%ulrad
    thm => clm3%g%l%c%ces%thm
    t_grnd => clm3%g%l%c%ces%t_grnd
    qg => clm3%g%l%c%cws%qg
    z0mg_col => clm3%g%l%c%cps%z0mg
    z0hg_col => clm3%g%l%c%cps%z0hg
    z0qg_col => clm3%g%l%c%cps%z0qg
    thv => clm3%g%l%c%ces%thv
    beta => clm3%g%l%c%cps%beta
    zii => clm3%g%l%c%cps%zii
    ram1 => clm3%g%l%c%p%pps%ram1
    cgrnds => clm3%g%l%c%p%pef%cgrnds
    cgrndl => clm3%g%l%c%p%pef%cgrndl
    cgrnd => clm3%g%l%c%p%pef%cgrnd
    dqgdT => clm3%g%l%c%cws%dqgdT
    htvp => clm3%g%l%c%cps%htvp
    watsat         => clm3%g%l%c%cps%watsat
    h2osoi_ice     => clm3%g%l%c%cws%h2osoi_ice
    dz             => clm3%g%l%c%cps%dz
    h2osoi_liq     => clm3%g%l%c%cws%h2osoi_liq
    frac_sno       => clm3%g%l%c%cps%frac_sno

    

    taux => clm3%g%l%c%p%pmf%taux
    tauy => clm3%g%l%c%p%pmf%tauy
    eflx_sh_grnd => clm3%g%l%c%p%pef%eflx_sh_grnd
    eflx_sh_tot => clm3%g%l%c%p%pef%eflx_sh_tot
    qflx_evap_soi => clm3%g%l%c%p%pwf%qflx_evap_soi
    qflx_evap_tot => clm3%g%l%c%p%pwf%qflx_evap_tot
    t_ref2m => clm3%g%l%c%p%pes%t_ref2m
    q_ref2m => clm3%g%l%c%p%pes%q_ref2m
    t_veg => clm3%g%l%c%p%pes%t_veg
    btran => clm3%g%l%c%p%pps%btran
    rssun => clm3%g%l%c%p%pps%rssun
    rssha => clm3%g%l%c%p%pps%rssha
    rootr => clm3%g%l%c%p%pps%rootr
    rresis => clm3%g%l%c%p%pps%rresis
    psnsun => clm3%g%l%c%p%pcf%psnsun
    psnsha => clm3%g%l%c%p%pcf%psnsha
    fpsn => clm3%g%l%c%p%pcf%fpsn

    

    fn = 0
    do fp = 1,num_nolakep
       p = filter_nolakep(fp)
       if (frac_veg_nosno(p) == 0) then
          fn = fn + 1
          filterp(fn) = p
       end if
    end do

    
    



    do f = 1, fn
       p = filterp(f)
       c = pcolumn(p)
       g = pgridcell(p)

       

       displa(p) = 0._r8
       dlrad(p)  = 0._r8
       ulrad(p)  = 0._r8

       ur(p) = max(1.0_r8,sqrt(forc_u(g)*forc_u(g)+forc_v(g)*forc_v(g)))
       dth(p) = thm(c)-t_grnd(c)
       dqh(p) = forc_q(g)-qg(c)
       dthv = dth(p)*(1._r8+0.61_r8*forc_q(g))+0.61_r8*forc_th(g)*dqh(p)
       zldis(p) = forc_hgt_u(g)

       

       z0mg_pft(p) = z0mg_col(c)
       z0hg_pft(p) = z0hg_col(c)
       z0qg_pft(p) = z0qg_col(c)

       

       call MoninObukIni(ur(p), thv(c), dthv, zldis(p), z0mg_pft(p), um(p), obu(p))

    end do

    
    
    

    do iter = 1, niters

       call FrictionVelocity(lbp, ubp, fn, filterp, &
                             displa, z0mg_pft, z0hg_pft, z0qg_pft, &
                             obu, iter, ur, um, ustar, &
                             temp1, temp2, temp12m, temp22m, fm)



       do f = 1, fn
          p = filterp(f)
          c = pcolumn(p)
          g = pgridcell(p)

          tstar = temp1(p)*dth(p)
          qstar = temp2(p)*dqh(p)
          z0hg_pft(p) = z0mg_pft(p)/exp(0.13_r8 * (ustar(p)*z0mg_pft(p)/1.5e-5_r8)**0.45_r8)
          z0qg_pft(p) = z0hg_pft(p)

          thvstar = tstar*(1._r8+0.61_r8*forc_q(g)) + 0.61_r8*forc_th(g)*qstar
          zeta = zldis(p)*vkc*grav*thvstar/(ustar(p)**2*thv(c))

          if (zeta >= 0._r8) then                   
             zeta = min(2._r8,max(zeta,0.01_r8))
             um(p) = max(ur(p),0.1_r8)
          else                                      
             zeta = max(-100._r8,min(zeta,-0.01_r8))
             wc = beta(c)*(-grav*ustar(p)*thvstar*zii(c)/thv(c))**0.333_r8
             um(p) = sqrt(ur(p)*ur(p) + wc*wc)
          end if
          obu(p) = zldis(p)/zeta
       end do

    end do 

     do j = 1, nlevsoi


       do f = 1, fn
          p = filterp(f)
          rootr(p,j) = 0._r8
          rresis(p,j) = 0._r8
        end do
     end do




    do f = 1, fn
       p = filterp(f)
       c = pcolumn(p)
       g = pgridcell(p)

       

       ram     = 1._r8/(ustar(p)*ustar(p)/um(p))
       rah     = 1._r8/(temp1(p)*ustar(p))
       raw     = 1._r8/(temp2(p)*ustar(p))
       raih    = forc_rho(g)*cpair/rah

       
       www     = (h2osoi_liq(c,1)/denh2o+h2osoi_ice(c,1)/denice)/dz(c,1)/watsat(c,1)
       www     = min(max(www,0.0_r8),1._r8)
       if (dqh(p) .gt. 0._r8) then   
         rsoil = 0._r8
       else
         rsoil   = (1._r8 - frac_sno(c)) * exp(8.206 - 4.255*www)
       end if

       raiw    = forc_rho(g)/(raw+rsoil)
       ram1(p) = ram  

       
       

       cgrnds(p) = raih
       cgrndl(p) = raiw*dqgdT(c)
       cgrnd(p)  = cgrnds(p) + htvp(c)*cgrndl(p)

       
       

       taux(p)          = -forc_rho(g)*forc_u(g)/ram
       tauy(p)          = -forc_rho(g)*forc_v(g)/ram
       eflx_sh_grnd(p)  = -raih*dth(p)
       eflx_sh_tot(p)   = eflx_sh_grnd(p)
       qflx_evap_soi(p) = -raiw*dqh(p)
       qflx_evap_tot(p) = qflx_evap_soi(p)

       

       t_ref2m(p) = thm(c) + temp1(p)*dth(p)*(1._r8/temp12m(p) - 1._r8/temp1(p))

       

       q_ref2m(p) = forc_q(g) + temp2(p)*dqh(p)*(1._r8/temp22m(p) - 1._r8/temp2(p))

       



       t_veg(p) =  t_grnd(c)
       btran(p) = 0._r8
       cf = forc_pbot(g)/(rgas*0.001_r8*thm(c))*1.e06_r8
       rssun(p) = 1._r8/1.e15_r8 * cf
       rssha(p) = 1._r8/1.e15_r8 * cf

       

       psnsun(p) = 0._r8
       psnsha(p) = 0._r8
       fpsn(p) = 0._r8
       clm3%g%l%c%p%pps%lncsun(p) = 0._r8
       clm3%g%l%c%p%pps%lncsha(p) = 0._r8
       clm3%g%l%c%p%pps%vcmxsun(p) = 0._r8
       clm3%g%l%c%p%pps%vcmxsha(p) = 0._r8
       
       clm3%g%l%c%p%pps%cisun(p) = 0._r8
       clm3%g%l%c%p%pps%cisha(p) = 0._r8
       clm3%g%l%c%p%pps%alphapsnsun(p) = 0._r8
       clm3%g%l%c%p%pps%alphapsnsha(p) = 0._r8
       clm3%g%l%c%p%pepv%rc13_canair(p) = 0._r8
       clm3%g%l%c%p%pepv%rc13_psnsun(p) = 0._r8
       clm3%g%l%c%p%pepv%rc13_psnsha(p) = 0._r8
       clm3%g%l%c%p%pc13f%psnsun(p) = 0._r8
       clm3%g%l%c%p%pc13f%psnsha(p) = 0._r8
       clm3%g%l%c%p%pc13f%fpsn(p) = 0._r8
       

    end do

  end subroutine BareGroundFluxes

end module BareGroundFluxesMod
