







module Biogeophysics1Mod













   use shr_kind_mod, only: r8 => shr_kind_r8


   implicit none
   save


   public :: Biogeophysics1   







contains







  subroutine Biogeophysics1(lbg, ubg, lbc, ubc, lbp, ubp, &
       num_nolakec, filter_nolakec, num_nolakep, filter_nolakep)
























    use clmtype
    
    use clm_varcon         , only : denh2o, denice, roverg, hvap, hsub, &
                                    istice, istwet, zlnd, zsno, spval
    use clm_varpar         , only : nlevsoi, nlevsno
    use QSatMod            , only : QSat


    implicit none
    integer, intent(in) :: lbg, ubg                    
    integer, intent(in) :: lbc, ubc                    
    integer, intent(in) :: lbp, ubp                    
    integer, intent(in) :: num_nolakec                 
    integer, intent(in) :: filter_nolakec(ubc-lbc+1)   
    integer, intent(in) :: num_nolakep                 
    integer, intent(in) :: filter_nolakep(ubp-lbp+1)   














    integer , pointer :: ivt(:)           
    integer , pointer :: ityplun(:)       
    integer , pointer :: clandunit(:)     
    integer , pointer :: cgridcell(:)     
    real(r8), pointer :: forc_pbot(:)     
    real(r8), pointer :: forc_q(:)        
    real(r8), pointer :: forc_t(:)        
    real(r8), pointer :: forc_hgt_t(:)    
    real(r8), pointer :: forc_th(:)       
    real(r8), pointer :: forc_u(:)        
    real(r8), pointer :: forc_v(:)        
    real(r8), pointer :: smpmin(:)        
    integer , pointer :: snl(:)           
    real(r8), pointer :: frac_sno(:)      
    real(r8), pointer :: h2osno(:)        
    real(r8), pointer :: elai(:)          
    real(r8), pointer :: esai(:)          
    real(r8), pointer :: z0mr(:)          
    real(r8), pointer :: displar(:)       
    real(r8), pointer :: htop(:)          
    real(r8), pointer :: dz(:,:)          
    real(r8), pointer :: t_soisno(:,:)    
    real(r8), pointer :: h2osoi_liq(:,:)  
    real(r8), pointer :: h2osoi_ice(:,:)  
    real(r8), pointer :: watsat(:,:)      
    real(r8), pointer :: sucsat(:,:)      
    real(r8), pointer :: bsw(:,:)         



    real(r8), pointer :: t_grnd(:)        
    real(r8), pointer :: qg(:)            
    real(r8), pointer :: dqgdT(:)         
    real(r8), pointer :: emg(:)           
    real(r8), pointer :: htvp(:)          
    real(r8), pointer :: beta(:)          
    real(r8), pointer :: zii(:)           
    real(r8), pointer :: thm(:)           
    real(r8), pointer :: thv(:)           
    real(r8), pointer :: z0mg(:)          
    real(r8), pointer :: z0hg(:)          
    real(r8), pointer :: z0qg(:)          
    real(r8), pointer :: emv(:)           
    real(r8), pointer :: z0m(:)           
    real(r8), pointer :: displa(:)        
    real(r8), pointer :: z0mv(:)          
    real(r8), pointer :: z0hv(:)          
    real(r8), pointer :: z0qv(:)          
    real(r8), pointer :: eflx_sh_tot(:)   
    real(r8), pointer :: eflx_lh_tot(:)   
    real(r8), pointer :: eflx_sh_veg(:)   
    real(r8), pointer :: qflx_evap_tot(:) 
    real(r8), pointer :: qflx_evap_veg(:) 
    real(r8), pointer :: qflx_tran_veg(:) 
    real(r8), pointer :: cgrnd(:)         
    real(r8), pointer :: cgrnds(:)        
    real(r8), pointer :: cgrndl(:)        
    real(r8) ,pointer :: tssbef(:,:)      
    real(r8) ,pointer :: soilalpha(:)     





    integer  :: g,l,c,p 
    integer  :: j       
    integer  :: fp      
    integer  :: fc      
    real(r8) :: qred    
    real(r8) :: avmuir  
    real(r8) :: eg      
    real(r8) :: qsatg   
    real(r8) :: degdT   
    real(r8) :: qsatgdT 
    real(r8) :: fac     
    real(r8) :: psit    
    real(r8) :: hr      
    real(r8) :: wx      


   

    forc_hgt_t    => clm_a2l%forc_hgt_t
    forc_pbot     => clm_a2l%forc_pbot
    forc_q        => clm_a2l%forc_q
    forc_t        => clm_a2l%forc_t
    forc_th       => clm_a2l%forc_th
    forc_u        => clm_a2l%forc_u
    forc_v        => clm_a2l%forc_v

    

    ityplun       => clm3%g%l%itype

    

    cgridcell     => clm3%g%l%c%gridcell
    clandunit     => clm3%g%l%c%landunit
    beta          => clm3%g%l%c%cps%beta
    dqgdT         => clm3%g%l%c%cws%dqgdT
    emg           => clm3%g%l%c%cps%emg
    frac_sno      => clm3%g%l%c%cps%frac_sno
    h2osno        => clm3%g%l%c%cws%h2osno
    htvp          => clm3%g%l%c%cps%htvp
    qg            => clm3%g%l%c%cws%qg
    smpmin        => clm3%g%l%c%cps%smpmin
    snl           => clm3%g%l%c%cps%snl
    t_grnd        => clm3%g%l%c%ces%t_grnd
    thm           => clm3%g%l%c%ces%thm
    thv           => clm3%g%l%c%ces%thv
    z0hg          => clm3%g%l%c%cps%z0hg
    z0mg          => clm3%g%l%c%cps%z0mg
    z0qg          => clm3%g%l%c%cps%z0qg
    zii           => clm3%g%l%c%cps%zii
    bsw           => clm3%g%l%c%cps%bsw
    dz            => clm3%g%l%c%cps%dz
    h2osoi_ice    => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq    => clm3%g%l%c%cws%h2osoi_liq
    soilalpha     => clm3%g%l%c%cws%soilalpha
    sucsat        => clm3%g%l%c%cps%sucsat
    t_soisno      => clm3%g%l%c%ces%t_soisno
    tssbef        => clm3%g%l%c%ces%tssbef
    watsat        => clm3%g%l%c%cps%watsat

    

    ivt           => clm3%g%l%c%p%itype
    elai          => clm3%g%l%c%p%pps%elai
    esai          => clm3%g%l%c%p%pps%esai
    htop          => clm3%g%l%c%p%pps%htop
    emv           => clm3%g%l%c%p%pps%emv
    z0m           => clm3%g%l%c%p%pps%z0m
    displa        => clm3%g%l%c%p%pps%displa
    z0mv          => clm3%g%l%c%p%pps%z0mv
    z0hv          => clm3%g%l%c%p%pps%z0hv
    z0qv          => clm3%g%l%c%p%pps%z0qv
    eflx_sh_tot   => clm3%g%l%c%p%pef%eflx_sh_tot
    eflx_lh_tot   => clm3%g%l%c%p%pef%eflx_lh_tot
    eflx_sh_veg   => clm3%g%l%c%p%pef%eflx_sh_veg
    qflx_evap_tot => clm3%g%l%c%p%pwf%qflx_evap_tot
    qflx_evap_veg => clm3%g%l%c%p%pwf%qflx_evap_veg
    qflx_tran_veg => clm3%g%l%c%p%pwf%qflx_tran_veg
    cgrnd         => clm3%g%l%c%p%pef%cgrnd
    cgrnds        => clm3%g%l%c%p%pef%cgrnds
    cgrndl        => clm3%g%l%c%p%pef%cgrndl

    

    z0mr          => pftcon%z0mr
    displar       => pftcon%displar

    do j = -nlevsno+1, nlevsoi


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          tssbef(c,j) = t_soisno(c,j)
       end do
    end do



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       l = clandunit(c)
       g = cgridcell(c)

       
       

       t_grnd(c) = t_soisno(c,snl(c)+1)

       
       

       qred = 1._r8
       if (ityplun(l)/=istwet .AND. ityplun(l)/=istice) then
          wx   = (h2osoi_liq(c,1)/denh2o+h2osoi_ice(c,1)/denice)/dz(c,1)
          fac  = min(1._r8, wx/watsat(c,1))
          fac  = max( fac, 0.01_r8 )
          psit = -sucsat(c,1) * fac ** (-bsw(c,1))
          psit = max(smpmin(c), psit)
          hr   = exp(psit/roverg/t_grnd(c))
          qred = (1._r8-frac_sno(c))*hr + frac_sno(c)
          soilalpha(c) = qred
       else
          soilalpha(c) = spval
       end if

       call QSat(t_grnd(c), forc_pbot(g), eg, degdT, qsatg, qsatgdT)

       qg(c) = qred*qsatg
       dqgdT(c) = qred*qsatgdT

       if (qsatg > forc_q(g) .and. forc_q(g) > qred*qsatg) then
          qg(c) = forc_q(g)
          dqgdT(c) = 0._r8
       end if

       

       if (h2osno(c)>0._r8 .or. ityplun(l)==istice) then
          emg(c) = 0.97_r8
       else
          emg(c) = 0.96_r8
       end if

       
       

       htvp(c) = hvap
       if (h2osoi_liq(c,snl(c)+1) <= 0._r8 .and. h2osoi_ice(c,snl(c)+1) > 0._r8) htvp(c) = hsub

       
       





       
       

       if (frac_sno(c) > 0._r8) then
          z0mg(c) = zsno
       else
          z0mg(c) = zlnd
       end if
       z0hg(c) = z0mg(c)            
       z0qg(c) = z0mg(c)            

       
       

       beta(c) = 1._r8
       zii(c)  = 1000._r8
       thm(c)  = forc_t(g) + 0.0098_r8*forc_hgt_t(g)
       thv(c)  = forc_th(g)*(1._r8+0.61_r8*forc_q(g))

    end do 

    



    do fp = 1,num_nolakep
       p = filter_nolakep(fp)

       

       eflx_sh_tot(p) = 0._r8
       eflx_lh_tot(p) = 0._r8
       eflx_sh_veg(p) = 0._r8
       qflx_evap_tot(p) = 0._r8
       qflx_evap_veg(p) = 0._r8
       qflx_tran_veg(p) = 0._r8

       

       cgrnd(p)  = 0._r8
       cgrnds(p) = 0._r8
       cgrndl(p) = 0._r8

       

       avmuir = 1._r8
       emv(p) = 1._r8-exp(-(elai(p)+esai(p))/avmuir)

       

       z0m(p)    = z0mr(ivt(p)) * htop(p)
       displa(p) = displar(ivt(p)) * htop(p)

       z0mv(p)   = z0m(p)
       z0hv(p)   = z0mv(p)
       z0qv(p)   = z0mv(p)

    end do

  end subroutine Biogeophysics1

end module Biogeophysics1Mod
