






module DriverInitMod










  implicit none
  save


  public :: DriverInit







contains







  subroutine DriverInit(lbc, ubc, lbp, ubp, &
             num_nolakec, filter_nolakec, num_lakec, &

             filter_lakec, ilx, jlx)





    use shr_kind_mod , only : r8 => shr_kind_r8
    use clmtype
    use clm_varpar   , only : nlevsoi, nlevsno
    use subgridAveMod, only : p2c



    implicit none
    integer, intent(in) :: lbc, ubc                    
    integer, intent(in) :: lbp, ubp                    
    integer, intent(in) :: num_nolakec                 
    integer, intent(in) :: filter_nolakec(ubc-lbc+1)   
    integer, intent(in) :: num_lakec                   
    integer, intent(in) :: filter_lakec(ubc-lbc+1)     
    integer, intent(in) :: ilx, jlx













    real(r8), pointer :: pwtgcell(:)           
    integer , pointer :: snl(:)                
    real(r8), pointer :: h2osno(:)             
    integer , pointer :: frac_veg_nosno_alb(:) 
    integer , pointer :: frac_veg_nosno(:)     
    real(r8), pointer :: h2osoi_ice(:,:)       
    real(r8), pointer :: h2osoi_liq(:,:)       



    logical , pointer :: do_capsnow(:)         
    real(r8), pointer :: h2osno_old(:)         
    real(r8), pointer :: frac_iceold(:,:)      



    integer :: c, p, f, j, fc            


    

    snl                => clm3%g%l%c%cps%snl
    h2osno             => clm3%g%l%c%cws%h2osno
    h2osno_old         => clm3%g%l%c%cws%h2osno_old
    do_capsnow         => clm3%g%l%c%cps%do_capsnow
    frac_iceold        => clm3%g%l%c%cps%frac_iceold
    h2osoi_ice         => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq         => clm3%g%l%c%cws%h2osoi_liq
    frac_veg_nosno_alb => clm3%g%l%c%p%pps%frac_veg_nosno_alb
    frac_veg_nosno     => clm3%g%l%c%p%pps%frac_veg_nosno

    

    pwtgcell           => clm3%g%l%c%p%wtgcell



    do c = lbc, ubc

      
      h2osno_old(c) = h2osno(c)


      



         do_capsnow(c) = .false.


    end do

    



    do p = lbp,ubp
       if (pwtgcell(p)>0._r8) then
          frac_veg_nosno(p) = frac_veg_nosno_alb(p)
       else
          frac_veg_nosno(p) = 0._r8
       end if
    end do

    
    

    do j = -nlevsno+1,0


      do f = 1, num_nolakec
         c = filter_nolakec(f)
         if (j >= snl(c) + 1) then
            frac_iceold(c,j) = h2osoi_ice(c,j)/(h2osoi_liq(c,j)+h2osoi_ice(c,j))
         end if
      end do
    end do

  end subroutine DriverInit

end module DriverInitMod
