







module SoilHydrologyMod










  implicit none
  save


  public :: SurfaceRunoff  
  public :: Infiltration   
  public :: SoilWater      
  public :: Drainage       








contains







  subroutine SurfaceRunoff (lbc, ubc, lbp, ubp, num_soilc, filter_soilc, &
       vol_liq, icefrac)





    use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype
    use clm_varcon, only : denice, denh2o, wimp
    use clm_varpar, only : nlevsoi


    implicit none
    integer , intent(in)  :: lbc, ubc                   
    integer , intent(in)  :: lbp, ubp                   
    integer , intent(in)  :: num_soilc                  
    integer , intent(in)  :: filter_soilc(ubc-lbc+1)    
    real(r8), intent(out) :: vol_liq(lbc:ubc,1:nlevsoi) 
    real(r8), intent(out) :: icefrac(lbc:ubc,1:nlevsoi) 

















    real(r8), pointer :: qflx_top_soil(:)  
    real(r8), pointer :: watsat(:,:)       
    real(r8), pointer :: hkdepth(:)        
    real(r8), pointer :: zwt(:)            
    real(r8), pointer :: fcov(:)           
    real(r8), pointer :: dz(:,:)           
    real(r8), pointer :: h2osoi_ice(:,:)   
    real(r8), pointer :: h2osoi_liq(:,:)   
    real(r8), pointer :: wtfact(:)         
    real(r8), pointer :: hksat(:,:)        
    real(r8), pointer :: bsw(:,:)          
    real(r8), pointer :: sucsat(:,:)       



    real(r8), pointer :: qflx_surf(:)      
    real(r8), pointer :: eff_porosity(:,:) 
    real(r8), pointer :: fracice(:,:)      





    integer  :: c,j,fc,g                   
    real(r8) :: vol_ice(lbc:ubc,1:nlevsoi) 
    real(r8) :: fff(lbc:ubc)               
    real(r8) :: s1                         
    real(r8) :: su                         
    real(r8) :: v                          
    real(r8) :: qinmax                     



    

    qflx_top_soil => clm3%g%l%c%cwf%qflx_top_soil
    qflx_surf     => clm3%g%l%c%cwf%qflx_surf
    watsat        => clm3%g%l%c%cps%watsat
    hkdepth       => clm3%g%l%c%cps%hkdepth
    dz            => clm3%g%l%c%cps%dz
    h2osoi_ice    => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq    => clm3%g%l%c%cws%h2osoi_liq
    fcov          => clm3%g%l%c%cws%fcov
    eff_porosity  => clm3%g%l%c%cps%eff_porosity
    wtfact        => clm3%g%l%c%cps%wtfact
    zwt           => clm3%g%l%c%cws%zwt
    fracice       => clm3%g%l%c%cps%fracice
    hksat         => clm3%g%l%c%cps%hksat
    bsw           => clm3%g%l%c%cps%bsw
    sucsat        => clm3%g%l%c%cps%sucsat

    do j = 1,nlevsoi


       do fc = 1, num_soilc
          c = filter_soilc(fc)

          
          
   
          vol_ice(c,j) = min(watsat(c,j), h2osoi_ice(c,j)/(dz(c,j)*denice))
          eff_porosity(c,j) = watsat(c,j)-vol_ice(c,j)
          vol_liq(c,j) = min(eff_porosity(c,j), h2osoi_liq(c,j)/(dz(c,j)*denh2o))

          icefrac(c,j) = min(1._r8,h2osoi_ice(c,j)/(h2osoi_ice(c,j)+h2osoi_liq(c,j)))

          fracice(c,j) = max(0._r8,exp(-3._r8*(1._r8-icefrac(c,j)))- exp(-3._r8))

       end do
    end do

    



    do fc = 1, num_soilc
       c = filter_soilc(fc)
       fff(c)  = 1._r8 / hkdepth(c)
       fcov(c) = (1._r8 - fracice(c,1)) * wtfact(c) * exp(-0.5_r8*fff(c)*zwt(c)) + fracice(c,1)
    end do



    do fc = 1, num_soilc
       c = filter_soilc(fc)

       
       s1        = max(0.01_r8,vol_liq(c,1)/max(wimp,eff_porosity(c,1)))
       su        = max(0._r8,(s1-fcov(c)*1._r8) / (1._r8-fcov(c)))
       v         = -bsw(c,1)*sucsat(c,1)/(0.5_r8*dz(c,1)*1000._r8)
       qinmax    = (1._r8+v*(su-1._r8))*hksat(c,1)

       
       qflx_surf(c) =  fcov(c) * qflx_top_soil(c) + &
                       (1._r8-fcov(c)) * max(0._r8, qflx_top_soil(c)-qinmax)

    end do

  end subroutine SurfaceRunoff







  subroutine Infiltration(lbc, ubc, num_soilc, filter_soilc)





    use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype


    implicit none
    integer, intent(in) :: lbc, ubc                   
    integer, intent(in) :: num_soilc                  
    integer, intent(in) :: filter_soilc(ubc-lbc+1)    













    integer , pointer :: snl(:)            
    real(r8), pointer :: qflx_top_soil(:)  
    real(r8), pointer :: qflx_surf(:)      
    real(r8), pointer :: qflx_evap_grnd(:) 



    real(r8), pointer :: qflx_infl(:)      





    integer :: c, fc    


    

    snl            => clm3%g%l%c%cps%snl
    qflx_top_soil  => clm3%g%l%c%cwf%qflx_top_soil
    qflx_surf      => clm3%g%l%c%cwf%qflx_surf
    qflx_infl      => clm3%g%l%c%cwf%qflx_infl
    qflx_evap_grnd => clm3%g%l%c%cwf%pwf_a%qflx_evap_grnd

    



    do fc = 1, num_soilc
       c = filter_soilc(fc)
       if (snl(c) >= 0) then
          qflx_infl(c) = qflx_top_soil(c) - qflx_surf(c) - qflx_evap_grnd(c)
       else
          qflx_infl(c) = qflx_top_soil(c) - qflx_surf(c)
       end if
    end do

  end subroutine Infiltration







  subroutine SoilWater(lbc, ubc, num_soilc, &
       filter_soilc, vol_liq, dwat, hk, dhkdw)
































































    use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype

    use clm_varcon    , only : wimp, tfrz, hfus, grav
    use clm_varpar    , only : nlevsoi, max_pft_per_col

    use TridiagonalMod, only : Tridiagonal

    use globals, only: dtime




    implicit none
    integer , intent(in)  :: lbc, ubc                   
    integer , intent(in)  :: num_soilc                  
    integer , intent(in)  :: filter_soilc(ubc-lbc+1)    
    real(r8), intent(in)  :: vol_liq(lbc:ubc,1:nlevsoi) 
    real(r8), intent(out) :: dwat(lbc:ubc,1:nlevsoi)    
    real(r8), intent(out) :: hk(lbc:ubc,1:nlevsoi)      
    real(r8), intent(out) :: dhkdw(lbc:ubc,1:nlevsoi)   















    integer , pointer :: npfts(:)             
    real(r8), pointer :: pwtcol(:)            
    real(r8), pointer :: pwtgcell(:)          
    real(r8), pointer :: z(:,:)               
    real(r8), pointer :: dz(:,:)              
    real(r8), pointer :: smpmin(:)            
    real(r8), pointer :: qflx_infl(:)         
    real(r8), pointer :: qflx_tran_veg_pft(:) 
    real(r8), pointer :: qflx_tran_veg_col(:) 
    real(r8), pointer :: eff_porosity(:,:)    
    real(r8), pointer :: watsat(:,:)          
    real(r8), pointer :: hksat(:,:)           
    real(r8), pointer :: bsw(:,:)             
    real(r8), pointer :: sucsat(:,:)          
    real(r8), pointer :: t_soisno(:,:)        
    real(r8), pointer :: rootr_pft(:,:)       
    integer , pointer :: pfti(:)              
    real(r8), pointer :: fracice(:,:)         
    real(r8), pointer :: h2osoi_vol(:,:)      



    real(r8), pointer :: h2osoi_liq(:,:)      



    real(r8), pointer :: rootr_col(:,:)       





    integer  :: p,c,fc,j                  
    integer  :: jtop(lbc:ubc)             


    real(r8) :: amx(lbc:ubc,1:nlevsoi)    
    real(r8) :: bmx(lbc:ubc,1:nlevsoi)    
    real(r8) :: cmx(lbc:ubc,1:nlevsoi)    
    real(r8) :: rmx(lbc:ubc,1:nlevsoi)    
    real(r8) :: zmm(lbc:ubc,1:nlevsoi)    
    real(r8) :: dzmm(lbc:ubc,1:nlevsoi)   
    real(r8) :: den                       
    real(r8) :: dqidw0                    
    real(r8) :: dqidw1                    
    real(r8) :: dqodw1                    
    real(r8) :: dqodw2                    
    real(r8) :: dsmpdw(lbc:ubc,1:nlevsoi) 
    real(r8) :: num                       
    real(r8) :: qin                       
    real(r8) :: qout                      
    real(r8) :: s_node                    
    real(r8) :: s1                        
    real(r8) :: s2                        
    real(r8) :: smp(lbc:ubc,1:nlevsoi)    
    real(r8) :: sdamp                     
    integer  :: pi                        
    real(r8) :: temp(lbc:ubc)             


    

    npfts             => clm3%g%l%c%npfts
    z                 => clm3%g%l%c%cps%z
    dz                => clm3%g%l%c%cps%dz
    smpmin            => clm3%g%l%c%cps%smpmin
    watsat            => clm3%g%l%c%cps%watsat
    hksat             => clm3%g%l%c%cps%hksat
    bsw               => clm3%g%l%c%cps%bsw
    sucsat            => clm3%g%l%c%cps%sucsat
    eff_porosity      => clm3%g%l%c%cps%eff_porosity
    rootr_col         => clm3%g%l%c%cps%rootr_column
    t_soisno          => clm3%g%l%c%ces%t_soisno
    h2osoi_liq        => clm3%g%l%c%cws%h2osoi_liq
    h2osoi_vol        => clm3%g%l%c%cws%h2osoi_vol
    qflx_infl         => clm3%g%l%c%cwf%qflx_infl
    fracice           => clm3%g%l%c%cps%fracice
    qflx_tran_veg_col => clm3%g%l%c%cwf%pwf_a%qflx_tran_veg
    pfti              => clm3%g%l%c%pfti

    

    qflx_tran_veg_pft => clm3%g%l%c%p%pwf%qflx_tran_veg
    rootr_pft         => clm3%g%l%c%p%pps%rootr
    pwtcol            => clm3%g%l%c%p%wtcol
    pwtgcell          => clm3%g%l%c%p%wtgcell

    



    
    

    do j = 1, nlevsoi


       do fc = 1, num_soilc
          c = filter_soilc(fc)
          zmm(c,j) = z(c,j)*1.e3_r8
          dzmm(c,j) = dz(c,j)*1.e3_r8
       end do
    end do

    
    
    
    
    
    

    temp(:) = 0._r8

    do j = 1, nlevsoi


       do fc = 1, num_soilc
          c = filter_soilc(fc)
          rootr_col(c,j) = 0._r8
       end do
    end do

    do pi = 1,max_pft_per_col
       do j = 1,nlevsoi


          do fc = 1, num_soilc
             c = filter_soilc(fc)
             if (pi <= npfts(c)) then
                p = pfti(c) + pi - 1
                if (pwtgcell(p)>0._r8) then
                   rootr_col(c,j) = rootr_col(c,j) + rootr_pft(p,j) * qflx_tran_veg_pft(p) * pwtcol(p)
                end if
             end if
          end do
       end do


       do fc = 1, num_soilc
          c = filter_soilc(fc)
          if (pi <= npfts(c)) then
             p = pfti(c) + pi - 1
             if (pwtgcell(p)>0._r8) then
                temp(c) = temp(c) + qflx_tran_veg_pft(p) * pwtcol(p)
             end if
          end if
       end do
    end do

    do j = 1, nlevsoi


       do fc = 1, num_soilc
          c = filter_soilc(fc)
          if (temp(c) /= 0._r8) then
             rootr_col(c,j) = rootr_col(c,j)/temp(c)
          end if
       end do
    end do

    

    sdamp = 0._r8
    do j = 1, nlevsoi


       do fc = 1, num_soilc
          c = filter_soilc(fc)

          s1 = 0.5_r8*(h2osoi_vol(c,j) + h2osoi_vol(c,min(nlevsoi, j+1))) / &
               (0.5_r8*(watsat(c,j)+watsat(c,min(nlevsoi, j+1))))
          s1 = min(1._r8, s1)
          s2 = hksat(c,j)*s1**(2._r8*bsw(c,j)+2._r8)

          hk(c,j) = (1._r8-0.5_r8*(fracice(c,j)+fracice(c,min(nlevsoi, j+1))))*s1*s2

          dhkdw(c,j) = (1._r8-0.5_r8*(fracice(c,j)+fracice(c,min(nlevsoi, j+1))))* &
                       (2._r8*bsw(c,j)+3._r8)*s2*0.5_r8/watsat(c,j)
          if(j == nlevsoi) dhkdw(c,j) = dhkdw(c,j) * 2._r8

          s_node = max(h2osoi_vol(c,j)/watsat(c,j), 0.01_r8)
          s_node = min(1.0_r8, s_node)

          smp(c,j) = -sucsat(c,j)*s_node**(-bsw(c,j))
          smp(c,j) = max(smpmin(c), smp(c,j))

          dsmpdw(c,j) = -bsw(c,j)*smp(c,j)/(s_node*watsat(c,j))

       end do
    end do

    

    

    j = 1


    do fc = 1, num_soilc
       c = filter_soilc(fc)
       qin    = qflx_infl(c)
       den    = (zmm(c,j+1)-zmm(c,j))
       num    = (smp(c,j+1)-smp(c,j)) - den
       qout   = -hk(c,j)*num/den
       dqodw1 = -(-hk(c,j)*dsmpdw(c,j)   + num*dhkdw(c,j))/den
       dqodw2 = -( hk(c,j)*dsmpdw(c,j+1) + num*dhkdw(c,j))/den
       rmx(c,j) =  qin - qout - qflx_tran_veg_col(c) * rootr_col(c,j)
       amx(c,j) =  0._r8
       bmx(c,j) =  dzmm(c,j)*(sdamp+1._r8/dtime) + dqodw1
       cmx(c,j) =  dqodw2
    end do

    

    do j = 2, nlevsoi - 1


       do fc = 1, num_soilc
          c = filter_soilc(fc)
          den    = (zmm(c,j) - zmm(c,j-1))
          num    = (smp(c,j)-smp(c,j-1)) - den
          qin    = -hk(c,j-1)*num/den
          dqidw0 = -(-hk(c,j-1)*dsmpdw(c,j-1) + num*dhkdw(c,j-1))/den
          dqidw1 = -( hk(c,j-1)*dsmpdw(c,j)   + num*dhkdw(c,j-1))/den
          den    = (zmm(c,j+1)-zmm(c,j))
          num    = (smp(c,j+1)-smp(c,j)) - den
          qout   = -hk(c,j)*num/den
          dqodw1 = -(-hk(c,j)*dsmpdw(c,j)   + num*dhkdw(c,j))/den
          dqodw2 = -( hk(c,j)*dsmpdw(c,j+1) + num*dhkdw(c,j))/den
          rmx(c,j) =  qin - qout - qflx_tran_veg_col(c)*rootr_col(c,j)
          amx(c,j) = -dqidw0
          bmx(c,j) =  dzmm(c,j)/dtime - dqidw1 + dqodw1
          cmx(c,j) =  dqodw2
       end do
    end do

    

    j = nlevsoi


    do fc = 1, num_soilc
       c = filter_soilc(fc)
       den    = (zmm(c,j) - zmm(c,j-1))
       num    = (smp(c,j)-smp(c,j-1)) - den
       qin    = -hk(c,j-1)*num/den
       dqidw0 = -(-hk(c,j-1)*dsmpdw(c,j-1) + num*dhkdw(c,j-1))/den
       dqidw1 = -( hk(c,j-1)*dsmpdw(c,j)   + num*dhkdw(c,j-1))/den
       qout   =  0._r8  
       dqodw1 =  0._r8  
       rmx(c,j) =  qin - qout - qflx_tran_veg_col(c)*rootr_col(c,j)
       amx(c,j) = -dqidw0
       bmx(c,j) =  dzmm(c,j)/dtime - dqidw1 + dqodw1
       cmx(c,j) =  0._r8
    end do

    

    jtop(:) = 1
    call Tridiagonal(lbc, ubc, 1, nlevsoi, jtop, num_soilc, filter_soilc, &
                     amx, bmx, cmx, rmx, dwat(lbc:ubc,1:nlevsoi))

    

    do j= 1,nlevsoi


       do fc = 1,num_soilc
          c = filter_soilc(fc)
          h2osoi_liq(c,j) = h2osoi_liq(c,j) + dwat(c,j)*dzmm(c,j)
       end do
    end do

  end subroutine SoilWater







  subroutine Drainage(lbc, ubc, num_soilc, filter_soilc, vol_liq, hk, &
          icefrac)





    use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype


    use clm_varcon  , only: pondmx, tfrz
    use clm_varpar  , only : nlevsoi

    use globals, only: dtime


    implicit none
    integer , intent(in) :: lbc, ubc                   
    integer , intent(in) :: num_soilc                  
    integer , intent(in) :: filter_soilc(ubc-lbc+1)    
    real(r8), intent(in) :: vol_liq(lbc:ubc,1:nlevsoi) 
    real(r8), intent(in) :: hk(lbc:ubc,1:nlevsoi)      
    real(r8), intent(in) :: icefrac(lbc:ubc,1:nlevsoi) 















    integer , pointer :: snl(:)            
    real(r8), pointer :: qflx_snowcap(:)   
    real(r8), pointer :: qflx_dew_grnd(:)  
    real(r8), pointer :: qflx_dew_snow(:)  
    real(r8), pointer :: qflx_sub_snow(:)  
    real(r8), pointer :: dz(:,:)           
    real(r8), pointer :: bsw(:,:)          
    real(r8), pointer :: eff_porosity(:,:) 
    real(r8), pointer :: t_soisno(:,:)     
    real(r8), pointer :: hksat(:,:)        
    real(r8), pointer :: sucsat(:,:)       
    real(r8), pointer :: z(:,:)            
    real(r8), pointer :: zi(:,:)           
    real(r8), pointer :: watsat(:,:)       
    real(r8), pointer :: hkdepth(:)        
    real(r8), pointer :: zwt(:)            
    real(r8), pointer :: wa(:)             
    real(r8), pointer :: wt(:)             
    real(r8), pointer :: qcharge(:)        



    real(r8), pointer :: h2osoi_ice(:,:)   
    real(r8), pointer :: h2osoi_liq(:,:)   



    real(r8), pointer :: qflx_drain(:)     
    real(r8), pointer :: qflx_qrgwl(:)     
    real(r8), pointer :: eflx_impsoil(:)   





    integer  :: c,j,fc                   


    real(r8) :: xs(lbc:ubc)              
    real(r8) :: dzmm(lbc:ubc,1:nlevsoi)  
    real(r8) :: watmin                   
    integer  :: jwt(lbc:ubc)             
    real(r8) :: rsub_bot(lbc:ubc)        
    real(r8) :: rsub_sat(lbc:ubc)        
    real(r8) :: rsub_top(lbc:ubc)        
    real(r8) :: fff(lbc:ubc)             
    real(r8) :: xsi(lbc:ubc)             
    real(r8) :: xs1(lbc:ubc)             
    real(r8) :: smpfz(1:nlevsoi)         
    real(r8) :: wtsub                    
    real(r8) :: rous                     
    real(r8) :: wh                       
    real(r8) :: wh_zwt                   
    real(r8) :: ws                       
    real(r8) :: s_node                   
    real(r8) :: dzsum                    
    real(r8) :: icefracsum               
    real(r8) :: fracice_rsub(lbc:ubc)    
    real(r8) :: ka                       
    real(r8) :: dza                      


    

    snl           => clm3%g%l%c%cps%snl
    dz            => clm3%g%l%c%cps%dz
    bsw           => clm3%g%l%c%cps%bsw
    t_soisno      => clm3%g%l%c%ces%t_soisno
    hksat         => clm3%g%l%c%cps%hksat
    sucsat        => clm3%g%l%c%cps%sucsat
    z             => clm3%g%l%c%cps%z
    zi            => clm3%g%l%c%cps%zi
    watsat        => clm3%g%l%c%cps%watsat
    hkdepth       => clm3%g%l%c%cps%hkdepth
    zwt           => clm3%g%l%c%cws%zwt
    wa            => clm3%g%l%c%cws%wa
    wt            => clm3%g%l%c%cws%wt
    qcharge       => clm3%g%l%c%cws%qcharge
    eff_porosity  => clm3%g%l%c%cps%eff_porosity
    qflx_snowcap  => clm3%g%l%c%cwf%pwf_a%qflx_snowcap
    qflx_dew_grnd => clm3%g%l%c%cwf%pwf_a%qflx_dew_grnd
    qflx_dew_snow => clm3%g%l%c%cwf%pwf_a%qflx_dew_snow
    qflx_sub_snow => clm3%g%l%c%cwf%pwf_a%qflx_sub_snow
    qflx_drain    => clm3%g%l%c%cwf%qflx_drain
    qflx_qrgwl    => clm3%g%l%c%cwf%qflx_qrgwl
    eflx_impsoil  => clm3%g%l%c%cef%eflx_impsoil
    h2osoi_liq    => clm3%g%l%c%cws%h2osoi_liq
    h2osoi_ice    => clm3%g%l%c%cws%h2osoi_ice

    



    

    do j = 1,nlevsoi


       do fc = 1, num_soilc
          c = filter_soilc(fc)
          dzmm(c,j) = dz(c,j)*1.e3_r8
       end do
    end do

    



    do fc = 1, num_soilc
       c = filter_soilc(fc)
       qflx_drain(c) = 0._r8 
       rsub_bot(c)   = 0._r8
       rsub_sat(c)   = 0._r8
       rsub_top(c)   = 0._r8
       fracice_rsub(c) = 0._r8
    end do

    
    



    do fc = 1, num_soilc
       c = filter_soilc(fc)
       jwt(c) = nlevsoi
       do j = 2,nlevsoi
          if(zwt(c) <= zi(c,j)) then
             jwt(c) = j-1
             exit
          end if
       enddo
    end do

    


    do fc = 1, num_soilc
       c = filter_soilc(fc)
       fff(c)         = 1._r8/ hkdepth(c)
       dzsum = 0._r8
       icefracsum = 0._r8
       do j = jwt(c), nlevsoi
          dzsum  = dzsum + dzmm(c,j)
          icefracsum = icefracsum + icefrac(c,j) * dzmm(c,j)
       end do
       fracice_rsub(c) = max(0._r8,exp(-3._r8*(1._r8-(icefracsum/dzsum)))- exp(-3._r8))
       rsub_top(c)    = (1._r8 - fracice_rsub(c)) * 4.5e-4_r8 * exp(-fff(c)*zwt(c))
    end do

    rous = 0.2_r8

    



    do fc = 1, num_soilc
       c = filter_soilc(fc)

       
       if (eff_porosity(c,jwt(c))<0.001_r8) then
          s_node = 1.0_r8
       else
          s_node = vol_liq(c,jwt(c))/eff_porosity(c,jwt(c))
       end if
       s_node = max(s_node, 0.01_r8)
       s_node = min(1.0_r8, s_node)
       smpfz(jwt(c)) = -sucsat(c,jwt(c))*s_node**(-bsw(c,jwt(c)))
       smpfz(jwt(c)) = max(-80000.0_r8, smpfz(jwt(c)))

       
       if(jwt(c) == nlevsoi) then
          dza = fff(c)*(zwt(c)-z(c,jwt(c)))
          ka = hk(c,jwt(c)) * (1.0_r8-exp(-dza))/dza
          wh_zwt  = -zwt(c) * 1000._r8
       else
          ka = hk(c,jwt(c))
          wh_zwt  = -sucsat(c,jwt(c)+1) - zwt(c) * 1000._r8
       endif

       
       wh      = smpfz(jwt(c))  - z(c,jwt(c))*1.e3_r8
       qcharge(c) = -ka * (wh_zwt-wh)  /((zwt(c)-z(c,jwt(c)))*1000._r8)

       
       qcharge(c) = max(-10.0_r8/dtime,qcharge(c))
       qcharge(c) = min( 10.0_r8/dtime,qcharge(c))

       
       wt(c)  = wt(c) + (qcharge(c) - rsub_top(c)) * dtime

       if(jwt(c) == nlevsoi) then             
          wa(c)  = wa(c) + (qcharge(c) -rsub_top(c)) * dtime
          wt(c)  = wa(c)
          zwt(c)     = (zi(c,nlevsoi) + 25._r8) - wa(c)/1000._r8/rous
          h2osoi_liq(c,nlevsoi) = h2osoi_liq(c,nlevsoi) - qcharge(c) * dtime
          h2osoi_liq(c,nlevsoi) = h2osoi_liq(c,nlevsoi) + max(0._r8,(wa(c)-5000._r8))
          wa(c)  = min(wa(c), 5000._r8)
       else                                
          if (jwt(c) == nlevsoi-1) then       

             zwt(c) = zi(c,nlevsoi)- (wt(c)-rous*1000._r8*25._r8) /eff_porosity(c,nlevsoi)/1000._r8

          else                                   
             ws = 0._r8   
             do j = jwt(c)+2,nlevsoi
               ws = ws + eff_porosity(c,j) * 1000._r8 * dz(c,j)
             enddo
             zwt(c) = zi(c,jwt(c)+1)-(wt(c)-rous*1000_r8*25._r8-ws) /eff_porosity(c,jwt(c)+1)/1000._r8
          endif

          wtsub = 0._r8
          do j = jwt(c)+1, nlevsoi
             wtsub = wtsub + hk(c,j)*dzmm(c,j)
          end do

          
          do j = jwt(c)+1, nlevsoi 
             h2osoi_liq(c,j) = h2osoi_liq(c,j) - rsub_top(c)*dtime*hk(c,j)*dzmm(c,j)/wtsub
          end do
       end if

       zwt(c) = max(0.05_r8,zwt(c))
       zwt(c) = min(80._r8,zwt(c))

    end do

    
    

    do j = nlevsoi,2,-1


       do fc = 1, num_soilc
          c = filter_soilc(fc)
          xsi(c)            = max(h2osoi_liq(c,j)-eff_porosity(c,j)*dzmm(c,j),0._r8)
          h2osoi_liq(c,j)   = min(eff_porosity(c,j)*dzmm(c,j), h2osoi_liq(c,j))
          h2osoi_liq(c,j-1) = h2osoi_liq(c,j-1) + xsi(c)
       end do
    end do



    do fc = 1, num_soilc
       c = filter_soilc(fc)
       xs1(c)          = max(h2osoi_liq(c,1)-(pondmx+watsat(c,1)*dzmm(c,1)-h2osoi_ice(c,1)),0._r8)
       h2osoi_liq(c,1) = min(pondmx+watsat(c,1)*dzmm(c,1)-h2osoi_ice(c,1), h2osoi_liq(c,1))
       rsub_sat(c)     = xs1(c) / dtime
    end do

    
    
    

    watmin = 0.01_r8

    do j = 1, nlevsoi-1


       do fc = 1, num_soilc
          c = filter_soilc(fc)
          if (h2osoi_liq(c,j) < 0._r8) then
             xs(c) = watmin - h2osoi_liq(c,j)
          else
             xs(c) = 0._r8
          end if
          h2osoi_liq(c,j  ) = h2osoi_liq(c,j  ) + xs(c)
          h2osoi_liq(c,j+1) = h2osoi_liq(c,j+1) - xs(c)
       end do
    end do

    j = nlevsoi


    do fc = 1, num_soilc
       c = filter_soilc(fc)
       if (h2osoi_liq(c,j) < watmin) then
          xs(c) = watmin-h2osoi_liq(c,j)
       else
          xs(c) = 0._r8
       end if
       h2osoi_liq(c,j) = h2osoi_liq(c,j) + xs(c)
       wa(c) = wa(c) - xs(c)
       wt(c) = wt(c) - xs(c)
    end do



    do fc = 1, num_soilc
       c = filter_soilc(fc)

       

       qflx_drain(c) = rsub_sat(c) + rsub_top(c)

       

       qflx_qrgwl(c) = qflx_snowcap(c)

       

       eflx_impsoil(c) = 0._r8

       

       if (snl(c)+1 >= 1) then
          h2osoi_liq(c,1) = h2osoi_liq(c,1) + qflx_dew_grnd(c) * dtime
          h2osoi_ice(c,1) = h2osoi_ice(c,1) + (qflx_dew_snow(c) * dtime)
          if (qflx_sub_snow(c)*dtime > h2osoi_ice(c,1)) then
             qflx_sub_snow(c) = h2osoi_ice(c,1)/dtime
             h2osoi_ice(c,1) = 0._r8
          else
             h2osoi_ice(c,1) = h2osoi_ice(c,1) - (qflx_sub_snow(c) * dtime)
          end if
       end if
    end do

  end subroutine Drainage

end module SoilHydrologyMod
