






module SoilTemperatureMod










  implicit none
  save


  public :: SoilTemperature  


  private :: SoilThermProp   
  private :: PhaseChange     







contains







  subroutine SoilTemperature(lbc, ubc, num_nolakec, filter_nolakec, &
                             xmf, fact)





















    use shr_kind_mod  , only : r8 => shr_kind_r8
    use clmtype
    


    use globals, only : dtime,nstep
    use clm_varcon    , only : sb, capr, cnfac
    use clm_varpar    , only : nlevsno, nlevsoi, max_pft_per_col
    use TridiagonalMod, only : Tridiagonal


    implicit none
    integer , intent(in)  :: lbc, ubc                    
    integer , intent(in)  :: num_nolakec                 
    integer , intent(in)  :: filter_nolakec(ubc-lbc+1)   
    real(r8), intent(out) :: xmf(lbc:ubc)                
    real(r8), intent(out) :: fact(lbc:ubc, -nlevsno+1:nlevsoi) 

















    integer , pointer :: pgridcell(:)       
    integer , pointer :: npfts(:)           
    integer , pointer :: pfti(:)            
    real(r8), pointer :: pwtcol(:)          
    real(r8), pointer :: pwtgcell(:)        
    real(r8), pointer :: forc_lwrad(:)      
    integer , pointer :: snl(:)             
    real(r8), pointer :: htvp(:)            
    real(r8), pointer :: emg(:)             
    real(r8), pointer :: cgrnd(:)           
    real(r8), pointer :: dlrad(:)           
    real(r8), pointer :: sabg(:)            
    integer , pointer :: frac_veg_nosno(:)  
    real(r8), pointer :: eflx_sh_grnd(:)    
    real(r8), pointer :: qflx_evap_soi(:)   
    real(r8), pointer :: zi(:,:)            
    real(r8), pointer :: dz(:,:)            
    real(r8), pointer :: z(:,:)             
    real(r8), pointer :: t_soisno(:,:)      



    real(r8), pointer :: t_grnd(:)          



    real(r8), pointer :: eflx_gnet(:)       
    real(r8), pointer :: dgnetdT(:)         





    integer  :: j,c,p,g,pi                       
    integer  :: fc                               
    integer  :: jtop(lbc:ubc)                    


    real(r8) :: at (lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: bt (lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: ct (lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: rt (lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: cv (lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: tk (lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: fn (lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: fn1(lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: brr(lbc:ubc,-nlevsno+1:nlevsoi)  
    real(r8) :: dzm                              
    real(r8) :: dzp                              
    real(r8) :: hs(lbc:ubc)                      
    real(r8) :: dhsdT(lbc:ubc)                   
    real(r8) :: temp1(lbc:ubc)                   
    real(r8) :: temp2(lbc:ubc)                   


    

    forc_lwrad     => clm_a2l%forc_lwrad

    

    npfts          => clm3%g%l%c%npfts
    pfti           => clm3%g%l%c%pfti
    snl            => clm3%g%l%c%cps%snl
    htvp           => clm3%g%l%c%cps%htvp
    emg            => clm3%g%l%c%cps%emg
    t_grnd         => clm3%g%l%c%ces%t_grnd
    zi             => clm3%g%l%c%cps%zi
    dz             => clm3%g%l%c%cps%dz
    z              => clm3%g%l%c%cps%z
    t_soisno       => clm3%g%l%c%ces%t_soisno

    

    pgridcell      => clm3%g%l%c%p%gridcell
    pwtcol         => clm3%g%l%c%p%wtcol
    pwtgcell       => clm3%g%l%c%p%wtgcell  
    frac_veg_nosno => clm3%g%l%c%p%pps%frac_veg_nosno
    cgrnd          => clm3%g%l%c%p%pef%cgrnd
    dlrad          => clm3%g%l%c%p%pef%dlrad
    sabg           => clm3%g%l%c%p%pef%sabg
    eflx_sh_grnd   => clm3%g%l%c%p%pef%eflx_sh_grnd
    qflx_evap_soi  => clm3%g%l%c%p%pwf%qflx_evap_soi
    eflx_gnet      => clm3%g%l%c%p%pef%eflx_gnet
    dgnetdT        => clm3%g%l%c%p%pef%dgnetdT

    



    

    

    call SoilThermProp(lbc, ubc, num_nolakec, filter_nolakec, tk, cv)

    
    
    



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       temp1(c) =    emg(c) * sb * t_grnd(c)**4
       temp2(c) = 4._r8*emg(c) * sb * t_grnd(c)**3
    end do

    hs(lbc:ubc) = 0._r8
    dhsdT(lbc:ubc) = 0._r8
    do pi = 1,max_pft_per_col


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if ( pi <= npfts(c) ) then
             p = pfti(c) + pi - 1
             if (pwtgcell(p)>0._r8) then
                g = pgridcell(p)
                eflx_gnet(p) = sabg(p) + dlrad(p) + (1-frac_veg_nosno(p))*emg(c)*forc_lwrad(g) &
                               - temp1(c) - (eflx_sh_grnd(p)+qflx_evap_soi(p)*htvp(c))
                dgnetdT(p) = - cgrnd(p) - temp2(c)
                hs(c) = hs(c) + eflx_gnet(p) * pwtcol(p)
                dhsdT(c) = dhsdT(c) + dgnetdT(p) * pwtcol(p)
             end if
          end if
       end do
    end do

    
    
    

    do j = -nlevsno+1,nlevsoi


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (j >= snl(c)+1) then
             if (j == snl(c)+1) then
                fact(c,j) = dtime/cv(c,j) * dz(c,j) / (0.5_r8*(z(c,j)-zi(c,j-1)+capr*(z(c,j+1)-zi(c,j-1))))
                fn(c,j) = tk(c,j)*(t_soisno(c,j+1)-t_soisno(c,j))/(z(c,j+1)-z(c,j))
             else if (j <= nlevsoi-1) then
                fact(c,j) = dtime/cv(c,j)
                fn(c,j) = tk(c,j)*(t_soisno(c,j+1)-t_soisno(c,j))/(z(c,j+1)-z(c,j))
                dzm     = (z(c,j)-z(c,j-1))
             else if (j == nlevsoi) then
                fact(c,j) = dtime/cv(c,j)
                fn(c,j) = 0._r8
             end if
          end if
       enddo
    end do

    do j = -nlevsno+1,nlevsoi


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (j >= snl(c)+1) then
             if (j == snl(c)+1) then
                dzp     = z(c,j+1)-z(c,j)
                at(c,j) = 0._r8
                bt(c,j) = 1+(1._r8-cnfac)*fact(c,j)*tk(c,j)/dzp-fact(c,j)*dhsdT(c)
                ct(c,j) =  -(1._r8-cnfac)*fact(c,j)*tk(c,j)/dzp
                rt(c,j) = t_soisno(c,j) +  fact(c,j)*( hs(c) - dhsdT(c)*t_soisno(c,j) + cnfac*fn(c,j) )
             else if (j <= nlevsoi-1) then
                dzm     = (z(c,j)-z(c,j-1))
                dzp     = (z(c,j+1)-z(c,j))
                at(c,j) =   - (1._r8-cnfac)*fact(c,j)* tk(c,j-1)/dzm
                bt(c,j) = 1._r8+ (1._r8-cnfac)*fact(c,j)*(tk(c,j)/dzp + tk(c,j-1)/dzm)
                ct(c,j) =   - (1._r8-cnfac)*fact(c,j)* tk(c,j)/dzp
                rt(c,j) = t_soisno(c,j) + cnfac*fact(c,j)*( fn(c,j) - fn(c,j-1) )
             else if (j == nlevsoi) then
                dzm     = (z(c,j)-z(c,j-1))
                at(c,j) =   - (1._r8-cnfac)*fact(c,j)*tk(c,j-1)/dzm
                bt(c,j) = 1._r8+ (1._r8-cnfac)*fact(c,j)*tk(c,j-1)/dzm
                ct(c,j) = 0._r8
                rt(c,j) = t_soisno(c,j) - cnfac*fact(c,j)*fn(c,j-1)
             end if
          end if
       enddo
    end do



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       jtop(c) = snl(c) + 1
    end do
    call Tridiagonal(lbc, ubc, -nlevsno+1, nlevsoi, jtop, num_nolakec, filter_nolakec, &
                     at, bt, ct, rt, t_soisno(lbc:ubc,-nlevsno+1:nlevsoi))

    

    do j = -nlevsno+1,nlevsoi


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (j >= snl(c)+1) then
             if (j <= nlevsoi-1) then
                fn1(c,j) = tk(c,j)*(t_soisno(c,j+1)-t_soisno(c,j))/(z(c,j+1)-z(c,j))
             else if (j == nlevsoi) then
                fn1(c,j) = 0._r8
             end if
          end if
       end do
    end do

    do j = -nlevsno+1,nlevsoi



       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (j >= snl(c)+1) then
             if (j == snl(c)+1) then
                brr(c,j) = cnfac*fn(c,j) + (1._r8-cnfac)*fn1(c,j)
             else
                brr(c,j) = cnfac*(fn(c,j)-fn(c,j-1)) + (1._r8-cnfac)*(fn1(c,j)-fn1(c,j-1))
             end if
          end if
       end do
    end do

    call PhaseChange (lbc, ubc, num_nolakec, filter_nolakec, fact, brr, hs, dhsdT, xmf)



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       t_grnd(c) = t_soisno(c,snl(c)+1)
    end do

  end subroutine SoilTemperature







  subroutine SoilThermProp (lbc, ubc,  num_nolakec, filter_nolakec, tk, cv)
















    use shr_kind_mod, only : r8 => shr_kind_r8
    use clmtype
    use clm_varcon  , only : denh2o, denice, tfrz, tkwat, tkice, tkair, &
                             cpice,  cpliq,  istice, istwet
    use clm_varpar  , only : nlevsno, nlevsoi


    implicit none
    integer , intent(in)  :: lbc, ubc                       
    integer , intent(in)  :: num_nolakec                    
    integer , intent(in)  :: filter_nolakec(ubc-lbc+1)      
    real(r8), intent(out) :: cv(lbc:ubc,-nlevsno+1:nlevsoi) 
    real(r8), intent(out) :: tk(lbc:ubc,-nlevsno+1:nlevsoi) 














    integer , pointer :: clandunit(:)     
    integer , pointer :: ityplun(:)       
    integer , pointer :: snl(:)           
    real(r8), pointer :: h2osno(:)        



    real(r8), pointer :: watsat(:,:)      
    real(r8), pointer :: tksatu(:,:)      
    real(r8), pointer :: tkmg(:,:)        
    real(r8), pointer :: tkdry(:,:)       
    real(r8), pointer :: csol(:,:)        
    real(r8), pointer :: dz(:,:)          
    real(r8), pointer :: zi(:,:)          
    real(r8), pointer :: z(:,:)           
    real(r8), pointer :: t_soisno(:,:)    
    real(r8), pointer :: h2osoi_liq(:,:)  
    real(r8), pointer :: h2osoi_ice(:,:)  





    integer  :: l,c,j                     
    integer  :: fc                        
    real(r8) :: bw                        
    real(r8) :: dksat                     
    real(r8) :: dke                       
    real(r8) :: fl                        
    real(r8) :: satw                      
    real(r8) :: thk(lbc:ubc,-nlevsno+1:nlevsoi) 


    

    ityplun    => clm3%g%l%itype

    

    clandunit  => clm3%g%l%c%landunit
    snl        => clm3%g%l%c%cps%snl
    h2osno     => clm3%g%l%c%cws%h2osno
    watsat     => clm3%g%l%c%cps%watsat
    tksatu     => clm3%g%l%c%cps%tksatu
    tkmg       => clm3%g%l%c%cps%tkmg
    tkdry      => clm3%g%l%c%cps%tkdry
    csol       => clm3%g%l%c%cps%csol
    dz         => clm3%g%l%c%cps%dz
    zi         => clm3%g%l%c%cps%zi
    z          => clm3%g%l%c%cps%z
    t_soisno   => clm3%g%l%c%ces%t_soisno
    h2osoi_liq => clm3%g%l%c%cws%h2osoi_liq
    h2osoi_ice => clm3%g%l%c%cws%h2osoi_ice

    

    do j = -nlevsno+1,nlevsoi


       do fc = 1, num_nolakec
          c = filter_nolakec(fc)

          
          if (j >= 1) then
             l = clandunit(c)
             if (ityplun(l) /= istwet .AND. ityplun(l) /= istice) then
                satw = (h2osoi_liq(c,j)/denh2o + h2osoi_ice(c,j)/denice)/(dz(c,j)*watsat(c,j))
                satw = min(1._r8, satw)
                if (satw > .1e-6_r8) then
                   fl = h2osoi_liq(c,j)/(h2osoi_ice(c,j)+h2osoi_liq(c,j))
                   if (t_soisno(c,j) >= tfrz) then       
                      dke = max(0._r8, log10(satw) + 1.0_r8)
                      dksat = tksatu(c,j)
                   else                               
                      dke = satw
                      dksat = tkmg(c,j)*0.249_r8**(fl*watsat(c,j))*2.29_r8**watsat(c,j)
                   endif
                   thk(c,j) = dke*dksat + (1._r8-dke)*tkdry(c,j)
                else
                   thk(c,j) = tkdry(c,j)
                endif
             else
                thk(c,j) = tkwat
                if (t_soisno(c,j) < tfrz) thk(c,j) = tkice
             endif
          endif

          
          
          if (snl(c)+1 < 1 .AND. (j >= snl(c)+1) .AND. (j <= 0)) then
             bw = (h2osoi_ice(c,j)+h2osoi_liq(c,j))/dz(c,j)
             thk(c,j) = tkair + (7.75e-5_r8 *bw + 1.105e-6_r8*bw*bw)*(tkice-tkair)
          end if

       end do
    end do

    

    do j = -nlevsno+1,nlevsoi


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (j >= snl(c)+1 .AND. j <= nlevsoi-1) then
             tk(c,j) = thk(c,j)*thk(c,j+1)*(z(c,j+1)-z(c,j)) &
                  /(thk(c,j)*(z(c,j+1)-zi(c,j))+thk(c,j+1)*(zi(c,j)-z(c,j)))
          else if (j == nlevsoi) then
             tk(c,j) = 0._r8
          end if
       end do
    end do

    

    do j = 1, nlevsoi


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          l = clandunit(c)
          if (ityplun(l) /= istwet .AND. ityplun(l) /= istice) then
             cv(c,j) = csol(c,j)*(1-watsat(c,j))*dz(c,j) +   &
               (h2osoi_ice(c,j)*cpice + h2osoi_liq(c,j)*cpliq)
          else
             cv(c,j) = (h2osoi_ice(c,j)*cpice + h2osoi_liq(c,j)*cpliq)
          endif
          if (j == 1) then
             if (snl(c)+1 == 1 .AND. h2osno(c) > 0._r8) then
                cv(c,j) = cv(c,j) + cpice*h2osno(c)
             end if
          end if
       enddo
    end do

    

    do j = -nlevsno+1,0


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (snl(c)+1 < 1 .and. j >= snl(c)+1) then
             cv(c,j) = cpliq*h2osoi_liq(c,j) + cpice*h2osoi_ice(c,j)
          end if
       end do
    end do

  end subroutine SoilThermProp







  subroutine PhaseChange (lbc, ubc, num_nolakec, filter_nolakec, fact, &
                          brr, hs, dhsdT, xmf)














    use shr_kind_mod , only : r8 => shr_kind_r8
    use clmtype


    use globals, only : dtime,nstep
    use clm_varcon  , only : tfrz, hfus, grav
    use clm_varpar  , only : nlevsno, nlevsoi


    implicit none
    integer , intent(in) :: lbc, ubc                             
    integer , intent(in) :: num_nolakec                          
    integer , intent(in) :: filter_nolakec(ubc-lbc+1)            
    real(r8), intent(in) :: brr   (lbc:ubc, -nlevsno+1:nlevsoi)  
    real(r8), intent(in) :: fact  (lbc:ubc, -nlevsno+1:nlevsoi)  
    real(r8), intent(in) :: hs    (lbc:ubc)                      
    real(r8), intent(in) :: dhsdT (lbc:ubc)                      
    real(r8), intent(out):: xmf   (lbc:ubc)                      















    integer , pointer :: snl(:)           
    real(r8), pointer :: h2osno(:)        



    real(r8), pointer :: snowdp(:)        



    real(r8), pointer :: qflx_snomelt(:)  
    real(r8), pointer :: eflx_snomelt(:)  



    real(r8), pointer :: h2osoi_liq(:,:)  
    real(r8), pointer :: h2osoi_ice(:,:)  
    real(r8), pointer :: tssbef(:,:)      
    real(r8), pointer :: sucsat(:,:)      
    real(r8), pointer :: watsat(:,:)      
    real(r8), pointer :: bsw(:,:)         
    real(r8), pointer :: dz(:,:)          



    real(r8), pointer :: t_soisno(:,:)    



    integer, pointer :: imelt(:,:)        





    integer  :: j,c,g                              
    integer  :: fc                                 


    real(r8) :: heatr                              
    real(r8) :: temp1                              
    real(r8) :: hm(lbc:ubc,-nlevsno+1:nlevsoi)     
    real(r8) :: xm(lbc:ubc,-nlevsno+1:nlevsoi)     
    real(r8) :: wmass0(lbc:ubc,-nlevsno+1:nlevsoi) 
    real(r8) :: wice0 (lbc:ubc,-nlevsno+1:nlevsoi) 
    real(r8) :: wliq0 (lbc:ubc,-nlevsno+1:nlevsoi) 
    real(r8) :: supercool(lbc:ubc,nlevsoi)         
    real(r8) :: propor                             
    real(r8) :: tinc                               
    real(r8) :: smp                                


    

    snl          => clm3%g%l%c%cps%snl
    h2osno       => clm3%g%l%c%cws%h2osno
    snowdp       => clm3%g%l%c%cps%snowdp
    qflx_snomelt => clm3%g%l%c%cwf%qflx_snomelt
    eflx_snomelt => clm3%g%l%c%cef%eflx_snomelt
    h2osoi_liq   => clm3%g%l%c%cws%h2osoi_liq
    h2osoi_ice   => clm3%g%l%c%cws%h2osoi_ice
    imelt        => clm3%g%l%c%cps%imelt
    t_soisno     => clm3%g%l%c%ces%t_soisno
    tssbef       => clm3%g%l%c%ces%tssbef
    bsw          => clm3%g%l%c%cps%bsw
    sucsat       => clm3%g%l%c%cps%sucsat
    watsat       => clm3%g%l%c%cps%watsat
    dz           => clm3%g%l%c%cps%dz

    



    



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       qflx_snomelt(c) = 0._r8
       xmf(c) = 0._r8
    end do

    do j = -nlevsno+1,nlevsoi       


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (j >= snl(c)+1) then

             
             imelt(c,j) = 0
             hm(c,j) = 0._r8
             xm(c,j) = 0._r8
             wice0(c,j) = h2osoi_ice(c,j)
             wliq0(c,j) = h2osoi_liq(c,j)
             wmass0(c,j) = h2osoi_ice(c,j) + h2osoi_liq(c,j)
          endif   
       end do   
    enddo   

    do j = -nlevsno+1,0             


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (j >= snl(c)+1) then

             
             
             if (h2osoi_ice(c,j) > 0._r8 .AND. t_soisno(c,j) > tfrz) then
                imelt(c,j) = 1
                t_soisno(c,j) = tfrz
             endif

             
             
             if (h2osoi_liq(c,j) > 0._r8 .AND. t_soisno(c,j) < tfrz) then
                imelt(c,j) = 2
                t_soisno(c,j) = tfrz
             endif
          endif   
       end do   
    enddo   

    do j = 1,nlevsoi             


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if (h2osoi_ice(c,j) > 0. .AND. t_soisno(c,j) > tfrz) then
             imelt(c,j) = 1
             t_soisno(c,j) = tfrz
          endif

          
          supercool(c,j) = 0.0_r8
          if(t_soisno(c,j) < tfrz) then
             smp = hfus*(tfrz-t_soisno(c,j))/(grav*t_soisno(c,j)) * 1000._r8  
             supercool(c,j) = watsat(c,j)*(smp/sucsat(c,j))**(-1._r8/bsw(c,j))
             supercool(c,j) = supercool(c,j)*dz(c,j)*1000._r8       
          endif

          if (h2osoi_liq(c,j) > supercool(c,j) .AND. t_soisno(c,j) < tfrz) then
             imelt(c,j) = 2
             t_soisno(c,j) = tfrz
          endif

          
          if (snl(c)+1 == 1 .AND. h2osno(c) > 0._r8 .AND. j == 1) then
             if (t_soisno(c,j) > tfrz) then
                imelt(c,j) = 1
                t_soisno(c,j) = tfrz
             endif
          endif
       end do
    enddo

    do j = -nlevsno+1,nlevsoi       


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)

          if (j >= snl(c)+1) then

             
             if (imelt(c,j) > 0) then
                tinc = t_soisno(c,j)-tssbef(c,j)
                if (j > snl(c)+1) then
                   hm(c,j) = brr(c,j) - tinc/fact(c,j)
                else
                   hm(c,j) = hs(c) + dhsdT(c)*tinc + brr(c,j) - tinc/fact(c,j)
                endif
             endif

             
             
             if (imelt(c,j) == 1 .AND. hm(c,j) < 0._r8) then
                hm(c,j) = 0._r8
                imelt(c,j) = 0
             endif
             if (imelt(c,j) == 2 .AND. hm(c,j) > 0._r8) then
                hm(c,j) = 0._r8
                imelt(c,j) = 0
             endif

             

             if (imelt(c,j) > 0 .and. abs(hm(c,j)) > 0._r8) then
                xm(c,j) = hm(c,j)*dtime/hfus                           

                
                
                
                if (j == 1) then
                   if (snl(c)+1 == 1 .AND. h2osno(c) > 0._r8 .AND. xm(c,j) > 0._r8) then
                      temp1 = h2osno(c)                           
                      h2osno(c) = max(0._r8,temp1-xm(c,j))
                      propor = h2osno(c)/temp1
                      snowdp(c) = propor * snowdp(c)
                      heatr = hm(c,j) - hfus*(temp1-h2osno(c))/dtime   
                      if (heatr > 0._r8) then
                         xm(c,j) = heatr*dtime/hfus                    
                         hm(c,j) = heatr                               
                      else
                         xm(c,j) = 0._r8
                         hm(c,j) = 0._r8
                      endif
                      qflx_snomelt(c) = max(0._r8,(temp1-h2osno(c)))/dtime   
                      xmf(c) = hfus*qflx_snomelt(c)
                   endif
                endif

                heatr = 0._r8
                if (xm(c,j) > 0._r8) then
                   h2osoi_ice(c,j) = max(0._r8, wice0(c,j)-xm(c,j))
                   heatr = hm(c,j) - hfus*(wice0(c,j)-h2osoi_ice(c,j))/dtime
                else if (xm(c,j) < 0._r8) then
                   if (j <= 0) then
                      h2osoi_ice(c,j) = min(wmass0(c,j), wice0(c,j)-xm(c,j))  
                   else
                      if (wmass0(c,j) < supercool(c,j)) then
                         h2osoi_ice(c,j) = 0._r8
                      else
                         h2osoi_ice(c,j) = min(wmass0(c,j) - supercool(c,j),wice0(c,j)-xm(c,j))
                      endif
                   endif
                   heatr = hm(c,j) - hfus*(wice0(c,j)-h2osoi_ice(c,j))/dtime
                endif

                h2osoi_liq(c,j) = max(0._r8,wmass0(c,j)-h2osoi_ice(c,j))

                if (abs(heatr) > 0._r8) then
                   if (j > snl(c)+1) then
                      t_soisno(c,j) = t_soisno(c,j) + fact(c,j)*heatr
                   else
                      t_soisno(c,j) = t_soisno(c,j) + fact(c,j)*heatr/(1._r8-fact(c,j)*dhsdT(c))
                   endif
                   if (j <= 0) then    
                      if (h2osoi_liq(c,j)*h2osoi_ice(c,j)>0._r8) t_soisno(c,j) = tfrz
                   end if
                endif

                xmf(c) = xmf(c) + hfus * (wice0(c,j)-h2osoi_ice(c,j))/dtime

                if (imelt(c,j) == 1 .AND. j < 1) then
                   qflx_snomelt(c) = qflx_snomelt(c) + max(0._r8,(wice0(c,j)-h2osoi_ice(c,j)))/dtime
                endif
             endif

          endif   
       end do   
    enddo   

    



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       eflx_snomelt(c) = qflx_snomelt(c) * hfus
    end do

  end subroutine PhaseChange

end module SoilTemperatureMod
