








module SurfaceAlbedoMod










  use clm_varcon , only : istsoil

  use shr_kind_mod, only : r8 => shr_kind_r8
  implicit none
  save


  public :: SurfaceAlbedo  
  public :: SnowAge        


  private :: SnowAlbedo    
  private :: SoilAlbedo    
  private :: TwoStream     







contains










   subroutine SurfaceAlbedo(lbg, ubg, lbc, ubc, lbp, ubp, caldayp1)














    use clmtype
    use clm_varpar      , only : numrad


    use globals, only: nstep


    implicit none
    integer , intent(in) :: lbg, ubg 
    integer , intent(in) :: lbc, ubc 
    integer , intent(in) :: lbp, ubp 
    real(r8), intent(in) :: caldayp1 

















    integer , pointer :: pgridcell(:) 
    integer , pointer :: plandunit(:) 
    integer , pointer :: itypelun(:)  
    integer , pointer :: pcolumn(:)   
    integer , pointer :: cgridcell(:) 
    real(r8), pointer :: pwtgcell(:)  
    real(r8), pointer :: lat(:)       
    real(r8), pointer :: lon(:)       
    real(r8), pointer :: elai(:)      
    real(r8), pointer :: esai(:)      
    real(r8), pointer :: h2osno(:)    
    real(r8), pointer :: snowage(:)   
    real(r8), pointer :: rhol(:,:)    
    real(r8), pointer :: rhos(:,:)    
    real(r8), pointer :: taul(:,:)    
    real(r8), pointer :: taus(:,:)    
    integer , pointer :: ivt(:)       
    real(r8) :: declinp1 



    real(r8), pointer :: coszen(:)	  
    real(r8), pointer :: fsun(:)      
    real(r8), pointer :: albgrd(:,:)  
    real(r8), pointer :: albgri(:,:)  
    real(r8), pointer :: albd(:,:)    
    real(r8), pointer :: albi(:,:)    
    real(r8), pointer :: fabd(:,:)    
    real(r8), pointer :: fabi(:,:)    
    real(r8), pointer :: ftdd(:,:)    
    real(r8), pointer :: ftid(:,:)    
    real(r8), pointer :: ftii(:,:)    
    real(r8), pointer :: decl(:)      
    real(r8), pointer :: gdir(:)      
    real(r8), pointer :: omega(:,:)   





    real(r8), parameter :: mpe = 1.e-06_r8    
    integer  :: fp,g,c,p                   
    integer  :: ib                         
    integer  :: ic                         
    real(r8) :: wl(lbp:ubp)                
    real(r8) :: ws(lbp:ubp)                
    real(r8) :: vai(lbp:ubp)               
    real(r8) :: rho(lbp:ubp,numrad)        
    real(r8) :: tau(lbp:ubp,numrad)        
    real(r8) :: ftdi(lbp:ubp,numrad)       
    real(r8) :: albsnd(lbc:ubc,numrad)     
    real(r8) :: albsni(lbc:ubc,numrad)     
    real(r8) :: ext(lbp:ubp)               
    real(r8) :: coszen_gcell(lbg:ubg)      
    real(r8) :: coszen_col(lbc:ubc)        
    real(r8) :: coszen_pft(lbp:ubp)        
    integer  :: num_vegsol                 
    integer  :: filter_vegsol(ubp-lbp+1)   
    integer  :: num_novegsol               
    integer  :: filter_novegsol(ubp-lbp+1) 
    integer  :: num_solar                  
  

    

    lat       => clm3%g%lat_a
    lon       => clm3%g%lon_a

    

    itypelun       => clm3%g%l%itype

    

    cgridcell => clm3%g%l%c%gridcell
    h2osno    => clm3%g%l%c%cws%h2osno
    snowage   => clm3%g%l%c%cps%snowage
    albgrd    => clm3%g%l%c%cps%albgrd
    albgri    => clm3%g%l%c%cps%albgri
    decl      => clm3%g%l%c%cps%decl 
    coszen    => clm3%g%l%c%cps%coszen 

    

    plandunit => clm3%g%l%c%p%landunit
    pgridcell => clm3%g%l%c%p%gridcell
    pcolumn   => clm3%g%l%c%p%column
    pwtgcell  => clm3%g%l%c%p%wtgcell
    albd      => clm3%g%l%c%p%pps%albd
    albi      => clm3%g%l%c%p%pps%albi
    fabd      => clm3%g%l%c%p%pps%fabd
    fabi      => clm3%g%l%c%p%pps%fabi
    ftdd      => clm3%g%l%c%p%pps%ftdd
    ftid      => clm3%g%l%c%p%pps%ftid
    ftii      => clm3%g%l%c%p%pps%ftii
    fsun      => clm3%g%l%c%p%pps%fsun
    elai      => clm3%g%l%c%p%pps%elai
    esai      => clm3%g%l%c%p%pps%esai
    gdir      => clm3%g%l%c%p%pps%gdir
    omega     => clm3%g%l%c%p%pps%omega
    ivt       => clm3%g%l%c%p%itype
    rhol      => pftcon%rhol
    rhos      => pftcon%rhos
    taul      => pftcon%taul
    taus      => pftcon%taus

    







    call clmzen(caldayp1,coszen_gcell,lbg, ubg,declinp1)

    
    



    do c = lbc, ubc
       g = cgridcell(c)
       coszen_col(c) = coszen_gcell(g)
       coszen(c) = coszen_col(c)
       decl(c) = declinp1
    end do



    do p = lbp, ubp
       g = pgridcell(p)
       coszen_pft(p) = coszen_gcell(g)
    end do

    

    do ib = 1, numrad


       do c = lbc,ubc
          albgrd(c,ib) = 0._r8
          albgri(c,ib) = 0._r8
       end do


       do p = lbp,ubp
          albd(p,ib) = 1._r8
          albi(p,ib) = 1._r8
          fabd(p,ib) = 0._r8
          fabi(p,ib) = 0._r8
          ftdd(p,ib) = 0._r8
          ftid(p,ib) = 0._r8
          ftii(p,ib) = 0._r8
          omega(p,ib)= 0._r8
          if (ib==1) then
             gdir(p) = 0._r8
          end if
       end do
    end do

    
    

    num_solar = 0


    do g = lbg,ubg
       if (coszen_gcell(g) > 0._r8) num_solar = num_solar + 1
    end do
    if (num_solar <= 0._r8) return

    
    
    

    ic = 0; call SnowAlbedo(lbc, ubc, coszen_col, ic, albsnd)
    ic = 1; call SnowAlbedo(lbc, ubc, coszen_col, ic, albsni)

    
    
    

    call SoilAlbedo(lbc, ubc, coszen_col, albsnd, albsni)

    

    num_vegsol = 0
    num_novegsol = 0
    do p = lbp,ubp
       if (pwtgcell(p)>0._r8) then
          if (coszen_pft(p) > 0._r8) then
             if (itypelun(plandunit(p)) == istsoil .and. (elai(p) + esai(p)) > 0._r8) then                       
                num_vegsol = num_vegsol + 1
                filter_vegsol(num_vegsol) = p
             else if (itypelun(plandunit(p)) /= istsoil .or. &
                     (itypelun(plandunit(p)) == istsoil .and. (elai(p) + esai(p)) == 0._r8)) then
                num_novegsol = num_novegsol + 1
                filter_novegsol(num_novegsol) = p
             end if
          end if
       end if
    end do

    
    



    do fp = 1,num_vegsol
       p = filter_vegsol(fp)
       vai(p) = elai(p) + esai(p)
       wl(p) = elai(p) / max( vai(p), mpe )
       ws(p) = esai(p) / max( vai(p), mpe )
    end do

    do ib = 1, numrad


       do fp = 1,num_vegsol
          p = filter_vegsol(fp)
          rho(p,ib) = max( rhol(ivt(p),ib)*wl(p) + rhos(ivt(p),ib)*ws(p), mpe )
          tau(p,ib) = max( taul(ivt(p),ib)*wl(p) + taus(ivt(p),ib)*ws(p), mpe )
       end do
    end do

    
    

    call TwoStream (lbc, ubc, lbp, ubp, filter_vegsol, num_vegsol, &
                    coszen_pft, vai, rho, tau)
       
    

    do ib = 1,numrad


       do fp = 1,num_novegsol
          p = filter_novegsol(fp)
          c = pcolumn(p)
          fabd(p,ib) = 0._r8
          fabi(p,ib) = 0._r8
          ftdd(p,ib) = 1._r8
          ftid(p,ib) = 0._r8
          ftii(p,ib) = 1._r8
          albd(p,ib) = albgrd(c,ib)
          albi(p,ib) = albgri(c,ib)
          gdir(p) = 0._r8
       end do
    end do

  end subroutine SurfaceAlbedo







  subroutine SnowAlbedo (lbc, ubc, coszen, ind, alb)





    use clmtype


    implicit none
    integer , intent(in) :: lbc, ubc                 
    real(r8), intent(in) :: coszen(lbc:ubc)          
    integer , intent(in) :: ind                      
    real(r8), intent(out):: alb(lbc:ubc,2)           
















    real(r8), pointer :: h2osno(:)    
    real(r8), pointer :: snowage(:)   







    real(r8), parameter :: snal0 = 0.95_r8 
    real(r8), parameter :: snal1 = 0.65_r8 
    real(r8), parameter :: cons  = 0.2_r8  
    real(r8), parameter :: conn  = 0.5_r8  
    real(r8), parameter :: sl    = 2.0_r8  
    integer  :: c                       
    real(r8) :: age                     
    real(r8) :: albs                    
    real(r8) :: albl                    
    real(r8) :: cff                     
    real(r8) :: czf                     


    

    h2osno  => clm3%g%l%c%cws%h2osno
    snowage => clm3%g%l%c%cps%snowage

    
    

    
    
    
    
    



    do c = lbc, ubc
       if (coszen(c) > 0._r8 .and. h2osno(c) > 0._r8) then
          age = 1._r8-1._r8/(1._r8+snowage(c))
          albs = snal0*(1._r8-cons*age)
          albl = snal1*(1._r8-conn*age)
          if (ind == 0) then
             cff  = ((1._r8+1._r8/sl)/(1._r8+max(0.001_r8, coszen(c))*2._r8*sl )- 1._r8/sl)
             cff  = max(cff, 0._r8)
             czf  = 0.4_r8 * cff * (1._r8-albs)
             albs = albs + czf
             czf  = 0.4_r8 *cff * (1._r8-albl)
             albl = albl + czf
          end if
          alb(c,1) = albs
          alb(c,2) = albl
       else
          alb(c,1) = 0._r8
          alb(c,2) = 0._r8
       end if
    end do

  end subroutine SnowAlbedo







  subroutine SoilAlbedo (lbc, ubc, coszen, albsnd, albsni)





    use clmtype
    use clm_varpar, only : numrad
    use clm_varcon, only : albsat, albdry, alblak, albice, tfrz, istice, istsoil


    implicit none
    integer , intent(in) :: lbc, ubc                
    real(r8), intent(in) :: coszen(lbc:ubc)         
    real(r8), intent(in) :: albsnd(lbc:ubc,numrad)  
    real(r8), intent(in) :: albsni(lbc:ubc,numrad)  













    integer , pointer :: clandunit(:)    
    integer , pointer :: ltype(:)        
    integer , pointer :: isoicol(:)      
    real(r8), pointer :: t_grnd(:)       
    real(r8), pointer :: frac_sno(:)     
    real(r8), pointer :: h2osoi_vol(:,:) 



    real(r8), pointer:: albgrd(:,:)      
    real(r8), pointer:: albgri(:,:)      





    integer, parameter :: nband =numrad 
    integer  :: c,l           
    integer  :: ib            
    real(r8) :: inc           
    real(r8) :: albsod        
    real(r8) :: albsoi        
    integer  :: soilcol       



    

    clandunit  => clm3%g%l%c%landunit
    isoicol    => clm3%g%l%c%cps%isoicol
    t_grnd     => clm3%g%l%c%ces%t_grnd
    frac_sno   => clm3%g%l%c%cps%frac_sno
    h2osoi_vol => clm3%g%l%c%cws%h2osoi_vol
    albgrd     => clm3%g%l%c%cps%albgrd
    albgri     => clm3%g%l%c%cps%albgri

    

    ltype      => clm3%g%l%itype

    

    do ib = 1, nband


       do c = lbc, ubc
          if (coszen(c) > 0._r8) then
             l = clandunit(c)

             if (ltype(l) == istsoil)  then              
                inc    = max(0.11_r8-0.40_r8*h2osoi_vol(c,1), 0._r8)
                soilcol = isoicol(c)
                albsod = min(albsat(soilcol,ib)+inc, albdry(soilcol,ib))
                albsoi = albsod
             else if (ltype(l) == istice)  then          
                albsod = albice(ib)
                albsoi = albsod
             else if (t_grnd(c) > tfrz) then             
                albsod = 0.05_r8/(max(0.001_r8,coszen(c)) + 0.15_r8)
                albsoi = albsod
             else                                        
                albsod = alblak(ib)
                albsoi = albsod
             end if

             albgrd(c,ib) = albsod*(1._r8-frac_sno(c)) + albsnd(c,ib)*frac_sno(c)
             albgri(c,ib) = albsoi*(1._r8-frac_sno(c)) + albsni(c,ib)*frac_sno(c)
          end if
       end do
    end do

  end subroutine SoilAlbedo







  subroutine TwoStream (lbc, ubc, lbp, ubp, filter_vegsol, num_vegsol, &
                        coszen, vai, rho, tau)










    use clmtype
    use clm_varpar, only : numrad
    use clm_varcon, only : omegas, tfrz, betads, betais


    implicit none
    integer , intent(in)  :: lbc, ubc                 
    integer , intent(in)  :: lbp, ubp                 
    integer , intent(in)  :: filter_vegsol(ubp-lbp+1) 
    integer , intent(in)  :: num_vegsol               
    real(r8), intent(in)  :: coszen(lbp:ubp)          
    real(r8), intent(in)  :: vai(lbp:ubp)             
    real(r8), intent(in)  :: rho(lbp:ubp,numrad)      
    real(r8), intent(in)  :: tau(lbp:ubp,numrad)      













    integer , pointer :: pcolumn(:)    
    real(r8), pointer :: albgrd(:,:)   
    real(r8), pointer :: albgri(:,:)   
    real(r8), pointer :: t_veg(:)      
    real(r8), pointer :: fwet(:)       
    integer , pointer :: ivt(:)        
    real(r8), pointer :: xl(:)         



    real(r8), pointer :: albd(:,:)     
    real(r8), pointer :: albi(:,:)     
    real(r8), pointer :: fabd(:,:)     
    real(r8), pointer :: fabi(:,:)     
    real(r8), pointer :: ftdd(:,:)     
    real(r8), pointer :: ftid(:,:)     
    real(r8), pointer :: ftii(:,:)     
    real(r8), pointer :: gdir(:)		   
	 real(r8), pointer :: omega(:,:)    





    integer  :: fp,p,c           
    
    integer  :: ib               
    real(r8) :: cosz             
    real(r8) :: asu              
    real(r8) :: chil(lbp:ubp)    
    real(r8) :: twostext(lbp:ubp)
    real(r8) :: avmu(lbp:ubp)    
    real(r8) :: omegal           
    real(r8) :: betai            
    real(r8) :: betail           
    real(r8) :: betad            
    real(r8) :: betadl           
    real(r8) :: tmp0,tmp1,tmp2,tmp3,tmp4,tmp5,tmp6,tmp7,tmp8,tmp9 
    real(r8) :: p1,p2,p3,p4,s1,s2,u1,u2,u3                        
    real(r8) :: b,c1,d,d1,d2,f,h,h1,h2,h3,h4,h5,h6,h7,h8,h9,h10   
    real(r8) :: phi1,phi2,sigma                                   
    real(r8) :: temp0(lbp:ubp),temp1,temp2(lbp:ubp)               
    real(r8) :: t1


    

    albgrd  => clm3%g%l%c%cps%albgrd
    albgri  => clm3%g%l%c%cps%albgri

    

    pcolumn => clm3%g%l%c%p%column
    fwet    => clm3%g%l%c%p%pps%fwet
    t_veg   => clm3%g%l%c%p%pes%t_veg
    ivt     => clm3%g%l%c%p%itype
    albd    => clm3%g%l%c%p%pps%albd
    albi    => clm3%g%l%c%p%pps%albi
    fabd    => clm3%g%l%c%p%pps%fabd
    fabi    => clm3%g%l%c%p%pps%fabi
    ftdd    => clm3%g%l%c%p%pps%ftdd
    ftid    => clm3%g%l%c%p%pps%ftid
    ftii    => clm3%g%l%c%p%pps%ftii
    gdir    => clm3%g%l%c%p%pps%gdir
    omega   => clm3%g%l%c%p%pps%omega
    xl      => pftcon%xl

    
    
    
    
    
    



    do fp = 1,num_vegsol
       p = filter_vegsol(fp)
       
       
       
       
       cosz = max(0.001_r8, coszen(p))
       
       chil(p) = min( max(xl(ivt(p)), -0.4_r8), 0.6_r8 )
       if (abs(chil(p)) <= 0.01_r8) chil(p) = 0.01_r8
       phi1 = 0.5_r8 - 0.633_r8*chil(p) - 0.330_r8*chil(p)*chil(p)
       phi2 = 0.877_r8 * (1._r8-2._r8*phi1)
       gdir(p) = phi1 + phi2*cosz
       twostext(p) = gdir(p)/cosz
       avmu(p) = ( 1._r8 - phi1/phi2 * log((phi1+phi2)/phi1) ) / phi2
       temp0(p) = gdir(p) + phi2*cosz
       temp1 = phi1*cosz
       temp2(p) = ( 1._r8 - temp1/temp0(p) * log((temp1+temp0(p))/temp1) )
    end do

    do ib = 1, numrad


       do fp = 1,num_vegsol
          p = filter_vegsol(fp)
          c = pcolumn(p)

          omegal = rho(p,ib) + tau(p,ib)
          asu = 0.5_r8*omegal*gdir(p)/temp0(p) *temp2(p)
          betadl = (1._r8+avmu(p)*twostext(p))/(omegal*avmu(p)*twostext(p))*asu
          betail = 0.5_r8 * ((rho(p,ib)+tau(p,ib)) + (rho(p,ib)-tau(p,ib)) &
               * ((1._r8+chil(p))/2._r8)**2) / omegal

          

          if (t_veg(p) > tfrz) then                             
             tmp0 = omegal
             tmp1 = betadl
             tmp2 = betail
          else
             tmp0 =   (1._r8-fwet(p))*omegal        + fwet(p)*omegas(ib)
             tmp1 = ( (1._r8-fwet(p))*omegal*betadl + fwet(p)*omegas(ib)*betads ) / tmp0
             tmp2 = ( (1._r8-fwet(p))*omegal*betail + fwet(p)*omegas(ib)*betais ) / tmp0
          end if
          omega(p,ib) = tmp0           
          betad = tmp1 
          betai = tmp2  

          

          b = 1._r8 - omega(p,ib) + omega(p,ib)*betai
          c1 = omega(p,ib)*betai
          tmp0 = avmu(p)*twostext(p)
          d = tmp0 * omega(p,ib)*betad
          f = tmp0 * omega(p,ib)*(1._r8-betad)
          tmp1 = b*b - c1*c1
          h = sqrt(tmp1) / avmu(p)
          sigma = tmp0*tmp0 - tmp1
          p1 = b + avmu(p)*h
          p2 = b - avmu(p)*h
          p3 = b + tmp0
          p4 = b - tmp0
          







          s1 = exp(-h*vai(p))
          s2 = exp(-twostext(p)*vai(p))

          
          
          
          

          
          

          u1 = b - c1/albgrd(c,ib)
          u2 = b - c1*albgrd(c,ib)
          u3 = f + c1*albgrd(c,ib)

          tmp2 = u1 - avmu(p)*h
          tmp3 = u1 + avmu(p)*h
          d1 = p1*tmp2/s1 - p2*tmp3*s1
          tmp4 = u2 + avmu(p)*h
          tmp5 = u2 - avmu(p)*h
          d2 = tmp4/s1 - tmp5*s1
          h1 = -d*p4 - c1*f
          tmp6 = d - h1*p3/sigma
          tmp7 = ( d - c1 - h1/sigma*(u1+tmp0) ) * s2
          h2 = ( tmp6*tmp2/s1 - p2*tmp7 ) / d1
          h3 = - ( tmp6*tmp3*s1 - p1*tmp7 ) / d1
          h4 = -f*p3 - c1*d
          tmp8 = h4/sigma
          tmp9 = ( u3 - tmp8*(u2-tmp0) ) * s2
          h5 = - ( tmp8*tmp4/s1 + tmp9 ) / d2
          h6 = ( tmp8*tmp5*s1 + tmp9 ) / d2
          h7 = (c1*tmp2) / (d1*s1)
          h8 = (-c1*tmp3*s1) / d1
          h9 = tmp4 / (d2*s1)
          h10 = (-tmp5*s1) / d2

          

          ftdd(p,ib) = s2
          ftid(p,ib) = h4*s2/sigma + h5*s1 + h6/s1

          

          albd(p,ib) = h1/sigma + h2 + h3

          

          fabd(p,ib) = 1._r8 - albd(p,ib) &
               - (1._r8-albgrd(c,ib))*ftdd(p,ib) - (1._r8-albgri(c,ib))*ftid(p,ib)

          
          

          u1 = b - c1/albgri(c,ib)
          u2 = b - c1*albgri(c,ib)
          u3 = f + c1*albgri(c,ib)

          tmp2 = u1 - avmu(p)*h
          tmp3 = u1 + avmu(p)*h
          d1 = p1*tmp2/s1 - p2*tmp3*s1
          tmp4 = u2 + avmu(p)*h
          tmp5 = u2 - avmu(p)*h
          d2 = tmp4/s1 - tmp5*s1
          h1 = -d*p4 - c1*f
          tmp6 = d - h1*p3/sigma
          tmp7 = ( d - c1 - h1/sigma*(u1+tmp0) ) * s2
          h2 = ( tmp6*tmp2/s1 - p2*tmp7 ) / d1
          h3 = - ( tmp6*tmp3*s1 - p1*tmp7 ) / d1
          h4 = -f*p3 - c1*d
          tmp8 = h4/sigma
          tmp9 = ( u3 - tmp8*(u2-tmp0) ) * s2
          h5 = - ( tmp8*tmp4/s1 + tmp9 ) / d2
          h6 = ( tmp8*tmp5*s1 + tmp9 ) / d2
          h7 = (c1*tmp2) / (d1*s1)
          h8 = (-c1*tmp3*s1) / d1
          h9 = tmp4 / (d2*s1)
          h10 = (-tmp5*s1) / d2

          

          ftii(p,ib) = h9*s1 + h10/s1

          

          albi(p,ib) = h7 + h8

          

          fabi(p,ib) = 1._r8 - albi(p,ib) - (1._r8-albgri(c,ib))*ftii(p,ib)

       end do   
    end do   

  end subroutine TwoStream







  subroutine SnowAge (lbc, ubc)





    use clmtype
    use clm_varcon, only : tfrz
    use globals, only: dtime



    implicit none
    integer , intent(in) :: lbc, ubc 














    real(r8), pointer :: t_grnd(:)     
    real(r8), pointer :: h2osno(:)     
    real(r8), pointer :: h2osno_old(:) 



    real(r8), pointer :: snow_age(:)   





    integer  :: c     
    real(r8) :: age1  
    real(r8) :: age2  
    real(r8) :: age3  
    real(r8) :: arg   
    real(r8) :: arg2  
    real(r8) :: dela  
    real(r8) :: dels  
    real(r8) :: sge   



   

    snow_age   => clm3%g%l%c%cps%snowage
    t_grnd     => clm3%g%l%c%ces%t_grnd
    h2osno     => clm3%g%l%c%cws%h2osno
    h2osno_old => clm3%g%l%c%cws%h2osno_old

    





    do c = lbc, ubc
       if (h2osno(c) <= 0._r8) then
          snow_age(c) = 0._r8
       else if (h2osno(c) > 800._r8) then       
          snow_age(c) = 0._r8
       else                                  
          age3 = 0.3_r8
          arg  = 5.e3_r8*(1._r8/tfrz-1._r8/t_grnd(c))
          arg2 = min(0._r8, 10._r8*arg)
          age2 = exp(arg2)
          age1 = exp(arg)
          dela = 1.e-6_r8 * dtime * (age1+age2+age3)
          dels = 0.1_r8*max(0.0_r8,  h2osno(c)-h2osno_old(c))
          sge  = (snow_age(c)+dela) * (1.0_r8-dels)
          snow_age(c) = max(0.0_r8, sge)
       end if
    end do

  end subroutine SnowAge

end module SurfaceAlbedoMod
