






module TridiagonalMod










  implicit none
  save


  public :: Tridiagonal







contains







  subroutine Tridiagonal (lbc, ubc, lbj, ubj, jtop, numf, filter, &
                          a, b, c, r, u)





    use shr_kind_mod, only: r8 => shr_kind_r8


    implicit none
    integer , intent(in)    :: lbc, ubc               
    integer , intent(in)    :: lbj, ubj               
    integer , intent(in)    :: jtop(lbc:ubc)          
    integer , intent(in)    :: numf                   
    integer , intent(in)    :: filter(1:numf)         
    real(r8), intent(in)    :: a(lbc:ubc, lbj:ubj)    
    real(r8), intent(in)    :: b(lbc:ubc, lbj:ubj)    
    real(r8), intent(in)    :: c(lbc:ubc, lbj:ubj)    
    real(r8), intent(in)    :: r(lbc:ubc, lbj:ubj)    
    real(r8), intent(inout) :: u(lbc:ubc, lbj:ubj)    















    integer  :: j,ci,fc                   
    real(r8) :: gam(lbc:ubc,lbj:ubj)      
    real(r8) :: bet(lbc:ubc)              


    



    do fc = 1,numf
       ci = filter(fc)
       bet(ci) = b(ci,jtop(ci))
    end do

    do j = lbj, ubj



       do fc = 1,numf
          ci = filter(fc)
          if (j >= jtop(ci)) then
             if (j == jtop(ci)) then
                u(ci,j) = r(ci,j) / bet(ci)
             else
                gam(ci,j) = c(ci,j-1) / bet(ci)
                bet(ci) = b(ci,j) - a(ci,j) * gam(ci,j)
                u(ci,j) = (r(ci,j) - a(ci,j)*u(ci,j-1)) / bet(ci)
             end if
          end if
       end do
    end do



    do j = ubj-1,lbj,-1



       do fc = 1,numf
          ci = filter(fc)
          if (j >= jtop(ci)) then
             u(ci,j) = u(ci,j) - gam(ci,j+1) * u(ci,j+1)
          end if
       end do
    end do

  end subroutine Tridiagonal

end module TridiagonalMod
