



module accFldsMod


























  use shr_kind_mod, only: r8 => shr_kind_r8


  implicit none
  save


  public :: initAccFlds     
  public :: initAccClmtype  
  public :: updateAccFlds   






contains











  subroutine initAccFlds(t_ref2m)






    use decompMod    , only : get_proc_bounds
    use accumulMod   , only : init_accum_field
    use globals      , only : dtime, nstep
    use clm_varcon   , only : cday, tfrz
    use nanMod       , only : bigint
    use clm_varpar   , only : maxpatch


    implicit none





    real(r8) :: t_ref2m(maxpatch)
    real(r8) :: tda(maxpatch)
    real(r8) :: t10(maxpatch)
    real(r8) :: fnpsn10(maxpatch)
    real(r8) :: prec365(maxpatch)
    real(r8) :: agdd0(maxpatch)
    real(r8) :: agdd5(maxpatch)
    real(r8) :: agddtw(maxpatch)
    real(r8) :: agdd(maxpatch)

    real(r8) :: init_value(maxpatch)



    integer :: begp, endp   
    integer :: begc, endc   
    integer :: begl, endl   
    integer :: begg, endg   
    integer, parameter :: not_used = bigint
    integer :: ncount,ipp     


    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)


     ncount = 0

    


    ncount = ncount + 1
    if(nint(3600./dtime).ge.1) then
      ipp = nint(3600./dtime)
    else
      ipp = -1
    end if
    call init_accum_field(name='TREFAV', units='K', &
         desc='average over an hour of 2-m temperature', &
         accum_type='timeavg', accum_period=ipp, &
         subgrid_type='pft', numlev=1, init_value=t_ref2m,nct=ncount)


  end subroutine initAccFlds







  subroutine updateAccFlds()





    use clmtype
    use decompMod    , only : get_proc_bounds
    use clm_varcon   , only : spval,cday,tfrz
    use pftvarcon    , only : pftpar
    use globals      , only : dtime, nstep, secs,day,dayp1
    use accumulMod   , only : update_accum_field, extract_accum_field


    implicit none








    integer , pointer :: itype(:)            
    integer , pointer :: pgridcell(:)        
    real(r8), pointer :: forc_t(:)           
    real(r8), pointer :: forc_rain(:)        
    real(r8), pointer :: forc_snow(:)        
    real(r8), pointer :: frmf(:)             
    real(r8), pointer :: fpsn(:)             
    real(r8), pointer :: t_ref2m(:)          



    real(r8), pointer :: t_ref2m_min(:)      
    real(r8), pointer :: t_ref2m_max(:)      
    real(r8), pointer :: t_ref2m_min_inst(:) 
    real(r8), pointer :: t_ref2m_max_inst(:) 
    real(r8), pointer :: t10(:)              
    real(r8), pointer :: t_mo(:)             
    real(r8), pointer :: t_mo_min(:)         
    real(r8), pointer :: fnpsn10(:)          
    real(r8), pointer :: prec365(:)          
    real(r8), pointer :: agdd0(:)            
    real(r8), pointer :: agdd5(:)            
    real(r8), pointer :: agddtw(:)           
    real(r8), pointer :: agdd(:)             




    integer :: g,l,c,p                   
    integer :: itypveg                   
    logical :: end_cd                    
    integer :: ier                       
    integer :: begp, endp                
    integer :: begc, endc                
    integer :: begl, endl                
    integer :: begg, endg                
    real(r8), pointer :: rbufslp(:)      


    

    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

    

    forc_t => clm_a2l%forc_t
    forc_rain => clm_a2l%forc_rain
    forc_snow => clm_a2l%forc_snow

    

    itype            => clm3%g%l%c%p%itype
    pgridcell        => clm3%g%l%c%p%gridcell
    t_ref2m          => clm3%g%l%c%p%pes%t_ref2m
    fpsn             => clm3%g%l%c%p%pcf%fpsn
    frmf             => clm3%g%l%c%p%pcf%frmf
    t_ref2m_max_inst => clm3%g%l%c%p%pes%t_ref2m_max_inst
    t_ref2m_min_inst => clm3%g%l%c%p%pes%t_ref2m_min_inst
    t_ref2m_max      => clm3%g%l%c%p%pes%t_ref2m_max
    t_ref2m_min      => clm3%g%l%c%p%pes%t_ref2m_min
    t_mo             => clm3%g%l%c%p%pdgvs%t_mo
    t_mo_min         => clm3%g%l%c%p%pdgvs%t_mo_min
    t10              => clm3%g%l%c%p%pdgvs%t10
    fnpsn10          => clm3%g%l%c%p%pdgvs%fnpsn10
    prec365          => clm3%g%l%c%p%pdgvs%prec365
    agdd0            => clm3%g%l%c%p%pdgvs%agdd0
    agdd5            => clm3%g%l%c%p%pdgvs%agdd5
    agddtw           => clm3%g%l%c%p%pdgvs%agddtw
    agdd             => clm3%g%l%c%p%pdgvs%agdd

    
    

    if (nstep == 0) return

    
    
    

    

    allocate(rbufslp(begp:endp), stat=ier)
    if (ier/=0) then
       write(6,*)'update_accum_hist allocation error for rbuf1dp'
       call endrun
    endif

    
    
    
    
    
    

    call update_accum_field  ('TREFAV', t_ref2m, nstep)
    call extract_accum_field ('TREFAV', rbufslp, nstep)

    if(dayp1-day.eq.1) then
      end_cd =  .true.
    else
      end_cd =  .false.
    end if



    do p = begp,endp
       if (rbufslp(p) /= spval) then
          t_ref2m_max_inst(p) = max(rbufslp(p), t_ref2m_max_inst(p))
          t_ref2m_min_inst(p) = min(rbufslp(p), t_ref2m_min_inst(p))
       endif
       if (end_cd) then
          t_ref2m_max(p) = t_ref2m_max_inst(p)
          t_ref2m_min(p) = t_ref2m_min_inst(p)
          t_ref2m_max_inst(p) = -spval
          t_ref2m_min_inst(p) =  spval
       else if (secs == int(dtime)) then
          t_ref2m_max(p) = spval
          t_ref2m_min(p) = spval
       endif
    end do


    

    deallocate(rbufslp)

  end subroutine updateAccFlds







  subroutine initAccClmtype(t2m_max,t2m_min,t2m_max_inst,t2m_min_inst)










    use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype
    use decompMod   , only : get_proc_bounds
    use accumulMod  , only : extract_accum_field
    use clm_varcon  , only : spval
    use globals     , only : nstep


    implicit none










    real(r8), pointer :: t_ref2m_min(:)      
    real(r8), pointer :: t_ref2m_max(:)      
    real(r8), pointer :: t_ref2m_min_inst(:) 
    real(r8), pointer :: t_ref2m_max_inst(:) 
    real(r8), pointer :: t10(:)              
    real(r8), pointer :: t_mo(:)             
    real(r8), pointer :: fnpsn10(:)          
    real(r8), pointer :: prec365(:)          
    real(r8), pointer :: agdd0(:)            
    real(r8), pointer :: agdd5(:)            
    real(r8), pointer :: agddtw(:)           
    real(r8), pointer :: agdd(:)             





    real(r8) :: t2m_max(maxpatch)
    real(r8) :: t2m_min(maxpatch)
    real(r8) :: t2m_max_inst(maxpatch)
    real(r8) :: t2m_min_inst(maxpatch)


    integer :: p            
    integer :: ier          
    integer :: begp, endp   
    integer :: begc, endc   
    integer :: begl, endl   
    integer :: begg, endg   
    real(r8), pointer :: rbufslp(:)  


    

    t_ref2m_max_inst => clm3%g%l%c%p%pes%t_ref2m_max_inst
    t_ref2m_min_inst => clm3%g%l%c%p%pes%t_ref2m_min_inst
    t_ref2m_max      => clm3%g%l%c%p%pes%t_ref2m_max
    t_ref2m_min      => clm3%g%l%c%p%pes%t_ref2m_min
    t10              => clm3%g%l%c%p%pdgvs%t10
    t_mo             => clm3%g%l%c%p%pdgvs%t_mo
    fnpsn10          => clm3%g%l%c%p%pdgvs%fnpsn10
    prec365          => clm3%g%l%c%p%pdgvs%prec365
    agdd0            => clm3%g%l%c%p%pdgvs%agdd0
    agdd5            => clm3%g%l%c%p%pdgvs%agdd5
    agddtw           => clm3%g%l%c%p%pdgvs%agddtw
    agdd             => clm3%g%l%c%p%pdgvs%agdd

    

    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

    

    do p = begp,endp
       t_ref2m_max(p)      = t2m_max(p)
       t_ref2m_min(p)      = t2m_min(p)
       t_ref2m_max_inst(p) = t2m_max_inst(p)
       t_ref2m_min_inst(p) = t2m_min_inst(p) 
    end do


  end subroutine initAccClmtype

end module accFldsMod
