!------------------------------------------------------------------------
subroutine biophy_to_wrf(snl      ,snowdp  ,snowage      ,dzclm      ,zclm        ,&
                      ziclm       ,h2osno  ,h2osoi_liq   ,h2osoi_ice ,t_grnd      ,&
                      t_soisno    ,t_lake  ,t_veg        ,h2ocan     ,h2ocan_col  ,&
                      h2osoi_vol  ,wtc     ,wtp          ,numc       ,nump        ,&
                      htop        ,tsai    ,t2m_max      ,t2m_min    ,t2m_max_inst,&
                      t2m_min_inst,t_ref2m ,znt          ,q_ref2m) 
!
! !DESCRIPTION: 
! Read/Write biogeophysics information to/from restart file. 
!
! !USES:
    use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype
    use clm_varpar, only : nlevsoi,numrad,maxpatch,nlevsno,nlevlak
    use clm_varcon, only : denice, denh2o
    use nanMod, only : nan
    use decompMod , only : get_proc_bounds
    use pftvarcon , only : noveg
!
! !ARGUMENTS:
    implicit none

! The following vraiables for a WRF restart run
    integer   :: snl(maxpatch)
    integer   :: frac_veg_nosno_alb(maxpatch)
    real(r8)  :: snowdp(maxpatch)
    real(r8)  :: snowage(maxpatch)
    real(r8)  :: frac_sno(maxpatch)
    real(r8)  :: albd(numrad,maxpatch)
    real(r8)  :: albi(numrad,maxpatch)
    real(r8)  :: albgrd(numrad,maxpatch)
    real(r8)  :: albgri(numrad,maxpatch)
    real(r8)  :: h2osno(maxpatch)
    real(r8)  :: t_grnd(maxpatch)
    real(r8)  :: fwet(maxpatch)
    real(r8)  :: tlai(maxpatch)
    real(r8)  :: tsai(maxpatch)
    real(r8)  :: elai(maxpatch)
    real(r8)  :: esai(maxpatch)
    real(r8)  :: fsun(maxpatch)
    real(r8)  :: htop(maxpatch)
    real(r8)  :: hbot(maxpatch)
    real(r8)  :: fabd(numrad,maxpatch)
    real(r8)  :: fabi(numrad,maxpatch)
    real(r8)  :: ftdd(numrad,maxpatch)
    real(r8)  :: ftid(numrad,maxpatch)
    real(r8)  :: ftii(numrad,maxpatch)
    real(r8)  :: t_veg(maxpatch)
    real(r8)  :: h2ocan(maxpatch)
    real(r8)  :: h2ocan_col(maxpatch)
    real(r8)  :: wtc(maxpatch)
    real(r8)  :: wtp(maxpatch)

  real(r8)  :: t_lake(maxpatch,nlevlak)
  real(r8)  :: t_soisno(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: h2osoi_liq(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: h2osoi_ice(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: dzclm(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: zclm(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: ziclm(maxpatch,-nlevsno:nlevsoi)
  real(r8)  :: h2osoi_vol(maxpatch,nlevsoi)

    real(r8)  :: t2m_max(maxpatch)
    real(r8)  :: t2m_min(maxpatch)
    real(r8)  :: t2m_max_inst(maxpatch)
    real(r8)  :: t2m_min_inst(maxpatch)
    real(r8)  :: t_ref2m(maxpatch)
    real(r8)  :: q_ref2m(maxpatch)

    real(r8)  :: znt(maxpatch)
!
! !LOCAL VARIABLES:
    integer :: g,l,c,p,j    ! indices
    real(r8):: pftsum       ! temporary used for pft averaging for columns
    integer :: begp, endp   ! per-proc beginning and ending pft indices
    integer :: begc, endc   ! per-proc beginning and ending column indices
    integer :: begl, endl   ! per-proc beginning and ending landunit indices
    integer :: begg, endg   ! per-proc gridcell ending gridcell indices
    integer :: numc, nump
!-----------------------------------------------------------------------
    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

    numc = endc-begc+1
    nump = endp-begp+1

    ! Column physical state - snl
    do c = begc,endc
       snl(c) = clm3%g%l%c%cps%snl(c)
    end do

    ! Column physical state - snowdp
    do c = begc,endc
       snowdp(c) =  clm3%g%l%c%cps%snowdp(c)
    end do


    ! Column physical state - snowage
    do c = begc,endc
       snowage(c) = clm3%g%l%c%cps%snowage(c)
    end do

    ! Column physical state - frac_sno
    do c = begc,endc
       frac_sno(c) = clm3%g%l%c%cps%frac_sno(c)
    end do

    ! Column physical state - dz (snow)
    do j = -nlevsno+1,0
       do c = begc,endc
          dzclm(c,j) = clm3%g%l%c%cps%dz(c,j)
       end do
    end do

    ! Column physical state - z (snow)
    do j = -nlevsno+1,0
       do c = begc,endc
          zclm(c,j) = clm3%g%l%c%cps%z(c,j)
       end do
    end do

    do j = -nlevsno,0
       do c = begc,endc
          ziclm(c,j) = clm3%g%l%c%cps%zi(c,j)
       end do
    end do

    !pft type physical state variable - albd
    do j = 1,numrad
       do p = begp,endp
          albd(j,p) = clm3%g%l%c%p%pps%albd(p,j)
       end do
    end do

    !pft type physical state variable - albi
    do j = 1,numrad
       do p = begp,endp
          albi(j,p) = clm3%g%l%c%p%pps%albi(p,j)
       end do
    end do

    !column type physical state variable - albgrd
    do j = 1,numrad
       do c = begc,endc
          albgrd(j,c) = clm3%g%l%c%cps%albgrd(c,j)
       end do
    end do

    !column type physical state variable - albgri
    do j = 1,numrad
       do c = begc,endc
          albgri(j,c) = clm3%g%l%c%cps%albgri(c,j)
       end do
    end do

   ! column water state variable - h2osno
    do c = begc,endc
       h2osno(c) = clm3%g%l%c%cws%h2osno(c)
    end do

   ! column water state variable - h2osoi_liq
    do j = -nlevsno+1,nlevsoi
       do c = begc,endc
          h2osoi_liq(c,j) = clm3%g%l%c%cws%h2osoi_liq(c,j)
       end do
    end do

   ! column water state variable - h2osoi_ice
    do j = -nlevsno+1,nlevsoi
       do c = begc,endc
          h2osoi_ice(c,j) = clm3%g%l%c%cws%h2osoi_ice(c,j)
       end do
    end do

   ! column energy state variable - t_grnd
    do c = begc,endc
       t_grnd(c) = clm3%g%l%c%ces%t_grnd(c)
    end do


   ! pft energy state variable - t_ref2m_min
    do p = begp,endp
       t2m_min(p) = clm3%g%l%c%p%pes%t_ref2m_min(p) 
    end do

   ! pft energy state variable - t_ref2m_max
    do p = begp,endp
       t2m_max(p) = clm3%g%l%c%p%pes%t_ref2m_max(p) 
    end do

   ! pft energy state variable - t_ref2m_min_inst
    do p = begp,endp
       t2m_min_inst(p) = clm3%g%l%c%p%pes%t_ref2m_min_inst(p) 
    end do

   ! pft energy state variable - t_ref2m_max_inst
    do p = begp,endp
       t2m_max_inst(p) = clm3%g%l%c%p%pes%t_ref2m_max_inst(p) 
    end do

   ! pft energy state variable - t_ref2m
    do p = begp,endp
       t_ref2m(p) = clm3%g%l%c%p%pes%t_ref2m(p)
    end do

   ! pft energy state variable - q_ref2m
    do p = begp,endp
       q_ref2m(p) = clm3%g%l%c%p%pes%q_ref2m(p)
    end do

   ! column energy state variable - t_soisno
    do j = -nlevsno+1,nlevsoi
       do c = begc,endc
          t_soisno(c,j) = clm3%g%l%c%ces%t_soisno(c,j)
       end do
    end do

    !column type energy state variable - t_lake
    do j = 1,nlevlak
       do c = begc,endc
          t_lake(c,j) = clm3%g%l%c%ces%t_lake(c,j) 
       end do
    end do

    ! pft type physical state variable - frac_veg_nosno_alb 
    do p = begp,endp
       frac_veg_nosno_alb(p) = clm3%g%l%c%p%pps%frac_veg_nosno_alb(p) 
    end do

    ! pft type physical state variable - fwet
    do p = begp,endp
       fwet(p) = clm3%g%l%c%p%pps%fwet(p)
    end do

    ! pft type physical state variable - tlai
    do p = begp,endp
       tlai(p) = clm3%g%l%c%p%pps%tlai(p)
    end do

    ! pft type physical state variable - tsai
    do p = begp,endp
       tsai(p) =  clm3%g%l%c%p%pps%tsai(p)
    end do

    ! pft type physical state variable - elai
    do p = begp,endp
       elai(p) = clm3%g%l%c%p%pps%elai(p)
    end do

    ! pft type physical state variable - esai
    do p = begp,endp
       esai(p)= clm3%g%l%c%p%pps%esai(p)
    end do

    ! pft type physical state variable - fsun
    do p = begp,endp
       fsun(p)= clm3%g%l%c%p%pps%fsun(p)
    end do

    ! pft type physical state variable - htop
    do p = begp,endp
       htop(p)= clm3%g%l%c%p%pps%htop(p)
    end do

    ! pft type physical state variable - hbot
    do p = begp,endp
       hbot(p)= clm3%g%l%c%p%pps%hbot(p)
    end do

    ! pft type physical state variable - fabd
    do j = 1,numrad
       do p = begp,endp
          fabd(j,p) = clm3%g%l%c%p%pps%fabd(p,j)
       end do
    end do

    ! pft type physical state variable - fabi
    do j = 1,numrad
       do p = begp,endp
          fabi(j,p) = clm3%g%l%c%p%pps%fabi(p,j)
       end do
    end do

    ! pft type physical state variable - ftdd
    do j = 1,numrad
       do p = begp,endp
          ftdd(j,p) = clm3%g%l%c%p%pps%ftdd(p,j)
       end do
    end do

    ! pft type physical state variable - ftid
    do j = 1,numrad
       do p = begp,endp
          ftid(j,p) = clm3%g%l%c%p%pps%ftid(p,j)
       end do
    end do

    ! pft type physical state variable - ftii
    do j = 1,numrad
       do p = begp,endp
          ftii(j,p) = clm3%g%l%c%p%pps%ftii(p,j)
       end do
    end do

    ! pft type energy state variable - t_veg
    do p = begp,endp
       t_veg(p) = clm3%g%l%c%p%pes%t_veg(p)
    end do

    ! pft type water state variable - h2ocan 
    do p = begp,endp
       h2ocan(p) = clm3%g%l%c%p%pws%h2ocan(p)
    end do

    do p = begp,endp
        c  = clm3%g%l%c%p%column(p)
        l  = clm3%g%l%c%landunit(c)
       if(clm3%g%l%c%p%itype(p)/=noveg) then !.and. .not. clm3%g%l%lakpoi(l)) then
          znt(p) = clm3%g%l%c%p%pps%z0mv(p)
       else
          znt(p) = clm3%g%l%c%cps%z0mg(c)
       end if
    end do

    ! For read only:
    ! Determine average over all column pfts for h2ocan, needed by begwb
    ! computation in routine driver.F90) - this needs to be done after the
    ! weights are reset in the DGVM case
    ! The following should not be vectorized
       do c = begc,endc
          clm3%g%l%c%cws%pws_a%h2ocan(c) = 0.
       end do
       do p = begp,endp
          c = clm3%g%l%c%p%column(p)
          clm3%g%l%c%cws%pws_a%h2ocan(c) =  clm3%g%l%c%cws%pws_a%h2ocan(c) &
               + clm3%g%l%c%p%pws%h2ocan(p) * clm3%g%l%c%p%wtcol(p)
          h2ocan_col(c)  = clm3%g%l%c%cws%pws_a%h2ocan(c)
       end do

    ! For read only:
    ! Determine volumetric soil water
    do j = 1,nlevsoi
        do c = begc,endc
            clm3%g%l%c%cws%h2osoi_vol(c,j) = &
                clm3%g%l%c%cws%h2osoi_liq(c,j)/(clm3%g%l%c%cps%dz(c,j)*denh2o) &
              + clm3%g%l%c%cws%h2osoi_ice(c,j)/(clm3%g%l%c%cps%dz(c,j)*denice)
            h2osoi_vol(c,j) = clm3%g%l%c%cws%h2osoi_vol(c,j)
        end do
     end do


    do c = begc,endc
         wtc(c)   = clm3%g%l%c%wtgcell(c)
    end do

    do p = begp,endp
         wtp(p)  = clm3%g%l%c%p%wtgcell(p)
    end do
    
  end subroutine biophy_to_wrf
