



    subroutine clm(forc_txy        ,forc_uxy           ,forc_vxy      &
                  ,forc_qxy        ,zgcmxy             ,precxy        &
                  ,flwdsxy         ,forc_solsxy        ,forc_sollxy   &
                  ,forc_solsdxy    ,forc_solldxy       ,forc_pbotxy   &
                  ,forc_psrfxy     ,iveg               ,isl           &
                  ,lndmsk          ,xlat               ,xlon          &
                  ,areaxy          ,dt                 ,yr            &
                  ,mnth            ,dy                 ,nsec          &
                  ,cxday           ,yr1                ,mnp1          &
                  ,dyp1            ,nsec1              ,cxday1        &
                  ,mbdate          ,qsfxy              ,qdnxy         &
                  ,snl             ,snowdp             ,snowage       &
                  ,dzclm           ,zclm               ,ziclm         &
                  ,h2osno          ,h2osoi_liq         ,h2osoi_ice    &
                  ,t_grnd          ,t_soisno           ,t_lake        &
                  ,t_veg           ,h2ocan             ,h2ocan_col    &
                  ,h2osoi_vol      ,wtc                ,wtp           &
                  ,numc            ,nump               ,t2m_max       &
                  ,t2m_min         ,t2m_max_inst       ,t2m_min_inst  &
                  ,t_ref2m         ,albxy              ,tsxy          &
                  ,shxy            ,lhxy               ,nstp          &
                  ,inest           ,ilx                ,jlx           &
                  ,soiflx          ,sabv               ,sabg          &
                  ,lwupxy          ,znt0               ,q_ref2m       &
                  ,rhoxy                                              &
                  ,lake_icefracx,lakedepthx,dzlakex,zlakex,tlakex,savedtke1x &
                                                                      )



  use shr_kind_mod , only : r8 => shr_kind_r8
  use clm_varpar, only : nlevsoi,numrad,maxpatch,&
                         nlevsno,nlevlak,lsmlon,lsmlat
  use initializeMod
  use nanMod
  use clmtype
  use clm_varcon  , only : rair, cpair, po2, pco2, tcrit,tfrz,pstd,sb
  use globals
  use decompMod   , only : get_proc_bounds
  use clmtypeInitMod


  implicit none
  save







  real(r8) :: forc_txy          
  real(r8) :: forc_uxy          
  real(r8) :: forc_vxy          
  real(r8) :: forc_qxy          
  real(r8) :: zgcmxy            
  real(r8) :: precxy            
  real(r8) :: flwdsxy           
  real(r8) :: forc_solsxy       
  real(r8) :: forc_sollxy       
  real(r8) :: forc_solsdxy      
  real(r8) :: forc_solldxy      
  real(r8) :: forc_pbotxy       
  real(r8) :: forc_psrfxy       



































    integer :: i,j,k,g,p,c,l 
    integer :: begp, endp   
    integer :: begc, endc   
    integer :: begl, endl   
    integer :: begg, endg   
    type(gridcell_type), pointer :: gptr  



  integer   :: snl(maxpatch)
  real(r8)  :: snowdp(maxpatch)
  real(r8)  :: snowage(maxpatch)
  real(r8)  :: h2osno(maxpatch)
  real(r8)  :: t_grnd(maxpatch)
  real(r8)  :: t_veg(maxpatch)
  real(r8)  :: h2ocan(maxpatch)
  real(r8)  :: h2ocan_col(maxpatch)
  real(r8)  :: wtc(maxpatch)
  real(r8)  :: wtp(maxpatch)
  integer   :: numc,nump
  real(r8)  :: htop(maxpatch)
  real(r8)  :: tsai(maxpatch)

  real(r8)  :: t_lake(maxpatch,nlevlak)
  real(r8)  :: t_soisno(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: h2osoi_liq(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: h2osoi_ice(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: dzclm(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: zclm(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: ziclm(maxpatch,-nlevsno:nlevsoi)
  real(r8)  :: h2osoi_vol(maxpatch,nlevsoi)

  real(r8)  :: t2m_max(maxpatch)
  real(r8)  :: t2m_min(maxpatch)
  real(r8)  :: t2m_max_inst(maxpatch)
  real(r8)  :: t2m_min_inst(maxpatch)
  real(r8)  :: t_ref2m(maxpatch)

  real(r8)  :: znt(maxpatch)
  real(r8)  :: q_ref2m(maxpatch)

  logical doalb     

  real(r8)  :: albxy,albixy(numrad),albdxy(numrad)
  real(r8)  :: tsxy
  real(r8)  :: shxy
  real(r8)  :: lhxy
  real(r8)  :: lwupxy
  real(r8)  :: qsfxy
  real(r8)  :: qdnxy
  real(r8)  :: soiflx
  real(r8)  :: sabv
  real(r8)  :: sabg
  real(r8)  :: znt0
  real(r8),intent(out)  :: rhoxy

  integer   :: nstp

  real(r8) :: areaxy           
  real(r8) :: dt
  real(r8) :: cxday
  real(r8) :: cxday1
  real(r8) :: xlat
  real(r8) :: xlon

  integer  :: iveg
  integer  :: isl
  integer  :: lndmsk
  integer  :: yr
  integer  :: mnth
  integer  :: dy
  integer  :: nsec
  integer  :: yr1
  integer  :: mnp1
  integer  :: dyp1
  integer  :: nsec1
  integer  :: mbdate
  integer  :: inest
  integer  :: ilx,jlx

  
  real(r8), intent(in) :: lakedepthx, dzlakex(1:nlevsoi), zlakex(1:nlevsoi)
  real(r8), intent(inout) :: lake_icefracx(1:nlevsoi), tlakex(1:nlevsoi), savedtke1x

  real(r8)  :: t2m,dsq,dsqmin
  character*1024 :: msg



       call CLMDebug('Starting clm3.F')
       write(msg, *) 'At i,j,xlat,xlon = ', ilx, ', ', jlx, ', ', xlat, ', ', xlon, '.'
       call CLMDebug(msg)
       msg = ''
       write(msg, *) 't_grnd(1) = ', t_grnd(1), '.' 
       call CLMDebug(msg)
       msg = ''
       write(msg, *) 'atm forcing: T,u,v,z,q,p:', forc_txy,forc_uxy,forc_vxy,zgcmxy,forc_qxy,forc_pbotxy
       call CLMDebug(msg)


       call clmtype_mod
       call globals_mod
       dtime    = dt
       year     = yr
       month    = mnth
       day      = dy
       secs     = nsec
       calday   = cxday

       yrp1     = yr1
       monp1    = mnp1
       dayp1    = dyp1
       secp1    = nsec1
       caldayp1 = cxday1

       nbdate   = mbdate
       nstep    = nstp

      msg=''
      write(msg,*)'dzlakex(1),zlakex(1),t_lake,tlakex = ',dzlakex(1),zlakex(1),t_lake(1,1),tlakex(1)
      call CLMDebug(msg)

      
      if (isl == 14) isl = 15

      call  initialize(snl    ,snowdp  ,snowage   ,dzclm     ,zclm         &
                  ,ziclm       ,h2osno  ,h2osoi_liq,h2osoi_ice,t_grnd      &
                  ,t_soisno    ,t_lake  ,t_veg     ,h2ocan    ,h2ocan_col  &
                  ,h2osoi_vol  ,xlat    ,xlon      ,areaxy    ,iveg        &
                  ,isl         ,lndmsk  ,t2m_max   ,t2m_min   ,t2m_max_inst&
                  ,t2m_min_inst,t_ref2m                                    &
                  ,lake_icefracx,lakedepthx,dzlakex,zlakex,savedtke1x           &
                                                                          )
    call CLMDebug('Back in clm3')

    

    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

    

       gptr => clm3%g

       do g = begg, endg
          
          

          

          clm_a2l%forc_t(g) = forc_txy
          clm_a2l%forc_u(g) = forc_uxy
          clm_a2l%forc_v(g) = forc_vxy
          clm_a2l%forc_wind(g) = sqrt(forc_uxy**2 + forc_vxy**2)
          clm_a2l%forc_q(g) = forc_qxy
          clm_a2l%forc_hgt(g) = zgcmxy
          clm_a2l%forc_hgt_u(g) = zgcmxy 
          clm_a2l%forc_hgt_t(g) = zgcmxy 
          clm_a2l%forc_hgt_q(g) = zgcmxy 
          clm_a2l%forc_pbot(g) = forc_pbotxy
          clm_a2l%forc_psrf(g) = forc_psrfxy
          clm_a2l%forc_th(g)  = clm_a2l%forc_t(g) * (clm_a2l%forc_psrf(g) &
               / clm_a2l%forc_pbot(g))**(rair/cpair)
          clm_a2l%forc_vp(g)  = clm_a2l%forc_q(g) * clm_a2l%forc_pbot(g) &
               / (0.622 + 0.378 * clm_a2l%forc_q(g))
          clm_a2l%forc_rho(g) = (clm_a2l%forc_pbot(g) - 0.378 * clm_a2l%forc_vp(g)) &
               / (rair * clm_a2l%forc_t(g))

          clm_a2l%forc_pco2(g) = pco2 * clm_a2l%forc_pbot(g)
          clm_a2l%forc_po2(g)  = po2 * clm_a2l%forc_pbot(g)


          

          clm_a2l%forc_lwrad(g) = flwdsxy
          clm_a2l%forc_solad(g,1) = forc_solsxy
          clm_a2l%forc_solad(g,2) = forc_sollxy
          clm_a2l%forc_solai(g,1) = forc_solsdxy
          clm_a2l%forc_solai(g,2) = forc_solldxy
          clm_a2l%forc_solar(g) = forc_solsxy + forc_sollxy &
               + forc_solsdxy + forc_solldxy

          
          
          
          

          if (precxy > 0.) then
             if (clm_a2l%forc_t(g) > (tfrz + tcrit)) then
                clm_a2l%forc_rain(g) = precxy
                clm_a2l%forc_snow(g) = 0.
                clm_a2l%flfall(g) = 1.
             else
                clm_a2l%forc_rain(g) = 0.
                clm_a2l%forc_snow(g) = precxy

                if (clm_a2l%forc_t(g) <= tfrz) then
                   clm_a2l%flfall(g) = 0.
                else if (clm_a2l%forc_t(g) <= tfrz+2.) then
                   clm_a2l%flfall(g) = -54.632 + 0.2 * clm_a2l%forc_t(g)
                else
                   clm_a2l%flfall(g) = 0.4
                endif
             endif
          else
             clm_a2l%forc_rain(g) = 0.
             clm_a2l%forc_snow(g) = 0.
             clm_a2l%flfall(g) = 1.
          endif
          rhoxy = clm_a2l%forc_rho(g) 

       end do


     
     
     
     
     
     
     

     doalb = .true.

     
     
     

     call CLMDebug('Calling Driver')
     call driver (doalb,ilx,jlx)

     call biophy_to_wrf(snl      ,snowdp  ,snowage      ,dzclm      ,zclm        ,&
                     ziclm       ,h2osno  ,h2osoi_liq   ,h2osoi_ice ,t_grnd      ,&
                     t_soisno    ,t_lake  ,t_veg        ,h2ocan     ,h2ocan_col  ,&
                     h2osoi_vol  ,wtc     ,wtp          ,numc       ,nump        ,&
                     htop        ,tsai    ,t2m_max      ,t2m_min    ,t2m_max_inst,&
                     t2m_min_inst,t_ref2m ,znt          ,q_ref2m)


    do j = 1,numrad
       albdxy(j) = 0.0
       albixy(j) = 0.0
       do p = begp,endp
          albdxy(j) = albdxy(j) + clm3%g%l%c%p%pps%albd(p,j)*wtp(p)
          albixy(j) = albixy(j) + clm3%g%l%c%p%pps%albi(p,j)*wtp(p)
       end do
    end do
    albxy = 0.35*sum(albixy) + 0.15*sum(albdxy)


    msg = ''
    write(msg,*) 'Calculated albedo is ', albxy, '.'
    call CLMDebug(msg)

    lwupxy= 0._r8
    shxy  = 0._r8
    lhxy  = 0._r8
    soiflx= 0._r8
    sabv  = 0._r8
    sabg  = 0._r8
    tsxy  = 0._r8
    znt0  = 0._r8
    do p = begp,endp 
       lwupxy= lwupxy+ clm3%g%l%c%p%pef%eflx_lwrad_out(p)*wtp(p)
       shxy  = shxy  + clm3%g%l%c%p%pef%eflx_sh_tot(p)*wtp(p)
       lhxy  = lhxy  + clm3%g%l%c%p%pef%eflx_lh_tot(p)*wtp(p)
       soiflx= soiflx+ clm3%g%l%c%p%pef%eflx_soil_grnd(p)*wtp(p) 
       sabv  = sabv  + clm3%g%l%c%p%pef%sabv(p)*wtp(p)
       sabg  = sabg  + clm3%g%l%c%p%pef%sabg(p)*wtp(p)
       tsxy  = tsxy  + clm3%g%l%c%p%pes%t_veg(p)*wtp(p) 
       
       znt0  = znt0 + znt(p)*wtp(p)
    end do


    msg = ''
    write(msg,*) 'LWUP is', lwupxy, '.'
    call CLMDebug(msg)




    do c = begc,endc
       qsfxy = qsfxy + clm3%g%l%c%cwf%qflx_surf(c)*wtc(c)*dtime
       qdnxy = qdnxy + clm3%g%l%c%cwf%qflx_drain(c)*wtc(c)*dtime
    end do

    
    
    do k = 1,nlevsoi 
       do c=begc,endc
          l=clm3%g%l%c%landunit(c)
          if (clm3%g%l%lakpoi(l) ) then
             lake_icefracx(k) = clm3%g%l%c%cws%lake_icefrac(c,k)
             tlakex(k) = clm3%g%l%c%ces%t_lake(c,k)
             if (k==1) then
                savedtke1x = clm3%g%l%c%cps%savedtke1(c)
                
                msg = ''
                write(msg,*)'lake at point, icefrac(1),tlakex(1),savedtke1x=', lake_icefracx(1), &
                            tlakex(1),savedtke1x
                call CLMDebug(msg)
             end if
          end if
       end do
    end do















    call clmtype_dealloc()


     return

  end subroutine clm

