



module clm_varsur










  use shr_kind_mod, only: r8 => shr_kind_r8
  use clm_varpar, only : lsmlon, lsmlat, nlevsoi


  implicit none
  save



  integer :: numlon(lsmlat)             
  real(r8):: latixy(lsmlon,lsmlat)      
  real(r8):: longxy(lsmlon,lsmlat)      
  real(r8):: area(lsmlon,lsmlat)        
  real(r8):: landarea                   
  real(r8):: lats(lsmlat+1)             
  real(r8):: lonw(lsmlon+1,lsmlat)      
  real(r8):: lsmedge(4)                 
  logical :: pole_points                
  logical :: fullgrid  = .true.         
  logical :: offline_rdgrid             



  integer  landmask(lsmlon,lsmlat)      
  real(r8) landfrac(lsmlon,lsmlat)      



  integer , allocatable :: soic2d(:,:)   
  real(r8), allocatable :: sand3d(:,:,:) 
  real(r8), allocatable :: clay3d(:,:,:) 
  real(r8), allocatable :: pctgla(:,:)   
  real(r8), allocatable :: pctlak(:,:)   
  real(r8), allocatable :: pctwet(:,:)   
  real(r8), allocatable :: pcturb(:,:)   


  public :: varsur_alloc    
  public :: varsur_dealloc  







contains







  subroutine varsur_alloc





    implicit none







    integer :: ier                    


    allocate (soic2d(lsmlon,lsmlat), &
              sand3d(lsmlon,lsmlat,nlevsoi), &
              clay3d(lsmlon,lsmlat,nlevsoi), &
              pctgla(lsmlon,lsmlat), &
              pctlak(lsmlon,lsmlat), &
              pctwet(lsmlon,lsmlat), &
              pcturb(lsmlon,lsmlat), stat=ier)
    if (ier /= 0) then
       write(6,*)'varsur_alloc(): allocation error'
       call endrun
    endif

  end subroutine varsur_alloc







  subroutine varsur_dealloc





    implicit none







    deallocate (soic2d, &
                sand3d, &
                clay3d, &
                pctgla, &
                pctlak, &
                pctwet, &
                pcturb)

  end subroutine varsur_dealloc

end module clm_varsur
