






module clmtype










































  use shr_kind_mod, only: r8 => shr_kind_r8
  use clm_varpar




  implicit none













type, public :: energy_balance_type
   real(r8), pointer :: errsoi(:)        
   real(r8), pointer :: errseb(:)        
   real(r8), pointer :: errsol(:)        
   real(r8), pointer :: errlon(:)        
end type energy_balance_type




type, public :: water_balance_type
   real(r8), pointer :: begwb(:)         
   real(r8), pointer :: endwb(:)         
   real(r8), pointer :: errh2o(:)        
end type water_balance_type




type, public :: carbon_balance_type
   real(r8), pointer :: begcb(:)         
   real(r8), pointer :: endcb(:)         
   real(r8), pointer :: errcb(:)         
end type carbon_balance_type




type, public :: nitrogen_balance_type
   real(r8), pointer :: begnb(:)         
   real(r8), pointer :: endnb(:)         
   real(r8), pointer :: errnb(:)         
end type nitrogen_balance_type












type, public :: pft_pstate_type
   integer , pointer :: frac_veg_nosno(:)       
   integer , pointer :: frac_veg_nosno_alb(:)   
   real(r8), pointer :: emv(:) 		        
   real(r8), pointer :: z0mv(:) 		
   real(r8), pointer :: z0hv(:) 		
   real(r8), pointer :: z0qv(:) 		
   real(r8), pointer :: rootfr(:,:)             
   real(r8), pointer :: rootr(:,:)              
   real(r8), pointer :: rresis(:,:)             
   real(r8), pointer :: dewmx(:) 		
   real(r8), pointer :: rssun(:) 		
   real(r8), pointer :: rssha(:) 		
   real(r8), pointer :: laisun(:) 		
   real(r8), pointer :: laisha(:) 		
   real(r8), pointer :: btran(:) 		
   real(r8), pointer :: fsun(:) 		
   real(r8), pointer :: tlai(:) 		
   real(r8), pointer :: tsai(:) 		
   real(r8), pointer :: elai(:) 		
   real(r8), pointer :: esai(:) 		
   real(r8), pointer :: fwet(:) 		
   real(r8), pointer :: fdry(:) 		
   real(r8), pointer :: dt_veg(:) 		
   real(r8), pointer :: htop(:) 		
   real(r8), pointer :: hbot(:) 		
   real(r8), pointer :: z0m(:) 		        
   real(r8), pointer :: displa(:) 		
   real(r8), pointer :: albd(:,:)        	
   real(r8), pointer :: albi(:,:)        	
   real(r8), pointer :: fabd(:,:)        	
   real(r8), pointer :: fabi(:,:)        	
   real(r8), pointer :: ftdd(:,:)        	
   real(r8), pointer :: ftid(:,:)        	
   real(r8), pointer :: ftii(:,:)        	
   real(r8), pointer :: u10(:) 		        
   real(r8), pointer :: ram1(:) 		
   real(r8), pointer :: fv(:) 		        
   
   real(r8), pointer :: slasun(:)     
   real(r8), pointer :: slasha(:)     
   real(r8), pointer :: lncsun(:)     
   real(r8), pointer :: lncsha(:)     
   real(r8), pointer :: vcmxsun(:)    
   real(r8), pointer :: vcmxsha(:)    
   real(r8), pointer :: gdir(:)       
   real(r8), pointer :: omega(:,:)    
   real(r8), pointer :: eff_kid(:,:)  
   real(r8), pointer :: eff_kii(:,:)  
   real(r8), pointer :: sun_faid(:,:) 
   real(r8), pointer :: sun_faii(:,:) 
   real(r8), pointer :: sha_faid(:,:) 
   real(r8), pointer :: sha_faii(:,:) 
	
   
   real(r8), pointer :: cisun(:) 		
   real(r8), pointer :: cisha(:) 		
   real(r8), pointer :: alphapsnsun(:) 
   real(r8), pointer :: alphapsnsha(:) 
   
end type pft_pstate_type




type, public :: pft_epc_type
   integer , pointer :: ncorn(:) 		
   integer , pointer :: nwheat(:) 		
   integer , pointer :: noveg(:) 	        
   integer , pointer :: ntree(:) 		
   real(r8), pointer :: smpso(:)                
   real(r8), pointer :: smpsc(:)                
   real(r8), pointer :: fnitr(:)                
   real(r8), pointer :: foln(:) 	        
   real(r8), pointer :: dleaf(:) 		
   real(r8), pointer :: c3psn(:) 		
   real(r8), pointer :: vcmx25(:) 		
   real(r8), pointer :: mp(:) 		        
   real(r8), pointer :: qe25(:) 		
   real(r8), pointer :: xl(:) 		        
   real(r8), pointer :: rhol(:,:)               
   real(r8), pointer :: rhos(:,:)               
   real(r8), pointer :: taul(:,:)               
   real(r8), pointer :: taus(:,:)               
   real(r8), pointer :: z0mr(:) 		
   real(r8), pointer :: displar(:) 		
   real(r8), pointer :: roota_par(:) 	        
   real(r8), pointer :: rootb_par(:)	 	
   real(r8), pointer :: sla(:) 		        
   
   real(r8), pointer :: slatop(:)    
   real(r8), pointer :: dsladlai(:)  
   real(r8), pointer :: leafcn(:)    
   real(r8), pointer :: flnr(:)      
   real(r8), pointer :: woody(:)     
   real(r8), pointer :: lflitcn(:)      
   real(r8), pointer :: frootcn(:)      
   real(r8), pointer :: livewdcn(:)     
   real(r8), pointer :: deadwdcn(:)     
   real(r8), pointer :: froot_leaf(:)   
   real(r8), pointer :: stem_leaf(:)    
   real(r8), pointer :: croot_stem(:)   
   real(r8), pointer :: flivewd(:)      
   real(r8), pointer :: fcur(:)         
   real(r8), pointer :: lf_flab(:)      
   real(r8), pointer :: lf_fcel(:)      
   real(r8), pointer :: lf_flig(:)      
   real(r8), pointer :: fr_flab(:)      
   real(r8), pointer :: fr_fcel(:)      
   real(r8), pointer :: fr_flig(:)      
   real(r8), pointer :: dw_fcel(:)      
   real(r8), pointer :: dw_flig(:)      
   real(r8), pointer :: leaf_long(:)    
   real(r8), pointer :: evergreen(:)    
   real(r8), pointer :: stress_decid(:) 
   real(r8), pointer :: season_decid(:) 
   
   real(r8), pointer :: resist(:)       
end type pft_epc_type




type, public :: pft_dgvepc_type
   real(r8), pointer :: respcoeff(:)       
   real(r8), pointer :: flam(:)            
   real(r8), pointer :: resist(:)          
   real(r8), pointer :: l_turn(:)          
   real(r8), pointer :: l_long(:)          
   real(r8), pointer :: s_turn(:)          
   real(r8), pointer :: r_turn(:)          
   real(r8), pointer :: l_cton(:)          
   real(r8), pointer :: s_cton(:)          
   real(r8), pointer :: r_cton(:)          
   real(r8), pointer :: l_morph(:)         
   real(r8), pointer :: l_phen(:)          
   real(r8), pointer :: lmtorm(:)          
   real(r8), pointer :: crownarea_max(:)   
   real(r8), pointer :: init_lai(:)        
   real(r8), pointer :: x(:)               
   real(r8), pointer :: tcmin(:)           
   real(r8), pointer :: tcmax(:)           
   real(r8), pointer :: gddmin(:)          
   real(r8), pointer :: twmax(:)           
   real(r8), pointer :: lm_sapl(:) 
   real(r8), pointer :: sm_sapl(:) 
   real(r8), pointer :: hm_sapl(:) 
   real(r8), pointer :: rm_sapl(:) 
   logical , pointer :: tree(:)
   logical , pointer :: summergreen(:)
   logical , pointer :: raingreen(:)
   real(r8), pointer :: reinickerp(:)      
   real(r8), pointer :: wooddens(:)	   
   real(r8), pointer :: latosa(:)	   
   real(r8), pointer :: allom1(:)	   
   real(r8), pointer :: allom2(:)          
   real(r8), pointer :: allom3(:)	   
end type pft_dgvepc_type




type, public :: pft_epv_type
   real(r8), pointer :: dormant_flag(:)         
   real(r8), pointer :: days_active(:)          
   real(r8), pointer :: onset_flag(:)           
   real(r8), pointer :: onset_counter(:)        
   real(r8), pointer :: onset_gddflag(:)        
   real(r8), pointer :: onset_fdd(:)            
   real(r8), pointer :: onset_gdd(:)            
   real(r8), pointer :: onset_swi(:)            
   real(r8), pointer :: offset_flag(:)          
   real(r8), pointer :: offset_counter(:)       
   real(r8), pointer :: offset_fdd(:)           
   real(r8), pointer :: offset_swi(:)           
   real(r8), pointer :: lgsf(:)                 
   real(r8), pointer :: bglfr(:)                
   real(r8), pointer :: bgtr(:)                 
   real(r8), pointer :: dayl(:)                 
   real(r8), pointer :: prev_dayl(:)            
   real(r8), pointer :: annavg_t2m(:)           
   real(r8), pointer :: tempavg_t2m(:)          
   real(r8), pointer :: gpp(:)                  
   real(r8), pointer :: availc(:)               
   real(r8), pointer :: xsmrpool_recover(:)     
   real(r8), pointer :: xsmrpool_c13ratio(:)    
   real(r8), pointer :: alloc_pnow(:)           
   real(r8), pointer :: c_allometry(:)          
   real(r8), pointer :: n_allometry(:)          
   real(r8), pointer :: plant_ndemand(:)        
   real(r8), pointer :: tempsum_plant_ndemand(:)
   real(r8), pointer :: annsum_plant_ndemand(:) 
   real(r8), pointer :: tempsum_retransn(:)     
   real(r8), pointer :: annsum_retransn(:)      
   real(r8), pointer :: avail_retransn(:)       
   real(r8), pointer :: plant_nalloc(:)         
   real(r8), pointer :: plant_calloc(:)         
   real(r8), pointer :: excess_cflux(:)         
   real(r8), pointer :: downreg(:)              
   real(r8), pointer :: prev_leafc_to_litter(:) 
   real(r8), pointer :: prev_frootc_to_litter(:)
   real(r8), pointer :: tempsum_npp(:)          
   real(r8), pointer :: annsum_npp(:)           
	real(r8), pointer :: rc13_canair(:)          
   real(r8), pointer :: rc13_psnsun(:)          
   real(r8), pointer :: rc13_psnsha(:)          
end type pft_epv_type                        




type, public :: pft_estate_type
   real(r8), pointer :: t_ref2m(:)          
   real(r8), pointer :: t_ref2m_min(:)      
   real(r8), pointer :: t_ref2m_max(:)      
   real(r8), pointer :: t_ref2m_min_inst(:) 
   real(r8), pointer :: t_ref2m_max_inst(:) 
   real(r8), pointer :: q_ref2m(:)          
   real(r8), pointer :: t_veg(:)            
end type pft_estate_type




type, public :: pft_wstate_type
   real(r8), pointer ::	h2ocan(:)         
end type pft_wstate_type




type, public :: pft_cstate_type
   real(r8), pointer :: leafc(:)              
   real(r8), pointer :: leafc_storage(:)      
   real(r8), pointer :: leafc_xfer(:)         
   real(r8), pointer :: frootc(:)             
   real(r8), pointer :: frootc_storage(:)     
   real(r8), pointer :: frootc_xfer(:)        
   real(r8), pointer :: livestemc(:)          
   real(r8), pointer :: livestemc_storage(:)  
   real(r8), pointer :: livestemc_xfer(:)     
   real(r8), pointer :: deadstemc(:)          
   real(r8), pointer :: deadstemc_storage(:)  
   real(r8), pointer :: deadstemc_xfer(:)     
   real(r8), pointer :: livecrootc(:)         
   real(r8), pointer :: livecrootc_storage(:) 
   real(r8), pointer :: livecrootc_xfer(:)    
   real(r8), pointer :: deadcrootc(:)         
   real(r8), pointer :: deadcrootc_storage(:) 
   real(r8), pointer :: deadcrootc_xfer(:)    
   real(r8), pointer :: gresp_storage(:)      
   real(r8), pointer :: gresp_xfer(:)         
   real(r8), pointer :: cpool(:)              
   real(r8), pointer :: xsmrpool(:)           
   real(r8), pointer :: pft_ctrunc(:)         
   
   real(r8), pointer :: dispvegc(:)           
   real(r8), pointer :: storvegc(:)           
   real(r8), pointer :: totvegc(:)            
   real(r8), pointer :: totpftc(:)            
end type pft_cstate_type




type, public :: pft_nstate_type
   real(r8), pointer :: leafn(:)              
   real(r8), pointer :: leafn_storage(:)      
   real(r8), pointer :: leafn_xfer(:)         
   real(r8), pointer :: frootn(:)             
   real(r8), pointer :: frootn_storage(:)     
   real(r8), pointer :: frootn_xfer(:)        
   real(r8), pointer :: livestemn(:)          
   real(r8), pointer :: livestemn_storage(:)  
   real(r8), pointer :: livestemn_xfer(:)     
   real(r8), pointer :: deadstemn(:)          
   real(r8), pointer :: deadstemn_storage(:)  
   real(r8), pointer :: deadstemn_xfer(:)     
   real(r8), pointer :: livecrootn(:)         
   real(r8), pointer :: livecrootn_storage(:) 
   real(r8), pointer :: livecrootn_xfer(:)    
   real(r8), pointer :: deadcrootn(:)         
   real(r8), pointer :: deadcrootn_storage(:) 
   real(r8), pointer :: deadcrootn_xfer(:)    
   real(r8), pointer :: retransn(:)           
   real(r8), pointer :: npool(:)              
   real(r8), pointer :: pft_ntrunc(:)         
   
   real(r8), pointer :: dispvegn(:)           
   real(r8), pointer :: storvegn(:)           
   real(r8), pointer :: totvegn(:)            
   real(r8), pointer :: totpftn(:)            
end type pft_nstate_type




type, public :: pft_vstate_type
   real(r8), pointer :: dummy_entry(:)
end type pft_vstate_type




type, public :: pft_dgvstate_type
   real(r8), pointer :: agdd0(:)               
   real(r8), pointer :: agdd5(:)               
   real(r8), pointer :: agddtw(:)              
   real(r8), pointer :: agdd(:)                
   real(r8), pointer :: t10(:)                 
   real(r8), pointer :: t_mo(:)                
   real(r8), pointer :: t_mo_min(:)            
   real(r8), pointer :: fnpsn10(:)             
   real(r8), pointer :: prec365(:)             
   real(r8), pointer :: agdd20(:)              
   real(r8), pointer :: tmomin20(:)            
   real(r8), pointer :: t10min(:)              
   real(r8), pointer :: tsoi25(:)              
   real(r8), pointer :: annpsn(:)              
   real(r8), pointer :: annpsnpot(:)           
   logical , pointer :: present(:)             
   real(r8), pointer :: dphen(:)               
   real(r8), pointer :: leafon(:)              
   real(r8), pointer :: leafof(:)              
   real(r8), pointer :: nind(:)                
   real(r8), pointer :: lm_ind(:)              
   real(r8), pointer :: sm_ind(:)              
   real(r8), pointer :: hm_ind(:)              
   real(r8), pointer :: rm_ind(:)              
   real(r8), pointer :: lai_ind(:)             
   real(r8), pointer :: fpcinc(:)              
   real(r8), pointer :: fpcgrid(:)             
   real(r8), pointer :: crownarea(:)           
   real(r8), pointer :: bm_inc(:)              
   real(r8), pointer :: afmicr(:)              
   real(r8), pointer :: firelength(:)          
   real(r8), pointer :: litterag(:)            
   real(r8), pointer :: litterbg(:)            
   real(r8), pointer :: cpool_fast(:)          
   real(r8), pointer :: cpool_slow(:)          
   real(r8), pointer :: k_fast_ave(:)          
   real(r8), pointer :: k_slow_ave(:)          
   real(r8), pointer :: litter_decom_ave(:)    
   real(r8), pointer :: turnover_ind(:)        
end type pft_dgvstate_type




type, public :: pft_eflux_type
   real(r8), pointer :: sabg(:) 	     
   real(r8), pointer :: sabv(:) 	     
   real(r8), pointer :: fsa(:) 		     
   real(r8), pointer :: fsr(:) 		     
   real(r8), pointer :: parsun(:)            
   real(r8), pointer :: parsha(:)            
   real(r8), pointer :: dlrad(:)             
   real(r8), pointer :: ulrad(:)             
   real(r8), pointer :: eflx_lh_tot(:) 	     
   real(r8), pointer :: eflx_lh_grnd(:)      
   real(r8), pointer :: eflx_soil_grnd(:)    
   real(r8), pointer :: eflx_sh_tot(:)       
   real(r8), pointer :: eflx_sh_grnd(:)      
   real(r8), pointer :: eflx_sh_veg(:)       
   real(r8), pointer :: eflx_lh_vege(:)      
   real(r8), pointer :: eflx_lh_vegt(:)      
   real(r8), pointer :: cgrnd(:)             
   real(r8), pointer :: cgrndl(:)            
   real(r8), pointer :: cgrnds(:)            
   real(r8), pointer :: eflx_gnet(:)         
   real(r8), pointer :: dgnetdT(:)           
   real(r8), pointer :: eflx_lwrad_out(:)    
   real(r8), pointer :: eflx_lwrad_net(:)    
   real(r8), pointer :: fsds_vis_d(:)        
   real(r8), pointer :: fsds_nir_d(:)        
   real(r8), pointer :: fsds_vis_i(:)        
   real(r8), pointer :: fsds_nir_i(:)        
   real(r8), pointer :: fsr_vis_d(:)         
   real(r8), pointer :: fsr_nir_d(:)         
   real(r8), pointer :: fsr_vis_i(:)         
   real(r8), pointer :: fsr_nir_i(:)         
   real(r8), pointer :: fsds_vis_d_ln(:)     
   real(r8), pointer :: fsds_nir_d_ln(:)     
   real(r8), pointer :: fsr_vis_d_ln(:)      
   real(r8), pointer :: fsr_nir_d_ln(:)      
	real(r8), pointer :: sun_add(:,:)   
	real(r8), pointer :: tot_aid(:,:)   
	real(r8), pointer :: sun_aid(:,:)   
	real(r8), pointer :: sun_aii(:,:)   
	real(r8), pointer :: sha_aid(:,:)   
	real(r8), pointer :: sha_aii(:,:)   
	real(r8), pointer :: sun_atot(:,:)  
	real(r8), pointer :: sha_atot(:,:)  
	real(r8), pointer :: sun_alf(:,:)   
	real(r8), pointer :: sha_alf(:,:)   
	real(r8), pointer :: sun_aperlai(:,:) 
	real(r8), pointer :: sha_aperlai(:,:) 
end type pft_eflux_type




type, public :: pft_mflux_type
   real(r8),pointer ::  taux(:)           
   real(r8),pointer ::  tauy(:)           
end type pft_mflux_type




type, public :: pft_wflux_type
   real(r8), pointer :: qflx_prec_intr(:) 
   real(r8), pointer :: qflx_prec_grnd(:) 
   real(r8), pointer :: qflx_rain_grnd(:) 
   real(r8), pointer :: qflx_snow_grnd(:) 
   real(r8), pointer :: qflx_snowcap(:)   
   real(r8), pointer :: qflx_evap_veg(:)  
   real(r8), pointer :: qflx_tran_veg(:)  
   real(r8), pointer :: qflx_evap_can(:)  
   real(r8), pointer :: qflx_evap_soi(:)  
   real(r8), pointer :: qflx_evap_tot(:)  
   real(r8), pointer :: qflx_evap_grnd(:) 
   real(r8), pointer :: qflx_dew_grnd(:)  
   real(r8), pointer :: qflx_sub_snow(:)  
   real(r8), pointer :: qflx_dew_snow(:)  
end type pft_wflux_type




type, public :: pft_cflux_type
   real(r8), pointer ::	psnsun(:) 	  
   real(r8), pointer ::	psnsha(:) 	  
   real(r8), pointer ::	fpsn(:) 	  
   
   
   
   real(r8), pointer ::	frm(:) 		  
   real(r8), pointer ::	frmf(:) 	  
   real(r8), pointer ::	frms(:) 	  
   real(r8), pointer ::	frmr(:) 	  
   real(r8), pointer ::	frg(:) 		  
   real(r8), pointer ::	dmi(:) 		  
   real(r8), pointer ::	fco2(:) 	  
   real(r8), pointer ::	fmicr(:) 	  
   
   
   real(r8), pointer :: m_leafc_to_litter(:)                 
   real(r8), pointer :: m_leafc_storage_to_litter(:)         
   real(r8), pointer :: m_leafc_xfer_to_litter(:)            
   real(r8), pointer :: m_frootc_to_litter(:)                
   real(r8), pointer :: m_frootc_storage_to_litter(:)        
   real(r8), pointer :: m_frootc_xfer_to_litter(:)           
   real(r8), pointer :: m_livestemc_to_litter(:)             
   real(r8), pointer :: m_livestemc_storage_to_litter(:)     
   real(r8), pointer :: m_livestemc_xfer_to_litter(:)        
   real(r8), pointer :: m_deadstemc_to_litter(:)             
   real(r8), pointer :: m_deadstemc_storage_to_litter(:)     
   real(r8), pointer :: m_deadstemc_xfer_to_litter(:)        
   real(r8), pointer :: m_livecrootc_to_litter(:)            
   real(r8), pointer :: m_livecrootc_storage_to_litter(:)    
   real(r8), pointer :: m_livecrootc_xfer_to_litter(:)       
   real(r8), pointer :: m_deadcrootc_to_litter(:)            
   real(r8), pointer :: m_deadcrootc_storage_to_litter(:)    
   real(r8), pointer :: m_deadcrootc_xfer_to_litter(:)       
   real(r8), pointer :: m_gresp_storage_to_litter(:)         
   real(r8), pointer :: m_gresp_xfer_to_litter(:)            
   
   real(r8), pointer :: m_leafc_to_fire(:)                   
   real(r8), pointer :: m_leafc_storage_to_fire(:)           
   real(r8), pointer :: m_leafc_xfer_to_fire(:)              
   real(r8), pointer :: m_frootc_to_fire(:)                  
   real(r8), pointer :: m_frootc_storage_to_fire(:)          
   real(r8), pointer :: m_frootc_xfer_to_fire(:)             
   real(r8), pointer :: m_livestemc_to_fire(:)               
   real(r8), pointer :: m_livestemc_storage_to_fire(:)       
   real(r8), pointer :: m_livestemc_xfer_to_fire(:)          
   real(r8), pointer :: m_deadstemc_to_fire(:)               
   real(r8), pointer :: m_deadstemc_to_litter_fire(:)        
   real(r8), pointer :: m_deadstemc_storage_to_fire(:)       
   real(r8), pointer :: m_deadstemc_xfer_to_fire(:)          
   real(r8), pointer :: m_livecrootc_to_fire(:)              
   real(r8), pointer :: m_livecrootc_storage_to_fire(:)      
   real(r8), pointer :: m_livecrootc_xfer_to_fire(:)         
   real(r8), pointer :: m_deadcrootc_to_fire(:)              
   real(r8), pointer :: m_deadcrootc_to_litter_fire(:)       
   real(r8), pointer :: m_deadcrootc_storage_to_fire(:)      
   real(r8), pointer :: m_deadcrootc_xfer_to_fire(:)         
   real(r8), pointer :: m_gresp_storage_to_fire(:)           
   real(r8), pointer :: m_gresp_xfer_to_fire(:)              
   
   real(r8), pointer :: leafc_xfer_to_leafc(:)               
   real(r8), pointer :: frootc_xfer_to_frootc(:)             
   real(r8), pointer :: livestemc_xfer_to_livestemc(:)       
   real(r8), pointer :: deadstemc_xfer_to_deadstemc(:)       
   real(r8), pointer :: livecrootc_xfer_to_livecrootc(:)     
   real(r8), pointer :: deadcrootc_xfer_to_deadcrootc(:)     
   
   real(r8), pointer :: leafc_to_litter(:)                   
   real(r8), pointer :: frootc_to_litter(:)                  
   
   real(r8), pointer :: leaf_mr(:)                           
   real(r8), pointer :: froot_mr(:)                          
   real(r8), pointer :: livestem_mr(:)                       
   real(r8), pointer :: livecroot_mr(:)                      
   real(r8), pointer :: leaf_curmr(:)                        
   real(r8), pointer :: froot_curmr(:)                       
   real(r8), pointer :: livestem_curmr(:)                    
   real(r8), pointer :: livecroot_curmr(:)                   
   real(r8), pointer :: leaf_xsmr(:)                         
   real(r8), pointer :: froot_xsmr(:)                        
   real(r8), pointer :: livestem_xsmr(:)                     
   real(r8), pointer :: livecroot_xsmr(:)                    
   
   real(r8), pointer :: psnsun_to_cpool(:)                   
   real(r8), pointer :: psnshade_to_cpool(:)                 
   
   real(r8), pointer :: cpool_to_xsmrpool(:)                 
   real(r8), pointer :: cpool_to_leafc(:)                    
   real(r8), pointer :: cpool_to_leafc_storage(:)            
   real(r8), pointer :: cpool_to_frootc(:)                   
   real(r8), pointer :: cpool_to_frootc_storage(:)           
   real(r8), pointer :: cpool_to_livestemc(:)                
   real(r8), pointer :: cpool_to_livestemc_storage(:)        
   real(r8), pointer :: cpool_to_deadstemc(:)                
   real(r8), pointer :: cpool_to_deadstemc_storage(:)        
   real(r8), pointer :: cpool_to_livecrootc(:)               
   real(r8), pointer :: cpool_to_livecrootc_storage(:)       
   real(r8), pointer :: cpool_to_deadcrootc(:)               
   real(r8), pointer :: cpool_to_deadcrootc_storage(:)       
   real(r8), pointer :: cpool_to_gresp_storage(:)            
   
   real(r8), pointer :: cpool_leaf_gr(:)                     
   real(r8), pointer :: cpool_leaf_storage_gr(:)             
   real(r8), pointer :: transfer_leaf_gr(:)                  
   real(r8), pointer :: cpool_froot_gr(:)                    
   real(r8), pointer :: cpool_froot_storage_gr(:)            
   real(r8), pointer :: transfer_froot_gr(:)                 
   real(r8), pointer :: cpool_livestem_gr(:)                 
   real(r8), pointer :: cpool_livestem_storage_gr(:)         
   real(r8), pointer :: transfer_livestem_gr(:)              
   real(r8), pointer :: cpool_deadstem_gr(:)                 
   real(r8), pointer :: cpool_deadstem_storage_gr(:)         
   real(r8), pointer :: transfer_deadstem_gr(:)              
   real(r8), pointer :: cpool_livecroot_gr(:)                
   real(r8), pointer :: cpool_livecroot_storage_gr(:)        
   real(r8), pointer :: transfer_livecroot_gr(:)             
   real(r8), pointer :: cpool_deadcroot_gr(:)                
   real(r8), pointer :: cpool_deadcroot_storage_gr(:)        
   real(r8), pointer :: transfer_deadcroot_gr(:)             
   
   real(r8), pointer :: leafc_storage_to_xfer(:)             
   real(r8), pointer :: frootc_storage_to_xfer(:)            
   real(r8), pointer :: livestemc_storage_to_xfer(:)         
   real(r8), pointer :: deadstemc_storage_to_xfer(:)         
   real(r8), pointer :: livecrootc_storage_to_xfer(:)        
   real(r8), pointer :: deadcrootc_storage_to_xfer(:)        
   real(r8), pointer :: gresp_storage_to_xfer(:)             
   
   real(r8), pointer :: livestemc_to_deadstemc(:)            
   real(r8), pointer :: livecrootc_to_deadcrootc(:)          
   
   real(r8), pointer :: gpp(:)            
   real(r8), pointer :: mr(:)             
   real(r8), pointer :: current_gr(:)     
   real(r8), pointer :: transfer_gr(:)    
   real(r8), pointer :: storage_gr(:)     
   real(r8), pointer :: gr(:)             
   real(r8), pointer :: ar(:)             
   real(r8), pointer :: rr(:)             
   real(r8), pointer :: npp(:)            
   real(r8), pointer :: agnpp(:)          
   real(r8), pointer :: bgnpp(:)          
   real(r8), pointer :: litfall(:)        
   real(r8), pointer :: vegfire(:)        
   real(r8), pointer :: pft_cinputs(:)    
   real(r8), pointer :: pft_coutputs(:)   
   
   real(r8), pointer :: pft_fire_closs(:) 
end type pft_cflux_type




type, public :: pft_nflux_type
   
   
   real(r8), pointer :: m_leafn_to_litter(:)                
   real(r8), pointer :: m_frootn_to_litter(:)               
   real(r8), pointer :: m_leafn_storage_to_litter(:)        
   real(r8), pointer :: m_frootn_storage_to_litter(:)       
   real(r8), pointer :: m_livestemn_storage_to_litter(:)    
   real(r8), pointer :: m_deadstemn_storage_to_litter(:)    
   real(r8), pointer :: m_livecrootn_storage_to_litter(:)   
   real(r8), pointer :: m_deadcrootn_storage_to_litter(:)   
   real(r8), pointer :: m_leafn_xfer_to_litter(:)           
   real(r8), pointer :: m_frootn_xfer_to_litter(:)          
   real(r8), pointer :: m_livestemn_xfer_to_litter(:)       
   real(r8), pointer :: m_deadstemn_xfer_to_litter(:)       
   real(r8), pointer :: m_livecrootn_xfer_to_litter(:)      
   real(r8), pointer :: m_deadcrootn_xfer_to_litter(:)      
   real(r8), pointer :: m_livestemn_to_litter(:)            
   real(r8), pointer :: m_deadstemn_to_litter(:)            
   real(r8), pointer :: m_livecrootn_to_litter(:)           
   real(r8), pointer :: m_deadcrootn_to_litter(:)           
   real(r8), pointer :: m_retransn_to_litter(:)             
   
   real(r8), pointer :: m_leafn_to_fire(:)                  
   real(r8), pointer :: m_leafn_storage_to_fire(:)          
   real(r8), pointer :: m_leafn_xfer_to_fire(:)             
   real(r8), pointer :: m_frootn_to_fire(:)                 
   real(r8), pointer :: m_frootn_storage_to_fire(:)         
   real(r8), pointer :: m_frootn_xfer_to_fire(:)            
   real(r8), pointer :: m_livestemn_to_fire(:)              
   real(r8), pointer :: m_livestemn_storage_to_fire(:)      
   real(r8), pointer :: m_livestemn_xfer_to_fire(:)         
   real(r8), pointer :: m_deadstemn_to_fire(:)              
   real(r8), pointer :: m_deadstemn_to_litter_fire(:)       
   real(r8), pointer :: m_deadstemn_storage_to_fire(:)      
   real(r8), pointer :: m_deadstemn_xfer_to_fire(:)         
   real(r8), pointer :: m_livecrootn_to_fire(:)             
   real(r8), pointer :: m_livecrootn_storage_to_fire(:)     
   real(r8), pointer :: m_livecrootn_xfer_to_fire(:)        
   real(r8), pointer :: m_deadcrootn_to_fire(:)             
   real(r8), pointer :: m_deadcrootn_to_litter_fire(:)      
   real(r8), pointer :: m_deadcrootn_storage_to_fire(:)     
   real(r8), pointer :: m_deadcrootn_xfer_to_fire(:)        
   real(r8), pointer :: m_retransn_to_fire(:)               
   
   real(r8), pointer :: leafn_xfer_to_leafn(:)              
   real(r8), pointer :: frootn_xfer_to_frootn(:)            
   real(r8), pointer :: livestemn_xfer_to_livestemn(:)      
   real(r8), pointer :: deadstemn_xfer_to_deadstemn(:)      
   real(r8), pointer :: livecrootn_xfer_to_livecrootn(:)    
   real(r8), pointer :: deadcrootn_xfer_to_deadcrootn(:)    
   
   real(r8), pointer :: leafn_to_litter(:)                  
   real(r8), pointer :: leafn_to_retransn(:)                
   real(r8), pointer :: frootn_to_litter(:)                 
   
   real(r8), pointer :: retransn_to_npool(:)                
   real(r8), pointer :: sminn_to_npool(:)                   
   real(r8), pointer :: npool_to_leafn(:)                   
   real(r8), pointer :: npool_to_leafn_storage(:)           
   real(r8), pointer :: npool_to_frootn(:)                  
   real(r8), pointer :: npool_to_frootn_storage(:)          
   real(r8), pointer :: npool_to_livestemn(:)               
   real(r8), pointer :: npool_to_livestemn_storage(:)       
   real(r8), pointer :: npool_to_deadstemn(:)               
   real(r8), pointer :: npool_to_deadstemn_storage(:)       
   real(r8), pointer :: npool_to_livecrootn(:)              
   real(r8), pointer :: npool_to_livecrootn_storage(:)      
   real(r8), pointer :: npool_to_deadcrootn(:)              
   real(r8), pointer :: npool_to_deadcrootn_storage(:)      
   
   real(r8), pointer :: leafn_storage_to_xfer(:)            
   real(r8), pointer :: frootn_storage_to_xfer(:)           
   real(r8), pointer :: livestemn_storage_to_xfer(:)        
   real(r8), pointer :: deadstemn_storage_to_xfer(:)        
   real(r8), pointer :: livecrootn_storage_to_xfer(:)       
   real(r8), pointer :: deadcrootn_storage_to_xfer(:)       
   
   real(r8), pointer :: livestemn_to_deadstemn(:)           
   real(r8), pointer :: livestemn_to_retransn(:)            
   real(r8), pointer :: livecrootn_to_deadcrootn(:)         
   real(r8), pointer :: livecrootn_to_retransn(:)           
   
   real(r8), pointer :: ndeploy(:)                          
   real(r8), pointer :: pft_ninputs(:)                      
   real(r8), pointer :: pft_noutputs(:)                     
   
   real(r8), pointer :: pft_fire_nloss(:)                   
end type pft_nflux_type




type, public :: pft_vflux_type
   real(r8), pointer :: vocflx_tot(:)     
   real(r8), pointer :: vocflx(:,:)       
   real(r8), pointer :: vocflx_1(:)       
   real(r8), pointer :: vocflx_2(:)       
   real(r8), pointer :: vocflx_3(:)       
   real(r8), pointer :: vocflx_4(:)       
   real(r8), pointer :: vocflx_5(:)       
end type pft_vflux_type




type, public :: pft_dflux_type
   real(r8), pointer :: flx_mss_vrt_dst(:,:)    
   real(r8), pointer :: flx_mss_vrt_dst_tot(:)  
   real(r8), pointer :: vlc_trb(:,:)            
   real(r8), pointer :: vlc_trb_1(:) 	        
   real(r8), pointer :: vlc_trb_2(:) 	        
   real(r8), pointer :: vlc_trb_3(:) 	        
   real(r8), pointer :: vlc_trb_4(:) 	        
end type pft_dflux_type













type, public :: column_pstate_type
   type(pft_pstate_type) :: pps_a            
   integer , pointer :: snl(:)  	      
   integer , pointer :: isoicol(:) 	      
   real(r8), pointer :: bsw(:,:)              
   real(r8), pointer :: watsat(:,:)           
   real(r8), pointer :: watdry(:,:)           
   real(r8), pointer :: watopt(:,:)           
   real(r8), pointer :: hksat(:,:)            
   real(r8), pointer :: sucsat(:,:)           
   real(r8), pointer :: hkdepth(:)            
   real(r8), pointer :: wtfact(:)             
   real(r8), pointer :: fracice(:,:)          
   real(r8), pointer :: csol(:,:)             
   real(r8), pointer :: tkmg(:,:)             
   real(r8), pointer :: tkdry(:,:)            
   real(r8), pointer :: tksatu(:,:)           
   real(r8), pointer :: smpmin(:) 	      
   real(r8), pointer :: gwc_thr(:) 	      
   real(r8), pointer :: mss_frc_cly_vld(:)    
   real(r8), pointer :: mbl_bsn_fct(:) 	      
   logical , pointer :: do_capsnow(:)         
   real(r8), pointer :: snowdp(:) 	      
   real(r8), pointer :: snowage(:)	      
   real(r8), pointer :: frac_sno(:) 	      
   real(r8), pointer :: zi(:,:)               
   real(r8), pointer :: dz(:,:)               
   real(r8), pointer :: z(:,:)                
   real(r8), pointer :: frac_iceold(:,:)      
   integer , pointer :: imelt(:,:)            
   real(r8), pointer :: eff_porosity(:,:)     
   real(r8), pointer :: emg(:) 		      
   real(r8), pointer :: z0mg(:) 	      
   real(r8), pointer :: z0hg(:) 	      
   real(r8), pointer :: z0qg(:) 	      
   real(r8), pointer :: htvp(:) 	      
   real(r8), pointer :: beta(:) 	      
   real(r8), pointer :: zii(:) 		      
   real(r8), pointer :: albgrd(:,:)           
   real(r8), pointer :: albgri(:,:)           
   real(r8), pointer :: rootr_column(:,:)     
   real(r8), pointer :: wf(:)                 
   
   real(r8), pointer :: bsw2(:,:)        
   real(r8), pointer :: psisat(:,:)        
   real(r8), pointer :: vwcsat(:,:)        
   real(r8), pointer :: decl(:)              
   real(r8), pointer :: coszen(:)				
   real(r8), pointer :: soilpsi(:,:)		 
   real(r8), pointer :: fpi(:)           
   real(r8), pointer :: fpg(:)           
   real(r8), pointer :: annsum_counter(:) 
   real(r8), pointer :: cannsum_npp(:)    
   
   real(r8), pointer :: me(:)               
   real(r8), pointer :: fire_prob(:)        
   real(r8), pointer :: mean_fire_prob(:)   
   real(r8), pointer :: fireseasonl(:)      
   real(r8), pointer :: farea_burned(:)     
   real(r8), pointer :: ann_farea_burned(:) 
   
   real(r8), pointer :: ws(:)              
   real(r8), pointer :: ks(:)              
   real(r8), pointer :: dz_lake(:,:)       
   real(r8), pointer :: z_lake(:,:)        
   real(r8), pointer :: savedtke1(:)       
   real(r8), pointer :: lakedepth(:)       
   
end type column_pstate_type




type, public :: column_estate_type
   type(pft_estate_type):: pes_a	      
   real(r8), pointer :: t_grnd(:)  	      
   real(r8), pointer :: dt_grnd(:)	      
   real(r8), pointer :: t_soisno(:,:)         
   real(r8), pointer :: t_lake(:,:)           
   real(r8), pointer :: tssbef(:,:)           
   real(r8), pointer :: t_snow(:) 	      
   real(r8), pointer :: thv(:)        	      
   real(r8), pointer :: thm(:) 		      
end type column_estate_type




type, public :: column_wstate_type
   type(pft_wstate_type):: pws_a             
   real(r8), pointer :: h2osno(:)             
   real(r8), pointer :: h2osoi_liq(:,:)       
   real(r8), pointer :: h2osoi_ice(:,:)       
   real(r8), pointer :: h2osoi_vol(:,:)       
   real(r8), pointer :: h2osno_old(:)         
   real(r8), pointer :: qg(:)                 
   real(r8), pointer :: dqgdT(:)              
   real(r8), pointer :: snowice(:)            
   real(r8), pointer :: snowliq(:)            
   real(r8) ,pointer :: soilalpha(:)          
   real(r8), pointer :: zwt(:)                
   real(r8), pointer :: fcov(:)               
   real(r8), pointer :: wa(:)                 
   real(r8), pointer :: wt(:)                 
   real(r8), pointer :: qcharge(:)            
   
   real(r8), pointer :: lake_icefrac(:,:)     
   
end type column_wstate_type




type, public :: column_cstate_type
   type(pft_cstate_type):: pcs_a	
   
   
   real(r8), pointer :: soilc(:) 	
   
   real(r8), pointer :: cwdc(:)               
   real(r8), pointer :: litr1c(:)             
   real(r8), pointer :: litr2c(:)             
   real(r8), pointer :: litr3c(:)             
   real(r8), pointer :: soil1c(:)             
   real(r8), pointer :: soil2c(:)             
   real(r8), pointer :: soil3c(:)             
   real(r8), pointer :: soil4c(:)             
   real(r8), pointer :: col_ctrunc(:)         
   
   real(r8), pointer :: totlitc(:)            
   real(r8), pointer :: totsomc(:)            
   real(r8), pointer :: totecosysc(:)         
   real(r8), pointer :: totcolc(:)            
   
end type column_cstate_type




type, public :: column_nstate_type
   type(pft_nstate_type):: pns_a	
   
   real(r8), pointer :: cwdn(:)               
   real(r8), pointer :: litr1n(:)             
   real(r8), pointer :: litr2n(:)             
   real(r8), pointer :: litr3n(:)             
   real(r8), pointer :: soil1n(:)             
   real(r8), pointer :: soil2n(:)             
   real(r8), pointer :: soil3n(:)             
   real(r8), pointer :: soil4n(:)             
   real(r8), pointer :: sminn(:)              
   real(r8), pointer :: col_ntrunc(:)         
   
   real(r8), pointer :: totlitn(:)            
   real(r8), pointer :: totsomn(:)            
   real(r8), pointer :: totecosysn(:)         
   real(r8), pointer :: totcoln(:)            
end type column_nstate_type




type, public :: column_vstate_type
   type(pft_vstate_type):: pvs_a	
end type column_vstate_type




type, public :: column_dgvstate_type
   type(pft_dgvstate_type):: pdgvs_a
end type column_dgvstate_type




type, public :: column_dstate_type
   real(r8), pointer :: dummy_entry(:)
end type column_dstate_type




type, public :: column_eflux_type
   type(pft_eflux_type):: pef_a	
   real(r8), pointer :: eflx_snomelt(:) 
   real(r8), pointer :: eflx_impsoil(:)	
end type column_eflux_type




type, public :: column_mflux_type
   type(pft_mflux_type)::  pmf_a    
end type column_mflux_type




type, public :: column_wflux_type
   type(pft_wflux_type):: pwf_a	
   real(r8), pointer :: qflx_infl(:)	
   real(r8), pointer :: qflx_surf(:)	
   real(r8), pointer :: qflx_drain(:) 	
   real(r8), pointer :: qflx_top_soil(:)
   real(r8), pointer :: qflx_snomelt(:) 
   real(r8), pointer :: qflx_qrgwl(:) 	
   real(r8), pointer :: qmelt(:) 	
   real(r8), pointer :: h2ocan_loss(:) 
end type column_wflux_type




type, public :: column_cflux_type
   type(pft_cflux_type):: pcf_a		
   
   
   real(r8), pointer :: m_leafc_to_litr1c(:)              
   real(r8), pointer :: m_leafc_to_litr2c(:)              
   real(r8), pointer :: m_leafc_to_litr3c(:)              
   real(r8), pointer :: m_frootc_to_litr1c(:)             
   real(r8), pointer :: m_frootc_to_litr2c(:)             
   real(r8), pointer :: m_frootc_to_litr3c(:)             
   real(r8), pointer :: m_leafc_storage_to_litr1c(:)      
   real(r8), pointer :: m_frootc_storage_to_litr1c(:)     
   real(r8), pointer :: m_livestemc_storage_to_litr1c(:)  
   real(r8), pointer :: m_deadstemc_storage_to_litr1c(:)  
   real(r8), pointer :: m_livecrootc_storage_to_litr1c(:) 
   real(r8), pointer :: m_deadcrootc_storage_to_litr1c(:) 
   real(r8), pointer :: m_leafc_xfer_to_litr1c(:)         
   real(r8), pointer :: m_frootc_xfer_to_litr1c(:)        
   real(r8), pointer :: m_livestemc_xfer_to_litr1c(:)     
   real(r8), pointer :: m_deadstemc_xfer_to_litr1c(:)     
   real(r8), pointer :: m_livecrootc_xfer_to_litr1c(:)    
   real(r8), pointer :: m_deadcrootc_xfer_to_litr1c(:)    
   real(r8), pointer :: m_livestemc_to_cwdc(:)            
   real(r8), pointer :: m_deadstemc_to_cwdc(:)            
   real(r8), pointer :: m_livecrootc_to_cwdc(:)           
   real(r8), pointer :: m_deadcrootc_to_cwdc(:)           
   real(r8), pointer :: m_gresp_storage_to_litr1c(:)      
   real(r8), pointer :: m_gresp_xfer_to_litr1c(:)         
	
   real(r8), pointer :: m_deadstemc_to_cwdc_fire(:)       
   real(r8), pointer :: m_deadcrootc_to_cwdc_fire(:)      
   real(r8), pointer :: m_litr1c_to_fire(:)               
   real(r8), pointer :: m_litr2c_to_fire(:)               
   real(r8), pointer :: m_litr3c_to_fire(:)               
   real(r8), pointer :: m_cwdc_to_fire(:)                 
   
   real(r8), pointer :: leafc_to_litr1c(:)                
   real(r8), pointer :: leafc_to_litr2c(:)                
   real(r8), pointer :: leafc_to_litr3c(:)                
   real(r8), pointer :: frootc_to_litr1c(:)               
   real(r8), pointer :: frootc_to_litr2c(:)               
   real(r8), pointer :: frootc_to_litr3c(:)               
   
   real(r8), pointer :: cwdc_to_litr2c(:)     
   real(r8), pointer :: cwdc_to_litr3c(:)     
   real(r8), pointer :: litr1_hr(:)           
   real(r8), pointer :: litr1c_to_soil1c(:)   
   real(r8), pointer :: litr2_hr(:)           
   real(r8), pointer :: litr2c_to_soil2c(:)   
   real(r8), pointer :: litr3_hr(:)           
   real(r8), pointer :: litr3c_to_soil3c(:)   
   real(r8), pointer :: soil1_hr(:)           
   real(r8), pointer :: soil1c_to_soil2c(:)   
   real(r8), pointer :: soil2_hr(:)           
   real(r8), pointer :: soil2c_to_soil3c(:)   
   real(r8), pointer :: soil3_hr(:)           
   real(r8), pointer :: soil3c_to_soil4c(:)   
   real(r8), pointer :: soil4_hr(:)           
   
   real(r8), pointer :: lithr(:)         
   real(r8), pointer :: somhr(:)         
   real(r8), pointer :: hr(:)            
   real(r8), pointer :: sr(:)            
   real(r8), pointer :: er(:)            
   real(r8), pointer :: litfire(:)       
   real(r8), pointer :: somfire(:)       
   real(r8), pointer :: totfire(:)       
   real(r8), pointer :: nep(:)           
   real(r8), pointer :: nee(:)           
   real(r8), pointer :: col_cinputs(:)   
   real(r8), pointer :: col_coutputs(:)  
   
   real(r8), pointer :: col_fire_closs(:) 
end type column_cflux_type




type, public :: column_nflux_type
   type(pft_nflux_type):: pnf_a	        
   
   
   real(r8), pointer :: ndep_to_sminn(:)                   
   real(r8), pointer :: nfix_to_sminn(:)                   
   
   real(r8), pointer :: m_leafn_to_litr1n(:)               
   real(r8), pointer :: m_leafn_to_litr2n(:)               
   real(r8), pointer :: m_leafn_to_litr3n(:)               
   real(r8), pointer :: m_frootn_to_litr1n(:)              
   real(r8), pointer :: m_frootn_to_litr2n(:)              
   real(r8), pointer :: m_frootn_to_litr3n(:)              
   real(r8), pointer :: m_leafn_storage_to_litr1n(:)       
   real(r8), pointer :: m_frootn_storage_to_litr1n(:)      
   real(r8), pointer :: m_livestemn_storage_to_litr1n(:)   
   real(r8), pointer :: m_deadstemn_storage_to_litr1n(:)   
   real(r8), pointer :: m_livecrootn_storage_to_litr1n(:)  
   real(r8), pointer :: m_deadcrootn_storage_to_litr1n(:)  
   real(r8), pointer :: m_leafn_xfer_to_litr1n(:)          
   real(r8), pointer :: m_frootn_xfer_to_litr1n(:)         
   real(r8), pointer :: m_livestemn_xfer_to_litr1n(:)      
   real(r8), pointer :: m_deadstemn_xfer_to_litr1n(:)      
   real(r8), pointer :: m_livecrootn_xfer_to_litr1n(:)     
   real(r8), pointer :: m_deadcrootn_xfer_to_litr1n(:)     
   real(r8), pointer :: m_livestemn_to_cwdn(:)             
   real(r8), pointer :: m_deadstemn_to_cwdn(:)             
   real(r8), pointer :: m_livecrootn_to_cwdn(:)            
   real(r8), pointer :: m_deadcrootn_to_cwdn(:)            
   real(r8), pointer :: m_retransn_to_litr1n(:)            
	
   real(r8), pointer :: m_deadstemn_to_cwdn_fire(:)        
   real(r8), pointer :: m_deadcrootn_to_cwdn_fire(:)       
   real(r8), pointer :: m_litr1n_to_fire(:)                
   real(r8), pointer :: m_litr2n_to_fire(:)                
   real(r8), pointer :: m_litr3n_to_fire(:)                
   real(r8), pointer :: m_cwdn_to_fire(:)                  
   
   real(r8), pointer :: leafn_to_litr1n(:)       
   real(r8), pointer :: leafn_to_litr2n(:)       
   real(r8), pointer :: leafn_to_litr3n(:)       
   real(r8), pointer :: frootn_to_litr1n(:)      
   real(r8), pointer :: frootn_to_litr2n(:)      
   real(r8), pointer :: frootn_to_litr3n(:)      
   
   real(r8), pointer :: cwdn_to_litr2n(:)        
   real(r8), pointer :: cwdn_to_litr3n(:)        
   real(r8), pointer :: litr1n_to_soil1n(:)      
   real(r8), pointer :: sminn_to_soil1n_l1(:)    
   real(r8), pointer :: litr2n_to_soil2n(:)      
   real(r8), pointer :: sminn_to_soil2n_l2(:)    
   real(r8), pointer :: litr3n_to_soil3n(:)      
   real(r8), pointer :: sminn_to_soil3n_l3(:)    
   real(r8), pointer :: soil1n_to_soil2n(:)      
   real(r8), pointer :: sminn_to_soil2n_s1(:)    
   real(r8), pointer :: soil2n_to_soil3n(:)      
   real(r8), pointer :: sminn_to_soil3n_s2(:)    
   real(r8), pointer :: soil3n_to_soil4n(:)      
   real(r8), pointer :: sminn_to_soil4n_s3(:)    
   real(r8), pointer :: soil4n_to_sminn(:)       
   
   real(r8), pointer :: sminn_to_denit_l1s1(:)   
   real(r8), pointer :: sminn_to_denit_l2s2(:)   
   real(r8), pointer :: sminn_to_denit_l3s3(:)   
   real(r8), pointer :: sminn_to_denit_s1s2(:)   
   real(r8), pointer :: sminn_to_denit_s2s3(:)   
   real(r8), pointer :: sminn_to_denit_s3s4(:)   
   real(r8), pointer :: sminn_to_denit_s4(:)     
   real(r8), pointer :: sminn_to_denit_excess(:) 
   
   real(r8), pointer :: sminn_leached(:)         
   
   real(r8), pointer :: potential_immob(:)       
   real(r8), pointer :: actual_immob(:)          
   real(r8), pointer :: sminn_to_plant(:)        
   real(r8), pointer :: supplement_to_sminn(:)   
   real(r8), pointer :: gross_nmin(:)            
   real(r8), pointer :: net_nmin(:)              
   real(r8), pointer :: denit(:)                 
   real(r8), pointer :: col_ninputs(:)           
   real(r8), pointer :: col_noutputs(:)          
   
   real(r8), pointer :: col_fire_nloss(:)        
end type column_nflux_type




type, public :: column_vflux_type
   type(pft_vflux_type):: pvf_a		
end type column_vflux_type




type, public :: column_dflux_type	
   type(pft_dflux_type):: pdf_a		
end type column_dflux_type














type, public :: landunit_pstate_type
   type(column_pstate_type):: cps_a             
end type landunit_pstate_type




type, public :: landunit_estate_type
   type(column_estate_type)::	ces_a	     
end type landunit_estate_type




type, public :: landunit_wstate_type
   type(column_wstate_type)::	cws_a	      
end type landunit_wstate_type




type, public :: landunit_cstate_type
   type(column_cstate_type)::	ccs_a	      
end type landunit_cstate_type




type, public :: landunit_nstate_type
   type(column_nstate_type)::	cns_a	      
end type landunit_nstate_type




type, public :: landunit_vstate_type
   type(column_vstate_type)::	cvs_a	      
end type landunit_vstate_type




type, public :: landunit_dgvstate_type
   real(r8):: dummy_entry
end type landunit_dgvstate_type




type, public :: landunit_dstate_type
   type(column_dstate_type)::	cds_a		
end type landunit_dstate_type




type, public :: landunit_eflux_type
   type(column_eflux_type)::	cef_a		
end type landunit_eflux_type




type, public :: landunit_mflux_type
   type(pft_mflux_type)::	pmf_a		
end type landunit_mflux_type




type, public :: landunit_wflux_type
   type(column_wflux_type)::	cwf_a		
end type landunit_wflux_type




type, public :: landunit_cflux_type
   type(column_cflux_type)::	ccf_a		
end type landunit_cflux_type




type, public :: landunit_nflux_type
   type(column_nflux_type)::	cnf_a		
end type landunit_nflux_type




type, public :: landunit_vflux_type
   type(pft_vflux_type)::	pvf_a		
end type landunit_vflux_type




type, public :: landunit_dflux_type
   type(pft_dflux_type)::	pdf_a		
end type landunit_dflux_type












type, public :: gridcell_pstate_type
   type(column_pstate_type):: cps_a   
end type gridcell_pstate_type




type, public :: gridcell_estate_type
   type(column_estate_type)::	ces_a	
end type gridcell_estate_type




type, public :: gridcell_wstate_type
   type(column_wstate_type)::	cws_a	
end type gridcell_wstate_type




type, public :: gridcell_cstate_type
   type(column_cstate_type)::	ccs_a	
end type gridcell_cstate_type




type, public :: gridcell_nstate_type
   type(column_nstate_type)::	cns_a	
end type gridcell_nstate_type




type, public :: gridcell_vstate_type
   type(column_vstate_type)::	cvs_a	
end type gridcell_vstate_type




type, public :: gridcell_dstate_type
   type(column_dstate_type)::	cds_a	
end type gridcell_dstate_type




type, public :: gridcell_dgvstate_type
   real(r8), pointer :: afirefrac(:)   
   real(r8), pointer :: acfluxfire(:)  
   real(r8), pointer :: bmfm(:,:)      
   real(r8), pointer :: afmicr(:,:)    
   real(r8), pointer :: begwater(:)
   real(r8), pointer :: endwater(:)
   real(r8), pointer :: begenergy(:)
   real(r8), pointer :: endenergy(:)
end type gridcell_dgvstate_type




type, public :: gridcell_eflux_type
   type(column_eflux_type)::	cef_a		
end type gridcell_eflux_type




type, public :: gridcell_mflux_type
   type(pft_mflux_type)::	pmf_a		
end type gridcell_mflux_type




type, public :: gridcell_wflux_type

   real(r8), pointer :: qchan2(:)               
   real(r8), pointer :: qchocn2(:)              

   type(column_wflux_type)::	cwf_a		
end type gridcell_wflux_type




type, public :: gridcell_cflux_type
   type(column_cflux_type)::	ccf_a		
end type gridcell_cflux_type




type, public :: gridcell_nflux_type
   type(column_nflux_type)::	cnf_a		
end type gridcell_nflux_type




type, public :: gridcell_vflux_type
   type(pft_vflux_type)::	pvf_a		
end type gridcell_vflux_type




type, public :: gridcell_dflux_type
   type(pft_dflux_type)::	pdf_a		
end type gridcell_dflux_type












type, public :: model_pstate_type
   type(column_pstate_type) ::	cps_a	
end type model_pstate_type




type, public :: model_estate_type
   type(column_estate_type)::	ces_a		
end type model_estate_type




type, public :: model_wstate_type
   type(column_wstate_type)::	cws_a		
end type model_wstate_type




type, public :: model_cstate_type
   type(column_cstate_type)::	ccs_a		
end type model_cstate_type




type, public :: model_nstate_type
   type(column_nstate_type)::	cns_a		
end type model_nstate_type




type, public :: model_vstate_type
   type(column_vstate_type)::	cvs_a		
end type model_vstate_type




type, public :: model_dstate_type
   type(column_dstate_type)::	cds_a		
end type model_dstate_type




type, public :: model_eflux_type
   type(column_eflux_type)::	cef_a		
end type model_eflux_type




type, public :: model_mflux_type
   type(pft_mflux_type)::	pmf_a		
end type model_mflux_type




type, public :: model_wflux_type
   type(column_wflux_type)::	cwf_a		
end type model_wflux_type




type, public :: model_cflux_type
   type(column_cflux_type)::	ccf_a		
end type model_cflux_type




type, public :: model_nflux_type
   type(column_nflux_type)::	cnf_a		
end type model_nflux_type




type, public :: model_vflux_type
   type(pft_vflux_type)::	pvf_a		
end type model_vflux_type




type, public :: model_dflux_type
   type(pft_dflux_type)::	pdf_a		
end type model_dflux_type














type, public :: pft_type

   
   integer, pointer :: column(:)        
   real(r8), pointer :: wtcol(:)	
   integer, pointer :: landunit(:)      
   real(r8), pointer :: wtlunit(:)      
   integer, pointer :: gridcell(:)      
   real(r8), pointer :: wtgcell(:)	

   
   integer , pointer :: itype(:)        
   integer , pointer :: mxy(:)          

   integer , pointer :: ixy(:)          
   integer , pointer :: jxy(:)          
   real(r8), pointer :: area(:)         


   
   type(energy_balance_type)   :: pebal 
   type(water_balance_type)    :: pwbal 
   type(carbon_balance_type)   :: pcbal 
   type(nitrogen_balance_type) :: pnbal 
   
   
   type(pft_dgvstate_type) :: pdgvs     
   
   
   type(pft_epv_type)    :: pepv        
   
   
   type(pft_pstate_type) :: pps         
   type(pft_estate_type) :: pes         
   type(pft_wstate_type) :: pws         
   type(pft_cstate_type) :: pcs         
   type(pft_nstate_type) :: pns         
   type(pft_vstate_type) :: pvs         

   
   type(pft_eflux_type)  :: pef         
   type(pft_mflux_type)  :: pmf         
   type(pft_wflux_type)  :: pwf         
   type(pft_cflux_type)  :: pcf         
   type(pft_nflux_type)  :: pnf         
   type(pft_vflux_type)  :: pvf         
   type(pft_dflux_type)  :: pdf         
   
   
   
   type(pft_cstate_type) :: pc13s       
   type(pft_cflux_type)  :: pc13f       
   
end type pft_type





type, public :: column_type

   type(pft_type)   :: p       

   
   integer , pointer :: landunit(:)     
   real(r8), pointer :: wtlunit(:) 	
   integer , pointer :: gridcell(:)     
   real(r8), pointer :: wtgcell(:) 	
   integer , pointer :: pfti(:)         
   integer , pointer :: pftf(:)         
   integer , pointer :: npfts(:)        

   integer , pointer :: ixy(:)          
   integer , pointer :: jxy(:)          
   real(r8), pointer :: area(:)         

  
   
   integer , pointer :: itype(:) 	

   
   type(energy_balance_type)   :: cebal 
   type(water_balance_type)    :: cwbal 
   type(carbon_balance_type)   :: ccbal 
   type(nitrogen_balance_type) :: cnbal 
   
   
   type(column_pstate_type) :: cps      
   type(column_estate_type) :: ces      
   type(column_wstate_type) :: cws      
   type(column_cstate_type) :: ccs      
   type(column_nstate_type) :: cns      
   type(column_vstate_type) :: cvs      
   type(column_dstate_type) :: cds      
   
   
   type(column_eflux_type) :: cef       
   type(column_mflux_type) :: cmf       
   type(column_wflux_type) :: cwf       
   type(column_cflux_type) :: ccf       
   type(column_nflux_type) :: cnf       
   type(column_vflux_type) :: cvf       
   type(column_dflux_type) :: cdf       

   
   type (column_dgvstate_type) :: cdgvs 
   
   
   
   type(column_cstate_type) :: cc13s    
   type(column_cflux_type)  :: cc13f    
   
end type column_type





type, public :: landunit_type

   type(column_type) :: c    

   
   integer , pointer :: gridcell(:)     
   real(r8), pointer :: wtgcell(:)      
   integer , pointer :: coli(:)         
   integer , pointer :: colf(:)         
   integer , pointer :: ncolumns(:)     
   integer , pointer :: pfti(:)         
   integer , pointer :: pftf(:)         
   integer , pointer :: npfts(:)        
   
   
   integer , pointer :: itype(:) 	
   logical , pointer :: ifspecial(:)    
   logical , pointer :: lakpoi(:)	

   integer , pointer :: ixy(:)          
   integer , pointer :: jxy(:)          
   real(r8), pointer :: area(:)          


   
   type(energy_balance_type)   :: lebal 
   type(water_balance_type)    :: lwbal 
   type(carbon_balance_type)   :: lcbal 
   type(nitrogen_balance_type) :: lnbal 
   
   
   type(landunit_pstate_type) :: lps    
   type(landunit_estate_type) :: les    
   type(landunit_wstate_type) :: lws    
   type(landunit_cstate_type) :: lcs    
   type(landunit_nstate_type) :: lns    
   type(landunit_vstate_type) :: lvs    
   type(landunit_dstate_type) :: lds    
   
   
   type(landunit_eflux_type) :: lef     
   type(landunit_mflux_type) :: lmf     
   type(landunit_wflux_type) :: lwf     
   type(landunit_cflux_type) :: lcf     
   type(landunit_nflux_type) :: lnf     
   type(landunit_vflux_type) :: lvf     
   type(landunit_dflux_type) :: ldf     
end type landunit_type





type, public :: gridcell_type

   type(landunit_type) :: l	        

   
   integer, pointer :: luni(:)          
   integer, pointer :: lunf(:)          
   integer, pointer :: nlandunits(:)    
   integer, pointer :: coli(:)          
   integer, pointer :: colf(:)          
   integer, pointer :: ncolumns(:)      
   integer, pointer :: pfti(:)          
   integer, pointer :: pftf(:)          
   integer, pointer :: npfts(:)         

   
   real(r8), pointer :: area(:)         
   real(r8), pointer :: lat(:) 	        
   real(r8), pointer :: lon(:) 	        
   real(r8), pointer :: latdeg(:)       
   real(r8), pointer :: londeg(:)       
   real(r8), pointer :: lat_a(:) 	
   real(r8), pointer :: lon_a(:)        
   real(r8), pointer :: latdeg_a(:)     
   real(r8), pointer :: londeg_a(:)     

   integer , pointer :: ixy(:)          
   integer , pointer :: jxy(:)          

   
   type(energy_balance_type)   :: gebal 
   type(water_balance_type)    :: gwbal 
   type(carbon_balance_type)   :: gcbal 
   type(nitrogen_balance_type) :: gnbal 

   
   type(gridcell_dgvstate_type):: gdgvs 
   
   
   type(gridcell_pstate_type) :: gps    
   type(gridcell_estate_type) :: ges    
   type(gridcell_wstate_type) :: gws    
   type(gridcell_cstate_type) :: gcs    
   type(gridcell_nstate_type) :: gns    
   type(gridcell_vstate_type) :: gvs    
   type(gridcell_dstate_type) :: gds    
   
   
   type(gridcell_eflux_type) :: gef	
   type(gridcell_wflux_type) :: gwf	
   type(gridcell_cflux_type) :: gcf	
   type(gridcell_nflux_type) :: gnf	
   type(gridcell_vflux_type) :: gvf	
   type(gridcell_dflux_type) :: gdf	

end type gridcell_type





type, public :: model_type
   
   type(gridcell_type) :: g    
   integer  :: ngridcells      
   real(r8) :: area            

   
   type(energy_balance_type)   :: mebal 
   type(water_balance_type)    :: mwbal 
   type(carbon_balance_type)   :: mcbal 
   type(nitrogen_balance_type) :: mnbal 
   
   
   type(model_pstate_type) ::  mps      
   type(model_estate_type) ::  mes      
   type(model_wstate_type) ::  mws      
   type(model_cstate_type) ::  mcs      
   type(model_nstate_type) ::  mns      
   type(model_vstate_type) ::  mvs      
   type(model_dstate_type) ::  mds      
   
   
   type(model_eflux_type) ::   mef      
   type(model_wflux_type) ::   mwf      
   type(model_cflux_type) ::   mcf      
   type(model_nflux_type) ::   mnf      
   type(model_vflux_type) ::   mvf      
   type(model_dflux_type) ::   mdf      
end type model_type







type atm2lnd_type
  real(r8), pointer :: flfall(:)       
  real(r8), pointer :: forc_t(:)       
  real(r8), pointer :: forc_u(:)       
  real(r8), pointer :: forc_v(:)       
  real(r8), pointer :: forc_wind(:)    
  real(r8), pointer :: forc_q(:)       
  real(r8), pointer :: forc_hgt(:)     
  real(r8), pointer :: forc_hgt_u(:)   
  real(r8), pointer :: forc_hgt_t(:)   
  real(r8), pointer :: forc_hgt_q(:)   
  real(r8), pointer :: forc_pbot(:)    
  real(r8), pointer :: forc_th(:)      
  real(r8), pointer :: forc_vp(:)      
  real(r8), pointer :: forc_rho(:)     
  real(r8), pointer :: forc_psrf(:)    
  real(r8), pointer :: forc_pco2(:)    
  real(r8), pointer :: forc_lwrad(:)   
  real(r8), pointer :: forc_solad(:,:) 
                                       
  real(r8), pointer :: forc_solai(:,:) 
                                       
  real(r8), pointer :: forc_solar(:)   
  real(r8), pointer :: forc_rain(:)    
  real(r8), pointer :: forc_snow(:)    
  real(r8), pointer :: forc_ndep(:)    
  
  
  real(r8), pointer :: forc_pc13o2(:)  
  real(r8), pointer :: forc_po2(:)     
end type atm2lnd_type



type(atm2lnd_type), public, target, save :: clm_a2l







type(model_type)    , public, target     , save :: clm3




type(pft_epc_type), public, target, save :: pftcon




type(pft_dgvepc_type), public, target, save :: dgv_pftcon

character(len=8), parameter, public :: nameg  = 'gridcell'  
character(len=8), parameter, public :: namel  = 'landunit'  
character(len=8), parameter, public :: namec  = 'column'    
character(len=8), parameter, public :: namep  = 'pft'       
character(len=8), parameter, public :: ocnrof = 'ocnrof'    
                                                    
character(len=8), parameter, public :: lndrof = 'lndrof'    
                                                    
character(len=8), parameter, public :: allrof = 'allrof'    
                                                    








 contains
   subroutine clmtype_mod
   end subroutine clmtype_mod
end module clmtype  
