



      subroutine clmzen(calday, cosz, lbg, ubg, declination)

      use shr_kind_mod, only: r8 => shr_kind_r8     
      use clmtype

      implicit none






































    integer :: g
    integer , intent(in) :: lbg, ubg 
    real(r8), intent(in) :: calday   


   real(r8), intent(inout) :: cosz(lbg:ubg) 
   real(r8), intent(inout) :: declination  




      real(r8) :: dayspy              
      real(r8) :: pi                  
      real(r8) :: theta               
      real(r8) :: delta               
      real(r8) :: sind                
      real(r8) :: cosd                
      real(r8) :: phi                 
      real(r8) :: loctim              
      real(r8) :: hrang               

      real(r8), pointer :: lat(:)       
      real(r8), pointer :: lon(:)       
      real(r8) :: lonx(lbg:ubg)
      real(r8) :: latx(lbg:ubg)

      integer mcsec            

     dayspy = 365.
     pi = 4.*atan(1.)

     lat       => clm3%g%lat
     lon       => clm3%g%lon

     
     do g = lbg, ubg
       latx(g) = lat(g)
       lonx(g) = lon(g)
       if(lonx(g).lt.0.0) then
          lonx(g) = 2.*pi + lonx(g) 
       end if
     end do




      theta = (2.*pi*calday)/dayspy
      delta = .006918 - .399912*cos(   theta) + .070257*sin(   theta)&
                      - .006758*cos(2.*theta) + .000907*sin(2.*theta)&
                      - .002697*cos(3.*theta) + .001480*sin(3.*theta)
      sind = sin(delta)
      cosd = cos(delta)

      declination = delta

      do g = lbg, ubg


         mcsec = (calday - int(calday)) * 86400.
         phi = calday + lonx(g)/(2.*pi)
         loctim = (mcsec + (phi-calday)*86400.) / 3600.
         if(loctim.gt.24.0) loctim = loctim - 24.0
 


         hrang = 360./24. * (loctim-12.) * pi/180.




         cosz(g) = sin(latx(g))*sind + cos(latx(g))*cosd*cos(hrang)
         if (cosz(g) .ge. -0.001 .and. cosz(g).le. 0.) cosz(g) = 0.001
      end do

      return
      end
