














subroutine driver (doalb,ilx,jlx)















































































  use shr_kind_mod, only: r8 => shr_kind_r8
  use globals  
  use clmtype
  use decompMod           , only : get_proc_bounds
  use filterMod           , only : filter,filters_dealloc
  use clm_varcon          , only : zlnd
  use DriverInitMod       , only : DriverInit
  use BalanceCheckMod     , only : BalanceCheck, BeginWaterBalance
  use SurfaceRadiationMod , only : SurfaceRadiation
  use Hydrology1Mod       , only : Hydrology1
  use Hydrology2Mod       , only : Hydrology2

  use Biogeophysics1Mod   , only : Biogeophysics1
  use BareGroundFluxesMod , only : BareGroundFluxes
  use CanopyFluxesMod     , only : CanopyFluxes
  use Biogeophysics2Mod   , only : Biogeophysics2







  use SurfaceAlbedoMod    , only : SurfaceAlbedo, Snowage
  use pft2colMod          , only : pft2col
  use accFldsMod          , only : updateAccFlds
  use accumulMod          , only : accum_dealloc




  use STATICEcosysDynMod  , only : EcosystemDyn,interpMonthlyVeg,EcosystemDyn_dealloc








  implicit none
  logical , intent(in) :: doalb  
                                 







  integer  :: ilx,jlx
  integer  :: c         
  integer  :: ncdate        
  integer  :: kyr           
  integer  :: begp, endp    
  integer  :: begc, endc    
  integer  :: begl, endl    
  integer  :: begg, endg    
  type(column_type)  , pointer :: cptr    




  

  cptr => clm3%g%l%c

  
  
  
  
  
  
  

  
  
  
  
  
  
  
  

  if (doalb) call interpMonthlyVeg (monp1,dayp1)

  
  
  

     
     
     

     call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)


     call CLMDebug('BeginWaterBalance')
     call BeginWaterBalance(begc, endc, begp, endp, &
          filter%num_nolakec, filter%nolakec, &
          filter%num_lakec, filter%lakec, ilx, jlx)







     
     
     
     
     
     
     

     call CLMDebug('DriverInit')
     call DriverInit(begc, endc, begp, endp, &
          filter%num_nolakec, filter%nolakec, &
          filter%num_lakec, filter%lakec, ilx, jlx)

     
     
     

     call CLMDebug('Hydrology1')
     call Hydrology1(begc, endc, begp, endp, &
                     filter%num_nolakec, filter%nolakec, &
                     filter%num_nolakep, filter%nolakep)

     
     
     

     call CLMDebug('SurfaceRadiation')
     call SurfaceRadiation(begp, endp)

     
     
     
     

     call CLMDebug('Biogeophysics1')
     call Biogeophysics1(begg, endg, begc, endc, begp, endp, &
                         filter%num_nolakec, filter%nolakec, &
                         filter%num_nolakep, filter%nolakep)

     
     
     
     

     call CLMDebug('BareGroundFluxes')
     call BareGroundFluxes(begp, endp, &
                           filter%num_nolakep, filter%nolakep)

     
     
     
     
     

     call CLMDebug('CanopyFluxes')
     call CanopyFluxes(begg, endg, begc, endc, begp, endp, &
                       filter%num_nolakep, filter%nolakep)

     
     
     

     call CLMDebug('BiogeophysicsLake')







     
     
     



     
     
     

     call CLMDebug('EcosystemDyn')
     call EcosystemDyn(begp, endp, &
                       filter%num_nolakep, filter%nolakep, &
                       doalb)

     
     
     

     if (doalb) then
        call CLMDebug('SurfaceAlbedo')
        call SurfaceAlbedo(begg, endg, begc, endc, begp, endp, caldayp1)
     end if

     
     
     
     

     call CLMDebug('Biogeophysics2')
     call Biogeophysics2(begc, endc, begp, endp, &
                         filter%num_nolakec, filter%nolakec, &
                         filter%num_nolakep, filter%nolakep)

     
     
     

     call CLMDebug('pft2col')
     call pft2col(begc, endc, filter%num_nolakec, filter%nolakec)

  
  
  

     
     
     

     call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

     
     
     

     call CLMDebug('Hydrology2')
     call Hydrology2(begc, endc, ilx ,jlx, &

                     begp, endp, &
                     filter%num_nolakec, filter%nolakec, &
                     filter%num_soilc, filter%soilc, &
                     filter%num_snowc, filter%snowc, &
                     filter%num_nosnowc, filter%nosnowc)

     
     
     

     call CLMDebug('HydrologyLake')



     
     
     

     call CLMDebug('SnowAge')
     call SnowAge(begc, endc)

     
     
     

     do c = begc,endc
        cptr%cps%frac_sno(c) = cptr%cps%snowdp(c) / (10.*zlnd + cptr%cps%snowdp(c))
     end do


     
     
     






     
     
     

     call CLMDebug('BalanceCheck')
     call BalanceCheck(begp, endp, begc, endc ,ilx, jlx)


     
     
     

     call CLMDebug('updateAccFlds')
     call updateAccFlds()



  call accum_dealloc
  call filters_dealloc
  call EcosystemDyn_dealloc

  call CLMDebug('Leaving Driver')

end subroutine driver
