



module filterMod












  use shr_kind_mod, only: r8 => shr_kind_r8


  implicit none
  save

  type clumpfilter






     integer, pointer :: lakep(:)   
     integer :: num_lakep           
     integer, pointer :: nolakep(:) 
     integer :: num_nolakep         
     integer, pointer :: lakec(:)   
     integer :: num_lakec           
     integer, pointer :: nolakec(:) 
     integer :: num_nolakec         
     integer, pointer :: soilc(:)   
     integer :: num_soilc           
     integer, pointer :: snowc(:)   
     integer :: num_snowc           
     integer, pointer :: nosnowc(:) 
     integer :: num_nosnowc         
  end type clumpfilter
  type(clumpfilter), public :: filter








contains







  subroutine initFilters()





    use clmtype
    use decompMod , only : get_proc_bounds
    use clm_varcon, only : istsoil


    implicit none








    integer :: nc          
    integer :: c,l,p       
    integer :: nclumps     
    integer :: fl          
    integer :: fnl         
    integer :: fs          
    integer :: begp, endp  
    integer :: begc, endc  
    integer :: begl, endl  
    integer :: begg, endg  
    integer :: ier         


       call get_proc_bounds (begg, endg, begl, endl, begc, endc, begp, endp)


       
       

       allocate (filter%lakec(endc-begc+1))
       allocate (filter%nolakec(endc-begc+1))

       fl = 0
       fnl = 0


       do c = begc,endc
          l = clm3%g%l%c%landunit(c)
          if (clm3%g%l%lakpoi(l)) then
             fl = fl + 1
             filter%lakec(fl) = c
          else
             fnl = fnl + 1
             filter%nolakec(fnl) = c
          end if
       end do
       filter%num_lakec = fl
       filter%num_nolakec = fnl

       
       

       allocate (filter%lakep(endp-begp+1))
       allocate (filter%nolakep(endp-begp+1))

       fl = 0
       fnl = 0


       do p = begp,endp
          l = clm3%g%l%c%p%landunit(p)
          if (clm3%g%l%lakpoi(l)) then
             fl = fl + 1
             filter%lakep(fl) = p
          else
             fnl = fnl + 1
             filter%nolakep(fnl) = p
          end if
       end do
       filter%num_lakep = fl
       filter%num_nolakep = fnl

       
       

       allocate (filter%soilc(endc-begc+1))

       fs = 0


       do c = begc,endc
          l = clm3%g%l%c%landunit(c)
          if (clm3%g%l%itype(l) == istsoil) then
             fs = fs + 1
             filter%soilc(fs) = c
          end if
       end do
       filter%num_soilc = fs

       
       

       allocate(filter%snowc(endc-begc+1))
       allocate(filter%nosnowc(endc-begc+1))







  end subroutine initFilters







  subroutine filters_dealloc

    implicit none




    deallocate (filter%lakec)
    deallocate (filter%nolakec)
    deallocate (filter%lakep)
    deallocate (filter%nolakep)
    deallocate (filter%soilc)
    deallocate (filter%snowc)
    deallocate (filter%nosnowc)



  end subroutine filters_dealloc

end module FilterMod
