









subroutine iniTimeVar(snlx     ,snowdpx ,snowagex  ,dzclmx  ,zclmx      ,&
                     ziclmx    ,h2osnox ,h2osoi_liqx,h2osoi_icex,t_grndx,&
                     t_soisnox ,t_lakex ,t_vegx    ,h2ocanx ,h2ocan_colx,&
                     h2osoi_volx, lake_icefracx, savedtke1x)












  use shr_kind_mod         , only : r8 => shr_kind_r8
  use clmtype
  use decompMod            , only : get_proc_bounds
  use filterMod            , only : filter
  use clm_varpar           , only : nlevsoi, nlevsno, nlevlak,maxpatch
  use clm_varcon           , only : denice, denh2o, zlnd,istsoil,istdlak
  use FracWetMod           , only : FracWet
  use SurfaceAlbedoMod     , only : SurfaceAlbedo
  use globals              , only : month, day, calday




  use STATICEcosysDynMod, only : EcosystemDyn, interpMonthlyVeg



  implicit none








    integer   :: snlx(maxpatch)
    real(r8)  :: snowdpx(maxpatch)
    real(r8)  :: snowagex(maxpatch)
    real(r8)  :: h2osnox(maxpatch)
    real(r8)  :: t_grndx(maxpatch)
    real(r8)  :: t_vegx(maxpatch)
    real(r8)  :: h2ocanx(maxpatch)
    real(r8)  :: h2ocan_colx(maxpatch)

    real(r8)  :: t_lakex(maxpatch,nlevlak)
    real(r8)  :: t_soisnox(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: h2osoi_liqx(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: h2osoi_icex(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: dzclmx(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: zclmx(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: ziclmx(maxpatch,-nlevsno:nlevsoi)
    real(r8)  :: h2osoi_volx(maxpatch,nlevsoi)
    real(r8), intent(in)  :: lake_icefracx(nlevsoi), savedtke1x






  integer , pointer :: plandunit(:)      
  logical , pointer :: lakpoi(:)         
  real(r8), pointer :: dz(:,:)           
  real(r8), pointer :: h2osoi_ice(:,:)   
  real(r8), pointer :: h2osoi_liq(:,:)   
  integer , pointer :: frac_veg_nosno_alb(:) 



  real(r8), pointer :: h2osoi_vol(:,:)   
  real(r8), pointer :: snowdp(:)         
  real(r8), pointer :: frac_sno(:)       
  integer , pointer :: frac_veg_nosno(:) 
  real(r8), pointer :: fwet(:)           



  real(r8), pointer :: fdry(:)     
  real(r8), pointer :: tlai(:)     
  real(r8), pointer :: tsai(:)     
  real(r8), pointer :: htop(:)     
  real(r8), pointer :: hbot(:)     
  real(r8), pointer :: elai(:)     
  real(r8), pointer :: esai(:)     





  integer :: nc,j,l,c,p,fp,fc  
  integer :: begp, endp   
  integer :: begc, endc   
  integer :: begl, endl   
  integer :: begg, endg   



  

  lakpoi              => clm3%g%l%lakpoi

  

  dz                  => clm3%g%l%c%cps%dz
  h2osoi_ice          => clm3%g%l%c%cws%h2osoi_ice
  h2osoi_liq          => clm3%g%l%c%cws%h2osoi_liq
  h2osoi_vol          => clm3%g%l%c%cws%h2osoi_vol
  snowdp              => clm3%g%l%c%cps%snowdp
  frac_sno            => clm3%g%l%c%cps%frac_sno


  

  plandunit          => clm3%g%l%c%p%landunit
  frac_veg_nosno_alb => clm3%g%l%c%p%pps%frac_veg_nosno_alb
  frac_veg_nosno     => clm3%g%l%c%p%pps%frac_veg_nosno
  fwet               => clm3%g%l%c%p%pps%fwet

  
  

  htop               => clm3%g%l%c%p%pps%htop
  hbot               => clm3%g%l%c%p%pps%hbot
  tlai               => clm3%g%l%c%p%pps%tlai
  tsai               => clm3%g%l%c%p%pps%tsai
  elai               => clm3%g%l%c%p%pps%elai
  esai               => clm3%g%l%c%p%pps%esai
  fdry               => clm3%g%l%c%p%pps%fdry

  
  
  
  
  

    call mkarbinit(snlx     ,snowdpx ,snowagex  ,dzclmx  ,zclmx      ,&
                  ziclmx    ,h2osnox ,h2osoi_liqx,h2osoi_icex,t_grndx,&
                  t_soisnox ,t_lakex ,t_vegx    ,h2ocanx ,h2ocan_colx,&
                  h2osoi_volx, lake_icefracx, savedtke1x)

  
  
  
  
  
  
  
  
  
  


  
  call interpMonthlyVeg(month, day)


     call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

     



     do p = begp,endp
        l = plandunit(p)
        if (lakpoi(l)) then
           fwet(p) = 0.
           fdry(p) = 0.
           elai(p) = 0.
           esai(p) = 0.
           htop(p) = 0.
           hbot(p) = 0.
           tlai(p) = 0.
           tsai(p) = 0.
           frac_veg_nosno_alb(p) = 0.
           frac_veg_nosno(p) = 0.
        end if
     end do


     call EcosystemDyn(begp, endp, filter%num_nolakep, filter%nolakep, &
                       doalb=.true.)



     do p = begp, endp
        l = plandunit(p)
        if (.not. lakpoi(l)) then
           frac_veg_nosno(p) = frac_veg_nosno_alb(p)
           fwet(p) = 0.
        end if
     end do

     call FracWet(filter%num_nolakep, filter%nolakep)

     
     



     do c = begc, endc
        snowdp(c)  = snowdpx(c)
        frac_sno(c) = snowdp(c)/(10.*zlnd + snowdp(c))
     end do

     call SurfaceAlbedo(begg, endg, begc, endc, begp, endp, calday)

end subroutine iniTimeVar










subroutine mkarbinit(snlx   ,snowdpx ,snowagex  ,dzclmx  ,zclmx      ,&
                  ziclmx    ,h2osnox ,h2osoi_liqx,h2osoi_icex,t_grndx,&
                  t_soisnox ,t_lakex ,t_vegx    ,h2ocanx ,h2ocan_colx,&
                  h2osoi_volx, lake_icefracx, savedtke1x)













  use shr_kind_mod , only : r8 => shr_kind_r8
  use clmtype
  use decompMod    , only : get_proc_bounds
  use clm_varpar   , only : nlevsoi, nlevsno, nlevlak,maxpatch
  use clm_varcon   , only : bdsno, istice, istwet, istsoil, &
                            denice, denh2o, spval, sb, tfrz


  implicit none











  integer , pointer :: pcolumn(:)        
  integer , pointer :: clandunit(:)      
  integer , pointer :: ltype(:)          
  logical , pointer :: lakpoi(:)         
  real(r8), pointer :: dz(:,:)           
  real(r8), pointer :: zi(:,:)       
  real(r8), pointer :: z(:,:)       

  real(r8), pointer :: watsat(:,:)       
  real(r8), pointer :: h2osoi_ice(:,:)   
  real(r8), pointer :: h2osoi_liq(:,:)   
  real(r8), pointer :: bsw2(:,:)         
  real(r8), pointer :: psisat(:,:)       
  real(r8), pointer :: vwcsat(:,:)       


  real(r8), pointer :: wa(:)             
  real(r8), pointer :: wt(:)             
  real(r8), pointer :: zwt(:)            
  real(r8), pointer :: h2ocan_loss(:)    

  real(r8), pointer :: lake_icefrac(:,:)  
  real(r8), pointer :: savedtke1(:)       






  integer , pointer :: snl(:)            
  real(r8), pointer :: t_soisno(:,:)     
  real(r8), pointer :: t_lake(:,:)       
  real(r8), pointer :: t_grnd(:)         
  real(r8), pointer :: t_veg(:)          
  real(r8), pointer :: h2osoi_vol(:,:)   
  real(r8), pointer :: h2ocan_col(:)     
  real(r8), pointer :: h2ocan_pft(:)     
  real(r8), pointer :: h2osno(:)         
  real(r8), pointer :: snowdp(:)         
  real(r8), pointer :: snowage(:)        
  real(r8), pointer :: eflx_lwrad_out(:) 

  real(r8), pointer :: soilpsi(:,:)    



    integer   :: snlx(maxpatch)
    real(r8)  :: snowdpx(maxpatch)
    real(r8)  :: snowagex(maxpatch)
    real(r8)  :: h2osnox(maxpatch)
    real(r8)  :: t_grndx(maxpatch)
    real(r8)  :: t_vegx(maxpatch)
    real(r8)  :: h2ocanx(maxpatch)
    real(r8)  :: h2ocan_colx(maxpatch)

    real(r8)  :: t_lakex(maxpatch,nlevlak)
    real(r8)  :: t_soisnox(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: h2osoi_liqx(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: h2osoi_icex(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: dzclmx(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: zclmx(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: ziclmx(maxpatch,-nlevsno:nlevsoi)
    real(r8)  :: h2osoi_volx(maxpatch,nlevsoi)
    real(r8), intent(in)  :: lake_icefracx(nlevsoi), savedtke1x





  integer :: j,l,c,p      
  integer :: begp, endp   
  integer :: begc, endc   
  integer :: begl, endl   
  integer :: begg, endg   


  

  ltype => clm3%g%l%itype
  lakpoi => clm3%g%l%lakpoi

  

  clandunit  => clm3%g%l%c%landunit
  snl        => clm3%g%l%c%cps%snl
  dz         => clm3%g%l%c%cps%dz
  zi         => clm3%g%l%c%cps%zi
  z          => clm3%g%l%c%cps%z
  watsat     => clm3%g%l%c%cps%watsat
  h2osoi_ice => clm3%g%l%c%cws%h2osoi_ice
  h2osoi_liq => clm3%g%l%c%cws%h2osoi_liq
  h2osoi_vol => clm3%g%l%c%cws%h2osoi_vol
  h2ocan_col => clm3%g%l%c%cws%pws_a%h2ocan
  snowage    => clm3%g%l%c%cps%snowage
  snowdp     => clm3%g%l%c%cps%snowdp
  h2osno     => clm3%g%l%c%cws%h2osno
  t_soisno   => clm3%g%l%c%ces%t_soisno
  t_lake     => clm3%g%l%c%ces%t_lake
  t_grnd     => clm3%g%l%c%ces%t_grnd

    bsw2       => clm3%g%l%c%cps%bsw2
    vwcsat     => clm3%g%l%c%cps%vwcsat
    psisat     => clm3%g%l%c%cps%psisat
    soilpsi    => clm3%g%l%c%cps%soilpsi
    wa         => clm3%g%l%c%cws%wa
    wt         => clm3%g%l%c%cws%wt
    zwt        => clm3%g%l%c%cws%zwt
    h2ocan_loss => clm3%g%l%c%cwf%h2ocan_loss


    savedtke1       => clm3%g%l%c%cps%savedtke1
    lake_icefrac => clm3%g%l%c%cws%lake_icefrac

  

  pcolumn => clm3%g%l%c%p%column
  h2ocan_pft => clm3%g%l%c%p%pws%h2ocan
  t_veg => clm3%g%l%c%p%pes%t_veg
  eflx_lwrad_out => clm3%g%l%c%p%pef%eflx_lwrad_out

  

  call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

  
  
  

  

  

  do p = begp, endp
     h2ocan_pft(p) = h2ocanx(p)
  end do



  do c = begc,endc

     

     h2ocan_col(c) = h2ocan_colx(c)


     h2ocan_loss(c) = 0._r8

     

        h2osno(c) = h2osnox(c)

     

     snowdp(c)  = snowdpx(c)

     

     snowage(c) = snowagex(c)

  end do


  
  
  

  do c = begc,endc
   snl(c) = snlx(c)
   dz(c,-nlevsno+1:0)  = dzclmx(c,-nlevsno+1:0)
   z(c,-nlevsno+1:0)   = zclmx(c,-nlevsno+1:0)
   zi(c,-nlevsno+0:0)  = ziclmx(c,-nlevsno+0:0)
  end do


  
  
  

  
  
  
  



  do c = begc,endc
     t_soisno(c,-nlevsno+1:nlevsoi) = t_soisnox(c,-nlevsno+1:nlevsoi)
     t_lake(c,1:nlevlak) = t_lakex(c,1:nlevlak)
     t_grnd(c)  = t_grndx(c)
  
     l = clandunit(c)
     if (lakpoi(l)) then
        lake_icefrac(c,1:nlevlak) = lake_icefracx(1:nlevlak)
        savedtke1(c)              = savedtke1x
     end if
  end do



  do p = begp, endp
     c = pcolumn(p)
     t_veg(p) = t_vegx(c)
     eflx_lwrad_out(p) = sb * (t_grnd(c))**4
  end do

  
  
  

  
  

  do c = begc,endc
      do j=1,nlevsoi
          h2osoi_vol(c,j)  = h2osoi_volx(c,j)
      end do
      do j=-nlevsno+1,nlevsoi
          h2osoi_liq(c,j)  = h2osoi_liqx(c,j)
          h2osoi_ice(c,j)  = h2osoi_icex(c,j)
      end do
  end do


    wa(begc:endc)  = 5000._r8
    wt(begc:endc)  = 5000._r8
    zwt(begc:endc) = 0._r8



  do c = begc,endc

        l = clandunit(c)

          wa(c)  = 4800._r8
          wt(c)  = wa(c)
          zwt(c) = (25._r8 + zi(c,nlevsoi)) - wa(c)/0.2_r8 /1000._r8  


     do j = 1,nlevsoi

        l = clandunit(c)


           
           if(h2osoi_vol(c,j) > watsat(c,j)) then
              h2osoi_vol(c,j) = watsat(c,j)
              if(h2osoi_liq(c,j)/(dz(c,j)*denh2o)+ &
                 h2osoi_ice(c,j)/(dz(c,j)*denice)> &
                 h2osoi_vol(c,j) ) then
                 if(t_soisno(c,j) > tfrz) then
                    h2osoi_liq(c,j) = dz(c,j)*denh2o*watsat(c,j) 
                    h2osoi_ice(c,j) = 0.0
                 else
                    h2osoi_liq(c,j) = 0.0
                    h2osoi_ice(c,j) = dz(c,j)*denice*watsat(c,j)
                 end if
              end if
   
           endif




     end do
  end do

end subroutine mkarbinit
