



module initGridcellsMod















  use shr_kind_mod, only: r8 => shr_kind_r8
  use clmtype
  use clm_varpar, only : lsmlon, lsmlat, maxpatch, maxpatch_pft
  use clm_varsur, only : numlon, area, latixy, longxy, landfrac


  implicit none
  private
  save


  public initGridcells      


  private landunit_veg_compete
  private landunit_veg_noncompete
  private landunit_special
  private landunit_crop_noncompete







  type(gridcell_type), pointer :: gptr  
  type(landunit_type), pointer :: lptr  
  type(column_type)  , pointer :: cptr  
  type(pft_type)     , pointer :: pptr  


contains







  subroutine initGridcells (vegxy, wtxy)















    use decompMod , only : get_proc_bounds, get_gcell_xyind, &
                           get_gcell_info 
    use clm_varcon, only : pie


    implicit none
    integer , intent(in) :: vegxy(lsmlon,lsmlat,maxpatch) 
    real(r8), intent(in) :: wtxy(lsmlon,lsmlat,maxpatch)  
                                                          







    integer :: g,i,j,m,n,gi,li,ci,pi 
    integer :: ngcells     
    integer :: nlunits     
    integer :: ncols       
    integer :: npfts       
    integer :: nveg        
    real(r8):: wtveg       
    integer :: ncrop       
    real(r8):: wtcrop      
    integer :: begp, endp  
    integer :: begc, endc  
    integer :: begl, endl  
    integer :: begg, endg  
    integer :: ier         
    integer :: ilunits, icols, ipfts  










    

    gptr => clm3%g
    lptr => clm3%g%l
    cptr => clm3%g%l%c
    pptr => clm3%g%l%c%p

    

    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)
    call get_gcell_xyind(begg, endg, gptr%ixy, gptr%jxy)

    

    clm3%ngridcells = endg - begg + 1

    
    
    
    

    ngcells = begg-1
    nlunits = begl-1
    ncols   = begc-1
    npfts   = begp-1

    do gi = begg, endg

       

       i = gptr%ixy(gi)
       j = gptr%jxy(gi)


       gptr%area(gi)   = area(i,j)

      
       gptr%lat(gi)    = latixy(i,j) * pie/180.
       gptr%lon(gi)    = longxy(i,j) * pie/180.
       gptr%latdeg(gi) = latixy(i,j)
       gptr%londeg(gi) = longxy(i,j)


       gptr%luni(gi) = nlunits + 1
       gptr%coli(gi) = ncols   + 1
       gptr%pfti(gi) = npfts   + 1

       call get_gcell_info(i, j, wtxy, nlunits=ilunits, ncols=icols, npfts=ipfts)

       ngcells = ngcells + 1
       nlunits = nlunits + ilunits
       ncols   = ncols   + icols
       npfts   = npfts   + ipfts

       gptr%lunf(gi) = nlunits
       gptr%colf(gi) = ncols
       gptr%pftf(gi) = npfts

       gptr%nlandunits(gi) = gptr%lunf(gi) - gptr%luni(gi) + 1
       gptr%ncolumns(gi)   = gptr%colf(gi) - gptr%coli(gi) + 1
       gptr%npfts(gi)      = gptr%pftf(gi) - gptr%pfti(gi) + 1

    end do

    

    ngcells = 0
    nlunits = 0
    ncols   = 0
    npfts   = 0

    li = begl - 1
    ci = begc - 1
    pi = begp - 1

    do gi = begg,endg

       

       i = gptr%ixy(gi)
       j = gptr%jxy(gi)

       

       call get_gcell_info(i, j, wtxy, nveg=nveg, wtveg=wtveg, ncrop=ncrop, wtcrop=wtcrop)

       




       if (nveg > 0) call landunit_veg_compete(nveg, wtveg, wtxy, vegxy, i, j, gi, li, ci, pi)


       

       if (ncrop > 0) call landunit_crop_noncompete(ncrop, wtcrop, wtxy, vegxy, i, j, gi, li, ci, pi)

       

       do m = npatch_urban, npatch_glacier
          if (wtxy(i,j,m) > 0.) call landunit_special(wtxy, i, j, m, gi, li, ci, pi)
       end do

    end do


  end subroutine initGridcells







  subroutine landunit_veg_compete (nveg, wtveg, wtxy, vegxy, i, j, &
                                   gi, li, ci, pi)





    use clm_varcon, only : istsoil


    implicit none
    integer , intent(in) :: nveg   
    real(r8), intent(in) :: wtveg  
                                   
    real(r8), intent(in) :: wtxy(lsmlon,lsmlat,maxpatch)  
                                                          
    integer , intent(in) :: vegxy(lsmlon,lsmlat,maxpatch) 
    integer , intent(in) :: i      
    integer , intent(in) :: j      
    integer , intent(in) :: gi     
    integer , intent(inout) :: li  
    integer , intent(inout) :: ci  
    integer , intent(inout) :: pi  







    integer  :: m                          


    
    
    

    li = li + 1
    lptr%ncolumns(li) = 1
    lptr%coli(li) = ci + 1
    lptr%colf(li) = ci + 1
    lptr%npfts(li) = nveg
    lptr%pfti(li) = pi + 1
    lptr%pftf(li) = pi + nveg

    lptr%area(li) = gptr%area(gi) * wtveg

    lptr%gridcell(li) = gi
    lptr%wtgcell(li) = wtveg
    lptr%ixy(li) = i
    lptr%jxy(li) = j




    lptr%ifspecial(li) = .false.
    lptr%lakpoi(li) = .false.
    lptr%itype(li) = istsoil

    
    
    
    

    ci = ci + 1
    cptr%npfts(ci) = nveg
    cptr%pfti(ci) = pi + 1
    cptr%pftf(ci) = pi + nveg

    cptr%area(ci) = lptr%area(li)

    cptr%landunit(ci) = li
    cptr%gridcell(ci) = gi
    cptr%wtlunit(ci) = 1.0
    cptr%wtgcell(ci) = wtveg
    cptr%ixy(ci) = i
    cptr%jxy(ci) = j




    cptr%itype(ci) = 1

    
    



    do m = 1,maxpatch_pft
       if (wtxy(i,j,m) > 0.) then
          pi = pi+1
          pptr%column(pi) = ci
          pptr%landunit(pi) = li
          pptr%gridcell(pi) = gi
          pptr%wtcol(pi) = wtxy(i,j,m) / wtveg
          pptr%wtlunit(pi) = wtxy(i,j,m) / wtveg
          pptr%wtgcell(pi) = wtxy(i,j,m)

          pptr%area(pi) = cptr%area(ci) * pptr%wtcol(pi)

          pptr%ixy(pi) = i
          pptr%jxy(pi) = j
          pptr%mxy(pi) = m




          pptr%itype(pi) = vegxy(i,j,m)
       end if 
    end do 

  end subroutine landunit_veg_compete







  subroutine landunit_veg_noncompete (nveg, wtveg, wtxy, vegxy, i, j, &
                                      gi, li, ci, pi)





    use clm_varcon, only : istsoil


    implicit none
    integer , intent(in) :: nveg       
    real(r8), intent(in) :: wtveg      
    real(r8), intent(in) :: wtxy(lsmlon,lsmlat,maxpatch)  
    integer , intent(in) :: vegxy(lsmlon,lsmlat,maxpatch) 
    integer , intent(in) :: i          
    integer , intent(in) :: j          
    integer , intent(in) :: gi         
    integer , intent(inout) :: li      
    integer , intent(inout) :: ci      
    integer , intent(inout) :: pi      







    integer  :: m                          
    real(r8) :: wtlunit                    


    
    
    

    li = li + 1
    lptr%ncolumns(li) = nveg
    lptr%coli(li) = ci + 1
    lptr%colf(li) = ci + nveg
    lptr%npfts(li) = nveg
    lptr%pfti(li) = pi + 1
    lptr%pftf(li) = pi + nveg

    lptr%area(li) = gptr%area(gi) * wtveg

    lptr%gridcell(li) = gi
    lptr%wtgcell(li) = wtveg
    lptr%ixy(li) = i
    lptr%jxy(li) = j




    lptr%ifspecial(li) = .false.
    lptr%lakpoi(li) = .false.
    lptr%itype(li) = istsoil

    
    
    
    
    
    
    
    
    



    do m = 1, maxpatch_pft
       if (wtxy(i,j,m) > 0.) then

          

          wtlunit = wtxy(i,j,m) / wtveg

          

          ci = ci + 1
          cptr%npfts(ci) = 1
          cptr%pfti(ci) = ci
          cptr%pftf(ci) = ci

          cptr%area(ci) = lptr%area(li) * wtlunit

          cptr%landunit(ci) = li
          cptr%gridcell(ci) = gi
          cptr%wtlunit(ci) = wtlunit

          cptr%wtgcell(ci) = cptr%area(ci) / gptr%area(gi)

          cptr%ixy(ci) = i
          cptr%jxy(ci) = j




          cptr%itype(ci) = 1

          
          
          
          
          
          

          pi = pi + 1
          pptr%column(pi) = ci
          pptr%landunit(pi) = li
          pptr%gridcell(pi) = gi
          pptr%wtcol(pi) = 1.0
          pptr%wtlunit(pi) = cptr%wtlunit(ci)

          pptr%area(pi) = cptr%area(ci)
          pptr%wtgcell(pi) = pptr%area(pi) / gptr%area(gi)

          pptr%ixy(pi) = i
          pptr%jxy(pi) = j
          pptr%mxy(pi) = m




          pptr%itype(pi) = vegxy(i,j,m)

       end if   
    end do   

  end subroutine landunit_veg_noncompete







  subroutine landunit_special (wtxy, i, j, m, gi, li, ci, pi)





    use pftvarcon, only : noveg
    use clm_varcon, only : istice, istwet, istdlak, isturb
    use clm_varpar, only : npatch_lake, npatch_wet, npatch_urban, &
                           npatch_glacier


    implicit none
    real(r8), intent(in) :: wtxy(lsmlon,lsmlat,maxpatch)  
    integer, intent(in) :: i            
    integer, intent(in) :: j            
    integer, intent(in) :: m            
    integer, intent(in) :: gi           
    integer, intent(inout) :: li        
    integer, intent(inout) :: ci        
    integer, intent(inout) :: pi        







    integer  :: c             
    integer  :: ncols         
    integer  :: npfts         
    integer  :: ier           
    real(r8) :: weight        
    integer  :: itype         


    

    if (m == npatch_lake) then         
       itype = istdlak
    else if (m == npatch_wet) then     
       itype = istwet
    else if (m == npatch_glacier) then 
       itype = istice
    else if (m == npatch_urban) then   
       itype = isturb
    else                               
       write(6,*)'special landunit are currently only:', &
            ' deep lake, wetland, glacier or urban)'
       call endrun()
    endif

    

    li = li + 1
    lptr%ncolumns(li) = 1
    lptr%coli(li) = ci + 1
    lptr%colf(li) = ci + 1
    lptr%npfts(li) = 1
    lptr%pfti(li) = pi + 1
    lptr%pftf(li) = pi + 1

    lptr%area(li) = gptr%area(gi) * wtxy(i,j,m)
    lptr%gridcell(li) = gi
    lptr%wtgcell(li) = lptr%area(li) / gptr%area(gi)

    lptr%ixy(li) = i
    lptr%jxy(li) = j




    lptr%ifspecial(li) = .true.
    if (itype == istdlak) then
       lptr%lakpoi(li) = .true.
    else
       lptr%lakpoi(li) = .false.
    end if
    lptr%itype(li) = itype

    
    
    

    ncols = 1

    
    
    

    do c = 1,ncols

       
       

       weight = 1.0/ncols

       ci = ci + c
       cptr%npfts(ci) = 1
       cptr%pfti(ci) = pi + 1
       cptr%pftf(ci) = pi + 1

       cptr%area(ci) = lptr%area(li) * weight

       cptr%landunit(ci) = li
       cptr%gridcell(ci) = gi
       cptr%wtlunit(ci) = weight

       cptr%wtgcell(ci) = cptr%area(ci) / gptr%area(gi)

       cptr%ixy(ci) = i
       cptr%jxy(ci) = j




       cptr%itype(ci) = 1

       
       
       
       
       
       

       npfts = 1
       weight = 1.0/npfts

       pi = pi + 1
       pptr%column(pi) = ci
       pptr%landunit(pi) = li
       pptr%gridcell(pi) = gi

       pptr%area(pi) = lptr%area(li) * weight

       pptr%wtcol(pi) = weight
       pptr%wtlunit(pi) = cptr%wtlunit(ci)

       pptr%wtgcell(pi) = pptr%area(pi) / gptr%area(gi)

       pptr%ixy(pi) = i
       pptr%jxy(pi) = j
       pptr%mxy(pi) = m




       pptr%itype(pi) = noveg

    end do   

  end subroutine landunit_special







  subroutine landunit_crop_noncompete (ncrop, wtcrop, wtxy, vegxy, i, j, &
                                       gi, li, ci, pi)





    use clm_varcon, only : istsoil
    use clm_varpar, only : npatch_crop


    implicit none
    integer , intent(in) :: ncrop       
    real(r8), intent(in) :: wtcrop      
    real(r8), intent(in) :: wtxy(lsmlon,lsmlat,maxpatch)  
    integer , intent(in) :: vegxy(lsmlon,lsmlat,maxpatch) 
    integer , intent(in) :: i          
    integer , intent(in) :: j          
    integer , intent(in) :: gi         
    integer , intent(inout) :: li      
    integer , intent(inout) :: ci      
    integer , intent(inout) :: pi      







    integer  :: m                          
    real(r8) :: wtlunit                    


    
    
    

    li = li + 1
    lptr%ncolumns(li) = ncrop
    lptr%coli(li) = ci + 1
    lptr%colf(li) = ci + ncrop
    lptr%npfts(li) = ncrop
    lptr%pfti(li) = pi + 1
    lptr%pftf(li) = pi + ncrop

    lptr%area(li) = gptr%area(gi) * wtcrop
    lptr%gridcell(li) = gi
    lptr%wtgcell(li) = wtcrop

    lptr%ixy(li) = i
    lptr%jxy(li) = j




    lptr%ifspecial(li) = .false.
    lptr%lakpoi(li) = .false.
    lptr%itype(li) = istsoil

    
    
    
    
    
    
    
    
    



    do m = npatch_glacier+1, npatch_crop
       if (wtxy(i,j,m) > 0.) then

          

          wtlunit = wtxy(i,j,m) / wtcrop

          

          ci = ci + 1
          cptr%npfts(ci) = 1

          cptr%area(ci) = lptr%area(li) * wtlunit
          cptr%landunit(ci) = li
          cptr%gridcell(ci) = gi
          cptr%wtlunit(ci) = wtlunit
          cptr%wtgcell(ci) = cptr%area(ci) / gptr%area(gi)

          cptr%ixy(ci) = i
          cptr%jxy(ci) = j




          cptr%itype(ci) = 1

          
          
          
          
          

          pi = pi + 1
          pptr%column(pi) = ci
          pptr%landunit(pi) = li
          pptr%gridcell(pi) = gi

          pptr%wtcol(pi) = 1.0
          pptr%wtlunit(pi) = cptr%wtlunit(ci)
          pptr%area(pi) = cptr%area(ci)
          pptr%wtgcell(pi) = pptr%area(pi) / gptr%area(gi)

          pptr%ixy(pi) = i
          pptr%jxy(pi) = j
          pptr%mxy(pi) = m




          pptr%itype(pi) = vegxy(i,j,m)

          

          cptr%pfti(ci) = pi
          cptr%pftf(ci) = pi

       end if   
    end do   

  end subroutine landunit_crop_noncompete

end module initGridcellsMod
