









module module_fr_sfire_model

use module_fr_sfire_core
use module_fr_sfire_util
use module_fr_sfire_phys

contains

subroutine sfire_model (                    &
    id,                                     & 
    ifun,                                   & 
    restart,                                &
    need_lfn_update,                          & 
    num_ignitions,                          & 
    ifuelread,nfuel_cat0,                   & 
    ifds,ifde,jfds,jfde,                    & 
    ifms,ifme,jfms,jfme,                    & 
    ifps,ifpe,jfps,jfpe,                    & 
    ifts,ifte,jfts,jfte,                    & 
    time_start,dt,                          & 
    fdx,fdy,                                & 
    ignition_start_x,ignition_start_y,      & 
    ignition_end_x,ignition_end_y,          &
    ignition_radius,                        &
    ignition_time,                          &
    ignitions_done,ignited_tile,            &
    coord_xf,coord_yf,unit_xf,unit_yf,      & 
    zsf,                                    & 
    vx,vy,                                  & 
    lfn,lfn_out,tign,fuel_frac,fire_area,   & 
    grnhfx,grnqfx,                          & 
    ros,                                    & 
    nfuel_cat,                              & 
    fuel_time,                              & 
    bbb,betafl,phiwc,r_0,fgip,ischap &
) 





































implicit none




integer, intent(in) :: id
integer, intent(in) :: ifun                 
                                            
                                            
                                            
                                            
                                            
logical, intent(in):: restart               
logical, intent(out)::need_lfn_update       

integer, intent(in) :: num_ignitions        
integer, intent(in) :: ifuelread,nfuel_cat0 
integer, intent(in) :: ifds,ifde,jfds,jfde,&  
        ifps,ifpe,jfps,jfpe                
integer, intent(in) :: ifts,ifte,jfts,jfte  
integer, intent(in) :: ifms,ifme,jfms,jfme  
REAL,INTENT(in) :: time_start,dt            
REAL,INTENT(in) :: fdx,fdy                  

real, dimension(num_ignitions), intent(in):: &   
    ignition_start_x,ignition_start_y, &
    ignition_end_x,ignition_end_y,ignition_radius, & 
    ignition_time                           
integer, intent(out):: ignited_tile(num_ignitions),ignitions_done
real, dimension(ifms:ifme, jfms:jfme), intent(in):: & 
    coord_xf,coord_yf                       
real, intent(in):: unit_xf,unit_yf          
REAL, INTENT(in), dimension(ifms:ifme,jfms:jfme):: & 
    vx,vy                                   
    

REAL, INTENT(inout), dimension(ifms:ifme,jfms:jfme):: &
    zsf,   &                                
    lfn   , &                               
    tign  , &                               
    fuel_frac                               

REAL, INTENT(out), dimension(ifms:ifme,jfms:jfme):: &
    fire_area                               
    

REAL, INTENT(out), dimension(ifms:ifme,jfms:jfme):: &
    lfn_out, &                              
    grnhfx,grnqfx, &                        
    ros                                     
 

real, intent(inout), dimension(ifms:ifme, jfms:jfme)::nfuel_cat 
real,intent(inout),dimension(ifms:ifme,jfms:jfme):: fuel_time
real,intent(inout),dimension(ifms:ifme,jfms:jfme):: bbb,betafl,phiwc,r_0 
real,intent(inout),dimension(ifms:ifme,jfms:jfme):: fgip                 
integer,intent(inout),dimension(ifms:ifme,jfms:jfme):: ischap            



integer :: xifms,xifme,xjfms,xjfme  
real, dimension(ifts:ifte,jfts:jfte)::fuel_frac_burnt,fuel_frac_end
integer::ignited,ig,i,j
real::tbound
character(len=128)::msg
logical:: freeze_fire



call check_mesh_2dim(ifts-1,ifte+1,jfts-1,jfte+1,ifms,ifme,jfms,jfme)


xifms=ifms  
xifme=ifme
xjfms=jfms
xjfme=jfme



need_lfn_update=.false.
ignitions_done=0
freeze_fire = fire_const_time > 0. .and. time_start < fire_const_time

if(ifun.eq.1)then       
elseif(ifun.eq.2)then   
        

        
        
        

        call continue_at_boundary(1,1,0., & 
            ifms,ifme,jfms,jfme,           &                
            ifds,ifde,jfds,jfde, &                     
            ifps,ifpe,jfps,jfpe, &            
            ifts,ifte,jfts,jfte, &                
            zsf)                               

        if(.not.restart)call set_nfuel_cat( &
            ifms,ifme,jfms,jfme, &
            ifts,ifte,jfts,jfte, &
            ifuelread,nfuel_cat0,&
            zsf,nfuel_cat)            

        
        
        if(.not.restart)call set_fire_params(   & 
            ifds,ifde,jfds,jfde, &
            ifms,ifme,jfms,jfme, &
            ifts,ifte,jfts,jfte, &
            fdx,fdy,nfuel_cat0,  &
            nfuel_cat,fuel_time &
,xifms,xifme,xjfms,xjfme &
,vx,vy,zsf,bbb,betafl,phiwc,r_0,fgip,ischap &
)

        call print_2d_stats(ifts,ifte,jfts,jfte,ifms,ifme,jfms,jfme,zsf,'model: terrain height')        
                                        
        
        if(.not.restart)then
            call init_no_fire  ( &
            ifds,ifde,jfds,jfde, &
            ifms,ifme,jfms,jfme, &
            ifts,ifte,jfts,jfte, &
            fdx,fdy,time_start,  &
            fuel_frac,fire_area,lfn,tign)
            
            need_lfn_update=.true. 

        endif

elseif(ifun.eq.3)then   

    
    do ig = 1,num_ignitions
    
        if(ignition_time(ig)>=time_start.and.ignition_time(ig)<time_start+dt)then 
            call ignite_fire(                             &
                ifds,ifde,jfds,jfde,                      & 
                ifms,ifme,jfms,jfme,                      &
                ifts,ifte,jfts,jfte,                      &
                ignition_start_x(ig),ignition_start_y(ig),&
                ignition_end_x(ig),ignition_end_y(ig),    &
                ignition_radius(ig),                      &
                ignition_time(ig),                        &  
                coord_xf,coord_yf,unit_xf,unit_yf,        & 
                lfn,tign,ignited)
            ignitions_done=ignitions_done+1
            ignited_tile(ignitions_done)=ignited
                
            need_lfn_update=.true. 
            call write_array_m(ifts,ifte,jfts,jfte,ifms,ifme,jfms,jfme,lfn,'lfn_ig',id)
            call write_array_m(ifts,ifte,jfts,jfte,ifms,ifme,jfms,jfme,coord_xf,'coord_xf_ig',id)
            call write_array_m(ifts,ifte,jfts,jfte,ifms,ifme,jfms,jfme,coord_yf,'coord_yf_ig',id)

        endif
        
    enddo
    
elseif (ifun.eq.4) then  








    call print_2d_stats(ifts,ifte,jfts,jfte, &
                   ifms,ifme,jfms,jfme, &
                   fuel_frac,'model: fuel_frac start')

    
    
    
    
    
    
    
    





    if(.not. freeze_fire)then

    call prop_ls(id,     &
        ifds,ifde,jfds,jfde,                      & 
        ifms,ifme,jfms,jfme,                      &
        ifps,ifpe,jfps,jfpe, &                
        ifts,ifte,jfts,jfte,                      &
        time_start,dt,fdx,fdy,tbound,  &
        lfn,lfn_out,tign,ros &
,xifms,xifme,xjfms,xjfme &
,vx,vy,zsf,bbb,betafl,phiwc,r_0,fgip,ischap &
    ) 

    else
        call message('sfire_model: EXPERIMENTAL: skipping fireline propagation')

    endif
    
elseif (ifun.eq.5) then 
    
    

    if(.not. freeze_fire)then
    
    do j=jfts,jfte
        do i=ifts,ifte
            lfn(i,j)=lfn_out(i,j)
            
            
        enddo
    enddo

    endif
            
    call print_2d_stats(ifts,ifte,jfts,jfte,ifms,ifme,jfms,jfme, &
                   lfn,'sfire_model: lfn out')

    
    need_lfn_update=.true. 

elseif (ifun.eq.6) then 

    if(.not. freeze_fire)then

    
    
    call fuel_left(&
        ifms,ifme,jfms,jfme, &
        ifts,ifte,jfts,jfte, &
        ifts,ifte,jfts,jfte, &
        lfn,tign,fuel_time,time_start+dt,fuel_frac_end,fire_area) 

    call print_2d_stats(ifts,ifte,jfts,jfte, &
                   ifts,ifte,jfts,jfte, &
                   fuel_frac_end,'model: fuel_frac end')
    
    do j=jfts,jfte
        do i=ifts,ifte
            fuel_frac_burnt(i,j)=fuel_frac(i,j)-fuel_frac_end(i,j) 
            fuel_frac(i,j)=fuel_frac_end(i,j) 
        enddo
    enddo

    call print_2d_stats(ifts,ifte,jfts,jfte, &
                   ifts,ifte,jfts,jfte, &
                   fuel_frac_burnt,'model: fuel_frac burned')
        
    call heat_fluxes(dt,                          &
        ifms,ifme,jfms,jfme,                      &
        ifts,ifte,jfts,jfte,                      &
        ifts,ifte,jfts,jfte,                      &  
        fgip,                                     &
        fuel_frac_burnt,                          & 
        grnhfx,grnqfx)                              

    else
        call message('sfire_model: EXPERIMENTAL: skipping fuel burnt computation')

        if (fire_const_grnhfx >= 0. .and. fire_const_grnqfx >= 0.) then

        write(msg,'(a,2e12.3,a)')'sfire_model: EXPERIMENTAL output constant heat flux', &
           fire_const_grnhfx, fire_const_grnqfx, ' W/s'
        call message(msg)
        
        do j=jfts,jfte
            do i=ifts,ifte
                grnhfx(i,j)=fire_const_grnhfx
                grnqfx(i,j)=fire_const_grnqfx
            enddo
        enddo

        endif

    endif

    call print_2d_stats(ifts,ifte,jfts,jfte, &
                   ifms,ifme,jfms,jfme, &
                   grnhfx,'model: heat flux(J/m^2/s)')

else
    write(msg,*)'sfire_model: bad ifun=',ifun
    call crash(msg)
endif

end subroutine sfire_model




            
end module module_fr_sfire_model
