module pftvarcon

!----------------------------------------------------------------------- 
!BOP
!
! !MODULE: pftvarcon
! 
! !DESCRIPTION: 
! Module containing vegetation constants and method to 
! eads and initialize vegetation (PFT) constants.
!
! !USES:
  use shr_kind_mod, only: r8 => shr_kind_r8
  use clm_varpar
  use clm_varcon, only: pftname,z0mr,displar,dleaf,c3psn,&
      vcmx25,mp,qe25,rhol,rhos,taul,taus,xl,roota_par,&
      rootb_par
!
! !PUBLIC TYPES:
  implicit none
  save
!
! Vegetation type constants
!
  integer ncorn                  !value for corn
  integer nwheat                 !value for wheat
  integer noveg                  !value for not vegetated 
  integer ntree                  !value for last type of tree

  real(r8) sla(0:numpft)              !sp. leaf area [m2 leaf g-1 carbon]
  real(r8) pftpar(0:numpft,1:npftpar) !the rest for use with DGVM
  real(r8) lm_sapl(0:numpft)
  real(r8) sm_sapl(0:numpft)
  real(r8) hm_sapl(0:numpft)
  real(r8) rm_sapl(0:numpft)
  logical  tree(0:numpft)
  logical  summergreen(0:numpft)
  logical  raingreen(0:numpft)

  integer, private :: i  ! loop index

  real(r8) crop(0:numpft)

  real(r8), parameter :: reinickerp = 1.6 !parameter in allometric equation
  real(r8), parameter :: wooddens = 2.0e5 !wood density (gC/m3)
  real(r8), parameter :: latosa = 8.0e3   !ratio of leaf area to sapwood cross-sectional 
                                          !area (Shinozaki et al 1964a,b)
  real(r8), parameter :: allom1 = 100.0   !parameters in allometric
  real(r8), parameter :: allom2 =  40.0
  real(r8), parameter :: allom3 =   0.5

!New parameters for CLM3.5, added by Zack Subin, 7/15/08

  real(r8) :: smpso(0:numpft)    !soil water potential at full stomatal opening (mm)
  real(r8) :: smpsc(0:numpft)    !soil water potential at full stomatal closure (mm)  
  real(r8) :: fnitr(0:numpft)    !foliage nitrogen limitation factor (-)
  real(r8) :: dsladlai(0:numpft) !dSLA/dLAI [m^2/gC]
  real(r8) :: slatop(0:numpft)   !SLA at top of canopy [m^2/gC]
  real(r8):: leafcn(0:numpft)      !leaf C:N [gC/gN]
  real(r8):: flnr(0:numpft)        !fraction of leaf N in Rubisco [no units]

  data (smpso(i),i=1,numpft) /-0.66e5, -0.66e5, -0.66e5, -0.66e5, -0.66e5, -0.35e5, -0.35e5, -0.35e5, &
       -0.83e5, -0.83e5, -0.83e5, -0.74e5, -0.74e5, -0.74e5, -0.74e5, -0.74e5/

  data (smpsc(i),i=1,numpft) /-2.55e5, -2.55e5, -2.55e5, -2.55e5, -2.55e5, -2.24e5, -2.24e5, -2.24e5, &
       -4.28e5, -4.28e5, -4.28e5, -2.75e5, -2.75e5, -2.75e5, -2.75e5, -2.75e5/

  data (slatop(i),i=1,numpft) /0.01000, 0.00800, 0.02400, 0.01200, 0.01200, 0.03000, 0.03000, 0.03000, &
        0.01200, 0.03000, 0.03000, 0.05000, 0.05000, 0.05000, 0.05000, 0.05000/

  data (dsladlai(i),i=1,numpft) /0.00125, 0.00100, 0.00300, 0.00150, 0.00150, 0.00400, 0.00400, 0.00400, &
        0.00150, 0.00400, 0.00400, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000/

  data (fnitr(i), i=1, numpft) /0.72, 0.78, 0.79, 0.83, 0.71, 0.66, 0.64, 0.70, &
        0.62, 0.60, 0.76, 0.68, 0.61, 0.64, 0.61, 0.61/

  data (leafcn(i), i=1, numpft) /35,40,25,30,30,25,25,25,30,25,25,25,25,25,25,25/
  data (flnr(i), i=1, numpft) /0.05,0.04,0.08,0.06,0.06,0.09,0.09,0.09,0.06,0.09,0.09,0.09,0.09,0.09,0.1,0.1/

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

#if (defined CN)
  real(r8):: woody(0:numpft)       !woody lifeform flag (0 or 1)
  real(r8):: lflitcn(0:numpft)      !leaf litter C:N (gC/gN)
  real(r8):: frootcn(0:numpft)      !fine root C:N (gC/gN)
  real(r8):: livewdcn(0:numpft)     !live wood (phloem and ray parenchyma) C:N (gC/gN)
  real(r8):: deadwdcn(0:numpft)     !dead wood (xylem and heartwood) C:N (gC/gN)
  real(r8):: froot_leaf(0:numpft)   !allocation parameter: new fine root C per new leaf C (gC/gC) 
  real(r8):: stem_leaf(0:numpft)    !allocation parameter: new stem c per new leaf C (gC/gC)
  real(r8):: croot_stem(0:numpft)   !allocation parameter: new coarse root C per new stem C (gC/gC)
  real(r8):: flivewd(0:numpft)      !allocation parameter: fraction of new wood that is live (phloem and ray parenchyma) (no units)
  real(r8):: fcur(0:numpft)         !allocation parameter: fraction of allocation that goes to currently displayed growth, remainder to storage
  real(r8):: lf_flab(0:numpft)      !leaf litter labile fraction
  real(r8):: lf_fcel(0:numpft)      !leaf litter cellulose fraction
  real(r8):: lf_flig(0:numpft)      !leaf litter lignin fraction
  real(r8):: fr_flab(0:numpft)      !fine root litter labile fraction
  real(r8):: fr_fcel(0:numpft)      !fine root litter cellulose fraction
  real(r8):: fr_flig(0:numpft)      !fine root litter lignin fraction
  real(r8):: dw_fcel(0:numpft)      !dead wood cellulose fraction
  real(r8):: dw_flig(0:numpft)      !dead wood lignin fraction
  real(r8):: leaf_long(0:numpft)    !leaf longevity (yrs)
  real(r8):: evergreen(0:numpft)    !binary flag for evergreen leaf habit (0 or 1)
  real(r8):: stress_decid(0:numpft) !binary flag for stress-deciduous leaf habit (0 or 1)
  real(r8):: season_decid(0:numpft) !binary flag for seasonal-deciduous leaf habit (0 or 1)
  ! begin new pft parameters for CN-fire code
  real(r8):: resist(0:numpft)       !resistance to fire (no units)
#elif (defined DGVM)
  real(r8):: resist(0:numpft)       !resistance to fire (no units)
#endif

!
! !PUBLIC MEMBER FUNCTIONS:
  public :: pftconrd ! Read and initialize vegetation (PFT) constants 
!
! !REVISION HISTORY:
! Created by Sam Levis (put into module form by Mariana Vertenstein)
!
!EOP
!----------------------------------------------------------------------- 

contains

!-----------------------------------------------------------------------
!BOP
!
! !IROUTINE: pftconrd
!
! !INTERFACE:
  subroutine pftconrd
!
! !DESCRIPTION: 
! Read and initialize vegetation (PFT) constants 
!
! !USES:
!
! !ARGUMENTS:
    implicit none
!
! !CALLED FROM:
! routine initialize in module initializeMod
!
! !REVISION HISTORY:
! Created by Gordon Bonan
!
!EOP
!
! !LOCAL VARIABLES:
    integer :: i,n              !loop indices
    integer :: ier              !error code
!-----------------------------------------------------------------------

! Set specific vegetation type values

    ncorn  = 15
    nwheat = 16

    ! Set value for last type of tree

    ntree = 8  !value for last type of tree

    ! Set value for non-vegetated

    noveg = 0  !value

    ! Assign unit number to file. Get local file. 
    ! Open file and read PFT's.
    ! Close and release file.

    crop(:)  = 0
    crop(15) = 1
    crop(16) = 1


    ! Define PFT zero to be bare ground

    pftname(noveg) = 'not_vegetated'
    z0mr(noveg) = 0.
    displar(noveg) = 0.
    dleaf(noveg) = 0.
    c3psn(noveg) = 1.
    vcmx25(noveg) = 0.
    mp(noveg) = 9.
    qe25(noveg) = 0.
    rhol(noveg,1) = 0.
    rhol(noveg,2) = 0.
    rhos(noveg,1) = 0.
    rhos(noveg,2) = 0.
    taul(noveg,1) = 0.
    taul(noveg,2) = 0.
    taus(noveg,1) = 0.
    taus(noveg,2) = 0.
    xl(noveg) = 0.
    roota_par(noveg) = 0.
    rootb_par(noveg) = 0.
    crop(noveg) = 0.
!New variables added by Zack Subin 7/15/08
    smpso(noveg) = 0._r8
    smpsc(noveg) = 0._r8
    fnitr(noveg) = 0._r8
    slatop(noveg) = 0._r8
    dsladlai(noveg) = 0._r8
    leafcn(noveg) = 1._r8
    flnr(noveg) = 0._r8
#if (defined CN)
    ! begin variables used only for CN code
    woody(noveg) = 0._r8
    lflitcn(noveg) = 1._r8
    frootcn(noveg) = 1._r8
    livewdcn(noveg) = 1._r8
    deadwdcn(noveg) = 1._r8
    froot_leaf(noveg) = 0._r8
    stem_leaf(noveg) = 0._r8
    croot_stem(noveg) = 0._r8
    flivewd(noveg) = 0._r8
    fcur(noveg) = 0._r8
    lf_flab(noveg) = 0._r8
    lf_fcel(noveg) = 0._r8
    lf_flig(noveg) = 0._r8
    fr_flab(noveg) = 0._r8
    fr_fcel(noveg) = 0._r8
    fr_flig(noveg) = 0._r8
    dw_fcel(noveg) = 0._r8
    dw_flig(noveg) = 0._r8
    leaf_long(noveg) = 0._r8
    evergreen(noveg) = 0._r8
    stress_decid(noveg) = 0._r8
    season_decid(noveg) = 0._r8
    resist(noveg) = 1._r8
#endif
!!!!!!!!!!!!!!!!!!!!!!!!!

    return 
  end subroutine pftconrd

end module pftvarcon

