






module subgridAveMod










  use shr_kind_mod, only: r8 => shr_kind_r8
  use clmtype
  use clm_varcon, only : spval



  implicit none
  save


  public :: p2c   
  public :: p2l   
  public :: p2g   
  public :: c2l   
  public :: c2g   
  public :: l2g   

  interface p2c
     module procedure p2c_1d
     module procedure p2c_2d
     module procedure p2c_1d_filter
     module procedure p2c_2d_filter
  end interface
  interface p2l
     module procedure p2l_1d
     module procedure p2l_2d
  end interface
  interface p2g
     module procedure p2g_1d
     module procedure p2g_2d
  end interface
  interface c2l
     module procedure c2l_1d
     module procedure c2l_2d
  end interface
  interface c2g
     module procedure c2g_1d
     module procedure c2g_2d
  end interface
  interface l2g
     module procedure l2g_1d
     module procedure l2g_2d
  end interface







contains







  subroutine p2c_1d (lbp, ubp, lbc, ubc, parr, carr, p2c_scale_type)






    use clm_varpar, only : max_pft_per_col


    implicit none
    integer , intent(in)  :: lbp, ubp              
    integer , intent(in)  :: lbc, ubc              
    real(r8), intent(in)  :: parr(lbp:ubp)         
    real(r8), intent(out) :: carr(lbc:ubc)         
    character(len=*), intent(in) :: p2c_scale_type 







    integer  :: pi,p,c,index           
    real(r8) :: scale_p2c(lbp:ubp)     
    logical  :: found                  
    real(r8) :: sumwt(lbc:ubc)         
    real(r8), pointer :: wtcol(:)      
    integer , pointer :: pcolumn(:)    
    integer , pointer :: npfts(:)      
    integer , pointer :: pfti(:)       


    wtcol    => clm3%g%l%c%p%wtcol
    pcolumn  => clm3%g%l%c%p%column
    npfts    => clm3%g%l%c%npfts
    pfti     => clm3%g%l%c%pfti

    if (p2c_scale_type == 'unity') then
       do p = lbp,ubp
          scale_p2c(p) = 1.0_r8
       end do
    else
       write(6,*)'p2c_1d error: scale type ',p2c_scale_type,' not supported'
       call endrun()
    end if

    carr(lbc:ubc) = spval
    sumwt(lbc:ubc) = 0._r8
    do p = lbp,ubp
       if (wtcol(p) /= 0._r8) then
          if (parr(p) /= spval) then
             c = pcolumn(p)
             if (sumwt(c) == 0._r8) carr(c) = 0._r8
             carr(c) = carr(c) + parr(p) * scale_p2c(p) * wtcol(p)
             sumwt(c) = sumwt(c) + wtcol(p)
          end if
       end if
    end do
    found = .false.
    do c = lbc,ubc
       if (sumwt(c) > 1.0_r8 + 1.e-6_r8) then
          found = .true.
          index = c
       else if (sumwt(c) /= 0._r8) then
          carr(c) = carr(c)/sumwt(c)
       end if
    end do
    if (found) then
       write(6,*)'p2c error: sumwt is greater than 1.0 at c= ',index
       call endrun()
    end if

  end subroutine p2c_1d







  subroutine p2c_2d (lbp, ubp, lbc, ubc, num2d, parr, carr, p2c_scale_type)






    use clm_varpar, only : max_pft_per_col


    implicit none
    integer , intent(in)  :: lbp, ubp              
    integer , intent(in)  :: lbc, ubc              
    integer , intent(in)  :: num2d                 
    real(r8), intent(in)  :: parr(lbp:ubp,num2d)   
    real(r8), intent(out) :: carr(lbc:ubc,num2d)   
    character(len=*), intent(in) :: p2c_scale_type 







    integer  :: j,pi,p,c,index         
    real(r8) :: scale_p2c(lbp:ubp)     
    logical  :: found                  
    real(r8) :: sumwt(lbc:ubc)         
    real(r8), pointer :: wtcol(:)      
    integer , pointer :: pcolumn(:)    
    integer , pointer :: npfts(:)      
    integer , pointer :: pfti(:)       


    wtcol    => clm3%g%l%c%p%wtcol
    pcolumn  => clm3%g%l%c%p%column
    npfts    => clm3%g%l%c%npfts
    pfti     => clm3%g%l%c%pfti

    if (p2c_scale_type == 'unity') then
       do p = lbp,ubp
          scale_p2c(p) = 1.0_r8
       end do
    else
       write(6,*)'p2c_2d error: scale type ',p2c_scale_type,' not supported'
       call endrun()
    end if

    carr(:,:) = spval
    do j = 1,num2d
       sumwt(:) = 0._r8
       do p = lbp,ubp
          if (wtcol(p) /= 0._r8) then
             if (parr(p,j) /= spval) then
                c = pcolumn(p)
                if (sumwt(c) == 0._r8) carr(c,j) = 0._r8
                carr(c,j) = carr(c,j) + parr(p,j) * scale_p2c(p) * wtcol(p)
                sumwt(c) = sumwt(c) + wtcol(p)
             end if
          end if
       end do
       found = .false.
       do c = lbc,ubc
          if (sumwt(c) > 1.0_r8 + 1.e-6_r8) then
             found = .true.
             index = c
          else if (sumwt(c) /= 0._r8) then
             carr(c,j) = carr(c,j)/sumwt(c)
          end if
       end do
       if (found) then
          write(6,*)'p2c_2d error: sumwt is greater than 1.0 at c= ',index,' lev= ',j
          call endrun()
       end if
    end do 
  end subroutine p2c_2d







  subroutine p2c_1d_filter (numfc, filterc, pftarr, colarr)





    use clm_varpar, only : max_pft_per_col


    implicit none
    integer , intent(in)  :: numfc
    integer , intent(in)  :: filterc(numfc)
    real(r8), pointer     :: pftarr(:)
    real(r8), pointer     :: colarr(:)







    integer :: fc,c,pi,p           
    integer , pointer :: npfts(:)
    integer , pointer :: pfti(:)
    integer , pointer :: pftf(:)
    real(r8), pointer :: wtcol(:)
    real(r8), pointer :: wtgcell(:)


    npfts   => clm3%g%l%c%npfts
    pfti    => clm3%g%l%c%pfti
    pftf    => clm3%g%l%c%pftf
    wtcol   => clm3%g%l%c%p%wtcol
    wtgcell => clm3%g%l%c%p%wtgcell

    do fc = 1,numfc
       c = filterc(fc)
       colarr(c) = 0._r8
       do p = pfti(c), pftf(c)
          if (wtgcell(p) > 0._r8) colarr(c) = colarr(c) + pftarr(p) * wtcol(p)
       end do
    end do

  end subroutine p2c_1d_filter







  subroutine p2c_2d_filter (lev, numfc, filterc, pftarr, colarr)





    use clm_varpar, only : max_pft_per_col


    implicit none
    integer , intent(in)  :: lev
    integer , intent(in)  :: numfc
    integer , intent(in)  :: filterc(numfc)
    real(r8), pointer     :: pftarr(:,:)
    real(r8), pointer     :: colarr(:,:)







    integer :: fc,c,pi,p,j    
    integer , pointer :: npfts(:)
    integer , pointer :: pfti(:)
    integer , pointer :: pftf(:)
    real(r8), pointer :: wtcol(:)


    npfts => clm3%g%l%c%npfts
    pfti  => clm3%g%l%c%pfti
    pftf  => clm3%g%l%c%pftf
    wtcol => clm3%g%l%c%p%wtcol

    do j = 1,lev
       do fc = 1,numfc
          c = filterc(fc)
          colarr(c,j) = 0._r8
          do p = pfti(c), pftf(c)
             colarr(c,j) = colarr(c,j) + pftarr(p,j) * wtcol(p)
          end do
       end do
    end do

  end subroutine p2c_2d_filter







  subroutine p2l_1d (lbp, ubp, lbc, ubc, lbl, ubl, parr, larr, &
       p2c_scale_type, c2l_scale_type)






    use clm_varpar, only : max_pft_per_lu


    implicit none
    integer , intent(in)  :: lbp, ubp              
    integer , intent(in)  :: lbc, ubc              
    integer , intent(in)  :: lbl, ubl              
    real(r8), intent(in)  :: parr(lbp:ubp)         
    real(r8), intent(out) :: larr(lbl:ubl)         
    character(len=*), intent(in) :: p2c_scale_type 
    character(len=*), intent(in) :: c2l_scale_type 







    integer  :: pi,p,c,l,index         
    logical  :: found                  
    real(r8) :: sumwt(lbl:ubl)         
    real(r8) :: scale_p2c(lbc:ubc)     
    real(r8) :: scale_c2l(lbc:ubc)     
    real(r8), pointer :: wtlunit(:)    
    integer , pointer :: pcolumn(:)    
    integer , pointer :: plandunit(:)  
    integer , pointer :: npfts(:)      
    integer , pointer :: pfti(:)       


    wtlunit   => clm3%g%l%c%p%wtlunit
    pcolumn   => clm3%g%l%c%p%column
    plandunit => clm3%g%l%c%p%landunit
    npfts     => clm3%g%l%npfts
    pfti      => clm3%g%l%pfti

    if (c2l_scale_type == 'unity') then
       do c = lbc,ubc
          scale_c2l(c) = 1.0_r8
       end do
    else
       write(6,*)'p2l_1d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if
    if (p2c_scale_type == 'unity') then
       do p = lbp,ubp
          scale_p2c(p) = 1.0_r8
       end do
    else
       write(6,*)'p2l_1d error: scale type ',p2c_scale_type,' not supported'
       call endrun()
    end if

    larr(:) = spval
    sumwt(:) = 0._r8
    do p = lbp,ubp
       if (wtlunit(p) /= 0._r8) then
          if (parr(p) /= spval) then
             c = pcolumn(p)
             l = plandunit(p)
             if (sumwt(l) == 0._r8) larr(l) = 0._r8
             larr(l) = larr(l) + parr(p) * scale_p2c(p) * scale_c2l(c) * wtlunit(p)
             sumwt(l) = sumwt(l) + wtlunit(p)
          end if
       end if
    end do
    found = .false.
    do l = lbl,ubl
       if (sumwt(l) > 1.0_r8 + 1.e-6_r8) then
          found = .true.
          index = l
       else if (sumwt(l) /= 0._r8) then
          larr(l) = larr(l)/sumwt(l)
       end if
    end do
    if (found) then
       write(6,*)'p2l_1d error: sumwt is greater than 1.0 at l= ',index
       call endrun()
    end if

  end subroutine p2l_1d







  subroutine p2l_2d(lbp, ubp, lbc, ubc, lbl, ubl, num2d, parr, larr, &
       p2c_scale_type, c2l_scale_type)






    use clm_varpar, only : max_pft_per_lu


    implicit none
    integer , intent(in)  :: lbp, ubp              
    integer , intent(in)  :: lbc, ubc              
    integer , intent(in)  :: lbl, ubl              
    integer , intent(in)  :: num2d                 
    real(r8), intent(in)  :: parr(lbp:ubp,num2d)   
    real(r8), intent(out) :: larr(lbl:ubl,num2d)   
    character(len=*), intent(in) :: p2c_scale_type 
    character(len=*), intent(in) :: c2l_scale_type 







    integer  :: j,pi,p,c,l,index       
    logical  :: found                  
    real(r8) :: sumwt(lbl:ubl)         
    real(r8) :: scale_p2c(lbc:ubc)     
    real(r8) :: scale_c2l(lbc:ubc)     
    real(r8), pointer :: wtlunit(:)    
    integer , pointer :: pcolumn(:)    
    integer , pointer :: plandunit(:)  
    integer , pointer :: npfts(:)      
    integer , pointer :: pfti(:)       


    wtlunit   => clm3%g%l%c%p%wtlunit
    pcolumn   => clm3%g%l%c%p%column
    plandunit => clm3%g%l%c%p%landunit
    npfts     => clm3%g%l%npfts
    pfti      => clm3%g%l%pfti

    if (c2l_scale_type == 'unity') then
       do c = lbc,ubc
          scale_c2l(c) = 1.0_r8
       end do
    else
       write(6,*)'p2l_2d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if
    if (p2c_scale_type == 'unity') then
       do p = lbp,ubp
          scale_p2c(p) = 1.0_r8
       end do
    else
       write(6,*)'p2l_2d error: scale type ',p2c_scale_type,' not supported'
       call endrun()
    end if

    larr(:,:) = spval
    do j = 1,num2d
       sumwt(:) = 0._r8
       do p = lbp,ubp
          if (wtlunit(p) /= 0._r8) then
             if (parr(p,j) /= spval) then
                c = pcolumn(p)
                l = plandunit(p)
                if (sumwt(l) == 0._r8) larr(l,j) = 0._r8
                larr(l,j) = larr(l,j) + parr(p,j) * scale_p2c(p) * scale_c2l(c) * wtlunit(p)
                sumwt(l) = sumwt(l) + wtlunit(p)
             end if
          end if
       end do
       found = .false.
       do l = lbl,ubl
          if (sumwt(l) > 1.0_r8 + 1.e-6_r8) then
             found = .true.
             index = l
          else if (sumwt(l) /= 0._r8) then
             larr(l,j) = larr(l,j)/sumwt(l)
          end if
       end do
       if (found) then
          write(6,*)'p2l_2d error: sumwt is greater than 1.0 at l= ',index,' j= ',j
          call endrun()
       end if
    end do

  end subroutine p2l_2d







  subroutine p2g_1d(lbp, ubp, lbc, ubc, lbl, ubl, lbg, ubg, parr, garr, &
       p2c_scale_type, c2l_scale_type, l2g_scale_type)






    use clm_varpar, only : max_pft_per_gcell


    implicit none
    integer , intent(in)  :: lbp, ubp            
    integer , intent(in)  :: lbc, ubc            
    integer , intent(in)  :: lbl, ubl            
    integer , intent(in)  :: lbg, ubg            
    real(r8), intent(in)  :: parr(lbp:ubp)       
    real(r8), intent(out) :: garr(lbg:ubg)       
    character(len=*), intent(in) :: p2c_scale_type 
    character(len=*), intent(in) :: c2l_scale_type 
    character(len=*), intent(in) :: l2g_scale_type 






    integer  :: pi,p,c,l,g,index       
    logical  :: found                  
    real(r8) :: scale_p2c(lbp:ubp)     
    real(r8) :: scale_c2l(lbc:ubc)     
    real(r8) :: scale_l2g(lbl:ubl)     
    real(r8) :: sumwt(lbg:ubg)         
    real(r8), pointer :: wtgcell(:)    
    integer , pointer :: pcolumn(:)    
    integer , pointer :: plandunit(:)  
    integer , pointer :: pgridcell(:)  
    integer , pointer :: npfts(:)      
    integer , pointer :: pfti(:)       


    wtgcell   => clm3%g%l%c%p%wtgcell
    pcolumn   => clm3%g%l%c%p%column
    pgridcell => clm3%g%l%c%p%gridcell
    plandunit => clm3%g%l%c%p%landunit
    npfts     => clm3%g%npfts
    pfti      => clm3%g%pfti

    if (l2g_scale_type == 'unity') then
       do l = lbl,ubl
          scale_l2g(l) = 1.0_r8
       end do
    else
       write(6,*)'p2g_1d error: scale type ',l2g_scale_type,' not supported'
       call endrun()
    end if
    if (c2l_scale_type == 'unity') then
       do c = lbc,ubc
          scale_c2l(c) = 1.0_r8
       end do
    else
       write(6,*)'p2g_1d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if
    if (p2c_scale_type == 'unity') then
       do p = lbp,ubp
          scale_p2c(p) = 1.0_r8
       end do
    else
       write(6,*)'p2g_1d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if

    garr(:) = spval
    sumwt(:) = 0._r8
    do p = lbp,ubp
       if (wtgcell(p) /= 0._r8) then
          if (parr(p) /= spval) then
             c = pcolumn(p)
             l = plandunit(p)
             g = pgridcell(p)
             if (sumwt(g) == 0._r8) garr(g) = 0._r8
             garr(g) = garr(g) + parr(p) * scale_p2c(p) * scale_c2l(c) * scale_l2g(l) * wtgcell(p)
             sumwt(g) = sumwt(g) + wtgcell(p)
          end if
       end if
    end do
    found = .false.
    do g = lbg, ubg
       if (sumwt(g) > 1.0_r8 + 1.e-6_r8) then
          found = .true.
          index = g
       else if (sumwt(g) /= 0._r8) then
          garr(g) = garr(g)/sumwt(g)
       end if
    end do
    if (found) then
       write(6,*)'p2g_1d error: sumwt is greater than 1.0 at g= ',index
       call endrun()
    end if

  end subroutine p2g_1d







  subroutine p2g_2d(lbp, ubp, lbc, ubc, lbl, ubl, lbg, ubg, num2d, &
       parr, garr, p2c_scale_type, c2l_scale_type, l2g_scale_type)






    use clm_varpar, only : max_pft_per_gcell


    implicit none
    integer , intent(in)  :: lbp, ubp              
    integer , intent(in)  :: lbc, ubc              
    integer , intent(in)  :: lbl, ubl              
    integer , intent(in)  :: lbg, ubg              
    integer , intent(in)  :: num2d                 
    real(r8), intent(in)  :: parr(lbp:ubp,num2d)   
    real(r8), intent(out) :: garr(lbg:ubg,num2d)   
    character(len=*), intent(in) :: p2c_scale_type 
    character(len=*), intent(in) :: c2l_scale_type 
    character(len=*), intent(in) :: l2g_scale_type 







    integer  :: j,pi,p,c,l,g,index     
    logical  :: found                  
    real(r8) :: scale_p2c(lbp:ubp)     
    real(r8) :: scale_c2l(lbc:ubc)     
    real(r8) :: scale_l2g(lbl:ubl)     
    real(r8) :: sumwt(lbg:ubg)         
    real(r8), pointer :: wtgcell(:)    
    integer , pointer :: pcolumn(:)    
    integer , pointer :: plandunit(:)  
    integer , pointer :: pgridcell(:)  
    integer , pointer :: npfts(:)      
    integer , pointer :: pfti(:)       


    wtgcell   => clm3%g%l%c%p%wtgcell
    pcolumn   => clm3%g%l%c%p%column
    pgridcell => clm3%g%l%c%p%gridcell
    plandunit => clm3%g%l%c%p%landunit
    npfts     => clm3%g%npfts
    pfti      => clm3%g%pfti

    if (l2g_scale_type == 'unity') then
       do l = lbl,ubl
          scale_l2g(l) = 1.0_r8
       end do
    else
       write(6,*)'p2g_2d error: scale type ',l2g_scale_type,' not supported'
       call endrun()
    end if
    if (c2l_scale_type == 'unity') then
       do c = lbc,ubc
          scale_c2l(c) = 1.0_r8
       end do
    else
       write(6,*)'p2g_2d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if
    if (p2c_scale_type == 'unity') then
       do p = lbp,ubp
          scale_p2c(p) = 1.0_r8
       end do
    else
       write(6,*)'p2g_2d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if

    garr(:,:) = spval
    do j = 1,num2d
       sumwt(:) = 0._r8
       do p = lbp,ubp
          if (wtgcell(p) /= 0._r8) then
             if (parr(p,j) /= spval) then
                c = pcolumn(p)
                l = plandunit(p)
                g = pgridcell(p)
                if (sumwt(g) == 0._r8) garr(g,j) = 0._r8
                garr(g,j) = garr(g,j) + parr(p,j) * scale_p2c(p) * scale_c2l(c) * scale_l2g(l) * wtgcell(p)
                sumwt(g) = sumwt(g) + wtgcell(p)
             end if
          end if
       end do
       found = .false.
       do g = lbg, ubg
          if (sumwt(g) > 1.0_r8 + 1.e-6_r8) then
             found = .true.
             index = g
          else if (sumwt(g) /= 0._r8) then
             garr(g,j) = garr(g,j)/sumwt(g)
          end if
       end do
       if (found) then
          write(6,*)'p2g_2d error: sumwt gt 1.0 at g/sumwt = ',index,sumwt(index)
          call endrun()
       end if
    end do

  end subroutine p2g_2d







  subroutine c2l_1d (lbc, ubc, lbl, ubl, carr, larr, c2l_scale_type)






    implicit none
    integer , intent(in)  :: lbc, ubc      
    integer , intent(in)  :: lbl, ubl      
    real(r8), intent(in)  :: carr(lbc:ubc) 
    real(r8), intent(out) :: larr(lbl:ubl) 
    character(len=*), intent(in) :: c2l_scale_type 







    integer  :: ci,c,l,index           
    integer  :: max_col_per_lu         
    logical  :: found                  
    real(r8) :: scale_c2l(lbc:ubc)     
    real(r8) :: sumwt(lbl:ubl)         
    real(r8), pointer :: wtlunit(:)    
    integer , pointer :: clandunit(:)  
    integer , pointer :: ncolumns(:)   
    integer , pointer :: coli(:)       


    wtlunit   => clm3%g%l%c%wtlunit
    clandunit => clm3%g%l%c%landunit
    ncolumns  => clm3%g%l%ncolumns
    coli      => clm3%g%l%coli

    if (c2l_scale_type == 'unity') then
       do c = lbc,ubc
          scale_c2l(c) = 1.0_r8
       end do
    else
       write(6,*)'c2l_1d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if

    larr(:) = spval
    sumwt(:) = 0._r8
    do c = lbc,ubc
       if (wtlunit(c) /= 0._r8) then
          if (carr(c) /= spval) then
             l = clandunit(c)
             if (sumwt(l) == 0._r8) larr(l) = 0._r8
             larr(l) = larr(l) + carr(c) * scale_c2l(c) * wtlunit(c)
             sumwt(l) = sumwt(l) + wtlunit(c)
          end if
       end if
    end do
    found = .false.
    do l = lbl,ubl
       if (sumwt(l) > 1.0_r8 + 1.e-6_r8) then
          found = .true.
          index = l
       else if (sumwt(l) /= 0._r8) then
          larr(l) = larr(l)/sumwt(l)
       end if
    end do
    if (found) then
       write(6,*)'c2l_1d error: sumwt is greater than 1.0 at l= ',index
       call endrun()
    end if

  end subroutine c2l_1d







  subroutine c2l_2d (lbc, ubc, lbl, ubl, num2d, carr, larr, c2l_scale_type)






    implicit none
    integer , intent(in)  :: lbc, ubc            
    integer , intent(in)  :: lbl, ubl            
    integer , intent(in)  :: num2d               
    real(r8), intent(in)  :: carr(lbc:ubc,num2d) 
    real(r8), intent(out) :: larr(lbl:ubl,num2d) 
    character(len=*), intent(in) :: c2l_scale_type 







    integer  :: j,l,ci,c,index         
    integer  :: max_col_per_lu         
    logical  :: found                  
    real(r8) :: scale_c2l(lbc:ubc)        
    real(r8) :: sumwt(lbl:ubl)         
    real(r8), pointer :: wtlunit(:)    
    integer , pointer :: clandunit(:)  
    integer , pointer :: ncolumns(:)   
    integer , pointer :: coli(:)       


    wtlunit   => clm3%g%l%c%wtlunit
    clandunit => clm3%g%l%c%landunit
    ncolumns  => clm3%g%l%ncolumns
    coli      => clm3%g%l%coli

    if (c2l_scale_type == 'unity') then
       do c = lbc,ubc
          scale_c2l(c) = 1.0_r8
       end do
    else
       write(6,*)'c2l_2d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if


    larr(:,:) = spval
    do j = 1,num2d
       sumwt(:) = 0._r8
       do c = lbc,ubc
          if (wtlunit(c) /= 0._r8) then
             if (carr(c,j) /= spval) then
                l = clandunit(c)
                if (sumwt(l) == 0._r8) larr(l,j) = 0._r8
                larr(l,j) = larr(l,j) + carr(c,j) * scale_c2l(c) * wtlunit(c)
                sumwt(l) = sumwt(l) + wtlunit(c)
             end if
          end if
       end do
       found = .false.
       do l = lbl,ubl
          if (sumwt(l) > 1.0_r8 + 1.e-6_r8) then
             found = .true.
             index = l
          else if (sumwt(l) /= 0._r8) then
             larr(l,j) = larr(l,j)/sumwt(l)
          end if
       end do
       if (found) then
          write(6,*)'c2l_2d error: sumwt is greater than 1.0 at l= ',index,' lev= ',j
          call endrun()
       end if
    end do

  end subroutine c2l_2d







  subroutine c2g_1d(lbc, ubc, lbl, ubl, lbg, ubg, carr, garr, &
       c2l_scale_type, l2g_scale_type)






    implicit none
    integer , intent(in)  :: lbc, ubc              
    integer , intent(in)  :: lbl, ubl              
    integer , intent(in)  :: lbg, ubg              
    real(r8), intent(in)  :: carr(lbc:ubc)         
    real(r8), intent(out) :: garr(lbg:ubg)         
    character(len=*), intent(in) :: c2l_scale_type 
    character(len=*), intent(in) :: l2g_scale_type 







    integer  :: ci,c,l,g,index         
    integer  :: max_col_per_gcell      
    logical  :: found                  
    real(r8) :: scale_c2l(lbc:ubc)     
    real(r8) :: scale_l2g(lbl:ubl)     
    real(r8) :: sumwt(lbg:ubg)         
    real(r8), pointer :: wtgcell(:)    
    integer , pointer :: clandunit(:)  
    integer , pointer :: cgridcell(:)  
    integer , pointer :: ncolumns(:)   
    integer , pointer :: coli(:)       


    wtgcell   => clm3%g%l%c%wtgcell
    clandunit => clm3%g%l%c%landunit
    cgridcell => clm3%g%l%c%gridcell
    ncolumns  => clm3%g%ncolumns
    coli      => clm3%g%coli

    if (l2g_scale_type == 'unity') then
       do l = lbl,ubl
          scale_l2g(l) = 1.0_r8
       end do
    else
       write(6,*)'c2l_1d error: scale type ',l2g_scale_type,' not supported'
       call endrun()
    end if
    if (c2l_scale_type == 'unity') then
       do c = lbc,ubc
          scale_c2l(c) = 1.0_r8
       end do
    else
       write(6,*)'c2l_1d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if

    garr(:) = spval
    sumwt(:) = 0._r8
    do c = lbc,ubc
       if ( wtgcell(c) /= 0._r8) then
          if (carr(c) /= spval) then
             l = clandunit(c)
             g = cgridcell(c)
             if (sumwt(g) == 0._r8) garr(g) = 0._r8
             garr(g) = garr(g) + carr(c) * scale_c2l(c) * scale_l2g(l) * wtgcell(c)
             sumwt(g) = sumwt(g) + wtgcell(c)
          end if
       end if
    end do
    found = .false.
    do g = lbg, ubg
       if (sumwt(g) > 1.0_r8 + 1.e-6_r8) then
          found = .true.
          index = g
       else if (sumwt(g) /= 0._r8) then
          garr(g) = garr(g)/sumwt(g)
       end if
    end do
    if (found) then
       write(6,*)'c2g_1d error: sumwt is greater than 1.0 at g= ',index
       call endrun()
    end if

  end subroutine c2g_1d







  subroutine c2g_2d(lbc, ubc, lbl, ubl, lbg, ubg, num2d, carr, garr, &
       c2l_scale_type, l2g_scale_type)






    implicit none
    integer , intent(in)  :: lbc, ubc              
    integer , intent(in)  :: lbl, ubl              
    integer , intent(in)  :: lbg, ubg              
    integer , intent(in)  :: num2d                 
    real(r8), intent(in)  :: carr(lbc:ubc,num2d)   
    real(r8), intent(out) :: garr(lbg:ubg,num2d)   
    character(len=*), intent(in) :: c2l_scale_type 
    character(len=*), intent(in) :: l2g_scale_type 







    integer  :: j,ci,c,g,l,index       
    integer  :: max_col_per_gcell      
    logical  :: found                  
    real(r8) :: scale_c2l(lbc:ubc)     
    real(r8) :: scale_l2g(lbl:ubl)     
    real(r8) :: sumwt(lbg:ubg)         
    real(r8), pointer :: wtgcell(:)    
    integer , pointer :: clandunit(:)  
    integer , pointer :: cgridcell(:)  
    integer , pointer :: ncolumns(:)   
    integer , pointer :: coli(:)       


    wtgcell   => clm3%g%l%c%wtgcell
    clandunit => clm3%g%l%c%landunit
    cgridcell => clm3%g%l%c%gridcell
    ncolumns  => clm3%g%ncolumns
    coli      => clm3%g%coli

    if (l2g_scale_type == 'unity') then
       do l = lbl,ubl
          scale_l2g(l) = 1.0_r8
       end do
    else
       write(6,*)'c2g_2d error: scale type ',l2g_scale_type,' not supported'
       call endrun()
    end if
    if (c2l_scale_type == 'unity') then
       do c = lbc,ubc
          scale_c2l(c) = 1.0_r8
       end do
    else
       write(6,*)'c2g_2d error: scale type ',c2l_scale_type,' not supported'
       call endrun()
    end if


    garr(:,:) = spval
    do j = 1,num2d
       sumwt(:) = 0._r8
       do c = lbc,ubc
          if (wtgcell(c) /= 0._r8) then
             if (carr(c,j) /= spval) then
                l = clandunit(c)
                g = cgridcell(c)
                if (sumwt(g) == 0._r8) garr(g,j) = 0._r8
                garr(g,j) = garr(g,j) + carr(c,j) * scale_c2l(c) * scale_l2g(l) * wtgcell(c)
                sumwt(g) = sumwt(g) + wtgcell(c)
             end if
          end if
       end do
       found = .false.
       do g = lbg, ubg
          if (sumwt(g) > 1.0_r8 + 1.e-6_r8) then
             found = .true.
             index = g
          else if (sumwt(g) /= 0._r8) then
             garr(g,j) = garr(g,j)/sumwt(g)
          end if
       end do
       if (found) then
          write(6,*)'c2g_2d error: sumwt is greater than 1.0 at g= ',index
          call endrun()
       end if
    end do

  end subroutine c2g_2d







  subroutine l2g_1d(lbl, ubl, lbg, ubg, larr, garr, l2g_scale_type)






    implicit none
    integer , intent(in)  :: lbl, ubl       
    integer , intent(in)  :: lbg, ubg       
    real(r8), intent(in)  :: larr(lbl:ubl)  
    real(r8), intent(out) :: garr(lbg:ubg)  
    character(len=*), intent(in) :: l2g_scale_type 







    integer  :: li,l,g,index           
    integer  :: max_lu_per_gcell       
    logical  :: found                  
    real(r8) :: scale_l2g(lbl:ubl)     
    real(r8) :: sumwt(lbg:ubg)         
    real(r8), pointer :: wtgcell(:)    
    integer , pointer :: lgridcell(:)  
    integer , pointer :: nlandunits(:) 
    integer , pointer :: luni(:)       


    wtgcell    => clm3%g%l%wtgcell
    lgridcell  => clm3%g%l%gridcell
    nlandunits => clm3%g%nlandunits
    luni       => clm3%g%luni

    if (l2g_scale_type == 'unity') then
       do l = lbl,ubl
          scale_l2g(l) = 1.0_r8
       end do
    else
       write(6,*)'l2g_1d error: scale type ',l2g_scale_type,' not supported'
       call endrun()
    end if

    garr(:) = spval
    sumwt(:) = 0._r8
    do l = lbl,ubl
       if (wtgcell(l) /= 0._r8) then
          if (larr(l) /= spval) then
             g = lgridcell(l)
             if (sumwt(g) == 0._r8) garr(g) = 0._r8
             garr(g) = garr(g) + larr(l) * scale_l2g(l) * wtgcell(l)
             sumwt(g) = sumwt(g) + wtgcell(l)
          end if
       end if
    end do
    found = .false.
    do g = lbg, ubg
       if (sumwt(g) > 1.0_r8 + 1.e-6_r8) then
          found = .true.
          index = g
       else if (sumwt(g) /= 0._r8) then
          garr(g) = garr(g)/sumwt(g)
       end if
    end do
    if (found) then
       write(6,*)'l2g_1d error: sumwt is greater than 1.0 at g= ',index
       call endrun()
    end if

  end subroutine l2g_1d







  subroutine l2g_2d(lbl, ubl, lbg, ubg, num2d, larr, garr, l2g_scale_type)






    implicit none
    integer , intent(in)  :: lbl, ubl             
    integer , intent(in)  :: lbg, ubg             
    integer , intent(in)  :: num2d                
    real(r8), intent(in)  :: larr(lbl:ubl,num2d)  
    real(r8), intent(out) :: garr(lbg:ubg,num2d)  
    character(len=*), intent(in) :: l2g_scale_type 







    integer  :: j,g,li,l,index         
    integer  :: max_lu_per_gcell       
    logical  :: found                  
    real(r8) :: scale_l2g(lbl:ubl)     
    real(r8) :: sumwt(lbg:ubg)         
    real(r8), pointer :: wtgcell(:)    
    integer , pointer :: lgridcell(:)  
    integer , pointer :: nlandunits(:) 
    integer , pointer :: luni(:)       


    wtgcell   => clm3%g%l%wtgcell
    lgridcell => clm3%g%l%gridcell
    nlandunits => clm3%g%nlandunits
    luni       => clm3%g%luni

    if (l2g_scale_type == 'unity') then
       do l = lbl,ubl
          scale_l2g(l) = 1.0_r8
       end do
    else
       write(6,*)'l2g_2d error: scale type ',l2g_scale_type,' not supported'
       call endrun()
    end if


    garr(:,:) = spval
    do j = 1,num2d
       sumwt(:) = 0._r8
       do l = lbl,ubl
          if (wtgcell(l) /= 0._r8) then
             if (larr(l,j) /= spval) then
                g = lgridcell(l)
                if (sumwt(g) == 0._r8) garr(g,j) = 0._r8
                garr(g,j) = garr(g,j) + larr(l,j) * scale_l2g(l) * wtgcell(l)
                sumwt(g) = sumwt(g) + wtgcell(l)
             end if
          end if
       end do
       found = .false.
       do g = lbg,ubg
          if (sumwt(g) > 1.0_r8 + 1.e-6_r8) then
             found = .true.
             index= g
          else if (sumwt(g) /= 0._r8) then
             garr(g,j) = garr(g,j)/sumwt(g)
          end if
       end do
       if (found) then
          write(6,*)'l2g_2d error: sumwt is greater than 1.0 at g= ',index,' lev= ',j
          call endrun()
       end if
    end do

  end subroutine l2g_2d

end module subgridAveMod
