







module Biogeophysics2Mod











  use shr_kind_mod, only: r8 => shr_kind_r8


  implicit none
  save


  public :: Biogeophysics2   







contains







  subroutine Biogeophysics2 (lbc, ubc, lbp, ubp, num_nolakec, &
             filter_nolakec, num_nolakep, filter_nolakep)


































    use clmtype
    


    use globals, only : dtime,nstep
    use clm_varcon        , only : hvap, cpair, grav, vkc, tfrz, sb
    use clm_varpar        , only : nlevsno, nlevsoi, max_pft_per_col
    use SoilTemperatureMod, only : SoilTemperature
    use subgridAveMod     , only : p2c


    implicit none
    integer, intent(in) :: lbp, ubp                    
    integer, intent(in) :: lbc, ubc                    
    integer, intent(in) :: num_nolakec                 
    integer, intent(in) :: filter_nolakec(ubc-lbc+1)   
    integer, intent(in) :: num_nolakep                 
    integer, intent(in) :: filter_nolakep(ubp-lbp+1)   














    integer , pointer :: pcolumn(:)         
    integer , pointer :: pgridcell(:)       
    real(r8), pointer :: pwtgcell(:)        
    integer , pointer :: npfts(:)           
    integer , pointer :: pfti(:)            
    integer , pointer :: snl(:)             
    logical , pointer :: do_capsnow(:)      
    real(r8), pointer :: forc_lwrad(:)      
    real(r8), pointer :: emg(:)             
    real(r8), pointer :: htvp(:)            
    real(r8), pointer :: t_grnd(:)          
    integer , pointer :: frac_veg_nosno(:)  
    real(r8), pointer :: cgrnds(:)          
    real(r8), pointer :: cgrndl(:)          
    real(r8), pointer :: sabg(:)            
    real(r8), pointer :: dlrad(:)           
    real(r8), pointer :: ulrad(:)           
    real(r8), pointer :: eflx_sh_veg(:)     
    real(r8), pointer :: qflx_evap_veg(:)   
    real(r8), pointer :: qflx_tran_veg(:)   
    real(r8), pointer :: qflx_evap_can(:)   
    real(r8), pointer :: wtcol(:)           
    real(r8), pointer :: tssbef(:,:)        
    real(r8), pointer :: t_soisno(:,:)      
    real(r8), pointer :: h2osoi_ice(:,:)    
    real(r8), pointer :: h2osoi_liq(:,:)    



    real(r8), pointer :: eflx_sh_grnd(:)    
    real(r8), pointer :: qflx_evap_soi(:)   
    real(r8), pointer :: qflx_snowcap(:)    



    real(r8), pointer :: dt_grnd(:)         
    real(r8), pointer :: eflx_soil_grnd(:)  
    real(r8), pointer :: eflx_sh_tot(:)     
    real(r8), pointer :: qflx_evap_tot(:)   
    real(r8), pointer :: eflx_lh_tot(:)     
    real(r8), pointer :: qflx_evap_grnd(:)  
    real(r8), pointer :: qflx_sub_snow(:)   
    real(r8), pointer :: qflx_dew_snow(:)   
    real(r8), pointer :: qflx_dew_grnd(:)   
    real(r8), pointer :: eflx_lwrad_out(:)  
    real(r8), pointer :: eflx_lwrad_net(:)  
    real(r8), pointer :: eflx_lh_vege(:)    
    real(r8), pointer :: eflx_lh_vegt(:)    
    real(r8), pointer :: eflx_lh_grnd(:)    
    real(r8), pointer :: errsoi_pft(:)      
    real(r8), pointer :: errsoi_col(:)      





    integer  :: p,c,g,j,pi,l         
    integer  :: fc,fp                


    real(r8) :: egsmax(lbc:ubc)      
    real(r8) :: egirat(lbc:ubc)      
    real(r8) :: tinc(lbc:ubc)        
    real(r8) :: xmf(lbc:ubc)         
    real(r8) :: sumwt(lbc:ubc)       
    real(r8) :: evaprat(lbp:ubp)     
    real(r8) :: save_qflx_evap_soi   
    real(r8) :: topsoil_evap_tot(lbc:ubc)          
    real(r8) :: fact(lbc:ubc, -nlevsno+1:nlevsoi)  


    

    forc_lwrad => clm_a2l%forc_lwrad

    

    npfts      => clm3%g%l%c%npfts
    pfti       => clm3%g%l%c%pfti
    snl        => clm3%g%l%c%cps%snl
    do_capsnow => clm3%g%l%c%cps%do_capsnow
    htvp       => clm3%g%l%c%cps%htvp
    emg        => clm3%g%l%c%cps%emg
    t_grnd     => clm3%g%l%c%ces%t_grnd
    dt_grnd    => clm3%g%l%c%ces%dt_grnd
    t_soisno   => clm3%g%l%c%ces%t_soisno
    tssbef     => clm3%g%l%c%ces%tssbef
    h2osoi_ice => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq => clm3%g%l%c%cws%h2osoi_liq
    errsoi_col => clm3%g%l%c%cebal%errsoi

    

    pcolumn        => clm3%g%l%c%p%column
    pgridcell      => clm3%g%l%c%p%gridcell
    pwtgcell       => clm3%g%l%c%p%wtgcell
    frac_veg_nosno => clm3%g%l%c%p%pps%frac_veg_nosno
    sabg           => clm3%g%l%c%p%pef%sabg
    dlrad          => clm3%g%l%c%p%pef%dlrad
    ulrad          => clm3%g%l%c%p%pef%ulrad
    eflx_sh_grnd   => clm3%g%l%c%p%pef%eflx_sh_grnd
    eflx_sh_veg    => clm3%g%l%c%p%pef%eflx_sh_veg
    qflx_evap_soi  => clm3%g%l%c%p%pwf%qflx_evap_soi
    qflx_evap_veg  => clm3%g%l%c%p%pwf%qflx_evap_veg
    qflx_tran_veg  => clm3%g%l%c%p%pwf%qflx_tran_veg
    qflx_evap_can  => clm3%g%l%c%p%pwf%qflx_evap_can
    qflx_snowcap   => clm3%g%l%c%p%pwf%qflx_snowcap
    qflx_evap_tot  => clm3%g%l%c%p%pwf%qflx_evap_tot
    qflx_evap_grnd => clm3%g%l%c%p%pwf%qflx_evap_grnd
    qflx_sub_snow  => clm3%g%l%c%p%pwf%qflx_sub_snow
    qflx_dew_snow  => clm3%g%l%c%p%pwf%qflx_dew_snow
    qflx_dew_grnd  => clm3%g%l%c%p%pwf%qflx_dew_grnd
    eflx_soil_grnd => clm3%g%l%c%p%pef%eflx_soil_grnd
    eflx_sh_tot    => clm3%g%l%c%p%pef%eflx_sh_tot
    eflx_lh_tot    => clm3%g%l%c%p%pef%eflx_lh_tot
    eflx_lwrad_out => clm3%g%l%c%p%pef%eflx_lwrad_out
    eflx_lwrad_net => clm3%g%l%c%p%pef%eflx_lwrad_net
    eflx_lh_vege   => clm3%g%l%c%p%pef%eflx_lh_vege
    eflx_lh_vegt   => clm3%g%l%c%p%pef%eflx_lh_vegt
    eflx_lh_grnd   => clm3%g%l%c%p%pef%eflx_lh_grnd
    cgrnds         => clm3%g%l%c%p%pef%cgrnds
    cgrndl         => clm3%g%l%c%p%pef%cgrndl
    eflx_sh_grnd   => clm3%g%l%c%p%pef%eflx_sh_grnd
    qflx_evap_soi  => clm3%g%l%c%p%pwf%qflx_evap_soi
    errsoi_pft     => clm3%g%l%c%p%pebal%errsoi
    wtcol          => clm3%g%l%c%p%wtcol

    



    

    call SoilTemperature(lbc, ubc, num_nolakec, filter_nolakec, xmf , fact)



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       j = snl(c)+1

       
       

       tinc(c) = t_soisno(c,j) - tssbef(c,j)

       

       egsmax(c) = (h2osoi_ice(c,j)+h2osoi_liq(c,j)) / dtime

       

       if (egsmax(c) < 0._r8) then
          egsmax(c) = 0._r8
       end if
    end do

    
    
    
    
    
    
    



    do fp = 1,num_nolakep
       p = filter_nolakep(fp)
       c = pcolumn(p)
       eflx_sh_grnd(p) = eflx_sh_grnd(p) + tinc(c)*cgrnds(p)
       qflx_evap_soi(p) = qflx_evap_soi(p) + tinc(c)*cgrndl(p)
    end do

    
    



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       topsoil_evap_tot(c) = 0._r8
       sumwt(c) = 0._r8
    end do

    do pi = 1,max_pft_per_col


       do fc = 1,num_nolakec
          c = filter_nolakec(fc)
          if ( pi <= npfts(c) ) then
             p = pfti(c) + pi - 1
             if (pwtgcell(p)>0._r8) then
                topsoil_evap_tot(c) = topsoil_evap_tot(c) + qflx_evap_soi(p) * wtcol(p)
             end if
          end if
       end do
    end do

    



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       if (topsoil_evap_tot(c) > egsmax(c)) then
          egirat(c) = (egsmax(c)/topsoil_evap_tot(c))
       else
          egirat(c) = 1.0_r8
       end if
    end do



    do fp = 1,num_nolakep
       p = filter_nolakep(fp)
       c = pcolumn(p)
       g = pgridcell(p)
       j = snl(c)+1

       
       

       if (egirat(c) < 1.0_r8) then
          save_qflx_evap_soi = qflx_evap_soi(p)
          qflx_evap_soi(p) = qflx_evap_soi(p) * egirat(c)
          eflx_sh_grnd(p) = eflx_sh_grnd(p) + (save_qflx_evap_soi - qflx_evap_soi(p))*htvp(c)
       end if

       

       eflx_soil_grnd(p) = sabg(p) + dlrad(p) + (1-frac_veg_nosno(p))*emg(c)*forc_lwrad(g) &
            - emg(c)*sb*tssbef(c,j)**3*(tssbef(c,j) + 4._r8*tinc(c)) &
            - (eflx_sh_grnd(p)+qflx_evap_soi(p)*htvp(c))

       

       eflx_sh_tot(p) = eflx_sh_veg(p) + eflx_sh_grnd(p)
       qflx_evap_tot(p) = qflx_evap_veg(p) + qflx_evap_soi(p)
       eflx_lh_tot(p)= hvap*qflx_evap_veg(p) + htvp(c)*qflx_evap_soi(p)

       
       

       qflx_evap_grnd(p) = 0._r8
       qflx_sub_snow(p) = 0._r8
       qflx_dew_snow(p) = 0._r8
       qflx_dew_grnd(p) = 0._r8

       if (qflx_evap_soi(p) >= 0._r8) then
          
	  
	  if ((h2osoi_liq(c,j)+h2osoi_ice(c,j)) > 0.) then
             qflx_evap_grnd(p) = max(qflx_evap_soi(p)*(h2osoi_liq(c,j)/(h2osoi_liq(c,j)+h2osoi_ice(c,j))), 0._r8)
	  else
	     qflx_evap_grnd(p) = 0.
	  end if
          qflx_sub_snow(p) = qflx_evap_soi(p) - qflx_evap_grnd(p)
       else
          if (t_grnd(c) < tfrz) then
             qflx_dew_snow(p) = abs(qflx_evap_soi(p))
          else
             qflx_dew_grnd(p) = abs(qflx_evap_soi(p))
          end if
       end if

       
       
       

       if (snl(c) < 0 .and. do_capsnow(c)) then
          qflx_snowcap(p) = qflx_snowcap(p) + qflx_dew_snow(p) + qflx_dew_grnd(p)
       end if

       
       

       eflx_lwrad_out(p) = ulrad(p) &
            + (1-frac_veg_nosno(p))*(1._r8-emg(c))*forc_lwrad(g) &
            + (1-frac_veg_nosno(p))*emg(c)*sb * tssbef(c,j)**4 &
            + 4._r8*emg(c)*sb*tssbef(c,j)**3*tinc(c)

       

       qflx_evap_can(p)  = qflx_evap_veg(p) - qflx_tran_veg(p)
       eflx_lh_vege(p)   = (qflx_evap_veg(p) - qflx_tran_veg(p)) * hvap
       eflx_lh_vegt(p)   = qflx_tran_veg(p) * hvap
       eflx_lh_grnd(p)   = qflx_evap_soi(p) * htvp(c)
       eflx_lwrad_net(p) = eflx_lwrad_out(p) - forc_lwrad(g)

    end do

    



    do fp = 1,num_nolakep
       p = filter_nolakep(fp)
       c = pcolumn(p)
       errsoi_pft(p) = eflx_soil_grnd(p) - xmf(c)
    end do
    do j = -nlevsno+1,nlevsoi


       do fp = 1,num_nolakep
          p = filter_nolakep(fp)
          c = pcolumn(p)
          if (j >= snl(c)+1) then
             errsoi_pft(p) = errsoi_pft(p) - (t_soisno(c,j)-tssbef(c,j))/fact(c,j)
          end if
       end do
    end do

    
    

    call p2c(num_nolakec, filter_nolakec, errsoi_pft, errsoi_col)

  end subroutine Biogeophysics2

end module Biogeophysics2Mod
