






module CanopyFluxesMod
















   implicit none
   save


   public :: CanopyFluxes 


   private :: Stomata     










contains







  subroutine CanopyFluxes(lbg, ubg, lbc, ubc, lbp, ubp, &
                          num_nolakep, filter_nolakep)





























    use shr_kind_mod       , only : r8 => shr_kind_r8
    use clmtype
    
    use globals, only : dtime,nstep


    use clm_varpar         , only : nlevsoi, nlevsno
    use clm_varcon         , only : sb, cpair, hvap, vkc, grav, denice, &
                                    denh2o, tfrz, csoilc
    use QSatMod            , only : QSat
    use FrictionVelocityMod, only : FrictionVelocity, MoninObukIni



    implicit none
    integer, intent(in) :: lbg, ubg                    
    integer, intent(in) :: lbc, ubc                    
    integer, intent(in) :: lbp, ubp                    
    integer, intent(in) :: num_nolakep                 
    integer, intent(in) :: filter_nolakep(ubp-lbp+1)   



















   integer , pointer :: frac_veg_nosno(:) 
   integer , pointer :: ivt(:)         
   integer , pointer :: pcolumn(:)     
   integer , pointer :: plandunit(:)   
   integer , pointer :: pgridcell(:)   
   real(r8), pointer :: forc_th(:)     
   real(r8), pointer :: t_grnd(:)      
   real(r8), pointer :: thm(:)         
   real(r8), pointer :: qg(:)          
   real(r8), pointer :: thv(:)         
   real(r8), pointer :: z0mv(:)        
   real(r8), pointer :: z0hv(:)        
   real(r8), pointer :: z0qv(:)        
   real(r8), pointer :: z0mg(:)        
   real(r8), pointer :: dqgdT(:)       
   real(r8), pointer :: htvp(:)        
   real(r8), pointer :: emv(:)         
   real(r8), pointer :: emg(:)         
   real(r8), pointer :: forc_pbot(:)   
   real(r8), pointer :: forc_pco2(:)   
   
   



   real(r8), pointer :: forc_po2(:)    
   real(r8), pointer :: forc_q(:)      
   real(r8), pointer :: forc_u(:)      
   real(r8), pointer :: forc_v(:)      
   real(r8), pointer :: forc_hgt_u(:)  
   real(r8), pointer :: forc_rho(:)    
   real(r8), pointer :: forc_lwrad(:)  
   real(r8), pointer :: displa(:)      
   real(r8), pointer :: elai(:)        
   real(r8), pointer :: esai(:)        
   real(r8), pointer :: fdry(:)        
   real(r8), pointer :: fwet(:)        
   real(r8), pointer :: laisun(:)      
   real(r8), pointer :: laisha(:)      
   real(r8), pointer :: sabv(:)        
   real(r8), pointer :: watsat(:,:)    



   real(r8), pointer :: h2osoi_ice(:,:)
   real(r8), pointer :: h2osoi_liq(:,:)
   real(r8), pointer :: dz(:,:)        
   real(r8), pointer :: t_soisno(:,:)  
   real(r8), pointer :: sucsat(:,:)    
   real(r8), pointer :: bsw(:,:)       
   real(r8), pointer :: rootfr(:,:)    
   real(r8), pointer :: dleaf(:)       
   real(r8), pointer :: smpso(:)       
   real(r8), pointer :: smpsc(:)       
   real(r8), pointer :: frac_sno(:)    



   real(r8), pointer :: cgrnds(:)      
   real(r8), pointer :: cgrndl(:)      
   real(r8), pointer :: t_veg(:)       
   real(r8), pointer :: t_ref2m(:)     
   real(r8), pointer :: q_ref2m(:)     
   real(r8), pointer :: h2ocan(:)      
   real(r8), pointer :: cisun(:)       
   real(r8), pointer :: cisha(:)       



   real(r8), pointer :: cgrnd(:)           
   real(r8), pointer :: dlrad(:)           
   real(r8), pointer :: ulrad(:)           
   real(r8), pointer :: ram1(:)            
   real(r8), pointer :: btran(:)           
   real(r8), pointer :: rssun(:)           
   real(r8), pointer :: rssha(:)           
   real(r8), pointer :: psnsun(:)          
   real(r8), pointer :: psnsha(:)          
   
   
   real(r8), pointer :: alphapsnsun(:)     
   real(r8), pointer :: alphapsnsha(:)     
   
   real(r8), pointer :: qflx_tran_veg(:)   
   real(r8), pointer :: dt_veg(:)          
   real(r8), pointer :: qflx_evap_veg(:)   
   real(r8), pointer :: eflx_sh_veg(:)     
   real(r8), pointer :: taux(:)            
   real(r8), pointer :: tauy(:)            
   real(r8), pointer :: eflx_sh_grnd(:)    
   real(r8), pointer :: qflx_evap_soi(:)   
   real(r8), pointer :: fpsn(:)            
   real(r8), pointer :: rootr(:,:)         
   real(r8), pointer :: rresis(:,:)        





   real(r8), parameter :: btran0 = 0.0_r8  
   real(r8), parameter :: zii = 1000.0_r8  
   real(r8), parameter :: beta = 1.0_r8    
   real(r8), parameter :: delmax = 1.0_r8  
   real(r8), parameter :: dlemin = 0.1_r8  
   real(r8), parameter :: dtmin = 0.01_r8  
   integer , parameter :: itmax = 40       
   integer , parameter :: itmin = 2         


   real(r8) :: zldis(lbp:ubp)        
   real(r8) :: zeta                  
   real(r8) :: wc                    
   real(r8) :: dth(lbp:ubp)          
   real(r8) :: dthv(lbp:ubp)         
   real(r8) :: dqh(lbp:ubp)          
   real(r8) :: obu(lbp:ubp)          
   real(r8) :: um(lbp:ubp)           
   real(r8) :: ur(lbp:ubp)           
   real(r8) :: uaf                   
   real(r8) :: temp1(lbp:ubp)        
   real(r8) :: temp12m(lbp:ubp)      
   real(r8) :: temp2(lbp:ubp)        
   real(r8) :: temp22m(lbp:ubp)      
   real(r8) :: ustar(lbp:ubp)        
   real(r8) :: tstar                 
   real(r8) :: qstar                 
   real(r8) :: thvstar               
   real(r8) :: taf(lbp:ubp)          
   real(r8) :: qaf(lbp:ubp)          
   real(r8) :: rpp                   
   real(r8) :: rppdry                
   real(r8) :: cf                    
   real(r8) :: rb(lbp:ubp)           
   real(r8) :: rah(lbp:ubp,2)        
   real(r8) :: raw(lbp:ubp,2)        
   real(r8) :: wta                   
   real(r8) :: wtg(lbp:ubp)          
   real(r8) :: wtl                   
   real(r8) :: wta0(lbp:ubp)         
   real(r8) :: wtl0(lbp:ubp)         
   real(r8) :: wtg0                  
   real(r8) :: wtal(lbp:ubp)         
   real(r8) :: wtga                  
   real(r8) :: wtaq                  
   real(r8) :: wtlq                  
   real(r8) :: wtgq(lbp:ubp)         
   real(r8) :: wtaq0(lbp:ubp)        
   real(r8) :: wtlq0(lbp:ubp)        
   real(r8) :: wtgq0                 
   real(r8) :: wtalq(lbp:ubp)        
   real(r8) :: wtgaq                 
   real(r8) :: el(lbp:ubp)           
   real(r8) :: deldT                 
   real(r8) :: qsatl(lbp:ubp)        
   real(r8) :: qsatldT(lbp:ubp)      
   real(r8) :: air(lbp:ubp),bir(lbp:ubp),cir(lbp:ubp)  
   real(r8) :: dc1,dc2               
   real(r8) :: delt                  
   real(r8) :: delq(lbp:ubp)         
   real(r8) :: del(lbp:ubp)          
   real(r8) :: del2(lbp:ubp)         
   real(r8) :: dele(lbp:ubp)         
   real(r8) :: dels                  
   real(r8) :: det(lbp:ubp)          
   real(r8) :: efeb(lbp:ubp)         
   real(r8) :: efeold                
   real(r8) :: efpot                 
   real(r8) :: efe(lbp:ubp)          
   real(r8) :: efsh                  
   real(r8) :: obuold(lbp:ubp)       
   real(r8) :: tlbef(lbp:ubp)        
   real(r8) :: ecidif                
   real(r8) :: err(lbp:ubp)          
   real(r8) :: erre                  
   real(r8) :: co2(lbp:ubp)          
   
   
   real(r8) :: o2(lbp:ubp)           
   real(r8) :: svpts(lbp:ubp)        
   real(r8) :: eah(lbp:ubp)          
   real(r8) :: s_node                
   real(r8) :: smp_node              
   real(r8) :: vol_ice               
   real(r8) :: eff_porosity          
   real(r8) :: vol_liq               
   integer  :: itlef                 
   integer  :: nmozsgn(lbp:ubp)      
   real(r8) :: w                     
   real(r8) :: csoilcn               
   real(r8) :: fm(lbp:ubp)           
   real(r8) :: wtshi                 
   real(r8) :: wtsqi                 
   integer  :: j                     
   integer  :: p                     
   integer  :: c                     
   integer  :: l                     
   integer  :: g                     
   integer  :: fp                    
   integer  :: fn                    
   integer  :: fnorig                
   integer  :: fnold                 
   integer  :: f                     
   integer  :: filterp(ubp-lbp+1)    
   integer  :: fporig(ubp-lbp+1)     
   real(r8) :: displa_loc(lbp:ubp)   
   real(r8) :: z0mv_loc(lbp:ubp)     
   real(r8) :: z0hv_loc(lbp:ubp)     
   real(r8) :: z0qv_loc(lbp:ubp)     
   logical  :: found                 
   integer  :: index                 
   real(r8) :: www                   
   real(r8) :: rsoil                 


   

   forc_lwrad     => clm_a2l%forc_lwrad
   forc_pco2      => clm_a2l%forc_pco2
   forc_po2       => clm_a2l%forc_po2
   forc_q         => clm_a2l%forc_q
   forc_pbot      => clm_a2l%forc_pbot
   forc_u         => clm_a2l%forc_u
   forc_v         => clm_a2l%forc_v
   forc_th        => clm_a2l%forc_th
   forc_hgt_u     => clm_a2l%forc_hgt_u
   forc_rho       => clm_a2l%forc_rho

   

   t_soisno       => clm3%g%l%c%ces%t_soisno
   watsat         => clm3%g%l%c%cps%watsat



   h2osoi_ice     => clm3%g%l%c%cws%h2osoi_ice
   dz             => clm3%g%l%c%cps%dz
   h2osoi_liq     => clm3%g%l%c%cws%h2osoi_liq
   sucsat         => clm3%g%l%c%cps%sucsat
   bsw            => clm3%g%l%c%cps%bsw
   emg            => clm3%g%l%c%cps%emg
   t_grnd         => clm3%g%l%c%ces%t_grnd
   thm            => clm3%g%l%c%ces%thm
   qg             => clm3%g%l%c%cws%qg
   thv            => clm3%g%l%c%ces%thv
   dqgdT          => clm3%g%l%c%cws%dqgdT
   htvp           => clm3%g%l%c%cps%htvp
   z0mg           => clm3%g%l%c%cps%z0mg
   frac_sno       => clm3%g%l%c%cps%frac_sno

   

   ivt            => clm3%g%l%c%p%itype
   pcolumn        => clm3%g%l%c%p%column
   plandunit      => clm3%g%l%c%p%landunit
   pgridcell      => clm3%g%l%c%p%gridcell
   frac_veg_nosno => clm3%g%l%c%p%pps%frac_veg_nosno
   btran          => clm3%g%l%c%p%pps%btran
   rootfr         => clm3%g%l%c%p%pps%rootfr
   rootr          => clm3%g%l%c%p%pps%rootr
   rresis         => clm3%g%l%c%p%pps%rresis
   emv            => clm3%g%l%c%p%pps%emv
   t_veg          => clm3%g%l%c%p%pes%t_veg
   displa         => clm3%g%l%c%p%pps%displa
   z0mv           => clm3%g%l%c%p%pps%z0mv
   z0hv           => clm3%g%l%c%p%pps%z0hv
   z0qv           => clm3%g%l%c%p%pps%z0qv
   ram1           => clm3%g%l%c%p%pps%ram1
   rssun          => clm3%g%l%c%p%pps%rssun
   rssha          => clm3%g%l%c%p%pps%rssha
   cisun          => clm3%g%l%c%p%pps%cisun
   cisha          => clm3%g%l%c%p%pps%cisha
   psnsun         => clm3%g%l%c%p%pcf%psnsun
   psnsha         => clm3%g%l%c%p%pcf%psnsha
   
   
   alphapsnsun    => clm3%g%l%c%p%pps%alphapsnsun
   alphapsnsha    => clm3%g%l%c%p%pps%alphapsnsha
   
   elai           => clm3%g%l%c%p%pps%elai
   esai           => clm3%g%l%c%p%pps%esai
   fdry           => clm3%g%l%c%p%pps%fdry
   laisun         => clm3%g%l%c%p%pps%laisun
   laisha         => clm3%g%l%c%p%pps%laisha
   qflx_tran_veg  => clm3%g%l%c%p%pwf%qflx_tran_veg
   fwet           => clm3%g%l%c%p%pps%fwet
   h2ocan         => clm3%g%l%c%p%pws%h2ocan
   dt_veg         => clm3%g%l%c%p%pps%dt_veg
   sabv           => clm3%g%l%c%p%pef%sabv
   qflx_evap_veg  => clm3%g%l%c%p%pwf%qflx_evap_veg
   eflx_sh_veg    => clm3%g%l%c%p%pef%eflx_sh_veg
   taux           => clm3%g%l%c%p%pmf%taux
   tauy           => clm3%g%l%c%p%pmf%tauy
   eflx_sh_grnd   => clm3%g%l%c%p%pef%eflx_sh_grnd
   qflx_evap_soi  => clm3%g%l%c%p%pwf%qflx_evap_soi
   t_ref2m        => clm3%g%l%c%p%pes%t_ref2m
   q_ref2m        => clm3%g%l%c%p%pes%q_ref2m
   dlrad          => clm3%g%l%c%p%pef%dlrad
   ulrad          => clm3%g%l%c%p%pef%ulrad
   cgrnds         => clm3%g%l%c%p%pef%cgrnds
   cgrndl         => clm3%g%l%c%p%pef%cgrndl
   cgrnd          => clm3%g%l%c%p%pef%cgrnd
   fpsn           => clm3%g%l%c%p%pcf%fpsn
      
   

   dleaf          => pftcon%dleaf
   smpso          => pftcon%smpso
   smpsc          => pftcon%smpsc

   



   

   fn = 0
   do fp = 1,num_nolakep
      p = filter_nolakep(fp)
      if (frac_veg_nosno(p) /= 0) then
         fn = fn + 1
         filterp(fn) = p
      end if
   end do

   

   do f = 1, fn
      p = filterp(f)
      del(p)    = 0._r8  
      efeb(p)   = 0._r8  
      wtlq0(p)  = 0._r8
      wtalq(p)  = 0._r8
      wtgq(p)   = 0._r8
      wtaq0(p)  = 0._r8
      obuold(p) = 0._r8
      btran(p)  = btran0
   end do

   
   

   do j = 1,nlevsoi


      do f = 1, fn
         p = filterp(f)
         c = pcolumn(p)
         l = plandunit(p)

         

         vol_ice = min(watsat(c,j), h2osoi_ice(c,j)/(dz(c,j)*denice))
         eff_porosity = watsat(c,j)-vol_ice
         vol_liq = min(eff_porosity, h2osoi_liq(c,j)/(dz(c,j)*denh2o))
         if (vol_liq .le. 0._r8) then
            rootr(p,j) = 0._r8
         else


            if(eff_porosity > 0.0) then
              s_node = max(vol_liq/eff_porosity,0.01_r8)
            else
              s_node = 0.01_r8
            end if


            smp_node = max(smpsc(ivt(p)), -sucsat(c,j)*s_node**(-bsw(c,j)))

            rresis(p,j) = min( (eff_porosity/watsat(c,j))* &
                          (smp_node - smpsc(ivt(p))) / (smpso(ivt(p)) - smpsc(ivt(p))), 1._r8)
            rootr(p,j) = rootfr(p,j)*rresis(p,j)
            btran(p) = btran(p) + rootr(p,j)
         endif 
      end do
   end do

   

   do j = 1,nlevsoi


      do f = 1, fn
         p = filterp(f)
         if (btran(p) .gt. btran0) then
           rootr(p,j) = rootr(p,j)/btran(p)
         else
           rootr(p,j) = 0._r8
         end if
      end do
   end do

   found = .false.


   do f = 1, fn
      p = filterp(f)
      c = pcolumn(p)
      g = pgridcell(p)

      
      

      air(p) =   emv(p) * (1._r8+(1._r8-emv(p))*(1._r8-emg(c))) * forc_lwrad(g)
      bir(p) = - (2._r8-emv(p)*(1._r8-emg(c))) * emv(p) * sb
      cir(p) =   emv(p)*emg(c)*sb

      
      

      call QSat (t_veg(p), forc_pbot(g), el(p), deldT, qsatl(p), qsatldT(p))

      

      co2(p) = forc_pco2(g)
      o2(p)  = forc_po2(g)
      
      
      
      

      nmozsgn(p) = 0

      taf(p) = (t_grnd(c) + thm(c))/2._r8
      qaf(p) = (forc_q(g)+qg(c))/2._r8

      ur(p) = max(1.0_r8,sqrt(forc_u(g)*forc_u(g)+forc_v(g)*forc_v(g)))
      dth(p) = thm(c)-taf(p)
      dqh(p) = forc_q(g)-qaf(p)
      delq(p) = qg(c) - qaf(p)
      dthv(p) = dth(p)*(1._r8+0.61_r8*forc_q(g))+0.61_r8*forc_th(g)*dqh(p)
      zldis(p) = forc_hgt_u(g) - displa(p)

      
      if (zldis(p) < 0._r8) then
         found = .true.
         index = p
      end if

   end do

   if (found) then
      write(6,*)'Error: Forcing height is below canopy height for pft index ',index
      call endrun()
   end if



   do f = 1, fn
      p = filterp(f)
      c = pcolumn(p)

      

      call MoninObukIni(ur(p), thv(c), dthv(p), zldis(p), z0mv(p), um(p), obu(p))

   end do

   

   itlef = 0    
   fnorig = fn
   fporig(1:fn) = filterp(1:fn)

   
   


   do f = 1, fn
      p = filterp(f)
      displa_loc(p) = displa(p)
      z0mv_loc(p) = z0mv(p)
      z0hv_loc(p) = z0hv(p)
      z0qv_loc(p) = z0qv(p)
   end do

   

   ITERATION : do while (itlef <= itmax .and. fn > 0)

      
      

      call FrictionVelocity (lbp, ubp, fn, filterp, &
                             displa_loc, z0mv_loc, z0hv_loc, z0qv_loc, &
                             obu, itlef+1, ur, um, ustar, &
                             temp1, temp2, temp12m, temp22m, fm)



      do f = 1, fn
         p = filterp(f)
         c = pcolumn(p)
         g = pgridcell(p)

         tlbef(p) = t_veg(p)
         del2(p) = del(p)

         

         ram1(p)  = 1._r8/(ustar(p)*ustar(p)/um(p))
         rah(p,1) = 1._r8/(temp1(p)*ustar(p))
         raw(p,1) = 1._r8/(temp2(p)*ustar(p))

         

         uaf = um(p)*sqrt( 1._r8/(ram1(p)*um(p)) )
         cf  = 0.01_r8/(sqrt(uaf)*sqrt(dleaf(ivt(p))))
         rb(p)  = 1._r8/(cf*uaf)

         
         

         w = exp(-(elai(p)+esai(p)))
         csoilcn = (vkc/(0.13_r8*(z0mg(c)*uaf/1.5e-5_r8)**0.45_r8))*w + csoilc*(1._r8-w)
         rah(p,2) = 1._r8/(csoilcn*uaf)
         raw(p,2) = rah(p,2)

         
         

         svpts(p) = el(p)                         
         eah(p) = forc_pbot(g) * qaf(p) / 0.622_r8   
      end do

      
      call Stomata (fn, filterp, lbp, ubp, svpts, eah, o2, co2, rb, phase='sun')
      call Stomata (fn, filterp, lbp, ubp, svpts, eah, o2, co2, rb, phase='sha')



      do f = 1, fn
         p = filterp(f)
         c = pcolumn(p)
         g = pgridcell(p)

         
         

         wta    = 1._r8/rah(p,1)             
         wtl    = (elai(p)+esai(p))/rb(p)    
         wtg(p) = 1._r8/rah(p,2)             
         wtshi  = 1._r8/(wta+wtl+wtg(p))

         wtl0(p) = wtl*wtshi         
         wtg0    = wtg(p)*wtshi      
         wta0(p) = wta*wtshi         

         wtga    = wta0(p)+wtg0      
         wtal(p) = wta0(p)+wtl0(p)   

         

         if (fdry(p) .gt. 0._r8) then
            rppdry  = fdry(p)*rb(p)*(laisun(p)/(rb(p)+rssun(p)) + &
                                     laisha(p)/(rb(p)+rssha(p)))/elai(p)
         else
            rppdry = 0._r8
         end if
         efpot = forc_rho(g)*wtl*(qsatl(p)-qaf(p))

         if (efpot > 0._r8) then
            if (btran(p) > btran0) then
               qflx_tran_veg(p) = efpot*rppdry
               rpp = rppdry + fwet(p)
            else
               
               rpp = fwet(p)
               qflx_tran_veg(p) = 0._r8
            end if
            
            rpp = min(rpp, (qflx_tran_veg(p)+h2ocan(p)/dtime)/efpot)
         else
            
            rpp = 1._r8
            qflx_tran_veg(p) = 0._r8
         end if

         
         
         
         

         wtaq    = frac_veg_nosno(p)/raw(p,1)                        
         wtlq    = frac_veg_nosno(p)*(elai(p)+esai(p))/rb(p) * rpp   

         
         www     = (h2osoi_liq(c,1)/denh2o+h2osoi_ice(c,1)/denice)/dz(c,1)/watsat(c,1)
         www     = min(max(www,0.0_r8),1._r8)
         if (delq(p) .lt. 0._r8) then  
           rsoil = 0._r8
         else
           rsoil   = (1._r8 - frac_sno(c)) * exp(8.206_r8 - 4.255_r8*www)
         end if

         wtgq(p) = frac_veg_nosno(p)/(raw(p,2)+rsoil)
         wtsqi   = 1._r8/(wtaq+wtlq+wtgq(p))

         wtgq0    = wtgq(p)*wtsqi      
         wtlq0(p) = wtlq*wtsqi         
         wtaq0(p) = wtaq*wtsqi         

         wtgaq    = wtaq0(p)+wtgq0     
         wtalq(p) = wtaq0(p)+wtlq0(p)  

         dc1 = forc_rho(g)*cpair*wtl
         dc2 = hvap*forc_rho(g)*wtlq

         efsh   = dc1*(wtga*t_veg(p)-wtg0*t_grnd(c)-wta0(p)*thm(c))
         efe(p) = dc2*(wtgaq*qsatl(p)-wtgq0*qg(c)-wtaq0(p)*forc_q(g))

         

         erre = 0._r8
         if (efe(p)*efeb(p) < 0._r8) then
            efeold = efe(p)
            efe(p)  = 0.1_r8*efeold
            erre = efe(p) - efeold
         end if
         dt_veg(p) = (sabv(p) + air(p) + bir(p)*t_veg(p)**4 + &
              cir(p)*t_grnd(c)**4 - efsh - efe(p)) / &
              (- 4._r8*bir(p)*t_veg(p)**3 +dc1*wtga +dc2*wtgaq*qsatldT(p))
         t_veg(p) = tlbef(p) + dt_veg(p)
         dels = dt_veg(p)
         del(p)  = abs(dels)
         err(p) = 0._r8
         if (del(p) > delmax) then
            dt_veg(p) = delmax*dels/del(p)
            t_veg(p) = tlbef(p) + dt_veg(p)
            err(p) = sabv(p) + air(p) + bir(p)*tlbef(p)**3*(tlbef(p) + &
                 4._r8*dt_veg(p)) + cir(p)*t_grnd(c)**4 - &
                 (efsh + dc1*wtga*dt_veg(p)) - (efe(p) + &
                 dc2*wtgaq*qsatldT(p)*dt_veg(p))
         end if

         
         
         
         

         efpot = forc_rho(g)*wtl*(wtgaq*(qsatl(p)+qsatldT(p)*dt_veg(p)) &
            -wtgq0*qg(c)-wtaq0(p)*forc_q(g))
         qflx_evap_veg(p) = rpp*efpot
         
         
         
         
         
         

         ecidif = 0._r8
         if (efpot > 0._r8 .and. btran(p) > btran0) then
            qflx_tran_veg(p) = efpot*rppdry
         else
            qflx_tran_veg(p) = 0._r8
         end if
         ecidif = max(0._r8, qflx_evap_veg(p)-qflx_tran_veg(p)-h2ocan(p)/dtime)
         qflx_evap_veg(p) = min(qflx_evap_veg(p),qflx_tran_veg(p)+h2ocan(p)/dtime)

         
         

         eflx_sh_veg(p) = efsh + dc1*wtga*dt_veg(p) + err(p) + erre + hvap*ecidif

         
         

         call QSat(t_veg(p), forc_pbot(g), el(p), deldT, qsatl(p), qsatldT(p))

         
         
         

         taf(p) = wtg0*t_grnd(c) + wta0(p)*thm(c) + wtl0(p)*t_veg(p)
         qaf(p) = wtlq0(p)*qsatl(p) + wtgq0*qg(c) + forc_q(g)*wtaq0(p)

         
         

         dth(p) = thm(c)-taf(p)
         dqh(p) = forc_q(g)-qaf(p)
         delq(p) = wtalq(p)*qg(c)-wtlq0(p)*qsatl(p)-wtaq0(p)*forc_q(g)

         tstar = temp1(p)*dth(p)
         qstar = temp2(p)*dqh(p)

         thvstar = tstar*(1._r8+0.61_r8*forc_q(g)) + 0.61_r8*forc_th(g)*qstar
         zeta = zldis(p)*vkc*grav*thvstar/(ustar(p)**2*thv(c))

         if (zeta >= 0._r8) then     
            zeta = min(2._r8,max(zeta,0.01_r8))
            um(p) = max(ur(p),0.1_r8)
         else                     
            zeta = max(-100._r8,min(zeta,-0.01_r8))
            wc = beta*(-grav*ustar(p)*thvstar*zii/thv(c))**0.333_r8
            um(p) = sqrt(ur(p)*ur(p)+wc*wc)
         end if
         obu(p) = zldis(p)/zeta

         if (obuold(p)*obu(p) < 0._r8) nmozsgn(p) = nmozsgn(p)+1
         if (nmozsgn(p) >= 4) obu(p) = zldis(p)/(-0.01_r8)
         obuold(p) = obu(p)

      end do   

      

      itlef = itlef+1
      if (itlef > itmin) then


         do f = 1, fn
            p = filterp(f)
            dele(p) = abs(efe(p)-efeb(p))
            efeb(p) = efe(p)
            det(p)  = max(del(p),del2(p))
         end do
         fnold = fn
         fn = 0
         do f = 1, fnold
            p = filterp(f)
            if (.not. (det(p) < dtmin .and. dele(p) < dlemin)) then
               fn = fn + 1
               filterp(fn) = p
            end if
         end do
      end if

   end do ITERATION     

   fn = fnorig
   filterp(1:fn) = fporig(1:fn)



   do f = 1, fn
      p = filterp(f)
      c = pcolumn(p)
      g = pgridcell(p)

      

      err(p) = sabv(p) + air(p) + bir(p)*tlbef(p)**3*(tlbef(p) + 4._r8*dt_veg(p)) &
         + cir(p)*t_grnd(c)**4 - eflx_sh_veg(p) - hvap*qflx_evap_veg(p)

      

      delt    = wtal(p)*t_grnd(c)-wtl0(p)*t_veg(p)-wta0(p)*thm(c)
      taux(p) = -forc_rho(g)*forc_u(g)/ram1(p)
      tauy(p) = -forc_rho(g)*forc_v(g)/ram1(p)
      eflx_sh_grnd(p) = cpair*forc_rho(g)*wtg(p)*delt
      qflx_evap_soi(p) = forc_rho(g)*wtgq(p)*delq(p)

      

      t_ref2m(p) = thm(c) + temp1(p)*dth(p)*(1._r8/temp12m(p) - 1._r8/temp1(p))

      

      q_ref2m(p) = forc_q(g) + temp2(p)*dqh(p)*(1._r8/temp22m(p) - 1._r8/temp2(p))

      

      dlrad(p) = (1._r8-emv(p))*emg(c)*forc_lwrad(g) + &
         emv(p)*emg(c)*sb*tlbef(p)**3*(tlbef(p) + 4._r8*dt_veg(p))

      

      ulrad(p) = ((1._r8-emg(c))*(1._r8-emv(p))*(1._r8-emv(p))*forc_lwrad(g) &
         + emv(p)*(1._r8+(1._r8-emg(c))*(1._r8-emv(p)))*sb*tlbef(p)**3*(tlbef(p) + &
         4._r8*dt_veg(p)) + emg(c)*(1._r8-emv(p))*sb*t_grnd(c)**4)

      

      cgrnds(p) = cgrnds(p) + cpair*forc_rho(g)*wtg(p)*wtal(p)
      cgrndl(p) = cgrndl(p) + forc_rho(g)*wtgq(p)*wtalq(p)*dqgdT(c)
      cgrnd(p)  = cgrnds(p) + cgrndl(p)*htvp(c)

      
      
      h2ocan(p) = max(0._r8,h2ocan(p)+(qflx_tran_veg(p)-qflx_evap_veg(p))*dtime)
      
      

      fpsn(p) = psnsun(p)*laisun(p) + psnsha(p)*laisha(p)
      
      
   end do

   

   fnold = fn
   fn = 0
   do f = 1, fnold
      p = filterp(f)
      if (abs(err(p)) > 0.1_r8) then
         fn = fn + 1
         filterp(fn) = p
      end if
   end do

   do f = 1, fn
      p = filterp(f)
      write(6,*) 'energy balance in canopy ',p,', err=',err(p)
   end do

   end subroutine CanopyFluxes







   subroutine Stomata (fn, filterp, lbp, ubp, ei, ea, o2, co2, rb, phase)














     use shr_kind_mod , only : r8 => shr_kind_r8


     use clm_varcon   , only : tfrz,rgas
     use clmtype	
     



     implicit none
     integer , intent(in)    :: fn                 
     integer , intent(in)    :: filterp(fn)        
     integer , intent(in)    :: lbp, ubp           
     real(r8), intent(in)    :: ei(lbp:ubp)        
     real(r8), intent(in)    :: ea(lbp:ubp)        
     real(r8), intent(in)    :: o2(lbp:ubp)        
     real(r8), intent(in)    :: co2(lbp:ubp)       
     real(r8), intent(inout) :: rb(lbp:ubp)        
     character(len=*), intent(in) :: phase         









     integer , pointer :: pcolumn(:)     
     integer , pointer :: pgridcell(:)   
     integer , pointer :: ivt(:)         
     real(r8), pointer :: qe25(:)        
     real(r8), pointer :: vcmx25(:)      
     real(r8), pointer :: c3psn(:)       
     real(r8), pointer :: mp(:)          
     real(r8), pointer :: tgcm(:)        
     real(r8), pointer :: forc_pbot(:)   
     real(r8), pointer :: tl(:)          
     real(r8), pointer :: btran(:)       
     real(r8), pointer :: apar(:)        
     real(r8), pointer :: leafcn(:)      
     real(r8), pointer :: flnr(:)        
     real(r8), pointer :: sla(:)         
     real(r8), pointer :: fnitr(:)       



     real(r8), pointer :: rs(:)          
     real(r8), pointer :: psn(:)         
     real(r8), pointer :: ci(:)          
     real(r8), pointer :: alphapsn(:)    




     real(r8), pointer :: lnc(:)         
     real(r8), pointer :: vcmx(:)        





     real(r8), parameter :: mpe = 1.e-6_r8   
     integer , parameter :: niter = 3     
     integer  :: f,p,c,g 
     integer  :: iter    
     real(r8) :: ab      
     real(r8) :: bc      
     real(r8) :: f1      
     real(r8) :: f2      
     real(r8) :: tc      
     real(r8) :: cs      
     real(r8) :: kc      
     real(r8) :: ko      
     real(r8) :: atmp    
     real(r8) :: btmp    
     real(r8) :: ctmp    
     real(r8) :: q       
     real(r8) :: r1,r2   
     real(r8) :: ppf     
     real(r8) :: wc      
     real(r8) :: wj      
     real(r8) :: we      
     real(r8) :: cp      
     real(r8) :: awc     
     real(r8) :: j       
     real(r8) :: cea     
     real(r8) :: cf      
     real(r8) :: rsmax0  
     real(r8) :: kc25    
     real(r8) :: akc     
     real(r8) :: ko25    
     real(r8) :: ako     
     real(r8) :: avcmx   
     real(r8) :: bp      
     
     real(r8) :: act25   
     real(r8) :: act     
     real(r8) :: q10act  
     real(r8) :: fnr     


     

     f1(ab,bc) = ab**((bc-25._r8)/10._r8)

     f2(ab) = 1._r8 + exp((-2.2e05_r8+710._r8*(ab+tfrz))/(rgas*0.001_r8*(ab+rgas)))

     

     pcolumn   => clm3%g%l%c%p%column
     pgridcell => clm3%g%l%c%p%gridcell
     ivt       => clm3%g%l%c%p%itype
     tl        => clm3%g%l%c%p%pes%t_veg
     btran     => clm3%g%l%c%p%pps%btran
     if (phase == 'sun') then
        apar   => clm3%g%l%c%p%pef%parsun
        rs     => clm3%g%l%c%p%pps%rssun
        psn    => clm3%g%l%c%p%pcf%psnsun
        ci     => clm3%g%l%c%p%pps%cisun
        alphapsn  => clm3%g%l%c%p%pps%alphapsnsun
        sla    => clm3%g%l%c%p%pps%slasun
        lnc    => clm3%g%l%c%p%pps%lncsun   
        vcmx   => clm3%g%l%c%p%pps%vcmxsun   
     else if (phase == 'sha') then
        apar   => clm3%g%l%c%p%pef%parsha
        rs     => clm3%g%l%c%p%pps%rssha
        psn    => clm3%g%l%c%p%pcf%psnsha
        ci     => clm3%g%l%c%p%pps%cisha
        sla    => clm3%g%l%c%p%pps%slasha   
        alphapsn  => clm3%g%l%c%p%pps%alphapsnsha
        lnc    => clm3%g%l%c%p%pps%lncsha   
        vcmx   => clm3%g%l%c%p%pps%vcmxsha
     end if

     

     forc_pbot => clm_a2l%forc_pbot

     

     tgcm      => clm3%g%l%c%ces%thm

     
     

     qe25      => pftcon%qe25
     vcmx25    => pftcon%vcmx25
     c3psn     => pftcon%c3psn
     mp        => pftcon%mp
     leafcn    => pftcon%leafcn
     flnr      => pftcon%flnr
     fnitr     => pftcon%fnitr

     

     kc25  = 30._r8
     akc   = 2.1_r8
     ko25  = 30000._r8
     ako   = 1.2_r8
     avcmx = 2.4_r8
     bp    = 2000._r8

     

     act25 = 3.6_r8
     q10act = 2.4_r8
     fnr = 7.16_r8
     
     

     act25 = act25 * 1000.0_r8 / 60.0_r8



     do f = 1, fn
        p = filterp(f)
        c = pcolumn(p)
        g = pgridcell(p)

        
        
        


        rsmax0 = 2.e4_r8
        cf = forc_pbot(g)/(rgas*0.001_r8*tgcm(c))*1.e06_r8 
        if (apar(p) <= 0._r8) then          
           rs(p) = min(rsmax0, 1._r8/bp * cf)
           psn(p) = 0._r8
           lnc(p) = 0._r8
           vcmx(p) = 0._r8
           alphapsn(p) = 1._r8
        else                             
           tc = tl(p) - tfrz
           ppf = 4.6_r8 * apar(p)                  
           j = ppf * qe25(ivt(p))
           kc = kc25 * f1(akc,tc)       
           ko = ko25 * f1(ako,tc)
           awc = kc * (1._r8+o2(p)/ko)
           cp = 0.5_r8*kc/ko*o2(p)*0.21_r8
           
           
           lnc(p) = 1._r8 / (sla(p) * leafcn(ivt(p)))
		   act = act25 * f1(q10act,tc)
           vcmx(p) = lnc(p) * flnr(ivt(p)) * fnr * act / f2(tc) * btran(p) * fnitr(ivt(p))
           

           

           ci(p) = 0.7_r8*co2(p)*c3psn(ivt(p)) + 0.4_r8*co2(p)*(1._r8-c3psn(ivt(p)))

           

           rb(p) = rb(p)/cf 

           

           cea = max(0.25_r8*ei(p)*c3psn(ivt(p))+0.40_r8*ei(p)*(1._r8-c3psn(ivt(p))), min(ea(p),ei(p)) ) 


           

           do iter = 1, niter
              wj = max(ci(p)-cp,0._r8)*j/(ci(p)+2._r8*cp)*c3psn(ivt(p)) + j*(1._r8-c3psn(ivt(p)))
              wc = max(ci(p)-cp,0._r8)*vcmx(p)/(ci(p)+awc)*c3psn(ivt(p)) + vcmx(p)*(1._r8-c3psn(ivt(p)))
              we = 0.5_r8*vcmx(p)*c3psn(ivt(p)) + 4000._r8*vcmx(p)*ci(p)/forc_pbot(g)*(1._r8-c3psn(ivt(p))) 
              psn(p) = min(wj,wc,we) 
              cs = max( co2(p)-1.37_r8*rb(p)*forc_pbot(g)*psn(p), mpe )
              atmp = mp(ivt(p))*psn(p)*forc_pbot(g)*cea / (cs*ei(p)) + bp
              btmp = ( mp(ivt(p))*psn(p)*forc_pbot(g)/cs + bp ) * rb(p) - 1._r8
              ctmp = -rb(p)
              if (btmp >= 0._r8) then
                 q = -0.5_r8*( btmp + sqrt(btmp*btmp-4._r8*atmp*ctmp) )
              else
                 q = -0.5_r8*( btmp - sqrt(btmp*btmp-4._r8*atmp*ctmp) )
              end if
              r1 = q/atmp
              r2 = ctmp/q
              rs(p) = max(r1,r2)
              ci(p) = max( cs-psn(p)*forc_pbot(g)*1.65_r8*rs(p), 0._r8 )
           end do


           

           rs(p) = min(rsmax0, rs(p)*cf)
           rb(p) = rb(p) * cf 
           
           
           
           alphapsn(p) = 1._r8 + (((c3psn(ivt(p)) * (4.4_r8 + (22.6_r8*(ci(p)/co2(p))))) + &
                         ((1._r8 - c3psn(ivt(p))) * 4.4_r8))/1000._r8)
           
           
           
        end if

     end do

  end subroutine Stomata

end module CanopyFluxesMod
