






module FracWetMod











  implicit none
  save


  public :: FracWet







contains







  subroutine FracWet(numf, filter)










    use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype


    implicit none
    integer, intent(in) :: numf                  
    integer, intent(in) :: filter(numf)          












    integer , pointer :: frac_veg_nosno(:) 
    real(r8), pointer :: dewmx(:)          
    real(r8), pointer :: elai(:)           
    real(r8), pointer :: esai(:)           
    real(r8), pointer :: h2ocan(:)         



    real(r8), pointer :: fwet(:)           
    real(r8), pointer :: fdry(:)           





    integer  :: fp,p             
    real(r8) :: vegt             
    real(r8) :: dewmxi           


    

    frac_veg_nosno => clm3%g%l%c%p%pps%frac_veg_nosno
    dewmx => clm3%g%l%c%p%pps%dewmx
    elai => clm3%g%l%c%p%pps%elai
    esai => clm3%g%l%c%p%pps%esai
    h2ocan => clm3%g%l%c%p%pws%h2ocan
    fwet => clm3%g%l%c%p%pps%fwet
    fdry => clm3%g%l%c%p%pps%fdry

    



    do fp = 1,numf
       p = filter(fp)
       if (frac_veg_nosno(p) == 1) then
          if (h2ocan(p) > 0._r8) then
             vegt    = frac_veg_nosno(p)*(elai(p) + esai(p))
             dewmxi  = 1.0_r8/dewmx(p)
             fwet(p) = ((dewmxi/vegt)*h2ocan(p))**0.666666666666_r8
             fwet(p) = min (fwet(p),1.0_r8)   
          else
             fwet(p) = 0._r8
          end if
          fdry(p) = (1._r8-fwet(p))*elai(p)/(elai(p)+esai(p))




       else
          fwet(p) = 0._r8
          fdry(p) = 0._r8
       end if
    end do

  end subroutine FracWet

end module FracWetMod
