






module FrictionVelocityMod











  use shr_kind_mod, only: r8 => shr_kind_r8


  implicit none
  save


  public :: FrictionVelocity       
  public :: MoninObukIni           


  private :: StabilityFunc1        
  private :: StabilityFunc2        







contains







  subroutine FrictionVelocity(lbp, ubp, fn, filterp, &
                              displa, z0m, z0h, z0q, &
                              obu, iter, ur, um, ustar, &
                              temp1, temp2, temp12m, temp22m, fm)










   use clmtype
   
   use clm_varcon, only : vkc


   implicit none
   integer , intent(in)  :: lbp, ubp         
   integer , intent(in)  :: fn               
   integer , intent(in)  :: filterp(fn)      
   real(r8), intent(in)  :: displa(lbp:ubp)  
   real(r8), intent(in)  :: z0m(lbp:ubp)     
   real(r8), intent(in)  :: z0h(lbp:ubp)     
   real(r8), intent(in)  :: z0q(lbp:ubp)     
   real(r8), intent(in)  :: obu(lbp:ubp)     
   integer,  intent(in)  :: iter             
   real(r8), intent(in)  :: ur(lbp:ubp)      
   real(r8), intent(in)  :: um(lbp:ubp)      
   real(r8), intent(out) :: ustar(lbp:ubp)   
   real(r8), intent(out) :: temp1(lbp:ubp)   
   real(r8), intent(out) :: temp12m(lbp:ubp) 
   real(r8), intent(out) :: temp2(lbp:ubp)   
   real(r8), intent(out) :: temp22m(lbp:ubp) 
   real(r8), intent(inout) :: fm(lbp:ubp)    














   integer , pointer :: pgridcell(:)   
   real(r8), pointer :: forc_hgt(:)    
   real(r8), pointer :: forc_hgt_u(:)  
   real(r8), pointer :: forc_hgt_t(:)  
   real(r8), pointer :: forc_hgt_q(:)  



   real(r8), pointer :: u10(:)         
   real(r8), pointer :: fv(:)          





   real(r8), parameter :: zetam = 1.574_r8 
   real(r8), parameter :: zetat = 0.465_r8 
   integer :: f                         
   integer :: p                         
   integer :: g                         
   real(r8):: zldis(lbp:ubp)            
   real(r8):: zeta(lbp:ubp)             








   

   pgridcell  => clm3%g%l%c%p%gridcell
   forc_hgt   => clm_a2l%forc_hgt
   forc_hgt_u => clm_a2l%forc_hgt_u
   forc_hgt_t => clm_a2l%forc_hgt_t
   forc_hgt_q => clm_a2l%forc_hgt_q

   

   u10        => clm3%g%l%c%p%pps%u10
   fv         => clm3%g%l%c%p%pps%fv

   





   do f = 1, fn
      p = filterp(f)
      g = pgridcell(p)

      

      zldis(p) = forc_hgt_u(g)-displa(p)
      zeta(p) = zldis(p)/obu(p)
      if (zeta(p) < -zetam) then
         ustar(p) = vkc*um(p)/(log(-zetam*obu(p)/z0m(p))&
              - StabilityFunc1(-zetam) &
              + StabilityFunc1(z0m(p)/obu(p)) &
              + 1.14_r8*((-zeta(p))**0.333_r8-(zetam)**0.333_r8))
      else if (zeta(p) < 0._r8) then
         ustar(p) = vkc*um(p)/(log(zldis(p)/z0m(p))&
              - StabilityFunc1(zeta(p))&
              + StabilityFunc1(z0m(p)/obu(p)))
      else if (zeta(p) <=  1._r8) then
         ustar(p) = vkc*um(p)/(log(zldis(p)/z0m(p)) + 5._r8*zeta(p) -5._r8*z0m(p)/obu(p))
      else
         ustar(p) = vkc*um(p)/(log(obu(p)/z0m(p))+5._r8-5._r8*z0m(p)/obu(p) &
              +(5._r8*log(zeta(p))+zeta(p)-1._r8))
      end if

      

      zldis(p) = forc_hgt_t(g)-displa(p)
      zeta(p) = zldis(p)/obu(p)
      if (zeta(p) < -zetat) then
         temp1(p) = vkc/(log(-zetat*obu(p)/z0h(p))&
              - StabilityFunc2(-zetat) &
              + StabilityFunc2(z0h(p)/obu(p)) &
              + 0.8_r8*((zetat)**(-0.333_r8)-(-zeta(p))**(-0.333_r8)))
      else if (zeta(p) < 0._r8) then
         temp1(p) = vkc/(log(zldis(p)/z0h(p)) &
              - StabilityFunc2(zeta(p)) &
              + StabilityFunc2(z0h(p)/obu(p)))
      else if (zeta(p) <=  1._r8) then
         temp1(p) = vkc/(log(zldis(p)/z0h(p)) + 5._r8*zeta(p) - 5._r8*z0h(p)/obu(p))
      else
         temp1(p) = vkc/(log(obu(p)/z0h(p)) + 5._r8 - 5._r8*z0h(p)/obu(p) &
              + (5._r8*log(zeta(p))+zeta(p)-1._r8))
      end if

      

      if (forc_hgt_q(g) == forc_hgt_t(g) .and. z0q(p) == z0h(p)) then
         temp2(p) = temp1(p)
      else
         zldis(p) = forc_hgt_q(g)-displa(p)
         zeta(p) = zldis(p)/obu(p)
         if (zeta(p) < -zetat) then
            temp2(p) = vkc/(log(-zetat*obu(p)/z0q(p)) &
                 - StabilityFunc2(-zetat) &
                 + StabilityFunc2(z0q(p)/obu(p)) &
                 + 0.8_r8*((zetat)**(-0.333_r8)-(-zeta(p))**(-0.333_r8)))
         else if (zeta(p) < 0._r8) then
            temp2(p) = vkc/(log(zldis(p)/z0q(p)) &
                 - StabilityFunc2(zeta(p)) &
                 + StabilityFunc2(z0q(p)/obu(p)))
         else if (zeta(p) <=  1._r8) then
            temp2(p) = vkc/(log(zldis(p)/z0q(p)) + 5._r8*zeta(p)-5._r8*z0q(p)/obu(p))
         else
            temp2(p) = vkc/(log(obu(p)/z0q(p)) + 5._r8 - 5._r8*z0q(p)/obu(p) &
                 + (5._r8*log(zeta(p))+zeta(p)-1._r8))
         end if
      endif

      

      zldis(p) = 2.0_r8 + z0h(p)
      zeta(p) = zldis(p)/obu(p)
      if (zeta(p) < -zetat) then
         temp12m(p) = vkc/(log(-zetat*obu(p)/z0h(p))&
              - StabilityFunc2(-zetat) &
              + StabilityFunc2(z0h(p)/obu(p)) &
              + 0.8_r8*((zetat)**(-0.333_r8)-(-zeta(p))**(-0.333_r8)))
      else if (zeta(p) < 0._r8) then
         temp12m(p) = vkc/(log(zldis(p)/z0h(p)) &
              - StabilityFunc2(zeta(p))  &
              + StabilityFunc2(z0h(p)/obu(p)))
      else if (zeta(p) <=  1._r8) then
         temp12m(p) = vkc/(log(zldis(p)/z0h(p)) + 5._r8*zeta(p) - 5._r8*z0h(p)/obu(p))
      else
         temp12m(p) = vkc/(log(obu(p)/z0h(p)) + 5._r8 - 5._r8*z0h(p)/obu(p) &
              + (5._r8*log(zeta(p))+zeta(p)-1._r8))
      end if

      

      if (z0q(p) == z0h(p)) then
         temp22m(p) = temp12m(p)
      else
         zldis(p) = 2.0_r8 + z0q(p)
         zeta(p) = zldis(p)/obu(p)
         if (zeta(p) < -zetat) then
            temp22m(p) = vkc/(log(-zetat*obu(p)/z0q(p)) - &
                 StabilityFunc2(-zetat) + StabilityFunc2(z0q(p)/obu(p)) &
                 + 0.8_r8*((zetat)**(-0.333_r8)-(-zeta(p))**(-0.333_r8)))
         else if (zeta(p) < 0._r8) then
            temp22m(p) = vkc/(log(zldis(p)/z0q(p)) - &
                 StabilityFunc2(zeta(p))+StabilityFunc2(z0q(p)/obu(p)))
         else if (zeta(p) <=  1._r8) then
            temp22m(p) = vkc/(log(zldis(p)/z0q(p)) + 5._r8*zeta(p)-5._r8*z0q(p)/obu(p))
         else
            temp22m(p) = vkc/(log(obu(p)/z0q(p)) + 5._r8 - 5._r8*z0q(p)/obu(p) &
                 + (5._r8*log(zeta(p))+zeta(p)-1._r8))
         end if
      end if


   end do



   end subroutine FrictionVelocity







   real(r8) function StabilityFunc1(zeta)







      use clm_varcon, only: pie


      implicit none
      real(r8), intent(in) :: zeta  











      real(r8) :: chik, chik2


      chik2 = sqrt(1._r8-16._r8*zeta)
      chik = sqrt(chik2)
      StabilityFunc1 = 2._r8*log((1._r8+chik)*0.5_r8) &

           + log((1._r8+chik2)*0.5_r8)-2._r8*atan(chik)+pie*0.5_r8

    end function StabilityFunc1







   real(r8) function StabilityFunc2(zeta)









     implicit none
     real(r8), intent(in) :: zeta  











     real(r8) :: chik2


     chik2 = sqrt(1._r8-16._r8*zeta)
     StabilityFunc2 = 2._r8*log((1._r8+chik2)*0.5_r8)

   end function StabilityFunc2







  subroutine MoninObukIni (ur, thv, dthv, zldis, z0m, um, obu)









    use clm_varcon, only : grav


    implicit none
    real(r8), intent(in)  :: ur    
    real(r8), intent(in)  :: thv   
    real(r8), intent(in)  :: dthv  
    real(r8), intent(in)  :: zldis 
    real(r8), intent(in)  :: z0m   
    real(r8), intent(out) :: um    
    real(r8), intent(out) :: obu   














    real(r8) :: wc    
    real(r8) :: rib   
    real(r8) :: zeta  
    real(r8) :: ustar 


    

    ustar=0.06_r8
    wc=0.5_r8
    if (dthv >= 0._r8) then
       um=max(ur,0.1_r8)
    else
       um=sqrt(ur*ur+wc*wc)
    endif

    rib=grav*zldis*dthv/(thv*um*um)

    if (rib >= 0._r8) then      
       zeta = rib*log(zldis/z0m)/(1._r8-5._r8*min(rib,0.19_r8))
       zeta = min(2._r8,max(zeta,0.01_r8 ))
    else                     
       zeta=rib*log(zldis/z0m)
       zeta = max(-100._r8,min(zeta,-0.01_r8 ))
    endif

    obu=zldis/zeta

  end subroutine MoninObukIni

end module FrictionVelocityMod
