







module Hydrology1Mod















   implicit none
   save


   public :: Hydrology1







contains







   subroutine Hydrology1(lbc, ubc, lbp, ubp, num_nolakec, filter_nolakec, &
                         num_nolakep, filter_nolakep)












    use shr_kind_mod , only : r8 => shr_kind_r8
    use clmtype
    
    use clm_varcon   , only : tfrz, istice, istwet, istsoil
    use FracWetMod   , only : FracWet



    use globals, only: dtime
    use subgridAveMod, only : p2c


    implicit none
    integer, intent(in) :: lbp, ubp                     
    integer, intent(in) :: lbc, ubc                     
    integer, intent(in) :: num_nolakec                  
    integer, intent(in) :: filter_nolakec(ubc-lbc+1)    
    integer, intent(in) :: num_nolakep                  
    integer, intent(in) :: filter_nolakep(ubp-lbp+1)    
















    integer , pointer :: cgridcell(:)      
    integer , pointer :: clandunit(:)      
    integer , pointer :: pgridcell(:)      
    integer , pointer :: plandunit(:)      
    integer , pointer :: pcolumn(:)        
    integer , pointer :: npfts(:)          
    integer , pointer :: pfti(:)           
    integer , pointer :: itype(:)          
    real(r8), pointer :: forc_rain(:)      
    real(r8), pointer :: forc_snow(:)      
    real(r8), pointer :: forc_t(:)         



    logical , pointer :: do_capsnow(:)     
    real(r8), pointer :: t_grnd(:)         
    real(r8), pointer :: dewmx(:)          
    integer , pointer :: frac_veg_nosno(:) 
    real(r8), pointer :: elai(:)           
    real(r8), pointer :: esai(:)           
    real(r8), pointer :: h2ocan_loss(:)    



    integer , pointer :: snl(:)            
    real(r8), pointer :: snowage(:)        
    real(r8), pointer :: snowdp(:)         
    real(r8), pointer :: h2osno(:)         
    real(r8), pointer :: h2ocan(:)         



    real(r8), pointer :: qflx_prec_intr(:)     
    real(r8), pointer :: qflx_prec_grnd(:)     
    real(r8), pointer :: qflx_snowcap(:)       
    real(r8), pointer :: qflx_snow_grnd_pft(:) 
    real(r8), pointer :: qflx_snow_grnd_col(:) 
    real(r8), pointer :: qflx_rain_grnd(:)     
    real(r8), pointer :: fwet(:)               
    real(r8), pointer :: fdry(:)               
    real(r8), pointer :: zi(:,:)               
    real(r8), pointer :: dz(:,:)               
    real(r8), pointer :: z(:,:)                
    real(r8), pointer :: t_soisno(:,:)         
    real(r8), pointer :: h2osoi_ice(:,:)       
    real(r8), pointer :: h2osoi_liq(:,:)       
    real(r8), pointer :: frac_iceold(:,:)      





    integer  :: f                            
    integer  :: pi                           
    integer  :: p                            
    integer  :: c                            
    integer  :: l                            
    integer  :: g                            
    integer  :: newnode                      


    real(r8) :: h2ocanmx                     
    real(r8) :: fpi                          
    real(r8) :: xrun                         
    real(r8) :: dz_snowf                     
    real(r8) :: bifall                       
    real(r8) :: fracsnow(lbp:ubp)            
    real(r8) :: fracrain(lbp:ubp)            
    real(r8) :: qflx_candrip(lbp:ubp)        
    real(r8) :: qflx_through_rain(lbp:ubp)   
    real(r8) :: qflx_through_snow(lbp:ubp)   
    real(r8) :: qflx_prec_grnd_snow(lbp:ubp) 
    real(r8) :: qflx_prec_grnd_rain(lbp:ubp) 


    

    pgridcell          => clm3%g%l%c%p%gridcell
    forc_rain          => clm_a2l%forc_rain
    forc_snow          => clm_a2l%forc_snow
    forc_t             => clm_a2l%forc_t




    

    clandunit          => clm3%g%l%c%landunit
    itype              => clm3%g%l%itype

    

    cgridcell          => clm3%g%l%c%gridcell
    pfti               => clm3%g%l%c%pfti
    npfts              => clm3%g%l%c%npfts
    do_capsnow         => clm3%g%l%c%cps%do_capsnow
    t_grnd             => clm3%g%l%c%ces%t_grnd
    snl                => clm3%g%l%c%cps%snl
    snowdp             => clm3%g%l%c%cps%snowdp
    snowage            => clm3%g%l%c%cps%snowage
    h2osno             => clm3%g%l%c%cws%h2osno
    zi                 => clm3%g%l%c%cps%zi
    dz                 => clm3%g%l%c%cps%dz
    z                  => clm3%g%l%c%cps%z
    frac_iceold        => clm3%g%l%c%cps%frac_iceold
    t_soisno           => clm3%g%l%c%ces%t_soisno
    h2osoi_ice         => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq         => clm3%g%l%c%cws%h2osoi_liq
    qflx_snow_grnd_col => clm3%g%l%c%cwf%pwf_a%qflx_snow_grnd
    h2ocan_loss        => clm3%g%l%c%cwf%h2ocan_loss

    

    plandunit          => clm3%g%l%c%p%landunit
    pcolumn            => clm3%g%l%c%p%column
    dewmx              => clm3%g%l%c%p%pps%dewmx
    frac_veg_nosno     => clm3%g%l%c%p%pps%frac_veg_nosno
    elai               => clm3%g%l%c%p%pps%elai
    esai               => clm3%g%l%c%p%pps%esai
    h2ocan             => clm3%g%l%c%p%pws%h2ocan
    qflx_prec_intr     => clm3%g%l%c%p%pwf%qflx_prec_intr
    qflx_prec_grnd     => clm3%g%l%c%p%pwf%qflx_prec_grnd
    qflx_snowcap       => clm3%g%l%c%p%pwf%qflx_snowcap
    qflx_snow_grnd_pft => clm3%g%l%c%p%pwf%qflx_snow_grnd
    qflx_rain_grnd     => clm3%g%l%c%p%pwf%qflx_rain_grnd
    fwet               => clm3%g%l%c%p%pps%fwet
    fdry               => clm3%g%l%c%p%pps%fdry

    



    



    do f = 1, num_nolakep
       p = filter_nolakep(f)
       g = pgridcell(p)
       l = plandunit(p)
       c = pcolumn(p)
       
       
       

       if (itype(l)==istsoil .or. itype(l)==istwet) then

          qflx_candrip(p) = 0._r8      
          qflx_through_snow(p) = 0._r8 
          qflx_through_rain(p) = 0._r8 
          qflx_prec_intr(p) = 0._r8    
          fracsnow(p) = 0._r8          
          fracrain(p) = 0._r8          

          if (frac_veg_nosno(p) == 1 .and. (forc_rain(g) + forc_snow(g)) > 0._r8) then

             

             fracsnow(p) = forc_snow(g)/(forc_snow(g) + forc_rain(g))
             fracrain(p) = forc_rain(g)/(forc_snow(g) + forc_rain(g))

             
             
             
             
             
             h2ocanmx = dewmx(p) * (elai(p) + esai(p))

             
             
             fpi = 0.25_r8*(1._r8 - exp(-0.5_r8*(elai(p) + esai(p))))

             
             qflx_through_snow(p) = forc_snow(g) * (1._r8-fpi)
             qflx_through_rain(p) = forc_rain(g) * (1._r8-fpi)

             
             qflx_prec_intr(p) = (forc_snow(g) + forc_rain(g)) * fpi

             
             h2ocan(p) = max(0._r8, h2ocan(p) + dtime*qflx_prec_intr(p))

             
             qflx_candrip(p) = 0._r8

             
             xrun = (h2ocan(p) - h2ocanmx)/dtime

             
             
             if (xrun > 0._r8) then
                qflx_candrip(p) = xrun
                h2ocan(p) = h2ocanmx
             end if

          end if

       else if (itype(l) == istice) then

          fracsnow(p) = 0._r8
          fracrain(p) = 0._r8
          qflx_prec_intr(p) = 0._r8
          h2ocan(p) = 0._r8
          qflx_candrip(p) = 0._r8
          qflx_through_snow(p) = 0._r8
          qflx_through_rain(p) = 0._r8

       end if

       
       
       
       
       
       
       if (frac_veg_nosno(p) == 0) then
          qflx_prec_grnd_snow(p) = forc_snow(g)
          qflx_prec_grnd_rain(p) = forc_rain(g) + h2ocan_loss(c)
       else
          qflx_prec_grnd_snow(p) = qflx_through_snow(p) + (qflx_candrip(p) * fracsnow(p))
          qflx_prec_grnd_rain(p) = qflx_through_rain(p) + (qflx_candrip(p) * fracrain(p)) + h2ocan_loss(c)
       end if
       qflx_prec_grnd(p) = qflx_prec_grnd_snow(p) + qflx_prec_grnd_rain(p)

       if (do_capsnow(c)) then
          qflx_snowcap(p) = qflx_prec_grnd_snow(p) + qflx_prec_grnd_rain(p)
          qflx_snow_grnd_pft(p) = 0._r8
          qflx_rain_grnd(p) = 0._r8
       else
          qflx_snowcap(p) = 0._r8




          qflx_snow_grnd_pft(p) = qflx_prec_grnd_snow(p)           
          qflx_rain_grnd(p)     = qflx_prec_grnd_rain(p)           

       end if

    end do 

    
    

    call FracWet(num_nolakep, filter_nolakep)

    

    call p2c(num_nolakec, filter_nolakec, qflx_snow_grnd_pft, qflx_snow_grnd_col)

    



    do f = 1, num_nolakec
       c = filter_nolakec(f)
       l = clandunit(c)
       g = cgridcell(c)

       
       
       

       if (do_capsnow(c)) then
          dz_snowf = 0._r8
       else
          if (forc_t(g) > tfrz + 2._r8) then
             bifall=50._r8 + 1.7_r8*(17.0_r8)**1.5_r8
          else if (forc_t(g) > tfrz - 15._r8) then
             bifall=50._r8 + 1.7_r8*(forc_t(g) - tfrz + 15._r8)**1.5_r8
          else
             bifall=50._r8
          end if
          dz_snowf = qflx_snow_grnd_col(c)/bifall
          snowdp(c) = snowdp(c) + dz_snowf*dtime
          h2osno(c) = h2osno(c) + qflx_snow_grnd_col(c)*dtime  
       end if

       if (itype(l)==istwet .and. t_grnd(c)>tfrz) then
          h2osno(c)=0._r8
          snowdp(c)=0._r8
          snowage(c)=0._r8
       end if

       
       
       

       newnode = 0    
       if (snl(c) == 0 .and. qflx_snow_grnd_col(c) > 0.0_r8 .and. snowdp(c) >= 0.01_r8) then
          newnode = 1
          snl(c) = -1
          dz(c,0) = snowdp(c)                       
          z(c,0) = -0.5_r8*dz(c,0)
          zi(c,-1) = -dz(c,0)
          snowage(c) = 0._r8                        
          t_soisno(c,0) = min(tfrz, forc_t(g))      
          h2osoi_ice(c,0) = h2osno(c)               
          h2osoi_liq(c,0) = 0._r8                   
          frac_iceold(c,0) = 1._r8
       end if

       
       
       

       if (snl(c) < 0 .and. newnode == 0) then
          h2osoi_ice(c,snl(c)+1) = h2osoi_ice(c,snl(c)+1)+dtime*qflx_snow_grnd_col(c)
          dz(c,snl(c)+1) = dz(c,snl(c)+1)+dz_snowf*dtime
       end if

    end do

  end subroutine Hydrology1

end module Hydrology1Mod
