







module Hydrology2Mod










  implicit none
  save


  public :: Hydrology2        











contains







  subroutine Hydrology2(lbc, ubc, ilx, jlx, lbp, ubp, num_nolakec, filter_nolakec, &
                        num_soilc, filter_soilc, num_snowc, filter_snowc, &
                        num_nosnowc, filter_nosnowc)

















    use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype
    
    use clm_varcon      , only : denh2o, denice, istice, istwet, istsoil, spval, istwet, istice
    use clm_varpar      , only : nlevsoi, nlevsno
    use SnowHydrologyMod, only : SnowCompaction, CombineSnowLayers, DivideSnowLayers, &
                                 SnowWater, BuildSnowFilter
    use SoilHydrologyMod, only : Infiltration, SoilWater, Drainage, SurfaceRunoff

    use globals, only: dtime, nstep




    implicit none
    integer, intent(in) :: lbc, ubc                    

    integer, intent(in) :: ilx, jlx

    integer, intent(in) :: lbp, ubp                    
    integer, intent(in) :: num_nolakec                 
    integer, intent(in) :: filter_nolakec(ubc-lbc+1)   
    integer, intent(in) :: num_soilc                   
    integer, intent(in) :: filter_soilc(ubc-lbc+1)     











    integer , pointer :: cgridcell(:)     
    integer , pointer :: clandunit(:)     
    integer , pointer :: ityplun(:)       
    integer , pointer :: snl(:)           
    real(r8), pointer :: h2ocan(:)        
    real(r8), pointer :: h2osno(:)        
    real(r8), pointer :: watsat(:,:)      
    real(r8), pointer :: sucsat(:,:)      
    real(r8), pointer :: bsw(:,:)         
    real(r8), pointer :: z(:,:)           
    real(r8), pointer :: forc_rain(:)     
    real(r8), pointer :: forc_snow(:)     
    real(r8), pointer :: begwb(:)         
    real(r8), pointer :: qflx_evap_tot(:) 
    real(r8), pointer :: bsw2(:,:)        
    real(r8), pointer :: psisat(:,:)      
    real(r8), pointer :: vwcsat(:,:)      



    real(r8), pointer :: dz(:,:)          
    real(r8), pointer :: zi(:,:)          
    real(r8), pointer :: zwt(:)           
    real(r8), pointer :: fcov(:)          
    real(r8), pointer :: wa(:)            
    real(r8), pointer :: qcharge(:)       



    real(r8), pointer :: endwb(:)         
    real(r8), pointer :: snowage(:)       
    real(r8), pointer :: wf(:)            
    real(r8), pointer :: snowice(:)       
    real(r8), pointer :: snowliq(:)       
    real(r8), pointer :: t_snow(:)        
    real(r8), pointer :: t_grnd(:)        
    real(r8), pointer :: t_soisno(:,:)    
    real(r8), pointer :: h2osoi_ice(:,:)  
    real(r8), pointer :: h2osoi_liq(:,:)  
    real(r8), pointer :: h2osoi_vol(:,:)  
    real(r8), pointer :: qflx_drain(:)    
    real(r8), pointer :: qflx_surf(:)     
    real(r8), pointer :: qflx_infl(:)     
    real(r8), pointer :: qflx_qrgwl(:)    
    real(r8), pointer :: soilpsi(:,:)	  





    integer  :: g,l,c,j,fc                 
    integer  :: num_snowc                  
    integer  :: filter_snowc(ubc-lbc+1)    
    integer  :: num_nosnowc                
    integer  :: filter_nosnowc(ubc-lbc+1)  



    real(r8) :: vol_liq(lbc:ubc,1:nlevsoi) 
    real(r8) :: icefrac(lbc:ubc,1:nlevsoi) 
    real(r8) :: dwat(lbc:ubc,1:nlevsoi)    
    real(r8) :: hk(lbc:ubc,1:nlevsoi)      
    real(r8) :: dhkdw(lbc:ubc,1:nlevsoi)   
    real(r8) :: psi,vwc,fsat               


    

    forc_rain => clm_a2l%forc_rain
    forc_snow => clm_a2l%forc_snow

    

    ityplun => clm3%g%l%itype

    

    cgridcell     => clm3%g%l%c%gridcell
    clandunit     => clm3%g%l%c%landunit
    snl           => clm3%g%l%c%cps%snl
    snowage       => clm3%g%l%c%cps%snowage
    t_snow        => clm3%g%l%c%ces%t_snow
    t_grnd        => clm3%g%l%c%ces%t_grnd
    h2ocan        => clm3%g%l%c%cws%pws_a%h2ocan
    h2osno        => clm3%g%l%c%cws%h2osno
    wf            => clm3%g%l%c%cps%wf
    snowice       => clm3%g%l%c%cws%snowice
    snowliq       => clm3%g%l%c%cws%snowliq
    zwt           => clm3%g%l%c%cws%zwt
    fcov          => clm3%g%l%c%cws%fcov
    wa            => clm3%g%l%c%cws%wa
    qcharge       => clm3%g%l%c%cws%qcharge
    watsat        => clm3%g%l%c%cps%watsat
    sucsat        => clm3%g%l%c%cps%sucsat
    bsw           => clm3%g%l%c%cps%bsw
    z             => clm3%g%l%c%cps%z
    dz            => clm3%g%l%c%cps%dz
    zi            => clm3%g%l%c%cps%zi
    t_soisno      => clm3%g%l%c%ces%t_soisno
    h2osoi_ice    => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq    => clm3%g%l%c%cws%h2osoi_liq
    h2osoi_vol    => clm3%g%l%c%cws%h2osoi_vol
    qflx_evap_tot => clm3%g%l%c%cwf%pwf_a%qflx_evap_tot
    qflx_drain    => clm3%g%l%c%cwf%qflx_drain
    qflx_surf     => clm3%g%l%c%cwf%qflx_surf
    qflx_infl     => clm3%g%l%c%cwf%qflx_infl
    qflx_qrgwl    => clm3%g%l%c%cwf%qflx_qrgwl
    endwb         => clm3%g%l%c%cwbal%endwb
    begwb         => clm3%g%l%c%cwbal%begwb
    bsw2          => clm3%g%l%c%cps%bsw2
    psisat        => clm3%g%l%c%cps%psisat
    vwcsat        => clm3%g%l%c%cps%vwcsat
    soilpsi       => clm3%g%l%c%cps%soilpsi

    




    
    

    call BuildSnowFilter(lbc, ubc, num_nolakec, filter_nolakec, &
         num_snowc, filter_snowc, num_nosnowc, filter_nosnowc)

    

    call SnowWater(lbc, ubc, num_snowc, filter_snowc, num_nosnowc, filter_nosnowc)

    

    call SurfaceRunoff(lbc, ubc, lbp, ubp, num_soilc, filter_soilc, &
         vol_liq, icefrac)

    call Infiltration(lbc, ubc,  num_soilc, filter_soilc)

    call SoilWater(lbc, ubc, num_soilc, filter_soilc, &
         vol_liq, dwat, hk, dhkdw)

    call Drainage(lbc, ubc, num_soilc, filter_soilc, &
         vol_liq, hk, icefrac)



       

       call SnowCompaction(lbc, ubc, num_snowc, filter_snowc)

       

       call CombineSnowLayers(lbc, ubc, num_snowc, filter_snowc)

       

       call DivideSnowLayers(lbc, ubc, num_snowc, filter_snowc)















  

 

    



    do fc = 1, num_snowc
       c = filter_snowc(fc)
       if (snl(c) == 0) then
          snowage(c) = 0._r8
       end if
    end do

    

    do j = -nlevsno+1,0


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j <= snl(c) .and. snl(c) > -nlevsno) then
             h2osoi_ice(c,j) = 0._r8
             h2osoi_liq(c,j) = 0._r8
             t_soisno(c,j) = 0._r8
             dz(c,j) = 0._r8
             z(c,j) = 0._r8
             zi(c,j-1) = 0._r8
          end if
       end do
    end do

    

    call BuildSnowFilter(lbc, ubc, num_nolakec, filter_nolakec, &
         num_snowc, filter_snowc, num_nosnowc, filter_nosnowc)

    
    



    do fc = 1, num_snowc
       c = filter_snowc(fc)
       t_snow(c)  = 0._r8
       snowice(c) = 0._r8
       snowliq(c) = 0._r8
    end do


    do fc = 1, num_nosnowc
       c = filter_nosnowc(fc)
       t_snow(c)  = spval
       snowice(c) = spval
       snowliq(c) = spval
    end do

    do j = -nlevsno+1, 0


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j >= snl(c)+1) then
             t_snow(c)  = t_snow(c) + t_soisno(c,j)
             snowice(c) = snowice(c) + h2osoi_ice(c,j)
             snowliq(c) = snowliq(c) + h2osoi_liq(c,j)
          end if
       end do
    end do

    



    do fc = 1, num_nolakec
       
       c = filter_nolakec(fc)
       if (snl(c) < 0) t_snow(c) = t_snow(c)/abs(snl(c))
       t_grnd(c) = t_soisno(c,snl(c)+1)
       endwb(c) = h2ocan(c) + h2osno(c) + wa(c)
    end do

    do j = 1, nlevsoi


       do fc = 1, num_nolakec
          c = filter_nolakec(fc)
          endwb(c) = endwb(c) + h2osoi_ice(c,j) + h2osoi_liq(c,j)
          h2osoi_vol(c,j) = h2osoi_liq(c,j)/(dz(c,j)*denh2o) + h2osoi_ice(c,j)/(dz(c,j)*denice)
       end do
    end do

    
    



    do fc = 1,num_nolakec
       c = filter_nolakec(fc)
       l = clandunit(c)
       g = cgridcell(c)
       if (ityplun(l)==istwet .or. ityplun(l)==istice) then
          qflx_drain(c) = 0._r8
          qflx_surf(c) = 0._r8
          qflx_infl(c) = 0._r8
          qflx_qrgwl(c) = forc_rain(g) + forc_snow(g) - qflx_evap_tot(c) - (endwb(c)-begwb(c))/dtime
          fcov(c) = spval
          qcharge(c) = spval
       end if
    end do



  end subroutine Hydrology2

end module Hydrology2Mod
