



module STATICEcosysdynMOD












  use shr_kind_mod, only: r8 => shr_kind_r8
   use decompMod    , only : get_proc_bounds


  implicit none
  save


  public :: EcosystemDyn       
  public :: EcosystemDynini    
  public :: interpMonthlyVeg   







  private :: readMonthlyVegetation   


  integer , private :: InterpMonths1         
  real(r8), private :: timwt(2)              
  real(r8), private, allocatable :: mlai1(:) 
  real(r8), private, allocatable :: mlai2(:) 
  real(r8), private, allocatable :: msai1(:) 
  real(r8), private, allocatable :: msai2(:) 
  real(r8), private, allocatable :: mhvt1(:) 
  real(r8), private, allocatable :: mhvt2(:) 
  real(r8), private, allocatable :: mhvb1(:) 
  real(r8), private, allocatable :: mhvb2(:) 


contains







  subroutine EcosystemDynini ()





    use nanMod

    implicit none






    integer :: ier    
    integer :: begg
    integer :: endg
    integer :: begl
    integer :: endl
    integer :: begc
    integer :: endc
    integer :: begp
    integer :: endp


    InterpMonths1 = -999  

    call get_proc_bounds (begg, endg, begl, endl, begc, endc, begp, endp)

    ier = 0
    if(.not.allocated(mlai1))allocate (mlai1(endp), mlai2(endp), &
              msai1(endp), msai2(endp), &
              mhvt1(endp), mhvt2(endp), &
              mhvb1(endp), mhvb2(endp), stat=ier)

    if (ier /= 0) then
       write (6,*) 'EcosystemDynini allocation error'
       call endrun
    end if

    mlai1(:) = nan
    mlai2(:) = nan
    msai1(:) = nan
    msai2(:) = nan
    mhvt1(:) = nan
    mhvt2(:) = nan
    mhvb1(:) = nan
    mhvb2(:) = nan

  end subroutine EcosystemDynini







  subroutine EcosystemDyn(lbp, ubp, num_nolakep, filter_nolakep, doalb)







    use clmtype


    implicit none
    integer, intent(in) :: lbp, ubp                    
    integer, intent(in) :: num_nolakep                 
    integer, intent(in) :: filter_nolakep(ubp-lbp+1)   
    logical, intent(in) :: doalb                       











    integer , pointer :: pcolumn(:)  
    real(r8), pointer :: snowdp(:)   



    real(r8), pointer :: tlai(:)     
    real(r8), pointer :: tsai(:)     
    real(r8), pointer :: htop(:)     
    real(r8), pointer :: hbot(:)     
    real(r8), pointer :: elai(:)     
    real(r8), pointer :: esai(:)     
    integer , pointer :: frac_veg_nosno_alb(:) 





    integer  :: fp,p,c   
    real(r8) :: ol       
    real(r8) :: fb       


    if (doalb) then

       

       snowdp  => clm3%g%l%c%cps%snowdp

       

       pcolumn => clm3%g%l%c%p%column
       tlai    => clm3%g%l%c%p%pps%tlai
       tsai    => clm3%g%l%c%p%pps%tsai
       elai    => clm3%g%l%c%p%pps%elai
       esai    => clm3%g%l%c%p%pps%esai
       htop    => clm3%g%l%c%p%pps%htop
       hbot    => clm3%g%l%c%p%pps%hbot
       frac_veg_nosno_alb => clm3%g%l%c%p%pps%frac_veg_nosno_alb



       do fp = 1, num_nolakep
          p = filter_nolakep(fp)
          c = pcolumn(p)

          
          
          
          
          
          
          
          
          
          
          
          
          
          
          

          tlai(p) = timwt(1)*mlai1(p) + timwt(2)*mlai2(p)
          tsai(p) = timwt(1)*msai1(p) + timwt(2)*msai2(p)
          htop(p) = timwt(1)*mhvt1(p) + timwt(2)*mhvt2(p)
          hbot(p) = timwt(1)*mhvb1(p) + timwt(2)*mhvb2(p)

          
          
          

          ol = min( max(snowdp(c)-hbot(p), 0._r8), htop(p)-hbot(p))
          fb = 1. - ol / max(1.e-06, htop(p)-hbot(p))
          elai(p) = max(tlai(p)*fb, 0.0_r8)
          esai(p) = max(tsai(p)*fb, 0.0_r8)
          if (elai(p) < 0.05) elai(p) = 0._r8
          if (esai(p) < 0.05) esai(p) = 0._r8

          

          if ((elai(p) + esai(p)) >= 0.05) then
             frac_veg_nosno_alb(p) = 1
          else
             frac_veg_nosno_alb(p) = 0
          end if

       end do 

    end if  

  end subroutine EcosystemDyn







  subroutine interpMonthlyVeg (kmo, kda)






    implicit none







    integer :: kyr         
    integer :: kmo         
    integer :: kda         
    integer :: ksec        
    real(r8):: dtime       
    real(r8):: t           
    integer :: it(2)       
    integer :: months(2)   
    integer, dimension(12) :: ndaypm= &
         (/31,28,31,30,31,30,31,31,30,31,30,31/) 


    t = (kda-0.5) / ndaypm(kmo)
    it(1) = t + 0.5
    it(2) = it(1) + 1
    months(1) = kmo + it(1) - 1
    months(2) = kmo + it(2) - 1
    if (months(1) <  1) months(1) = 12
    if (months(2) > 12) months(2) = 1
    timwt(1) = (it(1)+0.5) - t
    timwt(2) = 1.-timwt(1)


       call readMonthlyVegetation (kmo, kda, months)



  end subroutine interpMonthlyVeg







  subroutine readMonthlyVegetation (kmo, kda, months)





    use clmtype
    use clm_varpar  , only : lsmlon, lsmlat, maxpatch_pft, maxpatch, npatch_crop, numpft
    use clm_varcon  , only : lai,sai,hvt,hvb



    implicit none
    integer, intent(in) :: kmo            
    integer, intent(in) :: kda            
    integer, intent(in) :: months(2)      







    integer :: i,j,k,l,m,p,ivt            
    integer :: begg
    integer :: endg
    integer :: begl
    integer :: endl
    integer :: begc
    integer :: endc
    integer :: begp
    integer :: endp

    integer :: ier                        
    real(r8), allocatable :: mlai(:,:,:)  
    real(r8), allocatable :: msai(:,:,:)  
    real(r8), allocatable :: mhgtt(:,:,:) 
    real(r8), allocatable :: mhgtb(:,:,:) 



      call get_proc_bounds (begg, endg, begl, endl, begc, endc, begp, endp)
      do k=1,2
          do p = begp, endp
             i = clm3%g%l%c%p%ixy(p)
             j = clm3%g%l%c%p%jxy(p)
             m = clm3%g%l%c%p%mxy(p)
             ivt = clm3%g%l%c%p%itype(p)

             
             

                if((m <= maxpatch_pft.and.ivt/=0).or.ivt==15.or.ivt==16)then
                   if (k == 1) then
                      mlai1(p) = lai(ivt,months(k))
                      msai1(p) = sai(ivt,months(k))
                      mhvt1(p) = hvt(ivt)
                      mhvb1(p) = hvb(ivt)
                   else 
                      mlai2(p) = lai(ivt,months(k))
                      msai2(p) = sai(ivt,months(k))
                      mhvt2(p) = hvt(ivt)
                      mhvb2(p) = hvb(ivt)
                   end if
                else                        
                   if (k == 1) then
                      mlai1(p) = 0.
                      msai1(p) = 0.
                      mhvt1(p) = 0.
                      mhvb1(p) = 0.
                   else 
                      mlai2(p) = 0.
                      msai2(p) = 0.
                      mhvt2(p) = 0.
                      mhvb2(p) = 0.
                   end if
                end if

          end do   

       end do   

  end subroutine readMonthlyVegetation







  subroutine EcosystemDyn_dealloc ()

    implicit none




    if(allocated(mlai1)) deallocate (mlai1)
    if(allocated(mlai2)) deallocate (mlai2)
    if(allocated(msai1)) deallocate (msai1)
    if(allocated(msai2)) deallocate (msai2)
    if(allocated(mhvt1)) deallocate (mhvt1)
    if(allocated(mhvt2)) deallocate (mhvt2)
    if(allocated(mhvb1)) deallocate (mhvb1)
    if(allocated(mhvb2)) deallocate (mhvb2)

  end subroutine EcosystemDyn_dealloc



end module STATICEcosysDynMod
