



module SnowHydrologyMod










  use shr_kind_mod, only: r8 => shr_kind_r8

  use clm_varpar  , only : nlevsno


  implicit none
  save


  public :: SnowWater         
  public :: SnowCompaction    
  public :: CombineSnowLayers 
  public :: DivideSnowLayers  
  public :: BuildSnowFilter   


  private :: Combo            







contains







  subroutine SnowWater(lbc, ubc, num_snowc, filter_snowc, &
                       num_nosnowc, filter_nosnowc)














    use clmtype
    use clm_varcon  , only : denh2o, denice, wimp, ssi
    use globals, only: dtime


    implicit none
    integer, intent(in) :: lbc, ubc                    
    integer, intent(in) :: num_snowc                   
    integer, intent(in) :: filter_snowc(ubc-lbc+1)     
    integer, intent(in) :: num_nosnowc                 
    integer, intent(in) :: filter_nosnowc(ubc-lbc+1)   













    integer , pointer :: snl(:)              
    logical , pointer :: do_capsnow(:)       
    real(r8), pointer :: qflx_snomelt(:)     
    real(r8), pointer :: qflx_rain_grnd(:)   
    real(r8), pointer :: qflx_sub_snow(:)    
    real(r8), pointer :: qflx_evap_grnd(:)   
    real(r8), pointer :: qflx_dew_snow(:)    
    real(r8), pointer :: qflx_dew_grnd(:)    
    real(r8), pointer :: dz(:,:)             



    real(r8), pointer :: qflx_top_soil(:)     



    real(r8), pointer :: h2osoi_ice(:,:)     
    real(r8), pointer :: h2osoi_liq(:,:)     





    integer  :: c, j, fc                           
    real(r8) :: qin(lbc:ubc)                       
    real(r8) :: qout(lbc:ubc)                      
    real(r8) :: wgdif                              
    real(r8) :: vol_liq(lbc:ubc,-nlevsno+1:0)      
    real(r8) :: vol_ice(lbc:ubc,-nlevsno+1:0)      
    real(r8) :: eff_porosity(lbc:ubc,-nlevsno+1:0) 


    

    snl            => clm3%g%l%c%cps%snl
    do_capsnow     => clm3%g%l%c%cps%do_capsnow
    qflx_snomelt   => clm3%g%l%c%cwf%qflx_snomelt
    qflx_rain_grnd => clm3%g%l%c%cwf%pwf_a%qflx_rain_grnd
    qflx_sub_snow  => clm3%g%l%c%cwf%pwf_a%qflx_sub_snow
    qflx_evap_grnd => clm3%g%l%c%cwf%pwf_a%qflx_evap_grnd
    qflx_dew_snow  => clm3%g%l%c%cwf%pwf_a%qflx_dew_snow
    qflx_dew_grnd  => clm3%g%l%c%cwf%pwf_a%qflx_dew_grnd
    qflx_top_soil  => clm3%g%l%c%cwf%qflx_top_soil
    dz             => clm3%g%l%c%cps%dz
    h2osoi_ice     => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq     => clm3%g%l%c%cws%h2osoi_liq


    
    



    do fc = 1,num_snowc
       c = filter_snowc(fc)
       if (do_capsnow(c)) then
          wgdif = h2osoi_ice(c,snl(c)+1) - qflx_sub_snow(c)*dtime
          h2osoi_ice(c,snl(c)+1) = wgdif
          if (wgdif < 0.) then
             h2osoi_ice(c,snl(c)+1) = 0.
             h2osoi_liq(c,snl(c)+1) = h2osoi_liq(c,snl(c)+1) + wgdif
          end if
          h2osoi_liq(c,snl(c)+1) = h2osoi_liq(c,snl(c)+1) - qflx_evap_grnd(c) * dtime
       else
          wgdif = h2osoi_ice(c,snl(c)+1) + (qflx_dew_snow(c) - qflx_sub_snow(c)) * dtime
          h2osoi_ice(c,snl(c)+1) = wgdif
          if (wgdif < 0.) then
             h2osoi_ice(c,snl(c)+1) = 0.
             h2osoi_liq(c,snl(c)+1) = h2osoi_liq(c,snl(c)+1) + wgdif
          end if
          h2osoi_liq(c,snl(c)+1) = h2osoi_liq(c,snl(c)+1) +  &
               (qflx_rain_grnd(c) + qflx_dew_grnd(c) - qflx_evap_grnd(c)) * dtime
       end if
       h2osoi_liq(c,snl(c)+1) = max(0._r8, h2osoi_liq(c,snl(c)+1))
    end do

    

    do j = -nlevsno+1, 0


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j >= snl(c)+1) then
             vol_ice(c,j) = min(1._r8, h2osoi_ice(c,j)/(dz(c,j)*denice))
             eff_porosity(c,j) = 1. - vol_ice(c,j)
             vol_liq(c,j) = min(eff_porosity(c,j),h2osoi_liq(c,j)/(dz(c,j)*denh2o))
          end if
       end do
    end do

    
    
    
    
    
    
    

    qin(:) = 0._r8

    do j = -nlevsno+1, 0


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j >= snl(c)+1) then
             h2osoi_liq(c,j) = h2osoi_liq(c,j) + qin(c)
             if (j <= -1) then
                
                if (eff_porosity(c,j) < wimp .OR. eff_porosity(c,j+1) < wimp) then
                   qout(c) = 0._r8
                else
                   qout(c) = max(0._r8,(vol_liq(c,j)-ssi*eff_porosity(c,j))*dz(c,j))
                   qout(c) = min(qout(c),(1.-vol_ice(c,j+1)-vol_liq(c,j+1))*dz(c,j+1))
                end if
             else
                qout(c) = max(0._r8,(vol_liq(c,j) - ssi*eff_porosity(c,j))*dz(c,j))
             end if
             qout(c) = qout(c)*1000.
             h2osoi_liq(c,j) = h2osoi_liq(c,j) - qout(c)
             qin(c) = qout(c)
          end if
       end do
    end do



    do fc = 1, num_snowc
       c = filter_snowc(fc)
       
       qflx_top_soil(c) = qout(c) / dtime
    end do



    do fc = 1, num_nosnowc
       c = filter_nosnowc(fc)
       qflx_top_soil(c) = qflx_rain_grnd(c) + qflx_snomelt(c)
    end do

  end subroutine SnowWater







  subroutine SnowCompaction(lbc, ubc, num_snowc, filter_snowc)











    use clmtype
    use globals, only: dtime
    use clm_varcon  , only : denice, denh2o, tfrz


    implicit none
    integer, intent(in) :: lbc, ubc                
    integer, intent(in) :: num_snowc               
    integer, intent(in) :: filter_snowc(ubc-lbc+1) 













    integer,  pointer :: snl(:)             



    integer,  pointer :: imelt(:,:)        
    real(r8), pointer :: frac_iceold(:,:)  
    real(r8), pointer :: t_soisno(:,:)     
    real(r8), pointer :: h2osoi_ice(:,:)   
    real(r8), pointer :: h2osoi_liq(:,:)   



    real(r8), pointer :: dz(:,:)           





    integer :: j, c, fc                   
    real(r8), parameter :: c2 = 23.e-3    
    real(r8), parameter :: c3 = 2.777e-6  
    real(r8), parameter :: c4 = 0.04      
    real(r8), parameter :: c5 = 2.0       
    real(r8), parameter :: dm = 100.0     
    real(r8), parameter :: eta0 = 9.e+5   
    real(r8) :: burden(lbc:ubc) 
    real(r8) :: ddz1   
    real(r8) :: ddz2   
    real(r8) :: ddz3   
    real(r8) :: dexpf  
    real(r8) :: fi     
    real(r8) :: td     
    real(r8) :: pdzdtc 
    real(r8) :: void   
    real(r8) :: wx     
    real(r8) :: bi     



    

    snl         => clm3%g%l%c%cps%snl
    dz          => clm3%g%l%c%cps%dz
    imelt       => clm3%g%l%c%cps%imelt
    frac_iceold => clm3%g%l%c%cps%frac_iceold
    t_soisno    => clm3%g%l%c%ces%t_soisno
    h2osoi_ice  => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq  => clm3%g%l%c%cws%h2osoi_liq


    

    burden(:) = 0._r8

    do j = -nlevsno+1, 0


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j >= snl(c)+1) then

             wx = h2osoi_ice(c,j) + h2osoi_liq(c,j)
             void = 1. - (h2osoi_ice(c,j)/denice + h2osoi_liq(c,j)/denh2o) / dz(c,j)

             
             if (void > 0.001 .and. h2osoi_ice(c,j) > .1) then
                bi = h2osoi_ice(c,j) / dz(c,j)
                fi = h2osoi_ice(c,j) / wx
                td = tfrz-t_soisno(c,j)
                dexpf = exp(-c4*td)

                

                ddz1 = -c3*dexpf
                if (bi > dm) ddz1 = ddz1*exp(-46.0e-3*(bi-dm))

                

                if (h2osoi_liq(c,j) > 0.01*dz(c,j)) ddz1=ddz1*c5

                

                ddz2 = -burden(c)*exp(-0.08*td - c2*bi)/eta0

                

                if (imelt(c,j) == 1) then
                   ddz3 = - 1./dtime * max(0._r8,(frac_iceold(c,j) - fi)/frac_iceold(c,j))
                else
                   ddz3 = 0._r8
                end if

                

                pdzdtc = ddz1 + ddz2 + ddz3

                

                dz(c,j) = dz(c,j) * (1.+pdzdtc*dtime)
             end if

             

             burden(c) = burden(c) + wx

          end if
       end do
    end do

  end subroutine SnowCompaction







  subroutine CombineSnowLayers(lbc, ubc, num_snowc, filter_snowc)








    use clmtype
    use clm_varcon, only : istsoil


    implicit none
    integer, intent(in)    :: lbc, ubc                    
    integer, intent(inout) :: num_snowc                   
    integer, intent(inout) :: filter_snowc(ubc-lbc+1)     













    integer, pointer :: clandunit(:)       
    integer, pointer :: ityplun(:)         



    integer , pointer :: snl(:)            
    real(r8), pointer :: h2osno(:)         
    real(r8), pointer :: snowdp(:)         
    real(r8), pointer :: dz(:,:)           
    real(r8), pointer :: zi(:,:)           
    real(r8), pointer :: t_soisno(:,:)     
    real(r8), pointer :: h2osoi_ice(:,:)   
    real(r8), pointer :: h2osoi_liq(:,:)   



    real(r8), pointer :: z(:,:)            





    integer :: c, fc                 
    integer :: i,k                   
    integer :: j,l                   
    integer :: msn_old(lbc:ubc)      
    integer :: mssi(lbc:ubc)         
    integer :: neibor                
    real(r8):: zwice(lbc:ubc)        
    real(r8):: zwliq (lbc:ubc)       
    real(r8):: dzmin(5)              

    data dzmin /0.010, 0.015, 0.025, 0.055, 0.115/


    

    ityplun    => clm3%g%l%itype

    

    clandunit  => clm3%g%l%c%landunit
    snl        => clm3%g%l%c%cps%snl
    snowdp     => clm3%g%l%c%cps%snowdp
    h2osno     => clm3%g%l%c%cws%h2osno
    dz         => clm3%g%l%c%cps%dz
    zi         => clm3%g%l%c%cps%zi
    z          => clm3%g%l%c%cps%z
    t_soisno   => clm3%g%l%c%ces%t_soisno
    h2osoi_ice => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq => clm3%g%l%c%cws%h2osoi_liq

    
    



    do fc = 1, num_snowc
       c = filter_snowc(fc)
       msn_old(c) = snl(c)
    end do

    

    do fc = 1, num_snowc
       c = filter_snowc(fc)
       l = clandunit(c)
       do j = msn_old(c)+1,0
          if (h2osoi_ice(c,j) <= .1) then
             if (ityplun(l) == istsoil) then
                h2osoi_liq(c,j+1) = h2osoi_liq(c,j+1) + h2osoi_liq(c,j)
                h2osoi_ice(c,j+1) = h2osoi_ice(c,j+1) + h2osoi_ice(c,j)
             else if (ityplun(l) /= istsoil .and. j /= 0) then
                h2osoi_liq(c,j+1) = h2osoi_liq(c,j+1) + h2osoi_liq(c,j)
                h2osoi_ice(c,j+1) = h2osoi_ice(c,j+1) + h2osoi_ice(c,j)
             end if

             
             if (j > snl(c)+1 .and. snl(c) < -1) then
                do i = j, snl(c)+2, -1
                   t_soisno(c,i)   = t_soisno(c,i-1)
                   h2osoi_liq(c,i) = h2osoi_liq(c,i-1)
                   h2osoi_ice(c,i) = h2osoi_ice(c,i-1)
                   dz(c,i)         = dz(c,i-1)
                end do
             end if
             snl(c) = snl(c) + 1
          end if
       end do
    end do



    do fc = 1, num_snowc
       c = filter_snowc(fc)
       h2osno(c) = 0._r8
       snowdp(c) = 0._r8
       zwice(c)  = 0._r8
       zwliq(c)  = 0._r8
    end do

    do j = -nlevsno+1,0


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j >= snl(c)+1) then
             h2osno(c) = h2osno(c) + h2osoi_ice(c,j) + h2osoi_liq(c,j)
             snowdp(c) = snowdp(c) + dz(c,j)
             zwice(c)  = zwice(c) + h2osoi_ice(c,j)
             zwliq(c)  = zwliq(c) + h2osoi_liq(c,j)
          end if
       end do
    end do

    
    



    do fc = 1, num_snowc
       c = filter_snowc(fc)
       l = clandunit(c)
       if (snowdp(c) < 0.01 .and. snowdp(c) > 0.) then
          snl(c) = 0
          h2osno(c) = zwice(c)
          if (h2osno(c) <= 0.) snowdp(c) = 0._r8
          if (ityplun(l) == istsoil) h2osoi_liq(c,1) = h2osoi_liq(c,1) + zwliq(c)
       end if
    end do

    
    

    do fc = 1, num_snowc
       c = filter_snowc(fc)

       

       if (snl(c) < -1) then

          msn_old(c) = snl(c)
          mssi(c) = 1

          do i = msn_old(c)+1,0
             if (dz(c,i) < dzmin(mssi(c))) then

                if (i == snl(c)+1) then
                   
                   neibor = i + 1
                else if (i == 0) then
                   
                   neibor = i - 1
                else
                   
                   neibor = i + 1
                   if ((dz(c,i-1)+dz(c,i)) < (dz(c,i+1)+dz(c,i))) neibor = i-1
                end if

                
                if (neibor > i) then
                   j = neibor
                   l = i
                else
                   j = i
                   l = neibor
                end if

                call Combo (dz(c,j), h2osoi_liq(c,j), h2osoi_ice(c,j), &
                   t_soisno(c,j), dz(c,l), h2osoi_liq(c,l), h2osoi_ice(c,l), t_soisno(c,l) )

                
                if (j-1 > snl(c)+1) then
                   do k = j-1, snl(c)+2, -1
                      t_soisno(c,k) = t_soisno(c,k-1)
                      h2osoi_ice(c,k) = h2osoi_ice(c,k-1)
                      h2osoi_liq(c,k) = h2osoi_liq(c,k-1)
                      dz(c,k) = dz(c,k-1)
                   end do
                end if

                
                snl(c) = snl(c) + 1
                if (snl(c) >= -1) EXIT

             else

                
                mssi(c) = mssi(c) + 1

             end if
          end do

       end if

    end do

    

    do j = 0, -nlevsno+1, -1


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j >= snl(c) + 1) then
             z(c,j) = zi(c,j) - 0.5*dz(c,j)
             zi(c,j-1) = zi(c,j) - dz(c,j)
          end if
       end do
    end do

  end subroutine CombineSnowLayers







  subroutine DivideSnowLayers(lbc, ubc, num_snowc, filter_snowc)





    use clmtype


    implicit none
    integer, intent(in)    :: lbc, ubc                    
    integer, intent(inout) :: num_snowc                   
    integer, intent(inout) :: filter_snowc(ubc-lbc+1)     













    integer , pointer :: snl(:)            
    real(r8), pointer :: dz(:,:)           
    real(r8), pointer :: zi(:,:)           
    real(r8), pointer :: t_soisno(:,:)     
    real(r8), pointer :: h2osoi_ice(:,:)   
    real(r8), pointer :: h2osoi_liq(:,:)   



    real(r8), pointer :: z(:,:)            





    integer  :: j, c, fc               
    real(r8) :: drr                    
    integer  :: msno                   
    real(r8) :: dzsno(lbc:ubc,nlevsno) 
    real(r8) :: swice(lbc:ubc,nlevsno) 
    real(r8) :: swliq(lbc:ubc,nlevsno) 
    real(r8) :: tsno(lbc:ubc ,nlevsno) 
    real(r8) :: zwice                  
    real(r8) :: zwliq                  
    real(r8) :: propor                 


    

    snl        => clm3%g%l%c%cps%snl
    dz         => clm3%g%l%c%cps%dz
    zi         => clm3%g%l%c%cps%zi
    z          => clm3%g%l%c%cps%z
    t_soisno   => clm3%g%l%c%ces%t_soisno
    h2osoi_ice => clm3%g%l%c%cws%h2osoi_ice
    h2osoi_liq => clm3%g%l%c%cws%h2osoi_liq

    
    

    do j = 1,nlevsno


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j <= abs(snl(c))) then
             dzsno(c,j) = dz(c,j+snl(c))
             swice(c,j) = h2osoi_ice(c,j+snl(c))
             swliq(c,j) = h2osoi_liq(c,j+snl(c))
             tsno(c,j)  = t_soisno(c,j+snl(c))
          end if
       end do
    end do



    do fc = 1, num_snowc
       c = filter_snowc(fc)

       msno = abs(snl(c))

       if (msno == 1) then
          
          if (dzsno(c,1) > 0.03) then
             msno = 2
             dzsno(c,1) = dzsno(c,1)/2.
             swice(c,1) = swice(c,1)/2.
             swliq(c,1) = swliq(c,1)/2.
             dzsno(c,2) = dzsno(c,1)
             swice(c,2) = swice(c,1)
             swliq(c,2) = swliq(c,1)
             tsno(c,2)  = tsno(c,1)
          end if
       end if

       if (msno > 1) then
          if (dzsno(c,1) > 0.02) then
             drr = dzsno(c,1) - 0.02
             propor = drr/dzsno(c,1)
             zwice = propor*swice(c,1)
             zwliq = propor*swliq(c,1)
             propor = 0.02/dzsno(c,1)
             swice(c,1) = propor*swice(c,1)
             swliq(c,1) = propor*swliq(c,1)
             dzsno(c,1) = 0.02

             call Combo (dzsno(c,2), swliq(c,2), swice(c,2), tsno(c,2), drr, &
                  zwliq, zwice, tsno(c,1))

             
             if (msno <= 2 .and. dzsno(c,2) > 0.07) then
                msno = 3
                dzsno(c,2) = dzsno(c,2)/2.
                swice(c,2) = swice(c,2)/2.
                swliq(c,2) = swliq(c,2)/2.
                dzsno(c,3) = dzsno(c,2)
                swice(c,3) = swice(c,2)
                swliq(c,3) = swliq(c,2)
                tsno(c,3)  = tsno(c,2)
             end if
          end if
       end if

       if (msno > 2) then
          if (dzsno(c,2) > 0.05) then
             drr = dzsno(c,2) - 0.05
             propor = drr/dzsno(c,2)
             zwice = propor*swice(c,2)
             zwliq = propor*swliq(c,2)
             propor = 0.05/dzsno(c,2)
             swice(c,2) = propor*swice(c,2)
             swliq(c,2) = propor*swliq(c,2)
             dzsno(c,2) = 0.05

             call Combo (dzsno(c,3), swliq(c,3), swice(c,3), tsno(c,3), drr, &
                  zwliq, zwice, tsno(c,2))

             
             if (msno <= 3 .and. dzsno(c,3) > 0.18) then
                msno =  4
                dzsno(c,3) = dzsno(c,3)/2.
                swice(c,3) = swice(c,3)/2.
                swliq(c,3) = swliq(c,3)/2.
                dzsno(c,4) = dzsno(c,3)
                swice(c,4) = swice(c,3)
                swliq(c,4) = swliq(c,3)
                tsno(c,4)  = tsno(c,3)
             end if
          end if
       end if

       if (msno > 3) then
          if (dzsno(c,3) > 0.11) then
             drr = dzsno(c,3) - 0.11
             propor = drr/dzsno(c,3)
             zwice = propor*swice(c,3)
             zwliq = propor*swliq(c,3)
             propor = 0.11/dzsno(c,3)
             swice(c,3) = propor*swice(c,3)
             swliq(c,3) = propor*swliq(c,3)
             dzsno(c,3) = 0.11

             call Combo (dzsno(c,4), swliq(c,4), swice(c,4), tsno(c,4), drr, &
                  zwliq, zwice, tsno(c,3))

             
             if (msno <= 4 .and. dzsno(c,4) > 0.41) then
                msno = 5
                dzsno(c,4) = dzsno(c,4)/2.
                swice(c,4) = swice(c,4)/2.
                swliq(c,4) = swliq(c,4)/2.
                dzsno(c,5) = dzsno(c,4)
                swice(c,5) = swice(c,4)
                swliq(c,5) = swliq(c,4)
                tsno(c,5)  = tsno(c,4)
             end if
          end if
       end if

       if (msno > 4) then
          if (dzsno(c,4) > 0.23) then
             drr = dzsno(c,4) - 0.23
             propor = drr/dzsno(c,4)
             zwice = propor*swice(c,4)
             zwliq = propor*swliq(c,4)
             propor = 0.23/dzsno(c,4)
             swice(c,4) = propor*swice(c,4)
             swliq(c,4) = propor*swliq(c,4)
             dzsno(c,4) = 0.23

             call Combo (dzsno(c,5), swliq(c,5), swice(c,5), tsno(c,5), drr, &
                  zwliq, zwice, tsno(c,4))
          end if
       end if

       snl(c) = -msno

    end do

    do j = -nlevsno+1,0


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j >= snl(c)+1) then
             dz(c,j)         = dzsno(c,j-snl(c))
             h2osoi_ice(c,j) = swice(c,j-snl(c))
             h2osoi_liq(c,j) = swliq(c,j-snl(c))
             t_soisno(c,j)   = tsno(c,j-snl(c))
          end if
       end do
    end do

    do j = 0, -nlevsno+1, -1


       do fc = 1, num_snowc
          c = filter_snowc(fc)
          if (j >= snl(c)+1) then
             z(c,j)    = zi(c,j) - 0.5*dz(c,j)
             zi(c,j-1) = zi(c,j) - dz(c,j)
          end if
       end do
    end do

  end subroutine DivideSnowLayers







  subroutine Combo(dz,  wliq,  wice, t, dz2, wliq2, wice2, t2)









    use clm_varcon,  only : cpice, cpliq, tfrz, hfus


    implicit none
    real(r8), intent(in)    :: dz2   
    real(r8), intent(in)    :: wliq2 
    real(r8), intent(in)    :: wice2 
    real(r8), intent(in)    :: t2    
    real(r8), intent(inout) :: dz    
    real(r8), intent(inout) :: wliq  
    real(r8), intent(inout) :: wice  
    real(r8), intent(inout) :: t     













    real(r8) :: dzc   
    real(r8) :: wliqc 
    real(r8) :: wicec 
    real(r8) :: tc    
    real(r8) :: h     
    real(r8) :: h2    
    real(r8) :: hc    


    dzc = dz+dz2
    wicec = (wice+wice2)
    wliqc = (wliq+wliq2)
    h = (cpice*wice+cpliq*wliq) * (t-tfrz)+hfus*wliq
    h2= (cpice*wice2+cpliq*wliq2) * (t2-tfrz)+hfus*wliq2

    hc = h + h2
    if(hc < 0.)then
       tc = tfrz + hc/(cpice*wicec + cpliq*wliqc)
    else if (hc.le.hfus*wliqc) then
       tc = tfrz
    else
       tc = tfrz + (hc - hfus*wliqc) / (cpice*wicec + cpliq*wliqc)
    end if

    dz = dzc
    wice = wicec
    wliq = wliqc
    t = tc

  end subroutine Combo







  subroutine BuildSnowFilter(lbc, ubc, num_nolakec, filter_nolakec, &
                             num_snowc, filter_snowc, &
                             num_nosnowc, filter_nosnowc)





    use clmtype


    implicit none
    integer, intent(in)  :: lbc, ubc                    
    integer, intent(in)  :: num_nolakec                 
    integer, intent(in)  :: filter_nolakec(ubc-lbc+1)   
    integer, intent(out) :: num_snowc                   
    integer, intent(out) :: filter_snowc(ubc-lbc+1)     
    integer, intent(out) :: num_nosnowc                 
    integer, intent(out) :: filter_nosnowc(ubc-lbc+1)   










    integer , pointer :: snl(:)                        




    integer  :: fc, c


    

    snl => clm3%g%l%c%cps%snl

    

    num_snowc = 0
    num_nosnowc = 0
    do fc = 1, num_nolakec
       c = filter_nolakec(fc)
       if (snl(c) < 0) then
          num_snowc = num_snowc + 1
          filter_snowc(num_snowc) = c
       else
          num_nosnowc = num_nosnowc + 1
          filter_nosnowc(num_nosnowc) = c
       end if
    end do

  end subroutine BuildSnowFilter

end module SnowHydrologyMod
