






module SurfaceRadiationMod










   use shr_kind_mod, only: r8 => shr_kind_r8


   implicit none
   save


   public :: SurfaceRadiation 












contains







   subroutine SurfaceRadiation(lbp, ubp)


















     use clmtype

     use clm_varpar  , only : numrad
     use clm_varcon  , only : spval


     use globals, only: dtime, secs


     implicit none
     integer, intent(in) :: lbp, ubp      

































     integer , pointer :: ivt(:)           
     integer , pointer :: pcolumn(:)       
     integer , pointer :: pgridcell(:)     
     real(r8), pointer :: pwtgcell(:)      
     real(r8), pointer :: elai(:)          
     real(r8), pointer :: esai(:)          
     real(r8), pointer :: londeg(:)        
     real(r8), pointer :: latdeg(:)        
     real(r8), pointer :: slasun(:)        
     real(r8), pointer :: slasha(:)        
     real(r8), pointer :: gdir(:)	   
     real(r8), pointer :: omega(:,:)       
     real(r8), pointer :: coszen(:)	   
     real(r8), pointer :: forc_solad(:,:)  
     real(r8), pointer :: forc_solai(:,:)  
     real(r8), pointer :: fabd(:,:)        
     real(r8), pointer :: fabi(:,:)        
     real(r8), pointer :: ftdd(:,:)        
     real(r8), pointer :: ftid(:,:)        
     real(r8), pointer :: ftii(:,:)        
     real(r8), pointer :: albgrd(:,:)      
     real(r8), pointer :: albgri(:,:)      
     real(r8), pointer :: albd(:,:)        
     real(r8), pointer :: albi(:,:)        
     real(r8), pointer :: slatop(:)        
     real(r8), pointer :: dsladlai(:)      



     real(r8), pointer :: fsun(:)          
     real(r8), pointer :: laisun(:)        
     real(r8), pointer :: laisha(:)        
     real(r8), pointer :: sabg(:)          
     real(r8), pointer :: sabv(:)          
     real(r8), pointer :: fsa(:)           
     real(r8), pointer :: parsun(:)        
     real(r8), pointer :: parsha(:)        
     real(r8), pointer :: fsr(:)           
     real(r8), pointer :: fsds_vis_d(:)    
     real(r8), pointer :: fsds_nir_d(:)    
     real(r8), pointer :: fsds_vis_i(:)    
     real(r8), pointer :: fsds_nir_i(:)    
     real(r8), pointer :: fsr_vis_d(:)     
     real(r8), pointer :: fsr_nir_d(:)     
     real(r8), pointer :: fsr_vis_i(:)     
     real(r8), pointer :: fsr_nir_i(:)     
     real(r8), pointer :: fsds_vis_d_ln(:) 
     real(r8), pointer :: fsds_nir_d_ln(:) 
     real(r8), pointer :: fsr_vis_d_ln(:)  
     real(r8), pointer :: fsr_nir_d_ln(:)  
     real(r8), pointer :: eff_kid(:,:)     
     real(r8), pointer :: eff_kii(:,:)     
     real(r8), pointer :: sun_faid(:,:)    
     real(r8), pointer :: sun_faii(:,:)    
     real(r8), pointer :: sha_faid(:,:)    
     real(r8), pointer :: sha_faii(:,:)    
     real(r8), pointer :: sun_add(:,:)     
     real(r8), pointer :: tot_aid(:,:)     
     real(r8), pointer :: sun_aid(:,:)     
     real(r8), pointer :: sun_aii(:,:)     
     real(r8), pointer :: sha_aid(:,:)     
     real(r8), pointer :: sha_aii(:,:)     
     real(r8), pointer :: sun_atot(:,:)    
     real(r8), pointer :: sha_atot(:,:)    
     real(r8), pointer :: sun_alf(:,:)     
     real(r8), pointer :: sha_alf(:,:)     
     real(r8), pointer :: sun_aperlai(:,:) 
     real(r8), pointer :: sha_aperlai(:,:) 





     integer , parameter :: nband = numrad 
     real(r8), parameter :: mpe = 1.e-06_r8   
     integer  :: p                   
     integer  :: c                   
     integer  :: g                   
     integer  :: ib                  
     real(r8) :: abs                 
     real(r8) :: rnir                
     real(r8) :: rvis                
     real(r8) :: laifra              
     real(r8) :: trd                 
     real(r8) :: tri                 
     real(r8) :: cad(lbp:ubp,numrad) 
     real(r8) :: cai(lbp:ubp,numrad) 
     real(r8) :: vai(lbp:ubp)        
     real(r8) :: ext                 
     real(r8) :: t1, t2              
     real(r8) :: cosz
     integer  :: local_secp1         




     

     londeg        => clm3%g%londeg
     latdeg        => clm3%g%latdeg
     forc_solad    => clm_a2l%forc_solad
     forc_solai    => clm_a2l%forc_solai

     

     albgrd        => clm3%g%l%c%cps%albgrd
     albgri        => clm3%g%l%c%cps%albgri
     coszen        => clm3%g%l%c%cps%coszen

     

     ivt           => clm3%g%l%c%p%itype
     pcolumn       => clm3%g%l%c%p%column
     pgridcell     => clm3%g%l%c%p%gridcell
     pwtgcell      => clm3%g%l%c%p%wtgcell
     elai          => clm3%g%l%c%p%pps%elai
     esai          => clm3%g%l%c%p%pps%esai
     slasun        => clm3%g%l%c%p%pps%slasun
     slasha        => clm3%g%l%c%p%pps%slasha
     gdir          => clm3%g%l%c%p%pps%gdir
     omega         => clm3%g%l%c%p%pps%omega
     laisun        => clm3%g%l%c%p%pps%laisun
     laisha        => clm3%g%l%c%p%pps%laisha
     fabd          => clm3%g%l%c%p%pps%fabd
     fabi          => clm3%g%l%c%p%pps%fabi
     ftdd          => clm3%g%l%c%p%pps%ftdd
     ftid          => clm3%g%l%c%p%pps%ftid
     ftii          => clm3%g%l%c%p%pps%ftii
     albd          => clm3%g%l%c%p%pps%albd
     albi          => clm3%g%l%c%p%pps%albi
     fsun          => clm3%g%l%c%p%pps%fsun
     sabg          => clm3%g%l%c%p%pef%sabg
     sabv          => clm3%g%l%c%p%pef%sabv
     fsa           => clm3%g%l%c%p%pef%fsa
     fsr           => clm3%g%l%c%p%pef%fsr
     parsun        => clm3%g%l%c%p%pef%parsun
     parsha        => clm3%g%l%c%p%pef%parsha
     fsds_vis_d    => clm3%g%l%c%p%pef%fsds_vis_d
     fsds_nir_d    => clm3%g%l%c%p%pef%fsds_nir_d
     fsds_vis_i    => clm3%g%l%c%p%pef%fsds_vis_i
     fsds_nir_i    => clm3%g%l%c%p%pef%fsds_nir_i
     fsr_vis_d     => clm3%g%l%c%p%pef%fsr_vis_d
     fsr_nir_d     => clm3%g%l%c%p%pef%fsr_nir_d
     fsr_vis_i     => clm3%g%l%c%p%pef%fsr_vis_i
     fsr_nir_i     => clm3%g%l%c%p%pef%fsr_nir_i
     fsds_vis_d_ln => clm3%g%l%c%p%pef%fsds_vis_d_ln
     fsds_nir_d_ln => clm3%g%l%c%p%pef%fsds_nir_d_ln
     fsr_vis_d_ln  => clm3%g%l%c%p%pef%fsr_vis_d_ln
     fsr_nir_d_ln  => clm3%g%l%c%p%pef%fsr_nir_d_ln
     eff_kid =>       clm3%g%l%c%p%pps%eff_kid
     eff_kii =>       clm3%g%l%c%p%pps%eff_kii
     sun_faid =>      clm3%g%l%c%p%pps%sun_faid
     sun_faii =>      clm3%g%l%c%p%pps%sun_faii
     sha_faid =>      clm3%g%l%c%p%pps%sha_faid
     sha_faii =>      clm3%g%l%c%p%pps%sha_faii
     sun_add =>       clm3%g%l%c%p%pef%sun_add
     tot_aid =>       clm3%g%l%c%p%pef%tot_aid
     sun_aid =>       clm3%g%l%c%p%pef%sun_aid
     sun_aii =>       clm3%g%l%c%p%pef%sun_aii
     sha_aid =>       clm3%g%l%c%p%pef%sha_aid
     sha_aii =>       clm3%g%l%c%p%pef%sha_aii
     sun_atot =>      clm3%g%l%c%p%pef%sun_atot
     sha_atot =>      clm3%g%l%c%p%pef%sha_atot
     sun_alf =>       clm3%g%l%c%p%pef%sun_alf
     sha_alf =>       clm3%g%l%c%p%pef%sha_alf
     sun_aperlai =>   clm3%g%l%c%p%pef%sun_aperlai
     sha_aperlai =>   clm3%g%l%c%p%pef%sha_aperlai
     
     

     slatop        => pftcon%slatop
     dsladlai      => pftcon%dsladlai
     
     
     



     



     do p = lbp,ubp
        if (pwtgcell(p)>0._r8) then
           sabg(p) = 0._r8
           sabv(p) = 0._r8
           fsa(p)  = 0._r8
        end if
     end do 

     


     do p = lbp,ubp
        if (pwtgcell(p)>0._r8) then
           c = pcolumn(p)
           g = pgridcell(p)
        
           vai(p) = elai(p) + esai(p)
           if (coszen(c) > 0._r8 .and. elai(p) > 0._r8 .and. gdir(p) > 0._r8) then
              cosz = max(0.001_r8, coszen(c))
              ext = gdir(p)/cosz
              t1 = min(ext*elai(p), 40.0_r8)
              t2 = exp(-t1)
              fsun(p) = (1._r8-t2)/t1
              
              
              
              
              
              if (elai(p) > 0.01_r8) then
                 laisun(p) = elai(p)*fsun(p)
                 laisha(p) = elai(p)*(1._r8-fsun(p))
                 
                 
                 
                 slasun(p) = (t2*dsladlai(ivt(p))*ext*elai(p) + &
                              t2*dsladlai(ivt(p)) + &
                              t2*slatop(ivt(p))*ext - &
                              dsladlai(ivt(p)) - &
                              slatop(ivt(p))*ext) / &
                              (ext*(t2-1._r8))
                 slasha(p) = ((slatop(ivt(p)) + &
                             (dsladlai(ivt(p)) * elai(p)/2.0_r8)) * elai(p) - &
                             laisun(p)*slasun(p)) / laisha(p)
              else
                 
                 fsun(p) = 1._r8
                 laisun(p) = elai(p)
                 laisha(p) = 0._r8
                 slasun(p) = slatop(ivt(p))
                 slasha(p) = 0._r8
              end if
           else
              fsun(p)   = 0._r8
              laisun(p) = 0._r8
              laisha(p) = elai(p)
              slasun(p) = 0._r8
              slasha(p) = 0._r8
           end if
        end if
     end do
        
     
     do ib = 1, nband


        do p = lbp,ubp
           if (pwtgcell(p)>0._r8) then
              c = pcolumn(p)
              g = pgridcell(p)
              
              
              
              cad(p,ib) = forc_solad(g,ib)*fabd(p,ib)
              cai(p,ib) = forc_solai(g,ib)*fabi(p,ib)
              sabv(p) = sabv(p) + cad(p,ib) + cai(p,ib)
              fsa(p)  = fsa(p)  + cad(p,ib) + cai(p,ib)
              
              
              
              trd = forc_solad(g,ib)*ftdd(p,ib)
              tri = forc_solad(g,ib)*ftid(p,ib) + forc_solai(g,ib)*ftii(p,ib)
              
              
              
              abs = trd*(1._r8-albgrd(c,ib)) + tri*(1._r8-albgri(c,ib))
              sabg(p) = sabg(p) + abs
              fsa(p)  = fsa(p)  + abs
              
              
              
              if (coszen(c) > 0._r8 .and. elai(p) > 0._r8) then
                 
                 
                 
                 
                 
                 sun_add(p,ib) = forc_solad(g,ib) * (1._r8-ftdd(p,ib)) * (1._r8-omega(p,ib))
                 tot_aid(p,ib) = (forc_solad(g,ib) * fabd(p,ib)) - sun_add(p,ib)
                 
                 
                 
                 
                 tot_aid(p,ib) = max(tot_aid(p,ib), 0._r8)
                 
                 
                 
                 
                 
                 
                 
                 
                 
                 
                 

                 
                 
                 sun_faid(p,ib) = fsun(p)
                 sun_faii(p,ib) = fsun(p)
                 sha_faid(p,ib) = 1._r8-sun_faid(p,ib)
                 sha_faii(p,ib) = 1._r8-sun_faii(p,ib)

                 
                 
                 

                 sun_aid(p,ib) = tot_aid(p,ib) * sun_faid(p,ib)
                 sun_aii(p,ib) = forc_solai(g,ib)*fabi(p,ib)*sun_faii(p,ib)
                 sha_aid(p,ib) = tot_aid(p,ib) * sha_faid(p,ib)
                 sha_aii(p,ib) = forc_solai(g,ib)*fabi(p,ib)*sha_faii(p,ib)
                 
                 
                 
                 
                 sun_atot(p,ib) = sun_add(p,ib) + sun_aid(p,ib) + sun_aii(p,ib)
                 sha_atot(p,ib) = sha_aid(p,ib) + sha_aii(p,ib)
                 
                 
                 
                 
                 laifra = elai(p)/vai(p)
                 sun_alf(p,ib) = sun_atot(p,ib) * laifra
                 sha_alf(p,ib) = sha_atot(p,ib) * laifra
                 
                 
                 
                 
                 if (laisun(p) > 0._r8) then
                    sun_aperlai(p,ib) = sun_alf(p,ib)/laisun(p)
                 else
                    sun_aperlai(p,ib) = 0._r8
                 endif
                 if (laisha(p) > 0._r8) then
                    sha_aperlai(p,ib) = sha_alf(p,ib)/laisha(p)
                 else
                    sha_aperlai(p,ib) = 0._r8
                 endif
             
              else   
                 
                 sun_add(p,ib)     = 0._r8
                 tot_aid(p,ib)     = 0._r8
                 eff_kid(p,ib)     = 0._r8
                 eff_kii(p,ib)     = 0._r8
                 sun_faid(p,ib)    = 0._r8
                 sun_faii(p,ib)    = 0._r8
                 sha_faid(p,ib)    = 0._r8
                 sha_faii(p,ib)    = 0._r8
                 sun_aid(p,ib)     = 0._r8
                 sun_aii(p,ib)     = 0._r8
                 sha_aid(p,ib)     = 0._r8
                 sha_aii(p,ib)     = 0._r8
                 sun_atot(p,ib)    = 0._r8
                 sha_atot(p,ib)    = 0._r8
                 sun_alf(p,ib)     = 0._r8
                 sha_alf(p,ib)     = 0._r8
                 sun_aperlai(p,ib) = 0._r8
                 sha_aperlai(p,ib) = 0._r8
                 
              end if
           end if
        end do 
     end do 



     do p = lbp,ubp
        if (pwtgcell(p)>0._r8) then
           g = pgridcell(p)
        
           
           
           
           
           parsun(p) = sun_aperlai(p,1)
           parsha(p) = sha_aperlai(p,1)
           
           
           
           
           rvis = albd(p,1)*forc_solad(g,1) + albi(p,1)*forc_solai(g,1)
           rnir = albd(p,2)*forc_solad(g,2) + albi(p,2)*forc_solai(g,2)
           fsr(p) = rvis + rnir
           
           fsds_vis_d(p) = forc_solad(g,1)
           fsds_nir_d(p) = forc_solad(g,2)
           fsds_vis_i(p) = forc_solai(g,1)
           fsds_nir_i(p) = forc_solai(g,2)
           fsr_vis_d(p)  = albd(p,1)*forc_solad(g,1)
           fsr_nir_d(p)  = albd(p,2)*forc_solad(g,2)
           fsr_vis_i(p)  = albi(p,1)*forc_solai(g,1)
           fsr_nir_i(p)  = albi(p,2)*forc_solai(g,2)
           
           local_secp1 = secs + nint((londeg(g)/15._r8*3600._r8)/dtime)*dtime
           local_secp1 = mod(local_secp1,86400)
           if (local_secp1 == 43200) then
              fsds_vis_d_ln(p) = forc_solad(g,1)
              fsds_nir_d_ln(p) = forc_solad(g,2)
              fsr_vis_d_ln(p) = albd(p,1)*forc_solad(g,1)
              fsr_nir_d_ln(p) = albd(p,2)*forc_solad(g,2)
           else
              fsds_vis_d_ln(p) = spval
              fsds_nir_d_ln(p) = spval
              fsr_vis_d_ln(p) = spval
              fsr_nir_d_ln(p) = spval
           end if
        end if
     end do 

   end subroutine SurfaceRadiation

end module SurfaceRadiationMod
