



module accumulMod
























  use shr_kind_mod, only: r8 => shr_kind_r8
  use clm_varpar  , only: maxpatch


  implicit none
  save


  public :: init_accum_field     
  public :: accum_dealloc
  public :: extract_accum_field  
  interface extract_accum_field
     module procedure extract_accum_field_sl 
     module procedure extract_accum_field_ml 
  end interface
  public :: update_accum_field
  interface update_accum_field               
     module procedure update_accum_field_sl  
     module procedure update_accum_field_ml  
  end interface








  private



  type accum_field
     character(len=  8) :: name     
     character(len=128) :: desc     
     character(len=  8) :: units    
     character(len=  8) :: acctype  
     integer :: period              
     character(len= 8) :: type1d    
     integer :: beg1d               
     integer :: end1d               
     integer :: num1d               
     integer :: numlev              
     real(r8), pointer :: val(:,:)  
     real(r8) :: initval(maxpatch,1)         
  end type accum_field

  integer, parameter :: max_accum = 100    
  type (accum_field) :: accum(max_accum)   
  integer :: naccflds 


contains







  subroutine init_accum_field (name, units, desc, &
       accum_type, accum_period, numlev, subgrid_type, init_value,&
       nct)











    use clm_varcon,    only : cday
    use globals,       only : dtime
    use decompMod,     only : get_proc_bounds


    implicit none
    character(len=*), intent(in) :: name           
    character(len=*), intent(in) :: units          
    character(len=*), intent(in) :: desc           
    character(len=*), intent(in) :: accum_type     
    integer , intent(in) :: accum_period           
    character(len=*), intent(in)   :: subgrid_type 
    integer , intent(in) :: numlev 
    real(r8), intent(in) :: init_value(maxpatch,1) 
    integer , intent(in) :: nct 







    integer :: nf           
    integer :: beg1d,end1d  
    integer :: num1d        
    integer :: begp, endp   
    integer :: begc, endc   
    integer :: begl, endl   
    integer :: begg, endg   


    

    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

    
    



    naccflds = nct

    if (naccflds > max_accum) then
       write (6,*) 'INIT_ACCUM_FIELD error: user-defined accumulation fields ', &
            'equal to ',naccflds,' exceeds max_accum'
       call endrun
    end if
    nf = naccflds

    
    

    accum(nf)%name = trim(name)
    accum(nf)%units = trim(units)
    accum(nf)%desc = trim(desc)
    accum(nf)%acctype = trim(accum_type)
    accum(nf)%initval = init_value
    accum(nf)%period = accum_period
    if (accum(nf)%period < 0) then
       accum(nf)%period = -accum(nf)%period * nint(cday) / dtime
    end if

    select case (trim(subgrid_type))
    case ('gridcell')
       beg1d = begg
       end1d = endg
       num1d = endg - begg + 1
    case ('landunit')
       beg1d = begl
       end1d = endl
       num1d = endl - begl + 1
    case ('column')
       beg1d = begc
       end1d = endc
       num1d = endc - begc + 1
    case ('pft')
       beg1d = begp
       end1d = endp
       num1d = endp - begp + 1
    case default
       write(6,*)'INIT_ACCUM_FIELD: unknown subgrid type ',subgrid_type
       call endrun ()
    end select

    accum(nf)%type1d = trim(subgrid_type)
    accum(nf)%beg1d = beg1d
    accum(nf)%end1d = end1d
    accum(nf)%num1d = num1d
    accum(nf)%numlev = numlev

    


    allocate(accum(nf)%val(beg1d:end1d,numlev))
    accum(nf)%val(beg1d:end1d,1) = init_value(beg1d:end1d,1)

  end subroutine init_accum_field







  subroutine extract_accum_field_sl (name, field, nstep)









    use clm_varcon, only : spval


    implicit none
    character(len=*), intent(in) :: name     
    real(r8), pointer, dimension(:) :: field 
    integer , intent(in) :: nstep            









    integer :: i,k,nf        
    integer :: beg,end         


    

    nf = 0


    do i = 1, naccflds
       if (name == accum(i)%name) nf = i
    end do
    if (nf == 0) then
       write(6,*) 'EXTRACT_ACCUM_FIELD_SL error: field name ',name,' not found'
       call endrun
    endif

    

    beg = accum(nf)%beg1d
    end = accum(nf)%end1d
    if (size(field,dim=1) /= end-beg+1) then
       write(6,*)'ERROR in extract_accum_field for field ',accum(nf)%name
       write(6,*)'size of first dimension of field is ',&
            size(field,dim=1),' and should be ',end-beg+1
       call endrun
    endif

    

    if (accum(nf)%acctype == 'timeavg' .and. &
         mod(nstep,accum(nf)%period) /= 0) then


       do k = beg,end
          field(k) = spval  
       end do
    else


       do k = beg,end
          field(k) = accum(nf)%val(k,1)
       end do
    end if

  end subroutine extract_accum_field_sl







  subroutine extract_accum_field_ml (name, field, nstep)









    use clm_varcon, only : spval


    implicit none
    character(len=*), intent(in) :: name       
    real(r8), pointer, dimension(:,:) :: field 
    integer, intent(in) :: nstep               









    integer :: i,j,k,nf        
    integer :: beg,end         
    integer :: numlev          


    

    nf = 0
    do i = 1, naccflds
       if (name == accum(i)%name) nf = i
    end do
    if (nf == 0) then
       write(6,*) 'EXTRACT_ACCUM_FIELD_ML error: field name ',name,' not found'
       call endrun
    endif

    

    numlev = accum(nf)%numlev
    beg = accum(nf)%beg1d
    end = accum(nf)%end1d
    if (size(field,dim=1) /= end-beg+1) then
       write(6,*)'ERROR in extract_accum_field for field ',accum(nf)%name
       write(6,*)'size of first dimension of field is ',&
            size(field,dim=1),' and should be ',end-beg+1
       call endrun
    else if (size(field,dim=2) /= numlev) then
       write(6,*)'ERROR in extract_accum_field for field ',accum(nf)%name
       write(6,*)'size of second dimension of field iis ',&
            size(field,dim=2),' and should be ',numlev
       call endrun
    endif

    

    if (accum(nf)%acctype == 'timeavg' .and. &
         mod(nstep,accum(nf)%period) /= 0) then
       do j = 1,numlev


          do k = beg,end
             field(k,j) = spval  
          end do
       end do
    else
       do j = 1,numlev


          do k = beg,end
             field(k,j) = accum(nf)%val(k,j)
          end do
       end do
    end if

  end subroutine extract_accum_field_ml







  subroutine update_accum_field_sl (name, field, nstep)






    implicit none
    character(len=*), intent(in) :: name     
    real(r8), pointer, dimension(:) :: field 
    integer , intent(in) :: nstep            









    integer :: i,k,nf              
    integer :: accper              
    integer :: beg,end             


    

    nf = 0
    do i = 1, naccflds
       if (name == accum(i)%name) nf = i
    end do
    if (nf == 0) then
       write(6,*) 'UPDATE_ACCUM_FIELD_SL error: field name ',name,' not found'
       call endrun
    endif

    

    beg = accum(nf)%beg1d
    end = accum(nf)%end1d
    if (size(field,dim=1) /= end-beg+1) then
       write(6,*)'ERROR in UPDATE_ACCUM_FIELD_SL for field ',accum(nf)%name
       write(6,*)'size of first dimension of field is ',size(field,dim=1),&
            ' and should be ',end-beg+1
       call endrun
    endif

    

    if (accum(nf)%acctype /= 'timeavg' .AND. &
        accum(nf)%acctype /= 'runmean' .AND. &
        accum(nf)%acctype /= 'runaccum') then
       write(6,*) 'UPDATE_ACCUM_FIELD_SL error: incorrect accumulation type'
       write(6,*) ' was specified for field ',name
       write(6,*)' accumulation type specified is ',accum(nf)%acctype
       write(6,*)' only [timeavg, runmean, runaccum] are currently acceptable'
       call endrun()
    end if


    
    
    

    if (accum(nf)%acctype == 'timeavg') then

       
       

       if ((mod(nstep,accum(nf)%period) == 1) .and. (nstep /= 0)) then
          accum(nf)%val(beg:end,1) = 0._r8
       end if
       accum(nf)%val(beg:end,1) =  accum(nf)%val(beg:end,1) + field(beg:end)
       if (mod(nstep,accum(nf)%period) == 0) then
          accum(nf)%val(beg:end,1) = accum(nf)%val(beg:end,1) / accum(nf)%period
       endif

    else if (accum(nf)%acctype == 'runmean') then

       

       accper = min (nstep,accum(nf)%period)
       accum(nf)%val(beg:end,1) = ((accper-1)*accum(nf)%val(beg:end,1) + field(beg:end)) / accper

    else if (accum(nf)%acctype == 'runaccum') then

       



       do k = beg,end
          if (nint(field(k)) == -99999) then
             accum(nf)%val(k,1) = 0._r8
          end if
       end do
       accum(nf)%val(beg:end,1) = min(max(accum(nf)%val(beg:end,1) + field(beg:end), 0.), 99999.)

    end if

  end subroutine update_accum_field_sl







  subroutine update_accum_field_ml (name, field, nstep)





    implicit none
    character(len=*), intent(in) :: name       
    real(r8), pointer, dimension(:,:) :: field 
    integer , intent(in) :: nstep              









    integer :: i,j,k,nf            
    integer :: accper              
    integer :: beg,end             
    integer :: numlev              


    

    nf = 0
    do i = 1, naccflds
       if (name == accum(i)%name) nf = i
    end do
    if (nf == 0) then
       write(6,*) 'UPDATE_ACCUM_FIELD_ML error: field name ',name,' not found'
       call endrun
    endif

    

    numlev = accum(nf)%numlev
    beg = accum(nf)%beg1d
    end = accum(nf)%end1d
    if (size(field,dim=1) /= end-beg+1) then
       write(6,*)'ERROR in UPDATE_ACCUM_FIELD_ML for field ',accum(nf)%name
       write(6,*)'size of first dimension of field is ',size(field,dim=1),&
            ' and should be ',end-beg+1
       call endrun
    else if (size(field,dim=2) /= numlev) then
       write(6,*)'ERROR in UPDATE_ACCUM_FIELD_ML for field ',accum(nf)%name
       write(6,*)'size of second dimension of field is ',size(field,dim=2),&
            ' and should be ',numlev
       call endrun
    endif

    

    if (accum(nf)%acctype /= 'timeavg' .AND. &
        accum(nf)%acctype /= 'runmean' .AND. &
        accum(nf)%acctype /= 'runaccum') then
       write(6,*) 'UPDATE_ACCUM_FIELD_ML error: incorrect accumulation type'
       write(6,*) ' was specified for field ',name
       write(6,*)' accumulation type specified is ',accum(nf)%acctype
       write(6,*)' only [timeavg, runmean, runaccum] are currently acceptable'
       call endrun()
    end if

    

    
    
    

    if (accum(nf)%acctype == 'timeavg') then

       
       

       if ((mod(nstep,accum(nf)%period) == 1) .and. (nstep /= 0)) then
          accum(nf)%val(beg:end,1:numlev) = 0._r8
       endif
       accum(nf)%val(beg:end,1:numlev) =  accum(nf)%val(beg:end,1:numlev) + field(beg:end,1:numlev)
       if (mod(nstep,accum(nf)%period) == 0) then
          accum(nf)%val(beg:end,1:numlev) = accum(nf)%val(beg:end,1:numlev) / accum(nf)%period
       endif

    else if (accum(nf)%acctype == 'runmean') then

       

       accper = min (nstep,accum(nf)%period)
       accum(nf)%val(beg:end,1:numlev) = &
            ((accper-1)*accum(nf)%val(beg:end,1:numlev) + field(beg:end,1:numlev)) / accper

    else if (accum(nf)%acctype == 'runaccum') then

       

       do j = 1,numlev


          do k = beg,end
             if (nint(field(k,j)) == -99999) then
                accum(nf)%val(k,j) = 0._r8
             end if
          end do
       end do
       accum(nf)%val(beg:end,1:numlev) = &
            min(max(accum(nf)%val(beg:end,1:numlev) + field(beg:end,1:numlev), 0.), 99999.)

    end if

  end subroutine update_accum_field_ml







  subroutine accum_dealloc





    implicit none
    integer :: i



    do i = 1,naccflds
      deallocate (accum(i)%val) 
    end do

  end subroutine accum_dealloc


end module accumulMod
