    subroutine clm(forc_txy        ,forc_uxy           ,forc_vxy      &
                  ,forc_qxy        ,zgcmxy             ,precxy        &
                  ,flwdsxy         ,forc_solsxy        ,forc_sollxy   &
                  ,forc_solsdxy    ,forc_solldxy       ,forc_pbotxy   &
                  ,forc_psrfxy     ,iveg               ,isl           &
                  ,lndmsk          ,xlat               ,xlon          &
                  ,areaxy          ,dt                 ,yr            &
                  ,mnth            ,dy                 ,nsec          &
                  ,cxday           ,yr1                ,mnp1          &
                  ,dyp1            ,nsec1              ,cxday1        &
                  ,mbdate          ,qsfxy              ,qdnxy         &
                  ,snl             ,snowdp             ,snowage       &
                  ,dzclm           ,zclm               ,ziclm         &
                  ,h2osno          ,h2osoi_liq         ,h2osoi_ice    &
                  ,t_grnd          ,t_soisno           ,t_lake        &
                  ,t_veg           ,h2ocan             ,h2ocan_col    &
                  ,h2osoi_vol      ,wtc                ,wtp           &
                  ,numc            ,nump               ,t2m_max       &
                  ,t2m_min         ,t2m_max_inst       ,t2m_min_inst  &
                  ,t_ref2m         ,albxy              ,tsxy          &
                  ,shxy            ,lhxy               ,nstp          &
                  ,inest           ,ilx                ,jlx           &
                  ,soiflx          ,sabv               ,sabg          &
                  ,lwupxy          ,znt0               ,q_ref2m       &
                  ,rhoxy                                              &
                  ,lake_icefracx,lakedepthx,dzlakex,zlakex,tlakex,savedtke1x &
#if (defined DGVM)
                  ,t_mo_min           ,annpsn                         &
                  ,annpsnpot       ,fmicr              ,bm_inc        &
                  ,afmicr          ,t10min             ,tmomin20      &
                  ,agdd20          ,fpcgrid            ,lai_ind       &
                  ,crownarea       ,dphen              ,leafon        &
                  ,leafof          ,firelength         ,litterag      &
                  ,litterbg        ,cpool_fast         ,cpool_slow    &
                  ,k_fast_ave      ,k_slow_ave         ,nind          &
                  ,lm_ind          ,sm_ind             ,hm_ind        &
                  ,rm_ind          ,present            ,tda           &
                  ,t10             ,fnpsn10            ,prec365       &
                  ,agdd0           ,agdd5              ,agddtw        &
                  ,agdd            ,litter_decom_ave   ,htop          &
                  ,tsai                                               &

#endif
                                                                      )
!-----------------------------------------------------------------------
!
! !USES:
  use shr_kind_mod , only : r8 => shr_kind_r8
  use clm_varpar, only : nlevsoi,numrad,maxpatch,&
                         nlevsno,nlevlak,lsmlon,lsmlat
  use initializeMod
  use nanMod
  use clmtype
  use clm_varcon  , only : rair, cpair, po2, pco2, tcrit,tfrz,pstd,sb
  use globals
  use decompMod   , only : get_proc_bounds
  use clmtypeInitMod
!
! !PUBLIC TYPES:
  implicit none
  save
!
! !REVISION HISTORY:
! Created by Gordon Bonan, Sam Levis and Mariana Vertenstein
!
!EOP
! atmospheric forcing variables on land model grid
!
  real(r8) :: forc_txy          !atm bottom level temperature (Kelvin)
  real(r8) :: forc_uxy          !atm bottom level zonal wind (m/s)
  real(r8) :: forc_vxy          !atm bottom level meridional wind (m/s)
  real(r8) :: forc_qxy          !atm bottom level specific humidity (kg/kg)
  real(r8) :: zgcmxy            !atm bottom level height above surface (m)
  real(r8) :: precxy            !precipitation rate (mm H2O/s)
  real(r8) :: flwdsxy           !downward longwave rad onto surface (W/m**2)
  real(r8) :: forc_solsxy       !vis direct beam solar rad onto srf (W/m**2)
  real(r8) :: forc_sollxy       !nir direct beam solar rad onto srf (W/m**2)
  real(r8) :: forc_solsdxy      !vis diffuse solar rad onto srf (W/m**2)
  real(r8) :: forc_solldxy      !nir diffuse solar rad onto srf(W/m**2)
  real(r8) :: forc_pbotxy       !atm bottom level pressure (Pa)
  real(r8) :: forc_psrfxy       !atm surface pressure (Pa)
! atmosphere grid to land model surface grid mapping for each land grid cell:
!=======================================================================

! !DESCRIPTION:
! This code reads in atmospheric fields from an input file and generates
! the required atmospheric forcing. These data files have [atmmin] minute
! average data for each month. Input data files are named in month-year
! format (e.g., 09-0001 contains 240 3-hour time slices of data, 30*8, for
! September of year one). The model will cycle through however many full
! years of data are available [pyr]. At least one full year of data is
! necessary for cycling. The model may start on any base date, as long as
! this date corresponds to an existing data file. A run need not be an
! exact multiple of a year.
!
! ============================
! Possible atmospheric fields:
! ============================
! Name     Description                              Required/Optional
! -----------------------------------------------------------------------------
! TBOT     temperature (K)                          Required
! WIND     wind:sqrt(u**2+v**2) (m/s)               Required
! QBOT     specific humidity (kg/kg)                Required
! Tdew     dewpoint temperature (K)                 Alternative to Q
! RH       relative humidity (percent)              Alternative to Q
! ZBOT     reference height (m)                     optional
! PSRF     surface pressure (Pa)                    optional
! FSDS     total incident solar radiation (W/m**2)  Required
! FSDSdir  direct incident solar radiation (W/m**2) optional (replaces FSDS)
! FSDSdif  diffuse incident solar rad (W/m**2)      optional (replaces FSDS)
! FLDS     incident longwave radiation (W/m**2)     optional
! PRECTmms total precipitation (mm H2O / sec)       Required
! PRECCmms convective precipitation (mm H2O / sec)  optional (replaces PRECT)
! PRECLmms large-scale precipitation (mm H2O / sec) optional (replaces PRECT)
!
! LOCAL VARIABLES:
    integer :: i,j,k,g,p,c,l !indices
    integer :: begp, endp   ! per-proc beginning and ending pft indices
    integer :: begc, endc   ! per-proc beginning and ending column indices
    integer :: begl, endl   ! per-proc beginning and ending landunit indices
    integer :: begg, endg   ! per-proc gridcell ending gridcell indices
    type(gridcell_type), pointer :: gptr  ! pointer to gridcell derived subtype
!------------------------------------------------------------------------
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#if (defined DGVM)
! The following vraiables for MM5 and restart run
    real(r8):: t_mo_min(maxpatch)            !annual min of t_mo (Kelvin)
    real(r8):: annpsn(maxpatch)              !annual photosynthesis (umol CO2 /m**2)
    real(r8):: annpsnpot(maxpatch)           !annual potential photosynthesis (same units)
    real(r8):: fmicr(maxpatch)               !microbial respiration (umol CO2 /m**2 /s)
    real(r8):: bm_inc(maxpatch)              !biomass increment
    real(r8):: afmicr(maxpatch)              !microbial respiration (Rh) for each naturally-vegetated pft
    real(r8):: t10min(maxpatch)              !annual minimum of 10-day running mean (K)
    real(r8):: tmomin20(maxpatch)            !20-yr running mean of tmomin
    real(r8):: agdd20(maxpatch)              !20-yr running mean of agdd
    real(r8):: fpcgrid(maxpatch)             !foliar projective cover on gridcell (fraction)
    real(r8):: lai_ind(maxpatch)             !LAI per individual
    real(r8):: crownarea(maxpatch)           !area that each individual tree takes up (m^2)
    real(r8):: dphen(maxpatch)               !phenology [0 to 1]
    real(r8):: leafon(maxpatch)              !leafon days
    real(r8):: leafof(maxpatch)              !leafoff days
    real(r8):: firelength(maxpatch)          !fire season in days
    real(r8):: litterag(maxpatch)            !above ground litter
    real(r8):: litterbg(maxpatch)            !below ground litter
    real(r8):: cpool_fast(maxpatch)          !fast carbon pool
    real(r8):: cpool_slow(maxpatch)          !slow carbon pool
    real(r8):: k_fast_ave(maxpatch)          !decomposition rate
    real(r8):: k_slow_ave(maxpatch)          !decomposition rate
    real(r8):: litter_decom_ave(maxpatch)    !decomposition rate
    real(r8):: nind(maxpatch)                !number of individuals (#/m**2)
    real(r8):: lm_ind(maxpatch)              !individual leaf mass
    real(r8):: sm_ind(maxpatch)              !individual sapwood mass
    real(r8):: hm_ind(maxpatch)              !individual heartwood mass
    real(r8):: rm_ind(maxpatch)              !individual root mass
    logical :: present(maxpatch)             !whether PFT present in patch

    real(r8) :: tda(maxpatch)
    real(r8) :: t10(maxpatch)
    real(r8) :: fnpsn10(maxpatch)
    real(r8) :: prec365(maxpatch)
    real(r8) :: agdd0(maxpatch)
    real(r8) :: agdd5(maxpatch)
    real(r8) :: agddtw(maxpatch)
    real(r8) :: agdd(maxpatch)
#endif

  integer   :: snl(maxpatch)
  real(r8)  :: snowdp(maxpatch)
  real(r8)  :: snowage(maxpatch)
  real(r8)  :: h2osno(maxpatch)
  real(r8)  :: t_grnd(maxpatch)
  real(r8)  :: t_veg(maxpatch)
  real(r8)  :: h2ocan(maxpatch)
  real(r8)  :: h2ocan_col(maxpatch)
  real(r8)  :: wtc(maxpatch)
  real(r8)  :: wtp(maxpatch)
  integer   :: numc,nump
  real(r8)  :: htop(maxpatch)
  real(r8)  :: tsai(maxpatch)

  real(r8)  :: t_lake(maxpatch,nlevlak)
  real(r8)  :: t_soisno(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: h2osoi_liq(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: h2osoi_ice(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: dzclm(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: zclm(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: ziclm(maxpatch,-nlevsno:nlevsoi)
  real(r8)  :: h2osoi_vol(maxpatch,nlevsoi)

  real(r8)  :: t2m_max(maxpatch)
  real(r8)  :: t2m_min(maxpatch)
  real(r8)  :: t2m_max_inst(maxpatch)
  real(r8)  :: t2m_min_inst(maxpatch)
  real(r8)  :: t_ref2m(maxpatch)

  real(r8)  :: znt(maxpatch)
  real(r8)  :: q_ref2m(maxpatch)

  logical doalb     !true if surface albedo calculation time step

  real(r8)  :: albxy,albixy(numrad),albdxy(numrad)
  real(r8)  :: tsxy
  real(r8)  :: shxy
  real(r8)  :: lhxy
  real(r8)  :: lwupxy
  real(r8)  :: qsfxy
  real(r8)  :: qdnxy
  real(r8)  :: soiflx
  real(r8)  :: sabv
  real(r8)  :: sabg
  real(r8)  :: znt0
  real(r8),intent(out)  :: rhoxy

  integer   :: nstp

  real(r8) :: areaxy           !gridcell area (km^2)
  real(r8) :: dt
  real(r8) :: cxday
  real(r8) :: cxday1
  real(r8) :: xlat
  real(r8) :: xlon

  integer  :: iveg
  integer  :: isl
  integer  :: lndmsk
  integer  :: yr
  integer  :: mnth
  integer  :: dy
  integer  :: nsec
  integer  :: yr1
  integer  :: mnp1
  integer  :: dyp1
  integer  :: nsec1
  integer  :: mbdate
  integer  :: inest
  integer  :: ilx,jlx

  !New lake variables
  real(r8), intent(in) :: lakedepthx, dzlakex(1:nlevsoi), zlakex(1:nlevsoi)
  real(r8), intent(inout) :: lake_icefracx(1:nlevsoi), tlakex(1:nlevsoi), savedtke1x

  real(r8)  :: t2m,dsq,dsqmin
  character*1024 :: msg

!------------------------------------------------------------------------
!Debug
       call CLMDebug('Starting clm3.F')
       write(msg, *) 'At i,j,xlat,xlon = ', ilx, ', ', jlx, ', ', xlat, ', ', xlon, '.'
       call CLMDebug(msg)
       msg = ''
       write(msg, *) 't_grnd(1) = ', t_grnd(1), '.' 
       call CLMDebug(msg)
       msg = ''
       write(msg, *) 'atm forcing: T,u,v,z,q,p:', forc_txy,forc_uxy,forc_vxy,zgcmxy,forc_qxy,forc_pbotxy
       call CLMDebug(msg)

! setup the  step, monthn and day
       call clmtype_mod
       call globals_mod
       dtime    = dt
       year     = yr
       month    = mnth
       day      = dy
       secs     = nsec
       calday   = cxday

       yrp1     = yr1
       monp1    = mnp1
       dayp1    = dyp1
       secp1    = nsec1
       caldayp1 = cxday1

       nbdate   = mbdate
       nstep    = nstp
!-------------------------------------------------
      msg=''
      write(msg,*)'dzlakex(1),zlakex(1),t_lake,tlakex = ',dzlakex(1),zlakex(1),t_lake(1,1),tlakex(1)
      call CLMDebug(msg)

      ! For soil under lakes, for new lake code, set soil type equal to bedrock.
      if (isl == 14) isl = 15

      call  initialize(snl    ,snowdp  ,snowage   ,dzclm     ,zclm         &
                  ,ziclm       ,h2osno  ,h2osoi_liq,h2osoi_ice,t_grnd      &
                  ,t_soisno    ,t_lake  ,t_veg     ,h2ocan    ,h2ocan_col  &
                  ,h2osoi_vol  ,xlat    ,xlon      ,areaxy    ,iveg        &
                  ,isl         ,lndmsk  ,t2m_max   ,t2m_min   ,t2m_max_inst&
                  ,t2m_min_inst,t_ref2m                                    &
                  ,lake_icefracx,lakedepthx,dzlakex,zlakex,savedtke1x           &
#if (defined DGVM)
                  ,t_mo_min  ,annpsn    ,annpsnpot                         &
                  ,fmicr       ,bm_inc  ,afmicr    ,t10min    ,tmomin20    &
                  ,agdd20      ,fpcgrid ,lai_ind   ,crownarea ,dphen       &
                  ,leafon      ,leafof  ,firelength,litterag  ,litterbg    &
                  ,cpool_fast  ,cpool_slow         ,k_fast_ave,k_slow_ave  &
                  ,nind        ,lm_ind  ,sm_ind    ,hm_ind    ,rm_ind      &
                  ,present     ,htop    ,tsai      ,tda       ,t10         &
                  ,prec365     ,agdd0   ,agdd5     ,agddtw    ,agdd        &
                  ,litter_decom_ave                                        &
#endif
                                                                          )
    call CLMDebug('Back in clm3')

    ! Determine necessary indices

    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

    ! Set pointers into derived type

       gptr => clm3%g

       do g = begg, endg
          !i = gptr%ixy(g)
          !j = gptr%jxy(g)

          !States

          clm_a2l%forc_t(g) = forc_txy
          clm_a2l%forc_u(g) = forc_uxy
          clm_a2l%forc_v(g) = forc_vxy
          clm_a2l%forc_wind(g) = sqrt(forc_uxy**2 + forc_vxy**2)
          clm_a2l%forc_q(g) = forc_qxy
          clm_a2l%forc_hgt(g) = zgcmxy
          clm_a2l%forc_hgt_u(g) = zgcmxy !observational height of wind [m]
          clm_a2l%forc_hgt_t(g) = zgcmxy !observational height of temp [m]
          clm_a2l%forc_hgt_q(g) = zgcmxy !observational height of humidity [m]
          clm_a2l%forc_pbot(g) = forc_pbotxy
          clm_a2l%forc_psrf(g) = forc_psrfxy
          clm_a2l%forc_th(g)  = clm_a2l%forc_t(g) * (clm_a2l%forc_psrf(g) &
               / clm_a2l%forc_pbot(g))**(rair/cpair)
          clm_a2l%forc_vp(g)  = clm_a2l%forc_q(g) * clm_a2l%forc_pbot(g) &
               / (0.622 + 0.378 * clm_a2l%forc_q(g))
          clm_a2l%forc_rho(g) = (clm_a2l%forc_pbot(g) - 0.378 * clm_a2l%forc_vp(g)) &
               / (rair * clm_a2l%forc_t(g))

          clm_a2l%forc_pco2(g) = pco2 * clm_a2l%forc_pbot(g)
          clm_a2l%forc_po2(g)  = po2 * clm_a2l%forc_pbot(g)


          !Fluxes

          clm_a2l%forc_lwrad(g) = flwdsxy
          clm_a2l%forc_solad(g,1) = forc_solsxy
          clm_a2l%forc_solad(g,2) = forc_sollxy
          clm_a2l%forc_solai(g,1) = forc_solsdxy
          clm_a2l%forc_solai(g,2) = forc_solldxy
          clm_a2l%forc_solar(g) = forc_solsxy + forc_sollxy &
               + forc_solsdxy + forc_solldxy

          ! Snow and Rain
          ! Set upper limit of air temperature for snowfall at 275.65K.
          ! This cut-off was selected based on Fig. 1, Plate 3-1, of Snow
          ! Hydrology (1956).

          if (precxy > 0.) then
             if (clm_a2l%forc_t(g) > (tfrz + tcrit)) then
                clm_a2l%forc_rain(g) = precxy
                clm_a2l%forc_snow(g) = 0.
                clm_a2l%flfall(g) = 1.
             else
                clm_a2l%forc_rain(g) = 0.
                clm_a2l%forc_snow(g) = precxy

                if (clm_a2l%forc_t(g) <= tfrz) then
                   clm_a2l%flfall(g) = 0.
                else if (clm_a2l%forc_t(g) <= tfrz+2.) then
                   clm_a2l%flfall(g) = -54.632 + 0.2 * clm_a2l%forc_t(g)
                else
                   clm_a2l%flfall(g) = 0.4
                endif
             endif
          else
             clm_a2l%forc_rain(g) = 0.
             clm_a2l%forc_snow(g) = 0.
             clm_a2l%flfall(g) = 1.
          endif
          rhoxy = clm_a2l%forc_rho(g) ! here assume that g is always 1

       end do


     ! doalb is true when the next time step is a radiation time step
     ! this allows for the fact that an atmospheric model may not do
     ! the radiative calculations every time step. for example:
     !      nstep dorad doalb
     !        1     F     F
     !        2     F     T
     !        3     T     F

     doalb = .true.

     ! Call land surface model driver
     ! Note that surface fields used by the atmospheric model are zero for
     ! non-land points and must be set by the appropriate surface model

     call CLMDebug('Calling Driver')
     call driver (doalb,ilx,jlx)
!-------------------------------------------------------------------------
     call biophy_to_wrf(snl      ,snowdp  ,snowage      ,dzclm      ,zclm        ,&
                     ziclm       ,h2osno  ,h2osoi_liq   ,h2osoi_ice ,t_grnd      ,&
                     t_soisno    ,t_lake  ,t_veg        ,h2ocan     ,h2ocan_col  ,&
                     h2osoi_vol  ,wtc     ,wtp          ,numc       ,nump        ,&
                     htop        ,tsai    ,t2m_max      ,t2m_min    ,t2m_max_inst,&
                     t2m_min_inst,t_ref2m ,znt          ,q_ref2m)
#if (defined DGVM)
     call biochem_to_wrf(t_mo_min ,annpsn     ,annpsnpot  ,fmicr     ,&
                       bm_inc     ,afmicr     ,t10min     ,tmomin20  ,&
                       agdd20     ,fpcgrid    ,lai_ind    ,crownarea ,&
                       dphen      ,leafon     ,leafof     ,firelength,&
                       litterag   ,litterbg   ,cpool_fast ,cpool_slow,&
                       k_fast_ave ,k_slow_ave ,nind       ,lm_ind    ,&
                       sm_ind     ,hm_ind     ,rm_ind     ,present   ,&
                       litter_decom_ave)
#endif


    do j = 1,numrad
       albdxy(j) = 0.0
       albixy(j) = 0.0
       do p = begp,endp
          albdxy(j) = albdxy(j) + clm3%g%l%c%p%pps%albd(p,j)*wtp(p)
          albixy(j) = albixy(j) + clm3%g%l%c%p%pps%albi(p,j)*wtp(p)
       end do
    end do
    albxy = 0.35*sum(albixy) + 0.15*sum(albdxy)

!Debug
    msg = ''
    write(msg,*) 'Calculated albedo is ', albxy, '.'
    call CLMDebug(msg)

    lwupxy= 0._r8
    shxy  = 0._r8
    lhxy  = 0._r8
    soiflx= 0._r8
    sabv  = 0._r8
    sabg  = 0._r8
    tsxy  = 0._r8
    znt0  = 0._r8
    do p = begp,endp 
       lwupxy= lwupxy+ clm3%g%l%c%p%pef%eflx_lwrad_out(p)*wtp(p)
       shxy  = shxy  + clm3%g%l%c%p%pef%eflx_sh_tot(p)*wtp(p)
       lhxy  = lhxy  + clm3%g%l%c%p%pef%eflx_lh_tot(p)*wtp(p)
       soiflx= soiflx+ clm3%g%l%c%p%pef%eflx_soil_grnd(p)*wtp(p) ! [+ into soil]
       sabv  = sabv  + clm3%g%l%c%p%pef%sabv(p)*wtp(p)
       sabg  = sabg  + clm3%g%l%c%p%pef%sabg(p)*wtp(p)
       tsxy  = tsxy  + clm3%g%l%c%p%pes%t_veg(p)*wtp(p) 
       !over lakes and bare soils, t_veg = t_grnd
       znt0  = znt0 + znt(p)*wtp(p)
    end do

!Debug
    msg = ''
    write(msg,*) 'LWUP is', lwupxy, '.'
    call CLMDebug(msg)

!    qsfxy  = 0._r8
!    qdnxy  = 0._r8
!Making these variables cumulative: Zack Subin, 7/24/08
    do c = begc,endc
       qsfxy = qsfxy + clm3%g%l%c%cwf%qflx_surf(c)*wtc(c)*dtime
       qdnxy = qdnxy + clm3%g%l%c%cwf%qflx_drain(c)*wtc(c)*dtime
    end do

    !For new "Shallow" Lake Code, Zack Subin, 8/3/09 [This will only work because
    !WRF is calling CLM one gridcell at a time and there is only one lake per gridcell.]
    do k = 1,nlevsoi !levsoi=levlak
       do c=begc,endc
          l=clm3%g%l%c%landunit(c)
          if (clm3%g%l%lakpoi(l) ) then
             lake_icefracx(k) = clm3%g%l%c%cws%lake_icefrac(c,k)
             tlakex(k) = clm3%g%l%c%ces%t_lake(c,k)
             if (k==1) then
                savedtke1x = clm3%g%l%c%cps%savedtke1(c)
                !Debug
                msg = ''
                write(msg,*)'lake at point, icefrac(1),tlakex(1),savedtke1x=', lake_icefracx(1), &
                            tlakex(1),savedtke1x
                call CLMDebug(msg)
             end if
          end if
       end do
    end do

!       dsqmin= 8.0*8.0/(6378.136*0.0174533)**2
!       dsq = ((xlat-38.933)**2 + (xlon-239.95)**2)&
!             *cos(xlat*0.0174533)**2
!
!       t2m = 0.0
!       do p = begp,endp
!         t2m = t2m + t_ref2m(p)*wtp(p)
!       end do
!
!       if(dsq < dsqmin) then
!        write(888,*)ilx,jlx,yr,mnth,dy,nsec,clm_a2l%forc_rain(1),clm_a2l%forc_snow(1),&
!        clm_a2l%forc_t(1),t2m,tsxy,xlat,xlon,iveg,isl,inest,nstep
!       end if
!-------------------------------------------------------------------------
    call clmtype_dealloc()
!-------------------------------------------------------------------------

     return

  end subroutine clm

