



module decompMod






  use shr_kind_mod, only : r8 => shr_kind_r8
  use clm_varpar  , only : lsmlon, lsmlat, maxpatch, maxpatch_pft, &
                           npatch_crop, npatch_urban, npatch_glacier
  use clm_varsur  , only : numlon, landmask

  implicit none

  integer, public :: ncells
  integer, public :: nlunits
  integer, public :: ncols
  integer, public :: npfts

  public initDecomp              
                                 
  public get_gcell_info          
                                 
  public get_gcell_xyind         

  public get_proc_bounds         
                                 

  save 

  private

  type gcell_decomp
     integer :: gsn     
     integer :: ixy     
     integer :: jxy     
     integer :: li      
     integer :: lf      
     integer :: ci      
     integer :: cf      
     integer :: pi      
     integer :: pf      
  end type gcell_decomp
  type(gcell_decomp), allocatable :: gcelldc(:)

contains






  subroutine initDecomp(wtxy)






    use clmtype


    implicit none
    real(r8), intent(in) :: wtxy(lsmlon, lsmlat, maxpatch) 
                                                           


    integer :: ppc                    
    integer :: lpc                    
    integer :: ppclump                
    integer :: i,j,cid,pid            
    integer :: gi,li,ci,pi            
    integer :: gf,lf,cf,pf            
    integer :: g,l,c,p,n,m            
    integer :: gdc,gsn                
    integer :: nzero                  




    integer :: nveg                   
    integer :: numg                   
                                      
    integer :: numl                   
                                      
    integer :: numc                   
                                      
    integer :: nump                   
                                      
    logical :: error = .false.        
    integer :: ilunits, icols, ipfts  
    integer :: ng                     
    integer :: nl                     
    integer :: nc                     
    integer :: np                     
    integer :: ier                    










    

    ncells = 0
    nlunits = 0
    ncols = 0
    npfts = 0
    do j = 1, lsmlat
       do i = 1, numlon(j)
          if (landmask(i,j) == 1) then
             call get_gcell_info (i, j, wtxy, nlunits=ilunits, ncols=icols, npfts=ipfts)
             ncells  = ncells  + 1
             nlunits = nlunits + ilunits
             ncols   = ncols   + icols
             npfts   = npfts   + ipfts
          end if
       end do
    end do

  end subroutine initDecomp






   subroutine get_gcell_info (i, j, wtxy, nlunits, ncols, npfts, &
                              nveg, wtveg, ncrop, wtcrop)





     implicit none
     integer , intent(in)  :: i                  
     integer , intent(in)  :: j                  
     real(r8), intent(in)  :: wtxy(lsmlon, lsmlat, maxpatch) 
                                                             
     integer , optional, intent(out) :: nlunits  
     integer , optional, intent(out) :: ncols    
     integer , optional, intent(out) :: npfts    
     integer , optional, intent(out) :: nveg     
                                                 
                                                 
     real(r8), optional, intent(out) :: wtveg    
                                                 
                                                 
     integer , optional, intent(out) :: ncrop    
                                                 
     real(r8), optional, intent(out) :: wtcrop   
                                                 










     integer  :: m       
     integer  :: nvegl   
     real(r8) :: wtvegl  
     integer  :: nvegc   
     real(r8) :: wtvegc  
     integer  :: ilunits 
     integer  :: icols   
     integer  :: ipfts   


     

     ipfts   = 0
     icols   = 0
     ilunits = 0

     

     do m = 1,maxpatch
        if (wtxy(i,j,m) > 0.0) ipfts = ipfts + 1
     end do

     

     nvegl = 0
     wtvegl = 0.0
     do m = 1, maxpatch_pft
        if (wtxy(i,j,m) > 0.0) then
           nvegl = nvegl + 1
           wtvegl = wtvegl + wtxy(i,j,m)
        end if
     end do
     if (nvegl > 0) ilunits = ilunits + 1



     if (nvegl > 0) icols = icols + 1     


     

     do m = npatch_urban, npatch_glacier
        if (wtxy(i,j,m) > 0.0) ilunits = ilunits + 1
        if (wtxy(i,j,m) > 0.0) icols = icols + 1
     end do

     

     nvegc = 0
     wtvegc = 0.0

        do m = npatch_glacier+1, npatch_crop
           if (wtxy(i,j,m) > 0.0) then
              nvegc = nvegc + 1
              wtvegc = wtvegc + wtxy(i,j,m)
           end if
        end do
        if (nvegc > 0) ilunits = ilunits + 1
        if (nvegc > 0) icols = icols + nvegc

     if (present(nlunits)) nlunits = ilunits
     if (present(ncols))   ncols   = icols
     if (present(npfts))   npfts   = ipfts
     if (present(nveg))    nveg    = nvegl
     if (present(wtveg))   wtveg   = wtvegl
     if (present(ncrop))   ncrop   = nvegc
     if (present(wtcrop))  wtcrop  = wtvegc

 end subroutine get_gcell_info







   subroutine get_proc_bounds (begg, endg, begl, endl, begc, endc, &
                               begp, endp)


     implicit none
     integer, intent(out) :: begp, endp  
                                         
     integer, intent(out) :: begc, endc  
                                         
     integer, intent(out) :: begl, endl  
                                         
     integer, intent(out) :: begg, endg  
                                         









     begp = 1
     endp = npfts
     begc = 1
     endc = ncols
     begl = 1
     endl = nlunits
     begg = 1
     endg = 1

   end subroutine get_proc_bounds







   subroutine get_gcell_xyind(lbg, ubg, ixy, jxy)





     implicit none
     integer, intent(in) :: lbg
     integer, intent(in) :: ubg
     integer, pointer    :: ixy(:)
     integer, pointer    :: jxy(:)







     integer :: g     
     integer :: i, j
     integer :: ier                    




    allocate(gcelldc(ncells), stat=ier)
    g = 0
    do j = 1, lsmlat
       do i = 1, numlon(j)
          g = g + 1
          gcelldc(g)%ixy = i
          gcelldc(g)%jxy = j
       end do
    end do
    do g = lbg,ubg
        ixy(g) = gcelldc(g)%ixy
        jxy(g) = gcelldc(g)%jxy
    end do
    deallocate(gcelldc)

   end subroutine get_gcell_xyind

end module decompMod
