











subroutine iniTimeConst(zclm,dzclm,ziclm,lakedepth_in,dzlake,zlake)









  use shr_kind_mod, only: r8 => shr_kind_r8
  use nanMod
  use clmtype
  use decompMod , only : get_proc_bounds
  use clm_varpar, only : nlevsoi, nlevlak, nlevsno,lsmlon, lsmlat, numpft
  use clm_varsur, only : soic2d, sand3d, clay3d
  use clm_varcon, only : istice, istdlak, istwet, isturb, &
                         zlak, dzlak, zsoi, dzsoi, zisoi, spval, &





                         albsat, albdry, &

                         maxwattabfract

  use pftvarcon , only : ncorn, nwheat, noveg, ntree, roota_par, rootb_par,  &
                         z0mr, displar, dleaf, rhol, rhos, taul, taus, xl, &
                         qe25, vcmx25, mp, c3psn, &
                         pftpar , tree   , summergreen, raingreen  , sla     , &
                         lm_sapl, sm_sapl, hm_sapl    , rm_sapl    , latosa  , &
                         allom1 , allom2 , allom3     , reinickerp , wooddens, &

                         smpso, smpsc,&
                         fnitr, &
                         slatop, dsladlai &
                         ,leafcn, flnr


  implicit none








  real(r8)  :: dzclm(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: zclm(maxpatch,-nlevsno+1:nlevsoi)
  real(r8)  :: ziclm(maxpatch,-nlevsno:nlevsoi)
  real(r8), intent(in) :: lakedepth_in, dzlake(1:nlevsoi), zlake(1:nlevsoi)






  integer , pointer :: ivt(:)             
  integer , pointer :: ixy(:)             
  integer , pointer :: jxy(:)             
  integer , pointer :: pcolumn(:)         
  integer , pointer :: clandunit(:)       
  integer , pointer :: ltype(:)           



  real(r8), pointer :: z(:,:)             
  real(r8), pointer :: zi(:,:)            
  real(r8), pointer :: dz(:,:)            
  real(r8), pointer :: rootfr(:,:)        
  real(r8), pointer :: dewmx(:)           
  real(r8), pointer :: bsw(:,:)           
  real(r8), pointer :: watsat(:,:)        
  real(r8), pointer :: hksat(:,:)         
  real(r8), pointer :: sucsat(:,:)        
  real(r8), pointer :: csol(:,:)          
  real(r8), pointer :: tkmg(:,:)          
  real(r8), pointer :: tkdry(:,:)         
  real(r8), pointer :: tksatu(:,:)        
  real(r8), pointer :: wtfact(:)          
  real(r8), pointer :: smpmin(:)          
  integer , pointer :: isoicol(:)         
  real(r8), pointer :: gwc_thr(:)         
  real(r8), pointer :: mss_frc_cly_vld(:) 

  real(r8), pointer :: rresis(:,:)        
  real(r8), pointer :: bsw2(:,:)          
  real(r8), pointer :: psisat(:,:)        
  real(r8), pointer :: vwcsat(:,:)        
  real(r8), pointer :: watdry(:,:)        
  real(r8), pointer :: watopt(:,:)        
  real(r8), pointer :: hkdepth(:)         
  real(r8), pointer :: forc_ndep(:)       

  real(r8), pointer :: lakedepth(:)       
  real(r8), pointer :: dz_lake(:,:)       
  real(r8), pointer :: z_lake(:,:)        








  integer :: i,j,ib,lev       
  integer :: g,l,c,p          
  integer :: m                
  real(r8):: bd               
  real(r8):: tkm              
  real(r8):: xksat            
  real(r8):: scalez = 0.025   

  real(r8):: clay,sand        
  integer :: begp, endp       
  integer :: begc, endc       
  integer :: begl, endl       
  integer :: begg, endg       

  real(r8) :: slope,intercept        
  real(r8),pointer :: arrayl(:)   
  integer ,pointer :: irrayg(:)   
  character*256 :: msg






  



  

  ltype           => clm3%g%l%itype

  

  ixy             => clm3%g%l%c%ixy
  jxy             => clm3%g%l%c%jxy
  clandunit       => clm3%g%l%c%landunit
  z               => clm3%g%l%c%cps%z
  dz              => clm3%g%l%c%cps%dz
  zi              => clm3%g%l%c%cps%zi
  bsw             => clm3%g%l%c%cps%bsw
  watsat          => clm3%g%l%c%cps%watsat
  hksat           => clm3%g%l%c%cps%hksat
  sucsat          => clm3%g%l%c%cps%sucsat
  tkmg            => clm3%g%l%c%cps%tkmg
  tksatu          => clm3%g%l%c%cps%tksatu
  tkdry           => clm3%g%l%c%cps%tkdry
  csol            => clm3%g%l%c%cps%csol
  smpmin          => clm3%g%l%c%cps%smpmin
  isoicol         => clm3%g%l%c%cps%isoicol
  gwc_thr         => clm3%g%l%c%cps%gwc_thr
  mss_frc_cly_vld => clm3%g%l%c%cps%mss_frc_cly_vld

  bsw2            => clm3%g%l%c%cps%bsw2
  psisat          => clm3%g%l%c%cps%psisat
  vwcsat          => clm3%g%l%c%cps%vwcsat
  watdry          => clm3%g%l%c%cps%watdry  
  watopt          => clm3%g%l%c%cps%watopt  
  forc_ndep       => clm_a2l%forc_ndep


  wtfact          => clm3%g%l%c%cps%wtfact

  hkdepth         => clm3%g%l%c%cps%hkdepth

  dz_lake         => clm3%g%l%c%cps%dz_lake
  z_lake          => clm3%g%l%c%cps%z_lake
  lakedepth       => clm3%g%l%c%cps%lakedepth

  

  ivt             => clm3%g%l%c%p%itype
  pcolumn         => clm3%g%l%c%p%column
  dewmx           => clm3%g%l%c%p%pps%dewmx
  rootfr          => clm3%g%l%c%p%pps%rootfr


  rresis          => clm3%g%l%c%p%pps%rresis


  

  call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

  
  
  
  



   do m = 0,numpft
      pftcon%ncorn(m) = ncorn
      pftcon%nwheat(m) = nwheat
      pftcon%noveg(m) = noveg
      pftcon%ntree(m) = ntree
      pftcon%z0mr(m) = z0mr(m)
      pftcon%displar(m) = displar(m)
      pftcon%dleaf(m) = dleaf(m)
      pftcon%xl(m) = xl(m)
      do ib = 1,numrad
         pftcon%rhol(m,ib) = rhol(m,ib)
         pftcon%rhos(m,ib) = rhos(m,ib)
         pftcon%taul(m,ib) = taul(m,ib)
         pftcon%taus(m,ib) = taus(m,ib)
      end do
      pftcon%qe25(m) = qe25(m)
      pftcon%vcmx25(m) = vcmx25(m)
      pftcon%mp(m) = mp(m)
      pftcon%c3psn(m) = c3psn(m)
      pftcon%sla(m) = sla(m)

      pftcon%smpso(m) = smpso(m)
      pftcon%smpsc(m) = smpsc(m)
      pftcon%fnitr(m) = fnitr(m)
      pftcon%slatop(m) = slatop(m)
      pftcon%dsladlai(m) = dsladlai(m)
      pftcon%leafcn(m) = leafcn(m)
      pftcon%flnr(m) = flnr(m)

   end do



   do m = 0,numpft
      dgv_pftcon%respcoeff(m) = pftpar(m,5)
      dgv_pftcon%flam(m) = pftpar(m,6)
      dgv_pftcon%resist(m) = pftpar(m,8)
      dgv_pftcon%l_turn(m) = pftpar(m,9)
      dgv_pftcon%l_long(m) = pftpar(m,10)
      dgv_pftcon%s_turn(m) = pftpar(m,11)
      dgv_pftcon%r_turn(m) = pftpar(m,12)
      dgv_pftcon%l_cton(m) = pftpar(m,13)
      dgv_pftcon%s_cton(m) = pftpar(m,14)
      dgv_pftcon%r_cton(m) = pftpar(m,15)
      dgv_pftcon%l_morph(m) = pftpar(m,16)
      dgv_pftcon%l_phen(m) = pftpar(m,17)
      dgv_pftcon%lmtorm(m) = pftpar(m,18)
      dgv_pftcon%crownarea_max(m) = pftpar(m,20)
      dgv_pftcon%init_lai(m) = pftpar(m,21)
      dgv_pftcon%x(m) = pftpar(m,22)
      dgv_pftcon%tcmin(m) = pftpar(m,28)
      dgv_pftcon%tcmax(m) = pftpar(m,29)
      dgv_pftcon%gddmin(m) = pftpar(m,30)
      dgv_pftcon%twmax(m) = pftpar(m,31)
      dgv_pftcon%lm_sapl(m) = lm_sapl(m)
      dgv_pftcon%sm_sapl(m) = sm_sapl(m)
      dgv_pftcon%hm_sapl(m) = hm_sapl(m)
      dgv_pftcon%rm_sapl(m) = rm_sapl(m)
      dgv_pftcon%tree(m) = tree(m)
      dgv_pftcon%summergreen(m) = summergreen(m)
      dgv_pftcon%raingreen(m) = raingreen(m)
      dgv_pftcon%reinickerp(m) = reinickerp
      dgv_pftcon%wooddens(m) = wooddens
      dgv_pftcon%latosa(m) = latosa
      dgv_pftcon%allom1(m) = allom1
      dgv_pftcon%allom2(m) = allom2
      dgv_pftcon%allom3(m) = allom3

   end do

   
   
   
   

   

   if (nlevlak /= nlevsoi) then
      write(6,*)&
'number of soil levels and number of lake levels must be the same'
      write(6,*) 'nlevsoi= ', nlevsoi ,&
      'nlevlak= ',nlevlak
      call endrun
   endif

   
   
   
   

   
   do g = begg, endg

      


      
      


   end do

   


   do c = begc, endc

      
      i = ixy(c)
      j = jxy(c)
      l = clandunit(c)

      
      smpmin(c) = -1.e8

      
      isoicol(c) = soic2d(i,j)


     
      hkdepth(c) = 1._r8/2.5_r8

      


      if (ltype(l)==istdlak .or. ltype(l)==istwet .or. ltype(l)==istice) then
         wtfact(c) = 1.0
      else
         wtfact(c) = maxwattabfract
      end if


      

       if (ltype(l)==istwet .or. &
          ltype(l)==istice .or. ltype(l)==isturb ) then
         do lev = 1,nlevsoi
            bsw(c,lev) = spval
            watsat(c,lev) = spval
            hksat(c,lev) = spval
            sucsat(c,lev) = spval
            tkmg(c,lev) = spval
            tksatu(c,lev) = spval
            tkdry(c,lev) = spval
            csol(c,lev) = spval

            bsw2(c,lev) = spval
            psisat(c,lev) = spval
            vwcsat(c,lev) = spval
            watdry(c,lev) = spval 
            watopt(c,lev) = spval 

         end do
      else
         do lev = 1,nlevsoi
            clay = clay3d(i,j,lev)
            sand = sand3d(i,j,lev)

            watsat(c,lev) = 0.489 - 0.00126*sand
            bd = (1.-watsat(c,lev))*2.7e3
            xksat = 0.0070556 *( 10.**(-0.884+0.0153*sand) ) 
            tkm = (8.80*sand+2.92*clay)/(sand+clay)          

            bsw(c,lev) = 2.91 + 0.159*clay

            bsw2(c,lev) = -(3.10_r8 + 0.157_r8*clay - 0.003_r8*sand)
            psisat(c,lev) = -(exp((1.54 - 0.0095*sand + 0.0063*100.0)* &
               log(10.0_r8))*9.8e-5_r8)
            vwcsat(c,lev) = (50.5_r8 - 0.142_r8*sand - 0.037_r8*clay)/100.0_r8
            watdry(c,lev) = watsat(c,lev) * (316230._r8/sucsat(c,lev)) &
                ** (-1._r8/bsw(c,lev)) 
            watopt(c,lev) = watsat(c,lev) * (158490._r8/sucsat(c,lev)) &
                ** (-1._r8/bsw(c,lev)) 


            hksat(c,lev) = xksat * exp(-zisoi(lev)/hkdepth(c))
            sucsat(c,lev) = 10. * ( 10.**(1.88-0.0131*sand) )
            tkmg(c,lev) = tkm ** (1.- watsat(c,lev))
            tksatu(c,lev) = tkmg(c,lev)*0.57**watsat(c,lev)
            tkdry(c,lev) = (0.135*bd + 64.7) / (2.7e3 - 0.947*bd)
            csol(c,lev) = (2.128*sand+2.385*clay) / (sand+clay)*1.e6  
         end do
      endif

      
      if (ltype(l) == istdlak) then
         z_lake(c,1:nlevlak) = zlake(1:nlevlak)
         dz_lake(c,1:nlevlak) = dzlake(1:nlevlak)
         lakedepth(c)        = lakedepth_in
         call CLMDebug('Initializing lake depths to')
         do lev=1,nlevlak
            write(msg,*)'z,dz = ', z_lake(c,lev), dz_lake(c,lev)
            call CLMDebug(msg)
         end do
      end if
      
      z(c,1:nlevsoi) = zclm(c,1:nlevsoi)
      zi(c,0:nlevsoi) = ziclm(c,0:nlevsoi)
      dz(c,1:nlevsoi) = dzclm(c,1:nlevsoi)

      
      clay = clay3d(i,j,1)
      gwc_thr(c) = 0.17 + 0.14*clay*0.01
      mss_frc_cly_vld(c) = min(clay*0.01_r8, 0.20_r8)

   end do

   


   do p = begp, endp

      

      dewmx(p)  = 0.1

      
      
      
      

      c = pcolumn(p)
      if (ivt(p) /= noveg) then
         do lev = 1, nlevsoi-1
            rootfr(p,lev) = .5*( exp(-roota_par(ivt(p)) * zi(c,lev-1))  &
                               + exp(-rootb_par(ivt(p)) * zi(c,lev-1))  &
                               - exp(-roota_par(ivt(p)) * zi(c,lev  ))  &
                               - exp(-rootb_par(ivt(p)) * zi(c,lev  )) )
         end do
         rootfr(p,nlevsoi) = .5*( exp(-roota_par(ivt(p)) * zi(c,nlevsoi-1))  &
                                + exp(-rootb_par(ivt(p)) * zi(c,nlevsoi-1)) )



      else

         rootfr(p,1:nlevsoi) = 0.
      endif


      
      do lev = 1,nlevsoi
         rresis(p,lev) = 0._r8
      end do


   end do 




end subroutine iniTimeConst
