



module initializeMod










  implicit none
  save


  public :: initialize









contains







  subroutine initialize(snl    ,snowdp  ,snowage   ,dzclm     ,zclm        &
                  ,ziclm       ,h2osno  ,h2osoi_liq,h2osoi_ice,t_grnd      &
                  ,t_soisno    ,t_lake  ,t_veg     ,h2ocan    ,h2ocan_col  &
                  ,h2osoi_vol  ,xlat    ,xlon      ,areaxy    ,iveg        &
                  ,isl         ,lndmsk  ,t2m_max   ,t2m_min   ,t2m_max_inst&
                  ,t2m_min_inst,t_ref2m                                    &

                  ,lake_icefrac,lakedepth,dzlake,zlake,savedtke1     &
                                                                           )
















    use shr_kind_mod    , only : r8 => shr_kind_r8
    use clmtypeInitMod  , only : initClmtype
    use initGridCellsMod, only : initGridCells
    use clm_varpar      , only : lsmlon, lsmlat, maxpatch,nlevsoi,nlevsno,&
                                 nlevlak
    use clm_varsur      , only : varsur_alloc, varsur_dealloc,longxy,latixy,&
                                 area
    use filterMod       , only : initFilters
    use decompMod       , only : initDecomp
    use accFldsMod      , only : initAccFlds, initAccClmtype
    use surfFileMod     , only : surfrd
    use pftvarcon       , only : pftconrd
    use clm_varcon      , only : var_par


    use STATICEcosysDynMod , only : EcosystemDynini



    implicit none







    integer  :: i,j,k                 
    integer  :: yr                    
    integer  :: mon                   
    integer  :: day                   
    integer  :: ncsec                 
    logical  :: readini               
    integer  :: vegxy(lsmlon,lsmlat,maxpatch) 
    real(r8) :: wtxy(lsmlon,lsmlat,maxpatch)  
    integer  :: ier

    integer   :: snl(maxpatch)
    real(r8)  :: snowdp(maxpatch)
    real(r8)  :: snowage(maxpatch)
    real(r8)  :: h2osno(maxpatch)
    real(r8)  :: t_grnd(maxpatch)
    real(r8)  :: t_veg(maxpatch)
    real(r8)  :: h2ocan(maxpatch)
    real(r8)  :: h2ocan_col(maxpatch)

    real(r8)  :: t_lake(maxpatch,nlevlak)
    real(r8)  :: t_soisno(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: h2osoi_liq(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: h2osoi_ice(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: dzclm(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: zclm(maxpatch,-nlevsno+1:nlevsoi)
    real(r8)  :: ziclm(maxpatch,-nlevsno:nlevsoi)
    real(r8)  :: h2osoi_vol(maxpatch,nlevsoi)

    real(r8)  :: xlon
    real(r8)  :: xlat
    real(r8)  :: areaxy

    integer   :: iveg
    integer   :: isl
    integer   :: lndmsk




    real(r8) :: t2m_max(maxpatch)
    real(r8) :: t2m_min(maxpatch)
    real(r8) :: t2m_max_inst(maxpatch)
    real(r8) :: t2m_min_inst(maxpatch)
    real(r8) :: t_ref2m(maxpatch)

    
    real(r8), intent(in) :: lakedepth, savedtke1, dzlake(1:nlevsoi), zlake(1:nlevsoi)
    real(r8), intent(in) :: lake_icefrac(1:nlevsoi)

    call CLMDebug('Now in Initialize. Next call varsur_alloc.')


    do i=1,lsmlon
       do j=1,lsmlat
           longxy(i,j) = xlon
           latixy(i,j) = xlat
           area(i,j)   = areaxy
       end do
    end do


    

     call varsur_alloc ()

     
     

     call CLMDebug('pftconrd')
     call pftconrd ()

     
     
     
     
     
     

     call var_par

     call CLMDebug('surfrd')
     call surfrd (vegxy, wtxy, iveg, isl, lndmsk)

    

    call initDecomp(wtxy)


    

    call initClmtype()

    

    call CLMDebug('initGridCells')
    call initGridCells(vegxy, wtxy)

    

    call initFilters()

     

 call CLMDebug('EcosystemDynini')
 call EcosystemDynini()

    

    call CLMDebug('iniTimeConst')
    call iniTimeConst (zclm,dzclm,ziclm,lakedepth,dzlake,zlake)


    
    call CLMDebug('initAccFlds')
    call  initAccFlds(t_ref2m) 


    
    
    
    

    call CLMDebug('initAccClmtype') 
    call initAccClmtype(t2m_max,t2m_min,t2m_max_inst,t2m_min_inst)

    call CLMDebug('iniTimeVar')
    call iniTimeVar(snl      ,snowdp  ,snowage   ,dzclm     ,zclm      ,&
                   ziclm     ,h2osno  ,h2osoi_liq,h2osoi_ice,t_grnd    ,&
                   t_soisno  ,t_lake  ,t_veg     ,h2ocan    ,h2ocan_col,&
                   h2osoi_vol, lake_icefrac, savedtke1)

    

    call CLMDebug('entering varsurdealloc')
    call varsur_dealloc()
    call CLMDebug('done varsurdealloc')
    

  end subroutine initialize

end module initializeMod
