



MODULE module_sf_clm



  use shr_kind_mod, only: r8 => shr_kind_r8
  use clm_varpar, only: clm_varpar_mod, nlevsoi,nlevlak,nlevsno,maxpatch_pft
  use clm_varcon, only: hvap, hsub,tfrz, vkc, sb,tkwat

CONTAINS

    subroutine clmi(zgcmxy     ,forc_qxy   ,ps          ,forc_txy    ,tsxy      &
                   ,shxy       ,qfx        ,lhxy        ,soiflx      ,qgh       &
                   ,gsw        ,flwdsxy    ,smstav      ,smstot      ,qsfxy     &
                   ,qdnxy      ,ivgtyp     ,isltyp      ,vegfra      ,albxy     &
                   ,znt        ,z0         ,tmn         ,xland       ,xice      &
                   ,emiss      ,snowc      ,qsfc        ,prec        ,maxpatch  &
                   ,num_soil_layers        ,dt          ,dzs         ,nstep     &
                   ,smois      ,tslb       ,snow        ,canwat      ,chs       &
                   ,chs2                                                        &
                   ,sh2o       ,snowh      ,forc_uxy    ,forc_vxy    ,shdmin    &
                   ,shdmax     ,acsnom     ,acsnow      ,dx          ,xlat      &
                   ,xlong,ht                                                    &   
                   ,ids,ide, jds,jde, kds,kde                    &
                   ,ims,ime, jms,jme, kms,kme                    &
                   ,its,ite, jts,jte, kts,kte                    &
                   ,ucmcall,inest                                &

                ,tr_urb2d,tb_urb2d,tg_urb2d,tc_urb2d,qc_urb2d,  & 
                uc_urb2d,                                       & 
                xxxr_urb2d,xxxb_urb2d,xxxg_urb2d,xxxc_urb2d,    & 
                trl_urb3d,tbl_urb3d,tgl_urb3d,                  & 
                sh_urb2d,lh_urb2d,g_urb2d,rn_urb2d,ts_urb2d,    & 
                psim_urb2d,psih_urb2d,u10_urb2d,v10_urb2d,      & 
                GZ1OZ0_urb2d, AKMS_URB2D,                       & 
                th2_urb2d,q2_urb2d,ust_urb2d,                   & 
                declin_urb,cosz_urb2d,omg_urb2d,                & 
                xlat_urb2d,                                     & 
                num_roof_layers, num_wall_layers,               & 
                num_road_layers, DZR, DZB, DZG,                 & 
                FRC_URB2D, UTYPE_URB2D                          & 

               ,numc,nump,sabv,sabg,lwup,snl, &
                snowdp,snowage,wtc,wtp,h2osno,t_grnd,t_veg,         &
                h2ocan,h2ocan_col,t2m_max,t2m_min,t2m_max_inst,     &
                t2m_min_inst,t_ref2m,dzsnow1,dzsnow2,               &
                dzsnow3,dzsnow4,dzsnow5,h2osoi_liq_s1,              &
                h2osoi_liq_s2,h2osoi_liq_s3,h2osoi_liq_s4,          &
                h2osoi_liq_s5,h2osoi_liq1,h2osoi_liq2,              &
                h2osoi_liq3,h2osoi_liq4,h2osoi_liq5,h2osoi_liq6,    &
                h2osoi_liq7,h2osoi_liq8,h2osoi_liq9,h2osoi_liq10,   &
                h2osoi_ice_s1,h2osoi_ice_s2,                        &
                h2osoi_ice_s3,h2osoi_ice_s4,h2osoi_ice_s5,          &
                h2osoi_ice1,h2osoi_ice2,h2osoi_ice3,h2osoi_ice4,    &
                h2osoi_ice5,h2osoi_ice6,h2osoi_ice7,                &
                h2osoi_ice8,h2osoi_ice9,h2osoi_ice10,               &
                t_soisno_s1,t_soisno_s2,t_soisno_s3,t_soisno_s4,    &
                t_soisno_s5,t_soisno1,t_soisno2,t_soisno3,          &
                t_soisno4,t_soisno5,t_soisno6,t_soisno7,            &
                t_soisno8,t_soisno9,t_soisno10,                     &
                t_lake1,t_lake2,t_lake3,t_lake4,t_lake5,            &
                t_lake6,t_lake7,t_lake8,t_lake9,t_lake10,           &
                h2osoi_vol1,h2osoi_vol2,h2osoi_vol3,                &
                h2osoi_vol4,h2osoi_vol5,h2osoi_vol6,                &
                h2osoi_vol7,h2osoi_vol8,                            &
                h2osoi_vol9,h2osoi_vol10,                           &
                q_ref2m                                             &

                ,doclmlake,lakeminalt,lake_icefrac,lakedepth,        &
                 dzlake,zlake,tlake,savedtke1                        &
                 )


  USE module_date_time

  USE module_sf_v3urban   
  USE module_configure

  implicit none

  integer,  intent(in)       ::     ids,ide, jds,jde, kds,kde,  &
                                    ims,ime, jms,jme, kms,kme,  &
                                    its,ite, jts,jte, kts,kte

  integer,intent(in)  :: num_soil_layers,maxpatch,nstep,ucmcall
  real,dimension(ims:ime,1:num_soil_layers,jms:jme ),intent(inout) ::&
                                                         smois, & 
                                                         sh2o,  & 
                                                         tslb     

  real,intent(in) :: dt,dx
  real(r8) :: dtt
  real, dimension(1:num_soil_layers), intent(in)::dzs



  real,dimension(ims:ime,jms:jme ),intent(inout) ::&
                    smstav     ,smstot                &
                   ,znt        ,snowc      ,qsfc       ,snow        ,snowh &
                   ,canwat     ,acsnom     ,acsnow,   emiss, z0, tmn

  real,dimension(ims:ime,jms:jme ),intent(in) ::&
                 vegfra,shdmin,shdmax

  real,dimension(ims:ime,jms:jme ),intent(in) ::&
                   qgh,chs,chs2

  integer,   dimension(ims:ime,jms:jme ),intent(inout) :: numc,nump
  real,  dimension(ims:ime,jms:jme ),intent(inout) :: soiflx,sabv,sabg,lwup
  integer,   dimension(ims:ime,1:maxpatch,jms:jme ),intent(inout) :: snl
  real,  dimension(ims:ime,1:maxpatch,jms:jme ),intent(inout) ::  &
                snowdp,snowage,wtc,wtp,h2osno,t_grnd,t_veg,         &
                h2ocan,h2ocan_col,t2m_max,t2m_min,t2m_max_inst,     &
                t2m_min_inst,t_ref2m,dzsnow1,dzsnow2,               &
                dzsnow3,dzsnow4,dzsnow5,h2osoi_liq_s1,              &
                h2osoi_liq_s2,h2osoi_liq_s3,h2osoi_liq_s4,          &
                h2osoi_liq_s5,h2osoi_liq1,h2osoi_liq2,              &
                h2osoi_liq3,h2osoi_liq4,h2osoi_liq5,h2osoi_liq6,    &
                h2osoi_liq7,h2osoi_liq8,h2osoi_liq9,h2osoi_liq10,   &
                h2osoi_ice_s1,h2osoi_ice_s2,                        &
                h2osoi_ice_s3,h2osoi_ice_s4,h2osoi_ice_s5,          &
                h2osoi_ice1,h2osoi_ice2,h2osoi_ice3,h2osoi_ice4,    &
                h2osoi_ice5,h2osoi_ice6,h2osoi_ice7,                &
                h2osoi_ice8,h2osoi_ice9,h2osoi_ice10,               &
                t_soisno_s1,t_soisno_s2,t_soisno_s3,t_soisno_s4,    &
                t_soisno_s5,t_soisno1,t_soisno2,t_soisno3,          &
                t_soisno4,t_soisno5,t_soisno6,t_soisno7,            &
                t_soisno8,t_soisno9,t_soisno10,                     &
                t_lake1,t_lake2,t_lake3,t_lake4,t_lake5,            &
                t_lake6,t_lake7,t_lake8,t_lake9,t_lake10,           &
                h2osoi_vol1,h2osoi_vol2,h2osoi_vol3,                &
                h2osoi_vol4,h2osoi_vol5,h2osoi_vol6,                &
                h2osoi_vol7,h2osoi_vol8,                            &
                h2osoi_vol9,h2osoi_vol10,                           &
                q_ref2m

  integer  :: i,j,m,inest,k

  real, dimension(ims:ime, kms:kme,jms:jme),intent(in) ::&
            forc_txy,forc_uxy,forc_vxy,forc_qxy,zgcmxy,ps
  

  integer, intent(in) :: doclmlake
  real,    intent(in) :: lakeminalt
  real,    dimension(ims:ime, jms:jme), intent(in)    :: lakedepth
  real,    dimension(ims:ime, jms:jme), intent(inout) :: savedtke1
  real,    dimension(ims:ime, 1:num_soil_layers, jms:jme), intent(in) :: dzlake,zlake
  real,    dimension(ims:ime, 1:num_soil_layers, jms:jme), intent(inout) :: lake_icefrac,tlake

  real :: flwdsxy(ims:ime,jms:jme)           
  real :: gsw(ims:ime,jms:jme)               
  real :: xlat (ims:ime,jms:jme)
  real :: xlong(ims:ime,jms:jme)
  real :: ht(ims:ime,jms:jme)
  real :: xland (ims:ime,jms:jme)
  real :: xice (ims:ime,jms:jme)
  real :: prec (ims:ime,jms:jme)              
  integer  :: ivgtyp(ims:ime,jms:jme)
  integer  :: isltyp (ims:ime,jms:jme)

  real :: albxy(ims:ime,jms:jme)           
  real :: tsxy(ims:ime,jms:jme)           
  real :: shxy(ims:ime,jms:jme)           
  real :: lhxy(ims:ime,jms:jme)           
  real :: qfx(ims:ime,jms:jme)   
  real :: qsfxy(ims:ime,jms:jme) 
  real :: qdnxy(ims:ime,jms:jme) 

  real(r8) :: albxy_buf
  real(r8) :: tsxy_buf
  real(r8) :: shxy_buf
  real(r8) :: lhxy_buf
  real(r8) :: qsfxy_buf
  real(r8) :: qdnxy_buf
  real(r8) :: soiflx_buf
  real(r8) :: sabv_buf
  real(r8) :: sabg_buf
  real(r8) :: lwup_buf
  real(r8) :: znt_buf
  real(r8) :: rhoxy_buf

  real(r8) :: swd_buf
  real(r8) :: forc_sols_buf
  real(r8) :: forc_soll_buf
  real(r8) :: forc_solsd_buf
  real(r8) :: forc_solld_buf
  real(r8) :: area_buf
  real(r8) :: forc_pbot_buf
  real(r8) :: forc_txy_buf
  real(r8) :: forc_uxy_buf
  real(r8) :: forc_vxy_buf
  real(r8) :: forc_qxy_buf
  real(r8) :: zgcmxy_buf
  real(r8) :: prec_buf
  real(r8) :: flwdsxy_buf
  real(r8) :: forc_psrfxy_buf

  real(r8) :: xlat_buf 
  real(r8) :: xlon_buf

  real(r8),dimension(maxpatch,-nlevsno+1:num_soil_layers) :: dzclm
  real(r8),dimension(maxpatch,-nlevsno+1:num_soil_layers) :: zclm
  real(r8),dimension(maxpatch,-nlevsno:num_soil_layers)   :: ziclm

  real(r8),dimension(maxpatch,-nlevsno+1:num_soil_layers)   :: &
                          h2osoi_liq_buf, &
                          h2osoi_ice_buf, &
                          t_soisno_buf
      
  real(r8),dimension(maxpatch,1:num_soil_layers)   :: &
                         t_lake_buf, h2osoi_vol_buf

  
  real(r8) :: lakedepth_buf,savedtke1_buf
  real(r8), dimension(1:num_soil_layers) :: lake_icefrac_buf,dzlake_buf,zlake_buf,tlake_buf

  integer  :: lndmsk


  real(r8), dimension(maxpatch)  ::                 &
                snowdp_buf,snowage_buf,wtc_buf,wtp_buf,h2osno_buf,t_grnd_buf,t_veg_buf,         & 
                h2ocan_buf,h2ocan_col_buf,t2m_max_buf,t2m_min_buf,t2m_max_inst_buf,     &
                t2m_min_inst_buf,t_ref2m_buf, q_ref2m_buf






     INTEGER, INTENT(IN) :: num_roof_layers
     INTEGER, INTENT(IN) :: num_wall_layers
     INTEGER, INTENT(IN) :: num_road_layers
     REAL, OPTIONAL, DIMENSION(1:num_roof_layers), INTENT(IN) :: DZR
     REAL, OPTIONAL, DIMENSION(1:num_wall_layers), INTENT(IN) :: DZB
     REAL, OPTIONAL, DIMENSION(1:num_road_layers), INTENT(IN) :: DZG
     REAL, OPTIONAL, INTENT(IN) :: DECLIN_URB
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(IN) :: COSZ_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(IN) :: OMG_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(IN) :: XLAT_URB2D


     INTEGER :: UTYPE_URB 
     REAL :: TA_URB       
     REAL :: QA_URB       
     REAL :: UA_URB       
     REAL :: U1_URB       
     REAL :: V1_URB       
     REAL :: SSG_URB      
     REAL :: LLG_URB      
     REAL :: RAIN_URB     
     REAL :: RHOO_URB     
     REAL :: ZA_URB       
     REAL :: DELT_URB     
     REAL :: SSGD_URB     
     REAL :: SSGQ_URB     
     REAL :: XLAT_URB     
     REAL :: COSZ_URB     
     REAL :: OMG_URB      
     REAL :: ZNT_URB      
     REAL :: TR_URB
     REAL :: TB_URB
     REAL :: TG_URB
     REAL :: TC_URB
     REAL :: QC_URB
     REAL :: UC_URB
     REAL :: XXXR_URB
     REAL :: XXXB_URB
     REAL :: XXXG_URB
     REAL :: XXXC_URB
     REAL, DIMENSION(1:num_roof_layers) :: TRL_URB  
     REAL, DIMENSION(1:num_wall_layers) :: TBL_URB  
     REAL, DIMENSION(1:num_road_layers) :: TGL_URB  
     LOGICAL  :: LSOLAR_URB


     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: TR_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: TB_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: TG_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: TC_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: QC_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: UC_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: XXXR_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: XXXB_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: XXXG_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: XXXC_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: SH_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: LH_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: G_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: RN_URB2D

     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(INOUT) :: TS_URB2D

     REAL, OPTIONAL, DIMENSION( ims:ime, 1:num_roof_layers, jms:jme ), INTENT(INOUT) :: TRL_URB3D
     REAL, OPTIONAL, DIMENSION( ims:ime, 1:num_wall_layers, jms:jme ), INTENT(INOUT) :: TBL_URB3D
     REAL, OPTIONAL, DIMENSION( ims:ime, 1:num_road_layers, jms:jme ), INTENT(INOUT) :: TGL_URB3D


     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: PSIM_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: PSIH_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: GZ1OZ0_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: U10_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: V10_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: TH2_URB2D
     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: Q2_URB2D

     REAL, OPTIONAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: AKMS_URB2D

     REAL, DIMENSION( ims:ime, jms:jme ), INTENT(OUT) :: UST_URB2D
     REAL, DIMENSION( ims:ime, jms:jme ), INTENT(IN) :: FRC_URB2D
     INTEGER, DIMENSION( ims:ime, jms:jme ), INTENT(IN) :: UTYPE_URB2D



     REAL :: TS_URB     
     REAL :: QS_URB     
     REAL :: SH_URB     
     REAL :: LH_URB     
     REAL :: LH_KINEMATIC_URB 
     REAL :: SW_URB     
     REAL :: ALB_URB    
     REAL :: LW_URB     
     REAL :: G_URB      
     REAL :: RN_URB     
     REAL :: PSIM_URB   
     REAL :: PSIH_URB   
     REAL :: GZ1OZ0_URB   
     REAL :: U10_URB    
     REAL :: V10_URB    
     REAL :: TH2_URB    
     REAL :: Q2_URB     
     REAL :: CHS_URB
     REAL :: CHS2_URB
     REAL :: UST_URB



 CHARACTER(len=24) ::  nextstep_date, cdate,simulation_start_date
 INTEGER simulation_start_year   , &
         simulation_start_month  , &
         simulation_start_day    , &
         simulation_start_hour   , &
         simulation_start_minute , &
         simulation_start_second

 integer  :: myr,mon,mday,mhr,mint,msc,mtsec,myr1,mon1,mday1,mhr1,mint1,msc1,mtsec1
 integer  :: myrs,mons,mdays,mhrs,mints,mscs,mtsecs
 integer  :: julyr,julday, julyr1,julday1
 integer  :: mbdate
 integer  :: msec,msec1
 integer  :: ns
 real(r8) :: calday,calday1
 real     :: gmt,gmt1
 integer(selected_int_kind(12))  :: idts
 integer  :: idt
 real(r8) :: dsqmin, dsq
 character*256 :: msg

   call clm_varpar_mod

   call CLMDebug('Now in clmi.')

  if((nlevsoi /= num_soil_layers) .or. (nlevlak/= num_soil_layers)) then
    print*,'nlevsoi and nlevlak must be equal to num_soil_layers in CLM; Stop in module_sf_clm.F'
    call endrun() 
  end if

  dtt = dt

  CALL nl_get_simulation_start_year   ( 1, simulation_start_year   )
  CALL nl_get_simulation_start_month  ( 1, simulation_start_month  )
  CALL nl_get_simulation_start_day    ( 1, simulation_start_day    )
  CALL nl_get_simulation_start_hour   ( 1, simulation_start_hour   )
  CALL nl_get_simulation_start_minute ( 1, simulation_start_minute )
  CALL nl_get_simulation_start_second ( 1, simulation_start_second )
  WRITE ( simulation_start_date(1:19) , FMT = '(I4.4,"-",I2.2,"-",I2.2,"_",I2.2,":",I2.2,":",I2.2)' ) &
           simulation_start_year,simulation_start_month,simulation_start_day,&
           simulation_start_hour,simulation_start_minute,simulation_start_second
  simulation_start_date(1:24) = simulation_start_date(1:19)//'.0000'

  CALL split_date_char (simulation_start_date, myrs, mons, mdays, mhrs, mints, mscs, mtsecs) 

  idt  = nint(dtt)*nstep
  idts = nint(dtt)*nstep
  if(idt/=idts) then
     print*,'The integer idt and idts is too large; Stop in module_sf_clm.F', idt,idts
     call endrun()
  end if
  CALL geth_newdate (cdate(1:19), simulation_start_date(1:19), idt) 
  cdate(1:24) = cdate(1:19)//'.0000'
  CALL split_date_char (cdate, myr, mon, mday, mhr, mint, msc, mtsec )
  CALL geth_newdate (nextstep_date(1:19), cdate(1:19), nint(dtt)) 
  nextstep_date(1:24) = nextstep_date(1:19)//'.0000'
  CALL split_date_char (nextstep_date, myr1, mon1, mday1, mhr1, mint1, msc1, mtsec1) 
  CALL get_julgmt(cdate,julyr,julday, gmt)
  CALL get_julgmt(nextstep_date,julyr1,julday1, gmt1)

  msec  = mhr*3600  + mint*60
  msec1 = mhr1*3600 + mint1*60
  calday = julday  + gmt/24.0
  calday1= julday1 + gmt1/24.0
  mbdate = myrs*10000 + mons*100 + mdays

   do j=jts,jte

      if(nstep.eq.1)then
        do 50 i=its,ite

          if((xland(i,j)-1.5).ge.0. .AND. (DOCLMLAKE==0 .OR. HT(I,J) < LAKEMINALT))then

          If(xice(i,j).eq.1)print*,' SEA-ICE AT WATER POINT, i=',i,'j=',j

            smstav(i,j)=1.0
            smstot(i,j)=1.0
            DO ns=1,nlevsoi
              smois(i,ns,j)=1.0
              tslb(i,ns,j)=273.16                                          
            enddo
          else
            if(xice(i,j).eq.1.)then

              smstav(i,j)=1.0
              smstot(i,j)=1.0
              do ns=1,nlevsoi
                smois(i,ns,j)=1.0
              enddo
            endif
          endif
   50   continue
      endif                                                               

   do i=its,ite
      if(xland(i,j) == 1.0.or. &
        (ivgtyp(i,j)==16.0.and.ht(i,j)>=lakeminalt.and.doclmlake==1)) then

     
        lndmsk = 1
      else
        lndmsk = 0
      end if

   print *,"!!!!!!!!!!!!!! debug:   !!!!!!!!!!!!!!!!!!!"
   print *,"i = ",  i
   print *,"j = ",  j
   print *,"lndmsk = ",lndmsk  
   print *,"ivgtyp(i,j) = ", ivgtyp(i,j)

      qsfxy_buf       = qsfxy(i,j)
      qdnxy_buf       = qdnxy(i,j)


      xlon_buf       = xlong(i,j) + 360.0
      xlat_buf       = xlat(i,j)
      albxy_buf      = albxy(i,j) 

      if(gsw(i,j)>0.0.and.albxy_buf<0.99.and.albxy_buf>0.0)then
         swd_buf     = gsw(i,j)/(1.-albxy_buf)
      else
         swd_buf     = 0.0
      end if
      forc_sols_buf  = swd_buf*0.35
      forc_soll_buf  = swd_buf*0.35
      forc_solsd_buf = swd_buf*0.15
      forc_solld_buf = swd_buf*0.15
      area_buf       = dx*dx/1.e6 

      forc_pbot_buf  = ps(i,2,j)  
      forc_txy_buf   = (forc_txy(i,1,j)+forc_txy(i,2,j))/2
      forc_uxy_buf   = (forc_uxy(i,1,j)+forc_uxy(i,2,j))/2
      forc_vxy_buf   = (forc_vxy(i,1,j)+forc_vxy(i,2,j))/2
      forc_qxy_buf   = (forc_qxy(i,1,j)+forc_qxy(i,2,j))/2

      zgcmxy_buf     = zgcmxy(i,1,j)
      prec_buf       = prec(i,j)/dtt 
      flwdsxy_buf    = flwdsxy(i,j)
      forc_psrfxy_buf= ps(i,1,j) 

      soiflx(i,j) = 0.0
      sabv(i,j)   = 0.0
      sabg(i,j)   = 0.0
      lwup(i,j)   = 0.0
      soiflx_buf     = 0.0
      sabv_buf       = 0.0
      sabg_buf       = 0.0
      lwup_buf       = 0.0

      lakedepth_buf = lakedepth(i,j)
      savedtke1_buf = savedtke1(i,j)
      do k=1,nlevsoi
         lake_icefrac_buf(k) = lake_icefrac(i,k,j)
         dzlake_buf(k)       = dzlake(i,k,j)
         zlake_buf(k)        = zlake(i,k,j)
         tlake_buf(k)        = tlake(i,k,j)
      end do
      
      if(0 == 1) then


       dzclm(:,1) = 1.
       dzclm(:,2) = 2.
       dzclm(:,3) = 3.
       dzclm(:,4) = 4.
       dzclm(:,5) = 5.
       dzclm(:,6) = 7.
       dzclm(:,7) = 7.
       dzclm(:,8) = 7.
       dzclm(:,9) = 7.
       dzclm(:,10)= 7.

       zclm(:,1) =  0.5
       zclm(:,2) =  1.5
       zclm(:,3) =  4.5
       zclm(:,4) =  8.0
       zclm(:,5) = 12.5
       zclm(:,6) = 18.5
       zclm(:,7) = 25.5
       zclm(:,8) = 32.5
       zclm(:,9) = 39.5
       zclm(:,10)= 46.5

       ziclm(:,0) = 0.
       do k = 1, nlevlak-1
         ziclm(:,k) = 0.5*(zclm(:,k)+zclm(:,k))
       enddo
       ziclm(:,nlevlak) = zclm(:,nlevlak) + 0.5*dzclm(:,nlevlak)
    else  
      do k =1,nlevsoi 
        zclm(:,k) =  0.025*(exp(0.5*(k-0.5))-1.)
      end do

       dzclm(:,1) = 0.5*(zclm(:,1)+zclm(:,2))
       do k = 2,nlevsoi-1
         dzclm(:,k)= 0.5*(zclm(:,k+1)-zclm(:,k-1))
       enddo
       dzclm(:,nlevsoi) = zclm(:,nlevsoi)-zclm(:,nlevsoi-1)









      ziclm(:,0) = 0.0
      do k =1,nlevsoi-1 
        ziclm(:,k) =  0.5*(zclm(:,k) + zclm(:,k+1)) 
      end do
        ziclm(:,nlevsoi) =  zclm(:,nlevsoi) + 0.5*dzclm(:,nlevsoi)
    end if

      do m=1,maxpatch
         dzclm(m,-4) = dzsnow5(i,m,j) 
         dzclm(m,-3) = dzsnow4(i,m,j) 
         dzclm(m,-2) = dzsnow3(i,m,j) 
         dzclm(m,-1) = dzsnow2(i,m,j) 
         dzclm(m,0)  = dzsnow1(i,m,j) 
      end do

      do k=0,-nlevsno+1, -1
        zclm(:,k)     = ziclm(:,k) - 0.5*dzclm(:,k)
        ziclm(:,k-1)  = ziclm(:,k) - dzclm(:,k)
      end do

      do m=1,maxpatch
      snowdp_buf(m)     = snowdp(i,m,j)
      snowage_buf(m)    = snowage(i,m,j)

      h2osoi_liq_buf(m,-4) = h2osoi_liq_s5(i,m,j)
      h2osoi_liq_buf(m,-3) = h2osoi_liq_s4(i,m,j)
      h2osoi_liq_buf(m,-2) = h2osoi_liq_s3(i,m,j)
      h2osoi_liq_buf(m,-1) = h2osoi_liq_s2(i,m,j)
      h2osoi_liq_buf(m,0)  = h2osoi_liq_s1(i,m,j)
      h2osoi_liq_buf(m,1)  = h2osoi_liq1(i,m,j)
      h2osoi_liq_buf(m,2)  = h2osoi_liq2(i,m,j)
      h2osoi_liq_buf(m,3)  = h2osoi_liq3(i,m,j)
      h2osoi_liq_buf(m,4)  = h2osoi_liq4(i,m,j)
      h2osoi_liq_buf(m,5)  = h2osoi_liq5(i,m,j)
      h2osoi_liq_buf(m,6)  = h2osoi_liq6(i,m,j)
      h2osoi_liq_buf(m,7)  = h2osoi_liq7(i,m,j)
      h2osoi_liq_buf(m,8)  = h2osoi_liq8(i,m,j)
      h2osoi_liq_buf(m,9)  = h2osoi_liq9(i,m,j)
      h2osoi_liq_buf(m,10) = h2osoi_liq10(i,m,j)

      h2osoi_ice_buf(m,-4) = h2osoi_ice_s5(i,m,j)
      h2osoi_ice_buf(m,-3) = h2osoi_ice_s4(i,m,j)
      h2osoi_ice_buf(m,-2) = h2osoi_ice_s3(i,m,j)
      h2osoi_ice_buf(m,-1) = h2osoi_ice_s2(i,m,j)
      h2osoi_ice_buf(m,0)  = h2osoi_ice_s1(i,m,j)
      h2osoi_ice_buf(m,1)  = h2osoi_ice1(i,m,j)
      h2osoi_ice_buf(m,2)  = h2osoi_ice2(i,m,j)
      h2osoi_ice_buf(m,3)  = h2osoi_ice3(i,m,j)
      h2osoi_ice_buf(m,4)  = h2osoi_ice4(i,m,j)
      h2osoi_ice_buf(m,5)  = h2osoi_ice5(i,m,j)
      h2osoi_ice_buf(m,6)  = h2osoi_ice6(i,m,j)
      h2osoi_ice_buf(m,7)  = h2osoi_ice7(i,m,j)
      h2osoi_ice_buf(m,8)  = h2osoi_ice8(i,m,j)
      h2osoi_ice_buf(m,9)  = h2osoi_ice9(i,m,j)
      h2osoi_ice_buf(m,10) = h2osoi_ice10(i,m,j)

      t_soisno_buf(m,-4) = t_soisno_s5(i,m,j)
      t_soisno_buf(m,-3) = t_soisno_s4(i,m,j)
      t_soisno_buf(m,-2) = t_soisno_s3(i,m,j)
      t_soisno_buf(m,-1) = t_soisno_s2(i,m,j)
      t_soisno_buf(m,0)  = t_soisno_s1(i,m,j)
      t_soisno_buf(m,1)  = t_soisno1(i,m,j)
      t_soisno_buf(m,2)  = t_soisno2(i,m,j)
      t_soisno_buf(m,3)  = t_soisno3(i,m,j)
      t_soisno_buf(m,4)  = t_soisno4(i,m,j)
      t_soisno_buf(m,5)  = t_soisno5(i,m,j)
      t_soisno_buf(m,6)  = t_soisno6(i,m,j)
      t_soisno_buf(m,7)  = t_soisno7(i,m,j)
      t_soisno_buf(m,8)  = t_soisno8(i,m,j)
      t_soisno_buf(m,9)  = t_soisno9(i,m,j)
      t_soisno_buf(m,10) = t_soisno10(i,m,j)

      t_lake_buf(m,1)  = t_lake1(i,m,j)
      t_lake_buf(m,2)  = t_lake2(i,m,j)
      t_lake_buf(m,3)  = t_lake3(i,m,j)
      t_lake_buf(m,4)  = t_lake4(i,m,j)
      t_lake_buf(m,5)  = t_lake5(i,m,j)
      t_lake_buf(m,6)  = t_lake6(i,m,j)
      t_lake_buf(m,7)  = t_lake7(i,m,j)
      t_lake_buf(m,8)  = t_lake8(i,m,j)
      t_lake_buf(m,9)  = t_lake9(i,m,j)
      t_lake_buf(m,10) = t_lake10(i,m,j)

      h2osoi_vol_buf(m,1)  = h2osoi_vol1(i,m,j)
      h2osoi_vol_buf(m,2)  = h2osoi_vol2(i,m,j)
      h2osoi_vol_buf(m,3)  = h2osoi_vol3(i,m,j)
      h2osoi_vol_buf(m,4)  = h2osoi_vol4(i,m,j)
      h2osoi_vol_buf(m,5)  = h2osoi_vol5(i,m,j)
      h2osoi_vol_buf(m,6)  = h2osoi_vol6(i,m,j)
      h2osoi_vol_buf(m,7)  = h2osoi_vol7(i,m,j)
      h2osoi_vol_buf(m,8)  = h2osoi_vol8(i,m,j)
      h2osoi_vol_buf(m,9)  = h2osoi_vol9(i,m,j)
      h2osoi_vol_buf(m,10) = h2osoi_vol10(i,m,j)

      t_grnd_buf(m)     = t_grnd(i,m,j)
      t_veg_buf(m)      = t_veg(i,m,j)
      h2ocan_buf(m)     = h2ocan(i,m,j)
      h2ocan_col_buf(m) = h2ocan_col(i,m,j)
      h2osno_buf(m)     = h2osno(i,m,j)

      t2m_max_buf(m)    = t2m_max(i,m,j)
      t2m_min_buf(m)    = t2m_min(i,m,j)
      t2m_max_inst_buf(m)=t2m_max_inst(i,m,j)
      t2m_min_inst_buf(m)=t2m_min_inst(i,m,j)
      t_ref2m_buf(m)    = t_ref2m(i,m,j)
      q_ref2m_buf(m)    = q_ref2m(i,m,j)
      end do 

      if(lndmsk  == 1) then
          call clm(forc_txy_buf        ,forc_uxy_buf           ,forc_vxy_buf    &
                  ,forc_qxy_buf        ,zgcmxy_buf             ,prec_buf        &
                  ,flwdsxy_buf         ,forc_sols_buf          ,forc_soll_buf   &
                  ,forc_solsd_buf      ,forc_solld_buf         ,forc_pbot_buf   &
                  ,forc_psrfxy_buf     ,ivgtyp(i,j)            ,isltyp(i,j)     &
                  ,lndmsk              ,xlat_buf               ,xlon_buf        &
                  ,area_buf            ,dtt                    ,myr             &
                  ,mon                 ,mday                   ,msec            &
                  ,calday              ,myr1                   ,mon1            &
                  ,mday1               ,msec1                  ,calday1         &
                  ,mbdate              ,qsfxy_buf              ,qdnxy_buf       &
                  ,snl(i,:,j)          ,snowdp_buf             ,snowage_buf     &
                  ,dzclm               ,zclm                   ,ziclm           &
                  ,h2osno_buf          ,h2osoi_liq_buf         ,h2osoi_ice_buf  &
                  ,t_grnd_buf          ,t_soisno_buf           ,t_lake_buf      &
                  ,t_veg_buf           ,h2ocan_buf             ,h2ocan_col_buf  &
                  ,h2osoi_vol_buf      ,wtc_buf                ,wtp_buf         &
                  ,numc(i,j)           ,nump(i,j)              ,t2m_max_buf     &
                  ,t2m_min_buf         ,t2m_max_inst_buf       ,t2m_min_inst_buf&
                  ,t_ref2m_buf         ,albxy_buf              ,tsxy_buf        &
                  ,shxy_buf            ,lhxy_buf               ,nstep           &
                  ,inest               ,i                      ,j               &
                  ,soiflx_buf          ,sabv_buf               ,sabg_buf        &
                  ,lwup_buf            ,znt_buf                ,q_ref2m_buf     &
                  ,rhoxy_buf                                                    &
                  ,lake_icefrac_buf,lakedepth_buf,dzlake_buf,zlake_buf,tlake_buf,savedtke1_buf &
                                                                                )
                   
                 if(albxy_buf ==  1) albxy_buf = 0.991

                  albxy(i,j)          = albxy_buf
                  snowh(i,j)          = sum(snowdp_buf(1:numc(i,j))*wtc_buf(1:numc(i,j)))
                  snow(i,j)           = sum(h2osno_buf(1:numc(i,j))*wtc_buf(1:numc(i,j)))
                  canwat(i,j)         = sum(h2ocan_buf(1:nump(i,j))*wtp_buf(1:nump(i,j)))




              if (ivgtyp(i,j) /= 24) then 
                  do k=1,nlevsoi
                     smois(i,k,j)     = sum(h2osoi_vol_buf(1:numc(i,j),k)*wtc_buf(1:numc(i,j)))
                     tslb (i,k,j)     = sum(t_soisno_buf(1:numc(i,j),k)*wtc_buf(1:numc(i,j)))
                     sh2o (i,k,j)     = sum(h2osoi_liq_buf(1:numc(i,j),k)/dzclm(1:numc(i,j),k) &
                                        *wtc_buf(1:numc(i,j)))/1000
                  end do 
                  tmn(i,j) = tslb(i,nlevsoi,j)
              end if


                  tsxy(i,j)           = tsxy_buf
                  qsfxy(i,j)          = qsfxy_buf

                  qdnxy(i,j)          = 0 
                  soiflx(i,j)         = soiflx_buf
                  sabv(i,j)           = sabv_buf
                  sabg(i,j)           = sabg_buf
                  lwup(i,j)           = lwup_buf
                  znt(i,j)            = znt_buf
                  z0(i,j)             = znt(i,j)



                  
                  savedtke1(i,j)        = savedtke1_buf
                  do k=1,nlevsoi
                     lake_icefrac(i,k,j) = lake_icefrac_buf(k)
                     tlake(i,k,j)       = tlake_buf(k)
                  end do








                  emiss(i,j) = lwup(i,j)/(sb * tsxy(i,j)**4)


                  shxy(i,j)           = shxy_buf
                  lhxy(i,j)           = lhxy_buf
                  if(tsxy(i,j)>=tfrz) then
                    qfx(i,j)          = lhxy_buf/hvap 
                  else
                    qfx(i,j)          = lhxy_buf/hsub 
                  end if



                  qsfc(i,j)  = forc_qxy(i,1,j) +qfx(i,j)/(rhoxy_buf*chs(i,j))

              msg=''
              write(msg,*)'Back after clm3. TSK,LH,SH,LWUP=',tsxy(i,j),lhxy(i,j),shxy(i,j),lwup(i,j)
              if (ivgtyp(i,j)==16) write(msg,*)'\n znt=',znt(i,j)
              call CLMDebug(msg)

              do m=1,maxpatch
                  snowdp(i,m,j)       = snowdp_buf(m)
                  snowage(i,m,j)      = snowage_buf(m)
                  dzsnow5(i,m,j)      = dzclm(m,-4) 
                  dzsnow4(i,m,j)      = dzclm(m,-3) 
                  dzsnow3(i,m,j)      = dzclm(m,-2) 
                  dzsnow2(i,m,j)      = dzclm(m,-1) 
                  dzsnow1(i,m,j)      = dzclm(m,0)  

                  h2osno(i,m,j)       = h2osno_buf(m)
                  t_grnd(i,m,j)       = t_grnd_buf(m)
                  t_veg(i,m,j)        = t_veg_buf(m)
                  h2ocan(i,m,j)       = h2ocan_buf(m)
                  h2ocan_col(i,m,j)   = h2ocan_col_buf(m)
                  wtc(i,m,j)          = wtc_buf(m)
                  wtp(i,m,j)          = wtp_buf(m)
                  

                  h2osoi_liq_s5(i,m,j) = h2osoi_liq_buf(m,-4)
                  h2osoi_liq_s4(i,m,j) = h2osoi_liq_buf(m,-3)
                  h2osoi_liq_s3(i,m,j) = h2osoi_liq_buf(m,-2)
                  h2osoi_liq_s2(i,m,j) = h2osoi_liq_buf(m,-1)
                  h2osoi_liq_s1(i,m,j) = h2osoi_liq_buf(m,0)
                  h2osoi_liq1(i,m,j)   = h2osoi_liq_buf(m,1)
                  h2osoi_liq2(i,m,j)   = h2osoi_liq_buf(m,2)
                  h2osoi_liq3(i,m,j)   = h2osoi_liq_buf(m,3)
                  h2osoi_liq4(i,m,j)   = h2osoi_liq_buf(m,4)
                  h2osoi_liq5(i,m,j)   = h2osoi_liq_buf(m,5)
                  h2osoi_liq6(i,m,j)   = h2osoi_liq_buf(m,6)
                  h2osoi_liq7(i,m,j)   = h2osoi_liq_buf(m,7)
                  h2osoi_liq8(i,m,j)   = h2osoi_liq_buf(m,8)
                  h2osoi_liq9(i,m,j)   = h2osoi_liq_buf(m,9)
                  h2osoi_liq10(i,m,j)  = h2osoi_liq_buf(m,10)

                  h2osoi_ice_s5(i,m,j) = h2osoi_ice_buf(m,-4)
                  h2osoi_ice_s4(i,m,j) = h2osoi_ice_buf(m,-3)
                  h2osoi_ice_s3(i,m,j) = h2osoi_ice_buf(m,-2)
                  h2osoi_ice_s2(i,m,j) = h2osoi_ice_buf(m,-1)
                  h2osoi_ice_s1(i,m,j) = h2osoi_ice_buf(m,0)
                  h2osoi_ice1(i,m,j)   = h2osoi_ice_buf(m,1)
                  h2osoi_ice2(i,m,j)   = h2osoi_ice_buf(m,2)
                  h2osoi_ice3(i,m,j)   = h2osoi_ice_buf(m,3)
                  h2osoi_ice4(i,m,j)   = h2osoi_ice_buf(m,4)
                  h2osoi_ice5(i,m,j)   = h2osoi_ice_buf(m,5)
                  h2osoi_ice6(i,m,j)   = h2osoi_ice_buf(m,6)
                  h2osoi_ice7(i,m,j)   = h2osoi_ice_buf(m,7)
                  h2osoi_ice8(i,m,j)   = h2osoi_ice_buf(m,8)
                  h2osoi_ice9(i,m,j)   = h2osoi_ice_buf(m,9)
                  h2osoi_ice10(i,m,j)  = h2osoi_ice_buf(m,10)

                  t_soisno_s5(i,m,j) = t_soisno_buf(m,-4)
                  t_soisno_s4(i,m,j) = t_soisno_buf(m,-3)
                  t_soisno_s3(i,m,j) = t_soisno_buf(m,-2)
                  t_soisno_s2(i,m,j) = t_soisno_buf(m,-1)
                  t_soisno_s1(i,m,j) = t_soisno_buf(m,0)
                  t_soisno1(i,m,j)   = t_soisno_buf(m,1)
                  t_soisno2(i,m,j)   = t_soisno_buf(m,2)
                  t_soisno3(i,m,j)   = t_soisno_buf(m,3)
                  t_soisno4(i,m,j)   = t_soisno_buf(m,4)
                  t_soisno5(i,m,j)   = t_soisno_buf(m,5)
                  t_soisno6(i,m,j)   = t_soisno_buf(m,6)
                  t_soisno7(i,m,j)   = t_soisno_buf(m,7)
                  t_soisno8(i,m,j)   = t_soisno_buf(m,8)
                  t_soisno9(i,m,j)   = t_soisno_buf(m,9)
                  t_soisno10(i,m,j)  = t_soisno_buf(m,10)

                  t_lake1(i,m,j)   = t_lake_buf(m,1)
                  t_lake2(i,m,j)   = t_lake_buf(m,2)
                  t_lake3(i,m,j)   = t_lake_buf(m,3)
                  t_lake4(i,m,j)   = t_lake_buf(m,4)
                  t_lake5(i,m,j)   = t_lake_buf(m,5)
                  t_lake6(i,m,j)   = t_lake_buf(m,6)
                  t_lake7(i,m,j)   = t_lake_buf(m,7)
                  t_lake8(i,m,j)   = t_lake_buf(m,8)
                  t_lake9(i,m,j)   = t_lake_buf(m,9)
                  t_lake10(i,m,j)  = t_lake_buf(m,10)

                  h2osoi_vol1(i,m,j)   = h2osoi_vol_buf(m,1)
                  h2osoi_vol2(i,m,j)   = h2osoi_vol_buf(m,2)
                  h2osoi_vol3(i,m,j)   = h2osoi_vol_buf(m,3)
                  h2osoi_vol4(i,m,j)   = h2osoi_vol_buf(m,4)
                  h2osoi_vol5(i,m,j)   = h2osoi_vol_buf(m,5)
                  h2osoi_vol6(i,m,j)   = h2osoi_vol_buf(m,6)
                  h2osoi_vol7(i,m,j)   = h2osoi_vol_buf(m,7)
                  h2osoi_vol8(i,m,j)   = h2osoi_vol_buf(m,8)
                  h2osoi_vol9(i,m,j)   = h2osoi_vol_buf(m,9)
                  h2osoi_vol10(i,m,j)  = h2osoi_vol_buf(m,10)


                  t2m_max(i,m,j)      = t2m_max_buf(m)    
                  t2m_min(i,m,j)      = t2m_min_buf(m)   
                  t2m_max_inst(i,m,j) = t2m_max_inst_buf(m)
                  t2m_min_inst(i,m,j) = t2m_min_inst_buf(m)
                  t_ref2m(i,m,j)      = t_ref2m_buf(m)    
                  q_ref2m(i,m,j)      = q_ref2m_buf(m)    

              end do 
      end if

        IF (UCMCALL == 1 ) THEN                                              






          IF( IVGTYP(I,J) == 1 .or. IVGTYP(I,J) == 31 .or. &
              IVGTYP(I,J) == 32 .or. IVGTYP(I,J) == 33 ) THEN


      forc_sols_buf  = swd_buf*0.35
      forc_soll_buf  = swd_buf*0.35
      forc_solsd_buf = swd_buf*0.15
      forc_solld_buf = swd_buf*0.15
      area_buf       = dx*dx/1.e6 
      forc_pbot_buf  = ps(i,1,j) 
      forc_txy_buf   = forc_txy(i,1,j)
      forc_uxy_buf   = forc_uxy(i,1,j)
      forc_vxy_buf   = forc_vxy(i,1,j)
      forc_qxy_buf   = forc_qxy(i,1,j)
      zgcmxy_buf     = zgcmxy(i,1,j)
      prec_buf       = prec(i,j)/dtt 
      flwdsxy_buf    = flwdsxy(i,j) 
      forc_psrfxy_buf= ps(i,1,j) 

            UTYPE_URB = UTYPE_URB2D(I,J) 

            TA_URB    = forc_txy(i,1,j)  
            QA_URB    = forc_qxy(i,1,j)  
            UA_URB    = SQRT(forc_uxy(i,1,j)**2.+forc_vxy(i,1,j)**2.)
            U1_URB    = forc_uxy(i,1,j)
            V1_URB    = forc_vxy(i,1,j)
            IF(UA_URB < 1.) UA_URB=1.    
            SSG_URB   = swd_buf            
            SSGD_URB  = 0.8*swd_buf        
            SSGQ_URB  = SSG_URB-SSGD_URB 
            LLG_URB   = flwdsxy(i,j)    
            RAIN_URB  = prec(i,j)      
            RHOO_URB  = ps(i,1,j)/(287.04 * forc_txy(i,1,j) * (1.0+ 0.61 * forc_qxy(i,1,j))) 
            ZA_URB    = zgcmxy_buf             
            DELT_URB  = DT               
            XLAT_URB  = XLAT_URB2D(I,J)  
            COSZ_URB  = COSZ_URB2D(I,J)  
            OMG_URB   = OMG_URB2D(I,J)   
            ZNT_URB   = ZNT(I,J)

            LSOLAR_URB = .FALSE.

            TR_URB = TR_URB2D(I,J)
            TB_URB = TB_URB2D(I,J)
            TG_URB = TG_URB2D(I,J)
            TC_URB = TC_URB2D(I,J)
            QC_URB = QC_URB2D(I,J)
            UC_URB = UC_URB2D(I,J)

            DO K = 1,num_roof_layers
              TRL_URB(K) = TRL_URB3D(I,K,J)
            END DO
            DO K = 1,num_wall_layers
              TBL_URB(K) = TBL_URB3D(I,K,J)
            END DO
            DO K = 1,num_road_layers
              TGL_URB(K) = TGL_URB3D(I,K,J)
            END DO

            XXXR_URB = XXXR_URB2D(I,J)
            XXXB_URB = XXXB_URB2D(I,J)
            XXXG_URB = XXXG_URB2D(I,J)
            XXXC_URB = XXXC_URB2D(I,J)

            CHS_URB  = CHS(I,J)
            CHS2_URB = CHS2(I,J)



         
            CALL v3urban(LSOLAR_URB,                                      & 
                       num_roof_layers,num_wall_layers,num_road_layers, & 
                       DZR,DZB,DZG,                                     & 
                       UTYPE_URB,TA_URB,QA_URB,UA_URB,U1_URB,V1_URB,SSG_URB, & 
                       SSGD_URB,SSGQ_URB,LLG_URB,RAIN_URB,RHOO_URB,     & 
                       ZA_URB,DECLIN_URB,COSZ_URB,OMG_URB,              & 
                       XLAT_URB,DELT_URB,ZNT_URB,                       & 
                       CHS_URB, CHS2_URB,                               & 
                       TR_URB, TB_URB, TG_URB, TC_URB, QC_URB,UC_URB,   & 
                       TRL_URB,TBL_URB,TGL_URB,                         & 
                       XXXR_URB, XXXB_URB, XXXG_URB, XXXC_URB,          & 
                       TS_URB,QS_URB,SH_URB,LH_URB,LH_KINEMATIC_URB,    & 
                       SW_URB,ALB_URB,LW_URB,G_URB,RN_URB,PSIM_URB,PSIH_URB, & 
                       GZ1OZ0_URB,                                      & 
                       U10_URB, V10_URB, TH2_URB, Q2_URB,               & 
                       UST_URB)                                           

            TS_URB2D(I,J) = TS_URB

            albxy(i,j) = FRC_URB2D(I,J)*ALB_URB+(1-FRC_URB2D(I,J))*albxy_buf   
            shxy(i,j)  = FRC_URB2D(I,J)*SH_URB+(1-FRC_URB2D(I,J))*shxy_buf     
            qfx(i,j)   = FRC_URB2D(I,J)*LH_KINEMATIC_URB &
                     + (1-FRC_URB2D(I,J))*qfx(i,j)                
            lhxy(i,j) = FRC_URB2D(I,J)*LH_URB+(1-FRC_URB2D(I,J))*lhxy_buf     
            soiflx(i,j) = FRC_URB2D(I,J)*G_URB+(1-FRC_URB2D(I,J))*soiflx_buf  
            tsxy(i,j)  = FRC_URB2D(I,J)*TS_URB+(1-FRC_URB2D(I,J))*tsxy_buf          
            qsfc(i,j)  = FRC_URB2D(I,J)*QS_URB+(1-FRC_URB2D(I,J))*qsfc(i,j)         



            TR_URB2D(I,J) = TR_URB
            TB_URB2D(I,J) = TB_URB
            TG_URB2D(I,J) = TG_URB
            TC_URB2D(I,J) = TC_URB
            QC_URB2D(I,J) = QC_URB
            UC_URB2D(I,J) = UC_URB

            DO K = 1,num_roof_layers
              TRL_URB3D(I,K,J) = TRL_URB(K)
            END DO
            DO K = 1,num_wall_layers
              TBL_URB3D(I,K,J) = TBL_URB(K)
            END DO
            DO K = 1,num_road_layers
              TGL_URB3D(I,K,J) = TGL_URB(K)
            END DO
            XXXR_URB2D(I,J) = XXXR_URB
            XXXB_URB2D(I,J) = XXXB_URB
            XXXG_URB2D(I,J) = XXXG_URB
            XXXC_URB2D(I,J) = XXXC_URB

            SH_URB2D(I,J)    = SH_URB
            LH_URB2D(I,J)    = LH_URB
            G_URB2D(I,J)     = G_URB
            RN_URB2D(I,J)    = RN_URB
            PSIM_URB2D(I,J)  = PSIM_URB
            PSIH_URB2D(I,J)  = PSIH_URB
            GZ1OZ0_URB2D(I,J)= GZ1OZ0_URB
            U10_URB2D(I,J)   = U10_URB
            V10_URB2D(I,J)   = V10_URB
            TH2_URB2D(I,J)   = TH2_URB
            Q2_URB2D(I,J)    = Q2_URB
            UST_URB2D(I,J)   = UST_URB
            AKMS_URB2D(I,J)  = vkc * UST_URB2D(I,J)/(GZ1OZ0_URB2D(I,J)-PSIM_URB2D(I,J))

          END IF

         ENDIF                                   

  end do 
  end do 
end subroutine clmi

  subroutine clminit(VEGFRA,SNOW,SNOWC,SNOWH,CANWAT,SMSTAV,        &
                     SMSTOT, SFCRUNOFF,UDRUNOFF,ACSNOW,            &
                     ACSNOM,IVGTYP,ISLTYP,TSLB,SMOIS,SH2O,ZS,DZS,  &
                     FNDSOILW, FNDSNOWH,                           &
                     num_soil_layers, restart,                     &
                     allowed_to_read ,                             &
                     ids,ide, jds,jde, kds,kde,                    &
                     ims,ime, jms,jme, kms,kme,                    &
                     its,ite, jts,jte, kts,kte,                    &
                     maxpatch                                      &
                    ,numc,nump,snl,                                      &
                     snowdp,snowage,wtc,wtp,h2osno,t_grnd,t_veg,         &
                     h2ocan,h2ocan_col,t2m_max,t2m_min,t2m_max_inst,     &
                     t2m_min_inst,t_ref2m,dzsnow1,dzsnow2,               &
                     dzsnow3,dzsnow4,dzsnow5,h2osoi_liq_s1,              &
                     h2osoi_liq_s2,h2osoi_liq_s3,h2osoi_liq_s4,          &
                     h2osoi_liq_s5,h2osoi_liq1,h2osoi_liq2,              &
                     h2osoi_liq3,h2osoi_liq4,h2osoi_liq5,h2osoi_liq6,    &
                     h2osoi_liq7,h2osoi_liq8,h2osoi_liq9,h2osoi_liq10,   &
                     h2osoi_ice_s1,h2osoi_ice_s2,                        &
                     h2osoi_ice_s3,h2osoi_ice_s4,h2osoi_ice_s5,          &
                     h2osoi_ice1,h2osoi_ice2,h2osoi_ice3,h2osoi_ice4,    &
                     h2osoi_ice5,h2osoi_ice6,h2osoi_ice7,                &
                     h2osoi_ice8,h2osoi_ice9,h2osoi_ice10,               &
                     t_soisno_s1,t_soisno_s2,t_soisno_s3,t_soisno_s4,    &
                     t_soisno_s5,t_soisno1,t_soisno2,t_soisno3,          &
                     t_soisno4,t_soisno5,t_soisno6,t_soisno7,            &
                     t_soisno8,t_soisno9,t_soisno10,                     &
                     t_lake1,t_lake2,t_lake3,t_lake4,t_lake5,            &
                     t_lake6,t_lake7,t_lake8,t_lake9,t_lake10,           &
                     h2osoi_vol1,h2osoi_vol2,h2osoi_vol3,                &
                     h2osoi_vol4,h2osoi_vol5,h2osoi_vol6,                &
                     h2osoi_vol7,h2osoi_vol8,                            &
                     h2osoi_vol9,h2osoi_vol10,                           &
                     ht,xland                                            &
               ,doclmlake,domainlakedepth,lakeminalt,                    &
                lake_icefrac,lakedepth,dzlake,zlake,tlake,savedtke1      &
                                                                         )

  USE module_wrf_error

  implicit none

  INTEGER,  INTENT(IN   )   ::     ids,ide, jds,jde, kds,kde,  &
                                   ims,ime, jms,jme, kms,kme,  &
                                   its,ite, jts,jte, kts,kte

  INTEGER, INTENT(IN)       ::     num_soil_layers,maxpatch
    
   LOGICAL , INTENT(IN) :: restart , allowed_to_read

   REAL,    DIMENSION( num_soil_layers), INTENT(INOUT) :: zs, dzs

   REAL,    DIMENSION( ims:ime, num_soil_layers, jms:jme )    , &
            INTENT(INOUT)    ::                          SMOIS, &  
                                                         SH2O,  &  
                                                         TSLB      
     
   REAL,    DIMENSION( ims:ime, jms:jme )                     , &
            INTENT(INOUT)    ::                           SNOW, & 
                                                         SNOWH, &
                                                         SNOWC, &
                                                        CANWAT, &
                                                        SMSTAV, &
                                                        SMSTOT, &
                                                     SFCRUNOFF, &
                                                      UDRUNOFF, &
                                                        ACSNOW, &
                                                        VEGFRA, &
                                                        ACSNOM

   REAL,  DIMENSION( ims:ime, jms:jme ), INTENT(IN) :: HT
   INTEGER, DIMENSION( ims:ime, jms:jme )                     , &
            INTENT(IN)       ::                         IVGTYP, &
                                                        ISLTYP
   REAL, DIMENSION( ims:ime, jms:jme )                     , &
            INTENT(IN)       ::                         XLAND
   LOGICAL, DIMENSION( ims:ime, jms:jme ) :: lake

   LOGICAL, INTENT(IN)       ::                      FNDSOILW , &
                                                     FNDSNOWH

  integer,   dimension(ims:ime,jms:jme ),intent(inout) :: numc,nump
  integer,   dimension(ims:ime,1:maxpatch,jms:jme ),intent(inout) :: snl
  real,  dimension(ims:ime,1:maxpatch,jms:jme ),intent(inout) ::  &
                snowdp,snowage,wtc,wtp,h2osno,t_grnd,t_veg,         &
                h2ocan,h2ocan_col,t2m_max,t2m_min,t2m_max_inst,     &
                t2m_min_inst,t_ref2m,dzsnow1,dzsnow2,               &
                dzsnow3,dzsnow4,dzsnow5,h2osoi_liq_s1,              &
                h2osoi_liq_s2,h2osoi_liq_s3,h2osoi_liq_s4,          &
                h2osoi_liq_s5,h2osoi_liq1,h2osoi_liq2,              &
                h2osoi_liq3,h2osoi_liq4,h2osoi_liq5,h2osoi_liq6,    &
                h2osoi_liq7,h2osoi_liq8,h2osoi_liq9,h2osoi_liq10,   &
                h2osoi_ice_s1,h2osoi_ice_s2,                        &
                h2osoi_ice_s3,h2osoi_ice_s4,h2osoi_ice_s5,          &
                h2osoi_ice1,h2osoi_ice2,h2osoi_ice3,h2osoi_ice4,    &
                h2osoi_ice5,h2osoi_ice6,h2osoi_ice7,                &
                h2osoi_ice8,h2osoi_ice9,h2osoi_ice10,               &
                t_soisno_s1,t_soisno_s2,t_soisno_s3,t_soisno_s4,    &
                t_soisno_s5,t_soisno1,t_soisno2,t_soisno3,          &
                t_soisno4,t_soisno5,t_soisno6,t_soisno7,            &
                t_soisno8,t_soisno9,t_soisno10,                     &
                t_lake1,t_lake2,t_lake3,t_lake4,t_lake5,            &
                t_lake6,t_lake7,t_lake8,t_lake9,t_lake10,           &
                h2osoi_vol1,h2osoi_vol2,h2osoi_vol3,                &
                h2osoi_vol4,h2osoi_vol5,h2osoi_vol6,                &
                h2osoi_vol7,h2osoi_vol8,                            &
                h2osoi_vol9,h2osoi_vol10                            
  integer,intent(in)    ::      doclmlake
  real, intent(in)      ::      domainlakedepth,lakeminalt
  real   ,   dimension(ims:ime,jms:jme ),intent(out)   :: lakedepth,savedtke1
  real   ,   dimension(ims:ime, 1:num_soil_layers, jms:jme), intent(out) :: &
                lake_icefrac,dzlake,zlake,tlake


   INTEGER                   :: L
   REAL                      :: BX, SMCMAX, PSISAT, FREE
   INTEGER                   :: errflag
   INTEGER                   :: itf,jtf,j,i,k,m
   character*256 :: msg

   call CLMDebug('Now in clminit.')


   IF(restart) return

   itf=min0(ite,ide-1)
   jtf=min0(jte,jde-1)

   errflag = 0
   DO j = jts,jtf
     DO i = its,itf
       IF ( ISLTYP( i,j ) .LT. 1 ) THEN
         errflag = 1
         WRITE(wrf_err_message,*)"CLM: clminit: out of range ISLTYP ",i,j,ISLTYP( i,j )
         CALL wrf_message(wrf_err_message)
       ENDIF
     ENDDO
   ENDDO
   IF ( errflag .EQ. 1 ) THEN
      CALL wrf_error_fatal3("<stdin>",1139,&
"CLM: clminit: out of range value "// &
                            "of ISLTYP. Is this field in the input?" )
   ENDIF






          DO j = jts,jtf
          DO i = its,itf


            snowh(i,j)=snow(i,j)*0.005               








            snowdp(i,:,j) = snowh(i,j)

          ENDDO
          ENDDO



























       do i=its,itf
       do j=jts,jtf
           snl(i,:,j) = -999.0 
           h2osoi_liq_s5(i,:,j) = -999.0 
           h2osoi_liq_s4(i,:,j) = -999.0 
           h2osoi_liq_s3(i,:,j) = -999.0 
           h2osoi_liq_s2(i,:,j) = -999.0 
           h2osoi_liq_s1(i,:,j) = -999.0 
           h2osoi_liq1(i,:,j)   = -999.0 
           h2osoi_liq2(i,:,j)   = -999.0 
           h2osoi_liq3(i,:,j)   = -999.0 
           h2osoi_liq4(i,:,j)   = -999.0 
           h2osoi_liq5(i,:,j)   = -999.0 
           h2osoi_liq6(i,:,j)   = -999.0 
           h2osoi_liq7(i,:,j)   = -999.0 
           h2osoi_liq8(i,:,j)   = -999.0 
           h2osoi_liq9(i,:,j)   = -999.0 
           h2osoi_liq10(i,:,j)  = -999.0 

           h2osoi_ice_s5(i,:,j) = -999.0 
           h2osoi_ice_s4(i,:,j) = -999.0 
           h2osoi_ice_s3(i,:,j) = -999.0 
           h2osoi_ice_s2(i,:,j) = -999.0 
           h2osoi_ice_s1(i,:,j) = -999.0 
           h2osoi_ice1(i,:,j)   = -999.0 
           h2osoi_ice2(i,:,j)   = -999.0 
           h2osoi_ice3(i,:,j)   = -999.0 
           h2osoi_ice4(i,:,j)   = -999.0 
           h2osoi_ice5(i,:,j)   = -999.0 
           h2osoi_ice6(i,:,j)   = -999.0 
           h2osoi_ice7(i,:,j)   = -999.0 
           h2osoi_ice8(i,:,j)   = -999.0 
           h2osoi_ice9(i,:,j)   = -999.0 
           h2osoi_ice10(i,:,j)  = -999.0 

           snowage(i,:,j)= 0.0



             h2osno(i,:,j) = snow(i,j) 

       end do
       end do

       do i=its,itf
       do j=jts,jtf
         numc(i,j) = 0
         nump(i,j) = 0
         wtc(i,:,j) = 0.0
         wtp(i,:,j) = 0.0
       end do
       end do

       do i=its,itf
         do j=jts,jtf
            if(ivgtyp(i,j)==16.and.ht(i,j)>=lakeminalt.and.doclmlake==1) then

                lake(i,j)  = .true.
            else
                lake(i,j)  = .false.
            end if
        end do
       end do


      do m=1,maxpatch
      do i=its,itf
      do j=jts,jtf
               dzsnow1(i,m,j) = 0.0
               dzsnow2(i,m,j) = 0.0
               dzsnow3(i,m,j) = 0.0
               dzsnow4(i,m,j) = 0.0
               dzsnow5(i,m,j) = 0.0
               if(snowdp(i,m,j).lt.0.01) then
                     snl(i,m,j) = 0
                     dzsnow1(i,m,j) = 0.0
                     dzsnow2(i,m,j) = 0.0
                     dzsnow3(i,m,j) = 0.0
                     dzsnow4(i,m,j) = 0.0
                     dzsnow5(i,m,j) = 0.0
               else
                if(snowdp(i,m,j).ge.0.01.and.snowdp(i,m,j).le.0.03) then
                   snl(i,m,j) = -1
                   dzsnow1(i,m,j) = snowdp(i,m,j)
                else if(snowdp(i,m,j).gt.0.03.and.snowdp(i,m,j).le.0.04) then
                   snl(i,m,j) = -2
                   dzsnow2(i,m,j) = snowdp(i,m,j)/2.
                   dzsnow1(i,m,j) = snowdp(i,m,j)/2.
                else if(snowdp(i,m,j).gt.0.04.and.snowdp(i,m,j).le.0.07) then
                   snl(i,m,j) = -2
                   dzsnow2(i,m,j) = 0.02
                   dzsnow1(i,m,j) = snowdp(i,m,j)- dzsnow2(i,m,j)
                else if(snowdp(i,m,j).gt.0.07.and.snowdp(i,m,j).le.0.12) then
                   snl(i,m,j) = -3
                   dzsnow3(i,m,j) = 0.02
                   dzsnow2(i,m,j) = (snowdp(i,m,j) - 0.02)/2.0
                   dzsnow1(i,m,j) = (snowdp(i,m,j) - 0.02)/2.0
                else if(snowdp(i,m,j).gt.0.12.and.snowdp(i,m,j).le.0.18) then
                   snl(i,m,j) = -3
                   dzsnow3(i,m,j) = 0.02
                   dzsnow2(i,m,j) = 0.05
                   dzsnow1(i,m,j)= snowdp(i,m,j)-dzsnow3(i,m,j)-dzsnow2(i,m,j)
                else if(snowdp(i,m,j).gt.0.18.and.snowdp(i,m,j).le.0.29) then
                   snl(i,m,j) = -4
                   dzsnow4(i,m,j) = 0.02
                   dzsnow3(i,m,j) = 0.05
                   dzsnow2(i,m,j) = (snowdp(i,m,j)-dzsnow4(i,m,j)-dzsnow3(i,m,j))/2.0
                   dzsnow1(i,m,j) = dzsnow2(i,m,j)
                else if(snowdp(i,m,j).gt.0.29.and.snowdp(i,m,j).le.0.41) then
                   snl(i,m,j) = -4
                   dzsnow4(i,m,j) = 0.02
                   dzsnow3(i,m,j) = 0.05
                   dzsnow2(i,m,j) = 0.11
                   dzsnow1(i,m,j) = snowdp(i,m,j)-dzsnow4(i,m,j)-dzsnow3(i,m,j)-dzsnow2(i,m,j)
                else if(snowdp(i,m,j).gt.0.41.and.snowdp(i,m,j).le.0.64) then
                   snl(i,m,j) = -5
                   dzsnow5(i,m,j) = 0.02
                   dzsnow4(i,m,j) = 0.05
                   dzsnow3(i,m,j) = 0.11
                   dzsnow2(i,m,j) = (snowdp(i,m,j)-dzsnow5(i,m,j)-dzsnow4(i,m,j)-dzsnow3(i,m,j))/2.0
                   dzsnow1(i,m,j) = (snowdp(i,m,j)-dzsnow5(i,m,j)-dzsnow4(i,m,j)-dzsnow3(i,m,j))/2.0
                else if(snowdp(i,m,j).gt.0.64) then
                   snl(i,m,j) = -5
                   dzsnow5(i,m,j) = 0.02
                   dzsnow4(i,m,j)= 0.05
                   dzsnow3(i,m,j) = 0.11
                   dzsnow2(i,m,j) = 0.23
                   dzsnow1(i,m,j) = snowdp(i,m,j)-dzsnow5(i,m,j)-dzsnow4(i,m,j)-dzsnow3(i,m,j)-dzsnow2(i,m,j)
                end if
            end if 
       end do
       end do
       end do

       do i=its,itf
          do j=jts,jtf
              h2ocan(i,:,j) = 0.0
              h2ocan_col(i,:,j) = 0.0

              SFCRUNOFF(i,j) = 0.0 
              UDRUNOFF(i,j) = 0.0

          end do
       end do



      do i=its,itf
      do j=jts,jtf
           t_soisno_s5(i,:,j) = -999.0 
           t_soisno_s4(i,:,j) = -999.0 
           t_soisno_s3(i,:,j) = -999.0 
           t_soisno_s2(i,:,j) = -999.0 
           t_soisno_s1(i,:,j) = -999.0 
           t_soisno1(i,:,j)   = -999.0 
           t_soisno2(i,:,j)   = -999.0 
           t_soisno3(i,:,j)   = -999.0 
           t_soisno4(i,:,j)   = -999.0 
           t_soisno5(i,:,j)   = -999.0 
           t_soisno6(i,:,j)   = -999.0 
           t_soisno7(i,:,j)   = -999.0 
           t_soisno8(i,:,j)   = -999.0 
           t_soisno9(i,:,j)   = -999.0 
           t_soisno10(i,:,j)  = -999.0 
                  
           t_lake1(i,:,j)     = -999.0 
           t_lake2(i,:,j)     = -999.0 
           t_lake3(i,:,j)     = -999.0 
           t_lake4(i,:,j)     = -999.0 
           t_lake5(i,:,j)     = -999.0 
           t_lake6(i,:,j)     = -999.0 
           t_lake7(i,:,j)     = -999.0 
           t_lake8(i,:,j)     = -999.0 
           t_lake9(i,:,j)     = -999.0 
           t_lake10(i,:,j)    = -999.0 

           lake_icefrac(i,:,j)= -999.0
           tlake(i,:,j)         = -999.0
           dzlake(i,:,j)      = -999.0
           zlake(i,:,j)       = -999.0
      end do
      end do

      do i=its,itf
      do j=jts,jtf
           do k=1,num_soil_layers
             if(ivgtyp(i,j).eq.24.and.tslb(i,k,j) .gt.tfrz) tslb(i,k,j)=tfrz
           end do
           t_soisno_s5(i,:,j) = tslb(i,1,j)
           t_soisno_s4(i,:,j) = tslb(i,1,j)
           t_soisno_s3(i,:,j) = tslb(i,1,j)
           t_soisno_s2(i,:,j) = tslb(i,1,j)
           t_soisno_s1(i,:,j) = tslb(i,1,j)
           t_soisno1(i,:,j) = tslb(i,1,j)
           t_soisno2(i,:,j) = tslb(i,2,j)
           t_soisno3(i,:,j) = tslb(i,3,j)
           t_soisno4(i,:,j) = tslb(i,4,j)
           t_soisno5(i,:,j) = tslb(i,5,j)
           t_soisno6(i,:,j) = tslb(i,6,j)
           t_soisno7(i,:,j) = tslb(i,7,j)
           t_soisno8(i,:,j) = tslb(i,8,j)
           t_soisno9(i,:,j) = tslb(i,9,j)
           t_soisno10(i,:,j)= tslb(i,10,j)

           t_grnd(i,:,j) = tslb(i,1,j)
           t_veg(i,:,j)  = tslb(i,1,j)
      end do 
      end do 

      do i=its,itf
      do j=jts,jtf
        if(lake(i,j)) then
              
              write(msg,*)'initializing lake at point i,j=', i, j,'in clminit'
              call CLMDebug(msg)
              t_lake1(i,:,j)     = 277.0 
              t_lake2(i,:,j)     = 277.0 
              t_lake3(i,:,j)     = 277.0 
              t_lake4(i,:,j)     = 277.0 
              t_lake5(i,:,j)     = 277.0 
              t_lake6(i,:,j)     = 277.0 
              t_lake7(i,:,j)     = 277.0 
              t_lake8(i,:,j)     = 277.0 
              t_lake9(i,:,j)     = 277.0 
              t_lake10(i,:,j)    = 277.0 
              t_soisno1(i,:,j) =   277.0
              t_soisno2(i,:,j) =   277.0
              t_soisno3(i,:,j) =   277.0
              t_soisno4(i,:,j) =   277.0
              t_soisno5(i,:,j) =   277.0
              t_soisno6(i,:,j) =   277.0
              t_soisno7(i,:,j) =   277.0
              t_soisno8(i,:,j) =   277.0
              t_soisno9(i,:,j) =   277.0
              t_soisno10(i,:,j)=   277.0
              t_grnd(i,:,j)      = 277.0
              tlake(i,:,j)         = 277.0
              lake_icefrac(i,:,j)  = 0.0
              if(domainlakedepth > 0.0) then
                 lakedepth(i,j)  = domainlakedepth
              
              else if(lakedepth(i,j) < 1 .or. lakedepth(i,j) > 2000) then
                 call wrf_error_fatal3("<stdin>",1435,&
'Default lake depth is less than zero but spatial lake depth has not been initialized in wrfinput')
              end if
              msg=''
              write(msg,*),'lake depth = ',lakedepth(i,j)
              call CLMDebug(msg)
              
              dzlake(i,1,j) = 0.1_r8
              dzlake(i,2,j) = 1._r8
              dzlake(i,3,j) = 2._r8
              dzlake(i,4,j) = 3._r8
              dzlake(i,5,j) = 4._r8
              dzlake(i,6,j) = 5._r8
              dzlake(i,7,j) = 7._r8
              dzlake(i,8,j) = 7._r8
              dzlake(i,9,j) = 10.45_r8
              dzlake(i,10,j)= 10.45_r8
              zlake(i,1,j) = 0.05
              do k=2,num_soil_layers
                 dzlake(i,k,j) = dzlake(i,k,j)*lakedepth(i,j)/50.0
                 zlake(i,k,j) = zlake(i,k-1,j) + (dzlake(i,k-1,j)+dzlake(i,k,j))/2
              end do
              
              savedtke1(i,j) = tkwat  
              call CLMDebug('Lake Depths, Thicknesses:')
              do k=1,num_soil_layers
                 msg=''
                 write(msg,*)zlake(i,k,j),dzlake(i,k,j)
                 call CLMDebug(msg)
              end do
        else
           lakedepth(i,j) = -999.0
        end if
      end do
      end do



      do i=its,itf
      do j=jts,jtf
         h2osoi_vol1(i,:,j)   = smois(i,1,j)
         h2osoi_vol2(i,:,j)   = smois(i,2,j)
         h2osoi_vol3(i,:,j)   = smois(i,3,j)
         h2osoi_vol4(i,:,j)   = smois(i,4,j)
         h2osoi_vol5(i,:,j)   = smois(i,5,j)
         h2osoi_vol6(i,:,j)   = smois(i,6,j)
         h2osoi_vol7(i,:,j)   = smois(i,7,j)
         h2osoi_vol8(i,:,j)   = smois(i,8,j)
         h2osoi_vol9(i,:,j)   = smois(i,9,j)
         h2osoi_vol10(i,:,j)  = smois(i,10,j)

         h2osoi_liq_s5(i,:,j) = 0.0
         h2osoi_liq_s4(i,:,j) = 0.0
         h2osoi_liq_s3(i,:,j) = 0.0
         h2osoi_liq_s2(i,:,j) = 0.0
         h2osoi_liq_s1(i,:,j) = 0.0
         h2osoi_ice_s5(i,:,j) = dzsnow5(i,:,j)*200
         h2osoi_ice_s4(i,:,j) = dzsnow4(i,:,j)*200
         h2osoi_ice_s3(i,:,j) = dzsnow3(i,:,j)*200
         h2osoi_ice_s2(i,:,j) = dzsnow2(i,:,j)*200
         h2osoi_ice_s1(i,:,j) = dzsnow1(i,:,j)*200

         do m = 1, maxpatch
          if(t_soisno1(i,m,j) <tfrz.and.t_soisno1(i,m,j)/=-999.0) then
             h2osoi_ice1(i,m,j)   = dzs(1)*0.917e3*h2osoi_vol1(i,m,j)
             h2osoi_liq1(i,m,j)   = 0.0
          else if (t_soisno1(i,m,j) >= tfrz) then
             h2osoi_ice1(i,m,j)   = 0.0
             h2osoi_liq1(i,m,j)   = dzs(1)*1000.0*h2osoi_vol1(i,m,j)
          end if

          if(t_soisno2(i,m,j) <tfrz.and.t_soisno2(i,m,j)/=-999.0) then
             h2osoi_ice2(i,m,j)   = dzs(2)*0.917e3*h2osoi_vol2(i,m,j)
             h2osoi_liq2(i,m,j)   = 0.0
          else if (t_soisno2(i,m,j) >= tfrz) then
             h2osoi_ice2(i,m,j)   = 0.0
             h2osoi_liq2(i,m,j)   = dzs(2)*1000.0*h2osoi_vol2(i,m,j)
          end if

          if(t_soisno3(i,m,j) <tfrz.and.t_soisno3(i,m,j)/=-999.0) then
             h2osoi_ice3(i,m,j)   = dzs(3)*0.917e3*h2osoi_vol3(i,m,j)
             h2osoi_liq3(i,m,j)   = 0.0
          else if (t_soisno3(i,m,j) >= tfrz) then
             h2osoi_ice3(i,m,j)   = 0.0
             h2osoi_liq3(i,m,j)   = dzs(3)*1000.0*h2osoi_vol3(i,m,j)
          end if

          if(t_soisno4(i,m,j) <tfrz.and.t_soisno4(i,m,j)/=-999.0) then
             h2osoi_ice4(i,m,j)   = dzs(4)*0.917e4*h2osoi_vol4(i,m,j)
             h2osoi_liq4(i,m,j)   = 0.0
          else if (t_soisno4(i,m,j) >= tfrz) then
             h2osoi_ice4(i,m,j)   = 0.0
             h2osoi_liq4(i,m,j)   = dzs(4)*1000.0*h2osoi_vol4(i,m,j)
          end if

          if(t_soisno5(i,m,j) <tfrz.and.t_soisno5(i,m,j)/=-999.0) then
             h2osoi_ice5(i,m,j)   = dzs(5)*0.917e4*h2osoi_vol5(i,m,j)
             h2osoi_liq5(i,m,j)   = 0.0
          else if (t_soisno5(i,m,j) >= tfrz) then
             h2osoi_ice5(i,m,j)   = 0.0
             h2osoi_liq5(i,m,j)   = dzs(5)*1000.0*h2osoi_vol5(i,m,j)
          end if

          if(t_soisno6(i,m,j) <tfrz.and.t_soisno6(i,m,j)/=-999.0) then
             h2osoi_ice6(i,m,j)   = dzs(6)*0.917e4*h2osoi_vol6(i,m,j)
             h2osoi_liq6(i,m,j)   = 0.0
          else if (t_soisno6(i,m,j) >= tfrz) then
             h2osoi_ice6(i,m,j)   = 0.0
             h2osoi_liq6(i,m,j)   = dzs(6)*1000.0*h2osoi_vol6(i,m,j)
          end if

          if(t_soisno7(i,m,j) <tfrz.and.t_soisno7(i,m,j)/=-999.0) then
             h2osoi_ice7(i,m,j)   = dzs(7)*0.917e4*h2osoi_vol7(i,m,j)
             h2osoi_liq7(i,m,j)   = 0.0
          else if (t_soisno7(i,m,j) >= tfrz) then
             h2osoi_ice7(i,m,j)   = 0.0
             h2osoi_liq7(i,m,j)   = dzs(7)*1000.0*h2osoi_vol7(i,m,j)
          end if

          if(t_soisno8(i,m,j) <tfrz.and.t_soisno8(i,m,j)/=-999.0) then
             h2osoi_ice8(i,m,j)   = dzs(8)*0.917e4*h2osoi_vol8(i,m,j)
             h2osoi_liq8(i,m,j)   = 0.0
          else if (t_soisno8(i,m,j) >= tfrz) then
             h2osoi_ice8(i,m,j)   = 0.0
             h2osoi_liq8(i,m,j)   = dzs(8)*1000.0*h2osoi_vol8(i,m,j)
          end if

          if(t_soisno9(i,m,j) <tfrz.and.t_soisno9(i,m,j)/=-999.0) then
             h2osoi_ice9(i,m,j)   = dzs(9)*0.917e4*h2osoi_vol9(i,m,j)
             h2osoi_liq9(i,m,j)   = 0.0
          else if (t_soisno9(i,m,j) >= tfrz) then
             h2osoi_ice9(i,m,j)   = 0.0
             h2osoi_liq9(i,m,j)   = dzs(9)*1000.0*h2osoi_vol9(i,m,j)
          end if

          if(t_soisno10(i,m,j) <tfrz.and.t_soisno10(i,m,j)/=-999.0) then
             h2osoi_ice10(i,m,j)   = dzs(10)*0.917e4*h2osoi_vol10(i,m,j)
             h2osoi_liq10(i,m,j)   = 0.0
          else if (t_soisno10(i,m,j) >= tfrz) then
             h2osoi_ice10(i,m,j)   = 0.0
             h2osoi_liq10(i,m,j)   = dzs(10)*1000.0*h2osoi_vol10(i,m,j)
          end if
        end do

      end do
      end do

  
      do i=its,itf
      do j=jts,jtf
        t2m_max(i,:,j)           = tslb(i,1,j)
        t2m_min(i,:,j)           = tslb(i,1,j)
        t2m_max_inst(i,:,j)      = tslb(i,1,j)
        t2m_min_inst(i,:,j)      = tslb(i,1,j)
        t_ref2m(i,:,j)           = tslb(i,1,j)
      end do
      end do

      do i=its,itf
      do j=jts,jtf
       do k=1, num_soil_layers
          if(tslb(i,k,j) >= tfrz )  then
            sh2o(i,k,j) = smois(i,k,j)
          else
            sh2o(i,k,j) = 0.0
          end if
       end do
      end do
      end do

 END SUBROUTINE clminit

END MODULE module_sf_clm
