



module surfFileMod


















  implicit none
  save


  public :: surfrd  








contains







  subroutine surfrd(veg, wt,iveg,isl,lndmsk)




























































    use shr_kind_mod, only: r8 => shr_kind_r8
    use clm_varpar                      
    use clm_varsur                      
    use pftvarcon, only : noveg, crop,nwheat  
    use clm_varcon,only : sand,clay,soic,plant,cover,num_landcover_types


    implicit none
    integer , intent(out) :: veg(lsmlon,lsmlat,maxpatch) 
    real(r8), intent(out) :: wt(lsmlon,lsmlat,maxpatch)  










    integer  :: iveg,isl,lndmsk


    integer  :: i,j,k,m,k1,k2                            
    integer  :: ncid,dimid,varid                         
    integer  :: ier                                      
    integer  :: pft(lsmlon,lsmlat,maxpatch_pft)          
    integer  :: cft(lsmlon,lsmlat,maxpatch_cft)          
    real(r8) :: pctpft_lunit(lsmlon,lsmlat,maxpatch_pft) 
    real(r8) :: pctcft_lunit(lsmlon,lsmlat,maxpatch_cft) 
    real(r8), allocatable :: pctpft(:,:,:)               
    real(r8) :: pctspec                                  
    integer  :: cropcount                                
    real(r8) :: sumscl                                   
    real(r8) :: sumvec(lsmlon,lsmlat)                    
    logical  :: found                                    
    integer  :: iindx, jindx                             
    integer  :: miss = 99999                             
    real(r8) :: wst(0:numpft)                            
    integer  :: wsti(maxpatch_pft)                       
    real(r8) :: wst_sum                                  
    real(r8) :: sumpct                                   
    real(r8) :: diff                                     
    real(r8) :: rmax                                     

       

       landmask(:,:) = -999
       landfrac(:,:) = -999.
       soic2d(:,:)   = -999
       sand3d(:,:,:) = -999.
       clay3d(:,:,:) = -999.
       pctlak(:,:)   = 0.0
       pctwet(:,:)   = 0.0
       pcturb(:,:)   = 0.0
       pctgla(:,:)   = 0.0
       pft(:,:,:)    = 0

       allocate (pctpft(lsmlon,lsmlat,0:numpft), stat=ier)
       pctpft(:,:,:) = 0.0


       

       do j=1,lsmlat
          numlon(j) = lsmlon
       end do

       do j=1,lsmlat
          do i=1,numlon(j)

           landmask(i,j)    = lndmsk

           soic2d(i,j) = soic(isl)

           do k=1,nlevsoi
             sand3d(i,j,k)  = sand(isl)
             clay3d(i,j,k)  = clay(isl)
           end do






           if (iveg > num_landcover_types) then
              print*, 'Vegtype exceeds number of allowed landcover types in clm_varcon.F.'
              call endrun()
           end if


           do m=1,maxpatch_pft
              pft(i,j,m)     = plant(iveg,m)
              if(cover(iveg,m).ne.0.0) then
                 pctpft(i,j,pft(i,j,m))  = cover(iveg,m)
              end if
           end do









           if(iveg == 17 .or. iveg == 18) then
              pctwet(i,j)      = 100.0 
           elseif(iveg.eq.16.and.landmask(i,j).eq.1) then
              pctlak(i,j)      = 100.0
           elseif(iveg.eq.24) then
              pctgla(i,j)      = 100.0
           end if
            
         end do
       end do

       


       sumvec(:,:) = abs(sum(pctpft,dim=3)-100.)
       do j=1,lsmlat
          do i=1,numlon(j)
             do m = 1, maxpatch_pft
                if (pft(i,j,m)<0 .or. pft(i,j,m)>numpft) then
                   write(6,*)'SURFRD error: invalid PFT for i,j,m=',i,j,m,pft(i,j,m)
                   call endrun
                end if
             end do
             if (sumvec(i,j)>1.e-04 .and. landmask(i,j)==1) then
                write(6,*)'SURFRD error: PFT cover ne 100 for i,j=',i,j
                do m=1,maxpatch_pft
                   write(6,*)'m= ',m,' pft= ',pft(i,j,m)
                end do
                write(6,*)'sumvec= ',sumvec(i,j)
                call endrun
             end if
          end do
       end do


          
          
          
          

          do j=1,lsmlat
             do i=1,numlon(j)
                cft(i,j,:) = 0
                pctcft_lunit(i,j,:) = 0.
                cropcount = 0
                pctspec = pcturb(i,j) + pctgla(i,j) + pctlak(i,j) + pctwet(i,j)
                if (pctspec < 100.) then
                   do m = 0, numpft
                      if (crop(m) == 1. .and. pctpft(i,j,m) > 0.) then
                         cropcount = cropcount + 1
                         if (cropcount > maxpatch_cft) then
                            write(6,*) 'ERROR surfFileMod: cropcount>maxpatch_cft'
                            call endrun()
                         end if
                         cft(i,j,cropcount) = m
                         pctcft_lunit(i,j,cropcount) = pctpft(i,j,m) * 100./(100.-pctspec)
                         pctpft(i,j,m) = 0.0
                      else if (crop(m) == 0.) then
                         pctpft(i,j,m) = pctpft(i,j,m) * 100./(100.-pctspec)
                      end if
                   end do
                else if (pctspec == 100.) then
                   pctpft(i,j,0)        = 100.
                   pctpft(i,j,1:numpft) =   0.
                end if
             end do
          end do

          
          

          do j=1,lsmlat
             do i=1,numlon(j)

                wst_sum = 0.
                sumpct = 0
                do m = 0, numpft
                   wst(m) = pctpft(i,j,m)
                   wst_sum = wst_sum + pctpft(i,j,m)
                end do

                

                if (landmask(i,j) == 1) call mkrank (numpft, wst, miss, wsti, maxpatch_pft)

                
                
                
                
                
                
                
                

                if (landmask(i,j) == 1) then       
                   do m = 1, maxpatch_pft
                      if (wsti(m) /=  miss) then
                         pft(i,j,m) = wsti(m)
                         pctpft_lunit(i,j,m) = wst(wsti(m))
                      else
                         pft(i,j,m) = noveg
                         pctpft_lunit(i,j,m) = 0.
                      end if
                      sumpct = sumpct + pctpft_lunit(i,j,m)
                   end do
                else                               
                   do m = 1, maxpatch_pft
                      pft(i,j,m) = 0
                      pctpft_lunit(i,j,m) = 0.
                   end do
                end if

                

                if (sumpct < wst_sum) then
                   diff  = wst_sum - sumpct
                   sumpct = 0.
                   do m = 1, maxpatch_pft
                      pctpft_lunit(i,j,m) = pctpft_lunit(i,j,m) + diff/maxpatch_pft
                      sumpct = sumpct + pctpft_lunit(i,j,m)
                   end do
                end if

                

                do m = 1,maxpatch_pft
                   if (pft(i,j,m) < 0 .or. pft(i,j,m) > numpft) then
                      write (6,*)'surfrd error: invalid PFT at gridcell i,j=',i,j,pft(i,j,m)
                      call endrun()
                   end if
                end do

                
                
                

                do m=1,maxpatch_pft
                   pctpft_lunit(i,j,m) = float(nint(pctpft_lunit(i,j,m)))
                end do
                do m=1,maxpatch_cft
                   pctcft_lunit(i,j,m) = float(nint(pctcft_lunit(i,j,m)))
                end do

                
                

                rmax = -9999.
                k1 = -9999
                k2 = -9999
                sumpct = 0.
                do m = 1, maxpatch_pft
                   sumpct = sumpct + pctpft_lunit(i,j,m)
                   if (pctpft_lunit(i,j,m) > rmax) then
                      k1 = m
                      rmax = pctpft_lunit(i,j,m)
                   end if
                end do
                do m = 1, maxpatch_cft
                   sumpct = sumpct + pctcft_lunit(i,j,m)
                   if (pctcft_lunit(i,j,m) > rmax) then
                      k2 = m
                      rmax = pctcft_lunit(i,j,m)
                   end if
                end do
                if (k1 == -9999 .and. k2 == -9999) then
                   write(6,*)'surfrd error: largest PFT patch not found'
                   call endrun()
                else if (landmask(i,j) == 1) then
                   if (sumpct < 95 .or. sumpct > 105.) then
                      write(6,*)'surfrd error: sum of PFT cover =',sumpct,' at i,j=',i,j
                      call endrun()
                   else if (sumpct /= 100. .and. k2 /= -9999) then
                      pctcft_lunit(i,j,k2) = pctcft_lunit(i,j,k2) - (sumpct-100.)
                   else if (sumpct /= 100.) then
                      pctpft_lunit(i,j,k1) = pctpft_lunit(i,j,k1) - (sumpct-100.)
                   end if
                end if

                

                sumpct = 0.
                do m = 1, maxpatch_pft
                   sumpct = sumpct + pctpft_lunit(i,j,m)
                end do
                do m = 1, maxpatch_cft
                   sumpct = sumpct + pctcft_lunit(i,j,m)
                end do
                if (landmask(i,j) == 1) then
                   if (abs(sumpct - 100.) > 0.000001) then
                      write(6,*)'surfFileMod error: sum(pct) over maxpatch_pft is not = 100.'
                      write(6,*)sumpct, i,j
                      call endrun()
                   end if
                   if (sumpct < -0.000001) then
                      write(6,*)'surfFileMod error: sum(pct) over maxpatch_pft is < 0.'
                      write(6,*)sumpct, i,j
                      call endrun()
                   end if
                end if

             end do   
          end do   

          deallocate(pctpft)


       

       found = .false.
       do j=1,lsmlat
          do i=1,numlon(j)
             sumscl = pctlak(i,j)+pctwet(i,j)+pcturb(i,j)+pctgla(i,j)
             if (sumscl > 100.+1.e-04) then
                found = .true.
                iindx = i
                jindx = j
                exit
             end if
          end do
          if (found) exit
       end do
       if ( found ) then
          write(6,*)'surfrd error: PFT cover>100 for i,j=',iindx,jindx
          call endrun()
       end if

       


       found = .false.
       do j=1,lsmlat
          do i=1,numlon(j)
             if (pcturb(i,j) /= 0.) then
                found = .true.
                iindx = i
                jindx = j
                exit
             end if
          end do
          if (found) exit
       end do
       if ( found ) then
          write (6,*)'surfrd error: urban parameterization not implemented at i,j= ',iindx,jindx
          call endrun()
       end if


    
    
    
    
    
    

    veg(:,:,:) = 0
    wt(:,:,:)  = 0.
    do j=1,lsmlat
       do i=1,numlon(j)
          if (landmask(i,j) == 1) then
             sumscl = pcturb(i,j)+pctlak(i,j)+pctwet(i,j)+pctgla(i,j)
             do m = 1, maxpatch_pft




                veg(i,j,m) = pft(i,j,m)
                wt(i,j,m) = pctpft_lunit(i,j,m) * (100.-sumscl)/10000.

             end do
             veg(i,j,npatch_urban) = noveg
             wt(i,j,npatch_urban) = pcturb(i,j)/100.
             veg(i,j,npatch_lake)  = noveg
             wt(i,j,npatch_lake)  = pctlak(i,j)/100.
             veg(i,j,npatch_wet)   = noveg
             wt(i,j,npatch_wet)   = pctwet(i,j)/100.
             veg(i,j,npatch_glacier) = noveg
             wt(i,j,npatch_glacier) = pctgla(i,j)/100.

             do m = 1,maxpatch_cft




                   veg(i,j,npatch_glacier+m) = cft(i,j,m)
                   wt(i,j,npatch_glacier+m)= pctcft_lunit(i,j,m) * (100.-sumscl)/10000.

            end do
          end if
       end do
    end do

    found = .false.
    sumvec(:,:) = abs(sum(wt,dim=3)-1.)
    do j=1,lsmlat
       do i=1,numlon(j)
          if (sumvec(i,j) > 1.e-06 .and. landmask(i,j)==1) then
             found = .true.
             iindx = i
             jindx = j
             exit
          endif
       end do
       if (found) exit
    end do
    if ( found ) then
       write (6,*)'surfrd error: WT > 1 occurs at i,j= ',iindx,jindx
       call endrun()
    end if

  end subroutine surfrd

end module surfFileMod
