 subroutine biochem_to_wrf(t_mo_min  ,annpsn     ,annpsnpot  ,fmicr     ,&
                          bm_inc     ,afmicr     ,t10min     ,tmomin20  ,&
                          agdd20     ,fpcgrid    ,lai_ind    ,crownarea ,&
                          dphen      ,leafon     ,leafof     ,firelength,&
                          litterag   ,litterbg   ,cpool_fast ,cpool_slow,&
                          k_fast_ave ,k_slow_ave ,nind       ,lm_ind    ,&
                          sm_ind     ,hm_ind     ,rm_ind     ,present   ,&
                          litter_decom_ave)

#if (defined DGVM)
!-----------------------------------------------------------------------
! !USES:
  use shr_kind_mod, only: r8 => shr_kind_r8
    use clmtype
    use decompMod, only : get_proc_bounds
!
! !PUBLIC TYPES:
  implicit none
  save
!-----------------------------------------------------------------------
! !LOCAL VARIABLES:
    integer :: c,p          ! indices
    integer :: begp, endp   ! per-proc beginning and ending pft indices
    integer :: begc, endc   ! per-proc beginning and ending column indices
    integer :: begl, endl   ! per-proc beginning and ending landunit indices
    integer :: begg, endg   ! per-proc gridcell ending gridcell indices

! The following vraiables for MM5 and restart run
    real(r8):: t_mo_min(maxpatch)            !annual min of t_mo (Kelvin)
    real(r8):: annpsn(maxpatch)              !annual photosynthesis (umol CO2 /m**2)
    real(r8):: annpsnpot(maxpatch)           !annual potential photosynthesis (same units)
    real(r8):: fmicr(maxpatch)               !microbial respiration (umol CO2 /m**2 /s)
    real(r8):: bm_inc(maxpatch)              !biomass increment
    real(r8):: afmicr(maxpatch)              !microbial respiration (Rh) for each naturally-vegetated pft
    real(r8):: t10min(maxpatch)              !annual minimum of 10-day running mean (K)
    real(r8):: tmomin20(maxpatch)            !20-yr running mean of tmomin
    real(r8):: agdd20(maxpatch)              !20-yr running mean of agdd
    real(r8):: fpcgrid(maxpatch)             !foliar projective cover on gridcell (fraction)
    real(r8):: lai_ind(maxpatch)             !LAI per individual
    real(r8):: crownarea(maxpatch)           !area that each individual tree takes up (m^2)
    real(r8):: dphen(maxpatch)               !phenology [0 to 1]
    real(r8):: leafon(maxpatch)              !leafon days
    real(r8):: leafof(maxpatch)              !leafoff days
    real(r8):: firelength(maxpatch)          !fire season in days
    real(r8):: litterag(maxpatch)            !above ground litter
    real(r8):: litterbg(maxpatch)            !below ground litter
    real(r8):: cpool_fast(maxpatch)          !fast carbon pool
    real(r8):: cpool_slow(maxpatch)          !slow carbon pool
    real(r8):: k_fast_ave(maxpatch)          !decomposition rate
    real(r8):: k_slow_ave(maxpatch)          !decomposition rate
    real(r8):: litter_decom_ave(maxpatch)    !decomposition rate
    real(r8):: nind(maxpatch)                !number of individuals (#/m**2)
    real(r8):: lm_ind(maxpatch)              !individual leaf mass
    real(r8):: sm_ind(maxpatch)              !individual sapwood mass
    real(r8):: hm_ind(maxpatch)              !individual heartwood mass
    real(r8):: rm_ind(maxpatch)              !individual root mass
    logical :: present(maxpatch)             !whether PFT present in patch
!-----------------------------------------------------------------------
    ! Determine necessary subgrid bounds

    call get_proc_bounds(begg, endg, begl, endl, begc, endc, begp, endp)

    ! pft type dgvm physical state - t_mo_min
    do p = begp,endp
       t_mo_min(p) = clm3%g%l%c%p%pdgvs%t_mo_min(p) 
    end do

    ! pft type dgvm physical state - annpsn
    do p = begp,endp
       annpsn(p) =  clm3%g%l%c%p%pdgvs%annpsn(p) 
    end do

    ! pft type dgvm physical state - annpsnpot
    do p = begp,endp
       annpsnpot(p) = clm3%g%l%c%p%pdgvs%annpsnpot(p) 
    end do

    ! pft cflux tye - fmicr
    do p = begp,endp
       fmicr(p) =  clm3%g%l%c%p%pcf%fmicr(p)
    end do

    ! pft type dgvm physical state - bm_inc
    do p = begp,endp
       bm_inc(p) = clm3%g%l%c%p%pdgvs%bm_inc(p)
    end do

    ! pft type dgvm physical state - afmicr
    do p = begp,endp
       afmicr(p) = clm3%g%l%c%p%pdgvs%afmicr(p)
    end do

    ! pft type dgvm physical state - t10min
    do p = begp,endp
       t10min(p) = clm3%g%l%c%p%pdgvs%t10min(p) 
    end do

    ! pft type dgvm physical state - tmomin20
    do p = begp,endp
       tmomin20(p) = clm3%g%l%c%p%pdgvs%tmomin20(p) 
    end do

    ! pft type dgvm physical state - agdd20
    do p = begp,endp
       agdd20(p) = clm3%g%l%c%p%pdgvs%agdd20(p) 
    end do

    ! pft type dgvm physical state - fpcgrid
    do p = begp,endp
       fpcgrid(p) = clm3%g%l%c%p%pdgvs%fpcgrid(p)
    end do

    ! pft type dgvm physical state - lai_ind
    do p = begp,endp
       lai_ind(p) = clm3%g%l%c%p%pdgvs%lai_ind(p) 
    end do

    ! pft type dgvm physical state - crownarea
    do p = begp,endp
       crownarea(p) = clm3%g%l%c%p%pdgvs%crownarea(p) 
    end do

    ! pft type dgvm physical state - dphen
    do p = begp,endp
       dphen(p) = clm3%g%l%c%p%pdgvs%dphen(p) 
    end do

    ! pft type dgvm physical state - leafon
    do p = begp,endp
       leafon(p) =  clm3%g%l%c%p%pdgvs%leafon(p) 
    end do

    ! pft type dgvm physical state - leafof
    do p = begp,endp
       leafof(p) = clm3%g%l%c%p%pdgvs%leafof(p) 
    end do

    ! pft type dgvm physical state - firelength
    do p = begp,endp
       firelength(p)= clm3%g%l%c%p%pdgvs%firelength(p) 
    end do

    ! pft type dgvm physical state - litterag
    do p = begp,endp
       litterag(p) =  clm3%g%l%c%p%pdgvs%litterag(p) 
    end do

    ! pft type dgvm physical state - litterbg
    do p = begp,endp
       litterbg(p) = clm3%g%l%c%p%pdgvs%litterbg(p) 
    end do

    ! pft type dgvm physical state - cpool_fast
    do p = begp,endp
       cpool_fast(p) = clm3%g%l%c%p%pdgvs%cpool_fast(p) 
    end do

    ! pft type dgvm physical state - cpool_slow
    do p = begp,endp
       cpool_slow(p) = clm3%g%l%c%p%pdgvs%cpool_slow(p) 
    end do

    ! pft type dgvm physical state - k_fast_ave
    do p = begp,endp
       k_fast_ave(p) = clm3%g%l%c%p%pdgvs%k_fast_ave(p) 
    end do

    ! pft type dgvm physical state - k_slow_ave
    do p = begp,endp
       k_slow_ave(p) = clm3%g%l%c%p%pdgvs%k_slow_ave(p) 
    end do

    ! pft type dgvm physical state - litter_decom_ave
    do p = begp,endp
       litter_decom_ave(p) = clm3%g%l%c%p%pdgvs%litter_decom_ave(p) 
    end do

    ! pft type dgvm physical state - nind
    do p = begp,endp
       nind(p) = clm3%g%l%c%p%pdgvs%nind(p) 
    end do

    ! pft type dgvm physical state - lm_ind
    do p = begp,endp
       lm_ind(p) = clm3%g%l%c%p%pdgvs%lm_ind(p) 
    end do

    ! pft type dgvm physical state - sm_ind
    do p = begp,endp
       sm_ind(p) = clm3%g%l%c%p%pdgvs%sm_ind(p) 
    end do

    ! pft type dgvm physical state - hm_ind
    do p = begp,endp
       hm_ind(p) = clm3%g%l%c%p%pdgvs%hm_ind(p) 
    end do

    ! pft type dgvm physical state - rm_ind
    do p = begp,endp
       rm_ind(p) = clm3%g%l%c%p%pdgvs%rm_ind(p) 
    end do

    ! pft type dgvm physical state - present
    do p = begp,endp
      present(p) =  clm3%g%l%c%p%pdgvs%present(p)
    end do

#endif
  end subroutine biochem_to_wrf

