MODULE lake_const
    implicit none 
    integer, parameter ::      r8 = selected_real_kind(12) 

!parameter:
    integer, parameter :: nlevsoi     =  10   ! number of soil layers
    integer, parameter :: nlevlak     =  10   ! number of lake layers
    integer, parameter :: nlevsno     =   5   ! maximum number of snow layers

    integer,parameter  ::     lbp = 1                        ! pft-index bounds
    integer,parameter  ::     ubp = 1
    integer,parameter  ::     lbc = 1                        ! column-index bounds
    integer,parameter  ::     ubc = 1
    integer,parameter  ::     num_shlakec       = 1          ! number of columns in lake filter
    integer,parameter  ::     filter_shlakec(1) = 1          ! lake filter (columns)
    integer,parameter  ::     num_shlakep       = 1          ! number of pfts in lake filter
    integer,parameter  ::     filter_shlakep(1) = 1          ! lake filter (pfts)
    integer,parameter  ::     pcolumn(1)        = 1  
    integer,parameter  ::     pgridcell(1)      = 1  
    integer,parameter  ::     cgridcell(1)      = 1          ! gridcell index of column
    integer,parameter  ::     clandunit(1)      = 1          ! landunit index of column
  
    integer,parameter  ::     begg = 1
    integer,parameter  ::     endg = 1
    integer,parameter  ::     begl = 1
    integer,parameter  ::     endl = 1
    integer,parameter  ::     begc = 1
    integer,parameter  ::     endc = 1
    integer,parameter  ::     begp = 1
    integer,parameter  ::     endp = 1

    integer,parameter  ::     column    =1
    logical,parameter  ::     lakpoi(1) = .true.
   



!Initialize physical constants:
    real(r8), parameter :: vkc    = 0.4_r8       !von Karman constant [-]
    real(r8), parameter :: pie    = 3.141592653589793_r8 ! pi
    real(r8), parameter :: grav   = 9.80616_r8   !gravity constant [m/s2]
    real(r8), parameter :: sb     = 5.67e-8_r8   !stefan-boltzmann constant  [W/m2/K4]
    real(r8), parameter :: tfrz   = 273.16_r8    !freezing temperature [K]
    real(r8), parameter :: denh2o = 1.000e3_r8   !density of liquid water [kg/m3]
    real(r8), parameter :: denice = 0.917e3_r8   !density of ice [kg/m3]
    real(r8), parameter :: cpice  = 2.11727e3_r8 !Specific heat of ice [J/kg-K]
    real(r8), parameter :: cpliq  = 4.188e3_r8   !Specific heat of water [J/kg-K]
    real(r8), parameter :: hfus   = 3.337e5_r8   !Latent heat of fusion for ice [J/kg]
    real(r8), parameter :: hvap   = 2.501e6_r8   !Latent heat of evap for water [J/kg]
    real(r8), parameter :: hsub   = 2.501e6_r8+3.337e5_r8 !Latent heat of sublimation    [J/kg]
    real(r8), parameter :: rair   = 287.0423_r8  !gas constant for dry air [J/kg/K]
    real(r8), parameter :: cpair  = 1.00464e3_r8 !specific heat of dry air [J/kg/K]
    real(r8), parameter :: tcrit  = 2.5          !critical temperature to determine rain or snow
    real(r8), parameter :: tkwat  = 0.6          !thermal conductivity of water [W/m/k]
    real(r8), parameter :: tkice  = 2.290        !thermal conductivity of ice   [W/m/k]
    real(r8), parameter :: tkair  = 0.023        !thermal conductivity of air   [W/m/k]
    real(r8), parameter :: bdsno = 250.            !bulk density snow (kg/m**3)
    
    real(r8), public, parameter :: spval = 1.e36  !special value for missing data (ocean)


    
   ! These are tunable constants
    real(r8), parameter :: wimp   = 0.05    !Water impremeable if porosity less than wimp
    real(r8), parameter :: ssi    = 0.033   !Irreducible water saturation of snow
    real(r8), parameter :: cnfac  = 0.5     !Crank Nicholson factor between 0 and 1


   ! Initialize water type constants
    integer,parameter :: istsoil = 1  !soil         "water" type
    integer, private  :: i  ! loop index 
    real(r8) :: dtime                                    ! land model time step (sec)

    real(r8) :: zlak(1:nlevlak)     !lake z  (layers)
    real(r8) :: dzlak(1:nlevlak)    !lake dz (thickness)
    real(r8) :: zsoi(1:nlevsoi)     !soil z  (layers)
    real(r8) :: dzsoi(1:nlevsoi)    !soil dz (thickness)
    real(r8) :: zisoi(0:nlevsoi)    !soil zi (interfaces)  


    real(r8) :: sand(19)                           ! percent sand
    real(r8) :: clay(19)                           ! percent clay

    data(sand(i), i=1,19)/92.,80.,66.,20.,5.,43.,60.,&
      10.,32.,51., 6.,22.,39.7,0.,100.,54.,17.,100.,92./

    data(clay(i), i=1,19)/ 3., 5.,10.,15.,5.,18.,27.,&
      33.,33.,41.,47.,58.,14.7,0., 0., 8.5,54.,  0., 3./

END MODULE lake_const

