PROGRAM mm52wrf

   USE date_time
#ifdef MPP1
   USE daves_pretend_dm
#endif
   USE diags
   USE interp
   USE mm5_input
   USE namelist_info

   IMPLICIT NONE

   !  MM5 input big header data.
   
   INTEGER :: ins_mm5 , jew_mm5, ktd_mm5
   REAL    :: ptop , p0  , ts0 , tlp , tiso

   !  NAMELIST RECORD 0

   CHARACTER (LEN=132) :: mm5_file_name , lowbdy_file_name

   !  NAMELIST RECORD 1

   REAL    :: dzetaw
   INTEGER :: numzeta

   LOGICAL :: ldum

   INTEGER :: loop , var_loop , k

   REAL :: zetatop

   !  Date stuff

   INTEGER :: julyr , julday 
   REAL    :: gmt

   !  Pull in the NAMELIST data.

   CALL proc_namelist

   mm5_file_name = TRIM(nml%rec0%mm5_file_name)
   lowbdy_file_name = TRIM(nml%rec0%lowbdy_file_name)

   dzetaw  = nml%rec1%dzetaw
   numzeta = nml%rec1%numzeta
   zetatop = numzeta * dzetaw

   !  Now we want the MM5 input data, but just the header info at the beginning.

   CALL proc_mm5_header ( mm5_file_name , lowbdy_file_name )

   !  Particularly salient features of the MM5 input header are the following.

   ins_mm5 = bhi_mm5(16,1)
   jew_mm5 = bhi_mm5(17,1)
   ktd_mm5 = bhi_mm5(12,bhi_mm5(1,1))

   ptop    = bhr_mm5(2,2)
   p0      = bhr_mm5(2,5)
   ts0     = bhr_mm5(3,5)
   tlp     = bhr_mm5(4,5)
   tiso    = MAX ( bhr_mm5(5,5) , 0. )

   !  ALLOCATE some pointers to MM5 input arrays and actual space for
   !  the accompanying small headers.  

   ALLOCATE ( all_mm5_3d( 20) )
   ALLOCATE ( all_mm5_2d(100) )
   ALLOCATE ( all_mm5_1d( 10) )

   ALLOCATE ( all_wrf_3d( 20) )
   ALLOCATE ( all_wrf_2d(100) )
   ALLOCATE ( all_wrf_1d( 10) )


   !  Loop over all of the input MM5 times.

   loop = 0
   all_times : DO

      num_mm5 = 0
      num_wrf = 0

      loop = loop + 1

      !  Pull in the MM5 data and load it up in the arrays: all_mm5_3d, 
      !  all_mm5_2d, and all_mm5_1d.  The gridded data and the supporting
      !  small headers are in there.  After this call the MM5 data has been
      !  horizontally interpolated to the correct WRF staggering, and the data 
      !  has been vertically flipped to a bottom-up orientation, to make the
      !  MM5 to WRF interpolations easier.
   
      CALL read_mm5 ( numzeta )
      CALL read_lowbdy
print *,'processing data at ',all_mm5_3d(1)%sh%current_date

      !  With a few MM5 fields, compute the total pressure.

      CALL compute_total_press ( jew_mm5 , ins_mm5 , ktd_mm5 , numzeta , ptop )

      !  With a few MM5 fields, compute the potential temperature.

      CALL compute_theta ( jew_mm5 , ins_mm5 , ktd_mm5 , numzeta )

      !  With a few MM5 fields, compute the density.

      CALL compute_density ( jew_mm5 , ins_mm5 , ktd_mm5 , numzeta )

      !  The required 2d fields are diagnosed.
 
      CALL compute_2d ( jew_mm5 , ins_mm5 , ktd_mm5 , zetatop )

      !  With a few MM5 fields, compute the surface pressure.

      CALL compute_surface_p ( jew_mm5 , ins_mm5 , ktd_mm5 , ptop )
   
      !  What do we do the first time through this loop.
   
      IF ( loop .EQ. 1 ) THEN

         !  Compute the height at each MM5 location during the first time

         CALL compute_height_mm5 ( jew_mm5 , ins_mm5 , ktd_mm5 , &
                                   ptop , p0 , ts0 , tlp , tiso , &
                                   zetatop , numzeta , dzetaw )
   
         !  Compute the height at each WRF location.
   
         CALL compute_height_wrf ( jew_mm5 , ins_mm5 , numzeta , dzetaw , zetatop )

      END IF

      !  Vertically interpolate the data to the WRF levels.

      CALL vinterp ( zt_mm5 , zu_mm5 , zv_mm5 , zw_mm5 , jew_mm5 , ins_mm5 , ktd_mm5 , &
                     zt_wrf , zu_wrf , zv_wrf , zw_wrf , numzeta )
   
      !  DEALLOCATE the MM5 and WRF space from this time period.

      DO var_loop = 1 , num_mm5(3)
         DEALLOCATE ( all_mm5_3d(var_loop)%data )
      END DO

      !  Output the 2d arrays from MM5.

      CALL geth_julgmt ( all_mm5_3d(1)%sh%current_date , julyr , julday , gmt )

      DO var_loop = 1 , num_mm5(2)

         !  First time loop open the file for output.

         IF ( var_loop .EQ. 1 ) THEN
            OPEN(FILE='wrf_input.d01.'//all_mm5_3d(1)%sh%current_date(1:19), &
                 UNIT=12, &
                 STATUS='UNKNOWN', & 
                 ACCESS='SEQUENTIAL', &
                 FORM='UNFORMATTED')
            WRITE (12) jew_mm5 , ins_mm5 , numzeta+1 , bhic_mm5(23,1)(1:4) , &
                       bhi_mm5(23,1) , gmt , julday , julyr , bhr_mm5(2,1) , &
                       bhr_mm5(9,1) , bhi_mm5(7,1) , bhr_mm5(5,1) , bhr_mm5(6,1) , &
                       bhr_mm5(3,1)
         END IF
         WRITE (12) all_mm5_2d(var_loop)%sh%name(1:8)
         WRITE (12) all_mm5_2d(var_loop)%data
      END DO

      DO var_loop = 1 , num_mm5(1)
         DEALLOCATE ( all_mm5_1d(var_loop)%data )
      END DO

      !  Output the 3d arrays.

      DO var_loop = 1 , num_wrf(3)
         WRITE (12) all_wrf_3d(var_loop)%sh%name(1:8)
         write (12) all_wrf_3d(var_loop)%data
         DEALLOCATE ( all_wrf_3d(var_loop)%data )
      END DO

      WRITE (12) 'Z       '
      write (12) zt_wrf
     
      !  Output the special WRF 2d arrays.

      DO var_loop = 1 , num_wrf(2)
         WRITE (12) all_wrf_2d(var_loop)%sh%name(1:8)
         WRITE (12) all_wrf_2d(var_loop)%data
         DEALLOCATE ( all_wrf_2d(var_loop)%data )
      END DO

      DO var_loop = 1 , num_wrf(1)
         WRITE (12) all_wrf_1d(var_loop)%sh%name(1:8)
         WRITE (12) all_wrf_1d(var_loop)%data
!        DEALLOCATE ( all_wrf_1d(var_loop)%data )
      END DO

print *,'domain size: x=',jew_mm5,'  y=',ins_mm5,'  z=',numzeta+1 

   END DO all_times

END PROGRAM mm52wrf
