MODULE interp

CONTAINS

   SUBROUTINE vinterp ( zt_mm5 , zu_mm5 , zv_mm5 , zw_mm5 , ix , jx , kx_mm5 , &
                        zt_wrf , zu_wrf , zv_wrf , zw_wrf , kx_wrf )
 
      USE mm5_input

      IMPLICIT NONE

      INTEGER , INTENT(IN) :: ix , jx , kx_mm5 , kx_wrf

      REAL , INTENT(IN) , DIMENSION(ix,jx,kx_mm5+1) ::  zt_mm5 , zu_mm5 , zv_mm5 , zw_mm5
      REAL , INTENT(IN) , DIMENSION(ix,jx,kx_wrf+1) ::  zt_wrf , zu_wrf , zv_wrf , zw_wrf

      INTEGER :: i , j , km , kw , loop

      !  Process the 3d data.

      all_3d : DO loop = 1 , num_mm5(3)

         IF      ( all_mm5_3d(loop)%sh%name(1:8) .EQ. 'U       ' ) THEN
            DO kw = 1 , kx_wrf
               DO j = 1 , jx - 1
                  this_one_u : DO i = 1 , ix
!                    all_wrf_3d(loop)%data(i,j,1) = all_mm5_3d(loop)%data(i,j,1)
                     DO km = 1 , kx_mm5 - 1
                        IF ( ( zu_mm5(i,j,km)   .LE. zu_wrf(i,j,kw) ) .AND. &
                             ( zu_mm5(i,j,km+1) .GT. zu_wrf(i,j,kw) ) ) THEN
              all_wrf_3d(loop)%data(i,j,kw) = ( all_mm5_3d(loop)%data(i,j,km  ) * ( zu_mm5(i,j,km+1 ) - zu_wrf(i,j,kw) ) + &
                                          all_mm5_3d(loop)%data(i,j,km+1) * ( zu_wrf(i,j,kw)    - zu_mm5(i,j,km) ) ) / &
                                                           ( zu_mm5(i,j,km+1 ) - zu_mm5(i,j,km ) )
                           CYCLE this_one_u

                        END IF
                     END DO                  
                  END DO this_one_u                 
               END DO                  
            END DO                  
         ELSE IF ( all_mm5_3d(loop)%sh%name(1:8) .EQ. 'V       ' ) THEN
            DO kw = 1 , kx_wrf
               DO j = 1 , jx 
                  this_one_v : DO i = 1 , ix - 1
!                    all_wrf_3d(loop)%data(i,j,1) = all_mm5_3d(loop)%data(i,j,1)
                     DO km = 1 , kx_mm5 - 1
                        IF ( ( zv_mm5(i,j,km)   .LE. zv_wrf(i,j,kw) ) .AND. &
                             ( zv_mm5(i,j,km+1) .GT. zv_wrf(i,j,kw) ) ) THEN
         all_wrf_3d(loop)%data(i,j,kw) = ( all_mm5_3d(loop)%data(i,j,km  ) * ( zv_mm5(i,j,km+1 ) - zv_wrf(i,j,kw) ) + &
                                         all_mm5_3d(loop)%data(i,j,km+1) * ( zv_wrf(i,j,kw)    - zv_mm5(i,j,km) ) ) / &
                                                    ( zv_mm5(i,j,km+1 ) - zv_mm5(i,j,km ) )
                           CYCLE this_one_v

                        END IF
                     END DO                  
                  END DO this_one_v                 
               END DO                  
            END DO                  
         ELSE IF ( all_mm5_3d(loop)%sh%name(1:8) .EQ. 'W       ' ) THEN
            DO j = 1 , jx - 1
               DO i = 1 , ix - 1
                  all_wrf_3d(loop)%data(i,j,       1) = all_mm5_3d(loop)%data(i,j,       1)
               END DO                  
            END DO                  
            DO kw = 2 , kx_wrf + 1
               DO j = 1 , jx - 1
                  this_one_w : DO i = 1 , ix - 1
                     DO km = 1 , kx_mm5
                        IF ( ( zw_mm5(i,j,km)   .LE. zw_wrf(i,j,kw) ) .AND. &
                             ( zw_mm5(i,j,km+1) .GT. zw_wrf(i,j,kw) ) ) THEN
          all_wrf_3d(loop)%data(i,j,kw) = ( all_mm5_3d(loop)%data(i,j,km  ) * ( zw_mm5(i,j,km+1 ) - zw_wrf(i,j,kw) ) + &
                                          all_mm5_3d(loop)%data(i,j,km+1) * ( zw_wrf(i,j,kw)    - zw_mm5(i,j,km) ) ) / &
                                                           ( zw_mm5(i,j,km+1 ) - zw_mm5(i,j,km ) )
                           CYCLE this_one_w

                        END IF
                     END DO                  
                  END DO this_one_w                 
               END DO                  
            END DO                  
         ELSE
            DO kw = 1 , kx_wrf
               DO j = 1 , jx - 1
                  this_one_t : DO i = 1 , ix - 1
!                    all_wrf_3d(loop)%data(i,j,1) = all_mm5_3d(loop)%data(i,j,1)
                     DO km = 1 , kx_mm5 - 1
                        IF ( ( zt_mm5(i,j,km)   .LE. zt_wrf(i,j,kw) ) .AND. &
                             ( zt_mm5(i,j,km+1) .GT. zt_wrf(i,j,kw) ) ) THEN
          all_wrf_3d(loop)%data(i,j,kw) = ( all_mm5_3d(loop)%data(i,j,km  ) * ( zt_mm5(i,j,km+1 ) - zt_wrf(i,j,kw) ) + &
                                       all_mm5_3d(loop)%data(i,j,km+1) * ( zt_wrf(i,j,kw)    - zt_mm5(i,j,km) ) ) / &
                                                           ( zt_mm5(i,j,km+1 ) - zt_mm5(i,j,km ) )
                           CYCLE this_one_t

                        END IF
                     END DO                  
                  END DO this_one_t                 
               END DO                  
            END DO                  
         END IF

      END DO all_3d

   END SUBROUTINE vinterp

END MODULE interp
