MODULE namelist_info

   TYPE nml_record0
      CHARACTER (LEN=132) :: mm5_file_name
      CHARACTER (LEN=132) :: lowbdy_file_name
   END TYPE nml_record0

   TYPE nml_record1
      REAL                :: dzetaw
      INTEGER             :: numzeta
   END TYPE nml_record1

   TYPE nml_all
      TYPE(nml_record0) :: rec0
      TYPE(nml_record1) :: rec1
   END TYPE nml_all

   TYPE(nml_all)        :: nml

   INTEGER , PARAMETER , PRIVATE :: unit = 9

CONTAINS

   SUBROUTINE namelist_close

      IMPLICIT NONE 

      CLOSE ( UNIT = unit )

   END SUBROUTINE namelist_close

   SUBROUTINE namelist_open ( name )

      IMPLICIT NONE 

      CHARACTER (LEN=132) , INTENT(IN) :: name

      LOGICAL :: file_exist

      INQUIRE ( FILE      = TRIM(name)   , &
                EXIST     = file_exist     )
    
      IF ( file_exist ) THEN

         !  OPEN the NAMELIST logical unit.
   
         OPEN ( UNIT      = unit         , &
                FILE      = TRIM(name)   , & 
                STATUS    = 'OLD'        , &
                FORM      = 'FORMATTED'    )

      ELSE

         PRINT '(A)','Namelist file, ',TRIM(name),', does not exist.'
         STOP 'NO_namelist_file_found'

      END IF

   END SUBROUTINE namelist_open

   SUBROUTINE namelist_read

      IMPLICIT NONE 

      !  NAMELIST RECORD 0

      CHARACTER (LEN=132) :: mm5_file_name , lowbdy_file_name
      NAMELIST /record0/ mm5_file_name , lowbdy_file_name

      !  NAMELIST RECORD 1

      REAL    :: dzetaw
      INTEGER :: numzeta
      NAMELIST /record1/ dzetaw , numzeta

      INTEGER :: i
      INTEGER , DIMENSION(50) :: nml_read_errors = (/ (0 ,  i = 1 , 50) /)
         
      !  READ NAMELIST data.

      READ ( UNIT = unit , NML = record0 , IOSTAT = nml_read_errors(0) )
      READ ( UNIT = unit , NML = record1 , IOSTAT = nml_read_errors(1) )

      !  Check for any error conditions.

      IF ( MAXVAL(nml_read_errors) .GT. 0 ) THEN
         PRINT '(A)','Error reading the namelist file, namelist.input.  It exists.'
         DO i = 1 , 50 
            IF ( nml_read_errors(i) .NE. 0 ) THEN
               PRINT '(A,I2,A)','Error reading record #',i,'.  Did you remember the trailing "/".'
            END IF
         END DO
         STOP 'ERROR_reading_namelist_file'
      END IF

      !  Assign NAMELIST data to a single user-defined type.

      nml%rec0%mm5_file_name = TRIM ( mm5_file_name )
      nml%rec0%lowbdy_file_name = TRIM ( lowbdy_file_name )

      nml%rec1%dzetaw         = dzetaw
      nml%rec1%numzeta        = numzeta
    
   END SUBROUTINE namelist_read

END MODULE namelist_info
