MODULE util

CONTAINS


   SUBROUTINE b2c3d ( b , c , ix , jx , kx , staggering )

      IMPLICIT NONE

      !  This routine accepts 2-d or 3d-d arrays as input, that are
      !  on the Arakawa B staggering (with the MM5 i,j,k ordering). The
      !  output is on an Arakawa C staggering (with WRF i,j,k 
      !  ordering).

      !  Arguments

      INTEGER , INTENT(IN)                  :: ix , jx , kx
      CHARACTER (LEN=1) , INTENT(IN)        :: staggering
      REAL , DIMENSION(:,:,:) , INTENT(IN)  :: b
      REAL , DIMENSION(:,:,:) , INTENT(OUT) :: c

      !  Stack variables

      INTEGER :: i , j , k

      !  The input staggering selection depends on the 
      !  variable type.  The choices are "U", "V", "T".

      IF      ( staggering(1:1) .EQ. "T" ) THEN
!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( i , j , k )
         DO k = 1 , kx
            DO j = 1 , jx - 1
               DO i = 1 , ix - 1
                  c(i,j,k) = b(j,i,kx+1-k)
               END DO
            END DO
         END DO
      ELSE IF ( staggering(1:1) .EQ. "U" ) THEN
!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( i , j , k )
         DO k = 1 , kx
            DO j = 1 , jx - 1
               DO i = 1 , ix
                  c(i,j,k) = ( b(j,i,kx+1-k) + b(j+1,i,kx+1-k) ) * 0.5
               END DO
            END DO
         END DO
      ELSE IF ( staggering(1:1) .EQ. "V" ) THEN
!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( i , j , k )
         DO k = 1 , kx
            DO j = 1 , jx
               DO i = 1 , ix - 1
                  c(i,j,k) = ( b(j,i,kx+1-k) + b(j,i+1,kx+1-k) ) * 0.5
               END DO
            END DO
         END DO
      END IF
      
   END SUBROUTINE b2c3d

   SUBROUTINE b2c2d ( b , c , ix , jx , staggering )

      IMPLICIT NONE

      !  This routine accepts 2-d or 3d-d arrays as input, that are
      !  on the Arakawa B staggering (with the MM5 i,j ordering). The
      !  output is on an Arakawa C staggering (with WRF i,j 
      !  ordering).

      !  Arguments

      INTEGER , INTENT(IN)                  :: ix , jx
      CHARACTER (LEN=1) , INTENT(IN)        :: staggering
      REAL , DIMENSION(:,:)   , INTENT(IN)  :: b
      REAL , DIMENSION(:,:)   , INTENT(OUT) :: c

      !  Stack variables

      INTEGER :: i , j

      !  The input staggering selection depends on the 
      !  variable type.  The choices are "U", "V", "T".

      IF      ( staggering(1:1) .EQ. "T" ) THEN
!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( i , j )
         DO j = 1 , jx 
            DO i = 1 , ix 
               c(i,j) = b(j,i)
            END DO
         END DO
      ELSE IF ( staggering(1:1) .EQ. "U" ) THEN
!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( i , j )
         DO j = 1 , jx - 1
            DO i = 1 , ix
               c(i,j) = ( b(j,i) + b(j+1,i) ) * 0.5
            END DO
         END DO
      ELSE IF ( staggering(1:1) .EQ. "V" ) THEN
!$OMP PARALLEL DO DEFAULT ( SHARED ) PRIVATE ( i , j )
         DO j = 1 , jx
            DO i = 1 , ix - 1
               c(i,j) = ( b(j,i) + b(j,i+1) ) * 0.5
            END DO
         END DO
      END IF
      
   END SUBROUTINE b2c2d

END MODULE util
