#include <stdio.h>
#include <fcntl.h>

#ifdef WRF_MPI_IO
#include <mpi.h>
#endif
#ifdef WRF_RSL_IO
#include <rsl.h>
#endif

#ifdef DOUBLE_PRECISION
# define  REAL double
#else
# define  REAL float
#endif
#ifndef CRAY
# ifdef NOUNDERSCORE
#  define WRF_INIT_WRFIO   wrf_init_wrfio
#  define WRF_WRITE_0D     wrf_write_0d
#  define WRF_WRITE_KIJ    wrf_write_kij
#  define WRF_WRITE_IKJ    wrf_write_ikj
#  define WRF_WRITE_IJK    wrf_write_ijk
#  define WRF_WRITE_IJ     wrf_write_ij
#  define WRF_WRITE_K      wrf_write_k
#  define WRF_READ_0D     wrf_read_0d
#  define WRF_READ_KIJ    wrf_read_kij
#  define WRF_READ_IJK    wrf_read_ijk
#  define WRF_READ_IKJ    wrf_read_ikj
#  define WRF_READ_IJ     wrf_read_ij
#  define WRF_READ_K      wrf_read_k
#  define WRF_OPEN_R_DATASET wrf_open_r_dataset
#  define WRF_OPEN_W_DATASET wrf_open_w_dataset
#  define WRF_CLOSE_DATASET wrf_close_dataset
#  define FORTRAN_NAMED_OPEN_WRITE fortran_named_open_write
#  define FORTRAN_NAMED_OPEN_READ fortran_named_open_read
#  define FORTRAN_READ fortran_read
#  define FORTRAN_WRITE fortran_write
#  define FORTRAN_CLOSE fortran_close
# else
#   ifdef F2CSTYLE
#  define WRF_INIT_WRFIO   wrf_init_wrfio__
#  define WRF_WRITE_0D     wrf_write_0d__
#  define WRF_WRITE_KIJ    wrf_write_kij__
#  define WRF_WRITE_IJK    wrf_write_ijk__
#  define WRF_WRITE_IJ     wrf_write_ij__
#  define WRF_WRITE_K      wrf_write_k__
#  define WRF_READ_0D     wrf_read_0d__
#  define WRF_READ_KIJ    wrf_read_kij__
#  define WRF_READ_IJK    wrf_read_ijk__
#  define WRF_READ_IKJ    wrf_read_ikj__
#  define WRF_READ_IJ     wrf_read_ij__
#  define WRF_READ_K      wrf_read_k__
#  define WRF_OPEN_R_DATASET wrf_open_r_dataset__
#  define WRF_OPEN_W_DATASET wrf_open_w_dataset__
#  define WRF_CLOSE_DATASET wrf_close_dataset__
#  define FORTRAN_NAMED_OPEN_WRITE fortran_named_open_write__
#  define FORTRAN_NAMED_OPEN_READ fortran_named_open_read__
#  define FORTRAN_READ fortran_read__
#  define FORTRAN_WRITE fortran_write__
#  define FORTRAN_CLOSE fortran_close__
#   else
#  define WRF_INIT_WRFIO   wrf_init_wrfio_
#  define WRF_WRITE_0D     wrf_write_0d_
#  define WRF_WRITE_KIJ    wrf_write_kij_
#  define WRF_WRITE_IJK    wrf_write_ijk_
#  define WRF_WRITE_IKJ    wrf_write_ikj_
#  define WRF_WRITE_IJ     wrf_write_ij_
#  define WRF_WRITE_K      wrf_write_k_
#  define WRF_READ_0D     wrf_read_0d_
#  define WRF_READ_KIJ    wrf_read_kij_
#  define WRF_READ_IJK    wrf_read_ijk_
#  define WRF_READ_IKJ    wrf_read_ikj_
#  define WRF_READ_IJ     wrf_read_ij_
#  define WRF_READ_K      wrf_read_k_
#  define WRF_OPEN_R_DATASET wrf_open_r_dataset_
#  define WRF_OPEN_W_DATASET wrf_open_w_dataset_
#  define WRF_CLOSE_DATASET wrf_close_dataset_
#  define FORTRAN_NAMED_OPEN_WRITE fortran_named_open_write_
#  define FORTRAN_NAMED_OPEN_READ fortran_named_open_read_
#  define FORTRAN_READ fortran_read_
#  define FORTRAN_WRITE fortran_write_
#  define FORTRAN_CLOSE fortran_close_
#   endif
# endif
#endif

#ifndef WRF_MPI_IO
#define MPI_Offset int 
#define MPI_File int 
#define MPI_Datatype int 
#endif

typedef struct {
  int id ;
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset disp ;
  MPI_File   fh ;
  MPI_Datatype   type3d, type2d, type1d ;

} io_entry ;

static io_entry iotab[99] ;

static REAL *obuf ; 
static int obuf_sz = NULL ;


store_diminfo( id,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
		   ips, ipe, jps, jpe, kps, kpe,
                   disp, fh, type3d, type2d, type1d,
		   info )
  int *id ;
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset disp ;
  MPI_File   fh ;
  MPI_Datatype   type3d, type2d, type1d ;
{
  int i ;
  for ( i = 8 ; i < 99 ; i++ )
  {
    if ( iotab[i].id < 0 )
    {
      iotab[i].id = i ;
      *id = i ;
      iotab[i].ids = ids ;
      iotab[i].ide = ide ;
      iotab[i].jds = jds ;
      iotab[i].jde = jde ;
      iotab[i].kds = kds ;
      iotab[i].kde = kde ;
      iotab[i].ims = ims ;
      iotab[i].ime = ime ;
      iotab[i].jms = jms ;
      iotab[i].jme = jme ;
      iotab[i].kms = kms ;
      iotab[i].kme = kme ;
      iotab[i].ips = ips ;
      iotab[i].ipe = ipe ;
      iotab[i].jps = jps ;
      iotab[i].jpe = jpe ;
      iotab[i].kps = kps ;
      iotab[i].kpe = kpe ;
      iotab[i].disp = disp ;
      iotab[i].fh = fh ;
      iotab[i].info = info ;
      iotab[i].type3d = type3d ;
      iotab[i].type2d = type2d ;
      iotab[i].type1d = type1d ;
      break ;
    }
  }
}

set_diminfo( id,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe,
                   disp, fh, type3d, type2d, type1d,
		   info )
  int id ;
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset disp ;
  MPI_File   fh ;
  MPI_Datatype   type3d, type2d, type1d ;
{
  int i ;
  for ( i = 8 ; i < 99 ; i++ )
  {
    if ( iotab[i].id == id )
    {
      iotab[i].ids = ids ;
      iotab[i].ide = ide ;
      iotab[i].jds = jds ;
      iotab[i].jde = jde ;
      iotab[i].kds = kds ;
      iotab[i].kde = kde ;
      iotab[i].ims = ims ;
      iotab[i].ime = ime ;
      iotab[i].jms = jms ;
      iotab[i].jme = jme ;
      iotab[i].kms = kms ;
      iotab[i].kme = kme ;
      iotab[i].ips = ips ;
      iotab[i].ipe = ipe ;
      iotab[i].jps = jps ;
      iotab[i].jpe = jpe ;
      iotab[i].kps = kps ;
      iotab[i].kpe = kpe ;
      iotab[i].disp = disp ;
      iotab[i].fh = fh ;
      iotab[i].info = info ;
      iotab[i].type3d = type3d ;
      iotab[i].type2d = type2d ;
      iotab[i].type1d = type1d ;
      break ;
    }
  }
}

get_diminfo( id,
             ids, ide, jds, jde, kds, kde,
             ims, ime, jms, jme, kms, kme,
             ips, ipe, jps, jpe, kps, kpe,
             disp, fh, type3d, type2d, type1d,
	     info)
  int id ; 
  int *ids, *ide, *jds, *jde, *kds, *kde,
      *ims, *ime, *jms, *jme, *kms, *kme,
      *ips, *ipe, *jps, *jpe, *kps, *kpe ;
  int *info ;
  MPI_Offset **disp ;
  MPI_File   *fh ;
  MPI_Datatype   *type3d, *type2d, *type1d ;
{
  if ( id >= 8 && id <= 99 )
  {
    if ( iotab[id].id == id )
    {
      *ids = iotab[id].ids ;
      *ide = iotab[id].ide ;
      *jds = iotab[id].jds ;
      *jde = iotab[id].jde ;
      *kds = iotab[id].kds ;
      *kde = iotab[id].kde ;
      *ims = iotab[id].ims ;
      *ime = iotab[id].ime ;
      *jms = iotab[id].jms ;
      *jme = iotab[id].jme ;
      *kms = iotab[id].kms ;
      *kme = iotab[id].kme ;
      *ips = iotab[id].ips ;
      *ipe = iotab[id].ipe ;
      *jps = iotab[id].jps ;
      *jpe = iotab[id].jpe ;
      *kps = iotab[id].kps ;
      *kpe = iotab[id].kpe ;
      *disp = &(iotab[id].disp) ;
      *fh  = iotab[id].fh ;
      *info  = iotab[id].info ;
      *type3d  = iotab[id].type3d ;
      *type2d  = iotab[id].type2d ;
      *type1d  = iotab[id].type1d ;
      return ;
    }
  }
  fprintf(stderr,"io.c:get_diminfo: internal error\n") ;
  exit(1);
}

clear_diminfo( id )
  int id ;
{
  if ( id >= 0 && id <= 99 )
  {
    if ( iotab[id].id == id ) 
    {
      iotab[id].id = -1 ;
      iotab[id].disp = 0 ;
      iotab[id].fh = 0 ;
      iotab[id].info = 0 ;
      return ;
    }
  }
  fprintf(stderr,"io.c:clear_diminfo: internal error\n") ;
  exit(1);
}


WRF_INIT_WRFIO ()
{
  int i ;

  for ( i = 0 ; i < 99 ; i++ ) 
  {
    iotab[i].disp = 0 ;
    iotab[i].id = -1 ;
  }
}

WRF_OPEN_W_DATASET ( id,
                   intname, lenname, info,
		   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe )
  int *id ;
  int *intname ;
  int *lenname ;
  int *ids, *ide, *jds, *jde, *kds, *kde,
      *ims, *ime, *jms, *jme, *kms, *kme,
      *ips, *ipe, *jps, *jpe, *kps, *kpe ;
  int *info ;
{
  int mode ;
  mode = 1 ;
  wrf_open_dataset ( id,
                     &mode,
                     intname, lenname, info,
		     ids, ide, jds, jde, kds, kde,
                     ims, ime, jms, jme, kms, kme,
                     ips, ipe, jps, jpe, kps, kpe ) ;
}

WRF_OPEN_R_DATASET ( id,
                   intname, lenname, info,
		   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe )
  int *id ;
  int *intname ;
  int *lenname ;
  int *ids, *ide, *jds, *jde, *kds, *kde,
      *ims, *ime, *jms, *jme, *kms, *kme,
      *ips, *ipe, *jps, *jpe, *kps, *kpe ;
  int *info ;
{
  int mode ;
  mode = 0 ;
  wrf_open_dataset ( id,
                     &mode,
                     intname, lenname, info,
		     ids, ide, jds, jde, kds, kde,
                     ims, ime, jms, jme, kms, kme,
                     ips, ipe, jps, jpe, kps, kpe ) ;
}

wrf_open_dataset ( id,
                   mode,
                   intname, lenname, info,
		   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe )
  int *id ;
  int *mode ;
  int *intname ;
  int *lenname ;
  int *ids, *ide, *jds, *jde, *kds, *kde,
      *ims, *ime, *jms, *jme, *kms, *kme,
      *ips, *ipe, *jps, *jpe, *kps, *kpe ;
  int *info ;
{
  char fname[128] ;
  int i ;
  int array_of_sizes[3] ;
  int array_of_subsizes[3] ;
  int array_of_starts[3] ;
  MPI_Offset disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  for ( i = 0 ; i < *lenname ; i++ )
  {
    fname[i] = intname[i] ;
  }
  fname[i] = '\0' ;

/* This call returns with an ID; we may reset some of
   the other information with a call to set_diminfo at end */
  store_diminfo( id, 
	         *ids, *ide, *jds, *jde, *kds, *kde,
	         *ims, *ime, *jms, *jme, *kms, *kme,
	         *ips, *ipe, *jps, *jpe, *kps, *kpe, disp, fh,
	         type3d, type2d, type1d, *info ) ;

#if ! ( defined WRF_MPI_IO || defined WRF_RSL_IO )

  if ( *mode == 1 )
  {
    if (( fh = open ( fname, O_CREAT | O_WRONLY | O_TRUNC, 0666 )) < 0 )
    {
      fprintf(stderr,"failed to open %s for writing \n",fname ) ;
      perror("") ;
      exit(1) ;
    }
  }
  else
  {
    if (( fh = open ( fname, O_RDONLY, 0666 )) < 0 )
    {
      fprintf(stderr,"failed to open %s for reading \n",fname ) ;
      perror("") ;
      exit(1) ;
    }
  }

#else

# if defined WRF_MPI_IO

  if ( *mode == 1 ) 
  {
    if (( MPI_File_open ( MPI_COMM_WORLD, fname,
	  MPI_MODE_CREATE | MPI_MODE_WRONLY, MPI_INFO_NULL, &fh )) < 0 )
    {
      fprintf(stderr,"failed to open %s for writing \n",fname ) ;
      perror("") ;
      exit(1) ;
    }
  }
  else
  {
    if (( MPI_File_open ( MPI_COMM_WORLD, fname,
	  MPI_MODE_RDONLY, MPI_INFO_NULL, &fh )) < 0 )
    {
      fprintf(stderr,"failed to open %s for reading \n",fname ) ;
      perror("") ;
      exit(1) ;
    }
  }

/* define the types that set views here */

  array_of_sizes[0] = *kde-*kds+1 ;
  array_of_sizes[1] = *ide-*ids+1 ;
  array_of_sizes[2] = *jde-*jds+1 ;
  array_of_subsizes[0] = *kpe-*kps+1 ;
  array_of_subsizes[1] = *ipe-*ips+1 ;
  array_of_subsizes[2] = *jpe-*jps+1 ;
  array_of_starts[0] = *kps-1 ;
  array_of_starts[1] = *ips-1 ;
  array_of_starts[2] = *jps-1 ;

#if 0
fprintf(stderr,"array_of_subsizes %d %d %d\n",array_of_subsizes[0] ,array_of_subsizes[1] ,array_of_subsizes[2] ) ;
fprintf(stderr,"kps %d kpe %d\n",*kps,*kpe) ;
fprintf(stderr,"jps %d jpe %d\n",*jps,*jpe) ;
#endif

  MPI_Type_create_subarray ( 3, 
			     array_of_sizes,
			     array_of_subsizes,
			     array_of_starts,
			     MPI_ORDER_FORTRAN,
			     MPI_REAL,
			     &type3d ) ;
  MPI_Type_commit( &type3d ) ;

  array_of_sizes[0] = *ide-*ids+1 ;
  array_of_sizes[1] = *jde-*jds+1 ;
  array_of_subsizes[0] = *ipe-*ips+1 ;
  array_of_subsizes[1] = *jpe-*jps+1 ;
  array_of_starts[0] = *ips-1 ;
  array_of_starts[1] = *jps-1 ;
  MPI_Type_create_subarray ( 2, 
			     array_of_sizes,
			     array_of_subsizes,
			     array_of_starts,
			     MPI_ORDER_FORTRAN,
			     MPI_REAL,
			     &type2d ) ;
  MPI_Type_commit( &type2d ) ;

  array_of_sizes[0] = *kde-*kds+1 ;
  array_of_subsizes[0] = *kpe-*kps+1 ;
  array_of_starts[0] = *kps-1 ;
  MPI_Type_create_subarray ( 1, 
			     array_of_sizes,
			     array_of_subsizes,
			     array_of_starts,
			     MPI_ORDER_FORTRAN,
			     MPI_REAL,
			     &type1d ) ;
  MPI_Type_commit( &type1d ) ;

# endif

# if defined WRF_RSL_IO


  if ( *mode == 1 )
  {
    int ierr ;
    FORTRAN_NAMED_OPEN_WRITE ( fname , lenname , id , &ierr ) ;
    if ( ierr != 0 )
    {
      fprintf(stderr,"failed to open %s for writing \n",fname ) ;
      perror("") ;
      exit(1) ;
    }
  }
  else
  {
    int ierr ;
    FORTRAN_NAMED_OPEN_READ ( fname , lenname , id , &ierr ) ;
    if ( ierr != 0 )
    {
      fprintf(stderr,"failed to open %s for reading \n",fname ) ;
      perror("") ;
      exit(1) ;
    }
  }
 
# endif

#endif

  disp = 0 ;
  set_diminfo( *id, 
	       *ids, *ide, *jds, *jde, *kds, *kde,
	       *ims, *ime, *jms, *jme, *kms, *kme,
	       *ips, *ipe, *jps, *jpe, *kps, *kpe, disp, fh,
	       type3d, type2d, type1d, *info ) ;

}

WRF_CLOSE_DATASET ( id )
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype dummy ;
  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
		&dummy, &dummy, &dummy, &info ) ;

#if ! (defined WRF_MPI_IO || defined WRF_RSL_IO )
  close(fh) ;
#else
#  ifdef WRF_MPI_IO
  MPI_File_close(&fh) ;
#  endif
#  ifdef WRF_RSL_IO
   FORTRAN_CLOSE ( id ) ;
#  endif
#endif
  clear_diminfo( *id ) ;
}


WRF_WRITE_0D ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype dummy ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
		&dummy, &dummy, &dummy, &info ) ;

#ifdef WRF_MPI_IO
  dummy = MPI_REAL ;
#endif
  wrf_write_field( *id, v, 
		   1,1, 1,1, 1,1,
		   1,1, 1,1, 1,1,
		   1,1, 1,1, 1,1, disp, fh, dummy, info ) ;

}

WRF_WRITE_KIJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
		&type3d, &type2d, &type1d, &info ) ;

  wrf_write_field( *id, v,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;
}

WRF_WRITE_IJK ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL *temp ;
  int i,j,k,ix,jx,kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;

  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;

  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        temp[k+i*kx+j*kx*ix] = v[i+j*ix+k*ix*jx] ;

  wrf_write_field( *id, temp,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;

  free (temp) ;
}

WRF_WRITE_IKJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL *temp ;
  int i,j,k,ix,jx,kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;

  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;

  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        temp[k+i*kx+j*kx*ix] = v[i+k*ix+j*ix*kx] ;

  wrf_write_field( *id, temp,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;

  free (temp) ;
}

WRF_WRITE_IJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
		&type3d, &type2d, &type1d, &info ) ;

  wrf_write_field( *id, v,
                   ids, ide, jds, jde, 1, 1,
                   ims, ime, jms, jme, 1, 1,
                   ips, ipe, jps, jpe, 1, 1, disp, fh, type2d, info ) ;
}

WRF_WRITE_K ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
		&type3d, &type2d, &type1d, &info ) ;

  wrf_write_field( *id, v,
                   1, 1, 1, 1, kds, kde,
                   1, 1, 1, 1, kms, kme,
                   1, 1, 1, 1, kps, kpe, disp, fh, type1d, info ) ;
}

wrf_write_field ( id, v, 
		  ids, ide, jds, jde, kds, kde,
		  ims, ime, jms, jme, kms, kme,
		  ips, ipe, jps, jpe, kps, kpe,
                  disp, fh, newtype, info
	        )
  int id ;
  REAL *v ;
  int ids, ide, jds, jde, kds, kde ;
  int ims, ime, jms, jme, kms, kme ;
  int ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype   newtype ;
{
  REAL *q ;
  int kx, ix, jx, kl, il, jl, kdom, idom, jdom ;
  int i, j, k ;
  int size ;
  int n ;
#ifdef WRF_MPI_IO
  MPI_Status status ;
#endif

  kx = kme - kms + 1 ;
  ix = ime - ims + 1 ;
  jx = jme - jms + 1 ;
  kl = kpe - kps + 1 ;
  il = ipe - ips + 1 ;
  jl = jpe - jps + 1 ;
  kdom = kde - kds + 1 ;
  idom = ide - ids + 1 ;
  jdom = jde - jds + 1 ;

  if ( obuf_sz < kx*ix*jx )
  {
    if ( obuf != NULL ) free (obuf) ;
    obuf = (REAL *) malloc( kx*ix*jx * sizeof(REAL) ) ;
    obuf_sz = kx*ix*jx ;
  }

  for ( i = 0 ; i < kx*ix*jx ; i++ ) obuf[i] = 0. ;
  
  q = obuf ;

  for ( j = jps ; j <= jpe ; j++ )
    for ( i = ips ; i <= ipe ; i++ )
      for ( k = kps ; k <= kpe ; k++ )
      {
	*q++ = v[ (k-kms) + (i-ims)*kx + (j-jms)*kx*ix ] ;
      }

#if ! ( defined WRF_MPI_IO || defined WRF_RSL_IO )
  if ((n=write( fh, obuf, idom*jdom*kdom*sizeof ( REAL ))) < idom*jdom*kdom*sizeof ( REAL ) ) 
    {perror("wrf_write_field");exit(1);}
#else
# ifdef WRF_MPI_IO
  MPI_File_set_view ( fh, *disp, MPI_REAL, newtype, "native",
		      MPI_INFO_NULL ) ;
  MPI_File_write_all ( fh, obuf, il*jl*kl, MPI_REAL, &status ) ;
  MPI_Type_size ( MPI_REAL, &size ) ;
  *disp = *disp + idom*jdom*kdom*size ;
# endif
# ifdef WRF_RSL_IO
  if ( il > 1  && jl > 1 && kl > 1 )
  {
    int iotag, iotype, glen[3], llen[3] ;
    iotag = IO3D_KIJ ;
    iotype = RSL_REAL ;
    glen[0] = kdom ; glen[1] = idom ; glen[2] = jdom ;
    llen[0] = kx ; llen[1] = ix ; llen[2] = jx ;

    RSL_WRITE ( &id, &iotag, v, &info, &iotype, glen, llen ) ;
  }
  else
  if ( il > 1 && jl > 1 )
  {
    int iotag, iotype, glen[3], llen[3] ;
    iotag = IO2D_IJ ;
    iotype = RSL_REAL ;
    glen[0] = idom ; glen[1] = jdom ;
    llen[0] = ix ; llen[1] = jx ;
    RSL_WRITE ( &id, &iotag, v, &info, &iotype, glen, llen ) ;
  }
  else
  {
    int i_am_monitor ;
    RSL_C_IAMMONITOR( &i_am_monitor ) ;
    if ( i_am_monitor )
    {
      FORTRAN_WRITE ( &id, obuf, &kdom ) ;
    }
  }
# endif
#endif

}

WRF_READ_0D ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype dummy ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &dummy, &dummy, &dummy, &info ) ;
#ifdef WRF_MPI_IO
  dummy = MPI_REAL ;
#endif
  wrf_read_field( *id, v,
                   1,1, 1,1, 1,1,
                   1,1, 1,1, 1,1,
                   1,1, 1,1, 1,1, disp, fh, dummy, info ) ;

}

WRF_READ_KIJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ; 
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  wrf_read_field( *id, v,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;
}

WRF_READ_IJK ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL * temp ;
  int i, j, k, ix, jx, kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;
  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;

  wrf_read_field( *id, v,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;
/* transpose */
#if 1
  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        temp[i+j*ix+k*ix*jx] = v[k+i*kx+j*kx*ix] ;
  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        v[i+j*ix+k*ix*jx] = temp[i+j*ix+k*ix*jx] ;
#endif
  free(temp) ;
}

WRF_READ_IKJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;
  REAL * temp ;
  int i, j, k, ix, jx, kx ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  ix = ime-ims+1 ;
  jx = jme-jms+1 ;
  kx = kme-kms+1 ;
  temp = ( REAL *) malloc( ix*jx*kx*sizeof( REAL )) ;

  wrf_read_field( *id, v,
                   ids, ide, jds, jde, kds, kde,
                   ims, ime, jms, jme, kms, kme,
                   ips, ipe, jps, jpe, kps, kpe, disp, fh, type3d, info ) ;
/* transpose */
#if 1
  for (i=0;i<ix;i++)
    for (j=0;j<jx;j++)
      for (k=0;k<kx;k++)
        temp[i+k*ix+j*ix*kx] = v[k+i*kx+j*kx*ix] ;
  for (j=0;j<jx;j++)
    for (k=0;k<kx;k++)
      for (i=0;i<ix;i++)
        v[i+k*ix+j*ix*kx] = temp[i+k*ix+j*ix*kx] ;
#endif
  free(temp) ;
}

WRF_READ_IJ ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  wrf_read_field( *id, v,
                   ids, ide, jds, jde, 1, 1,
                   ims, ime, jms, jme, 1, 1,
                   ips, ipe, jps, jpe, 1, 1, disp, fh, type2d, info ) ;
}

WRF_READ_K ( id, v )
  REAL *v ;
  int *id ;
{
  int ids, ide, jds, jde, kds, kde,
      ims, ime, jms, jme, kms, kme,
      ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype type3d, type2d, type1d ;

  get_diminfo( *id,
                &ids, &ide, &jds, &jde, &kds, &kde,
                &ims, &ime, &jms, &jme, &kms, &kme,
                &ips, &ipe, &jps, &jpe, &kps, &kpe, &disp, &fh,
                &type3d, &type2d, &type1d, &info ) ;

  wrf_read_field( *id, v,
                   1, 1, 1, 1, kds, kde,
                   1, 1, 1, 1, kms, kme,
                   1, 1, 1, 1, kps, kpe, disp, fh, type1d, info ) ;
}

wrf_read_field ( id, v, 
		  ids, ide, jds, jde, kds, kde,
		  ims, ime, jms, jme, kms, kme,
		  ips, ipe, jps, jpe, kps, kpe,
                  disp, fh, newtype, info
	        )
  int id ;
  REAL *v ;
  int ids, ide, jds, jde, kds, kde ;
  int ims, ime, jms, jme, kms, kme ;
  int ips, ipe, jps, jpe, kps, kpe ;
  int info ;
  MPI_Offset *disp ;
  MPI_File   fh ;
  MPI_Datatype   newtype ;
{
  REAL *q ;
  int kx, ix, jx, kl, il, jl, kdom, idom, jdom ;
  int i, j, k ;
  int n ;
  int size ;
#ifdef WRF_MPI_IO
  MPI_Status status ;
#endif

  kl = kpe - kps + 1 ;
  il = ipe - ips + 1 ;
  jl = jpe - jps + 1 ;
  kx = kme - kms + 1 ;
  ix = ime - ims + 1 ;
  jx = jme - jms + 1 ;
  kdom = kde - kds + 1 ;
  idom = ide - ids + 1 ;
  jdom = jde - jds + 1 ;

#if 0
fprintf(stderr,"wrf_read_field d %d %d %d %d %d %d\n",ids, ide, jds, jde, kds, kde ) ;
fprintf(stderr,"wrf_read_field m %d %d %d %d %d %d\n",ims, ime, jms, jme, kms, kme ) ;
fprintf(stderr,"wrf_read_field p %d %d %d %d %d %d\n",ips, ipe, jps, jpe, kps, kpe ) ;
fprintf(stderr,"kl il jl %d %d %d\n",kl,il,jl );
fprintf(stderr,"kx ix jx %d %d %d\n",kx,ix,jx );
fprintf(stderr,"kdom idom jdom %d %d %d\n",kdom,idom,jdom );
#endif

  if ( obuf_sz < kx*ix*jx )
  {
    if ( obuf != NULL ) free (obuf) ;
    obuf = (REAL *) malloc( kx*ix*jx * sizeof(REAL) ) ;
    obuf_sz = kx*ix*jx ;
  }

#ifdef WRF_MPI_IO
  if ( il == 1 && jl == 1 ) newtype = MPI_REAL ;
  MPI_File_set_view ( fh, *disp, MPI_REAL, newtype, "native",
                      MPI_INFO_NULL ) ;
#endif
  
  for ( i = 0 ; i < kx*ix*jx ; i++ ) obuf[i] = 0. ;

  q = obuf ;

#if ! ( defined WRF_MPI_IO || WRF_RSL_IO )
  if ((n=read( fh, obuf, idom*jdom*kdom*sizeof ( REAL ))) < idom*jdom*kdom*sizeof ( REAL ))
     {fprintf(stderr,"n=%d\n");perror("wrf_read_field");exit(2);}
#else
# ifdef WRF_MPI_IO
  if ( il > 1  && jl > 1 ) 
  {
    MPI_File_read_all ( fh, obuf, il*jl*kl, MPI_REAL, &status ) ;
  }
  else
  {
    MPI_File_read ( fh, obuf, idom*jdom*kdom, MPI_REAL, &status ) ;
  }

  MPI_Type_size ( MPI_REAL, &size ) ;
  *disp = *disp + idom*jdom*kdom*size ;
# endif
# ifdef WRF_RSL_IO
  if ( il > 1  && jl > 1 && kl > 1 )
  {
    int iotag, iotype, glen[3], llen[3] ;
    iotag = IO3D_KIJ ;
    iotype = RSL_REAL ;
    glen[0] = kdom ; glen[1] = idom ; glen[2] = jdom ;
    llen[0] = kx ; llen[1] = ix ; llen[2] = jx ;
    RSL_READ ( &id, &iotag, v, &info, &iotype, glen, llen ) ;
  }
  else
  if ( il > 1 && jl > 1 )
  {
    int iotag, iotype, glen[3], llen[3] ;
    iotag = IO2D_IJ ;
    iotype = RSL_REAL ;
    glen[0] = idom ; glen[1] = jdom ;
    llen[0] = ix ; llen[1] = jx ;
    RSL_READ ( &id, &iotag, v, &info, &iotype, glen, llen ) ;
  }
  else
  {
    int i_am_monitor, len ;
    RSL_C_IAMMONITOR( &i_am_monitor ) ;
    if ( i_am_monitor )
    {
      FORTRAN_READ ( &id, v, &kdom ) ;
    }
    len = kdom * sizeof(float) ;
    RSL_MON_BCAST ( v, &len ) ;
  }
# endif
#endif

#ifndef WRF_RSL_IO
  for ( j = jps ; j <= jpe ; j++ )
    for ( i = ips ; i <= ipe ; i++ )
      for ( k = kps ; k <= kpe ; k++ )
      {
	v[ (k-kms) + (i-ims)*kx + (j-jms)*kx*ix] = *q++ ;
      }
#endif

}

#if defined WRF_MPI_IO && defined NO_MPI_SUBARRAY

EXPORT_MPI_API int MPI_Type_create_subarray(
        int ndims,
        int *array_of_sizes,
        int *array_of_subsizes,
        int *array_of_starts,
        int order,
        MPI_Datatype oldtype,
        MPI_Datatype *newtype)
{
    MPI_Aint extent, disps[3], size;
    int i, blklens[3];
    MPI_Datatype tmp1, tmp2, types[3];
    int mpi_errno;
    static char myname[] = "MPI_TYPE_CREATE_SUBARRAY";

    if (ndims <= 0) {
        fprintf(stderr,"%s %s Invalid ndims argument = %d\n",
                 __FILE__,__LINE__, ndims) ;
        MPI_Abort(MPI_COMM_WORLD, 9 ) ;
    }
    mpi_errno = 0 ;
#if 0
    MPIR_TEST_ARG(array_of_sizes);
    MPIR_TEST_ARG(array_of_subsizes);
    MPIR_TEST_ARG(array_of_starts);
#endif
    if (mpi_errno)
    {
        fprintf(stderr,"%s %s mpi_errno %d\n",mpi_errno,
                __FILE__,__LINE__) ;
        MPI_Abort(MPI_COMM_WORLD, 9 ) ;
    }

    for (i=0; i<ndims; i++) {
        if (array_of_sizes[i] <= 0) {
            fprintf(stderr,"%s %s array_of_sizes[%d]=%d\n",
                 __FILE__,__LINE__,i,mpi_errno) ;
            MPI_Abort(MPI_COMM_WORLD, 9 ) ;
        }
        if (array_of_subsizes[i] <= 0) {
            fprintf(stderr,"%s %s array_of_subsizes[%d]=%d\n",
                 __FILE__,__LINE__,i,mpi_errno) ;
            MPI_Abort(MPI_COMM_WORLD, 9 ) ;
        }
        if (array_of_starts[i] < 0) {
            fprintf(stderr,"%s %s array_of_starts[%d]=%d\n",
                 __FILE__,__LINE__,i,mpi_errno) ;
            MPI_Abort(MPI_COMM_WORLD, 9 ) ;
        }
    }

    /* order argument checked below */

    if (oldtype == MPI_DATATYPE_NULL) {
        fprintf(stderr,"%s %s Null datatype\n",__FILE__,__LINE__) ;
        MPI_Abort(MPI_COMM_WORLD, 9 ) ;
    }

    MPI_Type_extent(oldtype, &extent);

    if (order == MPI_ORDER_FORTRAN) {
      /* dimension 0 changes fastest */
        if (ndims == 1)
            MPI_Type_contiguous(array_of_subsizes[0], oldtype, &tmp1);
        else {
            MPI_Type_vector(array_of_subsizes[1], array_of_subsizes[0],
                            array_of_sizes[0], oldtype, &tmp1);

            size = array_of_sizes[0]*extent;
            for (i=2; i<ndims; i++) {
                size *= array_of_sizes[i-1];
                MPI_Type_hvector(array_of_subsizes[i], 1, size, tmp1, &tmp2);
                MPI_Type_free(&tmp1);
                tmp1 = tmp2;
            }
        }

        /* add displacement and UB */

        disps[1] = array_of_starts[0];
        size = 1;
        for (i=1; i<ndims; i++) {
            size *= array_of_sizes[i-1];
            disps[1] += size*array_of_starts[i];
        }
        /* rest done below for both Fortran and C order */
    }

    else if (order == MPI_ORDER_C) {
        /* dimension ndims-1 changes fastest */
        if (ndims == 1)
            MPI_Type_contiguous(array_of_subsizes[0], oldtype, &tmp1);
        else {
            MPI_Type_vector(array_of_subsizes[ndims-2],
                            array_of_subsizes[ndims-1],
                            array_of_sizes[ndims-1], oldtype, &tmp1);

            size = array_of_sizes[ndims-1]*extent;
            for (i=ndims-3; i>=0; i--) {
                size *= array_of_sizes[i+1];
                MPI_Type_hvector(array_of_subsizes[i], 1, size, tmp1, &tmp2);
                MPI_Type_free(&tmp1);
                tmp1 = tmp2;
            }
        }

        /* add displacement and UB */

        disps[1] = array_of_starts[ndims-1];
        size = 1;
        for (i=ndims-2; i>=0; i--) {
            size *= array_of_sizes[i+1];
            disps[1] += size*array_of_starts[i];
        }
    }
    else {
        fprintf(stderr,"%s %s Invalid Order\n",__FILE__,__LINE__) ;
        MPI_Abort(MPI_COMM_WORLD,9) ;
    }

    disps[1] *= extent;

    disps[2] = extent;
    for (i=0; i<ndims; i++) disps[2] *= array_of_sizes[i];

    disps[0] = 0;
    blklens[0] = blklens[1] = blklens[2] = 1;
    types[0] = MPI_LB;
    types[1] = tmp1;
    types[2] = MPI_UB;

    MPI_Type_struct(3, blklens, disps, types, newtype);

    MPI_Type_free(&tmp1);

    return MPI_SUCCESS;
}

#endif

