!WRF:MODEL_LAYER:PHYSICS
!
MODULE module_diffusion

   USE module_configure
   USE module_bc
   USE module_state_description
   USE module_big_step_utilities 
   USE module_model_constants    
   USE module_wrf_error

CONTAINS

!==========================================================================
SUBROUTINE cal_deform_and_div ( config_flags,u,v,w,div,defor11,defor22,   &
                                defor33,defor12,defor13,defor23,          &
                                u_base, v_base,msfu, msfv, msft,          &
                                rdx, rdy, dzeta,dzetaw,                   &
                                fzm,fzp,cf1,cf2,cf3,zeta_z,zeta_x,zeta_y, &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,         INTENT(IN   ) ::       ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte
   REAL ,            INTENT(IN   ) ::                           rdx, rdy
   REAL ,            INTENT(IN   ) ::                      cf1, cf2, cf3


   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      ::  dzeta
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      :: dzetaw
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      :: u_base
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      :: v_base
   REAL , DIMENSION( ims:ime , jms:jme ) ,  INTENT(IN   )      :: zeta_z, &
                                                                    msfu, &
                                                                    msfv, &
                                                                    msft

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ) ,                       &
                                            INTENT(IN   )      ::      u, &
                                                                       v, &
                                                                       w, &
                                                                  zeta_x, &
                                                                  zeta_y

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ),                        &
                                            INTENT(INOUT)      ::defor11, &
                                                                 defor22, &
                                                                 defor33, &
                                                                 defor12, &
                                                                 defor13, &
                                                                 defor23, &
                                                                     div 
   ! Local vars

   INTEGER :: i, j, k, ktf, ktes1, ktes2
   INTEGER :: i_start, i_end, j_start, j_end
   REAL    :: tmp

   REAL , DIMENSION( its:ite, jts:jte)                     ::        mm
   REAL , DIMENSION( its:ite, jts:jte)                     ::     zzavg

   REAL , DIMENSION( its:ite, kts:kte, jts:jte)            ::     zxavg

   REAL , DIMENSION( its-2:ite+2, kts:kte, jts-2:jte+2)    ::      tmp1, &
                                                                    hat, &
                                                                 hatavg

!  zeta_dir_avg needs memory size

!-------------------------------------------------------------------------
!  deforxx = deformation

   ktes1=kte-1
   ktes2=kte-2

   ktf=MIN(kte,kde-1)

!*********************************************************
!*    calculate defor at p points with larger domain     *
!*                      defor11                          *
!*                      defor22                          *
!*                      defor33                          *
!*********************************************************

   i_start = its
   i_end   = min(ite,ide-1)
   j_start = jts
   j_end   = min(jte,jde-1)

   do j=j_start,j_end
   do i=i_start,i_end
       mm(i,j)=msft(i,j)*msft(i,j)
   enddo 
   enddo 

!---------------------------
!  partial u / partial x

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end+1
       hat(i,k,j)=u(i,k,j)/msfu(i,j)
   enddo 
   enddo 
   enddo 

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      hatavg(i,k,j)=0.5*(fzm(k)*(hat(i,k  ,j)+hat(i+1,  k,j))+ &
                         fzp(k)*(hat(i,k-1,j)+hat(i+1,k-1,j)))
   enddo 
   enddo 
   enddo 

   do j=j_start,j_end
   do i=i_start,i_end
      hatavg(i,1,j)  =0.5*(cf1*hat(i  ,1,j)+cf2*hat(i  ,2,j)+cf3*hat(i  ,3,j)+  &
                           cf1*hat(i+1,1,j)+cf2*hat(i+1,2,j)+cf3*hat(i+1,3,j))
      hatavg(i,kte,j)=0.5*(hat(i,ktes1,j)+(hat(i,ktes1,j)-hat(i,ktes2,j))       &
                                         *0.5*dzetaw(ktes1)/dzeta(ktes1)+ &
                           hat(i+1,ktes1,j)+(hat(i+1,ktes1,j)-hat(i+1,ktes2,j)) &
                                         *0.5*dzetaw(ktes1)/dzeta(ktes1))
   enddo 
   enddo 

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (hatavg(i,k+1,j)-hatavg(i,k,j))*zeta_x(i,k,j)/dzetaw(k)
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= mm(i,j)*(rdx*(hat(i+1,k,j)-hat(i,k,j))-tmp1(i,k,j))
   enddo 
   enddo 
   enddo 
!-----------------------------------
!  defor11 : 2 partial u / partial x

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      defor11(i,k,j)= 2.*tmp1(i,k,j)
   enddo 
   enddo 
   enddo 

!  defor11 done

!-----------------------------------
!  Div : add partial u / partial x

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      div(i,k,j)=tmp1(i,k,j)
   enddo 
   enddo 
   enddo 

!---------------------------
! partial  v / partial y

   do j=j_start,j_end+1
   do k=kts,ktf
   do i=i_start,i_end
       hat(i,k,j)=v(i,k,j)/msfv(i,j)
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      hatavg(i,k,j)=0.5*(fzm(k)*(hat(i,k  ,j)+hat(i,k  ,j+1))+  &
                         fzp(k)*(hat(i,k-1,j)+hat(i,k-1,j+1)))
   enddo 
   enddo 
   enddo 

   do j=j_start,j_end
   do i=i_start,i_end
      hatavg(i,1,j)  =0.5*(cf1*hat(i,1,j  )+cf2*hat(i,2,j  )+cf3*hat(i,3,j  )+  &
                           cf1*hat(i,1,j+1)+cf2*hat(i,2,j+1)+cf3*hat(i,3,j+1))
      hatavg(i,kte,j)=0.5*(hat(i,ktes1,j)+(hat(i,ktes1,j)-hat(i,ktes2,j))       &
                                         *0.5*dzetaw(ktes1)/dzeta(ktes1)+ &
                           hat(i,ktes1,j+1)+(hat(i,ktes1,j+1)-hat(i,ktes2,j+1)) &
                                         *0.5*dzetaw(ktes1)/dzeta(ktes1))
   enddo 
   enddo 

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (hatavg(i,k+1,j)-hatavg(i,k,j))*zeta_y(i,k,j)/dzetaw(k)
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= mm(i,j)*(rdy*(hat(i,k,j+1)-hat(i,k,j))-tmp1(i,k,j))
   enddo
   enddo
   enddo

!-------------------------------
! defor22 : 2 partial  v / partial y

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      defor22(i,k,j)= 2.*tmp1(i,k,j)
   enddo
   enddo
   enddo

! defor22 done

!-------------------------------
! Div : add partial v / partial y

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      div(i,k,j)=div(i,k,j)+tmp1(i,k,j)
   enddo 
   enddo 
   enddo 

!-------------------------
! partial w / partial z

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (w(i,k+1,j)-w(i,k,j))*zeta_z(i,j)/dzetaw(k)
   enddo
   enddo
   enddo
!----------------------------------
! defor33 : 2 partial w / parital z

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      defor33(i,k,j)= 2.*tmp1(i,k,j)
   enddo
   enddo
   enddo

! defor33 done

!----------------------------------
! Div : add partial w / parital z

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      div(i,k,j)=div(i,k,j)+tmp1(i,k,j)
   enddo 
   enddo 
   enddo 

! Div done

!*****************************************************************
!*    calculate defor at vorticity points with larger domain     *
!*                        defor12                                *
!*****************************************************************

! calculate defor at vorticity points

    i_start = its
    i_end   = ite
    j_start = jts
    j_end   = jte

    IF ( config_flags%open_xs .or. config_flags%specified .or. &
         config_flags%nested) i_start = MAX(ids+1,its)
    IF ( config_flags%open_xe .or. config_flags%specified .or. & 
         config_flags%nested) i_end   = MIN(ide-1,ite)
    IF ( config_flags%open_ys .or. config_flags%specified .or. &
         config_flags%nested) j_start = MAX(jds+1,jts)
    IF ( config_flags%open_ye .or. config_flags%specified .or. &
         config_flags%nested) j_end   = MIN(jde-1,jte)

!------------------------
!  partial u / partial y

   do j=j_start,j_end
   do i=i_start, i_end
       mm(i,j)=0.5*(msfu(i,j-1)+msfu(i,j))*(msfv(i-1,j)+msfv(i,j))
   enddo 
   enddo 

   do j=j_start-1,j_end
   do k=kts,ktf
   do i=i_start,i_end
       hat(i,k,j)=u(i,k,j)/msfu(i,j)
   enddo 
   enddo 
   enddo 

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      hatavg(i,k,j)=0.5*(fzm(k)*(hat(i,k  ,j-1)+hat(i,k  ,j))+ &
                         fzp(k)*(hat(i,k-1,j-1)+hat(i,k-1,j)))
   enddo 
   enddo 
   enddo 

   do j=j_start,j_end
   do i=i_start,i_end
      hatavg(i,1,j)  =0.5*(cf1*hat(i,1,j-1)+cf2*hat(i,2,j-1)+cf3*hat(i,3,j-1)+  &
                           cf1*hat(i,1,j)+cf2*hat(i,2,j)+cf3*hat(i,3,j))
      hatavg(i,kte,j)=0.5*(hat(i,ktes1,j-1)+(hat(i,ktes1,j-1)-hat(i,ktes2,j-1)) &
                                         *0.5*dzetaw(ktes1)/dzeta(ktes1)+ &
                           hat(i,ktes1,j)+(hat(i,ktes1,j)-hat(i,ktes2,j)) &
                                         *0.5*dzetaw(ktes1)/dzeta(ktes1))
   enddo 
   enddo 

   do j=j_start, j_end
   do k=kts,ktf
   do i=i_start, i_end
      tmp1(i,k,j)= (hatavg(i,k+1,j)-hatavg(i,k,j))*zeta_y(i,k,j)/dzetaw(k)
   enddo
   enddo
   enddo

!-------------------------------------
!  deform12: Add partial u / partial y

   do j=j_start, j_end
   do k=kts,ktf
   do i=i_start, i_end
      defor12(i,k,j)= mm(i,j)*(rdy*(hat(i,k,j)-hat(i,k,j-1))-tmp1(i,k,j))
   enddo
   enddo
   enddo

!-------------------------------------
! partial  v over partial x

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start-1,i_end
       hat(i,k,j)=v(i,k,j)/msfv(i,j)
   enddo
   enddo
   enddo

   do j=j_start, j_end
   do k=kts+1,ktf
   do i=i_start, i_end
      hatavg(i,k,j)=0.5*(fzm(k)*(hat(i-1,k  ,j)+hat(i,k  ,j))+ &
                         fzp(k)*(hat(i-1,k-1,j)+hat(i,k-1,j)))
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do i=i_start,i_end
      hatavg(i,1,j)  =0.5*(cf1*hat(i-1,1,j)+cf2*hat(i-1,2,j)+cf3*hat(i-1,3,j)+  &
                           cf1*hat(i,1,j)+cf2*hat(i,2,j)+cf3*hat(i,3,j))
      hatavg(i,kte,j)=0.5*(hat(i-1,ktes1,j)+(hat(i-1,ktes1,j)-hat(i-1,ktes2,j)) &
                                         *0.5*dzetaw(ktes1)/dzeta(ktes1)+ &
                           hat(i,ktes1,j)+(hat(i,ktes1,j)-hat(i,ktes2,j)) &
                                         *0.5*dzetaw(ktes1)/dzeta(ktes1))
   enddo
   enddo

   do j=j_start, j_end
   do k=kts,ktf
   do i=i_start, i_end
      tmp1(i,k,j)= (hatavg(i,k+1,j)-hatavg(i,k,j))*zeta_x(i,k,j)/dzetaw(k)
   enddo
   enddo
   enddo

!------------------------------------
!  deform12: Add partial v / partial x

   do j=j_start, j_end
   do k=kts,ktf
   do i=i_start, i_end
      defor12(i,k,j)= defor12(i,k,j) +  &
                      mm(i,j)*(rdx*(hat(i,k,j)-hat(i-1,k,j))-tmp1(i,k,j))
   enddo
   enddo
   enddo


!------------------------------------------------
! update boundary !!! might need to change later
!
   if (.not. config_flags%periodic_x .and. i_start .eq. ids+1) then
      do j=jts,jte
      do k=kts,kte
         defor12(ids,k,j)= defor12(ids+1,k,j)
      enddo
      enddo
   endif
!
   if (.not. config_flags%periodic_y .and. j_start .eq. jds+1) then
      do k=kts,kte
      do i=its,ite
         defor12(i,k,jds)= defor12(i,k,jds+1)
      enddo
      enddo
   endif

!
   if (.not. config_flags%periodic_x .and. i_end .eq. ide-1) then
      do j=jts,jte
      do k=kts,kte
         defor12(ide,k,j)= defor12(ide-1,k,j)
      enddo
      enddo
   endif

   if (.not. config_flags%periodic_y .and. j_end .eq. jde-1) then
      do k=kts,kte
      do i=its,ite
         defor12(i,k,jde)= defor12(i,k,jde-1)
      enddo
      enddo
   endif

! defor12 done

!*******************************************
!*    calculate defor between u points     *
!*                defor13                  *
!*******************************************

   i_start = its
   i_end   = min(ite,ide-1)
   j_start = jts
   j_end   = min(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)

!  i_start = its
!  i_end   = ite
!  j_start = jts
!  j_end   = jte

!  IF ( config_flags%open_xs .or. config_flags%specified .or. &
!       config_flags%nested) i_start = MAX(ids+1,its)
!  IF ( config_flags%open_xe .or. config_flags%specified .or. &
!       config_flags%nested) i_end   = MIN(ide-1,ite)
!  IF ( config_flags%open_ys .or. config_flags%specified .or. &
!       config_flags%nested) j_start = MAX(jds+1,jts)
!  IF ( config_flags%open_ye .or. config_flags%specified .or. &
!       config_flags%nested) j_end   = MIN(jde-1,jte)

   do j=jts,jte
   do i=its,ite
       mm(i,j)=msfu(i,j)*msfu(i,j)
   enddo 
   enddo 

! for both defor13 and defor23

   do j=j_start-1,min(jte,jde-1)
   do k=kts,kte
   do i=i_start,min(ite,ide-1)
       hat(i,k,j)=w(i,k,j)/msft(i,j)
   enddo
   enddo
   enddo
 
   i=i_start-1
   do j=j_start,min(jte,jde-1)
   do k=kts,kte
      hat(i,k,j)=w(i,k,j)/msft(i,j)
   enddo
   enddo

!----------------------------------
! defor13

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      hatavg(i,k,j)=0.25*(hat(i,k,j)+hat(i,k+1,j)+hat(i-1,k,j)+hat(i-1,k+1,j))
      zxavg(i,k,j)=0.5*(zeta_x(i,k,j)+zeta_x(i-1,k,j))
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (hatavg(i,k,j)-hatavg(i,k-1,j))*zxavg(i,k,j)/dzeta(k)
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      defor13(i,k,j)= mm(i,j)*(rdx*(hat(i,k,j)-hat(i-1,k,j))-tmp1(i,k,j))
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do i=i_start,i_end
      defor13(i,kts,j  )= 0.
      defor13(i,ktf+1,j)= 0.
   enddo
   enddo

   do j=j_start,j_end
   do i=i_start,i_end
      zzavg(i,j)=0.5*(zeta_z(i,j)+zeta_z(i-1,j))
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (u(i,k,j)-u_base(k)-u(i,k-1,j)+u_base(k-1))* &
                   zzavg(i,j)/dzeta(k)
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      defor13(i,k,j)=defor13(i,k,j)+tmp1(i,k,j)
   enddo
   enddo
   enddo

! defor13 done

!-------------
! defor23

   do j=jts,jte
   do i=its,ite
       mm(i,j)=msfv(i,j)*msfv(i,j)
   enddo
   enddo

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      hatavg(i,k,j)=0.25*(hat(i,k,j)+hat(i,k+1,j)+hat(i,k,j-1)+hat(i,k+1,j-1))
      zxavg(i,k,j)=0.5*(zeta_y(i,k,j)+zeta_y(i,k,j-1))
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (hatavg(i,k,j)-hatavg(i,k-1,j))*zxavg(i,k,j)/dzeta(k)
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      defor23(i,k,j)= mm(i,j)*(rdy*(hat(i,k,j)-hat(i,k,j-1))-tmp1(i,k,j))
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do i=i_start,i_end
      defor23(i,kts,j  )= 0.
      defor23(i,ktf+1,j)= 0.
   enddo
   enddo

   do j=j_start,j_end
   do i=i_start,i_end
      zzavg(i,j)=0.5*(zeta_z(i,j)+zeta_z(i,j-1))
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (v(i,k,j)-v_base(k)-v(i,k-1,j)+v_base(k-1))* &
                   zzavg(i,j)/dzeta(k)
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      defor23(i,k,j)= defor23(i,k,j) + tmp1(i,k,j)
   enddo
   enddo
   enddo

! defor23 done

!------------------------------------------------
! update boundary !!! might need to change later
!
   if (.not. config_flags%periodic_x .and. i_start .eq. ids+1) then
      do j=jts,jte
      do k=kts,kte
         defor13(ids,k,j)= defor13(ids+1,k,j)
         defor23(ids,k,j)= defor23(ids+1,k,j)
      enddo
      enddo
   endif
!
   if (.not. config_flags%periodic_y .and. j_start .eq. jds+1) then
      do k=kts,kte
      do i=its,ite
         defor13(i,k,jds)= defor13(i,k,jds+1)
         defor23(i,k,jds)= defor23(i,k,jds+1)
      enddo
      enddo
   endif
!
   if (.not. config_flags%periodic_x .and. i_end .eq. ide-1) then
      do j=jts,jte
      do k=kts,kte
         defor13(ide,k,j)= defor13(ide-1,k,j)
         defor23(ide,k,j)= defor23(ide-1,k,j)
      enddo
      enddo
   endif

   if (.not. config_flags%periodic_y .and. j_end .eq. jde-1) then
      do k=kts,kte
      do i=its,ite
         defor13(i,k,jde)= defor13(i,k,jde-1)
         defor23(i,k,jde)= defor23(i,k,jde-1)
      enddo
      enddo
   endif

END SUBROUTINE cal_deform_and_div

!===============================================================================
SUBROUTINE calculate_km_kh   (config_flags,dt,dampcoef,zdamp,damp_opt,         &
                              xkmh,xkmhd,xkmv,xkhh,xkhv,BN2,                   &
                              khdif,kvdif,div,defor11,defor22,defor33,defor12, &
                              defor13,defor23,tke,p8w,t8w,theta,t,p,moist,     &
                              dzeta,dzetaw,zeta_z,dx,dy,cr_len,n_moist,        &
                              cf1, cf2, cf3,                                   &
                              ids, ide, jds, jde, kds, kde,                    &
                              ims, ime, jms, jme, kms, kme,                    &
                              its, ite, jts, jte, kts, kte                     )
!-------------------------------------------------------------------------------
   IMPLICIT NONE
!-------------------------------------------------------------------------------
   TYPE(grid_config_rec_type) , INTENT(IN   ) :: config_flags   

   INTEGER ,          INTENT(IN   )           :: ids, ide, jds, jde, kds, kde, &
                                                 ims, ime, jms, jme, kms, kme, &
                                                 its, ite, jts, jte, kts, kte 
   INTEGER ,          INTENT(IN   )           :: n_moist, damp_opt
   REAL    ,          INTENT(IN   )           :: cr_len,dx,dy,zdamp,dt,dampcoef
   REAL,              INTENT(IN   )           :: cf1, cf2, cf3
   REAL,              INTENT(IN   )           :: khdif,kvdif

   REAL , DIMENSION( kms:kme ) ,                    INTENT(IN   ) ::   dzetaw
   REAL , DIMENSION( kms:kme ) ,                    INTENT(IN   ) ::    dzeta
   REAL , DIMENSION( ims:ime , jms:jme ) ,          INTENT(IN   ) ::   zeta_z

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_moist), INTENT(INOUT)        &
                                                                  ::    moist

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(INOUT) ::     xkmv, &
                                                                         xkmh, &
                                                                        xkmhd, &
                                                                         xkhv, &
                                                                         xkhh, &
                                                                          BN2  

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ),  INTENT(IN   )      ::      &    
                                                                      defor11, &
                                                                      defor22, &
                                                                      defor33, &
                                                                      defor12, &
                                                                      defor13, &
                                                                      defor23, &
                                                                          div 

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(IN   ) ::      p8w, &
                                                                          t8w, &
                                                                        theta, &
                                                                            t, &
                                                                            p

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(INOUT) ::      tke

! LOCAL VAR

   INTEGER:: i_start,i_end,j_start,j_end,ktf,i,j,k
!-------------------------------------------------------------------------------
!  calculate deformation and divergence

   ktf=min(kte,kde-1)
   i_start = its
   i_end   = min(ite,ide-1)
   j_start = jts
   j_end   = min(jte,jde-1)


   CALL calculate_N2( config_flags,BN2,moist,theta,t,p,                        &
                      p8w,t8w,dzetaw,dzeta,zeta_z,n_moist,cf1,cf2,cf3,         &
                      ids,ide, jds,jde, kds,kde,                               &
                      ims,ime, jms,jme, kms,kme,                               &
                      its,ite, jts,jte, kts,kte                                )

!  choice scheme for calculating diffusion coefficients

   km_coef: SELECT CASE(config_flags%km_opt)

       CASE (1)
            CALL isotropic_km( config_flags,xkmh,xkmhd,xkmv,                   &
                               xkhh,xkhv,khdif,kvdif,                          &
                               ids,ide, jds,jde, kds,kde,                      &
                               ims,ime, jms,jme, kms,kme,                      &
                               its,ite, jts,jte, kts,kte                       )
       CASE (2)  
            CALL tke_km( config_flags,xkmh,xkmhd,xkmv,                         &
                               xkhh,xkhv,tke,p8w,t8w,theta,                    &
                               dzeta,dzetaw,zeta_z,dx,dy,cr_len,               &
                               ids,ide, jds,jde, kds,kde,                      &
                               ims,ime, jms,jme, kms,kme,                      &
                               its,ite, jts,jte, kts,kte                       )
       CASE (3)  
            CALL smag_km( config_flags,xkmh,xkmhd,xkmv,xkhh,xkhv,BN2,          &
                               div,defor11,defor22,defor33,defor12,            &
                               defor13,defor23,                                &
                               dzetaw,zeta_z,dx,dy,cr_len,                     &
                               ids,ide, jds,jde, kds,kde,                      &
                               ims,ime, jms,jme, kms,kme,                      &
                               its,ite, jts,jte, kts,kte                       )
       CASE DEFAULT

            CALL wrf_error_fatal( 'Please choose a diffusion coefficient scheme' )

   END SELECT km_coef

   IF (damp_opt .eq. 1) THEN
       CALL cal_dampkm(config_flags,xkmhd,xkhh,xkmv,xkhv,                      &
                       dx,dy,dt,dampcoef,                                      &
                       zeta_z,dzetaw,dzeta,zdamp,                              &
                       ids,ide, jds,jde, kds,kde,                              &
                       ims,ime, jms,jme, kms,kme,                              &
                       its,ite, jts,jte, kts,kte                               )

   ENDIF

END SUBROUTINE calculate_km_kh

!===============================================================================
SUBROUTINE cal_dampkm(config_flags,xkmhd,xkhh,xkmv,xkhv,                       &
                      dx,dy,dt,dampcoef,                                       &
                      zeta_z,dzetaw,dzeta,zdamp,                               &
                      ids,ide, jds,jde, kds,kde,                               &
                      ims,ime, jms,jme, kms,kme,                               &
                      its,ite, jts,jte, kts,kte                                )
!-------------------------------------------------------------------------------
   IMPLICIT NONE
!-------------------------------------------------------------------------------
   TYPE(grid_config_rec_type) , INTENT(IN   ) :: config_flags

   INTEGER ,          INTENT(IN   )           :: ids, ide, jds, jde, kds, kde, &
                                                 ims, ime, jms, jme, kms, kme, &
                                                 its, ite, jts, jte, kts, kte

   REAL    ,          INTENT(IN   )           :: zdamp,dx,dy,dt,dampcoef

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   )    ::   dzetaw
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   )    ::    dzeta
   REAL , DIMENSION( ims:ime , jms:jme ) ,       INTENT(IN   )    ::   zeta_z

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT)    ::    xkmhd, &
                                                                         xkhh , &
                                                                         xkmv , &
                                                                         xkhv 
! LOCAL VARS

   INTEGER :: i_start, i_end, j_start, j_end, ktf, ktfm1, i, j, k
   REAL    :: kmmax,kmmvmax,degrad90,dz,tmp
   REAL ,     DIMENSION( its:ite )                                ::   deltaz
   REAL , DIMENSION( its:ite, kts:kte, jts:jte)                   ::   dampk,dampkv

   ktf = min(kte,kde-1)
   ktfm1 = ktf-1

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   kmmax=dx*dx/dt
   degrad90=DEGRAD*90.
   DO j = j_start, j_end

      k=ktf
      DO i = i_start, i_end
         deltaz(i)=0.5*dzetaw(k)/zeta_z(i,j)
         dz=dzetaw(k)/zeta_z(i,j)
         kmmvmax=dz*dz/dt
         tmp=min(deltaz(i)/zdamp,1.)
         dampk(i,k,j)=cos(degrad90*tmp)*kmmax*dampcoef
         dampkv(i,k,j)=cos(degrad90*tmp)*kmmvmax*dampcoef
      ENDDO

      DO k = ktfm1,kts,-1
      DO i = i_start, i_end
         deltaz(i)=deltaz(i)+dzeta(k)/zeta_z(i,j)
         dz=dzetaw(k)/zeta_z(i,j)
         kmmvmax=dz*dz/dt
         tmp=min(deltaz(i)/zdamp,1.)
         dampk(i,k,j)=cos(degrad90*tmp)*kmmax*dampcoef
         dampkv(i,k,j)=cos(degrad90*tmp)*kmmvmax*dampcoef
      ENDDO
      ENDDO

   ENDDO

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      xkmhd(i,k,j)=max(xkmhd(i,k,j),dampk(i,k,j))
      xkhh(i,k,j)=max(xkhh(i,k,j),dampk(i,k,j))
      xkmv(i,k,j)=max(xkmv(i,k,j),dampkv(i,k,j))
      xkhv(i,k,j)=max(xkhv(i,k,j),dampkv(i,k,j))
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE cal_dampkm

!===============================================================================
SUBROUTINE calculate_N2( config_flags,BN2,moist,theta,t,p,                     &
                         p8w,t8w,dzetaw,dzeta,zeta_z,n_moist,cf1,cf2,cf3,      &
                         ids,ide, jds,jde, kds,kde,                            &
                         ims,ime, jms,jme, kms,kme,                            &
                         its,ite, jts,jte, kts,kte                             )
!-------------------------------------------------------------------------------
   IMPLICIT NONE
!-------------------------------------------------------------------------------
   TYPE(grid_config_rec_type) , INTENT(IN   ) :: config_flags

   INTEGER ,          INTENT(IN   )           :: ids, ide, jds, jde, kds, kde, &
                                                 ims, ime, jms, jme, kms, kme, &
                                                 its, ite, jts, jte, kts, kte

   INTEGER ,          INTENT(IN   )           :: n_moist

   REAL,              INTENT(IN   )           :: cf1, cf2, cf3

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(INOUT) ::      BN2

   REAL , DIMENSION( kms:kme ) ,                    INTENT(IN   ) ::   dzetaw
   REAL , DIMENSION( kms:kme ) ,                    INTENT(IN   ) ::    dzeta
   REAL , DIMENSION( ims:ime , jms:jme ) ,          INTENT(IN   ) ::   zeta_z


   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_moist), INTENT(INOUT)        &
                                                                  ::    moist

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::       theta, &
                                                                            t, &
                                                                            p, &
                                                                          p8w, &
                                                                          t8w
! Local VAR

   INTEGER :: i, j, k, ktf, ispe, ktes1, ktes2

   INTEGER :: i_start, i_end, j_start, j_end

   REAL    :: coefa,thetaep1,thetaem1,qc_cr,es,tc,qlpqi,qsw,qsi,              &
              tmpdz,xlvqv,thetaesfc,thetasfc,qvtop,qvsfc,thetatop,            &
              thetaetop

   REAL , DIMENSION( its:ite, jts:jte)                          ::   tmp1sfc, &
                                                                     tmp1top

   REAL , DIMENSION( its:ite, kts:kte, jts:jte)                 ::      tmp1, &
                                                                         qvs, &
                                                                       qctmp
!------------------------------------------------------------------------------
!  qc_cr is in Kg/Kg

   qc_cr = 0.00001

   ktf=MIN(kte,kde-1)
   ktes1=kte-1
   ktes2=kte-2

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)
!
   IF (P_QC .ge. PARAM_FIRST_SCALAR) THEN
      DO j = j_start, j_end
      DO k = kts, ktf
      DO i = i_start, i_end
         qctmp(i,k,j)=moist(i,k,j,P_QC)
      ENDDO
      ENDDO
      ENDDO
   ELSE
      DO j = j_start, j_end
      DO k = kts, ktf
      DO i = i_start, i_end
         qctmp(i,k,j)=0.
      ENDDO
      ENDDO
      ENDDO
   ENDIF
!
   DO j = jts,jte
   DO k = kts,kte
   DO i = its,ite
      tmp1(i,k,j)=0.
   ENDDO
   ENDDO
   ENDDO
!
   DO j = jts,jte
   DO i = its,ite
      tmp1sfc(i,j)=0.
      tmp1top(i,j)=0.
   ENDDO
   ENDDO
!
   DO ispe=PARAM_FIRST_SCALAR,n_moist
      IF (ispe .eq. P_QV .or. ispe .eq. P_QC .or. ispe .eq. P_QI) THEN

         DO j = j_start, j_end
         DO k = kts, ktf
         DO i = i_start, i_end
            tmp1(i,k,j)=tmp1(i,k,j)+moist(i,k,j,ispe)
         ENDDO
         ENDDO
         ENDDO
!
         DO j = j_start, j_end
         DO i = i_start, i_end
            tmp1sfc(i,j)=tmp1sfc(i,j)+cf1*moist(i,1,j,ispe)+cf2*moist(i,2,j,ispe)+&
                         cf3*moist(i,3,j,ispe)
            tmp1top(i,j)=tmp1top(i,j)+moist(i,ktes1,j,ispe)+ &
                         (moist(i,ktes1,j,ispe)-moist(i,ktes2,j,ispe)) &
                         *0.5*dzetaw(ktes1)/dzeta(ktes1)
         ENDDO
         ENDDO

      ENDIF
   ENDDO

! calculate saturation mixing ratio

   IF (P_QI .ge. PARAM_FIRST_SCALAR) THEN
      DO j = j_start, j_end
      DO k = kts, ktf
      DO i = i_start, i_end
         tc=t(i,k,j)-SVPT0
         es=1000.*SVP1*exp( SVP2*tc/(t(i,k,j)-SVP3) )
         qsw=EP_2*es/(p(i,k,j)-es)
         if (t(i,k,j) .lt. 273.15 ) then
            es=1000.*SVP1*exp( 21.8745584*(tc-0.01)/(t(i,k,j)-7.66) )
            qsi=EP_2*es/(p(i,k,j)-es)
            if (tc .lt. -40.0) qsw=qsi
         else
            qsi=qsw
         endif
         qlpqi=qctmp(i,k,j)+moist(i,k,j,P_QI)
         if ( qlpqi .eq. 0.0 ) then
             qvs(i,k,j)=qsi
         else
             qvs(i,k,j)=(moist(i,k,j,P_QI)*qsi+moist(i,k,j,P_QV)*qsw)/qlpqi
         endif
      ENDDO
      ENDDO
      ENDDO
   ELSE
      DO j = j_start, j_end
      DO k = kts, ktf
      DO i = i_start, i_end
         tc=t(i,k,j)-SVPT0
         es=1000.*SVP1*exp(SVP2*tc/(t(i,k,j)-SVP3) )
         qvs(i,k,j)=EP_2*es/(p(i,k,j)-es)
      ENDDO
      ENDDO
      ENDDO
   ENDIF
!
   DO j = j_start, j_end
   DO k = kts+1, ktf-1
   DO i = i_start, i_end
      tmpdz=dzeta(k+1)+dzeta(k)
      IF (moist(i,k,j,P_QV) .ge. qvs(i,k,j) .or. qctmp(i,k,j) .ge. qc_cr) THEN
         xlvqv=XLV*moist(i,k,j,P_QV)
         coefa=(1.+xlvqv/R_d/t(i,k,j))/ &
               (1.+XLV*xlvqv/Cp/R_v/t(i,k,j)/t(i,k,j))/theta(i,k,j)
         thetaep1=theta(i,k+1,j)*exp(XLV*moist(i,k+1,j,P_QV)/Cp/t(i,k+1,j))
         thetaem1=theta(i,k-1,j)*exp(XLV*moist(i,k-1,j,P_QV)/Cp/t(i,k-1,j))
         BN2(i,k,j)=g*zeta_z(i,j)*(coefa*(thetaep1-thetaem1)/tmpdz-&
                                         (tmp1(i,k+1,j)-tmp1(i,k-1,j))/tmpdz     &
                                  )
      ELSE
         BN2(i,k,j)=g*zeta_z(i,j)*                                               &
                        ( (theta(i,k+1,j)-theta(i,k-1,j))/theta(i,k,j)/tmpdz   + &
                          0.61*(moist(i,k+1,j,P_QV)-moist(i,k-1,j,P_QV))/tmpdz   &
!                         -(tmp1(i,k+1,j)-tmp1(i,k-1,j))/tmpdz                   &
                        )
      ENDIF

   ENDDO
   ENDDO
   ENDDO

   k=kts
   DO j = j_start, j_end
   DO i = i_start, i_end
      tmpdz=dzeta(k+1)+0.5*dzetaw(k)
      thetasfc=T8w(i,kts,j)/(p8w(i,k,j)/p1000mb)**(R_d/Cp)
      qvsfc=cf1*moist(i,1,j,P_QV)+cf2*moist(i,2,j,P_QV)+cf3*moist(i,3,j,P_QV)
      IF (moist(i,k,j,P_QV) .ge. qvs(i,k,j) .or. qctmp(i,k,j) .ge. qc_cr) THEN
         xlvqv=XLV*moist(i,k,j,P_QV)
         coefa=(1.+xlvqv/R_d/t(i,k,j))/ &
               (1.+XLV*xlvqv/Cp/R_v/t(i,k,j)/t(i,k,j))/theta(i,k,j)
         thetaep1=theta(i,k+1,j)*exp(XLV*moist(i,k+1,j,P_QV)/Cp/t(i,k+1,j))
         thetaesfc=thetasfc*exp(XLV*qvsfc/Cp/t8w(i,kts,j))
         BN2(i,k,j)=g*zeta_z(i,j)*(coefa*(thetaep1-thetaesfc)/tmpdz-     &
                                   (tmp1(i,k+1,j)-tmp1sfc(i,j))/tmpdz    &
                                  )
      ELSE
         BN2(i,k,j)=g*zeta_z(i,j)*                                       &
                        ( (theta(i,k+1,j)-thetasfc)/theta(i,k,j)/tmpdz + &
                          0.61*(moist(i,k+1,j,P_QV)-qvsfc)/tmpdz         &
!                         -(tmp1(i,k+1,j)-tmp1sfc(i,j))/tmpdz            &
                        )
      ENDIF
   ENDDO
   ENDDO
!
   k=ktf
   DO j = j_start, j_end
   DO i = i_start, i_end
      tmpdz=dzeta(k)+0.5*dzetaw(k)
      thetatop=T8w(i,kde,j)/(p8w(i,kde,j)/p1000mb)**(R_d/Cp)
      qvtop=moist(i,ktes1,j,P_QV)+(moist(i,ktes1,j,P_QV)-moist(i,ktes2,j,P_QV)) &
                                  *0.5*dzetaw(ktes1)/dzeta(ktes1)
      IF (moist(i,k,j,P_QV) .ge. qvs(i,k,j) .or. qctmp(i,k,j) .ge. qc_cr) THEN
         xlvqv=XLV*moist(i,k,j,P_QV)
         coefa=(1.+xlvqv/R_d/t(i,k,j))/ &
               (1.+XLV*xlvqv/Cp/R_v/t(i,k,j)/t(i,k,j))/theta(i,k,j)
         thetaetop=thetatop*exp(XLV*qvtop/Cp/t8w(i,kde,j))
         thetaem1=theta(i,k-1,j)*exp(XLV*moist(i,k-1,j,P_QV)/Cp/t(i,k-1,j))
         BN2(i,k,j)=g*zeta_z(i,j)*(coefa*(thetaetop-thetaem1)/tmpdz-&
                                    (tmp1top(i,j)-tmp1(i,k-1,j))/tmpdz  &
                                   )
      ELSE
         BN2(i,k,j)=g*zeta_z(i,j)*                                       &
                      ( (thetatop-theta(i,k-1,j))/theta(i,k,j)/tmpdz +   &
                        0.61*(qvtop-moist(i,k-1,j,P_QV))/tmpdz           &
!                       -(tmp1top(i,j)-tmp1(i,k-1,j))/tmpdz              &
                      )
      ENDIF
   ENDDO
   ENDDO

END SUBROUTINE calculate_N2

!===============================================================================
SUBROUTINE isotropic_km( config_flags,                                         &
                      xkmh,xkmhd,xkmv,xkhh,xkhv,khdif,kvdif,                   &
                      ids,ide, jds,jde, kds,kde,                               &
                      ims,ime, jms,jme, kms,kme,                               &
                      its,ite, jts,jte, kts,kte                                )
!-------------------------------------------------------------------------------
   IMPLICIT NONE
!-------------------------------------------------------------------------------
   TYPE(grid_config_rec_type) , INTENT(IN   ) :: config_flags

   INTEGER ,          INTENT(IN   )           :: ids, ide, jds, jde, kds, kde, &
                                                 ims, ime, jms, jme, kms, kme, &
                                                 its, ite, jts, jte, kts, kte

   REAL    ,          INTENT(IN   )           :: khdif,kvdif               

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(INOUT) ::     xkmh, &
                                                                        xkmhd, &
                                                                         xkmv, &
                                                                         xkhh, &
                                                                         xkhv
! LOCAL VARS

   INTEGER :: i_start, i_end, j_start, j_end, ktf, i, j, k
   REAL    :: khdif3,kvdif3

   ktf = min(kte,kde-1)

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   khdif3=khdif*3.
   kvdif3=kvdif*3.

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      xkmh(i,k,j)=khdif
      xkmhd(i,k,j)=khdif
      xkmv(i,k,j)=kvdif
      xkhh(i,k,j)=khdif3
      xkhv(i,k,j)=kvdif3
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE isotropic_km

!===============================================================================
SUBROUTINE smag_km( config_flags,xkmh,xkmhd,xkmv,xkhh,xkhv,BN2,                &
                    div,defor11,defor22,defor33,defor12,                       &
                    defor13,defor23,                                           &
                    dzetaw,zeta_z,dx,dy,cr_len,                                &
                    ids,ide, jds,jde, kds,kde,                                 &
                    ims,ime, jms,jme, kms,kme,                                 &
                    its,ite, jts,jte, kts,kte                                  )
!-------------------------------------------------------------------------------
   IMPLICIT NONE
!-------------------------------------------------------------------------------
   TYPE(grid_config_rec_type) , INTENT(IN   ) :: config_flags

   INTEGER ,          INTENT(IN   )           :: ids, ide, jds, jde, kds, kde, &
                                                 ims, ime, jms, jme, kms, kme, &
                                                 its, ite, jts, jte, kts, kte

   REAL    ,          INTENT(IN   )           :: cr_len, dx, dy

   REAL , DIMENSION( kms:kme ) ,                    INTENT(IN   ) ::   dzetaw
   REAL , DIMENSION( ims:ime , jms:jme ) ,          INTENT(IN   ) ::   zeta_z


   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(IN   ) ::      BN2

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(INOUT) ::     xkmh, &
                                                                        xkmhd, &
                                                                         xkmv, &
                                                                         xkhh, &
                                                                         xkhv

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ),  INTENT(IN   )      ::      &    
                                                                      defor11, &
                                                                      defor22, &
                                                                      defor33, &
                                                                      defor12, &
                                                                      defor13, &
                                                                      defor23, &
                                                                          div

! LOCAL VARS

   INTEGER :: i_start, i_end, j_start, j_end, ktf, i, j, k
   REAL    :: deltas, tmp, pr, mlen_h, mlen_v           

   REAL, DIMENSION( its:ite , kts:kte , jts:jte )                 ::     def2
!-------------------------------------------------------------------------------
   ktf = min(kte,kde-1)

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

   pr=3.

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      def2(i,k,j)=0.5*(defor11(i,k,j)*defor11(i,k,j) + &
                       defor22(i,k,j)*defor22(i,k,j) + &
                       defor33(i,k,j)*defor33(i,k,j))-2./3.*div(i,k,j)
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp=0.25*(defor12(i  ,k,j)+defor12(i  ,k,j+1)+ &
                defor12(i+1,k,j)+defor12(i+1,k,j+1))
      def2(i,k,j)=def2(i,k,j)+tmp*tmp
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp=0.25*(defor13(i  ,k+1,j)+defor13(i  ,k,j)+ &
                defor13(i+1,k+1,j)+defor13(i+1,k,j))
      def2(i,k,j)=def2(i,k,j)+tmp*tmp
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp=0.25*(defor23(i,k+1,j  )+defor23(i,k,j  )+ &
                defor23(i,k+1,j+1)+defor23(i,k,j+1))
      def2(i,k,j)=def2(i,k,j)+tmp*tmp
   enddo
   enddo
   enddo
!
   IF (dx .gt. cr_len) THEN
      mlen_h=sqrt(dx*dy)
      DO j = j_start, j_end
      DO k = kts, ktf
      DO i = i_start, i_end
         mlen_v=dzetaw(k)/zeta_z(i,j)
         tmp=max(0.,def2(i,k,j)-BN2(i,k,j)/pr)
         tmp=tmp**0.5
         xkmh(i,k,j)=max(0.21*0.21*mlen_h*mlen_h*tmp, 1.0E-6*mlen_h*mlen_h )
         xkmh(i,k,j)=min(xkmh(i,k,j), 10.*mlen_h )
         xkmhd(i,k,j)=xkmh(i,k,j)
         xkmv(i,k,j)=max(0.21*0.21*mlen_v*mlen_v*tmp, 1.0E-6*mlen_v*mlen_v )
         xkmv(i,k,j)=min(xkmv(i,k,j), 10.*mlen_v )
         xkhh(i,k,j)=xkmh(i,k,j)*pr
         xkhv(i,k,j)=xkmv(i,k,j)*pr
      ENDDO
      ENDDO
      ENDDO
   ELSE
      DO j = j_start, j_end
      DO k = kts, ktf
      DO i = i_start, i_end
         deltas=(dx*dy*dzetaw(k)/zeta_z(i,j))**0.33333333
         tmp=max(0.,def2(i,k,j)-BN2(i,k,j)/pr)
         tmp=tmp**0.5
         xkmh(i,k,j)=max(0.21*0.21*deltas*deltas*tmp, 1.0E-6*deltas*deltas )
         xkmh(i,k,j)=min(xkmh(i,k,j), 10.*deltas )
         xkmhd(i,k,j)=xkmh(i,k,j)
         xkmv(i,k,j)=xkmh(i,k,j)
         xkhh(i,k,j)=xkmh(i,k,j)*pr
         xkhv(i,k,j)=xkmv(i,k,j)*pr
      ENDDO
      ENDDO
      ENDDO
   ENDIF

END SUBROUTINE smag_km

!===============================================================================
SUBROUTINE tke_km( config_flags,xkmh,xkmhd,xkmv,xkhh,xkhv,tke,p8w,t8w,theta,   &
                   dzeta,dzetaw,zeta_z,dx,dy,cr_len,                           &
                   ids,ide, jds,jde, kds,kde,                                  &
                   ims,ime, jms,jme, kms,kme,                                  &
                   its,ite, jts,jte, kts,kte                                   )
!-------------------------------------------------------------------------------
   IMPLICIT NONE
!-------------------------------------------------------------------------------
   TYPE(grid_config_rec_type) , INTENT(IN   ) :: config_flags

   INTEGER ,          INTENT(IN   )           :: ids, ide, jds, jde, kds, kde, &
                                                 ims, ime, jms, jme, kms, kme, &
                                                 its, ite, jts, jte, kts, kte

   REAL    ,          INTENT(IN   )           :: cr_len, dx, dy

   REAL , DIMENSION( kms:kme ) ,                    INTENT(IN   ) ::   dzetaw
   REAL , DIMENSION( kms:kme ) ,                    INTENT(IN   ) ::    dzeta
   REAL , DIMENSION( ims:ime , jms:jme ) ,          INTENT(IN   ) ::   zeta_z

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(IN   ) ::      tke, &
                                                                          p8w, & 
                                                                          t8w, & 
                                                                        theta

   REAL, DIMENSION( ims:ime , kms:kme , jms:jme ) , INTENT(INOUT) ::     xkmh, &
                                                                        xkmhd, &
                                                                         xkmv, &
                                                                         xkhh, &
                                                                         xkhv
! LOCAL VARS

   REAL , DIMENSION( its:ite, kts:kte, jts:jte)                   ::dthrdzeta

   REAL    :: deltas, tmp, mlen_s, mlen_h, mlen_v, mlen, tmpdz, thetasfc,      &
              thetatop, minkx, pr, pr_h, pr_v

   INTEGER :: i_start, i_end, j_start, j_end, ktf, i, j, k
!  REAL , DIMENSION( its:ite ,kts:kte, jts:jte)                   ::       pr

   ktf = min(kte,kde-1)

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

   DO j = j_start, j_end
   DO k = kts+1, ktf-1
   DO i = i_start, i_end
      tmpdz=dzeta(k+1)+dzeta(k)
      dthrdzeta(i,k,j)=(theta(i,k+1,j)-theta(i,k-1,j))/tmpdz
   ENDDO
   ENDDO
   ENDDO

   k=kts
   DO j = j_start, j_end
   DO i = i_start, i_end
      tmpdz=dzeta(k+1)+0.5*dzetaw(k)
      thetasfc=T8w(i,kts,j)/(p8w(i,k,j)/p1000mb)**(R_d/Cp)
      dthrdzeta(i,k,j)=(theta(i,k+1,j)-thetasfc)/tmpdz
   ENDDO
   ENDDO

   k=ktf
   DO j = j_start, j_end
   DO i = i_start, i_end
      tmpdz=dzeta(k)+0.5*dzetaw(k)
      thetatop=T8w(i,kde,j)/(p8w(i,kde,j)/p1000mb)**(R_d/Cp)
      dthrdzeta(i,k,j)=(thetatop-theta(i,k-1,j))/tmpdz
   ENDDO
   ENDDO

   IF (dx .gt. cr_len) THEN
      mlen_h=sqrt(dx*dy)
      DO j = j_start, j_end
      DO k = kts, ktf
      DO i = i_start, i_end
         tmp=sqrt(max(tke(i,k,j),0.0))
         deltas=dzetaw(k)/zeta_z(i,j)
         mlen_v=deltas
         IF (dthrdzeta(i,k,j) .gt. 0.) THEN
            mlen_s=0.76*tmp/ &
                   abs(g/theta(i,k,j)*zeta_z(i,j)*dthrdzeta(i,k,j))
            mlen_v=min(mlen_v,mlen_s)
         ENDIF
         xkmh(i,k,j)=max(0.1*tmp*mlen_h,1.0E-6*mlen_h*mlen_h)
         xkmh(i,k,j)=min(xkmh(i,k,j), 10.*mlen_h )
         xkmhd(i,k,j)=xkmh(i,k,j)
         xkmv(i,k,j)=max(0.1*tmp*mlen_v,1.0E-6*deltas*deltas)
         xkmv(i,k,j)=min(xkmv(i,k,j), 10.*deltas )
         pr_h=3.
         pr_v=1.+2.*mlen_v/deltas
         xkhh(i,k,j)=xkmh(i,k,j)*pr_h
         xkhv(i,k,j)=xkmv(i,k,j)*pr_v
      ENDDO
      ENDDO
      ENDDO
   ELSE
      DO j = j_start, j_end
      DO k = kts+1, ktf-1
      DO i = i_start, i_end
         tmp=sqrt(max(tke(i,k,j),0.0))
         deltas=(dx*dy*dzetaw(k)/zeta_z(i,j))**0.33333333
         mlen=deltas
         IF (dthrdzeta(i,k,j) .gt. 0.) THEN
            mlen_s=0.76*tmp/ &
                   abs(g/theta(i,k,j)*zeta_z(i,j)*dthrdzeta(i,k,j))
            mlen=min(mlen,mlen_s)
         ENDIF
         minkx=1.0E-6*deltas*deltas
         xkmh(i,k,j)=max(0.1*tmp*mlen,minkx)
         xkmh(i,k,j)=min(xkmh(i,k,j), 10.*mlen )
         xkmhd(i,k,j)=xkmh(i,k,j)
         xkmv(i,k,j)=max(0.1*tmp*mlen,minkx)
         xkmv(i,k,j)=min(xkmv(i,k,j), 10.*mlen )
         pr=1.+2.*mlen/deltas
         xkhh(i,k,j)=xkmh(i,k,j)*pr
         xkhv(i,k,j)=xkmv(i,k,j)*pr
      ENDDO
      ENDDO
      ENDDO
   ENDIF

END SUBROUTINE tke_km

!=================================================================================
SUBROUTINE horizontal_diffusion_2 (rt_tendf, ru_tendf, rv_tendf, rw_tendf,       &
                                   tke_tendf,                                    &
                                   moist_tendf, n_moist,                         &
                                   scalar_tendf, n_scalar, th_mix, qv_mix,       &
                                   thp, theta, rr, tke, config_flags,            &
                                   defor11, defor22, defor12,                    &
                                   defor13, defor23, div,                        &
                                   moist, scalar,                                &
                                   msfu, msfv, msft, xkmh, xkhh,km_opt,          &
                                   rdx, rdy, fzm, fzp, cf1, cf2, cf3,            &
                                   zeta_x, zeta_y, dzetaw, dzeta,                &
                                   ids, ide, jds, jde, kds, kde,                 &
                                   ims, ime, jms, jme, kms, kme,                 &
                                   its, ite, jts, jte, kts, kte                  )
!---------------------------------------------------------------------------------
   IMPLICIT NONE
!---------------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   INTEGER ,        INTENT(IN   ) ::        n_moist, n_scalar, km_opt

   REAL ,           INTENT(IN   ) ::        cf1, cf2, cf3

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: dzetaw
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  dzeta

   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msfu, &
                                                                    msfv, &
                                                                    msft

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::rt_tendf,&
                                                                 ru_tendf,&
                                                                 rv_tendf,&
                                                                 rw_tendf,&
                                                                tke_tendf,&
                                                                   th_mix,&
                                                                   qv_mix

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_moist),                 &
          INTENT(INOUT) ::                                    moist_tendf

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_scalar),                &
          INTENT(INOUT) ::                                   scalar_tendf

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_moist),                 &
          INTENT(IN   ) ::                                          moist

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_scalar) ,               &
          INTENT(IN   ) ::                                         scalar 

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::defor11, &
                                                                 defor22, &
                                                                 defor12, &
                                                                 defor13, &
                                                                 defor23, &
                                                                     div, &
                                                                    xkmh, &
                                                                    xkhh, &
                                                                  zeta_x, &
                                                                  zeta_y, &
                                                                   theta, &
                                                                     thp, &
                                                                     tke, &
                                                                      rr

   REAL ,                                        INTENT(IN   ) ::    rdx, &
                                                                     rdy

! LOCAL VARS
   
   INTEGER :: im

!  REAL , DIMENSION(its-1:ite+1, kts:kte, jts-1:jte+1)       ::     xkhh
!--------------------------------------------------------------------------
   CALL horizontal_diffusion_u_2(ru_tendf, rr, config_flags,              &
                                 defor11, defor12, div,                   &
                                 tke(ims,kms,jms),                 &
                                 msfu, xkmh, rdx, rdy, fzm, fzp,          &
                                 zeta_x, zeta_y, dzetaw,                  &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )

   CALL horizontal_diffusion_v_2(rv_tendf, rr, config_flags,              &
                                 defor12, defor22, div,                   &
                                 tke(ims,kms,jms),               &
                                 msfv, xkmh, rdx, rdy, fzm, fzp,          &
                                 zeta_x, zeta_y, dzetaw,                  &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )

   CALL horizontal_diffusion_w_2(rw_tendf, rr, config_flags,              &
                                 defor13, defor23, div,                   &
                                 tke(ims,kms,jms),               &
                                 msft, xkmh, rdx, rdy, fzm, fzp,          &
                                 zeta_x, zeta_y, dzeta,                   &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )
! calculate khh

!  CALL    calculate_khh(xkmh, xkhh, config_flags,                        &
!                                ids, ide, jds, jde, kds, kde,            &
!                                ims, ime, jms, jme, kms, kme,            &
!                                its, ite, jts, jte, kts, kte             )
 
   CALL horizontal_diffusion_s  (th_mix, rr, config_flags, thp,           &
                                 msft, msfu, msfv, xkhh, rdx, rdy,        &
                                 fzm, fzp, cf1, cf2, cf3,                 &
                                 zeta_x, zeta_y, dzetaw, dzeta,           &
                                 .false.,                                 &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )

   If (km_opt .eq. 2) then
   CALL horizontal_diffusion_s  (tke_tendf(ims,kms,jms),                  &
                                 rr, config_flags,                        &
                                 tke(ims,kms,jms),                        &
                                 msft, msfu, msfv, xkhh, rdx, rdy,        &
                                 fzm, fzp, cf1, cf2, cf3,                 &
                                 zeta_x, zeta_y, dzetaw, dzeta,           &
                                 .true.,                                  &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )
   endif

   IF (n_moist .ge. PARAM_FIRST_SCALAR) THEN 

     moist_loop: do im = PARAM_FIRST_SCALAR, n_moist

       IF (im .eq. P_QV) THEN
          CALL horizontal_diffusion_s  (qv_mix, rr, config_flags,         &
                                 moist(ims,kms,jms,im),                   &
                                 msft, msfu, msfv, xkhh, rdx, rdy,        &
                                 fzm, fzp, cf1, cf2, cf3,                 &
                                 zeta_x, zeta_y, dzetaw, dzeta,           &
                                 .false.,                                 &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )

          CALL mix_qv( moist_tendf(ims,kms,jms,im),                       &
                                 qv_mix, rr,                              &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )

       ELSE
          CALL horizontal_diffusion_s  (moist_tendf(ims,kms,jms,im),      &
                                 rr, config_flags,                        &
                                 moist(ims,kms,jms,im),                   &
                                 msft, msfu, msfv, xkhh, rdx, rdy,        &
                                 fzm, fzp, cf1, cf2, cf3,                 &
                                 zeta_x, zeta_y, dzetaw, dzeta,           &
                                 .false.,                                 &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )
       ENDIF
     ENDDO moist_loop

   ENDIF

   IF (n_scalar .ge. PARAM_FIRST_SCALAR) THEN 

     scalar_loop: do im = PARAM_FIRST_SCALAR, n_scalar

       CALL horizontal_diffusion_s  (scalar_tendf(ims,kms,jms,im),        &
                                 rr, config_flags,                        &
                                 scalar(ims,kms,jms,im),                  &
                                 msft, msfu, msfv, xkhh, rdx, rdy,        &
                                 fzm, fzp, cf1, cf2, cf3,                 &
                                 zeta_x, zeta_y, dzetaw, dzeta,           &
                                 .false.,                                 &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )

     ENDDO scalar_loop

   ENDIF

   CALL mix_theta_m ( rt_tendf, th_mix, qv_mix,                           &
                        rr, moist(ims,kms,jms,P_QV), theta, n_moist,      &
                        ids, ide, jds, jde, kds, kde,                     &
                        ims, ime, jms, jme, kms, kme,                     &
                        its, ite, jts, jte, kts, kte                      )

END SUBROUTINE horizontal_diffusion_2

!==========================================================================
SUBROUTINE horizontal_diffusion_u_2(tendency, rr, config_flags,           &
                                   defor11, defor12, div, tke,            &
                                   msfu, xkmh, rdx, rdy, fzm, fzp,        &
                                   zeta_x, zeta_y, dzetaw,                &
                                   ids, ide, jds, jde, kds, kde,          &
                                   ims, ime, jms, jme, kms, kme,          &
                                   its, ite, jts, jte, kts, kte           )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: dzetaw

   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msfu

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::     rr
 
   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::defor11, &
                                                                 defor12, &
                                                                     div, &   
                                                                     tke, &   
                                                                    xkmh, &
                                                                  zeta_x, &
                                                                  zeta_y

   REAL ,                                        INTENT(IN   ) ::    rdx, &
                                                                     rdy
! Local data
   
   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end
   INTEGER :: is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)    :: titau1avg, &
                                                              titau2avg, &
                                                                 titau1, & 
                                                                 titau2, & 
                                                                 xkxavg, & 
                                                                  rravg, & 
                                                                  zxavg, & 
                                                                  zyavg
   REAL :: mrdx, mrdy, rcoup

   ktf=MIN(kte,kde-1)
 
!----------------------------------------------------------------------
! u :   p (.), u(|), w(-)
!       
!       p  u  p  u                                  u     u
!
! p  |  .  |  .  |  .  |   k+1                |  .  |  .  |  .  |   k+1
!           
! w     - 13  -     -      k+1                     13               k+1 
!
! p  |  11 O 11  |  .  |   k                  |  12 O 12  |  .  |   k      
!
! w     - 13  -     -      k                       13               k  
!
! p  |  .  |  .  |  .  |   k-1                |  .  |  .  |  .  |   k-1
!
!      i-1 i  i i+1                          j-1 j  j j+1 j+1         
!

   i_start = its
   i_end   = ite
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-1,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

! titau1 = titau11 
   is_ext=1
   ie_ext=0
   js_ext=0
   je_ext=0
   CALL cal_titau_11_22_33(config_flags,titau1,rr,tke,            &
                           xkmh,defor11,div,                      &
                           is_ext,ie_ext,js_ext,je_ext,           &
                           ids, ide, jds, jde, kds, kde,          &
                           ims, ime, jms, jme, kms, kme,          &
                           its, ite, jts, jte, kts, kte           )

! titau2 = titau12
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=1
   CALL cal_titau_12_21(config_flags,titau2,rr,xkmh,defor12,      &
                           is_ext,ie_ext,js_ext,je_ext,           &
                           ids, ide, jds, jde, kds, kde,          &
                           ims, ime, jms, jme, kms, kme,          &
                           its, ite, jts, jte, kts, kte           )

! titau1avg = titau11avg
! titau2avg = titau12avg 

   DO j = j_start, j_end
   DO k = kts+1,ktf
   DO i = i_start, i_end
      titau1avg(i,k,j)=0.5*(fzm(k)*(titau1(i-1,k  ,j)+titau1(i,k  ,j))+ &
                            fzp(k)*(titau1(i-1,k-1,j)+titau1(i,k-1,j)))
      titau2avg(i,k,j)=0.5*(fzm(k)*(titau2(i,k  ,j+1)+titau2(i,k  ,j))+ &
                            fzp(k)*(titau2(i,k-1,j+1)+titau2(i,k-1,j)))
      zxavg(i,k,j)=0.5*(fzm(k)*(zeta_x(i-1,k  ,j)+zeta_x(i,k  ,j))+ &
                        fzp(k)*(zeta_x(i-1,k-1,j)+zeta_x(i,k-1,j)))
      zyavg(i,k,j)=0.5*(fzm(k)*(zeta_y(i-1,k  ,j)+zeta_y(i,k  ,j))+ &
                        fzp(k)*(zeta_y(i-1,k-1,j)+zeta_y(i,k-1,j)))
! titau1avg = titau1avg*zxavg
! titau2avg = titau1avg*zyavg

      titau1avg(i,k,j)=titau1avg(i,k,j)*zxavg(i,k,j)
      titau2avg(i,k,j)=titau2avg(i,k,j)*zyavg(i,k,j)
   ENDDO
   ENDDO
   ENDDO
!
   DO j = j_start, j_end
   DO i = i_start, i_end
      titau1avg(i,kts,j)=0.
      titau1avg(i,ktf+1,j)=0.
      titau2avg(i,kts,j)=0.
      titau2avg(i,ktf+1,j)=0.
   ENDDO
   ENDDO
!
   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end

      mrdx=msfu(i,j)*rdx
      mrdy=msfu(i,j)*rdy
      tendency(i,k,j)=tendency(i,k,j)-                                  &
           (mrdx*(titau1(i,k,j  )-titau1(i-1,k,j))+                     &
            mrdy*(titau2(i,k,j+1)-titau2(i,k,j  ))-                     &
            msfu(i,j)/dzetaw(k)*((titau1avg(i,k+1,j)-titau1avg(i,k,j))+ &
                                 (titau2avg(i,k+1,j)-titau2avg(i,k,j))  &
                                )				        &
           )
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE horizontal_diffusion_u_2

!==========================================================================
SUBROUTINE horizontal_diffusion_v_2(tendency, rr, config_flags,           &
                                   defor12, defor22, div, tke,            &
                                   msfv, xkmh, rdx, rdy, fzm, fzp,        &
                                   zeta_x, zeta_y, dzetaw,                &
                                   ids, ide, jds, jde, kds, kde,          &
                                   ims, ime, jms, jme, kms, kme,          &
                                   its, ite, jts, jte, kts, kte           )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: dzetaw

   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msfv

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: tendency

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::     rr

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::defor12, &
                                                                 defor22, &
                                                                     div, &
                                                                     tke, &
                                                                    xkmh, &
                                                                  zeta_x, &
                                                                  zeta_y

   REAL ,                                        INTENT(IN   ) ::    rdx, &
                                                                     rdy

! Local data

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end
   INTEGER :: is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)    :: titau1avg, &
                                                              titau2avg, &
                                                                 titau1, &
                                                                 titau2, &
                                                                 xkxavg, &
                                                                  rravg, &
                                                                  zxavg, &
                                                                  zyavg

   REAL :: mrdx, mrdy, rcoup

   ktf=MIN(kte,kde-1)
 
!----------------------------------------------------------------------
! v :   p (.), v(+), w(-)
!       
!       p  v  p  v                                  v     v
!
! p  +  .  +  .  +  .  +   k+1                +  .  +  .  +  .  +   k+1
!           
! w     - 23  -     -      k+1                     23               k+1 
!
! p  +  22 O 22  +  .  +   k                  +  21 O 21  +  .  +   k      
!
! w     - 23  -     -      k                       23               k  
!
! p  +  .  +  .  +  .  +   k-1                +  .  +  .  +  .  +   k-1
!
!      j-1 j  j j+1                          i-1 i  i i+1 i+1         
!

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = jte

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-1,jte)

! titau1 = titau21
   is_ext=0
   ie_ext=1
   js_ext=0
   je_ext=0
   CALL cal_titau_12_21(config_flags,titau1,rr,xkmh,defor12,    &
                        is_ext,ie_ext,js_ext,je_ext,            &
                        ids, ide, jds, jde, kds, kde,           &
                        ims, ime, jms, jme, kms, kme,           &
                        its, ite, jts, jte, kts, kte            )

! titau2 = titau22
   is_ext=0
   ie_ext=0
   js_ext=1
   je_ext=0
   CALL cal_titau_11_22_33(config_flags,titau2,rr,tke,          &
                        xkmh,defor22,div,                       &
                        is_ext,ie_ext,js_ext,je_ext,            &
                        ids, ide, jds, jde, kds, kde,           &
                        ims, ime, jms, jme, kms, kme,           &
                        its, ite, jts, jte, kts, kte            )

! titau1avg = titau21avg = titau12avg
! titau2avg = titau22avg 

   DO j = j_start, j_end
   DO k = kts+1,ktf
   DO i = i_start, i_end
      titau1avg(i,k,j)=0.5*(fzm(k)*(titau1(i+1,k  ,j)+titau1(i,k  ,j))+ &
                            fzp(k)*(titau1(i+1,k-1,j)+titau1(i,k-1,j)))
      titau2avg(i,k,j)=0.5*(fzm(k)*(titau2(i,k  ,j-1)+titau2(i,k  ,j))+ &
                            fzp(k)*(titau2(i,k-1,j-1)+titau2(i,k-1,j)))
      zxavg(i,k,j)=0.5*(fzm(k)*(zeta_x(i,k  ,j-1)+zeta_x(i,k  ,j))+ &
                        fzp(k)*(zeta_x(i,k-1,j-1)+zeta_x(i,k-1,j)))
      zyavg(i,k,j)=0.5*(fzm(k)*(zeta_y(i,k  ,j-1)+zeta_y(i,k  ,j))+ &
                        fzp(k)*(zeta_y(i,k-1,j-1)+zeta_y(i,k-1,j)))

! titau1avg = titau21avg = titau12avg
! titau2avg = titau22avg 

      titau1avg(i,k,j)=titau1avg(i,k,j)*zxavg(i,k,j)
      titau2avg(i,k,j)=titau2avg(i,k,j)*zyavg(i,k,j)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO i = i_start, i_end
      titau1avg(i,kts,j)=0.
      titau1avg(i,ktf+1,j)=0.
      titau2avg(i,kts,j)=0.
      titau2avg(i,ktf+1,j)=0.
   ENDDO
   ENDDO
!
   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
       
      mrdx=msfv(i,j)*rdx
      mrdy=msfv(i,j)*rdy

      tendency(i,k,j)=tendency(i,k,j)-                                  &
           (mrdy*(titau2(i  ,k,j)-titau2(i,k,j-1))-                     &
            mrdx*(titau1(i+1,k,j)-titau1(i,k,j  ))+                     &
            msfv(i,j)/dzetaw(k)*((titau1avg(i,k+1,j)-titau1avg(i,k,j))+ &
                                 (titau2avg(i,k+1,j)-titau2avg(i,k,j))  &
                                )			                &
           )
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE horizontal_diffusion_v_2

!==========================================================================
SUBROUTINE horizontal_diffusion_w_2(tendency, rr, config_flags,           &
                                   defor13, defor23, div, tke,            &
                                   msft, xkmh, rdx, rdy, fzm, fzp,        &
                                   zeta_x, zeta_y, dzeta,                 &
                                   ids, ide, jds, jde, kds, kde,          &
                                   ims, ime, jms, jme, kms, kme,          &
                                   its, ite, jts, jte, kts, kte           )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  dzeta

   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msft

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: tendency

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::     rr

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::defor13, &
                                                                 defor23, &
                                                                     div, &
                                                                     tke, &
                                                                    xkmh, &
                                                                  zeta_x, &
                                                                  zeta_y

   REAL ,                                        INTENT(IN   ) ::    rdx, &
                                                                     rdy

! Local data

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end
   INTEGER :: is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)    :: titau1avg, &
                                                              titau2avg, &
                                                                 titau1, &
                                                                 titau2, &
                                                                 xkxavg, &
                                                                  rravg, &
                                                                  zxavg, &
                                                                  zyavg

   REAL :: mrdx, mrdy, rcoup

   ktf=MIN(kte,kde-1)
 
!----------------------------------------------------------------------
! w :   p (.), u(|), v(+), w(-)
!       
!       p  u  p  u                               p  v  p  v 
!
! w     -     -     -      k+1             w     -     -     -      k+1 
!
! p     .  | 33  |  .      k               p     .  + 33  +  .      k      
!
! w     -  31 O 31  -      k               w     -  32 O 32  -      k   
!
! p     .  | 33  |  .      k-1             p     .  | 33  |  .      k-1 
!
! w     -     -     -      k-1             w     -     -     -      k-1 
!
!      i-1 i  i i+1                             j-1 j  j j+1         
!
   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

! titau1 = titau31
   is_ext=0
   ie_ext=1
   js_ext=0
   je_ext=0
   CALL cal_titau_13_31(config_flags,titau1,defor13,rr,xkmh,fzm,fzp,&
                        is_ext,ie_ext,js_ext,je_ext,                &
                        ids, ide, jds, jde, kds, kde,               &
                        ims, ime, jms, jme, kms, kme,               &
                        its, ite, jts, jte, kts, kte                )

! titau2 = titau32
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=1
   CALL cal_titau_23_32(config_flags,titau2,defor23,rr,xkmh,fzm,fzp,&
                        is_ext,ie_ext,js_ext,je_ext,                &
                        ids, ide, jds, jde, kds, kde,               &
                        ims, ime, jms, jme, kms, kme,               &
                        its, ite, jts, jte, kts, kte                )

! titau1avg = titau31avg * zeta_x = titau13avg * zeta_x
! titau2avg = titau32avg * zeta_y = titau23avg * zeta_y

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      titau1avg(i,k,j)=0.25*(titau1(i+1,k+1,j)+titau1(i,k+1,j)+ &
                             titau1(i+1,k  ,j)+titau1(i,k  ,j))
      titau2avg(i,k,j)=0.25*(titau2(i,k+1,j+1)+titau2(i,k+1,j)+ &
                             titau2(i,k  ,j+1)+titau2(i,k  ,j))
      titau1avg(i,k,j)=titau1avg(i,k,j)*zeta_x(i,k,j)
      titau2avg(i,k,j)=titau2avg(i,k,j)*zeta_y(i,k,j)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO i = i_start, i_end
      titau1avg(i,kts  ,j)=0.
      titau2avg(i,kts  ,j)=0.
      titau1avg(i,ktf+1,j)=0.
      titau2avg(i,ktf+1,j)=0.
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO k = kts+1,ktf
   DO i = i_start, i_end

      mrdx=msft(i,j)*rdx
      mrdy=msft(i,j)*rdy

      tendency(i,k,j)=tendency(i,k,j)-                               &
           (mrdx*(titau1(i+1,k,j)-titau1(i,k,j))+                    &
            mrdy*(titau2(i,k,j+1)-titau2(i,k,j))-                    &
            msft(i,j)/dzeta(k)*(titau1avg(i,k,j)-titau1avg(i,k-1,j)+ &
                                titau2avg(i,k,j)-titau2avg(i,k-1,j)  &
                               )				     &
           )
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE horizontal_diffusion_w_2

!==========================================================================
SUBROUTINE horizontal_diffusion_s (tendency, rr, config_flags, var,       &
                                   msft, msfu, msfv, xkhh, rdx, rdy,      &
                                   fzm, fzp, cf1, cf2, cf3,               &
                                   zeta_x, zeta_y, dzetaw, dzeta,         &
                                   doing_tke,                             &
                                   ids, ide, jds, jde, kds, kde,          &
                                   ims, ime, jms, jme, kms, kme,          &
                                   its, ite, jts, jte, kts, kte           )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   LOGICAL,         INTENT(IN   ) ::        doing_tke

   REAL , INTENT(IN   )           ::        cf1, cf2, cf3

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: dzetaw
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  dzeta

   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msfu
   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msfv
   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msft

!  REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1),                 &
!         INTENT(IN   ) ::                                         xkhh

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: tendency

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::     rr, &
                                                                    xkhh

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::    var, &
                                                                  zeta_x, &
                                                                  zeta_y

   REAL ,                                        INTENT(IN   ) ::    rdx, &
                                                                     rdy

! Local data

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)    ::     H1avg, &
                                                                  H2avg, &
                                                                     H1, &
                                                                     H2, &
                                                                 xkxavg, &
                                                                  zxavg, &
                                                                  zyavg
   REAL , DIMENSION( its:ite, kts:kte, jts:jte)            ::  tmptendf

   REAL    :: mrdx, mrdy, rcoup
   INTEGER :: ktes1,ktes2
!-------------------------------------------------------------------------
   ktf=MIN(kte,kde-1)
 
!------------------------------------------------------------------------
! scalars:   t (.), u(|), v(+), w(-)
!       
!       t  u  t  u                               t  v  t  v 
!
! w     -     3     -      k+1             w     -     3     -      k+1 
!
! t     .  1  O  1  .      k               t     .  2  O  2  .      k      
!
! w     -     3     -      k               w     -     3     -      k   
!
! t     .  |  .  |  .      k-1             t     .  +  .  +  .      k-1 
!
! w     -     -     -      k-1             w     -     -     -      k-1 
!
! t    i-1 i  i i+1                             j-1 j  j j+1         
!

   ktes1=kte-1
   ktes2=kte-2

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

! diffusion of the TKE needs mutiple 2

   IF ( doing_tke ) THEN
      DO j = j_start, j_end
      DO k = kts,ktf
      DO i = i_start, i_end
         tmptendf(i,k,j)=tendency(i,k,j)
      ENDDO
      ENDDO
      ENDDO
   ENDIF

! H1 = partial var over partial x

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end + 1
      zxavg(i,k,j) =0.5*( zeta_x(i-1,k,j)+ zeta_x(i,k,j))
      xkxavg(i,k,j)=0.5*(xkhh(i-1,k,j)+xkhh(i,k,j))
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO k = kts+1, ktf
   DO i = i_start, i_end + 1
      H1avg(i,k,j)=0.5*(fzm(k)*(var(i-1,k  ,j)+var(i,k  ,j))+  &
                        fzp(k)*(var(i-1,k-1,j)+var(i,k-1,j)))
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO i = i_start, i_end + 1
      H1avg(i,kts  ,j)=0.5*(cf1*var(i  ,1,j)+cf2*var(i  ,2,j)+ &
                            cf3*var(i  ,3,j)+cf1*var(i-1,1,j)+  &
                            cf2*var(i-1,2,j)+cf3*var(i-1,3,j))
      H1avg(i,ktf+1,j)=0.5*(var(i,ktes1,j)+(var(i,ktes1,j)- &
                            var(i,ktes2,j))*0.5*dzetaw(ktes1)/dzeta(ktes1)+ &
                            var(i-1,ktes1,j)+(var(i-1,ktes1,j)- &
                            var(i-1,ktes2,j))*0.5*dzetaw(ktes1)/dzeta(ktes1))
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end + 1
      H1(i,k,j)=-msfu(i,j)*xkxavg(i,k,j)*(                         &
                 rdx*(var(i,k,j)-var(i-1,k,j)) - zxavg(i,k,j)*     &
                     (H1avg(i,k+1,j)-H1avg(i,k,j))/dzetaw(k))
   ENDDO
   ENDDO
   ENDDO

! H2 = partial var over partial y

   DO j = j_start, j_end + 1
   DO k = kts, ktf
   DO i = i_start, i_end
      zyavg(i,k,j) =0.5*( zeta_y(i,k,j-1)+ zeta_y(i,k,j))
      xkxavg(i,k,j)=0.5*(xkhh(i,k,j-1)+xkhh(i,k,j))
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end + 1
   DO k = kts+1,   ktf
   DO i = i_start, i_end
      H2avg(i,k,j)=0.5*(fzm(k)*(var(i,k  ,j-1)+var(i,k-1,j))+  &
                        fzp(k)*(var(i,k-1,j-1)+var(i,k-1,j)))
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end + 1
   DO i = i_start, i_end
      H2avg(i,kts  ,j)=0.5*(cf1*var(i,1,j  )+cf2*var(i  ,2,j)+ &
                            cf3*var(i,3,j  )+cf1*var(i,1,j-1)+  &
                            cf2*var(i,2,j-1)+cf3*var(i,3,j-1))
      H2avg(i,ktf+1,j)=0.5*(var(i,ktes1,j)+(var(i,ktes1,j)- &
                            var(i,ktes2,j))*0.5*dzetaw(ktes1)/dzeta(ktes1)+ &
                            var(i,ktes1,j-1)+(var(i,ktes1,j-1)- &
                            var(i,ktes2,j-1))*0.5*dzetaw(ktes1)/dzeta(ktes1))
   ENDDO
   ENDDO

   DO j = j_start, j_end + 1
   DO k = kts, ktf
   DO i = i_start, i_end
      H2(i,k,j)=-msfv(i,j)*xkxavg(i,k,j)*(                         &
                 rdy*(var(i,k,j)-var(i,k,j-1)) - zyavg(i,k,j)*     &
                     (H2avg(i ,k+1,j)-H2avg(i,k,j))/dzetaw(k))
   ENDDO
   ENDDO
   ENDDO
!
   DO j = j_start, j_end
   DO k = kts+1, ktf
   DO i = i_start, i_end
      H1avg(i,k,j)=0.5*(fzm(k)*(H1(i+1,k  ,j)+H1(i,k  ,j))+  &
                        fzp(k)*(H1(i+1,k-1,j)+H1(i,k-1,j)))
      H2avg(i,k,j)=0.5*(fzm(k)*(H2(i,k  ,j+1)+H2(i,k  ,j))+  &
                        fzp(k)*(H2(i,k-1,j+1)+H2(i,k-1,j)))
      zxavg(i,k,j)=fzm(k)*zeta_x(i,k,j)+fzp(k)*zeta_x(i,k-1,j)
      zyavg(i,k,j)=fzm(k)*zeta_y(i,k,j)+fzp(k)*zeta_y(i,k-1,j)

! H1avg(i,k,j)=zeta_x*H1avg
! H2avg(i,k,j)=zeta_y*H2avg

      H1avg(i,k,j)=H1avg(i,k,j)*zxavg(i,k,j)
      H2avg(i,k,j)=H2avg(i,k,j)*zyavg(i,k,j)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO i = i_start, i_end
      H1avg(i,kts  ,j)=0.
      H1avg(i,ktf+1,j)=0.
      H2avg(i,kts  ,j)=0.
      H2avg(i,ktf+1,j)=0.
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end

      mrdx=msft(i,j)*rdx
      mrdy=msft(i,j)*rdy

      tendency(i,k,j)=tendency(i,k,j)-                          &
           (mrdx*0.5*((rr(i+1,k,j)+rr(i,k,j))*H1(i+1,k,j)-      &
                      (rr(i-1,k,j)+rr(i,k,j))*H1(i  ,k,j))+     &
            mrdy*0.5*((rr(i,k,j+1)+rr(i,k,j))*H2(i,k,j+1)-      &
                      (rr(i,k,j-1)+rr(i,k,j))*H2(i,k,j  ))-     &
            msft(i,j)*(H1avg(i,k+1,j)-H1avg(i,k,j)+             &
                       H2avg(i,k+1,j)-H2avg(i,k,j)              &
                                )/dzetaw(k)		        &
           )
   ENDDO
   ENDDO
   ENDDO
           
   IF ( doing_tke ) THEN
      DO j = j_start, j_end
      DO k = kts,ktf
      DO i = i_start, i_end
          tendency(i,k,j)=tmptendf(i,k,j)+2.* &
                          (tendency(i,k,j)-tmptendf(i,k,j))
      ENDDO
      ENDDO
      ENDDO
   ENDIF

END SUBROUTINE horizontal_diffusion_s

!============================================================================
SUBROUTINE vertical_diffusion_2   (ru_tendf, rv_tendf, rw_tendf, tke_tendf, &
                                   moist_tendf, n_moist,                    &
                                   scalar_tendf, n_scalar, th_mix, qv_mix,  &
                                   thp,u_base,v_base,qv_base,rr,tke,        &
                                   config_flags,defor13,defor23,defor33,div,&
                                   moist, scalar, xkmv, xkhv,km_opt,        &
                                   fzm, fzp, dzetaw, dzeta, zeta_z,         &
                                   ids, ide, jds, jde, kds, kde,            &
                                   ims, ime, jms, jme, kms, kme,            &
                                   its, ite, jts, jte, kts, kte             )
!----------------------------------------------------------------------------
   IMPLICIT NONE
!----------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   INTEGER ,        INTENT(IN   ) ::        n_moist, n_scalar, km_opt

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: dzetaw
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  dzeta
   REAL , DIMENSION( ims:ime , jms:jme ) ,  INTENT(IN   )      :: zeta_z

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: qv_base
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  u_base
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  v_base

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::ru_tendf,&
                                                                 rv_tendf,&
                                                                 rw_tendf,&
                                                                tke_tendf,&
                                                                   th_mix,&
                                                                   qv_mix

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_moist),                 &
          INTENT(INOUT) ::                                    moist_tendf

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_scalar) ,               &
          INTENT(INOUT) ::                                   scalar_tendf

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_moist),                 &
          INTENT(IN   ) ::                                          moist

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme, n_scalar) ,               &
          INTENT(IN   ) ::                                         scalar

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::defor13, &
                                                                 defor23, &
                                                                 defor33, &
                                                                     div, &
                                                                    xkmv, &
                                                                    xkhv, &
                                                                     thp, &
                                                                     tke, &
                                                                      rr
! LOVCAL VAR

   INTEGER :: im

!  REAL , DIMENSION( its:ite, kts:kte, jts:jte) :: xkhv
!--------------------------------------------------------------------------

      CALL vertical_diffusion_u_2(ru_tendf, config_flags, rr,             &
                                defor13, xkmv,                            &
                                dzetaw, zeta_z, fzm, fzp,                 &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )


      CALL vertical_diffusion_v_2(rv_tendf, config_flags, rr,             &
                                defor23, xkmv,                            &
                                dzetaw, zeta_z, fzm, fzp,                 &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )

      CALL vertical_diffusion_w_2(rw_tendf, config_flags, rr,             &
                                defor33, tke(ims,kms,jms),                &
                                div, xkmv,                                &
                                dzeta, zeta_z,                            &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )

! calculate khv

!  CALL    calculate_khv(xkmv, xkhv, config_flags,                        &
!                                ids, ide, jds, jde, kds, kde,            &
!                                ims, ime, jms, jme, kms, kme,            &
!                                its, ite, jts, jte, kts, kte             )

   CALL vertical_diffusion_s(th_mix, config_flags, thp, rr, xkhv,         &
                                dzeta, dzetaw, zeta_z, fzm, fzp,          &
                                .false.,                                  &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )

   If (km_opt .eq. 2) then
   CALL vertical_diffusion_s(tke_tendf(ims,kms,jms),                   &
                             config_flags, tke(ims,kms,jms),           &
                             rr, xkhv,                                 &
                             dzeta, dzetaw, zeta_z, fzm, fzp,          &
                             .true.,                                   &
                             ids, ide, jds, jde, kds, kde,             &
                             ims, ime, jms, jme, kms, kme,             &
                             its, ite, jts, jte, kts, kte              )
   endif
 
   IF (n_moist .ge. PARAM_FIRST_SCALAR) THEN 
     moist_loop: do im = PARAM_FIRST_SCALAR, n_moist
       IF (im .eq. P_QV) THEN
          CALL vertical_diffusion_s_qv(qv_mix, config_flags,              &
                                moist(ims,kms,jms,im), qv_base,           &
                                rr, xkhv,                                 &
                                dzeta, dzetaw, zeta_z, fzm, fzp,          &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
       ELSE
          CALL vertical_diffusion_s(moist_tendf(ims,kms,jms,im),          &
                                config_flags, moist(ims,kms,jms,im),      &
                                rr, xkhv,                                 &
                                dzeta, dzetaw, zeta_z, fzm, fzp,          &
                                .false.,                                  &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
       ENDIF

     ENDDO moist_loop

   ENDIF


   IF (n_scalar .ge. PARAM_FIRST_SCALAR) THEN 

     scalar_loop: do im = PARAM_FIRST_SCALAR, n_scalar

          CALL vertical_diffusion_s(scalar_tendf(ims,kms,jms,im),         &
                                config_flags, scalar(ims,kms,jms,im),     &
                                rr, xkhv,                                 &
                                dzeta, dzetaw, zeta_z, fzm, fzp,          &
                                .false.,                                  &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
     ENDDO scalar_loop

   ENDIF

END SUBROUTINE vertical_diffusion_2

!==========================================================================
SUBROUTINE vertical_diffusion_u_2(tendency, config_flags, rr,             &
                                defor13, xkmv,                            &
                                dzetaw, zeta_z, fzm, fzp,                 &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,         INTENT(IN   ) ::       ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      :: dzetaw
   REAL , DIMENSION( ims:ime , jms:jme ) ,  INTENT(IN   )      :: zeta_z

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ) ,                       &
                                            INTENT(IN   )      ::defor13, &
                                                                    xkmv, &
                                                                      rr
! LOCAL VARS

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end
   INTEGER :: is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)        :: titau3

   REAL , DIMENSION( its:ite, jts:jte)                         ::  zzavg
!--------------------------------------------------------------------------

   ktf=MIN(kte,kde-1)
  
   i_start = its
   i_end   = ite
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-1,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

! titau3 = titau13
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=0
   CALL cal_titau_13_31(config_flags,titau3,defor13,rr,xkmv,fzm,fzp,&
                        is_ext,ie_ext,js_ext,je_ext,                &
                        ids, ide, jds, jde, kds, kde,               &
                        ims, ime, jms, jme, kms, kme,               &
                        its, ite, jts, jte, kts, kte                )
   DO j = j_start, j_end
   DO i = i_start, i_end
      zzavg(i,j)=0.5*(zeta_z(i-1,j)+zeta_z(i,j))
   ENDDO
   ENDDO

! titau3 = titau13 * zeta_z

      DO j = j_start, j_end
      DO k = kts+1, ktf
      DO i = i_start, i_end
         titau3(i,k,j)=titau3(i,k,j)*zzavg(i,j)
      ENDDO
      ENDDO
      ENDDO
!
      DO j = j_start, j_end
      DO k=kts,ktf
      DO i = i_start, i_end
         tendency(i,k,j)=tendency(i,k,j)- &
                         (titau3(i,k+1,j)-titau3(i,k,j))/dzetaw(k)
      ENDDO
      ENDDO
      ENDDO

!----

END SUBROUTINE vertical_diffusion_u_2

!==========================================================================
SUBROUTINE vertical_diffusion_v_2(tendency, config_flags, rr,             &
                                defor23, xkmv,                            &
                                dzetaw, zeta_z, fzm, fzp,                 &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,         INTENT(IN   ) ::       ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      :: dzetaw
   REAL , DIMENSION( ims:ime , jms:jme ) ,  INTENT(IN   )      :: zeta_z

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ) ,                       &
                                            INTENT(IN   )      ::defor23, &
                                                                    xkmv, &
                                                                      rr
! LOCAL VARS

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end
   INTEGER :: is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)        :: titau3

   REAL , DIMENSION( its:ite, jts:jte)                         ::  zzavg
!--------------------------------------------------------------------------

   ktf=MIN(kte,kde-1)
  
   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = jte

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-1,jte)

! titau3 = titau23
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=0
   CALL cal_titau_23_32(config_flags,titau3,defor23,rr,xkmv,fzm,fzp,&
                        is_ext,ie_ext,js_ext,je_ext,                &
                        ids, ide, jds, jde, kds, kde,               &
                        ims, ime, jms, jme, kms, kme,               &
                        its, ite, jts, jte, kts, kte                )

   DO j = j_start, j_end
   DO i = i_start, i_end
      zzavg(i,j)=0.5*(zeta_z(i,j-1)+zeta_z(i,j))
   ENDDO
   ENDDO

! titau3 = titau23 * zeta_z

   DO j = j_start, j_end
   DO k = kts+1, ktf
   DO i = i_start, i_end
      titau3(i,k,j)=titau3(i,k,j)*zzavg(i,j)
   ENDDO
   ENDDO
   ENDDO
!
   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      tendency(i,k,j)=tendency(i,k,j)- &
                      (titau3(i,k+1,j)-titau3(i,k,j))/dzetaw(k)
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE vertical_diffusion_v_2

!==========================================================================
SUBROUTINE vertical_diffusion_w_2(tendency, config_flags, rr,             &
                                defor33, tke, div, xkmv,                  &
                                dzeta, zeta_z,                            &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,         INTENT(IN   ) ::       ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      ::  dzeta
   REAL , DIMENSION( ims:ime , jms:jme ) ,  INTENT(IN   )      :: zeta_z

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ) ,                       &
                                            INTENT(IN   )      ::defor33, &
                                                                     tke, &
                                                                     div, &
                                                                    xkmv, &
                                                                      rr
! LOCAL VARS

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end
   INTEGER :: is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)        :: titau3
!--------------------------------------------------------------------------

   ktf=MIN(kte,kde-1)
  
   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

! titau3 = titau33
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=0
   CALL cal_titau_11_22_33(config_flags,titau3,rr,tke,            &
                           xkmv,defor33,div,                      &
                           is_ext,ie_ext,js_ext,je_ext,           &
                           ids, ide, jds, jde, kds, kde,          &
                           ims, ime, jms, jme, kms, kme,          &
                           its, ite, jts, jte, kts, kte           )

   DO j = j_start, j_end
   DO k = kts+1, ktf
   DO i = i_start, i_end
      titau3(i,k,j)=titau3(i,k,j)*zeta_z(i,j)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO k = kts+1, ktf
   DO i = i_start, i_end
      tendency(i,k,j)=tendency(i,k,j)- &
                      (titau3(i,k,j)-titau3(i,k-1,j))/dzeta(k)
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE vertical_diffusion_w_2

!==========================================================================
SUBROUTINE vertical_diffusion_s(tendency, config_flags, var, rr, xkhv,    &
                                dzeta, dzetaw, zeta_z, fzm, fzp,          &
                                doing_tke,                                &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,         INTENT(IN   ) ::       ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   LOGICAL,         INTENT(IN   ) ::        doing_tke

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      ::  dzeta
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      :: dzetaw
   REAL , DIMENSION( ims:ime , jms:jme ) ,  INTENT(IN   )      :: zeta_z

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ) , INTENT(IN) ::   xkhv

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ) ,                       &
                                            INTENT(IN   )      ::    var, &
                                                                      rr
! LOCAL VARS

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end

   REAL , DIMENSION( its:ite, kts:kte, jts:jte)            ::        H3, &
                                                                 xkxavg, &
                                                                  rravg

   REAL , DIMENSION( its:ite, kts:kte, jts:jte)            ::  tmptendf
!--------------------------------------------------------------------------

   ktf=MIN(kte,kde-1)
  
   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

   IF (doing_tke) THEN
      DO j = j_start, j_end
      DO k = kts,ktf
      DO i = i_start, i_end
         tmptendf(i,k,j)=tendency(i,k,j)
      ENDDO
      ENDDO
      ENDDO
   ENDIF

! H3

   DO j = j_start, j_end
   DO k = kts+1,ktf
   DO i = i_start, i_end
      xkxavg(i,k,j)=fzm(k)*xkhv(i,k,j)+fzp(k)*xkhv(i,k-1,j)
      H3(i,k,j)=-xkxavg(i,k,j)*zeta_z(i,j)* &
                 (var(i,k,j)-var(i,k-1,j))/dzeta(k)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO i = i_start, i_end
      H3(i,kts,j)=0.
      H3(i,ktf+1,j)=0.
   ENDDO
   ENDDO

! H3 = rr * zeta_z * H3

   DO j = j_start, j_end
   DO k = kts+1,ktf
   DO i = i_start, i_end
      rravg(i,k,j)=fzm(k)*rr(i,k,j)+fzp(k)*rr(i,k-1,j)
      H3(i,k,j)=rravg(i,k,j)*zeta_z(i,j)*H3(i,k,j)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      tendency(i,k,j)=tendency(i,k,j)- &
                      (H3(i,k+1,j)-H3(i,k,j))/dzetaw(k)
   ENDDO
   ENDDO
   ENDDO

   IF (doing_tke) THEN
      DO j = j_start, j_end
      DO k = kts,ktf
      DO i = i_start, i_end
          tendency(i,k,j)=tmptendf(i,k,j)+2.* &
                          (tendency(i,k,j)-tmptendf(i,k,j))
      ENDDO
      ENDDO
      ENDDO
   ENDIF

END SUBROUTINE vertical_diffusion_s

!==========================================================================
SUBROUTINE vertical_diffusion_s_qv(tendency, config_flags, var,           &
                                var_base,rr, xkhv,                        &
                                dzeta, dzetaw, zeta_z, fzm, fzp,          &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                its, ite, jts, jte, kts, kte              )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,         INTENT(IN   ) ::       ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      ::  dzeta
   REAL , DIMENSION( kms:kme ) ,            INTENT(IN   )      :: dzetaw
   REAL , DIMENSION( ims:ime , jms:jme ) ,  INTENT(IN   )      :: zeta_z

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::var_base

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ) , INTENT(IN) ::   xkhv

   REAL , DIMENSION( ims:ime , kms:kme, jms:jme ) ,                       &
                                            INTENT(IN   )      ::    var, &
                                                                      rr
! LOCAL VARS

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end

   REAL , DIMENSION( its:ite, kts:kte+1, jts:jte)          ::        H3, &
                                                                 xkxavg, &
                                                                  rravg
!--------------------------------------------------------------------------

   ktf=MIN(kte,kde-1)
  
   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

! H3

   DO j = j_start, j_end
   DO k = kts+1,ktf
   DO i = i_start, i_end
      xkxavg(i,k,j)=fzm(k)*xkhv(i,k,j)+fzp(k)*xkhv(i,k-1,j)
      H3(i,k,j)=-xkxavg(i,k,j)*zeta_z(i,j)* &
                 (var(i,k  ,j)-var_base(k  )- &
                  var(i,k-1,j)+var_base(k-1))/dzeta(k)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO i = i_start, i_end
      H3(i,kts,j)=0.
      H3(i,ktf+1,j)=0.
   ENDDO
   ENDDO

! H3 = rr * zeta_z * H3

   DO j = j_start, j_end
   DO k = kts+1,ktf
   DO i = i_start, i_end
      rravg(i,k,j)=fzm(k)*rr(i,k,j)+fzp(k)*rr(i,k-1,j)
      H3(i,k,j)=rravg(i,k,j)*zeta_z(i,j)*H3(i,k,j)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      tendency(i,k,j)=tendency(i,k,j)- &
                      (H3(i,k+1,j)-H3(i,k,j))/dzetaw(k)
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE vertical_diffusion_s_qv
!==========================================================================
SUBROUTINE calculate_khh(xkmh, xkhh, config_flags,                        &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,         INTENT(IN   ) ::       ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1),                  &
                                                 INTENT(OUT  ) ::   xkhh

   REAL , DIMENSION( ims:ime ,kms:kme, jms:jme), INTENT(IN   ) ::   xkmh

!LOCAL VAR

   INTEGER :: i, j, k, ktf, i_start, i_end, j_start, j_end

   REAL , DIMENSION( its-1:ite+1 ,kts:kte, jts-1:jte+1)        ::   pr
!--------------------------------------------------------------------------

   ktf=MIN(kte,kde-1)

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

   DO j = j_start-1, j_end+1
   DO k = kts,ktf
   DO i = i_start-1, i_end+1
      pr(i,k,j)=3.
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start-1, j_end+1
   DO k = kts,ktf
   DO i = i_start-1, i_end+1
      xkhh(i,k,j)=xkmh(i,k,j)*pr(i,k,j)
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE calculate_khh

!==========================================================================
SUBROUTINE calculate_khv(xkmv, xkhv, config_flags,                        &
                                 ids, ide, jds, jde, kds, kde,            &
                                 ims, ime, jms, jme, kms, kme,            &
                                 its, ite, jts, jte, kts, kte             )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,         INTENT(IN   ) ::       ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( its:ite, kts:kte, jts:jte), INTENT(OUT  ) ::   xkhv

   REAL , DIMENSION( ims:ime ,kms:kme, jms:jme), INTENT(IN   ) ::   xkmv

!LOCAL VAR

   INTEGER :: i, j, k, ktf, i_start, i_end, j_start, j_end

   REAL , DIMENSION( its-1:ite+1,kts:kte,jts-1:jte+1)          ::   pr
!--------------------------------------------------------------------------
   ktf=MIN(kte,kde-1)

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

   
   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      pr(i,k,j)=3.
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      xkhv(i,k,j)=xkmv(i,k,j)*pr(i,k,j)
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE calculate_khv

!==========================================================================
SUBROUTINE cal_titau_11_22_33(config_flags,titau,rr,tke,xkx,defor,div,    &
                              is_ext,ie_ext,js_ext,je_ext,                &
                              ids, ide, jds, jde, kds, kde,               &
                              ims, ime, jms, jme, kms, kme,               &
                              its, ite, jts, jte, kts, kte                )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte
   INTEGER ,        INTENT(IN   ) ::        is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1),                  &
          INTENT(INOUT)                                        ::  titau 

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::  defor, &
                                                                     xkx, &
                                                                     div, &   
                                                                     tke, &
                                                                      rr   
! LOCAL VAR

   INTEGER :: i, j, k, ktf
   INTEGER :: i_start, i_end, j_start, j_end
   REAL    :: x2r3
!--------------------------------------------------------------------------
   x2r3 = 2./3.

   ktf=MIN(kte,kde-1)

   i_start = its
   i_end   = ite
   j_start = jts
   j_end   = jte

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-1,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-1,jte)

   i_start = i_start-is_ext
   i_end   = i_end  +ie_ext   
   j_start = j_start-js_ext
   j_end   = j_end  +je_ext   

   IF ( config_flags%km_opt .eq. 2) THEN
      DO j = j_start,j_end
      DO k = kts,ktf
      DO i = i_start,i_end
         titau(i,k,j)=rr(i,k,j)*(x2r3*max(tke(i,k,j),0.0)-xkx(i,k,j)* &
                                 (defor(i,k,j)-x2r3*div(i,k,j)))
      ENDDO
      ENDDO
      ENDDO
   ELSE
      DO j = j_start,j_end
      DO k = kts,ktf
      DO i = i_start,i_end
         titau(i,k,j)=-rr(i,k,j)*xkx(i,k,j)*defor(i,k,j)
      ENDDO
      ENDDO
      ENDDO
   ENDIF

END SUBROUTINE cal_titau_11_22_33

!==========================================================================
SUBROUTINE cal_titau_12_21(config_flags,titau,rr,xkx,defor,               &
                           is_ext,ie_ext,js_ext,je_ext,                   &
                           ids, ide, jds, jde, kds, kde,                  &
                           ims, ime, jms, jme, kms, kme,                  &
                           its, ite, jts, jte, kts, kte                   )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte
   INTEGER ,        INTENT(IN   ) ::        is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1),                  &
          INTENT(INOUT)                                        ::  titau 
 
   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::  defor, &
                                                                     xkx, &
                                                                      rr   
! LOCAL VAR

   INTEGER :: i, j, k, ktf
   INTEGER :: i_start, i_end, j_start, j_end
   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)         ::  rravg, &
                                                                   xkxavg 
!--------------------------------------------------------------------------
   ktf=MIN(kte,kde-1)

! needs one more point in the x and y directions

    i_start = its
    i_end   = ite
    j_start = jts
    j_end   = jte

    IF ( config_flags%open_xs .or. config_flags%specified .or. &
         config_flags%nested) i_start = MAX(ids+1,its)
    IF ( config_flags%open_xe .or. config_flags%specified .or. &
         config_flags%nested) i_end   = MIN(ide-1,ite)
    IF ( config_flags%open_ys .or. config_flags%specified .or. &
         config_flags%nested) j_start = MAX(jds+1,jts)
    IF ( config_flags%open_ye .or. config_flags%specified .or. &
         config_flags%nested) j_end   = MIN(jde-1,jte)

   i_start = i_start-is_ext
   i_end   = i_end  +ie_ext   
   j_start = j_start-js_ext
   j_end   = j_end  +je_ext   

   DO j = j_start,j_end
   DO k = kts,ktf
   DO i = i_start,i_end
      rravg(i,k,j) =0.25*(rr(i-1,k,j  )+rr(i,k,j  )+   &
                          rr(i-1,k,j-1)+rr(i,k,j-1))
      xkxavg(i,k,j)=0.25*(xkx(i-1,k,j  )+xkx(i,k,j  )+ &
                          xkx(i-1,k,j-1)+xkx(i,k,j-1))
   ENDDO
   ENDDO
   ENDDO

! titau12 or titau21

   DO j = j_start,j_end
   DO k = kts,ktf
   DO i = i_start,i_end
      titau(i,k,j)=-rravg(i,k,j)*xkxavg(i,k,j)*defor(i,k,j)
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE cal_titau_12_21

!==========================================================================
SUBROUTINE cal_titau_13_31(config_flags,titau,defor,rr,xkx,fzm,fzp,       &
                           is_ext,ie_ext,js_ext,je_ext,                   &
                           ids, ide, jds, jde, kds, kde,                  &
                           ims, ime, jms, jme, kms, kme,                  &
                           its, ite, jts, jte, kts, kte                   )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte
   INTEGER ,        INTENT(IN   ) ::        is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1),                  &
          INTENT(INOUT)                                        ::  titau 
 
   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::  defor, &
                                                                     xkx, &
                                                                      rr   
! LOCAL VAR

   INTEGER :: i, j, k, ktf
   INTEGER :: i_start, i_end, j_start, j_end
   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)        ::  rravg, &
                                                                   xkxavg 
!--------------------------------------------------------------------------
   ktf=MIN(kte,kde-1)

! need ide-1 and jde-1 for averaging to p point

   i_start = its
   i_end   = ite
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-1,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

   i_start = i_start-is_ext
   i_end   = i_end  +ie_ext   
   j_start = j_start-js_ext
   j_end   = j_end  +je_ext   

   DO j = j_start,j_end
   DO k = kts+1,ktf
   DO i = i_start,i_end
      rravg(i,k,j) =0.5*(fzm(k)*(rr(i,k  ,j)+rr(i-1,k  ,j))+   &
                         fzp(k)*(rr(i,k-1,j)+rr(i-1,k-1,j)))
      xkxavg(i,k,j)=0.5*(fzm(k)*(xkx(i,k  ,j)+xkx(i-1,k  ,j))+ &
                         fzp(k)*(xkx(i,k-1,j)+xkx(i-1,k-1,j)))
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start,j_end
   DO k = kts+1,ktf
   DO i = i_start,i_end
      titau(i,k,j)=-rravg(i,k,j)*xkxavg(i,k,j)*defor(i,k,j)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start,j_end
   DO i = i_start,i_end
      titau(i,kts,j)=0.
      titau(i,ktf+1,j)=0.
   ENDDO
   ENDDO

END SUBROUTINE cal_titau_13_31

!==========================================================================
SUBROUTINE cal_titau_23_32(config_flags,titau,defor,rr,xkx,fzm,fzp,       &
                           is_ext,ie_ext,js_ext,je_ext,                   &
                           ids, ide, jds, jde, kds, kde,                  &
                           ims, ime, jms, jme, kms, kme,                  &
                           its, ite, jts, jte, kts, kte                   )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte
   INTEGER ,        INTENT(IN   ) ::        is_ext,ie_ext,js_ext,je_ext  

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1),                  &
          INTENT(INOUT)                                        ::  titau 
 
   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::  defor, &
                                                                     xkx, &
                                                                      rr   
! LOCAL VAR

   INTEGER :: i, j, k, ktf
   INTEGER :: i_start, i_end, j_start, j_end
   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)        ::  rravg, &
                                                                   xkxavg 
!--------------------------------------------------------------------------
   ktf=MIN(kte,kde-1)

! need ide-1 and jde-1 for averaging to p point

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = jte

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-1,jte)

   i_start = i_start-is_ext
   i_end   = i_end  +ie_ext   
   j_start = j_start-js_ext
   j_end   = j_end  +je_ext   

   DO j = j_start,j_end
   DO k = kts+1, ktf
   DO i = i_start,i_end
      rravg(i,k,j) =0.5*(fzm(k)*(rr(i,k  ,j)+rr(i,k  ,j-1))+     &
                         fzp(k)*(rr(i,k-1,j)+rr(i,k-1,j-1)))
      xkxavg(i,k,j)=0.5*(fzm(k)*(xkx(i,k  ,j)+xkx(i,k  ,j-1))+   &
                         fzp(k)*(xkx(i,k-1,j)+xkx(i,k-1,j-1)))
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start,j_end
   DO k = kts+1, ktf
   DO i = i_start,i_end
      titau(i,k,j)=-rravg(i,k,j)*xkxavg(i,k,j)*defor(i,k,j)
   ENDDO
   ENDDO
   ENDDO

   DO j = j_start,j_end
   DO i = i_start,i_end
      titau(i,kts,j)=0.
      titau(i,ktf+1,j)=0.
   ENDDO
   ENDDO

END SUBROUTINE cal_titau_23_32

!==========================================================================
SUBROUTINE phy_bc (config_flags,div,defor11,defor22,defor33,              &
                   defor12,defor13,defor23,xkmh,xkmhd,xkmv,xkhh,xkhv,tke, &
                   RUBLTEN, RVBLTEN,                                      &
                   ids, ide, jds, jde, kds, kde,                          &
                   ims, ime, jms, jme, kms, kme,                          &
                   ips, ipe, jps, jpe, kps, kpe,                          &
                   its, ite, jts, jte, kts, kte                           )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            ips, ipe, jps, jpe, kps, kpe, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::RUBLTEN, &
                                                                 RVBLTEN, &
                                                                 defor11, &
                                                                 defor22, &
                                                                 defor33, &
                                                                 defor12, &
                                                                 defor13, &
                                                                 defor23, &
                                                                    xkmh, &
                                                                   xkmhd, &
                                                                    xkmv, &
                                                                    xkhh, &
                                                                    xkhv, &
                                                                     tke, &
                                                                     div

   IF(config_flags%bl_pbl_physics .GT. 0) THEN

        CALL set_physical_bc3d( RUBLTEN , 't', config_flags,              &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

        CALL set_physical_bc3d( RVBLTEN , 't', config_flags,              &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   ENDIF

   IF(config_flags%diff_opt .eq. 2) THEN

   CALL set_physical_bc3d( xkmh    , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( xkmhd   , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( xkmv    , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( xkhh    , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( xkhv    , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( tke     , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( div     , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( defor11 , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( defor22 , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( defor33 , 't', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( defor12 , 'd', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( defor13 , 'e', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   CALL set_physical_bc3d( defor23 , 'f', config_flags,                   &
                                ids, ide, jds, jde, kds, kde,             &
                                ims, ime, jms, jme, kms, kme,             &
                                ips, ipe, jps, jpe, kps, kpe,             &
                                its, ite, jts, jte, kts, kte              )

   ENDIF

END SUBROUTINE phy_bc 


!==========================================================================
SUBROUTINE tke_rhs        (tendency,BN2,config_flags,                     &
                           defor11,defor22,defor33,                       &
                           defor12,defor13,defor23,u,v,w,div,tke,rr,      &
                           theta,p,p8w,t8w,z,fzm,fzp,cf1,cf2,cf3,         &
                           msft,xkmh,xkmv,xkhv,rdx,rdy,dx,dy,             &
                           zeta_x,zeta_y,zeta_z,dzetaw,dzeta,cr_len,      &
                           ids, ide, jds, jde, kds, kde,                  &
                           ims, ime, jms, jme, kms, kme,                  &
                           its, ite, jts, jte, kts, kte                   )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , INTENT(IN   )           ::        cf1, cf2, cf3         
   REAL , INTENT(IN   )           ::        rdx, rdy, dx, dy, cr_len

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: dzetaw
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  dzeta

   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msft

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::defor11, &
                                                                 defor22, &
                                                                 defor33, &
                                                                 defor12, &
                                                                 defor13, &
                                                                 defor23, &
                                                                     div, &
                                                                     BN2, &
                                                                     tke, &
                                                                    xkmh, &
                                                                    xkmv, &
                                                                    xkhv, &
                                                                  zeta_x, &
                                                                  zeta_y, &
                                                                       u, &
                                                                       v, &
                                                                       w, &
                                                                   theta, &
                                                                       p, &
                                                                     p8w, &
                                                                     t8w, &
                                                                       z, &
                                                                      rr

   REAL , DIMENSION( ims:ime, jms:jme), INTENT(IN   )          :: zeta_z
!--------------------------------------------------------------------------

! call shear stress production term

     CALL tke_shear(tendency,config_flags,defor11,defor22,defor33,        &
                        defor12,defor13,defor23,u,v,w,div,tke,rr,         &
                        fzm,fzp,cf1,cf2,cf3,msft,xkmh,xkmv,rdx,rdy,       &
                        zeta_x,zeta_y,zeta_z,dzetaw,dzeta,                &
                        ids, ide, jds, jde, kds, kde,                     &
                        ims, ime, jms, jme, kms, kme,                     &
                        its, ite, jts, jte, kts, kte                      )

     CALL tke_dissip(tendency,config_flags,rr,tke,theta,p8w,t8w,z,        &
                        zeta_z,dx,dy,dzeta,dzetaw,cr_len,                 &
                        ids, ide, jds, jde, kds, kde,                     &
                        ims, ime, jms, jme, kms, kme,                     &
                         its, ite, jts, jte, kts, kte                     )

     CALL  tke_buoyancy(tendency,config_flags,rr,xkhv,BN2,                &
                        ids, ide, jds, jde, kds, kde,                     &
                        ims, ime, jms, jme, kms, kme,                     &
                        its, ite, jts, jte, kts, kte                      )

END SUBROUTINE tke_rhs

!==========================================================================
SUBROUTINE tke_buoyancy(tendency,config_flags,rr,xkhv,BN2,                &
                        ids, ide, jds, jde, kds, kde,                     &
                        ims, ime, jms, jme, kms, kme,                     &
                        its, ite, jts, jte, kts, kte                      )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::     rr, &
                                                                    xkhv, &
                                                                     BN2   
! Local VAR

   INTEGER :: i, j, k, ktf

   INTEGER :: i_start, i_end, j_start, j_end

!-------------------------------------------------------------------------
   ktf=MIN(kte,kde-1)

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)
!
   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      tendency(i,k,j)= tendency(i,k,j) - &
                       rr(i,k,j)*xkhv(i,k,j)*BN2(i,k,j)
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE tke_buoyancy

!==========================================================================
SUBROUTINE tke_dissip     (tendency,config_flags,rr,tke,theta,p8w,t8w,z,  &
                           zeta_z,dx,dy,dzeta,dzetaw,cr_len,              &
                           ids, ide, jds, jde, kds, kde,                  &
                           ims, ime, jms, jme, kms, kme,                  &
                           its, ite, jts, jte, kts, kte                   )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL ,           INTENT(IN   ) ::        dx, dy, cr_len

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: dzetaw
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  dzeta
   REAL , DIMENSION( ims:ime , jms:jme ) ,  INTENT(IN   )      :: zeta_z

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) ::tendency

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::     rr, &
                                                                     tke, &
                                                                   theta, &
                                                                     p8w, &
                                                                     t8w, &
                                                                       z
! Local VAR

   REAL , DIMENSION( its:ite, kts:kte, jts:jte)            ::  dthrdzeta

   REAL , DIMENSION( its:ite )                             ::     sumtke, &
                                                                 sumtkez

   INTEGER :: i, j, k, ktf
   INTEGER :: i_start, i_end, j_start, j_end
   REAL    :: disp_len, deltas, coefc, tmpdz, len_s, thetasfc,            &
              thetatop, dissip_l, len_0, tketmp
!--------------------------------------------------------------------------
   ktf=MIN(kte,kde-1)

   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)


   IF (dx .gt. cr_len) THEN

      DO j = j_start, j_end
         DO i = i_start, i_end
            sumtke(i)=0.
            sumtkez(i)=0.
         ENDDO
         DO k = kts, ktf
         DO i = i_start, i_end
            tketmp=max(tke(i,k,j),0.)
            sumtke(i)=sumtke(i)+sqrt(tketmp)*dzetaw(k)
            sumtkez(i)=sumtkez(i)+sumtke(i)*z(i,k,j)
            IF (abs(sumtke(i)) .gt. 0.01) THEN
               len_0=0.2*sumtkez(i)/sumtke(i)
            ELSE
               len_0=80.
            ENDIF
            len_0=min(80.,len_0)

            dissip_l=KARMAN*z(i,k,j)/(1.+KARMAN*z(i,k,j)/len_0)
            tendency(i,k,j)= tendency(i,k,j) - &
                             rr(i,k,j)*2.*sqrt(2.)/15.* &
                             tketmp**1.5/dissip_l
         ENDDO
         ENDDO
      ENDDO

   ELSE

      DO j = j_start, j_end
      DO k = kts+1, ktf-1
      DO i = i_start, i_end
         tmpdz=dzeta(k+1)+dzeta(k)
         dthrdzeta(i,k,j)=(theta(i,k+1,j)-theta(i,k-1,j))/tmpdz
      ENDDO
      ENDDO
      ENDDO

      k=kts
      DO j = j_start, j_end
      DO i = i_start, i_end
         tmpdz=dzeta(k+1)+0.5*dzetaw(k)
         thetasfc=T8w(i,kts,j)/(p8w(i,k,j)/p1000mb)**(R_d/Cp)
         dthrdzeta(i,k,j)=(theta(i,k+1,j)-thetasfc)/tmpdz
      ENDDO
      ENDDO

      k=ktf
      DO j = j_start, j_end
      DO i = i_start, i_end
         tmpdz=dzeta(k)+0.5*dzetaw(k)
         thetatop=T8w(i,kde,j)/(p8w(i,kde,j)/p1000mb)**(R_d/Cp)
         dthrdzeta(i,k,j)=(thetatop-theta(i,k-1,j))/tmpdz
      ENDDO
      ENDDO

      DO j = j_start, j_end
      DO k = kts, ktf
      DO i = i_start, i_end
         deltas=(dx*dy*dzetaw(k)/zeta_z(i,j))**0.33333333
         dissip_l=deltas
         tketmp=max(tke(i,k,j),0.0)
         IF (dthrdzeta(i,k,j) .gt. 0.) THEN 
            len_s=max(0.76*sqrt(tketmp)/ &
                      abs(g/theta(i,k,j)*zeta_z(i,j)*dthrdzeta(i,k,j)), 1.0E-5)
            dissip_l=min(dissip_l,len_s)
         ENDIF
         coefc=0.19+0.74*dissip_l/deltas
         tendency(i,k,j)= tendency(i,k,j) - &
                          rr(i,k,j)*coefc*tketmp**1.5/dissip_l
      ENDDO
      ENDDO
      ENDDO

   ENDIF

END SUBROUTINE tke_dissip

!==========================================================================
SUBROUTINE tke_shear      (tendency,config_flags,defor11,defor22,defor33, &
                           defor12,defor13,defor23,u,v,w,div,tke,rr,      &
                           fzm,fzp,cf1,cf2,cf3,msft,xkmh,xkmv,rdx,rdy,    &
                           zeta_x,zeta_y,zeta_z,dzetaw,dzeta,             &
                           ids, ide, jds, jde, kds, kde,                  &
                           ims, ime, jms, jme, kms, kme,                  &
                           its, ite, jts, jte, kts, kte                   )
!--------------------------------------------------------------------------
   IMPLICIT NONE
!--------------------------------------------------------------------------
   TYPE(grid_config_rec_type), INTENT(IN   ) :: config_flags

   INTEGER ,        INTENT(IN   ) ::        ids, ide, jds, jde, kds, kde, &
                                            ims, ime, jms, jme, kms, kme, &
                                            its, ite, jts, jte, kts, kte

   REAL , INTENT(IN   )           ::        cf1, cf2, cf3
   REAL , INTENT(IN   )           ::        rdx, rdy

   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzm
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::    fzp
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) :: dzetaw
   REAL , DIMENSION( kms:kme ) ,                 INTENT(IN   ) ::  dzeta

   REAL , DIMENSION( ims:ime, jms:jme) ,         INTENT(IN   ) ::   msft

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(INOUT) :: tendency

   REAL , DIMENSION( ims:ime, kms:kme, jms:jme), INTENT(IN   ) ::defor11, &
                                                                 defor22, &
                                                                 defor33, &
                                                                 defor12, &
                                                                 defor13, &
                                                                 defor23, &
                                                                     div, &
                                                                     tke, &
                                                                    xkmh, &
                                                                    xkmv, &
                                                                  zeta_x, &
                                                                  zeta_y, &
                                                                       u, &
                                                                       v, &
                                                                       w, &
                                                                      rr 

   REAL , DIMENSION( ims:ime, jms:jme), INTENT(IN   )          :: zeta_z

! Local VAR

   INTEGER :: i, j, k, ktf, ktes1, ktes2

   INTEGER :: i_start, i_end, j_start, j_end
   INTEGER :: is_ext,ie_ext,js_ext,je_ext

   REAL    :: mtau

   REAL , DIMENSION( its-1:ite+1, kts:kte, jts-1:jte+1)  ::         avg, &
                                                                  titau

   REAL , DIMENSION( its:ite, kts:kte, jts:jte)          ::     titau12, &
                                                                   tmp1
!-------------------------------------------------------------------------
   ktf=MIN(kte,kde-1)
   ktes1=kte-1
   ktes2=kte-2
  
   i_start = its
   i_end   = MIN(ite,ide-1)
   j_start = jts
   j_end   = MIN(jte,jde-1)

   IF ( config_flags%open_xs .or. config_flags%specified .or. &
        config_flags%nested) i_start = MAX(ids+1,its)
   IF ( config_flags%open_xe .or. config_flags%specified .or. &
        config_flags%nested) i_end   = MIN(ide-2,ite)
   IF ( config_flags%open_ys .or. config_flags%specified .or. &
        config_flags%nested) j_start = MAX(jds+1,jts)
   IF ( config_flags%open_ye .or. config_flags%specified .or. &
        config_flags%nested) j_end   = MIN(jde-2,jte)

!----------------
! avg = u at w point

   do j=j_start,j_end
   do k=kts+1, ktf
   do i=i_start,i_end
      avg(i,k,j)=0.5*(fzm(k)*(u(i,k  ,j)+u(i+1,k  ,j))+ &
                      fzp(k)*(u(i,k-1,j)+u(i+1,k-1,j)))
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do i=i_start,i_end
      avg(i,1,j)  =0.5*(cf1*u(i  ,1,j)+cf2*u(i  ,2,j)+cf3*u(i  ,3,j)+  &
                        cf1*u(i+1,1,j)+cf2*u(i+1,2,j)+cf3*u(i+1,3,j))
      avg(i,kte,j)=0.5*(u(i,ktes1,j)+(u(i,ktes1,j)-u(i,ktes2,j))       &
                                      *0.5*dzetaw(ktes1)/dzeta(ktes1)+ &
                        u(i+1,ktes1,j)+(u(i+1,ktes1,j)-u(i+1,ktes2,j)) &
                                      *0.5*dzetaw(ktes1)/dzeta(ktes1))
   enddo
   enddo

!  tmp1 = delta u at p point

   do j=j_start,j_end
   do k=kts, ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (avg(i,k+1,j)-avg(i,k,j))
   enddo
   enddo
   enddo

!----------------
! titau = titau11
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=0
   CALL cal_titau_11_22_33(config_flags,titau,rr,tke,             &
                           xkmh,defor11,div,                      &
                           is_ext,ie_ext,js_ext,je_ext,           &
                           ids, ide, jds, jde, kds, kde,          &
                           ims, ime, jms, jme, kms, kme,          &
                           its, ite, jts, jte, kts, kte           )

! update tendency with tau11 ( partial u / partial x)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      mtau=msft(i,j)*titau(i,k,j)
      tendency(i,k,j)= tendency(i,k,j) &
                      -mtau*(rdx*(u(i+1,k,j)-u(i,k,j))- &
                             tmp1(i,k,j)*zeta_x(i,k,j)/dzetaw(k))
   ENDDO
   ENDDO
   ENDDO

!----------------
! titau = titau12
   is_ext=0
   ie_ext=1
   js_ext=0
   je_ext=1
   CALL cal_titau_12_21(config_flags,titau,rr,xkmh,defor12, &
                        is_ext,ie_ext,js_ext,je_ext,        &
                        ids, ide, jds, jde, kds, kde,       &
                        ims, ime, jms, jme, kms, kme,       &
                        its, ite, jts, jte, kts, kte        )

! titau12 = titau12 at p point (keep for later use)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      titau12(i,k,j)=0.25*(titau(i  ,k,j)+titau(i  ,k,j+1)+ &
                           titau(i+1,k,j)+titau(i+1,k,j+1))
   ENDDO
   ENDDO
   ENDDO

! avg = u at v point

   DO j = j_start, j_end+1
   DO k = kts, ktf
   DO i = i_start, i_end
      avg(i,k,j)=0.25*(u(i,k,j  )+u(i+1,k,j  )+ &
                       u(i,k,j-1)+u(i+1,k,j-1))
   ENDDO
   ENDDO
   ENDDO

! update tendency with tau12 ( partial u / partial y)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      mtau=msft(i,j)*titau12(i,k,j)
      tendency(i,k,j)= tendency(i,k,j) &
                      -mtau*(rdy*(avg(i,k,j+1)-avg(i,k,j)) - &
                             tmp1(i,k,j)*zeta_y(i,k,j)/dzetaw(k))  
   ENDDO
   ENDDO
   ENDDO

!---------------
! avg = titau13
   is_ext=0
   ie_ext=1
   js_ext=0
   je_ext=0
   CALL cal_titau_13_31(config_flags,avg,defor13,rr,xkmv,fzm,fzp,   &
                        is_ext,ie_ext,js_ext,je_ext,                &
                        ids, ide, jds, jde, kds, kde,               &
                        ims, ime, jms, jme, kms, kme,               &
                        its, ite, jts, jte, kts, kte                )

! titau = titau 13 at p point

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      titau(i,k,j)=0.25*(avg(i  ,k+1,j)+avg(i  ,k,j)+ &
                         avg(i+1,k+1,j)+avg(i+1,k,j))
   ENDDO
   ENDDO
   ENDDO

! update tendency with tau13 ( partial u / partial z)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      tendency(i,k,j)= tendency(i,k,j) - &
                       titau(i,k,j)*zeta_z(i,j)*tmp1(i,k,j)/dzetaw(k)
   ENDDO
   ENDDO
   ENDDO

!-------------------------------------
! avg = v at w point

   do j=j_start,j_end
   do k=kts+1,ktf
   do i=i_start,i_end
      avg(i,k,j)=0.5*(fzm(k)*(v(i,k  ,j)+v(i,k  ,j+1))+ &
                      fzp(k)*(v(i,k-1,j)+v(i,k-1,j+1)))
   enddo
   enddo
   enddo

   do j=j_start,j_end
   do i=i_start,i_end
      avg(i,1,j)  =0.5*(cf1*v(i,1,j  )+cf2*v(i,2,j  )+cf3*v(i,3,j  )+ &
                        cf1*v(i,1,j+1)+cf2*v(i,2,j+1)+cf3*v(i,3,j+1))
      avg(i,kte,j)=0.5*(v(i,ktes1,j)+(v(i,ktes1,j)-v(i,ktes2,j))       &
                                      *0.5*dzetaw(ktes1)/dzeta(ktes1)+ &
                        v(i,ktes1,j+1)+(v(i,ktes1,j+1)-v(i,ktes2,j+1)) &
                                      *0.5*dzetaw(ktes1)/dzeta(ktes1))
   enddo
   enddo

!  tmp1 = delta v  at p point

   do j=j_start,j_end
   do k=kts, ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (avg(i,k+1,j)-avg(i,k,j))
   enddo
   enddo
   enddo

!-------------------
! avg = v at u point

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end+1
      avg(i,k,j)=0.25*(v(i  ,k,j)+v(i  ,k,j+1)+ &
                       v(i-1,k,j)+v(i-1,k,j+1))
   ENDDO
   ENDDO
   ENDDO

! update tendency with tau21 ( partial v / partial x)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      mtau=msft(i,j)*titau12(i,k,j)
      tendency(i,k,j)= tendency(i,k,j) &
                      -mtau*(rdx*(avg(i+1,k,j)-avg(i,k,j)) - &
                             zeta_x(i,k,j)*tmp1(i,k,j)/dzetaw(k))
   ENDDO
   ENDDO
   ENDDO

!-------------------------------------
! titau = titau22
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=0
   CALL cal_titau_11_22_33(config_flags,titau,rr,tke,        &
                           xkmh,defor22,div,                 &
                           is_ext,ie_ext,js_ext,je_ext,      &
                           ids, ide, jds, jde, kds, kde,     &
                           ims, ime, jms, jme, kms, kme,     &
                           its, ite, jts, jte, kts, kte      )

! update tendency with tau 22 ( partial v / partial y)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      mtau=msft(i,j)*titau(i,k,j)
      tendency(i,k,j)= tendency(i,k,j) &
                      -mtau*(rdy*(v(i,k,j+1)-v(i,k,j)) - &
                             zeta_y(i,k,j)*tmp1(i,k,j)/dzetaw(k))
   ENDDO
   ENDDO
   ENDDO

!-------------------------------------
! avg = titau23
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=1
   CALL cal_titau_23_32(config_flags,avg,defor23,rr,xkmv,fzm,fzp, &
                        is_ext,ie_ext,js_ext,je_ext,              &
                        ids, ide, jds, jde, kds, kde,             &
                        ims, ime, jms, jme, kms, kme,             &
                        its, ite, jts, jte, kts, kte              )

! titau = titau 23 at p point

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      titau(i,k,j)=0.25*(avg(i,k+1,j  )+avg(i,k,j  )+ &
                         avg(i,k+1,j+1)+avg(i,k,j+1))
   ENDDO
   ENDDO
   ENDDO

! update tendency with tau23 ( partial v / partial z)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      tendency(i,k,j)= tendency(i,k,j) - &
                       titau(i,k,j)*zeta_z(i,j)*tmp1(i,k,j)/dzetaw(k)
   ENDDO
   ENDDO
   ENDDO

!-------------------------------------
!  tmp1 = partial w over partial zeta at p point

   do j=j_start,j_end
   do k=kts,ktf
   do i=i_start,i_end
      tmp1(i,k,j)= (w(i,k+1,j)-w(i,k,j))
   enddo
   enddo
   enddo

!-------------------------------------
! avg = titau31
   is_ext=0
   ie_ext=1
   js_ext=0
   je_ext=0
   CALL cal_titau_13_31(config_flags,avg,defor13,rr,xkmh,fzm,fzp,   &
                        is_ext,ie_ext,js_ext,je_ext,                &
                        ids, ide, jds, jde, kds, kde,               &
                        ims, ime, jms, jme, kms, kme,               &
                        its, ite, jts, jte, kts, kte                )

! titau = titau 31 at p point

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      titau(i,k,j)=0.25*(avg(i  ,k+1,j)+avg(i  ,k,j)+ &
                         avg(i+1,k+1,j)+avg(i+1,k,j))
   ENDDO
   ENDDO
   ENDDO

! avg = w at u point

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end+1
      avg(i,k,j)=0.25*(w(i  ,k,j)+w(i  ,k+1,j)+ &
                       w(i-1,k,j)+w(i-1,k+1,j))
   ENDDO
   ENDDO
   ENDDO

! update tendency with tau31 ( partial w / partial x)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      mtau=msft(i,j)*titau(i,k,j)
      tendency(i,k,j)= tendency(i,k,j) &
                      -mtau*(rdx*(avg(i+1,k,j)-avg(i,k,j)) - &
                             zeta_x(i,k,j)*tmp1(i,k,j)/dzetaw(k))
   ENDDO
   ENDDO
   ENDDO

!-------------------------------------
! avg = titau32
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=1
   CALL cal_titau_23_32(config_flags,avg,defor23,rr,xkmh,fzm,fzp,  &
                        is_ext,ie_ext,js_ext,je_ext,               &
                        ids, ide, jds, jde, kds, kde,              &
                        ims, ime, jms, jme, kms, kme,              &
                        its, ite, jts, jte, kts, kte               )

! titau = titau 32 at p point

   DO j = j_start, j_end
   DO k = kts,ktf
   DO i = i_start, i_end
      titau(i,k,j)=0.25*(avg(i,k+1,j  )+avg(i,k,j  )+ &
                         avg(i,k+1,j+1)+avg(i,k,j+1))
   ENDDO
   ENDDO
   ENDDO

! avg  = w at v point

   DO j = j_start, j_end+1
   DO k = kts, ktf
   DO i = i_start, i_end
      avg(i,k,j)=0.25*(w(i,k,j  )+w(i,k+1,j  )+ &
                       w(i,k,j-1)+w(i,k+1,j-1))
   ENDDO
   ENDDO
   ENDDO

! update tendency with tau32 ( partial w / partial y)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      mtau=msft(i,j)*titau(i,k,j)
      tendency(i,k,j)= tendency(i,k,j) &
                      -mtau*(rdy*(avg(i,k,j+1)-avg(i,k,j)) - &
                             zeta_y(i,k,j)*tmp1(i,k,j)/dzetaw(k))
   ENDDO
   ENDDO
   ENDDO

!-------------------------------------
! titau = titau33
   is_ext=0
   ie_ext=0
   js_ext=0
   je_ext=0
   CALL cal_titau_11_22_33(config_flags,titau,rr,tke,             &
                           xkmv,defor33,div,                      &
                           is_ext,ie_ext,js_ext,je_ext,           &
                           ids, ide, jds, jde, kds, kde,          &
                           ims, ime, jms, jme, kms, kme,          &
                           its, ite, jts, jte, kts, kte           )

! update tendency with tau33 ( partial w / partial z)

   DO j = j_start, j_end
   DO k = kts, ktf
   DO i = i_start, i_end
      tendency(i,k,j)= tendency(i,k,j) - &
                       titau(i,k,j)*zeta_z(i,j)*tmp1(i,k,j)/dzetaw(k)
   ENDDO
   ENDDO
   ENDDO

END SUBROUTINE tke_shear
!-------------------------------------------------------------------------

END MODULE module_diffusion
